<?php

require_code('wiki');

list($id, $_chain) = get_param_wiki_chain('id');

$chain = explode('/', $_chain);

$parent_id = null;
$parent_title = null;
$previous_sibling_id = null;
$previous_sibling_title = null;
$previous_sibling_chain = null;
$next_sibling_id = null;
$next_sibling_title = null;
$next_sibling_chain = null;

array_pop($chain); // Just repeats $id

if (!empty($chain)) {
    $part = $chain[count($chain) - 1];
    if (is_numeric($part)) {
        $parent_id = intval($part);
    } else {
        $url_moniker_where = array('m_resource_page' => 'wiki', 'm_moniker' => $part);
        $_id = $GLOBALS['SITE_DB']->query_select_value_if_there('url_id_monikers', 'm_resource_id', $url_moniker_where);
        if (is_null($_id)) {
            return;
        }
        $parent_id = intval($_id);
    }
}

if ($parent_id !== null) {
    $sql = 'SELECT child_id,title,the_order FROM ' . get_table_prefix() . 'wiki_children WHERE parent_id=' . strval($parent_id) . ' ORDER BY the_order';
    $nodes = $GLOBALS['SITE_DB']->query($sql);
    $id_order = null;
    foreach ($nodes as $node) {
        if ($node['child_id'] == $id) {
            $id_order = $node['the_order'];
            break;
        }
    }
    foreach ($nodes as $node) {
        if ($node['the_order'] < $id_order) {
            $previous_sibling_id = $node['child_id'];
            $previous_sibling_title = $node['title'];
            $previous_sibling_chain = implode('/', $chain);
        }

        if (($next_sibling_id === null) && ($node['the_order'] > $id_order)) {
            $next_sibling_id = $node['child_id'];
            $next_sibling_title = $node['title'];
            $next_sibling_chain = implode('/', $chain);
        }
    }
}

if (!empty($map['multi_level'])) {
    $tree = get_cache_entry('_wiki_tree', '', CACHE_AGAINST_PERMISSIVE_GROUPS, 10000);
    if ($tree === null) {
        $wiki_seen = array();
        $tree = get_wiki_page_tree($wiki_seen, db_get_first_id());

        foreach ($tree as $i => $node) {
            unset($tree[$i]['breadcrumbs']);
            unset($tree[$i]['compound_list']);
            unset($tree[$i]['child_count']);
        }

        require_code('caches2');
        put_into_cache('_wiki_tree', 10000, '', null, null, '', null, '', $tree);
    }

    $previous_sibling_id = null;
    $previous_sibling_title = null;
    $previous_sibling_chain = null;
    $next_sibling_id = null;
    $next_sibling_title = null;
    $next_sibling_chain = null;

    foreach ($tree as $i => $node) {
        if ($node['id'] == $id) {
            if (isset($tree[$i - 1])) {
                $previous_sibling_id = $tree[$i - 1]['id'];
                $previous_sibling_title = $tree[$i - 1]['title'];
                $previous_sibling_chain = ''; // Just let it default
            }
            if (isset($tree[$i + 1])) {
                $next_sibling_id = $tree[$i + 1]['id'];
                $next_sibling_title = $tree[$i + 1]['title'];
                $next_sibling_chain = ''; // Just let it default
            }
            break;
        }
    }
}

if ($parent_id !== null) {
    $chain_reduced = $chain;
    array_pop($chain_reduced);
    $_id = '';
    if (!empty($chain_reduced)) {
        $_id .= implode('/', $chain_reduced) . '/';
    }
    $_id .= strval($parent_id);
    $parent_url = build_url(array('page' => 'wiki', 'type' => 'browse', 'id' => $_id), get_page_zone('wiki'), null, false, false, true);
    echo '<a title="' . escape_html($parent_title) . '" class="button_screen menu___generic_admin__view_archive" href="' . escape_html($parent_url->evaluate()) . '"><span>' . do_lang('PARENT') . '</span></a>';
}

if ($previous_sibling_id !== null) {
    $_id = '';
    if ($previous_sibling_chain != '') {
        $_id .= $previous_sibling_chain . '/';
    }
    $_id .= strval($previous_sibling_id);
    $previous_sibling_url = build_url(array('page' => 'wiki', 'type' => 'browse', 'id' => $_id), get_page_zone('wiki'), null, false, false, true);
    echo '<a title="' . escape_html($previous_sibling_title) . '" class="button_screen buttons__previous" rel="prev" accesskey="j" href="' . escape_html($previous_sibling_url->evaluate()) . '"><span>' . do_lang('PREVIOUS') . '</span></a>';
} else {
    echo '<span class="button_screen buttons__previous_none"><span>' . do_lang('PREVIOUS') . '</span></span>';
}

if ($next_sibling_id !== null) {
    $_id = '';
    if ($next_sibling_chain != '') {
        $_id .= $next_sibling_chain . '/';
    }
    $_id .= strval($next_sibling_id);
    $next_sibling_url = build_url(array('page' => 'wiki', 'type' => 'browse', 'id' => $_id), get_page_zone('wiki'), null, false, false, true);
    echo '<a title="' . escape_html($next_sibling_title) . '" class="button_screen buttons__next" rel="next" accesskey="k" href="' . escape_html($next_sibling_url->evaluate()) . '"><span>' . do_lang('NEXT') . '</span></a>';
} else {
    echo '<span class="button_screen buttons__next_none"><span>' . do_lang('NEXT') . '</span></span>';
}
