<?php

require_code('maps');

$width = empty($map['width']) ? null : $map['width'];
$height = empty($map['height']) ? null : $map['height'];

$intensity_label = empty($map['intensity_label']) ? 'Intensity' : $map['intensity_label'];

$color_pool = empty($map['color_pool']) ? array() : explode(',', $map['color_pool']);

$show_labels = empty($map['show_labels']) ? false : ($map['show_labels'] == '1');

$myfile = fopen(get_custom_file_base() . '/' . $map['file'], 'rb');
$data = array();
while (($line = fgetcsv($myfile)) !== false) {
    if (implode('', $line) == '') {
        continue;
    }

    if (count($line) < 2) {
        warn_exit(do_lang_tempcode('INTERNAL_ERROR'));
    }

    $data[] = array(
        'region' => $line[0],
        'intensity' => empty($line[1]) ? '' : $line[1],
        'description' => implode(',', array_slice($line, 2)),
    );
}
fclose($myfile);

$tpl = countries_on_map($data, $intensity_label, $color_pool, $show_labels, null, $width, $height);
$tpl->evaluate_echo();
