<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2012

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		core_ocf
 */

/*

OCF is designed to run under a number of different situations, via the object orientated driver situation, and some driver variable switcher functions in import.php.
 - Standalone OCF (FORUM_DB==SITE_DB, but not explicitly)
 - Installation (force standalone OCF, regardless of whether it is on an MSN in normal use: FORUM_DB:=SITE_DB, for installation/upgrading of OCF only)
 - Multi site network linking / Importing a non-forum (FORUM_DB!=SITE_DB)
 - Importing a forum (import.php functions used to to and from OCF and normal-forum-driver [which might not be OCF])

Exception: Welcome Mails are per-site, so run through SITE_DB. They have their own install code in the admin module though.

SITE_DB - The site database, always
FORUM_DB - The forum database. If not using OCF, will not be the OCF db. Switched around by installer/forum-importers according for need for locality/OCFality.
FORUM_DRIVER - The forum driver. May not be OCF, depending on which forum driver is used.
OCF_DRIVER - A forum driver to OCF. This is always used in OCF rather than FORUM_DRIVER, in case OCF functions are being called when OCF is not the primary forum driver running (when importing to OCF but using a different forum driver, often when in the process of switching forums)

The OCF functions should always call up the attachment and language systems using explicitly the forum database, so multi site networks function properly.

*/

/**
 * Standard code module initialisation function.
 */
function init__ocf_install()
{
	global $OCF_TRUE_PERMISSIONS,$OCF_FALSE_PERMISSIONS;
	$OCF_TRUE_PERMISSIONS=array(
									'run_multi_moderations',
									'use_pt',
									'edit_personal_topic_posts',
									'may_unblind_own_poll',
									'may_report_post',
									'view_member_photos',
									'use_quick_reply',
									'view_profiles',
									'own_avatars',
									//'decide_comment_type'
	);
	$OCF_FALSE_PERMISSIONS=array(
									'rename_self',
									'use_special_emoticons',
									'view_any_profile_field',
									'disable_lost_passwords',
									'close_own_topics',
									'edit_own_polls',
									'double_post',
									'see_warnings',
									'see_ip',
									'may_choose_custom_title',
									'delete_account',
									'view_other_pt',
									'view_poll_results_before_voting',
									'moderate_personal_topic',
									'member_maintenance',
									'probate_members',
									'warn_members',
									'control_usergroups',
									'multi_delete_topics',
									'show_user_browsing',
									'see_hidden_groups',
									'pt_anyone',
	);
}

/**
 * Uninstall OCF (1).
 */
function uninstall_ocf_everytime()
{
	delete_specific_permission('enquire_on_new_ips'); // Used to exist
	delete_specific_permission('allow_deletive_moderation'); // Used to exist
	global $OCF_TRUE_PERMISSIONS,$OCF_FALSE_PERMISSIONS;

	foreach ($OCF_TRUE_PERMISSIONS as $permission)
	{
		delete_specific_permission($permission);
	}
	foreach ($OCF_FALSE_PERMISSIONS as $permission)
	{
		delete_specific_permission($permission);
	}

	$GLOBALS['FORUM_DB']->query_delete('group_category_access',array('module_the_name'=>'forums'));

	delete_config_option('signup_fullname');
	delete_config_option('allow_email_from_staff_disable');
	delete_config_option('forum_posts_per_page');
	delete_config_option('forum_topics_per_page');
	delete_config_option('prevent_shouting');
	delete_config_option('restricted_usernames');
	delete_config_option('require_new_member_validation');
	delete_config_option('reported_posts_forum');
	delete_config_option('one_per_email_address');
	delete_config_option('hot_topic_definition');
	delete_config_option('httpauth_is_enabled');
	delete_config_option('send_staff_message_post_validation');
	delete_config_option('post_history_days');
	delete_config_option('is_on_invites');
	delete_config_option('invites_per_day');
	delete_config_option('is_on_coppa');
	delete_config_option('privacy_fax');
	delete_config_option('privacy_postal_address');
	delete_config_option('minimum_password_length');
	delete_config_option('maximum_password_length');
	delete_config_option('minimum_username_length');
	delete_config_option('maximum_username_length');
	delete_config_option('prohibit_password_whitespace');
	delete_config_option('prohibit_password_dictionary');
	delete_config_option('prohibit_username_whitespace');
	delete_config_option('random_avatars');
	delete_config_option('club_forum_parent_forum');
	delete_config_option('club_forum_parent_category');
	delete_config_option('delete_trashed_pts');
	delete_config_option('allow_member_integration');
	delete_config_option('probation_usergroup');
	delete_config_option('threaded_comments');
	//delete_config_option('threaded_topics_default');
	delete_config_option('show_first_join_page');
	delete_config_option('skip_email_confirm_join');
	delete_config_option('no_dob_ask');
	delete_config_option('allow_international');
	delete_config_option('is_on_post_titles');
	delete_config_option('is_on_anonymous_posts');
	delete_config_option('is_on_timezone_detection');
	delete_config_option('is_on_topic_descriptions');
	delete_config_option('is_on_topic_emoticons');
	delete_config_option('default_preview_guests');
	delete_config_option('forced_preview_option');
	delete_config_option('overt_whisper_suggestion');
	delete_config_option('is_on_invisibility');
	delete_config_option('allow_alpha_search');
	delete_config_option('allow_email_disable');
	delete_config_option('max_member_title_length');
	delete_config_option('encryption_key');
	delete_config_option('decryption_key');
	delete_config_option('intro_forum_id');
	delete_config_option('valid_email_domains');

	delete_value('ocf_newest_member_id');
	delete_value('ocf_newest_member_username');
	delete_value('ocf_member_count');
	delete_value('ocf_topic_count');
	delete_value('ocf_post_count');

	deldir_contents(get_custom_file_base().'/uploads/ocf_avatars',true);
	deldir_contents(get_custom_file_base().'/uploads/ocf_photos',true);
	deldir_contents(get_custom_file_base().'/uploads/ocf_photos_thumbs',true);
	deldir_contents(get_custom_file_base().'/uploads/avatars',true);
	deldir_contents(get_custom_file_base().'/uploads/photos',true);
	deldir_contents(get_custom_file_base().'/uploads/photos_thumbs',true);

	delete_attachments('ocf_post');
	delete_attachments('ocf_signature');
}

/**
 * Uninstall OCF (2).
 */
function uninstall_ocf()
{
	require_code('database_action');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_emoticons');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_forum_group_access');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_custom_fields');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_member_custom_fields');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_groups');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_categories');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_forums');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_forum_intro_ip');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_forum_intro_member');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_topics');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_posts');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_post_history');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_polls');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_poll_answers');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_poll_votes');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_post_templates');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_warnings');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_moderator_logs');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_member_known_login_ips');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_members');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_group_members');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_read_logs');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_forum_tracking');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_topic_tracking');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_multi_moderations');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_invites');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_forum_group_access');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_special_pt_access');
	$GLOBALS['FORUM_DB']->drop_if_exists('f_saved_warnings');
	$GLOBALS['FORUM_DB']->query_delete('gsp',array('module_the_name'=>'forums'));
}

/**
 * Install/upgrade OCF.
 *
 * @param  ?float	The version to upgrade from (NULL: fresh install).
 */
function install_ocf($upgrade_from=NULL)
{
	require_code('ocf_members');
	require_code('ocf_topics');
	require_code('ocf_groups');
	require_code('ocf_forums');
	require_lang('ocf');
	require_lang('ocf_config');
	require_code('ocf_moderation_action');
	require_code('ocf_posts_action');
	require_code('ocf_members_action');
	require_code('ocf_groups_action');
	require_code('ocf_general_action');
	require_code('ocf_forums_action');
	require_code('ocf_topics_action');
	require_code('database_action');

	if (is_null($upgrade_from))
	{
		uninstall_ocf_everytime();

//		if (post_param('clear_existing_forums_on_install','no')=='yes')  No longer necessary to have this option, as OCF is only ever installed to site-db, not forum-db (although site-db is aliased as forum-db for this code)
		{
			uninstall_ocf();
		}
	}

	$test=$GLOBALS['FORUM_DB']->query('SELECT id FROM '.$GLOBALS['FORUM_DB']->get_table_prefix().'f_forums',NULL,NULL,true);
	$not_installed=is_null($test);
	if ($not_installed) $upgrade_from=NULL;

	if ((is_null($upgrade_from)) || ($upgrade_from<4.2))
	{
		add_config_option('ENCRYPTION_KEY','encryption_key','line','require_code(\'encryption\');return is_encryption_available()?\'\':NULL;','PRIVACY','ADVANCED');
		add_config_option('DECRYPTION_KEY','decryption_key','line','require_code(\'encryption\');return is_encryption_available()?\'\':NULL;','PRIVACY','ADVANCED');
		add_config_option('IS_ON_POST_TITLES','is_on_post_titles','tick','return is_null($old=get_value(\'no_post_titles\'))?\'0\':invert_value($old);','SECTION_FORUMS','GENERAL');
		add_config_option('IS_ON_ANONYMOUS_POSTS','is_on_anonymous_posts','tick','return is_null($old=get_value(\'ocf_no_anonymous_post\'))?\'0\':invert_value($old);','SECTION_FORUMS','GENERAL');
		add_config_option('IS_ON_TIMEZONE_DETECTION','is_on_timezone_detection','tick','return is_null($old=get_value(\'no_js_timezone_detect\'))?\'0\':invert_value($old);','SECTION_FORUMS','GENERAL');
		add_config_option('IS_ON_TOPIC_DESCRIPTIONS','is_on_topic_descriptions','tick','return is_null($old=get_value(\'no_topic_descriptions\'))?\'1\':invert_value($old);','SECTION_FORUMS','GENERAL');
		add_config_option('IS_ON_TOPIC_EMOTICONS','is_on_topic_emoticons','tick','return is_null($old=get_value(\'ocf_no_topic_emoticons\'))?\'1\':invert_value($old);','SECTION_FORUMS','GENERAL');
		add_config_option('DEFAULT_PREVIEW_GUESTS','default_preview_guests','tick','return is_null($old=get_value(\'no_default_preview_guests\'))?\'0\':invert_value($old);','SECTION_FORUMS','GENERAL');
		add_config_option('FORCED_PREVIEW_OPTION','forced_preview_option','tick','return is_null($old=get_value(\'no_forced_preview_option\'))?\'0\':invert_value($old);','SECTION_FORUMS','GENERAL');
		add_config_option('OVERT_WHISPER_SUGGESTION','overt_whisper_suggestion','tick','return is_null($old=get_value(\'disable_overt_whispering\'))?\'1\':invert_value($old);','SECTION_FORUMS','GENERAL');
		add_config_option('IS_ON_INVISIBILITY','is_on_invisibility','tick','return is_null($old=get_value(\'no_invisible_option\'))?\'0\':invert_value($old);','SECTION_FORUMS','GENERAL');
		add_config_option('ALLOW_ALPHA_SEARCH','allow_alpha_search','tick','return is_null($old=get_value(\'allow_alpha_search\'))?\'0\':$old;','SECTION_FORUMS','GENERAL');
		add_config_option('ALLOW_EMAIL_DISABLE','allow_email_disable','tick','return is_null($old=get_value(\'disable_allow_emails_field\'))?\'1\':invert_value($old);','SECTION_FORUMS','GENERAL');
		add_config_option('MAX_MEMBER_TITLE_LENGTH','max_member_title_length','integer','return addon_installed(\'ocf_member_titles\')?\'20\':NULL;','SECTION_FORUMS','GENERAL');

		$GLOBALS['FORUM_DB']->drop_if_exists('f_member_cpf_perms');
		$GLOBALS['FORUM_DB']->create_table('f_member_cpf_perms',array(
						'member_id'=>'*USER',
						'field_id'=>'*AUTO_LINK',
						'guest_view'=>'BINARY',
						'member_view'=>'BINARY',
						'friend_view'=>'BINARY',
						'group_view'=>'SHORT_TEXT'
		));
	}

	if ((is_null($upgrade_from)) || ($upgrade_from<2.5))
	{
		add_config_option('HTTPAUTH_IS_ENABLED','httpauth_is_enabled','tick','return \'0\';','SECTION_FORUMS','ADVANCED',1);
		add_config_option('POST_HISTORY_DAYS','post_history_days','integer','return \'21\';','SECTION_FORUMS','GENERAL',1);
	}

	if (is_null($upgrade_from))
	{
		// Add config options
		add_config_option('FORUM_POSTS_PER_PAGE','forum_posts_per_page','integer','return has_no_forum()?NULL:\'20\';','SECTION_FORUMS','GENERAL');
		add_config_option('FORUM_TOPICS_PER_PAGE','forum_topics_per_page','integer','return has_no_forum()?NULL:\'30\';','SECTION_FORUMS','GENERAL');
		add_config_option('PREVENT_SHOUTING','prevent_shouting','tick','return has_no_forum()?NULL:\'1\';','SECTION_FORUMS','GENERAL');
		add_config_option('RESTRICTED_USERNAMES','restricted_usernames','line','return do_lang(\'GUEST\').\', \'.do_lang(\'STAFF\').\', \'.do_lang(\'ADMIN\').\', \'.do_lang(\'MODERATOR\').\', googlebot\';','SECTION_FORUMS','GENERAL');
		add_config_option('REQUIRE_NEW_MEMBER_VALIDATION','require_new_member_validation','tick','return \'0\';','SECTION_FORUMS','USERNAMES_AND_PASSWORDS');
		add_config_option('REPORTED_POSTS_FORUM','reported_posts_forum','forum','return (has_no_forum()||(!addon_installed(\'ocf_reported_posts\')))?NULL:do_lang(\'ocf:REPORTED_POSTS_FORUM\');','SECTION_FORUMS','GENERAL');
		add_config_option('ONE_PER_EMAIL_ADDRESS','one_per_email_address','tick','return \'1\';','SECTION_FORUMS','GENERAL');
		add_config_option('HOT_TOPIC_DEFINITION','hot_topic_definition','integer','return has_no_forum()?NULL:\'20\';','SECTION_FORUMS','GENERAL');
	}

	if ((!is_null($upgrade_from)) && ($upgrade_from<7.2))
	{
		$rows=$GLOBALS['FORUM_DB']->query('SELECT m_name FROM '.$GLOBALS['FORUM_DB']->get_table_prefix().'db_meta WHERE ('.db_string_equal_to('m_type','?INTEGER').' OR '.db_string_equal_to('m_type','BINARY').') AND '.db_string_equal_to('m_table','f_member_custom_fields'));
		foreach ($rows as $row)
		{
			$GLOBALS['FORUM_DB']->alter_table_field('f_member_custom_fields',$row['m_name'],'SHORT_TEXT');
		}

		$i=0;
		do
		{
			$rows=$GLOBALS['FORUM_DB']->query_select('f_member_custom_fields',array('*'),NULL,'',100,$i);
			foreach ($rows as $j=>$row)
			{
				foreach ($row as $key=>$val)
				{
					if (substr($key,0,6)=='field_')
					{
						$val=str_replace('|',chr(10),$val);
						$row[$key]=$val;
					}
				}
				if ($rows[$j]!=$row)
				{
					$GLOBALS['FORUM_DB']->query_update('f_member_custom_fields',array('mf_member_id'=>$row['mf_member_id']),$row,'',1);
				}
			}
			$i+=100;
		}
		while (count($rows)!=0);

		$GLOBALS['FORUM_DB']->alter_table_field('f_members','m_track_contributed_topics','BINARY','m_auto_monitor_contrib_content');
	}

	if ((!is_null($upgrade_from)) && ($upgrade_from<4.0))
	{
		$GLOBALS['FORUM_DB']->alter_table_field('f_members','m_password_compatibility_scheme','ID_TEXT','m_password_compat_scheme');
		$GLOBALS['FORUM_DB']->delete_table_field('f_members','m_track_all_forums');
	}

	if ((!is_null($upgrade_from)) && ($upgrade_from<3.1))
	{
		$GLOBALS['FORUM_DB']->add_table_field('f_emoticons','e_is_special','BINARY',0);
		$GLOBALS['FORUM_DB']->add_table_field('f_members','m_highlighted_name','BINARY',0);
	}

	if ((!is_null($upgrade_from)) && ($upgrade_from<3.0))
	{
		$rows=$GLOBALS['FORUM_DB']->query_select('f_forum_group_access',array('*'));
		foreach ($rows as $row)
		{
			if ($row['a_level']>1)
				$GLOBALS['SITE_DB']->query_insert('group_category_access',array('module_the_name'=>'forums','category_name'=>strval($row['a_forum_id']),'group_id'=>$row['a_group_id']));
		}
		$GLOBALS['FORUM_DB']->drop_if_exists('f_forum_group_access');
		delete_specific_permission('allow_deletive_moderation');
		$GLOBALS['FORUM_DB']->delete_table_field('f_post_templates','t_minimum_access_level');
		$GLOBALS['FORUM_DB']->add_table_field('f_groups','g_is_presented_at_install','BINARY',0);
		$GLOBALS['FORUM_DB']->alter_table_field('f_custom_fields','cf_name','SHORT_TRANS');
		$GLOBALS['FORUM_DB']->alter_table_field('f_groups','g_rank_image','ID_TEXT');
	}

	if ((!is_null($upgrade_from)) && ($upgrade_from<2.6))
	{
		$GLOBALS['FORUM_DB']->add_table_field('f_groups','g_is_default','BINARY');
	}

	if ((is_null($upgrade_from)) || ($upgrade_from<4.0))
	{
		add_config_option('MINIMUM_PASSWORD_LENGTH','minimum_password_length','integer','return \'4\';','SECTION_FORUMS','USERNAMES_AND_PASSWORDS');
		add_config_option('MAXIMUM_PASSWORD_LENGTH','maximum_password_length','integer','return \'20\';','SECTION_FORUMS','USERNAMES_AND_PASSWORDS');
		add_config_option('MINIMUM_USERNAME_LENGTH','minimum_username_length','integer','return \'1\';','SECTION_FORUMS','USERNAMES_AND_PASSWORDS');
		add_config_option('MAXIMUM_USERNAME_LENGTH','maximum_username_length','integer','return \'20\';','SECTION_FORUMS','USERNAMES_AND_PASSWORDS');
		add_config_option('PROHIBIT_PASSWORD_WHITESPACE','prohibit_password_whitespace','tick','return \'1\';','SECTION_FORUMS','USERNAMES_AND_PASSWORDS');
		//add_config_option('PROHIBIT_PASSWORD_DICTIONARY','prohibit_password_dictionary','tick','return \'0\';','SECTION_FORUMS','USERNAMES_AND_PASSWORDS');
		add_config_option('PROHIBIT_USERNAME_WHITESPACE','prohibit_username_whitespace','tick','return \'0\';','SECTION_FORUMS','USERNAMES_AND_PASSWORDS');
		add_config_option('ASSIGN_RANDOM_AVATARS','random_avatars','tick','return addon_installed(\'ocf_member_avatars\')?\'1\':NULL;','SECTION_FORUMS','GENERAL');
		add_config_option('CLUB_FORUM_PARENT_FORUM','club_forum_parent_forum','forum','return has_no_forum()?NULL:strval(db_get_first_id());','SECTION_FORUMS','GENERAL');
		add_config_option('CLUB_FORUM_PARENT_CATEGORY','club_forum_parent_category','category','return has_no_forum()?NULL:strval(db_get_first_id());','SECTION_FORUMS','GENERAL');
		add_config_option('DELETE_TRASHED_PTS','delete_trashed_pts','tick','return has_no_forum()?NULL:\'0\';','SECTION_FORUMS','GENERAL');
		//add_config_option('ALLOW_MEMBER_INTEGRATION','allow_member_integration','list','return \'off\';','SECTION_FORUMS','USERNAMES_AND_PASSWORDS',0,'strict|on|hidden|off');
		add_config_option('PROBATION_USERGROUP','probation_usergroup','usergroup','return do_lang(\'PROBATION\');','SECTION_FORUMS','USERNAMES_AND_PASSWORDS');
		add_config_option('SHOW_FIRST_JOIN_PAGE','show_first_join_page','tick','return \'1\';','SECTION_FORUMS','USERNAMES_AND_PASSWORDS');
		add_config_option('SKIP_EMAIL_CONFIRM_JOIN','skip_email_confirm_join','tick','return \'1\';','SECTION_FORUMS','USERNAMES_AND_PASSWORDS');
		add_config_option('NO_DOB_ASK','no_dob_ask','list','return \'0\';','SECTION_FORUMS','USERNAMES_AND_PASSWORDS',0,'0|1|2');
		add_config_option('ALLOW_INTERNATIONAL','allow_international','tick','return \'1\';','SECTION_FORUMS','USERNAMES_AND_PASSWORDS');
	}
	if ((is_null($upgrade_from)) || ($upgrade_from<10.0)) // TODO: Tidy up in v10 branch
	{
		add_config_option('VALID_EMAIL_DOMAINS','valid_email_domains','line','return \'\';','SECTION_FORUMS','USERNAMES_AND_PASSWORDS');
	}
	if ((is_null($upgrade_from)) || ($upgrade_from<8.0))
	{
		add_config_option('ALLOW_EMAIL_FROM_STAFF_DISABLE','allow_email_from_staff_disable','tick','return \'0\';','SECTION_FORUMS','GENERAL');
		add_config_option('INTRO_FORUM_ID','intro_forum_id','?forum','return \'\';','SECTION_FORUMS','USERNAMES_AND_PASSWORDS');
		add_config_option('SIGNUP_FULLNAME','signup_fullname','tick','return \'0\';','SECTION_FORUMS','USERNAMES_AND_PASSWORDS');
	}
	if ((!is_null($upgrade_from)) && ($upgrade_from<8.1))
	{
		delete_config_option('no_dob_ask');
		add_config_option('NO_DOB_ASK','no_dob_ask','list','return \'0\';','SECTION_FORUMS','USERNAMES_AND_PASSWORDS',0,'0|1|2'); // Recreate option
	}
	if ((!is_null($upgrade_from)) && ($upgrade_from<8.0))
	{
		$GLOBALS['FORUM_DB']->add_table_field('f_members','m_allow_emails_from_staff','BINARY');
		$GLOBALS['FORUM_DB']->add_table_field('f_custom_fields','cf_show_on_join_form','BINARY');
		$GLOBALS['FORUM_DB']->add_table_field('f_forums','f_is_threaded','BINARY',0);
		$GLOBALS['FORUM_DB']->add_table_field('f_posts','p_parent_id','?AUTO_LINK',NULL);
		$GLOBALS['FORUM_DB']->query('UPDATE '.$GLOBALS['FORUM_DB']->get_table_prefix().'f_custom_fields SET cf_show_on_join_form=cf_required');
		delete_config_option('send_staff_message_post_validation');

		require_code('notifications');
		$start=0;
		do
		{
			$rows=$GLOBALS['FORUM_DB']->query_select('f_forum_tracking',array('r_forum_id','r_member_id'),NULL,'',100,$start);
			foreach ($rows as $row)
			{
				enable_notifications('ocf_topic','forum:'.strval($row['r_forum_id']),$row['r_member_id']);
			}
			$start+=100;
		}
		while (count($rows)==100);
		$start=0;
		do
		{
			$rows=$GLOBALS['FORUM_DB']->query_select('f_topic_tracking',array('r_topic_id','r_member_id'),NULL,'',100,$start);
			foreach ($rows as $row)
			{
				enable_notifications('ocf_topic',strval($row['r_topic_id']),$row['r_member_id']);
			}
			$start+=100;
		}
		while (count($rows)==100);

		$GLOBALS['FORUM_DB']->drop_if_exists('f_forum_tracking');
		$GLOBALS['FORUM_DB']->drop_if_exists('f_topic_tracking');
	}
	if ((!is_null($upgrade_from)) && ($upgrade_from<4.2))
	{
		$GLOBALS['FORUM_DB']->add_table_field('f_topics','t_description_link','SHORT_TEXT');
		$GLOBALS['FORUM_DB']->add_table_field('f_custom_fields','cf_encrypted','BINARY',0);
	}
	if ((!is_null($upgrade_from)) && ($upgrade_from<4.0))
	{
		$GLOBALS['FORUM_DB']->add_table_field('f_members','m_on_probation_until','?TIME',time());
		$GLOBALS['FORUM_DB']->add_table_field('f_members','m_pt_rules_text','LONG_TRANS','');
		$GLOBALS['FORUM_DB']->add_table_field('f_members','m_pt_allow','SHORT_TEXT','*');
		$GLOBALS['FORUM_DB']->add_table_field('f_forums','f_order','ID_TEXT','last_post'); // last_post,first_post,title
		$GLOBALS['FORUM_DB']->add_table_field('f_groups','g_hidden','BINARY',0);
		$GLOBALS['FORUM_DB']->add_table_field('f_groups','g_order','INTEGER');
		$GLOBALS['FORUM_DB']->add_table_field('f_groups','g_rank_image_pri_only','BINARY',1);
		$GLOBALS['FORUM_DB']->add_table_field('f_groups','g_open_membership','BINARY',0);
		$GLOBALS['FORUM_DB']->add_table_field('f_groups','g_is_private_club','BINARY',0);
		$GLOBALS['FORUM_DB']->add_table_field('f_posts','p_skip_sig','BINARY',0);
		$GLOBALS['FORUM_DB']->add_table_field('f_topics','t_sunk','BINARY',0);
		$GLOBALS['FORUM_DB']->add_table_field('f_multi_moderations','mm_sink_state','?BINARY',NULL);
		$GLOBALS['FORUM_DB']->add_table_field('f_multi_moderations','mm_title_suffix','SHORT_TEXT');
		$GLOBALS['FORUM_DB']->add_table_field('f_warnings','w_is_warning','BINARY',1);
		$GLOBALS['FORUM_DB']->add_table_field('f_warnings','p_silence_from_topic','?AUTO_LINK');
		$GLOBALS['FORUM_DB']->add_table_field('f_warnings','p_silence_from_forum','?AUTO_LINK');
		$GLOBALS['FORUM_DB']->add_table_field('f_warnings','p_probation','INTEGER',0);
		$GLOBALS['FORUM_DB']->add_table_field('f_warnings','p_banned_ip','IP');
		$GLOBALS['FORUM_DB']->add_table_field('f_warnings','p_charged_points','INTEGER',0);
		$GLOBALS['FORUM_DB']->add_table_field('f_warnings','p_banned_member','BINARY',0);
		$GLOBALS['FORUM_DB']->add_table_field('f_warnings','p_changed_usergroup_from','?GROUP');
	}
	if ((is_null($upgrade_from)) || ($upgrade_from<3.0))
	{
		add_config_option('COPPA_ENABLED','is_on_coppa','tick','return \'0\';','PRIVACY','GENERAL');
		add_config_option('FAX_NUMBER','privacy_fax','line','return \'\';','PRIVACY','GENERAL');
		add_config_option('ADDRESS','privacy_postal_address','text','return \'\';','PRIVACY','GENERAL');
	}
	if ((is_null($upgrade_from)) || ($upgrade_from<2.6))
	{
		add_config_option('INVITES_ENABLED','is_on_invites','tick','return \'0\';','SECTION_FORUMS','GENERAL');
		add_config_option('INVITES_PER_DAY','invites_per_day','float','return \'1\';','SECTION_FORUMS','GENERAL');
	}
	if ((!is_null($upgrade_from)) && ($upgrade_from<2.5))
	{
		$GLOBALS['FORUM_DB']->add_table_field('f_forums','f_redirection','SHORT_TEXT');
		$GLOBALS['FORUM_DB']->add_table_field('f_forums','f_order_sub_alpha','BINARY');
		$GLOBALS['FORUM_DB']->add_table_field('f_forums','f_intro_question','LONG_TRANS');
		$GLOBALS['FORUM_DB']->add_table_field('f_forums','f_intro_answer','SHORT_TEXT');
		$GLOBALS['FORUM_DB']->add_table_field('f_members','m_max_email_attach_size_mb','INTEGER',3);
		$GLOBALS['FORUM_DB']->add_table_field('f_members','m_zone_wide','BINARY',1);
		$GLOBALS['FORUM_DB']->add_table_field('f_members','m_notes','LONG_TEXT'); // TODO: remove
		$GLOBALS['FORUM_DB']->add_table_field('f_emoticons','e_use_topics','BINARY',1);
		$GLOBALS['FORUM_DB']->add_table_field('f_topics','t_pt_from_category','SHORT_TEXT');
		$GLOBALS['FORUM_DB']->add_table_field('f_topics','t_pt_to_category','SHORT_TEXT');
		$GLOBALS['FORUM_DB']->add_table_field('f_custom_fields','cf_show_in_post_previews','BINARY',1);
		$GLOBALS['FORUM_DB']->add_table_field('f_custom_fields','cf_order','INTEGER');
		$GLOBALS['FORUM_DB']->add_table_field('f_custom_fields','cf_only_group','?GROUP');
		$GLOBALS['FORUM_DB']->add_table_field('f_multi_moderations','mm_forum_multi_code','SHORT_TEXT');

		$GLOBALS['FORUM_DB']->alter_table_field('f_topics','t_emoticon','SHORT_TEXT');
		$GLOBALS['FORUM_DB']->alter_table_field('f_emoticons','e_theme_img_code','SHORT_TEXT');
		$GLOBALS['FORUM_DB']->promote_text_field_to_comcode('f_forums','f_description');
		$GLOBALS['FORUM_DB']->alter_table_field('f_members','m_pass_hash_salted','SHORT_TEXT');

		$GLOBALS['FORUM_DB']->drop_if_exists('f_groups');
		$GLOBALS['FORUM_DB']->query_delete('f_emoticons');
	}
	if ((!is_null($upgrade_from)) && ($upgrade_from<3.1))
	{
		$GLOBALS['FORUM_DB']->alter_table_field('f_custom_fields','cf_only_group','LONG_TEXT');
	}

	// If we have the forum installed to this db already, leave
	if ((is_null($upgrade_from)) && ($not_installed))
	{
		uninstall_ocf();

		$GLOBALS['FORUM_DB']->create_table('f_emoticons',array(
			'e_code'=>'*ID_TEXT',
			'e_theme_img_code'=>'SHORT_TEXT',
			'e_relevance_level'=>'INTEGER', // 0=core,1=supported,2=unsupported,3=crappy,4=unused
			'e_use_topics'=>'BINARY', // Whether to use it to show a topics emotion
			'e_is_special'=>'BINARY'
		));
		$GLOBALS['FORUM_DB']->create_index('f_emoticons','relevantemoticons',array('e_relevance_level'));
		$GLOBALS['FORUM_DB']->create_index('f_emoticons','topicemos',array('e_use_topics'));

		$GLOBALS['FORUM_DB']->create_table('f_custom_fields',array(
			'id'=>'*AUTO',
			'cf_locked'=>'BINARY',  // Can't be deleted
			'cf_name'=>'SHORT_TRANS',
			'cf_description'=>'SHORT_TRANS',
			'cf_default'=>'LONG_TEXT',
			'cf_public_view'=>'BINARY',
			'cf_owner_view'=>'BINARY',
			'cf_owner_set'=>'BINARY',
			'cf_type'=>'ID_TEXT', // /* can be short_text,long_text,long_trans,integer,url,upload,picture,list,tick */
			'cf_required'=>'BINARY',
			'cf_show_in_posts'=>'BINARY',
			'cf_show_in_post_previews'=>'BINARY',
			'cf_order'=>'INTEGER',
			'cf_only_group'=>'LONG_TEXT',
			'cf_encrypted'=>'BINARY',
			'cf_show_on_join_form'=>'BINARY',
		));

		// These don't need to be filled in. We just use default from custom field if they aren't
		$GLOBALS['FORUM_DB']->create_table('f_member_custom_fields',array(
			'mf_member_id'=>'*USER'
		));
		//$GLOBALS['FORUM_DB']->create_index('f_member_custom_fields','fields_for_member',array('mf_member_id'));

		ocf_make_boiler_custom_field('SELF_DESCRIPTION');
		//ocf_make_boiler_custom_field('im_aim');
		//ocf_make_boiler_custom_field('im_msn');
		//ocf_make_boiler_custom_field('im_yahoo');
		//ocf_make_boiler_custom_field('im_icq');
		//ocf_make_boiler_custom_field('im_jabber');
		ocf_make_boiler_custom_field('im_skype');
		ocf_make_boiler_custom_field('sn_facebook');
		ocf_make_boiler_custom_field('sn_google');
		ocf_make_boiler_custom_field('sn_twitter');
		ocf_make_boiler_custom_field('interests');
		ocf_make_boiler_custom_field('location');
		ocf_make_boiler_custom_field('occupation');
		ocf_make_boiler_custom_field('staff_notes');
	}

	if ((is_null($upgrade_from)) || ($upgrade_from<2.6))
	{
		$GLOBALS['FORUM_DB']->create_table('f_invites',array(
			'id'=>'*AUTO',
			'i_inviter'=>'USER',
			'i_email_address'=>'SHORT_TEXT',
			'i_time'=>'TIME',
			'i_taken'=>'BINARY'
		));
	}

	if ((is_null($upgrade_from)) && ($not_installed))
	{
		$GLOBALS['FORUM_DB']->create_table('f_group_members',array(
			'gm_group_id'=>'*GROUP',
			'gm_member_id'=>'*USER',
			'gm_validated'=>'BINARY'
		));
		$GLOBALS['FORUM_DB']->create_index('f_group_members','gm_validated',array('gm_validated'));
		$GLOBALS['FORUM_DB']->create_index('f_group_members','gm_member_id',array('gm_member_id'));
		$GLOBALS['FORUM_DB']->create_index('f_group_members','gm_group_id',array('gm_group_id'));

		$GLOBALS['FORUM_DB']->create_table('f_members',array(
			'id'=>'*AUTO',
			'm_username'=>'ID_TEXT',
			'm_pass_hash_salted'=>'SHORT_TEXT', // Not MD5 type because it could store different things according to password_compatibility_scheme
			'm_pass_salt'=>'SHORT_TEXT',
			'm_theme'=>'ID_TEXT', // Blank means default
			'm_avatar_url'=>'URLPATH', // Blank means no avatar
			'm_validated'=>'BINARY',
			'm_validated_email_confirm_code'=>'SHORT_TEXT',
			'm_cache_num_posts'=>'INTEGER',
			'm_cache_warnings'=>'INTEGER',
			'm_join_time'=>'TIME',
			'm_timezone_offset'=>'SHORT_TEXT',
			'm_primary_group'=>'GROUP',
			'm_last_visit_time'=>'TIME',
			'm_last_submit_time'=>'TIME',
			'm_signature'=>'LONG_TRANS',	// Comcode
			'm_is_perm_banned'=>'BINARY',
			'm_preview_posts'=>'BINARY',
			'm_dob_day'=>'?INTEGER',
			'm_dob_month'=>'?INTEGER',
			'm_dob_year'=>'?INTEGER',
			'm_reveal_age'=>'BINARY',
			'm_email_address'=>'SHORT_TEXT',
			'm_title'=>'SHORT_TEXT', // Blank means use title
			'm_photo_url'=>'URLPATH', // Blank means no photo
			'm_photo_thumb_url'=>'URLPATH', // Blank means no photo
			'm_views_signatures'=>'BINARY',
			'm_auto_monitor_contrib_content'=>'BINARY',
			'm_language'=>'ID_TEXT',
			'm_ip_address'=>'IP',
			'm_allow_emails'=>'BINARY',
			'm_allow_emails_from_staff'=>'BINARY',
			'm_notes'=>'LONG_TEXT', // TODO: Remove
			'm_zone_wide'=>'BINARY',
			'm_highlighted_name'=>'BINARY',
			'm_pt_allow'=>'SHORT_TEXT',
			'm_pt_rules_text'=>'LONG_TRANS',	// Comcode
			'm_max_email_attach_size_mb'=>'INTEGER',
			'm_password_change_code'=>'SHORT_TEXT',
			'm_password_compat_scheme'=>'ID_TEXT',
			'm_on_probation_until'=>'?TIME'
		));
		$GLOBALS['FORUM_DB']->create_index('f_members','#search_user',array('m_username'));
		$GLOBALS['FORUM_DB']->create_index('f_members','user_list',array('m_username'));
		$GLOBALS['FORUM_DB']->create_index('f_members','menail',array('m_email_address'));
		$GLOBALS['FORUM_DB']->create_index('f_members','external_auth_lookup',array('m_pass_hash_salted'));
		$GLOBALS['FORUM_DB']->create_index('f_members','sort_post_count',array('m_cache_num_posts'));
		$GLOBALS['FORUM_DB']->create_index('f_members','m_join_time',array('m_join_time'));
		$GLOBALS['FORUM_DB']->create_index('f_members','whos_validated',array('m_validated'));
		$GLOBALS['FORUM_DB']->create_index('f_members','birthdays',array('m_dob_day','m_dob_month'));
		$GLOBALS['FORUM_DB']->create_index('f_members','ftjoin_msig',array('m_signature'));
		$GLOBALS['FORUM_DB']->create_index('f_members','primary_group',array('m_primary_group'));
		$GLOBALS['FORUM_DB']->create_index('f_members','avatar_url',array('m_avatar_url')); // Used for uniform avatar randomisation
	}

	if ((is_null($upgrade_from)) || ($upgrade_from<2.5))
	{
		$no_use_topics=array('party'=>1,'christmas'=>1,'offtopic'=>1,'rockon'=>1,'guitar'=>1,'sinner'=>1,'wink'=>1,'kiss'=>1,'nod'=>1,'smile'=>1,'mellow'=>1,'whistle'=>1,'shutup'=>1,'cyborg'=>1);
		$core_emoticons=array(':P'=>'cheeky',
										":'("=>'cry',
										':dry:'=>'dry',
										':$'=>'blush',
										';)'=>'wink',
										'O_o'=>'blink',
										':wub:'=>'wub',
										':cool:'=>'cool',
										':lol:'=>'lol',
										':('=>'sad',
										':)'=>'smile',
										':thumbs:'=>'thumbs',
										':offtopic:'=>'offtopic',
										':|'=>'mellow',
										':ninja:'=>'ph34r',
										':o'=>'shocked');
		$supported_emoticons=array(
										':rolleyes:'=>'rolleyes',
										':D'=>'grin',
										'^_^'=>'glee',
										'(K)'=>'kiss',
										':S'=>'confused',
										':@'=>'angry',
										':shake:'=>'shake',
										':hand:'=>'hand',
										':drool:'=>'drool',
										':devil:'=>'devil',
										':party:'=>'party',
										':constipated:'=>'constipated',
										':depressed:'=>'depressed',
										':zzz:'=>'zzz',
										':whistle:'=>'whistle',
										':upsidedown:'=>'upsidedown',
										':sick:'=>'sick',
										':shutup:'=>'shutup',
										':sarcy:'=>'sarcy',
										':puppyeyes:'=>'puppyeyes',
										':nod:'=>'nod',
										':nerd:'=>'nerd',
										':king:'=>'king',
										':birthday:'=>'birthday',
										':cyborg:'=>'cyborg',
										':hippie:'=>'hippie',
										':ninja2:'=>'ninja2',
										':rockon:'=>'rockon',
										':sinner:'=>'sinner',
										':guitar:'=>'guitar',
										);
		$unused_emoticons=array(
										':christmas:'=>'christmas');
		foreach ($core_emoticons as $a=>$b)
			ocf_make_emoticon($a,'ocf_emoticons/'.$b,0,array_key_exists($b,$no_use_topics)?0:1);
		foreach ($supported_emoticons as $a=>$b)
			ocf_make_emoticon($a,'ocf_emoticons/'.$b,1,array_key_exists($b,$no_use_topics)?0:1);
		foreach ($unused_emoticons as $a=>$b)
			ocf_make_emoticon($a,'ocf_emoticons/'.$b,1,array_key_exists($b,$no_use_topics)?0:1);

		$GLOBALS['FORUM_DB']->create_table('f_groups',array(
			'id'=>'*AUTO',
			'g_name'=>'SHORT_TRANS',
			'g_is_default'=>'BINARY',
			'g_is_presented_at_install'=>'BINARY',
			'g_is_super_admin'=>'BINARY',
			'g_is_super_moderator'=>'BINARY',
			'g_group_leader'=>'?USER',
			'g_title'=>'SHORT_TRANS',
			'g_promotion_target'=>'?GROUP',
			'g_promotion_threshold'=>'?INTEGER',
			'g_flood_control_submit_secs'=>'INTEGER',
			'g_flood_control_access_secs'=>'INTEGER',
			'g_gift_points_base'=>'INTEGER',
			'g_gift_points_per_day'=>'INTEGER',
			'g_max_daily_upload_mb'=>'INTEGER',
			'g_max_attachments_per_post'=>'INTEGER',
			'g_max_avatar_width'=>'INTEGER',
			'g_max_avatar_height'=>'INTEGER',
			'g_max_post_length_comcode'=>'INTEGER',
			'g_max_sig_length_comcode'=>'INTEGER',
			'g_enquire_on_new_ips'=>'BINARY',
			'g_rank_image'=>'ID_TEXT',
			'g_hidden'=>'BINARY',
			'g_order'=>'INTEGER',
			'g_rank_image_pri_only'=>'BINARY',
			'g_open_membership'=>'BINARY',
			'g_is_private_club'=>'BINARY',
		));
		$GLOBALS['FORUM_DB']->create_index('f_groups','ftjoin_gname',array('g_name'));
		$GLOBALS['FORUM_DB']->create_index('f_groups','ftjoin_gtitle',array('g_title'));
		$GLOBALS['FORUM_DB']->create_index('f_groups','is_private_club',array('g_is_private_club'));
		$GLOBALS['FORUM_DB']->create_index('f_groups','is_super_admin',array('g_is_super_admin'));
		$GLOBALS['FORUM_DB']->create_index('f_groups','is_super_moderator',array('g_is_super_moderator'));
		$GLOBALS['FORUM_DB']->create_index('f_groups','is_default',array('g_is_default'));
		$GLOBALS['FORUM_DB']->create_index('f_groups','hidden',array('g_hidden'));
		$GLOBALS['FORUM_DB']->create_index('f_groups','is_presented_at_install',array('g_is_presented_at_install'));
		$GLOBALS['FORUM_DB']->create_index('f_groups','gorder',array('g_order','id'));

		// For the_zone_access table
		require_code('zones2');
		reinstall_module('adminzone','admin_permissions');

		// Make guest
		$guest_group=ocf_make_group(do_lang('GUESTS'),0,0,0,do_lang('DESCRIPTION_GUESTS'));
		// Make admin
		$administrator_group=ocf_make_group(do_lang('ADMINISTRATORS'),0,1,0,do_lang('DESCRIPTION_ADMINISTRATORS'),'ocf_rank_images/admin',NULL,NULL,NULL,0);
		// Make mod
		$super_moderator_group=ocf_make_group(do_lang('SUPER_MODERATORS'),0,0,1,do_lang('DESCRIPTION_SUPER_MODERATORS'),'ocf_rank_images/mod',NULL,NULL,NULL,0);
		// Make supermember
		$super_member_group=ocf_make_group(do_lang('SUPER_MEMBERS'),0,0,0,do_lang('DESCRIPTION_SUPER_MEMBERS'),'',NULL,NULL,NULL,0);
		// Make member
		$member_group_4=ocf_make_group(do_lang('DEFAULT_RANK_4'),0,0,0,do_lang('DESCRIPTION_MEMBERS'),'ocf_rank_images/4');
		$member_group_3=ocf_make_group(do_lang('DEFAULT_RANK_3'),0,0,0,do_lang('DESCRIPTION_MEMBERS'),'ocf_rank_images/3',$member_group_4,10000);
		$member_group_2=ocf_make_group(do_lang('DEFAULT_RANK_2'),0,0,0,do_lang('DESCRIPTION_MEMBERS'),'ocf_rank_images/2',$member_group_3,2500);
		$member_group_1=ocf_make_group(do_lang('DEFAULT_RANK_1'),0,0,0,do_lang('DESCRIPTION_MEMBERS'),'ocf_rank_images/1',$member_group_2,400);
		$member_group_0=ocf_make_group(do_lang('DEFAULT_RANK_0'),0,0,0,do_lang('DESCRIPTION_MEMBERS'),'ocf_rank_images/0',$member_group_1,100); // Not default because primary is always defaulted to this one
		// Make probation
		$probation_group=ocf_make_group(do_lang('PROBATION'),0,0,0,do_lang('DESCRIPTION_PROBATION'),'',NULL,NULL,NULL,0);
	}

	if ((is_null($upgrade_from)) && ($not_installed))
	{
		$GLOBALS['FORUM_DB']->create_table('f_categories',array(
			'id'=>'*AUTO',
			'c_title'=>'SHORT_TEXT',
			'c_description'=>'LONG_TEXT',
			'c_expanded_by_default'=>'BINARY'
		));
		$category_id=ocf_make_category(do_lang('DEFAULT_GROUPING_TITLE'),'');
		$category_id_staff=ocf_make_category(do_lang('STAFF'),'');

		$GLOBALS['FORUM_DB']->create_table('f_forums',array(
			'id'=>'*AUTO',
			'f_name'=>'SHORT_TEXT',
			'f_description'=>'LONG_TRANS',	// Comcode
			'f_category_id'=>'?AUTO_LINK', // Categories can exist on multiple forum levels and positions - wherever a forum exists, the category it uses exists too (but not forums in category which aren't at level and position)
			'f_parent_forum'=>'?AUTO_LINK',
			'f_position'=>'INTEGER', // might have been called 'f_order'=>'INTEGER' (consistent with other table's ordering fields) if we had not used f_order as a text field to determine the automatic ordering type
			'f_order_sub_alpha'=>'BINARY',
			'f_post_count_increment'=>'BINARY',
			'f_intro_question'=>'LONG_TRANS',	// Comcode
			'f_intro_answer'=>'SHORT_TEXT',	// Comcode
			'f_cache_num_topics'=>'INTEGER',
			'f_cache_num_posts'=>'INTEGER',
			'f_cache_last_topic_id'=>'?AUTO_LINK',
			'f_cache_last_title'=>'SHORT_TEXT',
			'f_cache_last_time'=>'?TIME',
			'f_cache_last_username'=>'SHORT_TEXT',
			'f_cache_last_member_id'=>'?USER',
			'f_cache_last_forum_id'=>'?AUTO_LINK',
			'f_redirection'=>'SHORT_TEXT',
			'f_order'=>'ID_TEXT',
			'f_is_threaded'=>'BINARY',
		));
		$GLOBALS['FORUM_DB']->create_index('f_forums','cache_num_posts',array('f_cache_num_posts')); // Used to find active forums
		$GLOBALS['FORUM_DB']->create_index('f_forums','subforum_parenting',array('f_parent_forum'));
		$GLOBALS['FORUM_DB']->create_index('f_forums','findnamedforum',array('f_name'));
		$GLOBALS['FORUM_DB']->create_index('f_forums','f_position',array('f_position'));
		$typical_access=array($guest_group=>4,$administrator_group=>5,$super_moderator_group=>5,$probation_group=>2,$super_member_group=>4,$member_group_0=>4,$member_group_1=>4,$member_group_2=>4,$member_group_3=>4,$member_group_4=>4);
		$staff_post_access=array($guest_group=>1,$administrator_group=>5,$super_moderator_group=>5,$probation_group=>1,$super_member_group=>2,$member_group_0=>1,$member_group_1=>1,$member_group_2=>1,$member_group_3=>1,$member_group_4=>1);
		$staff_access=array($administrator_group=>5,$super_moderator_group=>5);
		$root_forum=ocf_make_forum(do_lang('ROOT_FORUM'),'',NULL,$staff_post_access,NULL);
		//ocf_make_forum(do_lang('NEWS'),'',$category_id,$staff_post_access,$root_forum);
		ocf_make_forum(do_lang('DEFAULT_FORUM_TITLE'),'',$category_id,$typical_access,$root_forum);
		//ocf_make_forum(do_lang('_FEEDBACK'),'',$category_id,$typical_access,$root_forum);	We already have a feedback page
		ocf_make_forum(do_lang('REPORTED_POSTS_FORUM'),'',$category_id_staff,$staff_access,$root_forum);
		$trash_forum_id=ocf_make_forum(do_lang('TRASH'),'',$category_id_staff,$staff_access,$root_forum);
		ocf_make_forum(do_lang('COMMENT_FORUM_NAME'),'',$category_id,$typical_access,$root_forum,1,1,0,'','','','last_post',1);
		if (addon_installed('tickets'))
		{
			require_lang('tickets');
			ocf_make_forum(do_lang('TICKET_FORUM_NAME'),'',$category_id_staff,$staff_access,$root_forum);
		}
		$staff_forum_id=ocf_make_forum(do_lang('STAFF'),'',$category_id_staff,$staff_access,$root_forum);

		$GLOBALS['FORUM_DB']->create_table('f_topics',array(
			'id'=>'*AUTO',
			't_pinned'=>'BINARY',
			't_sunk'=>'BINARY',
			't_cascading'=>'BINARY', // Cascades to deeper forums, as an announcement
			't_forum_id'=>'?AUTO_LINK', // Null if it's a Private Topic
			't_pt_from'=>'?USER',
			't_pt_to'=>'?USER',
			't_pt_from_category'=>'SHORT_TEXT',
			't_pt_to_category'=>'SHORT_TEXT',
			't_description'=>'SHORT_TEXT',
			't_description_link'=>'SHORT_TEXT',
			't_emoticon'=>'SHORT_TEXT',
			't_num_views'=>'INTEGER',
			't_validated'=>'BINARY',
			't_is_open'=>'BINARY',
			't_poll_id'=>'?AUTO_LINK',
			't_cache_first_post_id'=>'?AUTO_LINK',
			't_cache_first_time'=>'?TIME',
			't_cache_first_title'=>'SHORT_TEXT',
			't_cache_first_post'=>'?LONG_TRANS',	// Comcode
			't_cache_first_username'=>'ID_TEXT',
			't_cache_first_member_id'=>'?USER',
			't_cache_last_post_id'=>'?AUTO_LINK',
			't_cache_last_time'=>'?TIME',
			't_cache_last_title'=>'SHORT_TEXT',
			't_cache_last_username'=>'ID_TEXT',
			't_cache_last_member_id'=>'?USER',
			't_cache_num_posts'=>'INTEGER',
		));
		$GLOBALS['FORUM_DB']->create_index('f_topics','t_num_views',array('t_num_views'));
		$GLOBALS['FORUM_DB']->create_index('f_topics','t_pt_to',array('t_pt_to'));
		$GLOBALS['FORUM_DB']->create_index('f_topics','t_pt_from',array('t_pt_from'));
		$GLOBALS['FORUM_DB']->create_index('f_topics','t_validated',array('t_validated'));
		$GLOBALS['FORUM_DB']->create_index('f_topics','in_forum',array('t_forum_id'));
		$GLOBALS['FORUM_DB']->create_index('f_topics','topic_order_time',array('t_cache_last_time'));
		$GLOBALS['FORUM_DB']->create_index('f_topics','topic_order_time_2',array('t_cache_first_time'));
		$GLOBALS['FORUM_DB']->create_index('f_topics','#t_description',array('t_description'));
		$GLOBALS['FORUM_DB']->create_index('f_topics','descriptionsearch',array('t_description'));
		$GLOBALS['FORUM_DB']->create_index('f_topics','forumlayer',array('t_cache_first_title'));
		$GLOBALS['FORUM_DB']->create_index('f_topics','t_cascading',array('t_cascading'));
		$GLOBALS['FORUM_DB']->create_index('f_topics','t_cascading_or_forum',array('t_cascading','t_forum_id'));
		$GLOBALS['FORUM_DB']->create_index('f_topics','topic_order',array('t_cascading','t_pinned','t_cache_last_time')); // Ordering for forumview, is picked up over topic_order_3 for just the ordering bit (it seems)
		$GLOBALS['FORUM_DB']->create_index('f_topics','topic_order_2',array('t_forum_id','t_cascading','t_pinned','t_sunk','t_cache_last_time')); // Total index for forumview, including ordering. Doesn't work on current MySQL.
		$GLOBALS['FORUM_DB']->create_index('f_topics','topic_order_3',array('t_forum_id','t_cascading','t_pinned','t_cache_last_time')); // Total index for forumview, including ordering. Works if disable_sunk is turned on.
		$GLOBALS['FORUM_DB']->create_index('f_topics','ownedtopics',array('t_cache_first_member_id'));
		$GLOBALS['FORUM_DB']->create_index('f_topics','unread_forums',array('t_forum_id','t_cache_last_time'));

		// Welcome topic
		$topic_id=ocf_make_topic($staff_forum_id,'','',1,1,0,0,0,NULL,NULL,false);

		$GLOBALS['FORUM_DB']->create_table('f_posts',array(
			'id'=>'*AUTO',
			'p_title'=>'SHORT_TEXT',
			'p_post'=>'LONG_TRANS',	// Comcode
			'p_ip_address'=>'IP',
			'p_time'=>'TIME',
			'p_poster'=>'USER',
			'p_intended_solely_for'=>'?USER',
			'p_poster_name_if_guest'=>'ID_TEXT',
			'p_validated'=>'BINARY',
			'p_topic_id'=>'AUTO_LINK',
			'p_cache_forum_id'=>'?AUTO_LINK', // Null if for a PT
			'p_last_edit_time'=>'?TIME',
			'p_last_edit_by'=>'?USER',
			'p_is_emphasised'=>'BINARY',
			'p_skip_sig'=>'BINARY',
			'p_parent_id'=>'?AUTO_LINK'
		));
		$GLOBALS['FORUM_DB']->create_index('f_posts','p_validated',array('p_validated'));
		$GLOBALS['FORUM_DB']->create_index('f_posts','in_topic',array('p_topic_id','p_time','id'));
		$GLOBALS['FORUM_DB']->create_index('f_posts','post_order_time',array('p_time','id'));
		$GLOBALS['FORUM_DB']->create_index('f_posts','posts_since',array('p_time','p_cache_forum_id')); // p_cache_forum_id is used to not count PT posts
		$GLOBALS['FORUM_DB']->create_index('f_posts','p_last_edit_time',array('p_last_edit_time'));
		$GLOBALS['FORUM_DB']->create_index('f_posts','posts_by',array('p_poster'));
		$GLOBALS['FORUM_DB']->create_index('f_posts','find_pp',array('p_intended_solely_for'));
		$GLOBALS['FORUM_DB']->create_index('f_posts','search_join',array('p_post'));
		$GLOBALS['FORUM_DB']->create_index('f_posts','postsinforum',array('p_cache_forum_id'));
		$GLOBALS['FORUM_DB']->create_index('f_posts','deletebyip',array('p_ip_address'));
	}

	if ((((is_null($upgrade_from)) && ($not_installed)) || (((!is_null($upgrade_from)) && ($upgrade_from<4.0)))))
	{
		$GLOBALS['FORUM_DB']->create_table('f_special_pt_access',array(
			's_member_id'=>'*USER',
			's_topic_id'=>'*AUTO_LINK',
		));

		$GLOBALS['FORUM_DB']->create_table('f_saved_warnings',array(
			's_title'=>'*SHORT_TEXT',
			's_explanation'=>'LONG_TEXT',
			's_message'=>'LONG_TEXT',
		));
	}

	if ((((is_null($upgrade_from)) && ($not_installed)) || (($upgrade_from<2.5))))
	{
		$GLOBALS['FORUM_DB']->create_table('f_post_history',array(
			'id'=>'*AUTO',
			'h_create_date_and_time'=>'TIME',
			'h_action_date_and_time'=>'TIME',
			'h_owner_member_id'=>'USER',
			'h_alterer_member_id'=>'USER',
			'h_post_id'=>'AUTO_LINK',
			'h_topic_id'=>'AUTO_LINK',
			'h_before'=>'LONG_TEXT',
			'h_action'=>'ID_TEXT'
		));
		$GLOBALS['FORUM_DB']->create_index('f_post_history','phistorylookup',array('h_post_id'));

		$GLOBALS['FORUM_DB']->create_table('f_forum_intro_ip',array(
			'i_forum_id'=>'*AUTO_LINK',
			'i_ip'=>'*IP'
		));

		$GLOBALS['FORUM_DB']->create_table('f_forum_intro_member',array(
			'i_forum_id'=>'*AUTO_LINK',
			'i_member_id'=>'*USER'
		));

		$GLOBALS['FORUM_DB']->create_table('f_post_templates',array(
			'id'=>'*AUTO',
			't_title'=>'SHORT_TEXT',
			't_text'=>'LONG_TEXT',
			't_forum_multi_code'=>'SHORT_TEXT',
			't_use_default_forums'=>'BINARY'
		));
		ocf_make_post_template(do_lang('DEFAULT_POST_TEMPLATE_bug_title'),do_lang('DEFAULT_POST_TEMPLATE_bug_text'),'',0);
		ocf_make_post_template(do_lang('DEFAULT_POST_TEMPLATE_task_title'),do_lang('DEFAULT_POST_TEMPLATE_task_text'),'',0);
		ocf_make_post_template(do_lang('DEFAULT_POST_TEMPLATE_fault_title'),do_lang('DEFAULT_POST_TEMPLATE_fault_text'),'',0);

		$GLOBALS['FORUM_DB']->create_index('f_posts','#p_title',array('p_title'));
	}

	if ((is_null($upgrade_from)) && ($not_installed))
	{
		$GLOBALS['FORUM_DB']->create_table('f_polls',array(
			'id'=>'*AUTO',
			'po_question'=>'SHORT_TEXT',
			'po_cache_total_votes'=>'INTEGER',
			'po_is_private'=>'BINARY',
			'po_is_open'=>'BINARY',
			'po_minimum_selections'=>'INTEGER',
			'po_maximum_selections'=>'INTEGER',
			'po_requires_reply'=>'BINARY'
		));

		$GLOBALS['FORUM_DB']->create_table('f_poll_answers',array(
			'id'=>'*AUTO',
			'pa_poll_id'=>'AUTO_LINK',
			'pa_answer'=>'SHORT_TEXT',
			'pa_cache_num_votes'=>'INTEGER'
		));

		$GLOBALS['FORUM_DB']->create_table('f_poll_votes',array(
			'pv_poll_id'=>'*AUTO_LINK',
			'pv_member_id'=>'*USER',
			'pv_answer_id'=>'*AUTO_LINK' // -1 means "forfeited". We'd use NULL, but we aren't allowed NULL fragments in keys
		));

		$GLOBALS['FORUM_DB']->create_table('f_multi_moderations',array(
			'id'=>'*AUTO',
			'mm_name'=>'*SHORT_TRANS',
			'mm_post_text'=>'LONG_TEXT',	// Comcode
			'mm_move_to'=>'?INTEGER',
			'mm_pin_state'=>'?BINARY',
			'mm_sink_state'=>'?BINARY',
			'mm_open_state'=>'?BINARY',
			'mm_forum_multi_code'=>'SHORT_TEXT',
			'mm_title_suffix'=>'SHORT_TEXT'
		));
		ocf_make_multi_moderation(do_lang('TRASH'),'',$trash_forum_id,0,0,0);

		$GLOBALS['FORUM_DB']->create_table('f_warnings',array(
			'id'=>'*AUTO',
			'w_member_id'=>'USER',
			'w_time'=>'TIME',
			'w_explanation'=>'LONG_TEXT',
			'w_by'=>'USER',
			'w_is_warning'=>'BINARY',
			'p_silence_from_topic'=>'?AUTO_LINK',
			'p_silence_from_forum'=>'?AUTO_LINK',
			'p_probation'=>'INTEGER',
			'p_banned_ip'=>'IP',
			'p_charged_points'=>'INTEGER',
			'p_banned_member'=>'BINARY',
			'p_changed_usergroup_from'=>'?GROUP',
		));
		$GLOBALS['FORUM_DB']->create_index('f_warnings','warningsmemberid',array('w_member_id'));

		$GLOBALS['FORUM_DB']->create_table('f_moderator_logs',array(
			'id'=>'*AUTO',
			'l_the_type'=>'ID_TEXT', // Language identifier
			'l_param_a'=>'SHORT_TEXT',
			'l_param_b'=>'SHORT_TEXT',
			'l_date_and_time'=>'TIME',
			'l_reason'=>'LONG_TEXT',
			'l_by'=>'USER'
		));

		$GLOBALS['FORUM_DB']->create_table('f_member_known_login_ips',array(
			'i_member_id'=>'*USER',
			'i_ip'=>'*IP',
			'i_val_code'=>'SHORT_TEXT'
		));

		if (strtoupper(ocp_srv('REQUEST_METHOD'))!='POST') exit(); // Needed as YSlow can load as GET's in background and cause horrible results
		// NB: post_param's will return default's if OCF is being installed but not used yet (e.g. IPB forum driver chosen at installation)
		// Make guest
		ocf_make_member(do_lang('GUEST'),'','',NULL,NULL,NULL,NULL,array(),NULL,$guest_group,1,time(),time(),'',NULL,'',0,1,1,'','','',1,0,'',1,1,'',NULL,'',false);
		// Make admin user
		ocf_make_member(post_param('admin_username','admin'),post_param('ocf_admin_password','admin'),'',NULL,NULL,NULL,NULL,array(),NULL,$administrator_group,1,time(),time(),'','themes/default/images/ocf_default_avatars/default_set/cool_flare.png','',0,0,1,'','','',1,1,'',1,1,'',NULL,'',false);
		// Make test user
		ocf_make_member('test',post_param('ocf_admin_password','admin'),'',NULL,NULL,NULL,NULL,array(),NULL,$member_group_0,1,time(),time(),'',NULL,'',0,0,1,'','','',1,0,'',1,1,'',NULL,'',false);

		$GLOBALS['FORUM_DB']->create_table('f_read_logs',array(
			'l_member_id'=>'*USER',
			'l_topic_id'=>'*AUTO_LINK',
			'l_time'=>'TIME'
		));
		$GLOBALS['FORUM_DB']->create_index('f_read_logs','erase_old_read_logs',array('l_time'));

		ocf_make_post($topic_id,do_lang('DEFAULT_POST_TITLE'),do_lang('DEFAULT_POST_CONTENT'),0,true,1,0,do_lang('SYSTEM'),'127.0.0.1',time(),$GLOBALS['OCF_DRIVER']->get_guest_id(),NULL,NULL,NULL,false,true);
	}

	// Permissions have to be done after usergroups
	if (is_null($upgrade_from))
	{
		// Add privileges
		global $OCF_TRUE_PERMISSIONS,$OCF_FALSE_PERMISSIONS;
		foreach ($OCF_TRUE_PERMISSIONS as $permission)
		{
			add_specific_permission('SECTION_FORUMS',$permission,true);
		}
		foreach ($OCF_FALSE_PERMISSIONS as $permission)
		{
			add_specific_permission('SECTION_FORUMS',$permission,false,($permission=='view_other_pt'));
		}
	}

	if ((!is_null($upgrade_from)) && ($upgrade_from<3.1))
	{
		add_specific_permission('SECTION_FORUMS','use_special_emoticons',false);
	}
	if ((!is_null($upgrade_from)) && ($upgrade_from<4.0))
	{
		add_specific_permission('SECTION_FORUMS','member_maintenance',false);
		add_specific_permission('SECTION_FORUMS','probate_members',false);
		add_specific_permission('SECTION_FORUMS','own_avatars',true);
		//add_specific_permission('SECTION_FORUMS','decide_comment_type',true); if we add threads
		add_specific_permission('SECTION_FORUMS','control_usergroups',false,true);
		add_specific_permission('SECTION_FORUMS','edit_personal_topic_posts',true);
		add_specific_permission('SECTION_FORUMS','multi_delete_topics',false);
		add_specific_permission('SECTION_FORUMS','show_user_browsing',false);
		add_specific_permission('SECTION_FORUMS','see_hidden_groups',false);
		add_specific_permission('SECTION_FORUMS','pt_anyone',false);
	}
	if ((!is_null($upgrade_from)) && ($upgrade_from<3.0))
	{
		add_specific_permission('SECTION_FORUMS','view_profiles',true);
	}
	if ((!is_null($upgrade_from)) && ($upgrade_from<2.5))
	{
		add_specific_permission('SECTION_FORUMS','moderate_personal_topic',false);
		add_specific_permission('SECTION_FORUMS','disable_lost_passwords',false);
		add_specific_permission('SECTION_FORUMS','view_any_profile_field',false);
		add_specific_permission('SECTION_FORUMS','rename_self',true);
		add_specific_permission('SECTION_FORUMS','double_post',false);
		add_specific_permission('SECTION_FORUMS','close_own_topics',false);
		add_specific_permission('SECTION_FORUMS','edit_own_polls',true);
		add_specific_permission('SECTION_FORUMS','warn_members',false);
		add_specific_permission('SECTION_FORUMS','see_warnings',false);
		add_specific_permission('SECTION_FORUMS','see_ip',false);
		add_specific_permission('SECTION_FORUMS','may_choose_custom_title',false);
		add_specific_permission('SECTION_FORUMS','delete_account',false);
		add_specific_permission('SECTION_FORUMS','view_other_pt',false);
		add_specific_permission('SECTION_FORUMS','view_poll_results_before_voting',false);
		add_specific_permission('SECTION_FORUMS','may_unblind_own_poll',true);

		delete_specific_permission('enquire_on_new_ips');
	}
}


