<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		core
 */

/**
 * Process a login.
 *
 * @param  ID_TEXT		Username
 */
function handle_active_login($username)
{
	global $SESSION_CACHE;

	$result=array();

	$member_cookie_name=get_member_cookie();
	$colon_pos=strpos($member_cookie_name,':');

	if ($colon_pos!==false)
	{
		$base=substr($member_cookie_name,0,$colon_pos);
		$real_member_cookie=substr($member_cookie_name,$colon_pos+1);
		$real_pass_cookie=substr(get_pass_cookie(),$colon_pos+1);
		$serialized=true;
	} else
	{
		$real_member_cookie=get_member_cookie();
		$base=$real_member_cookie;
		$real_pass_cookie=get_pass_cookie();
		$serialized=false;
	}

	$password=trim(post_param('password'));
	$login_array=$GLOBALS['FORUM_DRIVER']->forum_authorise_login($username,NULL,my_md5($password,$username),$password);
	$id=$login_array['id'];

	// Run hooks, if any exist
	$hooks=find_all_hooks('systems','upon_login');
	foreach (array_keys($hooks) as $hook)
	{
		require_code('hooks/systems/upon_login/'.filter_naughty($hook));
		$ob=object_factory('upon_login'.filter_naughty($hook),true);
		if (is_null($ob)) continue;
		$ob->run(true,$username,$id); // true means "a new login attempt"
	}

	if (!is_null($id)) // Valid user
	{
		$old_session=get_session_id();
		if ((!is_null($old_session)) && ($old_session!=-1))
		{
			$GLOBALS['SITE_DB']->query_delete('sessions',array('the_session'=>$old_session,'the_user'=>$GLOBALS['FORUM_DRIVER']->get_guest_id(),'ip'=>get_ip_address(3)),'',1);

			if ((array_key_exists($old_session,$SESSION_CACHE)) && ($SESSION_CACHE[$old_session]['the_user']==$GLOBALS['FORUM_DRIVER']->get_guest_id()) && ($SESSION_CACHE[$old_session]['ip']==get_ip_address(3)))
			{
				unset($SESSION_CACHE[$old_session]);
				persistant_cache_set('SESSION_CACHE',$SESSION_CACHE);
			}
		}

		// Store the cookies
		$remember=post_param_integer('remember',0);
		if ($remember==1)
		{
			global $IS_A_COOKIE_LOGIN;
			$IS_A_COOKIE_LOGIN=true;

			// Create user cookie
			if (method_exists($GLOBALS['FORUM_DRIVER'],'forum_create_cookie'))
			{
				$GLOBALS['FORUM_DRIVER']->forum_create_cookie($id,NULL,$password);
			}
			else
			{
				if ($GLOBALS['FORUM_DRIVER']->is_cookie_login_name())
				{
					$name=$GLOBALS['FORUM_DRIVER']->get_username($id);
					if ($serialized)
					{
						$result[$real_member_cookie]=$name;
					} else
					{
						ocp_setcookie(get_member_cookie(),$name,false,true);
						$_COOKIE[get_member_cookie()]=$name;
					}
				} else
				{
					if ($serialized)
					{
						$result[$real_member_cookie]=$id;
					} else
					{
						ocp_setcookie(get_member_cookie(),strval($id),false,true);
						$_COOKIE[get_member_cookie()]=strval($id);
					}
				}

				// Create password cookie
				if (!$serialized)
				{
					if ($GLOBALS['FORUM_DRIVER']->is_hashed())
					{
						ocp_setcookie(get_pass_cookie(),my_md5($password,$username),false,true);
					}
					else
					{
						ocp_setcookie(get_pass_cookie(),$password,false,true);
					}
				} else
				{
					if ($GLOBALS['FORUM_DRIVER']->is_hashed()) $result[$real_pass_cookie]=my_md5($password,$username); else $result[$real_pass_cookie]=$password;
					$_result=serialize($result);
					ocp_setcookie($base,$_result,false,true);
				}
			}
		}

		// Store as logged in....

		global $MEMBER_CACHED;
		$MEMBER_CACHED=$id;
		if (addon_installed('points'))
		{
			$points_per_daily_visit=intval(get_option('points_per_daily_visit',true));
			if ($points_per_daily_visit!=0)
			{
				// See if this is the first visit today
				$test=$GLOBALS['SITE_DB']->query_value('stats','MAX(date_and_time)',array('the_user'=>$id));
				if ($test<time()-60*60*24)
				{
					require_code('points');
					$_before=point_info($id);
					$GLOBALS['FORUM_DRIVER']->set_custom_field($id,'points_gained_given',strval(intval($_before['points_gained_given'])+$points_per_daily_visit));
				}
			}
		}

		// Create a session
/*		$no_sessions=post_param_integer('no_sessions',0);
		if ($no_sessions==0)
		{*/
			// Delete expired sessions
			$GLOBALS['SITE_DB']->query('DELETE FROM '.get_table_prefix().'sessions WHERE last_activity<'.strval(time()-60*60*max(1,intval(get_option('session_expiry_time')))));

			$new_session=NULL;
			$dirty_session_cache=false;
			foreach ($SESSION_CACHE as $_session=>$row)
			{
				// Delete expiry from cache
				if ($row['last_activity']<time()-60*60*max(1,intval(get_option('session_expiry_time'))))
				{
					$dirty_session_cache=true;
					unset($SESSION_CACHE[$_session]);
					continue;
				}

				// Get back to prior session if there was one
				if ($row['the_user']==$id)
				{
					$new_session=$_session;
				}
			}
			if ($dirty_session_cache)
			{
				persistant_cache_set('SESSION_CACHE',$SESSION_CACHE);
			}

			if (is_null($new_session))
			{
				// Generate random session
				$new_session=mt_rand(0,10000000);

				// Store session
				$row=array('the_session'=>$new_session,'last_activity'=>time(),'the_user'=>$id,'ip'=>get_ip_address(3),'session_confirmed'=>1,'session_invisible'=>post_param_integer('login_invisible',0),'cache_username'=>$GLOBALS['FORUM_DRIVER']->get_username($id),'the_title'=>'','the_zone'=>get_zone_name(),'the_page'=>get_page_name(),'the_type'=>get_param('type',''),'the_id'=>either_param('id',''));
				$GLOBALS['SITE_DB']->query_insert('sessions',$row);
				$SESSION_CACHE[$new_session]=$row;
			} else
			{
				$row=array('session_invisible'=>post_param_integer('login_invisible',0),'last_activity'=>time(),'ip'=>get_ip_address(3),'session_confirmed'=>1);
				$GLOBALS['SITE_DB']->query_update('sessions',$row,array('the_session'=>$new_session),'',1);
				$SESSION_CACHE[$new_session]=array_merge($SESSION_CACHE[$new_session],$row);
			}

			persistant_cache_set('SESSION_CACHE',$SESSION_CACHE);

			require_code('users_inactive_occasionals');
			set_session_id($new_session);

			global $SESSION_CONFIRMED;
			$SESSION_CONFIRMED=1;
//		}
	} else
	{
                $subscriptionActive = ($login_array['subscription_not_started'] || $login_array['subsequent_subscription_payment_failed']) ?  false : true;

                //Log the failed login attempts for the subscription active member accounts.
                //The members who are not started the subscription are redirected to the payment page and so no meed
                //to log the detail.
                if ($subscriptionActive) {
                    $GLOBALS['SITE_DB']->query_insert('failedlogins',array('failed_account'=>trim(post_param('login_username')),'date_and_time'=>time(),'ip'=>get_ip_address()));
                    $count=$GLOBALS['SITE_DB']->query_value_null_ok_full('SELECT COUNT(*) FROM '.get_table_prefix().'failedlogins WHERE date_and_time>'.strval(time()-60*60*15).' AND '.db_string_equal_to('ip',get_ip_address()));
                    if ($count>30) log_hack_attack_and_exit('BRUTEFORCE_LOGIN_HACK');
                }
	}
}

