<?php

/**
 * Check whether the member has already submitted credit card detail.
 *
 * @param  ID_TEXT	MEMBER ID.
 * @return boolean
 */
function is_credit_card_detail_for_member($memberId)
{
	$value_check = $GLOBALS['FORUM_DB']->query_value_null_ok('creditcard','c_id',array('c_memberid'=>$memberId));
	return ($value_check) ? true : false;
}

/**
 * Enter encrypted credit card number for member.
 *
 * @param  ID_TEXT	MEMBER ID.
 * @param  NUMBER	CREDIT CARD NUMBER.
 * @return boolean
 */
function enter_encrypted_credit_card_number($memberId,$cardNumber)
{
	require_code('ecommerce');
	$key = get_encryption_key_for_credit_card_number();

	if (get_db_type()=='xml')
	{
	   $sql = 'UPDATE '.get_table_prefix().'creditcard SET c_card_number= "'.db_escape_string($cardNumber).'" WHERE c_memberid='.intval($memberId);
	} else
	{
	   $sql = 'UPDATE '.get_table_prefix().'creditcard SET c_card_number= AES_ENCRYPT("'.db_escape_string($cardNumber).'", "'.db_escape_string($key).'") WHERE c_memberid='.intval($memberId);
	}

	$GLOBALS['FORUM_DB']->query($sql);
}

/**
 * Get decrypted credit card number for member.
 *
 * @param  ID_TEXT	MEMBER ID.
 * @return NUMBER
 */
function get_decrypted_credit_card_number($memberId)
{
	require_code('ecommerce');
	$key = get_encryption_key_for_credit_card_number();

	if (get_db_type()=='xml')
	{
	   $sql = 'SELECT c_card_number FROM '.get_table_prefix().'creditcard WHERE c_memberid='.intval($memberId);
	} else
	{
	   $sql = 'SELECT AES_DECRYPT(c_card_number,"'.$key.'") AS c_card_number FROM '.get_table_prefix().'creditcard WHERE c_memberid='.intval($memberId);
	}

	$creditCardNumber = $GLOBALS['FORUM_DB']->query($sql);

	return $creditCardNumber[0]['c_card_number'];
}

/**
 * Enter credit card detail for member.
 *
 * @param  ID_TEXT	MEMBER ID.
 * @param  NUMBER	CREDIT CARD NUMBER.
 * @param  NUMBER	EXPIRY MONTH
 * @param  NUMBER	EXPIRY YEAR
 * @return boolean
 */
function enter_credit_card_detail_for_member($memberId,$cardNumber,$expiryMonth,$expiryYear,$address)
{
	require_code('ecommerce');
	$key = get_encryption_key_for_credit_card_number();

	if (is_credit_card_detail_for_member($memberId))
	{
		if (get_db_type()=='xml')
		{
		   $sql = 'UPDATE '.get_table_prefix().'creditcard SET c_card_number= "'.db_escape_string($cardNumber).'",c_expiry_month= '.intval($expiryMonth).',c_expiry_year= '.intval($expiryYear).',c_address= "'.db_escape_string($address).'" WHERE c_memberid='.intval($memberId);
		} else
		{
		   $sql = 'UPDATE '.get_table_prefix().'creditcard SET c_card_number= AES_ENCRYPT("'.db_escape_string($cardNumber).'", "'.db_escape_string($key).'"),c_expiry_month= '.intval($expiryMonth).',c_expiry_year= '.intval($expiryYear).',c_address= "'.db_escape_string($address).'" WHERE c_memberid='.intval($memberId);
		}
	} else
	{
		if (get_db_type()=='xml')
		{
		   $sql = 'INSERT INTO '.get_table_prefix().'creditcard (c_card_number,c_expiry_month,c_expiry_year,c_address,c_memberid) VALUES("'.db_escape_string($cardNumber).'",'.intval($expiryMonth).','.intval($expiryYear).','.db_escape_string($address).'",'.intval($memberId).')';
		} else
		{
		   $sql = 'INSERT INTO '.get_table_prefix().'creditcard (c_card_number,c_expiry_month,c_expiry_year,c_address,c_memberid) VALUES(AES_ENCRYPT("'.db_escape_string($cardNumber).'", "'.db_escape_string($key).'"),'.intval($expiryMonth).','.intval($expiryYear).','.db_escape_string($address).'",'.intval($memberId).')';
		}
	}

	enter_encrypted_credit_card_number($memberId,$cardNumber);
}

/**
 * Check whether the member has been alotted free subscription by admin
 *
 * @param MEMBER ID
 * @return bool
 */
function is_member_alotted_free_subscription_by_admin($member_id)
{
	$isEligible = false;
	$member_row = $GLOBALS['FORUM_DRIVER']->get_member_row($member_id);

	if ($member_row['m_avoid_subscription'] == 1) {
		$isEligible = true;
	}
	return $isEligible;
}

/**
 * Check whether the member is currenlty in 30 days trial period
 *
 * @param MEMBER ID
 * @return bool
 */
function is_member_in_trial_preriod($member_id)
{
	$member_row 			= $GLOBALS['FORUM_DRIVER']->get_member_row($member_id);
	$trial_period_expiry	=	$member_row['m_join_time']+intval(60*60*24*30);

	if($trial_period_expiry>time()) return true; else return false;
}

/**
 * Function to find weather user joined in a free account user group or not
 *
 *	@param	Array		Member array
 * @return	BINARY	User in free account or not
 */
function is_member_in_free_account_type($row)
{
	if (!array_key_exists('account_type',$row)) return true;
	if($row['account_type']=='basic' || $row['account_type']=='fan')	return true; else	return false;
}

/**
 * Function to unvalidate pro contents of a member
 *
 *	@param	USER		Member Id
 */
function delete_pro_contents($member_id)
{
	if ($member_id==db_get_first_id()) return;
	if (is_null($member_id)) return;
	
	if(!is_null($GLOBALS['SITE_DB']->query_value_null_ok('catalogues','c_title',array('c_name'=>'store_'.strval($member_id)))))
	{
		require_code('catalogues2');
		actual_delete_catalogue('store_'.strval($member_id));
	}

	//delete films and musics
	$rows	=	$GLOBALS['SITE_DB']->query_select('galleries',array('name'),array('accept_videos'=>1,'g_owner'=>$member_id));
	if(!array_key_exists(0,$rows))	return;
	require_code('galleries2');
	foreach($rows as $gallery)
	{
		delete_gallery($gallery['name']);
	}
}

/**
 * Function to find user have pro access
 *
 *	@param	USER		Member
 * @return	BINARY	User in pro or not
 */
function has_pro_account_access($member_id)
{
	$account_type	=	$GLOBALS['OCF_DRIVER']->get_member_row_field($member_id,'account_type');
	if($account_type=='pro')	return true; else	return false;
}

/**
 * Get the database table row for active subscription
 * (Row for a subscription)
 *
 * @param  ID     The member id
 * @return ARRAY  The table row
 */
function get_member_active_subscription_row($member_id)
{
	$sql = "SELECT * FROM ".get_table_prefix()."subscriptions WHERE `s_member_id`='$member_id' AND `s_type_code`= 'site_subscription' AND `s_state`='active'";

   $result = $GLOBALS['FORUM_DB']->query($sql);

	return ($result) ? $result[0] : NULL;
}
