<?php


	/**
	 * Find if the given member id and password is valid. If username is NULL, then the member id is used instead.
	 * All authorisation, cookies, and form-logins, are passed through this function.
	 * Some forums do cookie logins differently, so a Boolean is passed in to indicate whether it is a cookie login.
	 *
	 * @param  ?SHORT_TEXT	The member username (NULL: don't use this in the authentication - but look it up using the ID if needed)
	 * @param  ?MEMBER		The member id (NULL: use member name)
	 * @param  MD5				The md5-hashed password
	 * @param  string			The raw password
	 * @param  boolean		Whether this is a cookie login
	 * @return array			A map of 'id' and 'error'. If 'id' is NULL, an error occured and 'error' is set
	 */
	function forum_authorise_login($username,$userid,$password_hashed,$password_raw,$cookie_login=false)
	{
		require_code('ocf_members');
		require_code('ocf_groups');
      require_code('ocf_members_action2');

		if (!function_exists('require_lang')) require_code('lang');
		require_lang('ocf');
		require_code('mail');

		$out=array();
		$out['id']=NULL;
		$out['subscription_not_started']=false;
		$out['subsequent_subscription_payment_failed']=false;
		$out['trial_period_expired']=false;
		$out['member_in_free_account']=false;
		$out['inactive_account']=false;

		$skip_auth=false;
		

		if (is_null($userid))
		{
			/*if ((strpos($username,'.')!==false) && (strpos($username,'@')!==false))
			{
				if (get_option('allow_member_integration')=='off')
				{
					$out['error']=(do_lang_tempcode('NO_REMOTE_ON'));
					return $out;
				}

				if (preg_match('#//'.str_replace('#','\\#',preg_quote(ocp_srv('HTTP_HOST'))).'[/$]#',get_base_url())==0)
				{
					warn_exit(do_lang_tempcode('INT_WRONG_BASE_URL')); // Security issue
				}

				$result=http_download_file('http://ocproducts.com/uploads/website_specific/ocproducts.com/scripts/members.php?email='.urlencode($username).'&domain='.urlencode(ocp_srv('HTTP_HOST')).'&password='.$password_hashed);
				switch ($result)
				{
					case 'password':
						$out['error']=(do_lang_tempcode('USER_BAD_PASSWORD_INT',escape_html('http://ocproducts.com/personalzone/index.php?page=generate_password&type=generate&domain='.urlencode(ocp_srv('HTTP_HOST')))));
						return $out;

					case 'missing':
						$out['error']=(do_lang_tempcode('USER_NO_EXIST_INT',escape_html('http://ocproducts.com/index.php?page=join')));
						return $out;

					default:
						list($member_row,$cpf)=unserialize($result);
						$member_rows=$GLOBALS['FORUM_DB']->query_select('f_members',array('id','m_password_compat_scheme'),array('m_username'=>$member_row['m_username']));
						if (array_key_exists(0,$member_rows))
						{
							$password_compat_scheme=$member_rows[0]['m_password_compat_scheme'];
							if ($password_compat_scheme!='remote')
							{
								$out['error']=(do_lang_tempcode('USERNAME_LOCAL_REMOTE_CONFLICT'));
							}

							if (!$cookie_login)
							{
								// Resync (don't resync CPFs which are user-editable here)
								require_code('ocf_members_action');
								require_code('ocf_members_action2');
								$possible_fields=ocf_get_all_custom_fields_match($GLOBALS['OCF_DRIVER']->get_members_groups($member_rows[0]['id']),NULL,NULL,false);
								$custom_fields=array();
								foreach ($possible_fields as $_possible_field)
								{
									$possible_field=$_possible_field['trans_name'];
									if (array_key_exists($possible_field,$cpf)) $custom_fields[$possible_field]=$cpf[$possible_field];
								}

								if (post_param_integer('finishing_profile',0)==1)
								{
									$dob_day=post_param_integer('dob_day');
									$dob_month=post_param_integer('dob_month');
									$dob_year=post_param_integer('dob_year');
									$reveal_age=post_param_integer('reveal_age',0);

									$custom_fields=$custom_fields+ocf_read_in_custom_fields(ocf_get_all_custom_fields_match(ocf_get_all_default_groups(true),NULL,NULL,NULL,1));
								} else
								{
									$dob_day=NULL;
									$dob_month=NULL;
									$dob_year=NULL;
									$reveal_age=NULL;
								}

								ocf_edit_member($member_rows[0]['id'],$username,$member_row['m_preview_posts'],$dob_day,$dob_month,$dob_year,$member_row['m_timezone_offset']-floatval(get_value('timezone')),NULL,$custom_fields,NULL,$reveal_age,$member_row['m_views_signatures'],$member_row['m_track_contributed_topics'],$member_row['m_language'],NULL,NULL,$member_row['m_username'],NULL,NULL,NULL,NULL,NULL);
							}

							$username=$member_row['m_username'];
						} else
						{
							// Copy to new
							require_code('ocf_members_action');
							require_code('ocf_members_action2');
							$possible_fields=ocf_get_all_custom_fields_match(ocf_get_all_default_groups(true),NULL,NULL,NULL);
							$custom_fields=array();
							foreach ($possible_fields as $_possible_field)
							{
								$possible_field=$_possible_field['trans_name'];
								if (array_key_exists($possible_field,$cpf)) $custom_fields[$_possible_field['id']]=$cpf[$possible_field];
							}
							ocf_make_member($member_row['m_username'],$password_hashed,$member_row['m_email_address'],NULL,NULL,NULL,NULL,$custom_fields,$member_row['m_timezone_offset']-floatval(get_value('timezone')),NULL,1,NULL,NULL,'',$member_row['m_avatar_url'],$member_row['m_signature'],0,$member_row['m_preview_posts'],1,$member_row['m_title'],$member_row['m_photo_url'],$member_row['m_photo_thumb_url'],$member_row['m_views_signatures'],$member_row['m_track_contributed_topics'],$member_row['m_language'],1,'',NULL,'',false,'remote','',$member_row['m_zone_wide']);

							// Get extra details
							if (post_param_integer('finishing_profile',0)==0)
							{
								if (!function_exists('do_header')) require_code('site');
								$middle=ocf_member_external_linker_ask($member_row['m_username'],'remote',$username);
								$tpl=globalise($middle,NULL,'',true);
								$tpl->evaluate_echo();
								exit();
							}

							$username=$member_row['m_username'];
						}

						$skip_auth=true;
				}
			}*/

			$rows=$this->connection->query('SELECT * FROM '.$this->connection->get_table_prefix().'f_members WHERE '.db_string_equal_to('m_username',$username),1);
			if ((!array_key_exists(0,$rows)) && (get_option('one_per_email_address')=='1'))
			{
				$rows=$this->connection->query('SELECT * FROM '.$this->connection->get_table_prefix().'f_members WHERE '.db_string_equal_to('m_email_address',$username).' ORDER BY id ASC',1);
			}
			if (array_key_exists(0,$rows))
			{
				$this->MEMBER_ROWS_CACHED[$rows[0]['id']]=$rows[0];
				$userid=$rows[0]['id'];
			}
		} else
		{
			$rows[0]=$this->get_member_row($userid);
		}

		// LDAP to the rescue if we couldn't get a row
		global $LDAP_CONNECTION;
		if ((!array_key_exists(0,$rows)) && (!is_null($LDAP_CONNECTION)) && (is_null($userid)))
		{
			// See if LDAP has it -- if so, we can add
			$test=ocf_is_on_ldap($username);
			if (!$test)
			{
				$out['error']=(do_lang_tempcode('_USER_NO_EXIST',escape_html($username)));
				return $out;
			}

			$test_auth=ocf_ldap_authorise_login($username,$password_raw);
			if ($test_auth['m_pass_hash_salted']=='!!!')
			{
				$out['error']=(do_lang_tempcode('USER_BAD_PASSWORD'));
				return $out;
			}

			if ($test)
			{
				require_code('ocf_members_action');
				require_code('ocf_members_action2');
				if (trim(post_param('email_address',''))=='')
				{
					@ob_end_clean();
					if (!function_exists('do_header')) require_code('site');
					$middle=ocf_member_external_linker_ask($username,'ldap',ocf_ldap_guess_email($username));
					$tpl=globalise($middle,NULL,'',true);
					$tpl->evaluate_echo();
					exit();
				} else
				{
					$userid=ocf_member_external_linker($username,uniqid(''),'ldap');
					$row=$this->get_member_row($userid);
				}
			}
		}

		if ((!array_key_exists(0,$rows)) || (is_null($rows[0]))) // All hands to lifeboats
		{
			$out['error']=(do_lang_tempcode('_USER_NO_EXIST',escape_html($username)));
			return $out;
		}
		$row=$rows[0];

		// Now LDAP can kick in and get the correct hash
		if (ocf_is_ldap_member($userid))
		{
			//$rows[0]['m_pass_hash_salted']=ocf_get_ldap_hash($userid);

			// Doesn't exist any more? This is a special case - the 'LDAP member' exists in our DB, but not LDAP. It has been deleted from LDAP or LDAP server has jumped
			/*if (is_null($rows[0]['m_pass_hash_salted']))
			{
				$out['error']=(do_lang_tempcode('_USER_NO_EXIST',$username));
				return $out;
			} No longer appropriate with new authentication mode - instead we just have to give an invalid password message  */

			$row=array_merge($row,ocf_ldap_authorise_login($username,$password_hashed));
		}

		$is_admin = $GLOBALS['FORUM_DRIVER']->is_super_admin($row['id']);

		//Check subscription status for non-admins.
		require_code('ocf_referral');
		$is_member_in_trial_period	=	is_member_in_trial_preriod($row['id']);
		$member_in_free_account		=	is_member_in_free_account_type($row);
		if(!$is_member_in_trial_period)	$out['trial_period_expired']	=	true;

		if (!$is_admin && !is_member_alotted_free_subscription_by_admin($row['id']) && !$is_member_in_trial_period && !$member_in_free_account)
		{
			//Check whether the member has started subscription
			if (!is_member_started_join_subscription($row['id']))
			{
				$out['subscription_not_started'] = true;
				return $out;
			}
			//Check whether the member's subsequent subscription payment has been failed
			if (is_member_subscription_failed($row['id']))
			{
				$out['subsequent_subscription_payment_failed'] = true;
				return $out;
			}

			if (!member_have_active_subscription($row['id']))
			{
				$out['inactive_account'] = true;
				return $out;
			}
		}
	
		if ($row['m_validated']==0)
		{
			$out['error']=(do_lang_tempcode('USER_NOT_VALIDATED_STAFF'));
			return $out;
		}
		if ($row['m_validated_email_confirm_code']!='')
		{
			$out['error']=(do_lang_tempcode('USER_NOT_VALIDATED_EMAIL'));
			return $out;
		}
		if ($this->is_banned($row['id'])) // All hands to the guns
		{
			$out['error']=(do_lang_tempcode('USER_BANNED'));
			return $out;
		}

      // Check password
		if (!$skip_auth)
		{
			// Choose a compatibility screen.
			// Note that almost all cookie logins are the same. This is because the cookie logins use OCF cookies, regardless of compatibility scheme.
			$password_compatibility_scheme=$row['m_password_compat_scheme'];
			switch ($password_compatibility_scheme)
			{
				case 'remote': // This will work too - we're logging in with the username of a remote profile, so no resynching will happen
				case '': // ocPortal style salted MD5 algorithm
					if ($cookie_login)
					{
						if ($password_hashed!=$row['m_pass_hash_salted'])
						{
							$out['error']=(do_lang_tempcode('USER_BAD_PASSWORD'));
							return $out;
						}
					} else
					{
						if (md5($row['m_pass_salt'].$password_hashed)!=$row['m_pass_hash_salted'])
						{
							$out['error']=(do_lang_tempcode('USER_BAD_PASSWORD'));
							return $out;
						}
					}
					break;
				case 'plain':
					if ($password_hashed!=md5($row['m_pass_hash_salted']))
					{
						$out['error']=(do_lang_tempcode('USER_BAD_PASSWORD'));
						return $out;
					}
					break;
				case 'md5': // Old style plain md5		(also works if both are unhashed: used for LDAP)
					if (($password_hashed!=$row['m_pass_hash_salted']) && ($password_hashed!='!!!')) // The !!! bit would never be in a hash, but for plain text checks using this same code, we sometimes use '!!!' to mean 'Error'.
					{
						$out['error']=(do_lang_tempcode('USER_BAD_PASSWORD'));
						return $out;
					}
					break;
		/*		case 'httpauth':
					// This is handled in get_member()  */
					break;
				case 'ldap':
					if ($password_hashed!=$row['m_pass_hash_salted'])
					{
						$out['error']=(do_lang_tempcode('USER_BAD_PASSWORD'));
						return $out;
					}
					break;
				default:
					$path=get_file_base().'/sources_custom/hooks/systems/ocf_auth/'.$password_compatibility_scheme.'.php';
					if (!file_exists($path)) $path=get_file_base().'/sources/hooks/systems/ocf_auth/'.$password_compatibility_scheme.'.php';
					if (!file_exists($path))
					{
						$out['error']=(do_lang_tempcode('UNKNOWN_AUTH_SCHEME_IN_DB'));
						return $out;
					}
					require_code('hooks/systems/ocf_auth/'.$password_compatibility_scheme);
					$ob=object_factory('Hook_ocf_auth_'.$password_compatibility_scheme);
					$error=$ob->auth($username,$userid,$password_hashed,$password_raw,$cookie_login,$row);
					if (!is_null($error))
					{
						$out['error']=$error;
						return $out;
					}
					break;
			}
		}

		// Ok, authorised basically, but we need to see if this is a valid login IP
		if ((ocf_get_best_group_property($this->get_members_groups($row['id'],false,false,true),'enquire_on_new_ips')==1)) // High security usergroup membership
		{
			global $SENT_OUT_VALIDATE_NOTICE;
			$ip=get_ip_address(3);
			$test2=$this->connection->query_value_null_ok('f_member_known_login_ips','i_val_code',array('i_member_id'=>$row['id'],'i_ip'=>$ip));
			if (((is_null($test2)) || ($test2!='')) && (!compare_ip_address($ip,$row['m_ip_address'])))
			{
				if (!$SENT_OUT_VALIDATE_NOTICE)
				{
					if (!is_null($test2)) // Tidy up
					{
						$this->connection->query_delete('f_member_known_login_ips',array('i_member_id'=>$row['id'],'i_ip'=>$ip),'',1);
					}

					$code=!is_null($test2)?$test2:uniqid('');
					$this->connection->query_insert('f_member_known_login_ips',array('i_val_code'=>$code,'i_member_id'=>$row['id'],'i_ip'=>$ip));
					$url=find_script('validateip').'?code='.$code;
					$url_simple=find_script('validateip');
					$mail=do_lang('IP_VERIFY_MAIL',comcode_escape($url),comcode_escape(get_ip_address()),array($url_simple,$code));
					$email_address=$row['m_email_address'];
					if ($email_address=='') $email_address=get_option('staff_address');
					mail_wrap(do_lang('IP_VERIFY_MAIL_SUBJECT'),$mail,array($email_address),$row['m_username'],'','',1);

					$SENT_OUT_VALIDATE_NOTICE=true;
				}

				$out['error']=do_lang_tempcode('REQUIRES_IP_VALIDATION');
				return $out;
			}
		}

		$this->ocf_flood_control($row['id']);

		$out['id']=$row['id'];
		return $out;
	}

	/**
	 * Handle flood control for members.
	 *
	 * @param  MEMBER			The member ID that just got detected
	 */
	function ocf_flood_control($id)
	{
		global $NON_PAGE_SCRIPT;
		if ($NON_PAGE_SCRIPT==1) return;

		global $FLOOD_CONTROL_ONCE;
		if ($FLOOD_CONTROL_ONCE) return;
		$FLOOD_CONTROL_ONCE=true;

		if (get_page_name()=='join') return;

		require_code('ocf_groups');

		// Set last visit time session cookie if it doesn't exist
		if (!array_key_exists('last_visit',$_COOKIE))
		{
			require_code('users_active_actions');
			ocp_setcookie('last_visit',strval($this->get_member_row_field($id,'m_last_visit_time')),true);
		}

		// Do some flood control
		$submitting=((count($_POST)>0) && (get_param('type',NULL)!=='ed') && (get_param('type',NULL)!=='ec') && (!running_script('preview')));
		$restrict=$submitting?'flood_control_submit_secs':'flood_control_access_secs';
		$restrict_setting=$submitting?'m_last_submit_time':'m_last_visit_time';
		$restrict_answer=ocf_get_best_group_property($this->get_members_groups($id,false,false,true),$restrict);
		if ((!$submitting) && (array_key_exists('redirect',$_GET))) $restrict_answer=0;
		if ($restrict_answer<0) $restrict_answer=0;
		$last=$this->get_member_row_field($id,$restrict_setting);
		if ($last>time()) $last=time()-$restrict_answer; // Weird clock problem
		$wait_time=$restrict_answer-time()+$last;

		if ($wait_time>0)
		{
			require_code('site');
			log_stats('/flood',0);

			$time_threshold=30;
			$count_threshold=30;
			$query='SELECT COUNT(*) FROM '.$GLOBALS['SITE_DB']->get_table_prefix().'stats WHERE date_and_time>'.strval(time()-$time_threshold).' AND date_and_time<'.strval(time()).' AND '.db_string_equal_to('ip',get_ip_address());
			$count=$GLOBALS['SITE_DB']->query_value_null_ok_full($query);
			if ($count>=$count_threshold)
			{
				$ip=get_ip_address();
				require_code('failure');
				add_ip_ban($ip);
				require_code('mail');
				mail_wrap(do_lang('AUTO_BAN_SUBJECT'),do_lang('AUTO_BAN_DOS_MESSAGE',$ip,number_format($count_threshold),number_format($time_threshold)));
			}
			if (!function_exists('require_lang')) require_code('lang');
			require_lang('ocf');

			warn_exit(do_lang_tempcode('FLOOD_CONTROL_RESTRICT',number_format($wait_time)));
		}
		$extra=$submitting?array('m_last_submit_time'=>time()):array();

		$dif=time()-$this->get_member_row_field($id,'m_last_visit_time');
		if ($dif<0) $dif=0; // can happen if system clock changes
		$guest_id=$this->get_guest_id();
		if ($id==$guest_id) // bit of a hack, so that guests don't trip each others limits. Works out statistically.
		{
			global $SESSION_CACHE;
			$num_guests=0;
			foreach ($SESSION_CACHE as $c)
			{
				if (($c['last_activity']>time()-60*4) && ($c['the_user']==$guest_id)) $num_guests++;
			}
			$dif*=$num_guests;
		}
		if (($submitting) || ((count($_POST)==0) && ($dif>$wait_time)))
		{
			if (($restrict_answer!=0) || ($dif>180))
			{
				$old_ip=$this->get_member_row_field($id,'m_ip_address');

				$change_map=array('m_last_visit_time'=>time());
				if (get_ip_address()!=$old_ip) $change_map['m_ip_address']=get_ip_address();

				if (get_db_type()!='xml')
					$this->connection->query_update('f_members',$change_map+$extra,array('id'=>$id),'',1);
			}
		}
	}


