<?php

/**
 * Make a subscription (payment) button.
 *
 * @param  ID_TEXT		The product codename.
 * @param  SHORT_TEXT	The human-readable product title.
 * @param  ID_TEXT		The purchase ID.
 * @param  float			A transaction amount.
 * @param  integer		The subscription length in the units.
 * @param  ID_TEXT		The length units.
 * @set    d w m y
 * @param  ID_TEXT		The currency to use.
 * @param  ?ID_TEXT		The service the payment will go via via (NULL: autodetect).
 * @param  ?ID_TEXT		The member-id.
 * @return tempcode		The button
 */
function make_subscription_button($product,$item_name,$purchase_id,$amount,$length,$length_units,$currency,$via=NULL,$seller=NULL)
{
	$payment_buttons	=	array();
	$_hooks=find_all_hooks('systems','ecommerce_via');
	foreach (array_keys($_hooks) as $hook)
	{
		if(!is_null($via) && $via!=$hook)	continue;
		require_code('hooks/systems/ecommerce_via/'.filter_naughty_harsh($hook));
		$payment_object	=	object_factory('Hook_'.$hook);
		if(!$payment_object->is_enabled() || !method_exists($payment_object,'make_subscription_button'))	continue;

		$payment_buttons[$hook]	=	array('INFO_DESC'=>method_exists($payment_object,'info')?$payment_object->info():$hook,'SIGN_LOGO'=>method_exists($payment_object,'get_confidence_logos')?$payment_object->get_confidence_logos():'','PAY_BUTTON'=>$payment_object->make_subscription_button($product,$item_name,$purchase_id,$amount,$length,$length_units,$currency));
	}

	$has_multi_gateways	=	(count($payment_buttons)>1)?true:false;

	return do_template('PAYMENT_BUTTONS',array('PAYMENT_BUTTONS'=>$payment_buttons,'NOTIFICATION_TEXT'=>do_lang_tempcode('CHECKOUT_NOTIFICATION_TEXT',$purchase_id),'HAS_MULTI_GATEWAYS'=>$has_multi_gateways));
}

/**
 * Make a subscription cancellation button.
 *
 * @param  AUTO_LINK	The purchase ID.
 * @param  ID_TEXT	The service the payment will go via via.
 * @return ?tempcode	The button (NULL: no special cancellation -- just delete the subscription row to stop ocPortal regularly re-charging)
 */
function make_cancel_button($purchase_id,$via,$auto_found_key=NULL)
{
	if ($via=='') return NULL;
	if ($via=='manual') return NULL;
	require_code('hooks/systems/ecommerce_via/'.filter_naughty_harsh($via));
	$object=object_factory('Hook_'.$via);
	if (!method_exists($object,'make_cancel_button')) return NULL;
	return $object->make_cancel_button($purchase_id,$auto_found_key);
}

/**
 * Make a subscription update button.
 *
 * @param  AUTO_LINK	The purchase ID.
 * @param  ID_TEXT	The service the payment will go via via.
 * @return TEMPCODE	The button
 */
function make_update_button($purchase_id,$via,$auto_found_key=NULL)
{
	if (($via == '') || ($via == 'manual')) return new ocp_tempcode();

	require_code('hooks/systems/ecommerce_via/'.filter_naughty_harsh($via));
	$object=object_factory('Hook_'.$via);
	if (!method_exists($object,'make_update_button')) return new ocp_tempcode();

	return $object->make_update_button($purchase_id,$auto_found_key);
}

/**
 * Handle IPN's that have been confirmed as backed up by real money.
 *
 * @param  ID_TEXT		The ID of the purchase-type (meaning depends on item_name)
 * @param  SHORT_TEXT	The item being purchased (aka the product) (blank: subscription, so we need to look it up)
 * @param  SHORT_TEXT	The status this transaction is telling of
 * @set    SModified SCancelled Completed Pending Failed
 * @param  SHORT_TEXT	The code that gives reason to the status
 * @param  SHORT_TEXT	The reason it is in pending status (if it is)
 * @param  SHORT_TEXT	A note attached to the transaction
 * @param  SHORT_TEXT	The amount of money
 * @param  SHORT_TEXT	The currency the amount is in
 * @param  SHORT_TEXT	The transaction ID
 * @param  SHORT_TEXT	The ID of the parent transaction
 * @param  ID_TEXT		The ID of a special source for the transaction
 * @param  string			The subscription period (blank: N/A)
 */
function handle_confirmed_transaction($purchase_id,$item_name,$payment_status,$reason_code,$pending_reason,$memo,$mc_gross,$mc_currency,$txn_id,$parent_txn_id,$source='',$period='')
{
	//Temporary setting - force payment setting to "completed" for test mode transactions
	/*if(get_option('ecommerce_test_mode')=="1")
	{
		$payment_status	=	'Completed';
	}*/

	// Check what we sold
	$found = NULL;
	$products = find_all_products();
	foreach ($products as $product=>$details)
	{
		if ($product==$item_name)
		{
			if(is_object($details[5]) && method_exists($details[5],'find_purchased_price'))
			{
				$details[1]	=	$details[5]->find_purchased_price($purchase_id);
			}
			if (($mc_gross!=$details[1]) && ($details[1]!='?'))
			{
				if ($payment_status=='SModified')
					$GLOBALS['SITE_DB']->query_update('subscriptions',array('s_state'=>'new'),array('id'=>intval($purchase_id)),'',1);
				if (($payment_status!='SCancelled') && (substr($txn_id,0,6)!='manual'))
				{
					if(!credit_calculations($mc_gross,$details[1],$txn_id))
						my_exit(do_lang('PURCHASE_WRONG_PRICE',$item_name));
				}
			}
			$found=$details;
			break;
		}
	}
	if (is_null($found)) my_exit(do_lang('PRODUCT_NO_SUCH').' - '.$item_name);

	$object = find_product($item_name);
	$product_det =	$object->product_id;

	$product_name = $product_det[4];

	$subscription = ($product_det[0]==PRODUCT_SUBSCRIPTION) ?  true : false;

	if ($subscription)
	{
		$is_local_sub	=	$GLOBALS['SITE_DB']->query_value_null_ok('subscriptions','locally_controlled',array('id'=>intval($purchase_id)));
	}

	if ($period!='')
	{
		$length=array_key_exists('length',$found[3])?strval($found[3]['length']):'1';
		$length_units=array_key_exists('length_units',$found[3])?$found[3]['length_units']:'m';
		if (strtolower($period)!=strtolower($length.' '.$length_units)) my_exit(do_lang('IPN_SUB_PERIOD_WRONG'));
	}

	// FIXME: The Sales Report screen shows transactions with "to_member_id" set
	// to the relevant user. Here we are setting "to_member_id" as the contents
	// of $_seller, which itself is either NULL or $seller['id']. Likewise,
	// $seller is set to NULL if there is no "get_seller" method for this product
	// and, in the product_permissions hook, "get_seller" returns NULL if the
	// 'enable_member_payments' option is disabled. Thus there are 3 ways for the
	// seller to be NULL, all of which will result in nothing showing up in the
	// sales report. Also, since I'm writing this anyway, this branch is useless
	// considering that $_seller is set inside it, then called from outside it.
	// This implies a massive fail if shopping isn't installed, or a useless fork
	// if it is installed.
	if(addon_installed('shopping'))
	{
		$object	=	find_product(do_lang('PRODUCT_ORDERS',$purchase_id));
		$seller	=	(method_exists($object,'get_seller'))?	$object->get_seller($purchase_id):NULL;
		$_seller	=	(!is_null($seller))?$seller['id']:NULL;
	}

	// Store
	$GLOBALS['SITE_DB']->query_insert('transactions',array('id'=>$txn_id,'t_memo'=>$memo,'purchase_id'=>strval($purchase_id),'status'=>$payment_status,'pending_reason'=>$pending_reason,'reason'=>$reason_code,'amount'=>$mc_gross,'t_currency'=>$mc_currency,'linked'=>$parent_txn_id,'t_time'=>time(),'item'=>$product,'t_via'=>$source,'to_member_id'=>$_seller,'item_name'=>$product_name));

	$details['txn_id']	=	$txn_id;

	// Check currency
	if ($mc_currency!=get_option('currency'))
	{
		if ($payment_status=='SModified')
			$GLOBALS['SITE_DB']->query_update('subscriptions',array('s_state'=>'new'),array('id'=>intval($purchase_id)),'',1);
		if (($payment_status!='SCancelled') && (substr($txn_id,0,6)!='manual')) my_exit(do_lang('PURCHASE_WRONG_CURRENCY'));
	}

	// Pending
	if (($payment_status=='Pending') && (strpos($item_name,'invoice')!==false))
	{
		$GLOBALS['SITE_DB']->query_update('invoices',array('i_state'=>'pending'),array('id'=>intval($purchase_id)),'',1);
	}
	elseif (($payment_status=='Pending') && ($subscription))
	{
		$GLOBALS['SITE_DB']->query_update('subscriptions',array('s_state'=>'pending'),array('id'=>intval($purchase_id)),'',1);
		if ($details[2]!='') call_user_func_array($details[2],array($purchase_id,$details,$product,true)); // Run cancel code
	}
	elseif (($payment_status=='Pending') && ($item_name==do_lang('PRODUCT_ORDERS',$purchase_id)))
	{
		$details['ORDER_STATUS']='ORDER_STATUS_awaiting_payment';

		if ($details[2]!='') call_user_func_array($details[2],array($purchase_id,$details,$product,true)); // Set order status
	}
	// Cancelled
	elseif (($payment_status=='SCancelled') && ($subscription))
	{
		$update_vals	=	array('s_auto_fund_source'=>$source,'s_state'=>'cancelled','s_time'=>time());
		$GLOBALS['SITE_DB']->query_update('subscriptions',$update_vals,array('id'=>intval($purchase_id)),'',1);
		if ($found[2]!='') call_user_func_array($found[2],array($purchase_id,$found,$product,true)); // Run cancel code
	}
	//Made active
	elseif ($subscription)
	{
		$update_vals	=	array('s_auto_fund_source'=>$source,'s_state'=>'active','s_via'=>$source);
		if(!$is_local_sub)
		{
			$update_vals	=	array_merge($update_vals,array('s_auto_fund_key'=>$txn_id));
		}
		else
		{
			$update_vals	=	array_merge($update_vals,array('s_time'=>time()));
		}

		require_code('hooks/systems/ecommerce_via/'.$source);
		$payment_object	=	object_factory('Hook_'.$source);

		if(method_exists($payment_object,'map_payment_ids'))
		{
			$sub_prof_data	=	$payment_object->map_payment_ids($txn_id,$parent_txn_id);
			$update_vals	=	array_merge($update_vals,array('s_auto_fund_key'=>$sub_prof_data));
		}

		$GLOBALS['SITE_DB']->query_update('subscriptions',$update_vals,array('id'=>intval($purchase_id)),'',1);
	}

	// Check completed
	elseif (($payment_status!='Completed') && ($payment_status!='SCancelled') && get_option('ecommerce_test_mode')!="1")
		my_exit(do_lang('TRANSACTION_NOT_COMPLETE',$product.':'.strval($purchase_id),$payment_status),true);


	// Dispatch section code

	if ($payment_status=='Completed')
	{
		//Find product hooks of this order to check dispatch type

		if(is_object($object) && !method_exists($object,'get_product_dispatch_type'))
		{	//If hook does not have dispatch method setting take dispatch method as automatic
			$details['ORDER_STATUS']	=	'ORDER_STATUS_dispatched';
		}
		elseif(is_object($object) && $object->get_product_dispatch_type($purchase_id)=='automatic')
		{
			$details['ORDER_STATUS']	=	'ORDER_STATUS_dispatched';
		}
		else
		{
			$details['ORDER_STATUS']	=	'ORDER_STATUS_payment_received';
		}

		if ($details[2]!='') call_user_func_array($details[2],array($purchase_id,$details,$product));
	}

	//Dispatch section end

	// Invoice handling
	if ($found[0]==PRODUCT_INVOICE)
	{
		$price=$GLOBALS['SITE_DB']->query_value('invoices','i_amount',array('id'=>intval($purchase_id)));

		// Reading the credit points of the member
		require_code('hooks/modules/catalogue_items');
		$object=object_factory('Hook_catalogue_items');

		$member_id=method_exists($object,'member_for')?$object->member_for($purchase_id):$GLOBALS['FORUM_DRIVER']->get_guest_id();

		if(!credit_calculations($mc_gross,$details[1],$txn_id))
			my_exit(do_lang('PURCHASE_WRONG_PRICE',$item_name));

		$GLOBALS['SITE_DB']->query_update('invoices',array('i_state'=>'paid'),array('id'=>intval($purchase_id)),'',1);
	}

	// Delete if cancelled
	if (($payment_status=='SCancelled') && ($subscription))
	{
		$GLOBALS['SITE_DB']->query_delete('subscriptions',array('id'=>intval($purchase_id)),'',1);
	}
}

/**
 * Function to return general form fields for subscription update
 *
 *	@param  AUTO_LINK	Subscription Id
 */
function get_general_update_form_fields($subscription_id,$payobj)
{
	require_code('locations');
	require_code('form_templates');

	$first_name		=	post_param('first_name',get_ocp_cpf('credit_card_firstname'));
	$last_name		=	post_param('last_name',get_ocp_cpf('credit_card_lastname'));
	$card_number	= (ecommerce_test_mode()?'4444333322221111':post_param('card_number',get_ocp_cpf('credit_card_number')));
	$card_type		= (ecommerce_test_mode()?'Visa':post_param('card_type',get_ocp_cpf('credit_card_type')));
	$card_expiry_m	= post_param('expiry_date_month',NULL);
	$card_expiry_y	= post_param('expiry_date_year',NULL);
	$cv2				= post_param('cv2',(!is_null(get_ocp_cpf('credit_card_security_code'))?get_ocp_cpf('credit_card_security_code'):'123'));
	$address1		= post_param('address1',get_ocp_cpf('credit_card_address'));
	$city				= post_param('city',get_ocp_cpf('credit_card_city'));
	$state			= post_param('state',get_ocp_cpf('credit_card_state'));
	$zip				= post_param('zip',get_ocp_cpf('credit_card_post_code'));
	$country			= post_param('country',get_ocp_cpf('credit_card_country'));

	$hidden	 =	new ocp_tempcode();
	$card_det =	array();

	$card_det['first_name']	= form_input_line(do_lang_tempcode('CARDHOLDER_NAME_FIRST'),do_lang_tempcode('DESCRIPTION_CARDHOLDER_NAME_FIRST'),'first_name',$first_name,true);
	$card_det['last_name']	= form_input_line(do_lang_tempcode('CARDHOLDER_NAME_LAST'),do_lang_tempcode('DESCRIPTION_CARDHOLDER_NAME_LAST'),'last_name',$last_name,true);

	$card_det['card_number'] =	form_input_line(do_lang_tempcode('CARD_NUMBER'),do_lang_tempcode('DESCRIPTION_CARD_NUMBER'),'card_number',$card_number,true);
	if (method_exists($payobj,'nice_get_card_types'))
	{
		$card_det['card_type'] = form_input_list(do_lang_tempcode('CARD_TYPE'),'','card_type',$payobj->nice_get_card_types($card_type));
	}
	$card_det['expiry_date'] =	form_input_future_month_year(do_lang_tempcode('CARD_EXPIRY_DATE'),do_lang_tempcode('DESCRIPTION_CARD_EXPIRY_DATE'),'expiry_date',false,50,intval($card_expiry_y),intval($card_expiry_m),NULL,true);
	$card_det['cv2']			 =	form_input_line(do_lang_tempcode('CARD_CV2'),do_lang_tempcode('DESCRIPTION_CARD_CV2'),'cv2',$cv2,true);

	$card_det['spacer_1'] =	do_template('FORM_SCREEN_FIELD_SPACER',array('SECTION_HIDDEN'=>false,'TITLE'=>'Card address'));
	$card_det['address1'] =	form_input_line(do_lang_tempcode('SPECIAL_CPF__ocp_building_name_or_number'),'','address1',$address1,true);

	if (is_location_data())
	{
		$field_names =	array('country'=>array('field_name'=>'country','def_value'=>$country),'state'=>array('field_name'=>'state','def_value'=>$state),'city'=>array('field_name'=>'city','def_value'=>$city),'zip'=>array('field_name'=>'zip','def_value'=>$zip));
		list($card_det['location'],$loc_hidden) =	get_location_fields($field_names,do_lang_tempcode('YOUR_LOCATION'),'',true,'payment',true);
		$hidden->attach($loc_hidden);
	}
	else
	{
		$card_det['country'] = form_input_line(do_lang_tempcode('COUNTRY_CODE'),'','country',$country,true);
		$card_det['state']   = form_input_line(do_lang_tempcode('STATE_CODE'),'','state',$state,true);
		$card_det['city']    = form_input_line(do_lang_tempcode('CITY'),'','city',$city,true);
		$card_det['zip']     = form_input_line(do_lang_tempcode('ZIP'),'','zip',$zip,true);
	}

	//Set payment gateway subscription id as hidden form field
	$hidden->attach(form_input_hidden('subscription_id',strval($subscription_id)));

	return array($card_det,$hidden);
}

/** Function to check whether a subscription is locally controlled or not
 *
 *	@param	integer	Subscription table id
 * @return	boolean
 */
function is_locally_controlled_subscription($id)
{
	$value_check = $GLOBALS['FORUM_DB']->query_value_null_ok('subscriptions','locally_controlled',array('id'=>$id));
	return ($value_check) ? true : false;
}

/** Function to process local subscription method setting
 *
 *	@param	array		Transaction rows
 *	@param	object	Payment gateway object
 * @return	?array	Array of subscription legth and units/ [ NULL : if subscription method is locally controlled ]
 */
function do_subscription_method_process($transaction_row,$payment_object,$payment_gateway,$payment_details)
{
	if(method_exists($payment_object,'get_subscription_local_payment_method') && $payment_object->get_subscription_local_payment_method()=='automatic')
	{
		return	array($transaction_row['e_length'],$transaction_row['e_length_units']);
	}
	else
	{
		$GLOBALS['SITE_DB']->query_update('subscriptions',array('s_auto_fund_source'	=>$payment_gateway,'s_auto_fund_key'=>serialize($payment_details),'locally_controlled'=>1),array('id'=>$transaction_row['e_purchase_id']));
		return	array(NULL,NULL);
	}
}

/** Function to do subscription payment from local
 *
 * @return	NULL
 */
function do_local_subscription_payments()
{
	$rows		=	$GLOBALS['SITE_DB']->query_select('subscriptions',array('*'));
	if(!array_key_exists(0,$rows))	return;

	foreach($rows as $subscription)
	{
		if(!$subscription['locally_controlled'])	continue;

		$prod_obj	=	find_product($subscription['s_type_code']);
		$details		=	$prod_obj->product_id;
		$unit			=	array('d'=>24*60*60,'w'=>7*24*60*60,'m'=>30*24*60*60,'y'=>12*30*24*60*60);

		$sub_in_sec		=	$details[3]['length']*$unit[$details[3]['length_units']];
		$next_sub_time	=	$subscription['s_time']+$sub_in_sec;
		//Check if the current time is exceeded for the payment from last payment time
		if(time()>$next_sub_time && $subscription['s_state']!='cancelled')	//Do payment now
		{
			require_code('hooks/systems/ecommerce_via/'.$subscription['s_auto_fund_source']);
			$payment_object=	object_factory('Hook_'.$subscription['s_auto_fund_source']);

			$payment_det	=	unserialize($subscription['s_auto_fund_key']);
			$start_date		=	str_replace('/','',post_param('start_date',date('Y-m-d')));

			$trans_id		=	$payment_object->generate_trans_id();
			list($success,$code,$sub_code,$message_raw)	=	$payment_object->do_transaction($trans_id,$payment_det['first_name'],$payment_det['last_name'],$payment_det['card_number'],$subscription['s_amount'],$payment_det['expiry_date'],NULL,$start_date,$payment_det['card_type'],$payment_det['cv2'],NULL,NULL,$details[4],NULL,$payment_det['address'],$payment_det['city'],$payment_det['state'],$payment_det['zip'],$payment_det['country']);

			$status=(!$success)?'SCancelled':'Completed';
			handle_confirmed_transaction($subscription['id'],'',$status,$message_raw,'','',$subscription['s_amount'],get_option('currency'),$trans_id,'',$subscription['s_auto_fund_source'],'');
		}
	}
}

/**
 * Get all active subscription for the member
 *
 * @param  ID     The member id
 * @return ARRAY  The table rows
 */
function get_all_active_subscriptions($member_id)
{
	$sql = "SELECT * FROM ".get_table_prefix()."subscriptions WHERE `s_member_id`='$member_id' AND `s_state`='active'";

	$result = $GLOBALS['FORUM_DB']->query($sql);

	return ($result) ? $result : NULL;
}

/**
 * Get encryption key for credit card number.
 *
 * @return TEXT
 */
function get_encryption_key_for_credit_card_number()
{
	$key = "fl;fkj9034ktfg;ldj";
	return $key;
}
