<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		ecommerce
 */

class Module_subscriptions
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']='Chris Graham';
		$info['organisation']='ocProducts';
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=4;
		$info['locked']=false;
		$info['update_require_upgrade']=1;
		return $info;
	}

	/**
	 * Standard modular uninstall function.
	 */
	function uninstall()
	{
		$GLOBALS['SITE_DB']->drop_if_exists('subscriptions');

		$dbs_bak=$GLOBALS['NO_DB_SCOPE_CHECK'];
		$GLOBALS['NO_DB_SCOPE_CHECK']=true;
		$GLOBALS['SITE_DB']->drop_if_exists('f_usergroup_subs');
		$GLOBALS['NO_DB_SCOPE_CHECK']=$dbs_bak;

		$GLOBALS['SITE_DB']->query_delete('redirects',array('r_from_page'=>'subscriptions','r_from_zone'=>'personalzone','r_to_page'=>'subscriptions','r_to_zone'=>'site','r_is_transparent'=>1));
	}

	/**
	 * Standard modular install function.
	 *
	 * @param  ?integer	What version we're upgrading from (NULL: new install)
	 * @param  ?integer	What hack version we're upgrading from (NULL: new-install/not-upgrading-from-a-hacked-version)
	 */
	function install($upgrade_from=NULL,$upgrade_from_hack=NULL)
	{
		$dbs_bak=$GLOBALS['NO_DB_SCOPE_CHECK'];
		$GLOBALS['NO_DB_SCOPE_CHECK']=true;

		if (is_null($upgrade_from))
		{
			$GLOBALS['SITE_DB']->create_table('subscriptions',array(
				'id'=>'*AUTO', // linked to IPN with this
				's_type_code'=>'ID_TEXT',
				's_member_id'=>'USER',
				's_state'=>'ID_TEXT', // new|pending|active|cancelled (pending means payment has been requested)
				's_amount'=>'SHORT_TEXT', // can't always find this from s_type_code
				's_special'=>'SHORT_TEXT', // depending on s_type_code, would trigger something special such as a key upgrade
				's_time'=>'TIME',
				's_auto_fund_source'=>'ID_TEXT', // Used by PayPal for nothing much, but is of real use if we need to schedule our own subscription transactions
				's_auto_fund_key'=>'SHORT_TEXT', // Ditto as above: we can serialize cc numbers etc into here
				'auto_fund_source_type'=>'ID_TEXT',
				's_via'=>'ID_TEXT',
				'locally_controlled'=>'?BINARY',
			));

			$GLOBALS['SITE_DB']->query_insert('redirects',array('r_from_page'=>'subscriptions','r_from_zone'=>'personalzone','r_to_page'=>'subscriptions','r_to_zone'=>'site','r_is_transparent'=>1));
		}

		if ((is_null($upgrade_from)) || ($upgrade_from<3))
		{
			$GLOBALS['SITE_DB']->create_table('f_usergroup_subs',array(
				'id'=>'*AUTO',
				's_title'=>'SHORT_TRANS',
				's_description'=>'LONG_TRANS',
				's_cost'=>'SHORT_TEXT',
				's_length'=>'INTEGER',
				's_length_units'=>'SHORT_TEXT',
				's_group_id'=>'GROUP',
				's_enabled'=>'BINARY',
				's_mail_start'=>'LONG_TRANS',
				's_mail_end'=>'LONG_TRANS',
				's_mail_uhoh'=>'LONG_TRANS',
				's_uses_primary'=>'BINARY',
			));
		}

		if ((!is_null($upgrade_from)) && ($upgrade_from<4))
		{
			$GLOBALS['SITE_DB']->add_table_field('subscriptions','s_via','ID_TEXT','paypal');
			$GLOBALS['SITE_DB']->add_table_field('f_usergroup_subs','s_uses_primary','BINARY');
		}

		$GLOBALS['NO_DB_SCOPE_CHECK']=$dbs_bak;
	}

	/**
	 * Standard modular entry-point finder function.
	 *
	 * @return ?array	A map of entry points (type-code=>language-code) (NULL: disabled).
	 */
	function get_entry_points()
	{
		return array('misc'=>'MY_SUBSCRIPTIONS');
	}

	/**
	 * Standard modular run function.
	 *
	 * @return tempcode	The result of execution.
	 */
	function run()
	{
		require_lang('ecommerce');
		require_code('ecommerce');
		require_code('catalogues2');
		require_code('ocf_members');
		require_code('ocf_members_action');
		require_code('ocf_members_action2');
		require_css('ecommerce');

		// Kill switch
		//if ((ecommerce_test_mode()) && (!has_specific_permission(get_member(),'access_ecommerce_in_test_mode'))) inform_exit(do_lang_tempcode('PURCHASE_DISABLED'));

		if (is_guest()) access_denied('NOT_AS_GUEST');

		$type=get_param('type','misc');

		if ($type=='misc') return $this->my();
		if ($type=='cancel') return $this->cancel();
		if ($type=='update') return $this->update();
		if ($type=='_update') return $this->_update();
		return new ocp_tempcode();
	}

	/**
	 * Show my subscriptions.
	 *
	 * @return tempcode	The interface.
	 */
	function my()
	{
		$title=get_page_title('MY_SUBSCRIPTIONS');

		$member_id=get_member();
		if (has_specific_permission(get_member(),'assume_any_member')) $member_id=get_param_integer('id',$member_id);

		$subscriptions=array();
		$rows=$GLOBALS['SITE_DB']->query('SELECT * FROM '.get_table_prefix().'subscriptions WHERE s_member_id='.$member_id.' ORDER BY s_state');
		foreach ($rows as $row)
		{
			$product=$row['s_type_code'];

			if($product=='site_subscription')
			{
				require_code('ecommerce');
				$unit	=	($row['s_amount']==get_site_monthly_price() || $row['s_amount']==19.99)?'m':'y';
				$products[$product]=array('',$row['s_amount'],'',array('id'=>$row['id'],'length'=>1,'length_units'=>$unit),'Site');
			}
			else
			{
				$object=find_product($product);
				if (is_null($object)) continue;
				$products=$object->get_products();
				if (!array_key_exists(4,$products[$product])) $products[$product][4]=do_lang('CUSTOM_PRODUCT_'.$product);
			}

			$subscription_title=$products[$product][4];
			$added_time=get_timezoned_date($row['s_time'],true,false,false,true);
			$start_time = ($row['s_start']) ? get_timezoned_date($row['s_start'],true,false,false,true) : $added_time;

			$state=do_lang_tempcode('PAYMENT_STATE_'.$row['s_state']);

			if($row['s_state']=='active')
			{
				$cancel_button = make_cancel_button($row['id'],$row['s_via'],$row['s_auto_fund_key']);
				$update_button = make_update_button($row['id'],$row['s_via'],$row['s_auto_fund_key']);
			}
			else
			{
				$cancel_button	= new ocp_tempcode();
				$update_button = new ocp_tempcode();
			}

			$per=do_lang('_LENGTH_UNIT_'.$products[$product][3]['length_units'],number_format($products[$product][3]['length']));

			$subscriptions[]=array('SUBSCRIPTION_TITLE'=>$subscription_title,'ID'=>strval($row['id']),'PER'=>$per,'AMOUNT'=>$row['s_amount'],'ADDED_TIME'=>$added_time,'START_TIME'=>$start_time,'STATE'=>$state,'TYPE_CODE'=>$row['s_type_code'],'CANCEL_BUTTON'=>$cancel_button,'UPDATE_BUTTON'=>$update_button);
		}

		// Get the account type
		$account_type = $GLOBALS['SITE_DB']->query_value_null_ok('f_members','account_type',array('id'=>get_member()));
		if (is_null($account_type))
			$account_type = 'unknown';

		// Get the number of days until the next subscription payment
		$time_to_sub = $GLOBALS['SITE_DB']->query_value_null_ok('f_members','m_next_subscription_time',array('id'=>get_member()));
		// The above is seconds since the epoch (1970), so convert to days
		if (!is_null($time_to_sub))
		{
			$time_to_sub = intval($time_to_sub / (60 * 60 * 24));
			// Compare the the current time
			$cur_time = intval(time() / (60 * 60 * 24));
			if ($cur_time > $time_to_sub)
			{
				// FIXME: This user's subscription is late...
				$next_pay = do_lang('SUB_PAY_IN_PAST',strval($cur_time - $time_to_sub));
			}
			else
			{
				$next_pay = do_lang('NEXT_SUB_PAY',strval($time_to_sub - $cur_time));
			}
		}
		else
		{
			$next_pay = '';
		}

		return do_template('ECOM_SUBSCRIPTIONS_SCREEN',array(
			'_GUID'=>'e39cd1883ba7b87599314c1f8b67902d',
			'TITLE'=>$title,
			'SUBSCRIPTIONS'=>$subscriptions,
			'ACCOUNT'=>$account_type,
			'NEXT_PAYMENT'=>$next_pay
		));
	}

	/**
	 * Cancel a subscription.
	 *
	 * @return tempcode	The interface.
	 */
	function cancel()
	{
		$title=get_page_title('SUBSCRIPTION_CANCEL');

		breadcrumb_set_parents(array(array('_SELF:_SELF:misc',do_lang_tempcode('MY_SUBSCRIPTIONS'))));

		$member_id = get_member();
		$id = get_param_integer('id');
		$is_locally_controlled = is_locally_controlled_subscription($id);
		$is_site_subscription  = is_site_subscription($id);

		$row = $GLOBALS['SITE_DB']->query_select('subscriptions',array('*'),array('id'=>$id));

		if(!array_key_exists(0,$row))	warn_exit('MISSING_RESOURCE');

		$via = $row[0]['s_via'];

		$success = true;

		if (($via!='manual') && ($via!=''))
		{
			if (!$is_locally_controlled)
			{
				require_code('hooks/systems/ecommerce_via/'.filter_naughty($via));
				$hook=object_factory('Hook_'.filter_naughty($via));

				if ($hook->auto_cancel($id)!==true)
				{
					require_code('mail');

					$success = false;

					if ($is_site_subscription)
					{
						$data = unserialize($row[0]['s_auto_fund_key']);
						$trans_id = $data['id'];
					}
					else
					{
						$trans_id=$GLOBALS['SITE_DB']->query_value('transactions','id',array('purchase_id'=>strval($id)));
					}

					$username=$GLOBALS['FORUM_DRIVER']->get_username($member_id);
					mail_wrap(do_lang('SUBSCRIPTION_CANCELLED_SUBJECT'),do_lang('SUBSCRIPTION_CANCELLED_BODY',$trans_id,$username));
				}
			}
		}

		if ($success)
		{
			$GLOBALS['SITE_DB']->query_update('subscriptions',array('s_state'=>'cancelled'),array('id'=>$id,'s_member_id'=>$member_id),'',1);

			if ($is_site_subscription)
			{
            //Delete profile id in authorize.net
		      $authorize_profile_id = get_ocp_cpf('authorize_cim_profile_id',$member_id);
		      if ($authorize_profile_id) {
					$hook->delete_cim_profile($authorize_profile_id);
		      }

				$GLOBALS['FORUM_DB']->query_update('f_members',array('m_subscription_started'=>0),array('id'=>$member_id));
				//set_member_subscription_failed($member_id);

				$url=build_url(array('page'=>'login','type'=>'logout'),get_module_zone('login'));
				return redirect_screen($title,$url,do_lang_tempcode('SUCCESS'));
			}
			else
			{
				$product			=	$row[0]['s_type_code'];
				$prod_object	=	find_product($product);
				$prod_object->cancel_order($id);
			}
		}

		$url = build_url(array('page'=>'_SELF'),'_SELF');
		$msg = ($success) ? do_lang_tempcode('SUCCESS') : do_lang_tempcode('SUBSCRIPTION_CANCEL_UNEXPECTED_ERROR');

		return redirect_screen($title,$url,$msg);
	}

	/**
	 * Display form fields for updating the subscription
	 *
	 * @return tempcode	The interface.
	 */
	function update()
	{
		$title     = get_page_title('SUBSCRIPTION_UPDATE');
		$id        = get_param_integer('id');
		$url       = build_url(array('page'=>'_SELF'),'_SELF');
		$no_action = false;

		breadcrumb_set_parents(array(array('_SELF:_SELF:misc',do_lang_tempcode('MY_SUBSCRIPTIONS'))));

		$rows = $GLOBALS['SITE_DB']->query_select('subscriptions',array('*'),array('id'=>$id));

		if(!array_key_exists(0,$rows)) warn_exit('MISSING_RESOURCE');

		$via = $rows[0]['s_via'];
		if ($via != 'manual' && $via != '')
		{
			require_code('hooks/systems/ecommerce_via/'.filter_naughty($via));
			$hook = object_factory('Hook_'.filter_naughty($via));

			if (method_exists($hook,'get_update_form_fields'))
			{
				list($fields,$hidden,$verified_account_logo) = $hook->get_update_form_fields($id);
			}
			else
			{
				$no_action = true;
			}

			$finish_url=build_url(array('page'=>'_SELF','type'=>'_update','id'=>$id,'redirect'=>get_param('redirect',NULL)),'_SELF');

			$result=do_template('UPDATE_WIZARD_STAGE',array('_GUID'=>'15cbba9733f6ff8610968418d8ab527e','ERROR_MSG'=>'','FIELDS'=>$fields,'VERIFIED_ACCOUNT_LOGO'=>$verified_account_logo,'HIDDEN'=>$hidden));
			return $this->wrap($result,$title,$finish_url);
		}
		else
		{
			$no_action = true;
		}

		if ($no_action)
		{
			return redirect_screen($title,$url,'');
		}
	}

	/**
	 * Wrap-up so as to remove redundancy in templates.
	 *
	 * @param  tempcode	To wrap.
	 * @param  tempcode	The title to use.
	 * @param  ?mixed		URL (NULL: no next URL).
	 * @param  boolean	Whether it is a GET form
	 * @return tempcode	Wrapped.
	 */
	function wrap($content,$title,$url,$get=false,$login_needed=NULL)
	{
		if (is_null($url)) $url='';
		require_javascript('javascript_validation');
		return do_template('UPDATE_WIZARD_SCREEN',array('_GUID'=>'a32c99acc28e8ad05fd9b5e2f2cda029','GET'=>$get?true:NULL,'TITLE'=>$title,'CONTENT'=>$content,'URL'=>$url,'NO_PROCEED'=>$login_needed));
	}

	/**
	 * Update subscription.
	 *
	 * @return tempcode	The interface.
	 */
	function _update()
	{
		$title       = get_page_title('SUBSCRIPTION_UPDATE');
		$id          = get_param_integer('id');
		$first_name	 =	post_param('first_name','');
		$last_name	 =	post_param('last_name','');
		$card_number =	post_param('card_number');
		$card_type   =	post_param('card_type','');
		$expiry_date =	post_param('expiry_date_year').'/'.post_param('expiry_date_month');
		$cv2			 =	post_param('cv2',NULL);
		$address1	 =	post_param('address1','');
		$city			 =	post_param('city','');
		$state		 =	post_param('state','');
		$zip			 =	post_param('zip','');
		$country		 =	post_param('country','');
		$url         = build_url(array('page'=>'_SELF'),'_SELF');

		$is_locally_controlled = is_locally_controlled_subscription($id);

		$row = $GLOBALS['SITE_DB']->query_select('subscriptions',array('*'),array('id'=>$id));

		if(!array_key_exists(0,$row))	warn_exit('MISSING_RESOURCE');

		$via = $row[0]['s_via'];

		if ($via != 'manual' && $via != '')
		{
			if ($is_locally_controlled)
			{
				$payment_details	=	array(
													'card_number'	=>	$card_number,
													'cv2'				=>	$cv2,
													'card_type'		=>	$card_type,
													'expiry_date'	=>	$expiry_date,
													'first_name'	=>	$first_name,
													'last_name'		=>	$last_name,
													'address'		=>	$address1,
													'city'			=>	$city,
													'state'			=>	$state,
													'zip'				=>	$zip,
													'country'		=>	$country
												);
				$GLOBALS['SITE_DB']->query_update('subscriptions',array('s_auto_fund_key'=>serialize($payment_details)),array('id'=>$id));

				return redirect_screen($title,$url,do_lang_tempcode('SUCCESS'));
			}
			else
			{
				require_code('hooks/systems/ecommerce_via/'.filter_naughty($via));
				$hook = object_factory('Hook_'.filter_naughty($via));

				list($success,$code,$sub_code,$message_raw) = $hook->update_subscription($id,$first_name,$last_name,$card_number,$card_type,$expiry_date,$cv2,$address1,$city,$state,$zip,$country);

				if (!$success)
				{
					$error_message = $hook->get_subscription_error($code,$message_raw);
					attach_message(do_lang_tempcode('TRANSACTION_ERROR',$error_message),'warn');
					return $this->update();
				}
				else
				{
					return redirect_screen($title,$url,do_lang_tempcode('SUCCESS'));
				}
			}
		}
		else
		{
			return redirect_screen($title,$url,'');
		}
	}
}


