<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		core_ocf
 */

class Module_delete
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']='Chris Graham';
		$info['organisation']='ocProducts';
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=2;
		$info['locked']=true;
		return $info;
	}

	/**
	 * Standard modular entry-point finder function.
	 *
	 * @return ?array	A map of entry points (type-code=>language-code) (NULL: disabled).
	 */
	function get_entry_points()
	{
		return array('misc'=>'DELETE_MEMBER');
	}

	/**
	 * Standard modular run function.
	 *
	 * @return tempcode	The result of execution.
	 */
	function run()
	{
		if (get_forum_type()!='ocf') warn_exit(do_lang_tempcode('NO_OCF')); else ocf_require_all_forum_stuff();

		require_code('ocf_members');
		require_code('ocf_members_action');
		require_code('ocf_members_action2');
      require_code('ecommerce');
      require_code('users_active_actions');
      require_code('catalogues2');
      require_lang('ecommerce');

		$member_id=get_param_integer('id',get_member());
		enforce_personal_access($member_id,'delete_account');

		$type=get_param('type','misc');

		if ($type=='misc') return $this->gui();
		if ($type=='actual') return $this->actual();

		return new ocp_tempcode();
	}

	/**
	 * The UI for deleting a member.
	 *
	 * @return tempcode	The UI.
	 */
	function gui()
	{
		$member_id=get_param_integer('id',get_member());

      $username=$GLOBALS['FORUM_DRIVER']->get_username($member_id);
		if (is_null($username)) warn_exit(do_lang_tempcode('USER_NO_EXIST'));
		$title=get_page_title('DELETE_MEMBER');

		$preview=do_lang_tempcode('_DELETE_MEMBER'.(($member_id==get_member())?'_SUICIDAL':''),$username);

		$url=build_url(array('page'=>'_SELF','type'=>'actual','id'=>$member_id),'_SELF');

		return do_template('CONFIRM_SCREEN',array('_GUID'=>'37653ef38707eff83bec2367a604c1fb','TITLE'=>$title,'PREVIEW'=>$preview,'URL'=>$url,'FIELDS'=>''));
	}

	/**
	 * The actualiser for deleting a member.
	 *
	 * @return tempcode	The UI.
	 */
	function actual()
	{
		$title = get_page_title('DELETE_MEMBER');

		$cancelation_success = false;
		$member_id           = get_param_integer('id');
		$username            = $GLOBALS['FORUM_DRIVER']->get_username($member_id);

		if (is_null($username)) warn_exit(do_lang_tempcode('USER_NO_EXIST'));

		$title = get_page_title('DELETE_MEMBER');

		if ($member_id==$GLOBALS['FORUM_DRIVER']->get_guest_id()) warn_exit(do_lang_tempcode('INTERNAL_ERROR'));

		$active_subscriptions = get_all_active_subscriptions($member_id);

      //cancel site subscriptions
      if(!is_null($active_subscriptions))
      {
         foreach ($active_subscriptions as $active_subscription) {

         	$data = unserialize($active_subscription['s_auto_fund_key']);
				$subscription_id = $data['id'];

				if ($active_subscription['s_type_code'] == 'site_subscription')  continue;

	         $via = $active_subscription['s_via'];
	         require_code('hooks/systems/ecommerce_via/'.filter_naughty_harsh($via));
	         $object = object_factory('Hook_'.$via);

	         $cancelation_success = $object->cancel_subscription($subscription_id,$member_id);

	         if($cancelation_success)
	         {
	         	$GLOBALS['SITE_DB']->query_update('subscriptions',array('s_state'=>'cancelled'),array('id'=>$active_subscription['id']),'',1);

         		$product			=	$active_subscription['s_type_code'];
					$prod_object	=	find_product($product);
					$prod_object->cancel_order($active_subscription['id']);
	         }
	         else
	         {
					warn_exit(do_lang_tempcode('DELETE_SUBSCRIPTION_ERROR'));
	         }
         }
      }

      $site_subscription = get_member_active_subscription_row($member_id);

      if (!is_null($site_subscription))
      {
      	$data = unserialize($site_subscription['s_auto_fund_key']);
			$subscription_id = $data['id'];

      	$via = $site_subscription['s_via'];
         require_code('hooks/systems/ecommerce_via/'.filter_naughty_harsh($via));
         $object = object_factory('Hook_'.$via);

         $cancelation_success = $object->cancel_subscription($subscription_id,$member_id);

         if($cancelation_success)
         {
         	$GLOBALS['SITE_DB']->query_update('subscriptions',array('s_state'=>'cancelled'),array('id'=>$site_subscription['id']),'',1);

            //Delete profile id in authorize.net
		      $authorize_profile_id = get_ocp_cpf('authorize_cim_profile_id',$member_id);
		      if ($authorize_profile_id) {
					$via = 'authorize';/*currently subscription through authorize only*/
					require_code('hooks/systems/ecommerce_via/'.filter_naughty_harsh($via));
					$object = object_factory('Hook_'.$via);

					$object->delete_cim_profile($authorize_profile_id);
		      }
         }
         else
         {
				warn_exit(do_lang_tempcode('DELETE_SITE_SUBSCRIPTION_ERROR'));
         }
      }

		//delete all pro contents
		delete_pro_contents($member_id);
      ocf_delete_member($member_id);

		if ($member_id==get_member())
		{
			handle_active_logout();
			init__users();
			$url=build_url(array('page'=>'login','type'=>'logout'),get_module_zone('login'));
			return redirect_screen($title,$url,do_lang_tempcode('SUCCESS'));
		}

		$url=build_url(array('page'=>'members','type'=>'misc'),get_module_zone('members'));
		return redirect_screen($title,$url,do_lang_tempcode('SUCCESS'));
	}
}
