<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		ecommerce
 */

class Module_card_details
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']='Naveen';
		$info['organisation']='ocProducts';
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=1;
		$info['locked']=false;
		return $info;
	}

	/**
	* Standard modular run function.
	*
	* @return tempcode	The result of execution.
	*/
	function run()
	{
		require_lang('ecommerce');
      require_code('ecommerce');
      require_code('users_active_actions');

		$type=get_param('type','misc');

		if($type=='misc') return $this->show_details();
		if($type=='_misc') return $this->save_details();
		if($type=='_cancel') return $this->cancel();

		return new ocp_tempcode();
	}

	/**
	* Function to display and edit card details
	*
	* @return tempcode	The result of execution.
	*/
	function show_details()
	{
		$member_id=get_member();

		$title=get_page_title('MANAGE_SUBSCRIPTION');

		$post_url=build_url(array('page'=>'_SELF','type'=>'_misc'),'_SELF');
		$cancel_url=build_url(array('page'=>'_SELF','type'=>'_cancel'),'_SELF');

		$card_details = $GLOBALS['FORUM_DB']->query_select('creditcard',array('*'),array('c_memberid'=>$member_id));

		if(count($card_details)) {
			if (get_db_type()=='xml') {
				$selCardNo = $card_details[0]['c_card_number'];
			} else {
				$selCardNo = get_decrypted_credit_card_number($member_id);
			}

			$selMonth = $card_details[0]['c_expiry_month'];
			$selYear = $card_details[0]['c_expiry_year'];
			list($ads1, $ads2, $ads3, $ads4, $ads5) = explode(',',$card_details[0]['c_address']);
		} else {
			if (get_option('ecommerce_test_mode')=='1')
			{
				$selCardNo = '4111111111111111';
			} else
			{
				$selCardNo = '';
			}
			$selMonth = NULL;
			$selYear = NULL;
			list($ads1, $ads2, $ads3, $ads4, $ads5) = array(NULL,NULL,NULL,NULL,NULL);
		}


		$currentYear = date('Y');
		$expiryYears = array();
		for ($i=$currentYear;$i<=($currentYear+50);$i++) {
			$expiryYears[] = array('YEAR'=>"$i");
		}

		$expiryMonths = array();
		for ($i = 1; $i <= 12; $i++) {
			$month = str_pad($i,2,0,STR_PAD_LEFT);
			$expiryMonths[] = array('MONTH'=>"$month");
		}

		return do_template('UPDATE_CARD_DETAILS',array('TITLE'=>$title,'CANCEL_URL'=>$cancel_url,'URL'=>$post_url,'MEMBERID'=>"$member_id",'EXPIRY_YEARS'=>$expiryYears,'EXPIRY_MONTHS'=>$expiryMonths,'SCARDNO'=>$selCardNo,'SMONTH'=>"$selMonth",'SYEAR'=>"$selYear",'ADDRESS1'=>"$ads1",'ADDRESS2'=>"$ads2",'CITY'=>"$ads3",'STATE'=>"$ads4",'ZIP'=>"$ads5"));
	}

	/**
	* Function to save card details
	*
	* @return tempcode	The result of execution.
	*/
	function save_details()
	{
		require_code('ocf_members');

		$title=get_page_title('UPDATE_CARD');
		$url = build_url(array('page'=>'_SELF','type'=>'misc'),'_SELF');

		$cardNumber  = post_param('credit_card_number');
		$expiryMonth = post_param('exp_date_month');
		$expiryYear  = post_param('exp_date_year');

		$address=post_param('address1').",".post_param('address2').",".post_param('city').",".post_param('state').",".post_param('zip');

		enter_credit_card_detail_for_member(get_member(),$cardNumber,$expiryMonth,$expiryYear,$address);

		return redirect_screen($title,$url,do_lang_tempcode('SUCCESS'));
	}

	/**
	* Function to cancel subscription
	*
	* @return tempcode	The result of execution.
	*/
	function cancel()
	{
		$title=get_page_title('CANCEL_SUBSCRIPTION');

      $url=build_url(array('page'=>''),'');

		$confirm=post_param_integer('confirm',0);
		if ($confirm==0)
		{
			$preview=do_lang_tempcode('CONFIRM_CANCEL_SUBSCRIPTION');
			$fields=form_input_hidden('confirm','1');
			$map=array('page'=>'_SELF','type'=>'_cancel');
			$url=build_url($map,'_SELF');
			return do_template('CONFIRM_SCREEN',array('TITLE'=>$title,'FIELDS'=>$fields,'URL'=>$url,'PREVIEW'=>$preview));
		}

      $member_id = get_member();
      $subscription_id = get_active_subscription_id($member_id);

      $member_row  = $GLOBALS['FORUM_DRIVER']->get_member_row($member_id);

      $typeCode = 'USERGROUP'.$member_row['m_primary_group'];

      $via = get_option('payment_gateway');
      require_code('hooks/systems/ecommerce_via/'.filter_naughty_harsh($via));
      $object = object_factory('Hook_'.$via);

      $result= $object->cancel_subscription($subscription_id);

		$cancelation_success = ($result && $result[0]) ? true : false;

      if($cancelation_success)
      {
         set_member_subscription_failed($member_id);

         save_subscription_detail($typeCode,$member_id,'site subscription canceled by member',0,$member_id,time(),'authorize',$subscription_id,'authorize');

         handle_active_logout();

         $message = do_lang_tempcode('CANCELLED_DONE');
      } else {
         $message = do_lang_tempcode('CANCELLED_NOT_DONE');
      }

      return redirect_screen($title,$url,$message);
	}
}