<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		quizzes
 */

require_code('aed_module');

class Module_admin_shipping extends standard_aed_module
{
	var $lang_type='EQUATION';
	var $select_name_description='DESCRIPTION_SHIPPING';
	var $select_name='EQUATION';
	var $permissions_require='high';
	var $donext_type=NULL;
	var $menu_label='SHIPPING';
	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']='Manuprathap';
		$info['organisation']='ocProducts';
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=2;
		$info['locked']=false;
		return $info;
	}

	/**
	 * Standard modular uninstall function.
	 */
	function uninstall()
	{
		$GLOBALS['SITE_DB']->drop_if_exists('shipping_equations');
	}

	/**
	 * Standard modular install function.
	 *
	 * @param  ?integer	What version we're upgrading from (NULL: new install)
	 * @param  ?integer	What hack version we're upgrading from (NULL: new-install/not-upgrading-from-a-hacked-version)
	 */
	function install($upgrade_from=NULL,$upgrade_from_hack=NULL)
	{
		$GLOBALS['SITE_DB']->create_table('shipping_equations',array(
				'id'				=>	'*AUTO',
				'title'			=>	'SHORT_TRANS',
				'description'	=>	'SHORT_TRANS',
				'equation'		=>	'SHORT_TEXT',
				'is_default'	=>	'BINARY',
				'add_date'		=>	'TIME',
			));
	}

	/**
	 * Standard modular specific-permission-overide finder function.
	 *
	 * @return array	A map of specific-permissions that are overridable; sp to 0 or 1. 0 means "not category overridable". 1 means "category overridable".
	 */
	function get_sp_overrides()
	{
		require_lang('shipping');
		return array('submit_highrange_content'=>1,'bypass_validation_highrange_content'=>1,'edit_own_highrange_content'=>1,'edit_highrange_content'=>1,'delete_own_highrange_content'=>1,'delete_highrange_content'=>1);
	}

	/**
	 * Standard modular entry-point finder function.
	 *
	 * @return ?array	A map of entry points (type-code=>language-code) (NULL: disabled).
	 */
	function get_entry_points()
	{
		return array_merge(array('misc'=>'MANAGE_SHIPPING_EQUATIONS'),parent::get_entry_points());
	}

	/**
	 * Standard aed_module run_start.
	 *
	 * @param  ID_TEXT		The type of module execution
	 * @return tempcode		The output of the run
	 */
	function run_start($type)
	{
		require_code('shipping');
		if ($type=='misc') return $this->misc();
		return new ocp_tempcode();
	}

	/**
	 * The do-next manager for before content management.
	 *
	 * @return tempcode		The UI
	 */
	function misc()
	{
		breadcrumb_set_self(do_lang_tempcode('EQUATION'));
		breadcrumb_set_parents(array(array('_SEARCH:admin_ecommerce:admin_shipping',do_lang_tempcode('ECOMMERCE'))));

		require_code('templates_donext');
		return do_next_manager(get_page_title('MANAGE_SHIPPING_EQUATIONS'),comcode_to_tempcode(do_lang('DOC_QUIZZES'),NULL,true),
					array(
						/*	 type							  page	 params													 zone	  */
						array('add_one',array('_SELF',array('type'=>'ad'),'_SELF'),do_lang('ADD_EQUATION')),
						array('edit_one',array('_SELF',array('type'=>'ed'),'_SELF'),do_lang('EDIT_EQUATION')),
					),
					do_lang('MANAGE_SHIPPING_EQUATIONS')
		);
	}

	/**
	 * Standard aed_module list function.
	 *
	 * @return tempcode		The selection list
	 */
	function nice_get_entries()
	{
		$_m=$GLOBALS['SITE_DB']->query_select('shipping_equations',array('id','title','is_default'));
		$entries=new ocp_tempcode();
		foreach ($_m as $m)
		{
			$title	=	get_translated_text($m['title']);
			$title	.=	($m['is_default'])?do_lang('DEFAULT_OPTION'):NULL;
			$entries->attach(form_input_list_entry(strval($m['id']),false,$title));
		}
		return $entries;
	}

	/**
	 * Get tempcode for a adding/editing form.
	 *
	 * @param  ID_TEXT		Title of equation
	 * @param  ?SHORT_TEXT	Description about the equation
	 * @param  SHORT_TEXT	Shipping equation
	 * @return tempcode		The form fields
	 */
	function get_form_fields($title='',$description='',$equation='',$defalut=0)
	{
		$fields=new ocp_tempcode();
		$fields->attach(form_input_line(do_lang_tempcode('TITLE'),do_lang_tempcode('DESCRIPTION_TITLE'),'title',$title,true));
		$fields->attach(form_input_line(do_lang_tempcode('DESCRIPTION'),do_lang_tempcode('DESCRIPTION_DESCRIPTION'),'description',$description,false));
		$fields->attach(form_input_line(do_lang_tempcode('EQUATION'),do_lang_tempcode('DESCRIPTION_EQUATION'),'equation',$equation,true));
		$fields->attach(form_input_tick(do_lang_tempcode('DEFAULT_OPTION'),do_lang_tempcode('DESCRIPTION_DEFAULT_OPTION'),'default',$defalut,true));
		return $fields;
	}

	/**
	 * Standard aed_module edit form filler.
	 *
	 * @param  ID_TEXT		The entry being edited
	 * @return tempcode		The fields
	 */
	function fill_in_edit_form($_id)
	{
		$id=intval($_id);

		$myrows=$GLOBALS['SITE_DB']->query_select('shipping_equations',array('*'),array('id'=>$id));
		if (!array_key_exists(0,$myrows))
		{
			warn_exit(do_lang_tempcode('MISSING_RESOURCE'));
		}
		$myrow=$myrows[0];

		return $this->get_form_fields(get_translated_text($myrow['title']),get_translated_text($myrow['description']),$myrow['equation'],$myrow['is_default']);
	}

	/**
	 * Standard aed_module add actualiser.
	 *
	 * @return ID_TEXT			The ID of the new entry
	 */
	function add_actualisation()
	{
		$title			=	post_param('title');
		$description	=	post_param('description',NULL);
		$equation		=	post_param('equation');
		if(@ereg('^(([0-9]*)([/+-\*(\? :)&|%]*)([$weight]*))+$', $equation)==false)	warn_exit(do_lang_tempcode('EQUATION_ERROR'));
		//Equation validation
		validate_equation($equation);
		$is_default		=	post_param_integer('default',0);
		$id=add_equation($title,$description,$equation,$is_default);
		return strval($id);
	}

	/**
	 * Standard aed_module edit actualiser.
	 *
	 * @param  ID_TEXT		The entry being edited
	 */
	function edit_actualisation($_id)
	{
		$id=intval($_id);
		$title			=	post_param('title');
		$description	=	post_param('description',NULL);
		$equation		=	post_param('equation');
		if(@ereg('^(([0-9]*)([/+-\*(\? :)&|%]*)([$weight]*))+$', $equation)==false)	warn_exit(do_lang_tempcode('EQUATION_ERROR'));
		//Equation validation
		validate_equation($equation);
		$is_default		=	post_param_integer('default',0);
		edit_equation($id,$title,$description,$equation,$is_default);
	}

	/**
	 * Standard aed_module delete actualiser.
	 *
	 * @param  ID_TEXT		The entry being deleted
	 */
	function delete_actualisation($_id)
	{
		$id=intval($_id);
		delete_equation($id);
	}
}


