<?php

	/**
	 * The do-next manager for before usage management.
	 *
	 * @return tempcode		The UI
	 */
	function usage()
	{
		breadcrumb_set_parents(array());

		require_lang('shopping');
		require_lang('permissions');
		require_lang('credits');
		
		$also_url=build_url(array('page'=>'_SELF','type'=>'misc'),'_SELF');
		attach_message(do_lang_tempcode('ALSO_SEE_SETUP',escape_html($also_url->evaluate())),'inform');

		require_code('templates_donext');
		return do_next_manager(get_page_title('ECOMMERCE'),comcode_to_tempcode(do_lang('DOC_ECOMMERCE'),NULL,true),
					array(
						/*	 type							  page	 params													 zone	  */
						array('cash_flow',array('_SELF',array('type'=>'cash_flow'),'_SELF'),do_lang('CASH_FLOW')),
						array('profit_loss',array('_SELF',array('type'=>'profit_loss'),'_SELF'),do_lang('PROFIT_LOSS')),
						array('add_to_category',array('_SELF',array('type'=>'trigger'),'_SELF'),do_lang('MANUAL_TRANSACTION')),
						array('transactions',array('_SELF',array('type'=>'logs'),'_SELF'),do_lang('LOGS')),
						array('invoices',array('admin_invoices',array('type'=>'misc'),get_module_zone('admin_invoices')),do_lang('INVOICES')),
						array('orders',array('admin_orders',array('type'=>'misc'),get_module_zone('admin_orders')),do_lang('ORDERS')),
						array('permission_products',array('admin_permissions_products',array('type'=>'misc'),get_module_zone('admin_permissions_products')),do_lang('PERMISSION_PRODUCTS')),
						array('user_orders',array('admin_orders',array('type'=>'user_orders'),get_module_zone('admin_orders')),do_lang('USER_ORDERS')),
						array('shipping_equations',array('admin_shipping',array('type'=>'misc'),get_module_zone('admin_shipping')),do_lang('ADMIN_SHIPPING')),
						array('pointslog',array('admin_credits',array('type'=>'logs'),get_module_zone('admin_credits')),do_lang('CREDITS')),
						array('shipping_equations',array('_SELF',array('type'=>'tax_rates'),'_SELF'),do_lang('MANAGE_TAX_RATES')),
						array('gift_vouchers',array('admin_gift_vouchers',array('type'=>'misc'),get_module_zone('admin_gift_vouchers')),do_lang('ADMIN_GIFT_VOUCHERS')),
					),
					do_lang('ECOMMERCE')
		);
	}
