<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license	http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package	shipping
 */

/**
 * Save shipping equation to the db
 *
 *	@param	ID_TEXT		Title
 *	@param	SHORT_TEXT	Description
 *	@param	SHORT_TEXT	Equation
 *	@param	BINARY		Whether this option is a default method or not
 * @return  AUTO_LINK	Equation Id
 */
function add_equation($title,$description,$equation,$is_default)
{
	if($is_default)
	{
		if(!is_null($GLOBALS['SITE_DB']->query_value_null_ok('shipping_equations','id',array('is_default'=>1))))
			$GLOBALS['SITE_DB']->query_update('shipping_equations',array('is_default'=>0));
	}

	$id	=	$GLOBALS['SITE_DB']->query_insert('shipping_equations',array('title'=>insert_lang($title,2),'description'=>insert_lang($description,2),'equation'=>$equation,'is_default'=>$is_default,'add_date'=>time()),true);
	return $id;
}

/**
 * Modify a shipping equation.
 *
 * @param	AUTO_LINK	Equation Id
 *	@param	ID_TEXT		Title
 *	@param	SHORT_TEXT	Description
 *	@param	SHORT_TEXT	Equation
 *	@param	BINARY		Whether this option is a default method or not
 * @return 	BINARY		Update status
*/
function edit_equation($id,$title,$description,$equation,$is_default)
{
	if($is_default)
	{
		if(!is_null($GLOBALS['SITE_DB']->query_value_null_ok('shipping_equations','id',array('is_default'=>1))))
			$GLOBALS['SITE_DB']->query_update('shipping_equations',array('is_default'=>0));
	}
	return $GLOBALS['SITE_DB']->query_update('shipping_equations',array('title'=>insert_lang($title,2),'description'=>insert_lang($description,2),'equation'=>$equation,'is_default'=>$is_default),array('id'=>$id),'',1);
}

/**
 * Modify a shipping equation.
 *
 *	@param	AUTO_LINK	Equation Id
*/
function delete_equation($id)
{
	$GLOBALS['SITE_DB']->query_delete('shipping_equations',array('id'=>$id),'',1);
}

/**
 * Validate shipping equation
 *
 *	@param	AUTO_LINK	Equation Id
*/
function validate_equation($equation)
{
	$weight			=	10;
	$equation_to_validation		=	'$shipping_cost= '.$equation.';';
	$status			=	@eval($equation_to_validation);
	if(!is_null($status))	warn_exit(do_lang_tempcode('EQUATION_INVALID'));
}
