<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		ecommerce
 */

class Hook_other
{

	/**
	 * Function for administrators to pick an identifier (only used by admins, usually the identifier would be picked via some other means in the wider ocPortal codebase).
	 *
	 * @param  ID_TEXT		Product type code.
	 * @return ?tempcode		Input field in standard Tempcode format for fields (NULL: no identifier).
	 */
	function get_identifier_manual_field_inputter($type_code)
	{
		unset($type_code);

		return NULL;
	}

	/**
	 * Get the products handled by this eCommerce hook.
    *
	 * IMPORTANT NOTE TO PROGRAMMERS: This function may depend only on the database, and not on get_member() or any GET/POST values.
    *  Such dependencies will break IPN, which works via a Guest and no dependable environment variables. It would also break manual transactions from the Admin Zone.
	 *
	 * @return array	A map of product name to list of product details.
	 */
	function get_products()
	{
		$products=array(
			'OTHER'=>array(PRODUCT_OTHER,'?','',array('id'=>0)),
		);
		return $products;
	}

	/**
	 * Check whether the product has shipping feature
	 *
	 * @return boolean	Whether it is.
	 */
	function has_shipping_feature()
	{
		return false;
	}

}


