<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		core
 */

/**
 * Set values to the cpfs of a member
 *
 * @param	array		Cpf ids and values in array ( format array('cpf_name'=>$value,'cpf_2_name'=>$value2) )
 *	@param	?USER		Member ID (NULL will take current logged in member)
 * @return	NULL		NULL
 */
function set_ocp_cpfs($cus_flds,$member_id=NULL)
{
	require_code('ocf_members');
	if(is_null($member_id))	$member_id	=	get_member();

	$all_fields	=	ocf_get_all_custom_fields_match(NULL);
	$map			=	array();
	foreach($all_fields as $field)
	{
		$fld_name	=	get_translated_text($field['cf_name']);
		if(array_key_exists($fld_name,$cus_flds))
		{
			$map['field_'.$field['id']]	=	$cus_flds[$fld_name];
		}
	}

	if(count($map)>0)
	{
		$GLOBALS['FORUM_DB']->query_update('f_member_custom_fields',$map,array('mf_member_id'=>$member_id));
	}
}
