<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		ecommerce
 */

class Hook_paypal
{
	/**
	* Get some title/description about payment method
	*
	* @return SHORT_TEXT		Title/Description about paypal
	*/
	function info()
	{
		return do_lang('PAYPAL_DESCRIPTION');
	}

	/**
	 * Function to install paypal config options
	 */
	function install_config()
	{
		add_config_option('PAYPAL_ENABLE','paypal_enable','special_group__tick_control__paypal__tick','return\'0\';','ECOMMERCE','PAYMENT_GATEWAY');
		add_config_option('IPN_ADDRESS_TEST','ipn_test','special_group__tick_control__paypal__line','return \'\';','ECOMMERCE','PAYMENT_GATEWAY');
		add_config_option('IPN_ADDRESS','ipn','special_group__tick_control__paypal__line','return \'\';','ECOMMERCE','PAYMENT_GATEWAY');
		add_config_option('PAYPAL_API_USERNAME','paypal_api_username','special_group__tick_control__paypal__line','return \'\';','ECOMMERCE','PAYMENT_GATEWAY');
		add_config_option('PAYPAL_API_PASSWORD','paypal_api_password','special_group__tick_control__paypal__line','return \'\';','ECOMMERCE','PAYMENT_GATEWAY');
		add_config_option('PAYPAL_API_SIGNATURE','paypal_api_signature','special_group__tick_control__paypal__line','return \'\';','ECOMMERCE','PAYMENT_GATEWAY');
		add_config_option('PAYPAL_TEST_API_USERNAME','paypal_test_api_username','special_group__tick_control__paypal__line','return \'\';','ECOMMERCE','PAYMENT_GATEWAY');
		add_config_option('PAYPAL_TEST_API_PASSWORD','paypal_test_api_password','special_group__tick_control__paypal__line','return \'\';','ECOMMERCE','PAYMENT_GATEWAY');
		add_config_option('PAYPAL_TEST_API_SIGNATURE','paypal_test_api_signature','special_group__tick_control__paypal__line','return \'\';','ECOMMERCE','PAYMENT_GATEWAY');
		add_config_option('LOCAL_SUBSCRIPTION_METHODS','paypal_local_subscription_methods','special_group__tick_control__paypal__list','return \'automatic\';','ECOMMERCE','PAYMENT_GATEWAY',0,'automatic|local_controlled');
	}

	/**
	 * Function to unistall paypal config options
	 */
	function uninstall_config()
	{
		delete_config_option('paypal_enable');
		delete_config_option('ipn_test');
		delete_config_option('ipn');
		delete_config_option('paypal_api_username');
		delete_config_option('paypal_api_password');
		delete_config_option('paypal_api_signature');
		delete_config_option('paypal_test_api_username');
		delete_config_option('paypal_test_api_password');
		delete_config_option('paypal_test_api_signature');
		delete_config_option('paypal_local_subscription_methods');
	}

	/**
	* Get logos/verified seal of payment method
	*
	* @return tempcode	Logo/verified sign
	*/
	function get_confidence_logos()
	{
		require_css('ecommerce');
		$logo	=	'<a href="https://seal.verisign.com/splash?form_file=fdf/splash.fdf&amp;dn=SCGI.EBAY.COM&amp;lang=en"><img border="0" alt="paypal logo" src="http://www.paypal.com/en_US/i/icon/verification_seal.gif"/></a>';

		$read_text_link	=	build_url(array('page'=>'purchase','type'=>'payment_note','screen'=>'secure_payment_paypal','wide_high'=>1),get_module_zone('purchase'));

		$read_text_link	=	$read_text_link->evaluate();

		$js	=	"function secure_shopping_notes() {
                	window.open('$read_text_link','ruleswindow','menubar=1,resizable=1,scrollbars=1,width=970,height=650');
                  return false;
               }";
		return do_template('VERIFIED_MERCHANT_LOGO_SCREEN',array('LOGO'=>$logo,'READ_TEXT_LINK'=>$read_text_link,'JAVASCRIPT'=>$js,'PAYMENT_PROCESSING_LINK'=>'','PAYMENT_TEXT_URL'=>'site:secure_payment_authorize'));
	}

	/**
	 * Find the payment gateway enabled or not
	 *
	 * @return BINARY		Enabled/Disabled
	 */
	function is_enabled()
	{
		return get_option('paypal_enable');
	}

	/**
	 * Get gateway CPFs
	 *
	 * @return array
	 */
	function get_gateway_cpfs()
	{
		return array('paypal_api_username','paypal_api_password','paypal_api_signature');
	}

	/**
	 * Whether the cpf is of this gateway
	 *
	 * @param SHORT_TEXT The cpf
	 * @return bool
	 */
	function is_gateway_cpf($cpf)
	{
		return in_array($cpf,$this->get_gateway_cpfs());
	}

	/**
	 * Show option buton
	 *
	 *	@return tempcode	Form for paypal option
	 */
	function show_option_button($product)
	{
		return do_template('PAYPAL_OPTION_BUTTON',array('URL'=>get_self_url()));
	}

	/**
	 * Get the PayPal payment address.
	 *
	 * @return string			The answer.
	 */
	function _get_payment_address($seller=NULL)
	{
		$member_paypal_address = (!is_null($seller) && get_option('enable_member_payments')) ? get_ocp_cpf('paypal_address',$seller) : NULL;

		if(is_null($member_paypal_address) || $member_paypal_address=='')
			return	ecommerce_test_mode()?get_option('ipn_test'):get_option('ipn');
		else
			return	$member_paypal_address;
	}

	/**
	 * Get the PayPal IPN URL.
	 *
	 * @return URLPATH		The IPN url.
	 */
	function get_ipn_url()
	{
		return ecommerce_test_mode()?'https://www.sandbox.paypal.com/cgi-bin/webscr':'https://www.paypal.com/cgi-bin/webscr';
	}

	/**
	 * Make a transaction (payment) button.
	 *
	 * @param  ID_TEXT		The product codename.
	 * @param  SHORT_TEXT	The human-readable product title.
	 * @param  ID_TEXT		The purchase ID.
	 * @param  float			A transaction amount.
	 * @param  ID_TEXT		The currency to use.
	 * @return tempcode		The button
	 */
	function make_transaction_button($product,$item_name,$purchase_id,$amount,$currency,$seller=NULL)
	{
		$payment_address	=	$this->_get_payment_address($seller);

		$ipn_url				=	$this->get_ipn_url();
		$user_details		=	array();

		if(!is_guest() && get_ocp_cpf('firstname')!='' && get_ocp_cpf('lastname')!='' && get_ocp_cpf('building_name_or_number')!='' && get_ocp_cpf('city')!='' && get_ocp_cpf('state')!='' && get_ocp_cpf('post_code')!='' && get_ocp_cpf('country')!='')
		{
			$user_details['first_name']	=	get_ocp_cpf('firstname');
			$user_details['last_name']		=	get_ocp_cpf('lastname');
			$user_details['address1']		=	get_ocp_cpf('building_name_or_number');
			$user_details['city']			=	get_ocp_cpf('city');
			$user_details['state']			=	get_ocp_cpf('state');
			$user_details['zip']				=	get_ocp_cpf('post_code');
			$user_details['country']		=	get_ocp_cpf('country');
		}

		return do_template('ECOM_BUTTON_VIA_PAYPAL',array('_GUID'=>'b0d48992ed17325f5e2330bf90c85762','PRODUCT'=>urlencode($product),'ITEM_NAME'=>$item_name,'PURCHASE_ID'=>strval($purchase_id),'AMOUNT'=>float_to_raw_string($amount),'CURRENCY'=>$currency,'PAYMENT_ADDRESS'=>$payment_address,'IPN_URL'=>$ipn_url,'MEMBER_ADDRESS'=>$user_details));
	}

	/**
	 * Make a subscription (payment) button.
	 *
	 * @param  ID_TEXT		The product codename.
	 * @param  SHORT_TEXT	The human-readable product title.
	 * @param  ID_TEXT		The purchase ID.
	 * @param  float			A transaction amount.
	 * @param  integer		The subscription length in the units.
	 * @param  ID_TEXT		The length units.
	 * @set    d w m y
	 * @param  ID_TEXT		The currency to use.
	 * @return tempcode		The button
	 */
	function make_subscription_button($product,$item_name,$purchase_id,$amount,$length,$length_units,$currency)
	{
		$payment_address	=	$this->_get_payment_address();
		$ipn_url				=	$this->get_ipn_url();

		//Add subscription fee
		$first_amt		=	$amount+floatval(get_option('sub_one_time_fee'));
		$recurring_amt	=	$amount+floatval(get_option('sub_recurring_fee'));

		return do_template('ECOM_SUBSCRIPTION_BUTTON_VIA_PAYPAL',array('PRODUCT'=>urlencode($product),'ITEM_NAME'=>$item_name,'LENGTH'=>strval($length),'LENGTH_UNITS'=>$length_units,'PURCHASE_ID'=>$purchase_id,'FIRST_AMOUNT'=>float_to_raw_string($first_amt),'AMOUNT'=>float_to_raw_string($recurring_amt),'CURRENCY'=>$currency,'PAYMENT_ADDRESS'=>$payment_address,'IPN_URL'=>$ipn_url));
	}

	/**
	 * Make a subscription cancellation button.
	 *
	 * @param  ID_TEXT		The purchase ID.
	 *	@param	ID_TEXT		Serialized data which stores transaction keys
	 * @return tempcode		The button
	 */
	function make_cancel_button($purchase_id,$auto_found_key=NULL)
	{
		$recur_det	=	(!is_null($auto_found_key))?unserialize($auto_found_key):NULL;
		$remote_cancellation	=	false;
		if(is_array($recur_det) && $recur_det['type']=='website_payment_pro')
		{
			$url	=	build_url(array('page'=>'subscriptions','type'=>'cancel','id'=>$purchase_id),get_module_zone('subscriptions'));
			$url	=	$url->evaluate();
		}
		elseif(is_array($recur_det) && $recur_det['type']=='website_payment_standard')
		{
			$remote_cancellation	=	true;
			$trans_id	=	$recur_det['id'];
			$url = (get_option('ecommerce_test_mode')=='1') ? "https://www.sandbox.paypal.com/cgi-bin/webscr" : "https://history.paypal.com/cgi-bin/webscr?cmd=_subscr-details&amp;search_trans_id=$trans_id";
		}
		else
			$url	=	'';

		return do_template('ECOM_CANCEL_BUTTON_VIA_PAYPAL',array('URL'=>$url,'REMOTE_CANCEL'=>$remote_cancellation));
	}

	/**
	 * Find a transaction fee from a transaction amount. Regular fees aren't taken into account.
	 *
	 * @param  float	A transaction amount.
	 * @return float	The fee
	 */
	function get_transaction_fee($amount)
	{
		//return round(0.25+0.034*$amount,2);
		return round(floatval(get_option('paypal_transaction_flat_cost'))+floatval(get_option('paypal_transaction_percentage_cost'))*$amount,2);
	}

	/**
	 * Handle IPN's. The function may produce output, which would be returned to the Payment Gateway. The function may do transaction verification.
	 *
	 * @return array	A long tuple of collected data.
	 */
	function handle_transaction()
	{
		if ((file_exists(get_file_base().'/data_custom/ecommerce.log')) && (is_writable_wrap(get_file_base().'/data_custom/ecommerce.log')))
		{
			$myfile=fopen(get_file_base().'/data_custom/ecommerce.log','at');
			fwrite($myfile,serialize($_POST).chr(10));
			fclose($myfile);
		}

		//check for the recurring API response
		$is_recurring_api_response = is_null(post_param('recurring_payment_id',NULL)) ? false : true;

		// assign posted variables to local variables
		$purchase_id	 =	($is_recurring_api_response) ? post_param('product_name','-1') : post_param('custom','-1');
		$txn_type		 =	post_param('txn_type',NULL);
		$item_name      = (substr(post_param('txn_type',''),0,6)=='subscr') ? find_item_name_of_order($purchase_id) : find_item_name_of_subscription($purchase_id);
		$reason_code    = post_param('reason_code','');
		$pending_reason = post_param('pending_reason','');
		$memo           = post_param('memo','');
		$mc_gross       = ($is_recurring_api_response) ? post_param('amount','') : post_param('mc_gross','');
		$mc_currency    = ($is_recurring_api_response) ? post_param('currency_code','') : post_param('mc_currency','');
		$parent_txn_id  = post_param('parent_txn_id','-1');
		$receiver_email = post_param('receiver_email');

		if ($is_recurring_api_response)
		{
			$txn_id = post_param('recurring_payment_id','');
		}
		else
		{
			if (!is_null(post_param('subscr_id',NULL)))
			{
				$txn_id = post_param('subscr_id');
			} else
			{
				$txn_id = post_param('txn_id','');
			}
		}

		// post back to PayPal system to validate
		require_code('files');
		$pure_post=isset($GLOBALS['PURE_POST'])?$GLOBALS['PURE_POST']:$_POST;
		$x=0;
		$res=mixed();
		do
		{
			$res=http_download_file('http://'.(ecommerce_test_mode()?'www.sandbox.paypal.com':'www.paypal.com').'/cgi-bin/webscr',NULL,false,false,'ocPortal',$pure_post+array('cmd'=>'_notify-validate'));
			$x++;
		}
		while ((is_null($res)) && ($x<3));
		if (is_null($res)) my_exit(do_lang('IPN_SOCKET_ERROR'));
		if (!(strcmp($res,'VERIFIED')==0)) my_exit(do_lang('IPN_UNVERIFIED').' - '.$res.' - '.flatten_slashed_array($pure_post));

		$txn_type = str_replace('-','_',post_param('txn_type'));

		switch ($txn_type)
		{
			case 'subscr_signup':
				$payment_status = 'Completed';
				$mc_gross = post_param('mc_amount3');
				if (post_param_integer('recurring')!=1) my_exit(do_lang('IPN_SUB_RECURRING_WRONG'));
				break;

			case 'recurring_payment_profile_created':
				$payment_status = 'Completed';
				break;

			case 'subscr_modify':
			case 'recurring_payment_profile_modify':
				$payment_status = 'SModified';
				$txn_id .= '-m';
				break;

			case 'subscr_cancel':
			case 'recurring_payment_profile_cancel':
				$payment_status = 'SCancelled';
				$txn_id .= '-c';
				break;

			default:
				$payment_status = post_param('payment_status','');
		}

		//Find order seller
		$order_object	=	find_product($item_name);
		$seller			=	method_exists($order_object,'get_seller')?$order_object->get_seller($order_object->product_id[3]['id']):NULL;
		$payment_add	=	$this-> _get_payment_address($seller);

		if($receiver_email!=$payment_add)	my_exit(do_lang('IPN_EMAIL_ERROR'));

		if(addon_installed('shopping'))
		{
			$this->store_shipping_address($purchase_id,true);
		}

		return array($purchase_id,$item_name,$payment_status,$reason_code,$pending_reason,$memo,$mc_gross,$mc_currency,$txn_id,$parent_txn_id);
	}

	/**
	 * Make a transaction (payment) button for multiple shopping cart items
	 *
	 * @param  array			Items array
	 * @param  tempcode		Currency symbol
	 * @param  AUTO_LINK		Order Id
	 * @return tempcode		The button
	 */
	function make_cart_transaction_button($items,$currency,$order_id)
	{
		$payment_address	=	NULL;
		require_code('hooks/systems/ecommerce/'.filter_naughty_harsh('cart_orders'));
		$object				=	object_factory('Hook_'.filter_naughty_harsh('cart_orders'));
		$seller				=	$object->get_seller(do_lang('PRODUCT_ORDERS',strval($order_id)));
		$payment_address	=	$this->_get_payment_address($seller);
		$ipn_url				=	$this->get_ipn_url();

		$notification_text	=	do_lang_tempcode('CHECKOUT_NOTIFICATION_TEXT',$order_id);
		$user_details			=	array();

		if(!is_guest() && get_ocp_cpf('firstname')!='' && get_ocp_cpf('lastname')!='' && get_ocp_cpf('building_name_or_number')!='' && get_ocp_cpf('city')!='' && get_ocp_cpf('state')!='' && get_ocp_cpf('post_code')!='' && get_ocp_cpf('country')!='')
		{
			$user_details['first_name']	=	get_ocp_cpf('firstname');
			$user_details['last_name']		=	get_ocp_cpf('lastname');
			$user_details['address1']		=	get_ocp_cpf('building_name_or_number');
			$user_details['city']			=	get_ocp_cpf('city');
			$user_details['state']			=	get_ocp_cpf('state');
			$user_details['zip']				=	get_ocp_cpf('post_code');
			$user_details['country']		=	get_ocp_cpf('country');
		}

		return do_template('ECOM_CART_BUTTON_VIA_PAYPAL',array('ITEMS'=>$items,'CURRENCY'=>$currency,'PAYMENT_ADDRESS'=>$payment_address,'IPN_URL'=>$ipn_url,'ORDER_ID'=>strval($order_id),'NOTIFICATION_TEXT'=>$notification_text,'MEMBER_ADDRESS'=>$user_details));
	}

	/**
	 * Store shipping address for orders
	 *
	 * @param  AUTO_LINK		Order id
	 * @param  bool		   Whether this function is calling while getting the IPN reponse
	 * @return ?mixed			Address id (NULL: No address record found)
	 */
	function store_shipping_address($order_id,$is_from_ipn=false)
	{
		$shipping_address	=	array();

		if(is_null($GLOBALS['SITE_DB']->query_value_null_ok('shopping_order_addresses','id',array('order_id'=>$order_id))))
		{
			$shipping_address['order_id']			 =	$order_id;
			$shipping_address['address_name']	 =	($is_from_ipn) ? post_param('address_name','') : post_param('ship_first_name','')." ".post_param('ship_last_name','');
			$shipping_address['address_street']	 =	($is_from_ipn) ? post_param('address_street','') : post_param('ship_addr_1','');
			$shipping_address['address_city']	 =	($is_from_ipn) ? post_param('address_city','') : post_param('ship_city','');
			$shipping_address['address_state']	 =	($is_from_ipn) ? post_param('address_state','') : post_param('ship_state','');
			$shipping_address['address_zip']		 =	($is_from_ipn) ? post_param('address_zip','') : post_param('ship_post_code','');
			$shipping_address['address_country'] =	($is_from_ipn) ? post_param('address_country','') : post_param('shipping_country','');
			$shipping_address['receiver_email']	 =	'';//post_param('receiver_email','');

			$shipping_name      = explode(' ',$shipping_address['address_name']);
			$shipping_firstname = ($shipping_name && isset($shipping_name[0])) ? $shipping_name[0] : '';
			$shipping_lastname  = ($shipping_name && isset($shipping_name[1])) ? $shipping_name[1] : '';

			$cpfs_to_save = array
										(
											'ocp_shipping_firstname' => $shipping_firstname,
											'ocp_shipping_lastname'	 => $shipping_lastname,
											'ocp_shipping_street'	 => $shipping_address['address_street'],
											'ocp_shipping_country'   => $shipping_address['address_country'],
											'ocp_shipping_state'		 => $shipping_address['address_state'],
											'ocp_shipping_city'	    => $shipping_address['address_city'],
											'ocp_shipping_zip'		 => $shipping_address['address_zip']
										);
			set_ocp_cpfs($cpfs_to_save);

			return $GLOBALS['SITE_DB']->query_insert('shopping_order_addresses',$shipping_address,true);
		}
	}

	/**
	 * Function to detect whether the member has payment(address) details in his profile
	 *
	 * @param  USER			Member Id
	 * @return BINARY			Status of payment setting by the user
	 */
	function user_has_payment_setting($member=NULL)
	{
		if(is_null($member))	$member	=	get_member();

		return (get_ocp_cpf('building_name_or_number')!='' && get_ocp_cpf('state')!='' && get_ocp_cpf('post_code')!='' && get_ocp_cpf('country')!='');
	}

	/**
	* Get form fields for local payment.
	*
	* @param  ?ID_TEXT		The transaction ID (NULL: auto-generate)
	* @param  ID_TEXT		The purchase ID
	* @param  SHORT_TEXT	The item name
	* @param  SHORT_TEXT	The amount
	* @param  ?integer		The length (NULL: not a subscription)
	* @param  ID_TEXT		The length units
	* @return tempcode		The form fields
	*/
	function get_transaction_form_fields($trans_id,$purchase_id,$item_name,$amount,$length,$length_units)
	{
		require_code('ecommerce');
		if(is_null($trans_id))	$trans_id=$this->generate_trans_id();

		list($card_det,$hidden)	=	get_general_transaction_form_fields($trans_id,$purchase_id,$item_name,$amount,$length,$length_units,$this);

		/*	General transaction fields returned from ecommerce api, attaching the details to the form.
			The fields can add/remove here, depending on the customised payment gateway features.
		*/
		$fields	=	new ocp_tempcode();
		foreach($card_det as $field)
		{
			$fields->attach($field);
		}

		$hidden->attach(form_input_hidden('payment_gateway','paypal'));

		$verified_account_logo	=	$this->get_confidence_logos();
		return array($fields,$hidden,$verified_account_logo);
	}

	/**
	 * Whether the member could enter the subscription start date in the payment form
	 *
	 * @return boolean
	 */
	function is_allow_subscription_start_date()
	{
		return true;
	}

	/**
	 * Whether to allow shipping detail in the local payment form
	 *
	 * @return boolean
	 */
	function is_allow_shipping()
	{
		return true;
	}

	/**
	 * Get a list of card types.
	 *
	 * @param  ?string	The card type to select by default (NULL: don't care)
	 * @return tempcode	The list
	 */
	function nice_get_card_types($it=NULL)
	{
		$list=new ocp_tempcode();
		$array=array('Visa','MasterCard','Discover','American Express');
		foreach ($array as $x)
		{
			$list->attach(form_input_list_entry($x,$it==$x));
		}
		return $list;
	}

	/**
	 * Generate a transaction ID.
	 *
	 * @return string			A transaction ID.
	 */
	function generate_trans_id()
	{
		return md5(uniqid(strval((mt_rand(0,32000))),true));
	}

	/**
	 * Perform a transaction.
	 *
	 * @param  ?ID_TEXT		The transaction ID (NULL: generate one)
	 * @param  SHORT_TEXT	Cardholder first name
	 * @param  SHORT_TEXT	Cardholder last name
	 * @param  SHORT_TEXT	Card number
	 * @param  SHORT_TEXT	Transaction amount
	 * @param  SHORT_TEXT	Card Expiry date
	 * @param  integer		Card Issue number
	 * @param  SHORT_TEXT	Card Start date
	 * @param  SHORT_TEXT	Card Type
	 * @set    "Visa" "Master Card" "Switch" "UK Maestro" "Maestro" "Solo" "Delta" "American Express" "Diners Card" "JCB"
	 * @param  SHORT_TEXT	Card CV2 number (security number)
	 * @param  ?integer		The subscription length in the units. (NULL: not a subscription)
	 * @param  ?ID_TEXT		The length units. (NULL: not a subscription)
	 * @set    d w m y
	 * @param  SHORT_TEXT	Description for the transaction
	 * @param  ?MEMBER		Member making the transaction (NULL: current member)
	 * @param  SHORT_TEXT	Address for card
	 * @param  SHORT_TEXT	City for card
	 * @param  SHORT_TEXT	State for card
	 * @param  SHORT_TEXT	Zip/post-code for card
	 * @param  SHORT_TEXT	Country for card
	 * @param  SHORT_TEXT	Shipping Address for card
	 * @param  SHORT_TEXT	Shipping City for card
	 * @param  SHORT_TEXT	Shipping State for card
	 * @param  SHORT_TEXT	Shipping Zip/post-code for card
	 * @param  SHORT_TEXT	Shipping Country for card
	 * @param  integer		Total occurence for subscription
	 * @param  integer		Total trial occurence for subscription
	 * @param  integer		Trial amount for subscription
	 * @return array			A tuple: success (boolean), trans-id (string), message (string), raw message (string)
	 */
	function do_transaction($trans_id=NULL,$first_name,$last_name,$card_number,$amount,$expiry_date,$issue_number,$start_date,$card_type,$cv2,$length=NULL,$length_units=NULL,$description='',$member_id=NULL,$address='',$city='',$state='',$zip='',$country='',$shipping_first_name='',$shipping_last_name='',$shipping_address='',$shipping_city='',$shipping_state='',$shipping_zip='',$shipping_country='',$total_occurrences=9999,$trial_occurrences=0,$trial_amount=0)
	{
		if(is_null($trans_id)) $trans_id = $this->generate_trans_id();

		$purchase_id  = post_param_integer('customfld1','-1');
		$card_number  = str_replace(' ','',$card_number);
		$expiry_month = substr($expiry_date,5,2);
		$expiry_year  = substr($expiry_date,0,4);

      if (!is_null($length))
		{
			if($length_units=='m')	$billing_period =	'Month';
			if($length_units=='d')	$billing_period =	'Day';
			if($length_units=='y')  $billing_period =	'Year';

         $this->set_recurring_api_parameters($purchase_id,$length,$billing_period,$card_type,$card_number,$cv2,$expiry_month,$expiry_year,$start_date,$description,$amount,$first_name,$last_name,$address,$city,$state,$zip,$country,$shipping_first_name,$shipping_last_name,$shipping_address,$shipping_city,$shipping_state,$shipping_zip,$shipping_country,$member_id);

         $response = http_download_file($this->api_endpoint,NULL,true,false,'ocPortal',$this->api_parameters,NULL,NULL,NULL,NULL,NULL,NULL,NULL,20.0);

         if (!is_null($response))
			{
				$response_result = $this->deformat_nvp($response);
				$success = (strtoupper(trim($response_result['ACK'])) == 'SUCCESS' || strtoupper(trim($response_result['ACK'])) == 'SUCCESSWITHWARNING') ? true: false;
	         $response_code = ($success) ? $response_result['PROFILEID'] : $response_result['L_ERRORCODE0'];
	         $response_reason_text = ($success) ? 'success' : $response_result['L_LONGMESSAGE0'];

	         $result = array($success,$response_code,$response_reason_text,$response_reason_text);
         } else
			{
         	$result = array(false,NULL,NULL,NULL);
         }
		}
		else
		{
         $this->set_api_parameters($purchase_id,$card_type,$card_number,$cv2,$expiry_month,$expiry_year,$description,$amount,$first_name,$last_name,$address,$city,$state,$zip,$country,$shipping_first_name,$shipping_last_name,$shipping_address,$shipping_city,$shipping_state,$shipping_zip,$shipping_country,$member_id);

         $response = http_download_file($this->api_endpoint,NULL,true,false,'ocPortal',$this->api_parameters,NULL,NULL,NULL,NULL,NULL,NULL,NULL,20.0);

        	if (!is_null($response))
			{
				$response_result = $this->deformat_nvp($response);

		      $success = (strtoupper(trim($response_result['ACK'])) == 'SUCCESS' || strtoupper(trim($response_result['ACK'])) == 'SUCCESSWITHWARNING') ? true: false;
	         $response_code = ($success) ? $response_result['TRANSACTIONID'] : $response_result['L_ERRORCODE0'];
	         $response_subcode = '';
	         $response_reason_code = '';
	         $response_reason_text = ($success) ? 'success' : $response_result['L_LONGMESSAGE0'];

	         $result = array($success,$response_code,$response_reason_text,$response_reason_text);
         }
			else
			{
         	$result = array(false,NULL,NULL,NULL);
         }
      }

		if(addon_installed('shopping'))
		{
			$this->store_shipping_address($purchase_id);
		}

		return $result;
	}

	/**
    * Get subscription error
    *
    * @param  SHORT_TEXT   The error code
    * @param  SHORT_TEXT   The error
    * @return SHORT_TEXT   Error message
    */
   function get_subscription_error($code,$error)
   {
      require_lang('ecommerce');

      if (strpos($error,"enter a valid credit card number and type") !== false)
      {
         $error_msg = do_lang_tempcode('PAYPAL_CARD_NUMBER_INVALID');
      }
      elseif (strpos($error,"valid credit card expiration date") !== false)
      {
         $error_msg = do_lang_tempcode('PAYPAL_CARD_EXPIRED');
      }
      elseif (strpos($error,"enter a complete billing address") !== false)
      {
         $error_msg = do_lang_tempcode('PAYPAL_COMPLETE_BILLING_ADDRESS');
      }
      elseif (strpos($error,"enter a valid state in the billing address") !== false)
      {
         $error_msg = do_lang_tempcode('PAYPAL_VALID_STATE_BILLING');
      }
      elseif (strpos($error,"enter a valid country code in the billing address") !== false)
      {
         $error_msg = do_lang_tempcode('PAYPAL_VALID_COUNTRY_BILLING');
      }
      elseif (strpos($error,"Subscription start date is required") !== false)
      {
         $error_msg = do_lang_tempcode('PAYPAL_SUBSCRIPTION_START_DATE');
      }
      elseif (strpos($error,"enter a valid postal code in the billing address") !== false)
      {
         $error_msg = do_lang_tempcode('PAYPAL_VALID_ZIP');
      }
      elseif (strpos($error,"Invalid profile status for cancel action") !== false)
      {
      	$error_msg = do_lang_tempcode('PAYPAL_INVALID_PROFILE_FOR_CANCELLATION');
   	}
      else
      {
			if ($error=='') $error=do_lang('CARD_GENERAL_ERROR');

         $error_msg = $error;
      }

      return $error_msg;
   }

   /**
    * Get transaction error
    *
    * @param  SHORT_TEXT   The error code
    * @param  SHORT_TEXT   The error
    * @return SHORT_TEXT   Error message
    */
   function get_transaction_error($code,$error)
   {
      require_lang('ecommerce');

      if (strpos($error,"enter a valid credit card number and type") !== false)
      {
         $error_msg = do_lang_tempcode('PAYPAL_CARD_NUMBER_INVALID');
      }
      elseif (strpos($error,"valid credit card expiration date") !== false)
      {
         $error_msg = do_lang_tempcode('PAYPAL_CARD_EXPIRED');
      }
      elseif (strpos($error,"enter a complete billing address") !== false)
      {
         $error_msg = do_lang_tempcode('PAYPAL_COMPLETE_BILLING_ADDRESS');
      }
      elseif (strpos($error,"enter a valid state in the billing address") !== false)
      {
         $error_msg = do_lang_tempcode('PAYPAL_VALID_STATE_BILLING');
      }
      elseif (strpos($error,"enter a valid country code in the billing address") !== false)
      {
         $error_msg = do_lang_tempcode('PAYPAL_VALID_COUNTRY_BILLING');
      }
      elseif (strpos($error,"enter a valid postal code in the billing address") !== false)
      {
         $error_msg = do_lang_tempcode('PAYPAL_VALID_ZIP');
      }
      else
      {
			if ($error=='') $error=do_lang('CARD_GENERAL_ERROR');

         $error_msg = $error;
      }

      return $error_msg;
   }

	/**
	 * This function defines the parameters needed to make a recurring API call.
	 *
	 * @param  NUMBER       Purchase-id
	 * @param  NUMBER		   Billing Frequency
	 * @param  SHORT_TEXT	Billing Cycle
	 * @param  SHORT_TEXT	Card number
	 * @param  SHORT_TEXT	Card CV2 number (security number)
	 * @param  SHORT_TEXT	Card Expiry Month
	 * @param  SHORT_TEXT	Card Expiry Yeary
	 * @param  SHORT_TEXT	Description
	 * @param  SHORT_TEXT	Transaction amount
	 * @param  SHORT_TEXT	Address for card
	 * @param  SHORT_TEXT	City for card
	 * @param  SHORT_TEXT	State for card
	 * @param  SHORT_TEXT	Zip/post-code for card
	 * @param  SHORT_TEXT	Country for card
	 * @param  SHORT_TEXT	Shipping Address for card
	 * @param  SHORT_TEXT	Shipping City for card
	 * @param  SHORT_TEXT	Shipping State for card
	 * @param  SHORT_TEXT	Shipping Zip/post-code for card
	 * @param  SHORT_TEXT	Shipping Country for card
	 * @param  ?MEMBER		Member making the transaction (NULL: current member)
	 */
	function set_recurring_api_parameters($purchase_id,$billing_frequency,$billing_period,$card_type,$card_number,$cv2,$expiry_month,$expiry_year,$start_date,$description,$amount,$first_name=NULL,$last_name=NULL,$address=NULL,$city=NULL,$state=NULL,$zip=NULL,$country=NULL,$shipping_first_name=NULL,$shipping_last_name=NULL,$shipping_address=NULL,$shipping_city=NULL,$shipping_state=NULL,$shipping_zip=NULL,$shipping_country=NULL,$member_id=NULL)
	{
		$this->api_parameters = array();

		$access_detail = $this->get_access_detail($member_id);

		$this->api_endpoint = (get_option('ecommerce_test_mode')=='1') ? 'https://api-3t.sandbox.paypal.com/nvp' : 'https://api-3t.paypal.com/nvp';

		$this->api_parameters['METHOD']             = 'CreateRecurringPaymentsProfile';
		$this->api_parameters['USER']               = $access_detail[0];
		$this->api_parameters['PWD']                = $access_detail[1];
		$this->api_parameters['SIGNATURE']          = $access_detail[2];
		$this->api_parameters['VERSION']            = '61.0';
		$this->api_parameters['AMT']                = $amount;
		$this->api_parameters['CREDITCARDTYPE']     = $card_type;
		$this->api_parameters['ACCT']               = $card_number;
		$this->api_parameters['EXPDATE']            = $expiry_month.$expiry_year;
		$this->api_parameters['CVV2']               = $cv2;
		$this->api_parameters['FIRSTNAME']          = $first_name;
		$this->api_parameters['LASTNAME']           = $last_name;
		$this->api_parameters['STREET']             = $address;
		$this->api_parameters['CITY']               = $city.','.$state;
		$this->api_parameters['ZIP']                = $zip;
		$this->api_parameters['COUNTRYCODE']        = $country;
		$this->api_parameters['CURRENCYCODE']       = get_option('currency');
		$this->api_parameters['DESC']               = $purchase_id;
		$this->api_parameters['PROFILESTARTDATE']   = $start_date.'T00:00:00Z';
		$this->api_parameters['BILLINGPERIOD']      = $billing_period;
		$this->api_parameters['BILLINGFREQUENCY']   = $billing_frequency;
		$this->api_parameters['TOTALBILLINGCYCLES'] = 0;

		if ($shipping_first_name && $shipping_address && $shipping_city && $shipping_state && $shipping_zip)
		{
			$this->api_parameters['SHIPTONAME']        = $shipping_first_name.' '.$shipping_last_name;
			$this->api_parameters['SHIPTOSTREET']      = $shipping_address;
			$this->api_parameters['SHIPTOCITY']        = $shipping_city.','.$shipping_state;
			$this->api_parameters['SHIPTOZIP']         = $shipping_zip;
			$this->api_parameters['SHIPTOCOUNTRYCODE'] = $shipping_country;
		}
	}

	/**
	 * This function defines the parameters needed to make an API call.
	 *
	 * @param  NUMBER       Purchase-id
	 * @param  ?ID_TEXT		The transaction ID (NULL: generate one)
	 * @param  SHORT_TEXT	Card Type
	 * @param  SHORT_TEXT	Card number
	 * @param  SHORT_TEXT	Card CV2 number (security number)
	 * @param  SHORT_TEXT	Card Expiry Month
	 * @param  SHORT_TEXT	Card Expiry Yeary
	 * @param  SHORT_TEXT	Description
	 * @param  SHORT_TEXT	Transaction amount
	 * @param  SHORT_TEXT	Address for card
	 * @param  SHORT_TEXT	City for card
	 * @param  SHORT_TEXT	State for card
	 * @param  SHORT_TEXT	Zip/post-code for card
	 * @param  SHORT_TEXT	Country for card
	 * @param  SHORT_TEXT	Shipping Address for card
	 * @param  SHORT_TEXT	Shipping City for card
	 * @param  SHORT_TEXT	Shipping State for card
	 * @param  SHORT_TEXT	Shipping Zip/post-code for card
	 * @param  SHORT_TEXT	Shipping Country for card
	 * @param  ?MEMBER		Member making the transaction (NULL: current member)
	 */
	function set_api_parameters($purchase_id,$card_type,$card_number,$cv2,$expiry_month,$expiry_year,$description,$amount,$first_name=NULL,$last_name=NULL,$address=NULL,$city=NULL,$state=NULL,$zip=NULL,$country=NULL,$shipping_first_name=NULL,$shipping_last_name=NULL,$shipping_address=NULL,$shipping_city=NULL,$shipping_state=NULL,$shipping_zip=NULL,$shipping_country=NULL,$member_id=NULL)
	{
		$this->api_parameters = array();

		$access_detail = $this->get_access_detail($member_id);

		$item_name  = find_item_name_of_order($purchase_id);
		$notify_url = find_script('ecommerce').'?from=paypal&product='.$item_name;

		$this->api_endpoint = (get_option('ecommerce_test_mode')=='1') ? 'https://api-3t.sandbox.paypal.com/nvp' : 'https://api-3t.paypal.com/nvp';

		$this->api_parameters['METHOD']         = 'doDirectPayment';
		$this->api_parameters['USER']           = $access_detail[0];
		$this->api_parameters['PWD']            = $access_detail[1];
		$this->api_parameters['SIGNATURE']      = $access_detail[2];
		$this->api_parameters['VERSION']        = '61.0';
		$this->api_parameters['PAYMENTACTION']  = 'Sale';
		$this->api_parameters['AMT']            = $amount;
		$this->api_parameters['CREDITCARDTYPE'] = $card_type;
		$this->api_parameters['ACCT']           = $card_number;
		$this->api_parameters['EXPDATE']        = $expiry_month.$expiry_year;
		$this->api_parameters['CVV2']           = $cv2;
		$this->api_parameters['FIRSTNAME']      = $first_name;
		$this->api_parameters['LASTNAME']       = $last_name;
		$this->api_parameters['STREET']         = $address;
		$this->api_parameters['CITY']           = $city.','.$state;
		$this->api_parameters['ZIP']            = $zip;
		$this->api_parameters['COUNTRYCODE']    = $country;
		$this->api_parameters['CURRENCYCODE']   = get_option('currency');
		$this->api_parameters['CUSTOM']         = $purchase_id;
		$this->api_parameters['NOTIFYURL']      = $notify_url;

		if ($shipping_first_name && $shipping_address && $shipping_city && $shipping_state && $shipping_zip)
		{
			$this->api_parameters['SHIPTONAME']        = $shipping_first_name.' '.$shipping_last_name;
			$this->api_parameters['SHIPTOSTREET']      = $shipping_address;
			$this->api_parameters['SHIPTOCITY']        = $shipping_city.','.$shipping_state;
			$this->api_parameters['SHIPTOZIP']         = $shipping_zip;
			$this->api_parameters['SHIPTOCOUNTRYCODE'] = $shipping_country;
		}
	}

	/**
	 * Get paypal access detail
	 *
	 * @param ID Member Id
	 * @return array
	 */
	function get_access_detail($member_id=NULL)
	{
		$api_username	=	NULL;
		$api_password	=	NULL;
		$api_signature	=	NULL;

		if(!is_null($member_id) && get_option('enable_member_payments'))
		{
			$api_username  = get_ocp_cpf('paypal_api_username',$member_id);
			$api_password  = get_ocp_cpf('paypal_api_password',$member_id);
			$api_signature = get_ocp_cpf('paypal_api_signature',$member_id);
		}

		if (is_null($api_username) || $api_username=='' || is_null($api_password) || $api_password=='' || is_null($api_signature) || $api_signature== '')
		{
			$api_username	=	(get_option('ecommerce_test_mode')=='1')?get_option('paypal_test_api_username'): get_option('paypal_api_username');
			$api_password	=	(get_option('ecommerce_test_mode')=='1')?get_option('paypal_test_api_password'): get_option('paypal_api_password');
			$api_signature	=	(get_option('ecommerce_test_mode')=='1')?get_option('paypal_test_api_signature'): get_option('paypal_api_signature');
		}

		return array($api_username,$api_password,$api_signature);
	}

   /** This function will take NVPString and convert it to an Associative Array and it will decode the response.
	 * It is usefull to search for a particular key and displaying arrays.
	 *
	 * @param  ID_TEXT NVPString.
	 * @return ARRAY
	 */
	function deformat_nvp($nvp_str)
	{
		$intial = 0;
		$nvp_array = array();

		while(strlen($nvp_str)>0)
		{
			//postion of Key
			$key_pos = strpos($nvp_str,'=');
			//position of value
			$value_pos = strpos($nvp_str,'&') ? strpos($nvp_str,'&'): strlen($nvp_str);

			/*getting the Key and Value values and storing in a Associative Array*/
			$key_val = substr($nvp_str,$intial,$key_pos);
			$val_val = substr($nvp_str,$key_pos+1,$value_pos-$key_pos-1);
			//decoding the respose
			$nvp_array[urldecode($key_val)] = urldecode($val_val);
			$nvp_str = substr($nvp_str,$value_pos+1,strlen($nvp_str));
		}

		return $nvp_array;
	}

	/** Function to return local payment method for subscriptions
	 *
	 * @return ID_TEXT	automatic|local_controlled
	 */
	function get_subscription_local_payment_method()
	{
		return get_option('paypal_local_subscription_methods');
	}

	/**
	 * This function defines the parameters needed to make a cancelation API call.
	 *
	 * @param  NUMBER   Subscription Id
	 * @param  ?MEMBER  Member making the transaction (NULL: current member)
	 */
	function set_cancelation_api_parameters($subscription_id,$member_id=NULL)
	{
		$this->api_parameters = array();

		$access_detail = $this->get_access_detail($member_id);

		$this->api_endpoint = (get_option('ecommerce_test_mode')=='1') ? 'https://api-3t.sandbox.paypal.com/nvp' : 'https://api-3t.paypal.com/nvp';

		$this->api_parameters['METHOD']             = 'ManageRecurringPaymentsProfileStatus';
		$this->api_parameters['USER']               = $access_detail[0];
		$this->api_parameters['PWD']                = $access_detail[1];
		$this->api_parameters['SIGNATURE']          = $access_detail[2];
		$this->api_parameters['VERSION']            = '61.0';
		$this->api_parameters['PROFILEID']          = $subscription_id;
		$this->api_parameters['ACTION']             = 'Cancel';
	}

	/**
	 * Find whether the hook auto-cancels (if it does, auto cancel the given trans-id).
	 *
	 * @param  NUMBER    Subscription Id
	 * @return ?boolean	True: yes. False: no. (NULL: cancels via a user-URL-directioning)
	 */
	function auto_cancel($subscription_id)
	{
		return	$this->cancel_website_pro_subscription($subscription_id);
	}

	/**
	 * Find whether the hook auto-cancels (if it does, auto cancel the given trans-id).
	 *
	 * @param  NUMBER    Subscription Id
	 * @param  ?MEMBER	Member making the transaction (NULL: Admin)
	 * @return ?boolean	True: yes. False: no. (NULL: cancels via a user-URL-directioning)
	 */
	function cancel_website_pro_subscription($subscription_id,$member_id=NULL)
	{
		$success = false;
		$temp		=	$GLOBALS['SITE_DB']->query_value('subscriptions','s_auto_fund_key',array('id'=>$subscription_id));
		$data		=	unserialize($temp);
		$profile_id	=	$data['id'];

		$this->set_cancelation_api_parameters($profile_id,$member_id);

		$response = http_download_file($this->api_endpoint,NULL,true,false,'ocPortal',$this->api_parameters,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12.0);

		if (!is_null($response))
		{
			$response_result = $this->deformat_nvp($response);

			$success = (strtoupper(trim($response_result['ACK'])) == 'SUCCESS' || strtoupper(trim($response_result['ACK'])) == 'SUCCESSWITHWARNING') ? true: false;
			$response_code = ($success) ? 'success' : $response_result['L_ERRORCODE0'];
			$response_subcode = '';
			$response_reason_code = '';
			$response_reason_text = ($success) ? 'success' : $response_result['L_LONGMESSAGE0'];

			$result = array($success,$response_code,$response_reason_text,$response_reason_text);
		} else
		{
			$success = false;
			$result  = array(false,NULL,NULL,NULL);
		}
      return $success;
	}

	/**
	 * Function to return profile ids and types in serialized array format
	 *
	 *	@param	AUTO_LINK	Transaction id
	 * @param	AUTO_LINK 	Parent transaction id (Subscription profile id of a particular subscription: Need only in the case of paypal website pro)
	 * @return	?SHORT_TEXT	Type, profile id data in serialized string
	 */
	function	map_payment_ids($txn_id,$parent_txn_id)
	{
		$trans_type	=	post_param('txn_type','');
		$type 		= 	($parent_txn_id!=-1) ?'website_payment_pro' :'website_payment_standard';
		$id			=	($parent_txn_id!=-1)?$parent_txn_id:$txn_id;
		$data 		= array('id'=>$id,'type'=>$type);

		return serialize($data);
	}

	/**
	 * Get form fields.
	 *
	 * @param ID Subscription Id
	 * @return tempcode The form fields
	 */
	function get_update_form_fields($subscription_id)
	{
		require_code('ecommerce');

		list($card_det,$hidden)	= get_general_update_form_fields($subscription_id,$this);

		/*	General transaction fields returned from ecommerce api, attaching the details to the form.
			The fields can add/remove here, depending on the customised payment gateway features.
		*/
		$fields	=	new ocp_tempcode();
		foreach($card_det as $field)
		{
			$fields->attach($field);
		}

		$verified_account_logo	=	$this->get_confidence_logos();
		return array($fields,$hidden,$verified_account_logo);
	}

	/**
	 * Make a subscription update button.
	 *
	 * @param  ID_TEXT		The purchase ID.
	 *	@param	ID_TEXT		Serialized data which stores transaction keys
	 * @return tempcode		The button
	 */
	function make_update_button($purchase_id,$auto_found_key=NULL)
	{
		$recur_det	=	(!is_null($auto_found_key))?unserialize($auto_found_key):NULL;
		$remote_cancellation	=	false;

		if(is_array($recur_det) && $recur_det['type']=='website_payment_pro')
		{
			$url	=	build_url(array('page'=>'subscriptions','type'=>'update','id'=>$purchase_id),get_module_zone('subscriptions'));
			$url	=	$url->evaluate();
		}
		elseif(is_array($recur_det) && $recur_det['type']=='website_payment_standard')
		{
			$trans_id =	$recur_det['id'];
			$url = (get_option('ecommerce_test_mode')=='1') ? "https://www.sandbox.paypal.com/cgi-bin/webscr" : "https://history.paypal.com/cgi-bin/webscr?cmd=_subscr-details&amp;search_trans_id=$trans_id";
		}
		else
			$url	=	'';

		return do_template('ECOM_UPDATE_BUTTON_VIA_PAYPAL',array('URL'=>$url));
	}

	/**
	 * Update subscription
	 *
	 * @param  ID           Subscription Id
	 * @param  SHORT_TEXT	Cardholder first name
	 * @param  SHORT_TEXT	Cardholder last name
	 * @param  SHORT_TEXT	Card number
	 * @param  SHORT_TEXT	Card Type
	 * @param  SHORT_TEXT	Card Expiry date
	 * @param  SHORT_TEXT	Card CV2 number (security number)
	 * @param  SHORT_TEXT	Address for card
	 * @param  SHORT_TEXT	City for card
	 * @param  SHORT_TEXT	State for card
	 * @param  SHORT_TEXT	Zip/post-code for card
	 * @param  SHORT_TEXT	Country for card
	 * @param  ID Member Id (NULL: Admin)
	 * @return ARRAY
	 */
   function update_subscription($subscription_id,$first_name,$last_name,$card_number,$card_type,$expiry_date,$cv2,$address1,$city,$state,$zip,$country,$member_id=NULL)
	{
		$card_number = str_replace('-','',str_replace(' ','',$card_number));

		return $this->update_website_pro_subscription($subscription_id,$first_name,$last_name,$card_number,$card_type,$expiry_date,$cv2,$address1,$city,$state,$zip,$country,$member_id);
	}

	/**
	 * Update subscription for website payment pro.
	 *
	 * @param  ID           Subscription Id
	 * @param  SHORT_TEXT	Cardholder first name
	 * @param  SHORT_TEXT	Cardholder last name
	 * @param  SHORT_TEXT	Card number
	 * @param  SHORT_TEXT	Card Type
	 * @param  SHORT_TEXT	Card Expiry date
	 * @param  SHORT_TEXT	Card CV2 number (security number)
	 * @param  SHORT_TEXT	Address for card
	 * @param  SHORT_TEXT	City for card
	 * @param  SHORT_TEXT	State for card
	 * @param  SHORT_TEXT	Zip/post-code for card
	 * @param  SHORT_TEXT	Country for card
	 * @param  ID Member Id (NULL: Admin)
	 */
	function update_website_pro_subscription($subscription_id,$first_name,$last_name,$card_number,$card_type,$expiry_date,$cv2,$address1,$city,$state,$zip,$country,$member_id=NULL)
	{
		$success    = false;
		$temp		   =	$GLOBALS['SITE_DB']->query_value('subscriptions','s_auto_fund_key',array('id'=>$subscription_id));
		$data		   =	unserialize($temp);
		$profile_id	= $data['id'];

		$expiry_month = substr($expiry_date,5,2);
		$expiry_year  = substr($expiry_date,0,4);

		$this->set_update_api_parameters($profile_id,$first_name,$last_name,$card_number,$card_type,$expiry_month,$expiry_year,$cv2,$address1,$city,$state,$zip,$country,$member_id);

		$response = http_download_file($this->api_endpoint,NULL,true,false,'ocPortal',$this->api_parameters,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12.0);

		if (!is_null($response))
		{
			$response_result = $this->deformat_nvp($response);

			$success = (strtoupper(trim($response_result['ACK'])) == 'SUCCESS' || strtoupper(trim($response_result['ACK'])) == 'SUCCESSWITHWARNING') ? true: false;
			$response_code = ($success) ? 'success' : $response_result['L_ERRORCODE0'];
			$response_subcode = '';
			$response_reason_code = '';
			$response_reason_text = ($success) ? 'success' : $response_result['L_LONGMESSAGE0'];

			$result = array($success,$response_code,$response_reason_text,$response_reason_text);
		}
		else
		{
			$success = false;
			$result  = array(false,NULL,NULL,NULL);
		}

      return $result;
	}

	/**
	 * This function defines the parameters needed to make an API call.
	 *
	 * @param  ID           Profile Id
	 * @param  SHORT_TEXT	Cardholder first name
	 * @param  SHORT_TEXT	Cardholder last name
	 * @param  SHORT_TEXT	Card number
	 * @param  SHORT_TEXT	Card Type
	 * @param  SHORT_TEXT	Card Expiry date
	 * @param  SHORT_TEXT	Card CV2 number (security number)
	 * @param  SHORT_TEXT	Address for card
	 * @param  SHORT_TEXT	City for card
	 * @param  SHORT_TEXT	State for card
	 * @param  SHORT_TEXT	Zip/post-code for card
	 * @param  SHORT_TEXT	Country for card
	 * @param  ID Member Id (NULL: Admin)
	 */
	function set_update_api_parameters($profile_id,$first_name,$last_name,$card_number,$card_type,$expiry_month,$expiry_year,$cv2,$address1,$city,$state,$zip,$country,$member_id=NULL)
	{
		$this->api_parameters = array();

		$access_detail = $this->get_access_detail($member_id);

		$this->api_endpoint = (get_option('ecommerce_test_mode')=='1') ? 'https://api-3t.sandbox.paypal.com/nvp' : 'https://api-3t.paypal.com/nvp';

		$this->api_parameters['USER']               = $access_detail[0];
		$this->api_parameters['PWD']                = $access_detail[1];
		$this->api_parameters['SIGNATURE']          = $access_detail[2];
		$this->api_parameters['METHOD']             = 'UpdateRecurringPaymentsProfile';
		$this->api_parameters['VERSION']            = '61.0';
		$this->api_parameters['PROFILEID']          = $profile_id;
		//$this->api_parameters['AMT']              = '9.99';
		//$this->api_parameters['PROFILESTARTDATE'] = '2010-07-05T05:57:18+02:00';
		//$this->api_parameters['BILLINGPERIOD']    = 'Day';
		//$this->api_parameters['BILLINGFREQUENCY'] = '1';
		//$this->api_parameters['CURRENCYCODE']     = get_option('currency');
		$this->api_parameters['CREDITCARDTYPE']     = $card_type;
		$this->api_parameters['ACCT']               = $card_number;
		$this->api_parameters['EXPDATE']            = $expiry_month.$expiry_year;
		$this->api_parameters['CVV2']               = $cv2;
		$this->api_parameters['FIRSTNAME']          = $first_name;
		$this->api_parameters['LASTNAME']           = $last_name;
		$this->api_parameters['STREET']             = $address1;
		$this->api_parameters['CITY']               = $city;
		$this->api_parameters['STATE']              = $state;
		$this->api_parameters['COUNTRYCODE']        = $country;
		$this->api_parameters['ZIP']                = $zip;
	}

}