<?php

/**
  * admin_ocrewards.php
  *
 */

require_code('aed_module');

/**
 * Module page class.
 */
class Module_admin_ocrewards extends standard_aed_module
{

    var $lang_type='REWARD';
	var $possibly_some_kind_of_upload=true;
	var $output_of_action_is_confirmation=true;
	var $menu_label='OCREWARDS_TITLE';
	var $do_preview=NULL;
	var $javascript='standardAlternateFields(\'image\',\'url\');';
	var $select_name='NAME';

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']='Paul Arbogast';
		$info['organisation']='air-rc.com';
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=9.1;
		$info['update_require_upgrade']=1;
		$info['locked']=false;
		return $info;
	}

	/**
	 * Standard modular install function.
	 *
	 * @param  ?integer	What version we're upgrading from (NULL: new install)
	 */
	function install($upgrade_from=NULL)
	{
		if (is_null($upgrade_from))
		{
			$GLOBALS['SITE_DB']->create_table('ocrewards',array(
				'id'=>'*AUTO',
				'name'=>'SHORT_TEXT',
				'descrip'=>'SHORT_TEXT',
				'image'=>'SHORT_TEXT',
				'rmethod'=>'SHORT_INTEGER',
				'rparam'=>'SHORT_TEXT',
				'rtype'=>'INTEGER',
				'enabled'=>'BINARY',
			));

			$default_rewards=array();
			$default_rewards[]=array('name'=>'1000 Posts','descrip'=>'User has made 1000 Posts.','image'=>'uploads/ocrewards_addon/1kposts.png','rmethod'=>1,'rparam'=>'1000','rtype'=>1,'enabled'=>1);
			$default_rewards[]=array('name'=>'5000 Posts','descrip'=>'User has made 5000 Posts.','image'=>'uploads/ocrewards_addon/5kposts.png','rmethod'=>1,'rparam'=>'5000','rtype'=>1,'enabled'=>1);
			$default_rewards[]=array('name'=>'1 Year','descrip'=>'User has been a member for 1 Year.','image'=>'uploads/ocrewards_addon/1year.png','rmethod'=>2,'rparam'=>'1','rtype'=>1,'enabled'=>1);
			$default_rewards[]=array('name'=>'2 Year','descrip'=>'User has been a member for 2 Years.','image'=>'uploads/ocrewards_addon/2year.png','rmethod'=>2,'rparam'=>'2','rtype'=>1,'enabled'=>1);

			foreach ($default_rewards as $dg)
			{
				$GLOBALS['SITE_DB']->query_insert('ocrewards',$dg);
			}

			$GLOBALS['SITE_DB']->create_table('ocrewards_members',array(
				'id'=>'*AUTO',
				'user_id'=>'USER',
				'reward_id'=>'AUTO_LINK',

			));

			$GLOBALS['SITE_DB']->create_table('ocrewards_type',array(
			    'id'=>'*AUTO',
			    'name'=>'SHORT_TEXT',
			    'descrip'=>'SHORT_TEXT',
			    'image'=>'SHORT_TEXT',
			));

			$default_types=array();
			$default_types[]=array('name'=>'Badges','descrip'=>'User Badges','image'=>'uploads/ocrewards_addon/badges.png');
			$default_types[]=array('name'=>'Ribbons','descrip'=>'User Ribbons','image'=>'uploads/ocrewards_addon/ribbons.png');
			$default_types[]=array('name'=>'Medals','descrip'=>'User Medals','image'=>'uploads/ocrewards_addon/medals.png');
			$default_types[]=array('name'=>'Trophies','descrip'=>'User Trophies','image'=>'uploads/ocrewards_addon/trophies.png');
			foreach ($default_types as $dg)
			{
				$GLOBALS['SITE_DB']->query_insert('ocrewards_type',$dg);
			}

			$GLOBALS['SITE_DB']->create_table('ocrewards_methods',array(
			    'id'=>'*AUTO',
			    'name'=>'SHORT_TEXT',
			    'meth'=>'SHORT_TEXT',
			    'descrip'=>'SHORT_TEXT',
			));

			$default_types=array();
			$default_types[]=array('name'=>'Manually give this award','meth'=>'','descrip'=>'This reward will be given manually, not via a method.');
			$default_types[]=array('name'=>'User posts are greater than','meth'=>'user_posts_gt','descrip'=>'Put # of posts as param, user earns reward if their # of posts is >= param');
			$default_types[]=array('name'=>'User has been a member for longer than','meth'=>'user_year_gt','descrip'=>'Put # of years as param, user earns reward if the # of years they have been a member is >= param');
			$default_types[]=array('name'=>'Users points earned is greater than','meth'=>'points_earned_gt','descrip'=>'Put # of points earned as param, user earns reward if their points earned >= param');
			$default_types[]=array('name'=>'Likes User has receive is greater than','meth'=>'likes_type_gt','descrip'=>'Put #:type as param where # is the number of likes, and type is the type of content.  Type can be: posts, images, polls, catalogues, news, all');
			foreach ($default_types as $dg)
			{
				$GLOBALS['SITE_DB']->query_insert('ocrewards_methods',$dg);
			}

		}

	    if ((!is_null($upgrade_from)) && ($upgrade_from<3))
		{

		   $GLOBALS['SITE_DB']->create_table('ocrewards_methods',array(
			    'id'=>'*AUTO',
			    'name'=>'SHORT_TEXT',
			    'meth'=>'SHORT_TEXT',
			    'descrip'=>'SHORT_TEXT',
			));

			$default_types=array();
			$default_types[]=array('name'=>'Manually give this award','meth'=>'','descrip'=>'This reward will be given manually, not via a method.');
			$default_types[]=array('name'=>'User posts are greater than','meth'=>'user_posts_gt','descrip'=>'Put # of posts as param, user earns reward if their # of posts is >= param');
			$default_types[]=array('name'=>'User has been a member for longer than','meth'=>'user_year_gt','descrip'=>'Put # of years as param, user earns reward if the # of years they have been a member is >= param');
			$default_types[]=array('name'=>'Users points earned is greater than','meth'=>'points_earned_gt','descrip'=>'Put # of points earned as param, user earns reward if their points earned >= param');
			$default_types[]=array('name'=>'Likes User has receive is greater than','meth'=>'likes_type_gt','descrip'=>'Put #:type as param where # is the number of likes, and type is the type of content.  Type can be: posts, images, polls, catalogues, news, all');
			foreach ($default_types as $dg)
			{
				$GLOBALS['SITE_DB']->query_insert('ocrewards_methods',$dg);
			}


            $rows = $GLOBALS['FORUM_DB']->query_select('ocrewards',array('*'),NULL,'');  // read it
            $GLOBALS['SITE_DB']->alter_table_field('ocrewards','rmethod','SHORT_INTEGER');  // alter it

            foreach ($rows as $reward)
            {
              $newid = 0;

              switch ($reward['rmethod']) {
                case 'user_posts_gt': $newid = 1; break;
                case 'user_year_gt': $newid = 2; break;
                case 'points_earned_gt': $newid = 3; break;
                case 'likes_type_gt': $newid = 4; break;
                default:  break;
              }

              $GLOBALS['SITE_DB']->query_update('ocrewards',array('name'=>$reward['name'],'descrip'=>$reward['descrip'],'image'=>$reward['image'],'rtype'=>$reward['rtype'],'enabled'=>$reward['enabled'],'rmethod'=>$newid,'rparam'=>$rewards['rparam']),array('id'=>$reward['id']),'',1);
            }



		}
    }


	/**
	 * Standard modular uninstall function.
	 */
	function uninstall()
	{
		$GLOBALS['SITE_DB']->drop_if_exists('ocrewards');
		$GLOBALS['SITE_DB']->drop_if_exists('ocrewards_members');
		$GLOBALS['SITE_DB']->drop_if_exists('ocrewards_type');

	}


	/**
	 * Standard modular entry-point finder function.
	 *
	 * @return ?array	A map of entry points (type-code=>language-code) (NULL: disabled).
	 */
	function get_entry_points()
	{
		return array('misc'=>'MANAGE_REWARDS');
	}

	/**
	 * Standard aed_module run_start.
	 *
	 * @param  ID_TEXT		The type of module execution
	 * @return tempcode		The output of the run
	 */
	function run_start($type)
	{

        if (get_forum_type()!='ocf') warn_exit(do_lang_tempcode('NO_OCF')); else ocf_require_all_forum_stuff();

        $this->cat_aed_module=new Module_admin_ocrewards_cat();

		require_code('ocf_groups_action');
		require_code('ocf_forums_action');
		require_code('ocf_groups_action2');
		require_code('ocf_forums_action2');

		if ($type=='misc') return $this->misc();

		return new ocp_tempcode();
	}

	/**
	 * The do-next manager for before content management.
	 *
	 * @return tempcode		The UI
	 */
	function misc()
	{
		require_code('templates_donext');
		require_lang('ocrewards');

		return do_next_manager(get_screen_title('OCREWARDS_TITLE'),comcode_lang_string('DOC_OCREWARDS'),
					array(
						/*	 type							  page	 params													 zone*/
						array('add_one_category',array('_SELF',array('type'=>'ac'),'_SELF'),do_lang('ADD_REWARD_TYPE')),
						array('edit_one_category',array('_SELF',array('type'=>'ec'),'_SELF'),do_lang('EDIT_REWARD_TYPE')),

						array('add_one',array('_SELF',array('type'=>'ad'),'_SELF'),do_lang('ADD_REWARD')),
						array('edit_one',array('_SELF',array('type'=>'ed'),'_SELF'),do_lang('EDIT_REWARD')),

					),
					do_lang('OCREWARDS_TITLE')
		);
	}


	function get_form_fields($id=NULL,$name='',$descrip='',$rmethod=0,$rparam='',$image='',$rtype=1,$enabled=1)
	{
		$fields=new ocp_tempcode();
		$hidden=new ocp_tempcode();

		require_code('form_templates');

		$fields->attach(form_input_line(do_lang_tempcode('NAME'),do_lang_tempcode('NAME_REWARD'),'name',$name,true));

		$fields->attach(form_input_line(do_lang_tempcode('DESCRIP'),do_lang_tempcode('DESCRIPTION_REWARD'),'descrip',$descrip,true));

        $_meth = new ocp_tempcode();
        $rows = $GLOBALS['FORUM_DB']->query_select('ocrewards_methods',array('*'),NULL,'ORDER BY name ASC');

        foreach ($rows as $group)
        {
          $selected = 0;
          $selected=($group['id']==$rmethod);

          $_meth->attach(form_input_list_entry(strval($group['id']),$selected,$group['name']));
        }

		$fields->attach(form_input_list(do_lang_tempcode('RMETHOD'),do_lang_tempcode('RMETHOD_REWARD'),'rmethod',$_meth,false));

		$fields->attach(form_input_line(do_lang_tempcode('RPARAM'),do_lang_tempcode('RPARAM_REWARD'),'rparam',$rparam,false));

        $required=true;
        if ($image!='') {
          $required=false;
        }
		$fields->attach(form_input_upload(do_lang_tempcode('IMAGE'),($required==true?do_lang_tempcode('IMAGE_REWARD1'):do_lang_tempcode('IMAGE_REWARD2',get_custom_base_url().'/'.$image)),'image',$required,NULL,NULL,true,str_replace(' ','',get_option('valid_images'))));

        $_rtype = new ocp_tempcode();
		$rows=$GLOBALS['FORUM_DB']->query_select('ocrewards_type',array('id','name'),NULL,'ORDER BY name ASC');

		foreach ($rows as $group)
		{
	            $selected = 0;
	            $selected=($group['id']==$rtype);

				$_rtype->attach(form_input_list_entry(strval($group['id']),$selected,$group['name']));

		}

		$fields->attach(form_input_list(do_lang_tempcode('RTYPE'),do_lang_tempcode('RTYPE_REWARD'),'rtype',$_rtype,NULL,false,true));

		$fields->attach(form_input_tick(do_lang_tempcode('ENABLED'),do_lang_tempcode('ENABLED_REWARD'),'enabled',$enabled==1));

		return array($fields,$hidden);
	}

	/**
	 * Standard aed_module list function.
	 *
	 * @return tempcode		The selection list
	 */
	function nice_get_entries()
	{
		$fields=new ocp_tempcode();

		$this->select_name="BUGBUGBUG";

		$rows=$GLOBALS['SITE_DB']->query_select('ocrewards',array('*'),NULL);

		foreach ($rows as $row)
		{
            $fields->attach(form_input_list_entry(strval($row['id']),false,$row['name']));
        }

		return $fields;
	}

	/**
	 * Standard aed_module edit form filler.
	 *
	 * @param  ID_TEXT		The entry being edited
	 * @return array			A pair: The input fields, Hidden fields
	 */
	function fill_in_edit_form($id)
	{
		$rows=$GLOBALS['SITE_DB']->query_select('ocrewards',array('*'),array('id'=>intval($id)));
		if (!array_key_exists(0,$rows))
		{
			warn_exit(do_lang_tempcode('MISSING_RESOURCE'));
		}
		$myrow=$rows[0];

        $name=$myrow['name'];
		$descrip=$myrow['descrip'];
		$image=$myrow['image'];
		$rtype=$myrow['rtype'];
		$enabled=$myrow['enabled'];
		$rmethod=$myrow['rmethod'];
		$rparam=$myrow['rparam'];

		$ret=$this->get_form_fields($id,$name,$descrip,$rmethod,$rparam,$image,$rtype,$enabled);

		return $ret;
	}

	/**
	 * Standard aed_module add actualiser.
	 *
	 * @return ID_TEXT		The entry added
	 */
	function add_actualisation()
	{
		$name=post_param('name');
		$descrip=post_param('descrip');
		$rmethod=post_param('rmethod');
		$rparam=post_param('rparam');
		$rtype=post_param('rtype');
		$enabled=post_param('enabled',0);

		require_code('uploads');

		$urls=get_url('url','image','uploads/ocrewards_addon',0,OCP_UPLOAD_IMAGE,false,'','');

		if ($urls[0]=='')
		{
			warn_exit(do_lang_tempcode('IMPROPERLY_FILLED_IN_UPLOAD'));
		}

		if ((substr($urls[0],0,8)!='uploads/') && (is_null(http_download_file($urls[0],0,false))) && (!is_null($GLOBALS['HTTP_MESSAGE_B'])))
			attach_message($GLOBALS['HTTP_MESSAGE_B'],'warn');

		$url=$urls[0];

		$id=$GLOBALS['SITE_DB']->query_insert('ocrewards',array('name'=>$name,'descrip'=>$descrip,'image'=>$url,'rtype'=>intval($rtype),'enabled'=>$enabled,'rmethod'=>$rmethod,'rparam'=>$rparam),true);

		return strval($id);
	}

	/**
	 * Standard aed_module edit actualiser.
	 *
	 * @param  ID_TEXT		The entry being edited
	 * @return ?tempcode		Confirm message (NULL: continue)
	 */
	function edit_actualisation($id)
	{
	    $name=post_param('name');
		$descrip=post_param('descrip');
		$rmethod=post_param('rmethod');
        $rparam=post_param('rparam');
		$rtype=post_param('rtype');
		$enabled=post_param('enabled',0);

		require_code('uploads');

        $urls=get_url('url','image','uploads/ocrewards_addon',0,OCP_UPLOAD_IMAGE,false,'','');

		if ((substr($urls[0],0,8)!='uploads/') && (is_null(http_download_file($urls[0],0,false))) && (!is_null($GLOBALS['HTTP_MESSAGE_B'])))
			attach_message($GLOBALS['HTTP_MESSAGE_B'],'warn');

	    $previous_upload_value=$GLOBALS['SITE_DB']->query_select('ocrewards',array('image'),array('id'=>intval($id)));
        if ($urls[0]!='') {
          $url=$urls[0]; // Get new value
          @unlink(get_custom_file_base().'/'.rawurldecode($previous_upload_value[0]));
        } else {
          $url=$previous_upload_value[0]['image'];
        }

		$GLOBALS['SITE_DB']->query_update('ocrewards',array('name'=>$name,'descrip'=>$descrip,'image'=>$url,'rtype'=>$rtype,'enabled'=>$enabled,'rmethod'=>$rmethod,'rparam'=>$rparam),array('id'=>intval($id)),'',1);

		return NULL;
	}

	/**
	 * Standard aed_module delete actualiser.
	 *
	 * @param  ID_TEXT		The entry being deleted
	 */
	function delete_actualisation($id)
	{
		$GLOBALS['SITE_DB']->query_delete('ocrewards',array('id'=>intval($id)),'',1);
		$GLOBALS['SITE_DB']->query_delete('ocrewards_members',array('reward_id'=>intval($id)));
	}



}



/************************************************************************
 * Module for ocrewards types
 *
 */
class Module_admin_ocrewards_cat extends standard_aed_module
{

    var $lang_type='REWARD_TYPE';
	var $possibly_some_kind_of_upload=false;
	var $output_of_action_is_confirmation=true;
	var $menu_label='OCREWARDS_TITLE';
	var $do_preview=NULL;
	var $javascript='standardAlternateFields(\'image\',\'url\');';



	/**
	 * Standard aed_module list function.
	 *
	 * @return tempcode		The selection list
	 */
	function nice_get_entries()
	{
		$fields=new ocp_tempcode();

		$this->select_name="BUGBUGBUG";

		$rows=$GLOBALS['SITE_DB']->query_select('ocrewards_type',array('*'),NULL);

		foreach ($rows as $row)
		{
            $fields->attach(form_input_list_entry(strval($row['id']),false,$row['name']));
		}

		return $fields;
	}


	function get_form_fields($id=NULL,$name='',$descrip='',$image='')
	{
		$fields=new ocp_tempcode();
		$hidden=new ocp_tempcode();

		require_code('form_templates');

		$fields->attach(form_input_line(do_lang_tempcode('NAME'),do_lang_tempcode('NAME_REWARD_TYPE'),'name',$name,true));
		$fields->attach(form_input_line(do_lang_tempcode('DESCRIP'),do_lang_tempcode('DESCRIP_REWARD_TYPE'),'descrip',$descrip,true));
		$required=true;
        if ($image!='') {
          $required=false;
        }
        $fields->attach(form_input_upload(do_lang_tempcode('IMAGE'),($required==true?do_lang_tempcode('IMAGE_REWARD3'):do_lang_tempcode('IMAGE_REWARD2',get_custom_base_url().'/'.$image)),'image',$required,NULL,NULL,true,str_replace(' ','',get_option('valid_images'))));

		return array($fields,$hidden);
	}


	/**
	 * Standard aed_module edit form filler.
	 *
	 * @param  ID_TEXT		The entry being edited
	 * @return array			A pair: The input fields, Hidden fields
	 */
	function fill_in_edit_form($id)
	{
		$rows=$GLOBALS['SITE_DB']->query_select('ocrewards_type',array('*'),array('id'=>intval($id)));
		if (!array_key_exists(0,$rows))
		{
			warn_exit(do_lang_tempcode('MISSING_RESOURCE'));
		}
		$myrow=$rows[0];

        $name=$myrow['name'];
        $descrip=$myrow['descrip'];
        $image=$myrow['image'];

		$ret=$this->get_form_fields($id,$name,$descrip,$image);

		return $ret;
	}

	/**
	 * Standard aed_module add actualiser.
	 *
	 * @return array			A pair: The entry added, description about usage
	 */
	function add_actualisation()
	{

		$name=post_param('name');
		$descrip=post_param('descrip');

		require_code('uploads');
		$urls=get_url('url','image','uploads/ocrewards_addon',0,OCP_UPLOAD_IMAGE,false,'','');

		if ($urls[0]=='')
		{
			warn_exit(do_lang_tempcode('IMPROPERLY_FILLED_IN_UPLOAD'));
		}

		if ((substr($urls[0],0,8)!='uploads/') && (is_null(http_download_file($urls[0],0,false))) && (!is_null($GLOBALS['HTTP_MESSAGE_B'])))
			attach_message($GLOBALS['HTTP_MESSAGE_B'],'warn');

		$url=$urls[0];

		//add_banner_type($id,$is_textual,$image_width,$image_height,$max_file_size,$comcode_inline);
		$id=$GLOBALS['SITE_DB']->query_insert('ocrewards_type',array('name'=>$name,'descrip'=>$descrip,'image'=>$url),true);


		return strval($id);
	}

	/**
	 * Standard aed_module edit actualiser.
	 *
	 * @param  ID_TEXT		The entry being edited
	 * @return tempcode		Description about usage
	 */
	function edit_actualisation($id)
	{
		$name=post_param('name');
		$descrip=post_param('descrip');

		require_code('uploads');

        $urls=get_url('url','image','uploads/ocrewards_addon',0,OCP_UPLOAD_IMAGE,false,'','');

		if ((substr($urls[0],0,8)!='uploads/') && (is_null(http_download_file($urls[0],0,false))) && (!is_null($GLOBALS['HTTP_MESSAGE_B'])))
			attach_message($GLOBALS['HTTP_MESSAGE_B'],'warn');

	    $previous_upload_value=$GLOBALS['SITE_DB']->query_select('ocrewards_type',array('image'),array('id'=>intval($id)));
        if ($urls[0]!='') {
          $url=$urls[0]; // Get new value
          @unlink(get_custom_file_base().'/'.rawurldecode($previous_upload_value[0]));
        } else {
          $url=$previous_upload_value[0]['image'];
        }

		//edit_banner_type($id,post_param('new_id'),$is_textual,$image_width,$image_height,$max_file_size,$comcode_inline);
		$GLOBALS['SITE_DB']->query_update('ocrewards_type',array('name'=>$name,'descrip'=>$descrip,'image'=>$url),array('id'=>intval($id)),'',1);

		return NULL;
	}

	/**
	 * Standard aed_module delete actualiser.
	 *
	 * @param  ID_TEXT		The entry being deleted
	 */
	function delete_actualisation($id)
	{
		//delete_banner_type($id);
		$GLOBALS['SITE_DB']->query_delete('ocrewards_type',array('id'=>intval($id)),'',1);
	}

}



