<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		core_configuration
 */

class Hook_admin_config_tick_control
{

	/**
	 * Standard modular run function.
	 *
	 * @param  MEMBER		The ID of the member we are getting link hooks for
	 * @return array		List of tuples for results. Each tuple is: type,title,url
	 */
	function run($data)
	{
		$out			=	new ocp_tempcode();
		foreach ($data as $value)
		{
			$result		=	new ocp_tempcode();
			$controller	=	NULL;
			foreach ($value as $config)
			{
				if($config['CONFIG']['the_type']=='tick' && is_null($controller))
				{
					$controller	=	$config;
					continue;
				}
				$result->attach(get_option_field($config['CONFIG'],$config['NAME_TEMPCODE'],$config['EXPLANATION']));
			}

			if(!is_null($controller))
			{
				$out->attach(form_input_tick_with_sub_fields($controller['NAME_TEMPCODE'],$controller['EXPLANATION'],$controller['CONFIG']['the_name'],get_option($controller['CONFIG']['the_name'])=='1',NULL,$result));
			}
		}

		return $out;
	}
}


