<?php

/**
 * Get the tempcode for a checkbox input.
 *
 * @param  mixed			A human intelligible name for this input field
 * @param  mixed			A description for this input field
 * @param  ID_TEXT		The name which this input field is for
 * @param  boolean		Whether this is ticked by default
 * @param  ?integer		The tab index of the field (NULL: not specified)
 * @return tempcode		The input field
 */
function form_input_tick_with_sub_fields($pretty_name,$description,$name,$ticked,$tabindex=NULL,$other_fields='')
{
	$tabindex	=	get_form_field_tabindex($tabindex);
	$ticked		=	(filter_form_field_default($name,$ticked?'1':'0')=='1');
	$input		=	do_template('FORM_SCREEN_INPUT_TICK',array('CHECKED'=>$ticked,'TABINDEX'=>strval($tabindex),'NAME'=>$name));
	$chd_fields	=	do_template('FORM_SCREEN_FIELD_MULTIPLE_WRAP',array('FIELDS'=>$other_fields));

 	global $JAVASCRIPT;
 	$JAVASCRIPT->attach(do_template('JAVASCRIPT_SHOW_HIDE_FIELDS',array('SHOW_ON_LOAD'=>$ticked,'PARENT_FIELD'=>$name)));

	$input->attach(do_template('FORM_SCREEN_SHOW_HIDE_PANEL',array('TICK_ACTION_FIELD'=>$name,'CHILD_FIELDS'=>$chd_fields,'SHOW_ON_LOAD'=>$ticked)));

	return _form_input($name,$pretty_name,$description,$input,false,false,$tabindex);
}