<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		ecommerce
 */

/**
 * Show a cash flow diagram.
 *
 * @return tempcode	The result of execution.
 */
function render_cash_flow($member=NULL)
{
	$title=get_page_title('CASH_FLOW');

	$GLOBALS['HELPER_PANEL_PIC']='pagepics/cash_flow';

	breadcrumb_set_parents(array(array('_SELF:_SELF:ecom_usage',do_lang_tempcode('ECOMMERCE'))));

	$d=array(get_input_date('from',true),get_input_date('to',true));
	if (is_null($d[0])) return get_between($title);
	list($from,$to)=$d;

	$types=get_types($from,$to,false,$member);
	unset($types['PROFIT']);

	breadcrumb_set_parents(array(array('_SELF:_SELF:ecom_usage',do_lang_tempcode('ECOMMERCE')),array('_SELF:_SELF:cash_flow',do_lang_tempcode('CASH_FLOW'))));
	breadcrumb_set_self(do_lang_tempcode('RESULT'));

	return do_template('ECOM_CASH_FLOW_SCREEN',array('_GUID'=>'a042e16418417f46c24818890679f38a','TITLE'=>$title,'TYPES'=>$types));
}


/**
 * Show a sales report diagram.
 *
 * @return tempcode	The result of execution.
 */
function render_sales_report($member=NULL)
{
	$title=get_page_title('SALES_REPORT');

// 	$GLOBALS['HELPER_PANEL_PIC']='pagepics/cash_flow';

	breadcrumb_set_parents(array(array('_SELF:_SELF:ecom_usage',do_lang_tempcode('ECOMMERCE'))));
	breadcrumb_set_parents(array(array('_SELF:_SELF:ecom_usage',do_lang_tempcode('ECOMMERCE')),array('_SELF:_SELF:sales_report',do_lang_tempcode('SALES_REPORT'))));
	breadcrumb_set_self(do_lang_tempcode('RESULT'));


	$d=array(get_input_date('from',true),get_input_date('to',true));
	if (is_null($d[0])) return get_between($title);
	list($from,$to)=$d;

	$cash_types=get_types($from,$to,false,$member);
	unset($cash_types['PROFIT']);

	$profit_types=get_types($from,$to,true,$member);
	unset($profit_types['OPENING']);
	unset($profit_types['CLOSING']);


	$cf_title = '<h2>'.do_lang('CASH_FLOW').'</h2>';
	$cf=do_template('ECOM_CASH_FLOW_SCREEN',array('_GUID'=>'a042e16418417f46c24818890679f38a','TITLE'=>$cf_title,'TYPES'=>$cash_types));

	$pf_title = '<h2>'.do_lang('PROFIT_LOSS').'</h2>';
	$pf=do_template('ECOM_CASH_FLOW_SCREEN',array('_GUID'=>'a042e16418417f46c24818890679f38a','TITLE'=>$pf_title,'TYPES'=>$profit_types));

	return do_template('ECOM_SALES_REPORT_SCREEN',array('TITLE'=>$title,'PROFIT_LOSS'=>$pf,'CASH_FLOW'=>$cf));
}

/**
 * Show a profit/loss account.
 *
 * @return tempcode	The result of execution.
 */
function render_profit_loss($member=NULL)
{
	$title=get_page_title('PROFIT_LOSS');

	$GLOBALS['HELPER_PANEL_PIC']='pagepics/profit_loss';

	breadcrumb_set_parents(array(array('_SELF:_SELF:ecom_usage',do_lang_tempcode('ECOMMERCE'))));

	$d=array(get_input_date('from',true),get_input_date('to',true));
	if (is_null($d[0])) return get_between($title);
	list($from,$to)=$d;

	$types=get_types($from,$to,true,$member);
	unset($types['OPENING']);
	unset($types['CLOSING']);

	breadcrumb_set_parents(array(array('_SELF:_SELF:ecom_usage',do_lang_tempcode('ECOMMERCE')),array('_SELF:_SELF:profit_loss',do_lang_tempcode('PROFIT_LOSS'))));
	breadcrumb_set_self(do_lang_tempcode('RESULT'));

	return do_template('ECOM_CASH_FLOW_SCREEN',array('_GUID'=>'255681ec95e90e36e085d14cf984b725','TITLE'=>$title,'TYPES'=>$types));
}

/**
 * An interface for choosing between dates.
 *
 * @param  tempcode	The title to display.
 * @return tempcode	The result of execution.
 */
function get_between($title)
{
	require_code('form_templates');

	$fields=new ocp_tempcode();
	$month_start=array(0,0,intval(date('m')),1,intval(date('Y')));
	$fields->attach(form_input_date(do_lang_tempcode('FROM'),'','from',false,false,false,$month_start,10,intval(date('Y'))-9));
	$fields->attach(form_input_date(do_lang_tempcode('TO'),'','to',false,false,false,time(),10,intval(date('Y'))-9));

	return do_template('FORM_SCREEN',array('_GUID'=>'92888622a3ed6b7edbd4d1e5e2b35986','GET'=>true,'SKIP_VALIDATION'=>true,'TITLE'=>$title,'FIELDS'=>$fields,'TEXT'=>'','HIDDEN'=>'','URL'=>get_self_url(false,false,NULL,false,true),'SUBMIT_NAME'=>do_lang_tempcode('PROCEED')));
}

/**
 * Get transaction summaries.
 *
 * @param  TIME		Start of time range
 * @param  TIME		End of time range
 * @param  boolean	Whether to count unpaid invoices into this. This means any invoicing in transactions will be ignored, and  instead invoicing will be read directly.
 * @param  ?MEMBER		I DO NOT KNOW WHAT THIS DOES. PLEASE DOCUMENT IT. Seems to filter for transactions which have "to_member_id" equal to this (*including* NULL)
 * @return array		A template-ready list of maps of summary for multiple transaction types.
 */
function get_types($from,$to,$unpaid_invoices_count=false,$member=NULL)
{

	// PLEASE REPLACE THIS WITH A BETTER COMMENT IF YOU UNDERSTAND THE CODE
	// Not sure what "to_member_id" represents, or whether it's a good idea to
	// add the "IS NULL" condition to the query (since $member seems to have been
	// tacked on to the API, so we've presumably got to preserve the old
	// behaviour if it's not passed?).
	if(!is_null($member))
		$member_filter	=	' AND to_member_id='.strval($member);
	else
		$member_filter	=	' AND to_member_id IS NULL';

	// PLEASE REPLACE THIS WITH A BETTER COMMENT IF YOU UNDERSTAND THE CODE
	// TODO: It seems that the "member" parameter has been hastily added to this
	// function's signature. We could make this more readable if we refactored it
	// a little here to use if/else, rather than ternary ? operators.
	$types=array(
				'OPENING'=>array('TYPE'=>do_lang_tempcode('OPENING_BALANCE'),'AMOUNT'=>0.0,'SPECIAL'=>true),
				'INTEREST_PLUS'=>(!is_null($member))? NULL : array('TYPE'=>do_lang_tempcode('M_INTEREST_PLUS'),'AMOUNT'=>0.0,'SPECIAL'=>false),
				);
	$products=find_all_products(false,$member);
	foreach ($products as $product=>$details)
	{
		$types[$product]=array('TYPE'=>$details[4],'AMOUNT'=>0,'SPECIAL'=>false);
	}
	$types+=array(
				'COST'=>(!is_null($member))? NULL : array('TYPE'=>do_lang_tempcode('EXPENSES'),'AMOUNT'=>0.0,'SPECIAL'=>false),
				'TRANS'=>array('TYPE'=>do_lang_tempcode('TRANSACTION_FEES'),'AMOUNT'=>0.0,'SPECIAL'=>false),
				'WAGE'=>(!is_null($member))? NULL : array('TYPE'=>do_lang_tempcode('WAGES'),'AMOUNT'=>0.0,'SPECIAL'=>false),
				'INTEREST_MINUS'=>(!is_null($member))? NULL : array('TYPE'=>do_lang_tempcode('M_INTEREST_MINUS'),'AMOUNT'=>0.0,'SPECIAL'=>false),
				'TAX'=>(!is_null($member))? NULL : array('TYPE'=>do_lang_tempcode('TAX_GENERAL'),'AMOUNT'=>0.0,'SPECIAL'=>false),
				'CLOSING'=>array('TYPE'=>do_lang_tempcode('CLOSING_BALANCE'),'AMOUNT'=>0.0,'SPECIAL'=>true),
				'PROFIT'=>array('TYPE'=>do_lang_tempcode('NET_PROFIT'),'AMOUNT'=>0.0,'SPECIAL'=>true),
				);

	$filtered_types=array();
	foreach ($types as $item=>$details)
	{
		if (!is_null($details))
			$filtered_types[$item]=$details;
	}
	$types=$filtered_types;

	require_code('currency');

	// PLEASE REPLACE THIS WITH A BETTER COMMENT IF YOU UNDERSTAND THE CODE
	// This query seems to be too specific? Some sales aren't showing up in the
	// sales report and this may be the reason. Could it be the $member_filter?
	$transactions=$GLOBALS['SITE_DB']->query('SELECT * FROM '.$GLOBALS['SITE_DB']->get_table_prefix().'transactions WHERE t_time<'.strval((integer)$to).' AND '.db_string_equal_to('status','Completed').$member_filter.' ORDER BY t_time');

	// The above looks for transactions with the to_member_id set. However, the
	// ecommerce system no longer sets this (because payment happens within the
	// site via credits rather than externally via PayPal or whatever).
	// Thus we try to find transactions for this user based on something we can
	// find from their member ID: ecommerce credits. Gallery sales put the name
	// of the purchase in the "note" field, and since purchases go towards a
	// user's credits (for the time being, at least), there should be a credit
	// equivalent for each sale.
	if (!is_null($member))
	{
		// Grab all of the "note" fields from this user's ecommerce credits, where
		// the credits are for a gallery sale.
		$this_users_item_names = array_map('current', $GLOBALS['SITE_DB']->query('SELECT DISTINCT note FROM '.$GLOBALS['SITE_DB']->get_table_prefix().'ecommerce_credits WHERE member_id='.strval($member).' AND src_code="gallery_sale"'));
		
		// This is used for optimisation reasons (saves looping through the
		// transactions over and over). It stores IDs of transactions we've found.
		// NOTE: We might do something a little cleverer here, like array_map.
		$transaction_ids = array();
		foreach($transactions as $t)
		{
			$transaction_ids[] = $t['id'];
		}
		
		// Now check each item name to see if we have any sales for it
		// NOTE: We *could* think up some clever JOIN here, but since we're only
		// looping on the user's items, rather than the transactions, we should be
		// OK for a while (users won't have thousands of items).
		foreach ($this_users_item_names as $this_name)
		{
			// Grab all of the transactions which have this note as the item_name
			$these_transactions = $GLOBALS['SITE_DB']->query('SELECT * FROM '.$GLOBALS['SITE_DB']->get_table_prefix().'transactions WHERE t_time<'.strval((integer)$to).' AND '.db_string_equal_to('status','Completed').' AND item_name="'.$this_name.'" ORDER BY t_time');
			// Loop through everything we've found
			foreach ($these_transactions as $this_transaction)
			{
				// We don't want to add duplicates to the transactions array, so we
				// check to see if this transaction has already been found.
				if (!in_array($this_transaction['id'], $transaction_ids))
				{
					$transaction_ids[] = $this_transaction['id'];
					$transactions[] = $this_transaction;
				}
			}
		}

	}

	foreach ($transactions as $transaction)
	{
		if ($transaction['t_time']>$from)
		{
			$types['TRANS']['AMOUNT']-=get_transaction_fee($transaction['amount'],$transaction['t_via']);
		}

		if ($unpaid_invoices_count)
		{
			foreach ($products as $product=>$details)
			{
				if (($transaction['item']==$product) && ($details[0]==PRODUCT_INVOICE)) continue 2;
			}
		}

		$product=$transaction['item'];

		// HACKHACK: Really we should save transitional names in the transactions table so we can still retrieve them if an item is deleted.
		$matches=array();
		$row=find_product_row($product);
		if (!is_null($row))
		{
			if (array_key_exists(4,$row)) $product=$row[4];
		} else
		{
			// NOTE: This code is for compatibility with old product naming styles. i.e. legacy reasons
			if (preg_match('#^CATALOGUE\_ITEMS(\d+)#',$product,$matches)!=0)
			{
				require_code('catalogues');
				require_code('catalogues2');
				$catalogue_entries=$GLOBALS['SITE_DB']->query_select('catalogue_entries',array('*'),array('id'=>intval($matches[1])));
				if (count($catalogue_entries)!=0)
				{
					$catalogue_entries=get_catalogue_category_entry_buildup(NULL,$catalogue_entries[0]['c_name'],NULL,'CATEGORY','DEFAULT',NULL,NULL,NULL,-1,NULL,false,$catalogue_entries);
					foreach ($catalogue_entries[2] as $catalogue_entry)
					{
						$product='Physical item: '.$catalogue_entry['map']['FIELD_0_PLAIN']->evaluate();
					}
				}
			}
			elseif (preg_match('#^PERMISSION(\d+)#',$product,$matches)!=0)
			{
				$cat=$GLOBALS['SITE_DB']->query_value_null_ok('permissions_ecom_products','p_category',array('id'=>intval($matches[1])));
				if (!is_null($cat))
				{
					$_product=$GLOBALS['SITE_DB']->query_value_null_ok('galleries','fullname',array('name'=>$cat));
					if (!is_null($_product)) $product=get_translated_text($_product);
				} else
				{
					$cat=$GLOBALS['SITE_DB']->query_value_null_ok('ecommerce_credits','note',array('transaction_id'=>$transaction['purchase_id']));
					if (!is_null($cat)) $product=$cat;
				}
			}
		}

		$transaction['amount']=currency_convert($transaction['amount'],$transaction['t_currency'],get_option('currency'));

		$types['CLOSING']['AMOUNT']+=$transaction['amount'];

		if ($transaction['t_time']<$from)
		{
			$types['OPENING']['AMOUNT']+=$transaction['amount']-get_transaction_fee($transaction['amount'],$transaction['t_via']);
			continue;
		}

		if (($transaction['item']=='OTHER') && ($transaction['amount']<0))
		{
			$types['COST']['AMOUNT']+=$transaction['amount'];
		}
		elseif ($transaction['item']=='TAX')
		{
			$types['TAX']['AMOUNT']+=$transaction['amount'];
		}
		elseif ($transaction['item']=='INTEREST')
		{
			$types[$product][($transaction['amount']<0)?'INTEREST_MINUS':'INTEREST_PLUS']['AMOUNT']+=$transaction['amount'];
		}
		elseif ($transaction['item']=='WAGE')
		{
			$types['WAGE']['AMOUNT']+=$transaction['amount'];
		} else
		{
			if (!array_key_exists($product,$types)) $types[$product]=array('TYPE'=>$product,'AMOUNT'=>0,'SPECIAL'=>false); // In case product no longer exists
			$types[$product]['AMOUNT']+=$transaction['amount'];
		}
	}

	$types['CLOSING']['AMOUNT']+=$types['TRANS']['AMOUNT'];

	// Make sure some are on the end
	foreach (array('TAX','CLOSING','PROFIT') as $t)
	{
		if (isset($types[$t]))
		{
			$temp=$types[$t];
			unset($types[$t]);
			$types[$t]=$temp;
		}
	}

	if ($unpaid_invoices_count)
	{
		$invoices=$GLOBALS['SITE_DB']->query('SELECT * FROM '.$GLOBALS['SITE_DB']->get_table_prefix().'invoices WHERE '.db_string_equal_to('i_state','new').' AND i_time<'.strval((integer)$to).' ORDER BY i_time');
		foreach ($invoices as $invoice)
		{
			$product=$invoice['i_type_code'];

			$types['CLOSING']['AMOUNT']+=$invoice['i_amount'];

			if ($invoice['i_time']<$from)
			{
				$types['OPENING']['AMOUNT']+=$invoice['i_amount'];
				continue;
			}

			$types[$product]['AMOUNT']+=$transaction['amount'];
		}
	}

	foreach ($types as $i=>$t)
	{
		if (is_float($t['AMOUNT'])) $types[$i]['AMOUNT']=float_format($t['AMOUNT']);
		elseif (is_integer($t['AMOUNT'])) $types[$i]['AMOUNT']=strval($t['AMOUNT']).'.00';
	}

	// $types['PROFIT_GROSS'] is not calculated
	$types['PROFIT']['AMOUNT']=float_format(floatval($types['CLOSING']['AMOUNT'])-floatval($types['OPENING']['AMOUNT'])+(array_key_exists('TAX',$types)?floatval($types['TAX']['AMOUNT']):0.0));
	// $types['PROFIT_NET_TAXED'] is not calculated

	return $types;
}
