<?php

/**
 * Get all cpfs of enabled payment gateways
 *
 * @return array	Array of cpf names [ Eg: array('ocp_paypal_api_username'=>1,'ocp_paypal_api_password'=>1) ]
 */
function get_gateway_enabled_cpfs()
{
	$gateway_cpfs	=	array();
	$_hooks 			=	find_all_hooks('systems','ecommerce_via');
	foreach (array_keys($_hooks) as $hook)
	{
		require_code('hooks/systems/ecommerce_via/'.filter_naughty_harsh($hook));
		$payment_object = object_factory('Hook_'.$hook);
		if(method_exists($payment_object,'get_gateway_cpfs') && $payment_object->is_enabled())
		{
			$_cpfs	=	$payment_object->get_gateway_cpfs();
			foreach($_cpfs as $val)
			{
				$gateway_cpfs	=	array_merge($gateway_cpfs,array($val=>1));
			}
		}
	}
	return $gateway_cpfs;
}

/**
 * Make a transaction (payment) button.
 *
 * @param  ID_TEXT		The product codename.
 * @param  SHORT_TEXT	The human-readable product title.
 * @param  ?ID_TEXT		The purchase ID (NULL: unknown, we are actually just having this button to choose the payment gateway).
 * @param  float			A transaction amount.
 * @param  ID_TEXT		The currency to use.
 * @param  ?ID_TEXT		The service the payment will go via via (NULL: autodetect).
 * @return tempcode		The button
 */
function make_transaction_button($product,$item_name=NULL,$purchase_id=NULL,$amount=0,$currency=NULL,$via=NULL,$seller=NULL)
{
	$payment_buttons	=	array();
	require_lang('gift_voucher');
	require_css('ecommerce');
	$_hooks = find_all_hooks('systems','ecommerce_via');
	foreach (array_keys($_hooks) as $hook)
	{
		require_code('hooks/systems/ecommerce_via/'.filter_naughty_harsh($hook));
		$payment_object = object_factory('Hook_'.$hook);
		if(method_exists($payment_object,'is_enabled') && !$payment_object->is_enabled())	continue;

		$button	=	new ocp_tempcode();

		if(perform_local_payment())
		{
			if(!method_exists($payment_object,'show_option_button'))	continue;
			$button	=	$payment_object->show_option_button($product);
		}
		else
		{
			$button	=	(method_exists($payment_object,'make_transaction_button'))?$payment_object->make_transaction_button($product,$item_name,$purchase_id,$amount,$currency,$seller):new ocp_tempcode();
		}

		$payment_buttons[$hook]	=	array('INFO_DESC'=>method_exists($payment_object,'info')?$payment_object->info():$hook,'SIGN_LOGO'=>'','PAY_BUTTON'=>$button);
	}

	$has_multi_gateways	=	(count($payment_buttons)>1)?true:false;

	$notification_text = is_null($purchase_id)?new ocp_tempcode():do_lang_tempcode('CHECKOUT_NOTIFICATION_TEXT',$purchase_id);

	return do_template('PAYMENT_BUTTONS',array('PAYMENT_BUTTONS'=>$payment_buttons,'NOTIFICATION_TEXT'=>$notification_text,'HAS_MULTI_GATEWAYS'=>$has_multi_gateways,'VOUCHER_ACTION_URL'=>get_self_url()));
}

/**
 * Find all products.
 *
 * @param  boolean	Whether to make sure the language for item_name is the site default language (crucial for when we read/go to third-party sales systems and use the item_name as a key).
 * @param  MEMBER		The member to get products for.
 * @return array		A list of maps of product details.
 */
function find_all_products($site_lang=false,$for_member=NULL)
{
	$_hooks=find_all_hooks('systems','ecommerce');
	$products=array();
	foreach (array_keys($_hooks) as $hook)
	{
		require_code('hooks/systems/ecommerce/'.filter_naughty_harsh($hook));
		$object=object_factory('Hook_'.filter_naughty_harsh($hook),true);
		if (is_null($object)) continue;
		$_products=$object->get_products($site_lang);
		foreach ($_products as $product=>$details)
		{
			if (!array_key_exists(4,$details))
			{
				$details[4]=do_lang('CUSTOM_PRODUCT_'.$product,NULL,NULL,NULL,$site_lang?get_lang():NULL);
			}
			$details[]=$object;

			if (!is_null($for_member))
			{
				if (!method_exists($object,'get_seller')) continue;
				if ($object->get_seller($product)!=$for_member) continue;
			}

			$products[$product]=$details;
		}
	}
	return $products;
}

/**
 * Handle IPN's that have been confirmed as backed up by real money.
 *
 * @param  ID_TEXT		The ID of the purchase-type (meaning depends on item_name)
 * @param  SHORT_TEXT	The item being purchased (aka the product) (blank: subscription, so we need to look it up)
 * @param  SHORT_TEXT	The status this transaction is telling of
 * @set    SModified SCancelled Completed Pending Failed
 * @param  SHORT_TEXT	The code that gives reason to the status
 * @param  SHORT_TEXT	The reason it is in pending status (if it is)
 * @param  SHORT_TEXT	A note attached to the transaction
 * @param  SHORT_TEXT	The amount of money
 * @param  SHORT_TEXT	The currency the amount is in
 * @param  SHORT_TEXT	The transaction ID
 * @param  SHORT_TEXT	The ID of the parent transaction
 * @param  ID_TEXT		The ID of a special source for the transaction
 * @param  string			The subscription period (blank: N/A)
 */
function handle_confirmed_transaction($purchase_id,$item_name,$payment_status,$reason_code,$pending_reason,$memo,$mc_gross,$mc_currency,$txn_id,$parent_txn_id,$source='',$period='')
{
	//Temporary setting - force payment setting to "completed" for test mode transactions
	/*if(get_option('ecommerce_test_mode')=="1")
	{
		$payment_status	=	'Completed';
	}*/

	// Check what we sold
	$found = NULL;
	$products = find_all_products();
	foreach ($products as $product=>$details)
	{
		if ($product==$item_name)
		{
			if(is_object($details[5]) && method_exists($details[5],'find_purchased_price'))
			{
				$details[1]	=	$details[5]->find_purchased_price($purchase_id);
			}
			if (($mc_gross!=$details[1]) && ($details[1]!='?'))
			{
				if ($payment_status=='SModified')
					$GLOBALS['SITE_DB']->query_update('subscriptions',array('s_state'=>'new'),array('id'=>intval($purchase_id)),'',1);
				if (($payment_status!='SCancelled') && (substr($txn_id,0,6)!='manual'))
				{
					if(!credit_calculations($mc_gross,$details[1],$txn_id))
						my_exit(do_lang('PURCHASE_WRONG_PRICE',$item_name));
				}
			}
			$found=$details;
			break;
		}
	}
	if (is_null($found)) my_exit(do_lang('PRODUCT_NO_SUCH').' - '.$item_name);

	$object = find_product($item_name);
	$product_det =	$object->product_id;

	$product_name = $product_det[4];

	$subscription = ($product_det[0]==PRODUCT_SUBSCRIPTION) ?  true : false;

	if ($subscription)
	{
		$is_local_sub	=	$GLOBALS['SITE_DB']->query_value_null_ok('subscriptions','locally_controlled',array('id'=>intval($purchase_id)));
	}

	if ($period!='')
	{
		$length=array_key_exists('length',$found[3])?strval($found[3]['length']):'1';
		$length_units=array_key_exists('length_units',$found[3])?$found[3]['length_units']:'m';
		if (strtolower($period)!=strtolower($length.' '.$length_units)) my_exit(do_lang('IPN_SUB_PERIOD_WRONG'));
	}

	// FIXME: The Sales Report screen shows transactions with "to_member_id" set
	// to the relevant user. Here we are setting "to_member_id" as the contents
	// of $_seller, which itself is either NULL or $seller['id']. Likewise,
	// $seller is set to NULL if there is no "get_seller" method for this product
	// and, in the product_permissions hook, "get_seller" returns NULL if the
	// 'enable_member_payments' option is disabled. Thus there are 3 ways for the
	// seller to be NULL, all of which will result in nothing showing up in the
	// sales report. Also, since I'm writing this anyway, this branch is useless
	// considering that $_seller is set inside it, then called from outside it.
	// This implies a massive fail if shopping isn't installed, or a useless fork
	// if it is installed.
	if(addon_installed('shopping'))
	{
		$object	=	find_product(do_lang('PRODUCT_ORDERS',$purchase_id));
		$seller	=	(method_exists($object,'get_seller'))?	$object->get_seller($purchase_id):NULL;
		$_seller	=	(!is_null($seller))?$seller['id']:NULL;
	}

	// Store
	$GLOBALS['SITE_DB']->query_insert('transactions',array('id'=>$txn_id,'t_memo'=>$memo,'purchase_id'=>strval($purchase_id),'status'=>$payment_status,'pending_reason'=>$pending_reason,'reason'=>$reason_code,'amount'=>$mc_gross,'t_currency'=>$mc_currency,'linked'=>$parent_txn_id,'t_time'=>time(),'item'=>$product,'t_via'=>$source,'to_member_id'=>$_seller,'item_name'=>$product_name));

	$details['txn_id']	=	$txn_id;

	// Check currency
	if ($mc_currency!=get_option('currency'))
	{
		if ($payment_status=='SModified')
			$GLOBALS['SITE_DB']->query_update('subscriptions',array('s_state'=>'new'),array('id'=>intval($purchase_id)),'',1);
		if (($payment_status!='SCancelled') && (substr($txn_id,0,6)!='manual')) my_exit(do_lang('PURCHASE_WRONG_CURRENCY'));
	}

	// Pending
	if (($payment_status=='Pending') && (strpos($item_name,'invoice')!==false))
	{
		$GLOBALS['SITE_DB']->query_update('invoices',array('i_state'=>'pending'),array('id'=>intval($purchase_id)),'',1);
	}
	elseif (($payment_status=='Pending') && ($subscription))
	{
		$GLOBALS['SITE_DB']->query_update('subscriptions',array('s_state'=>'pending'),array('id'=>intval($purchase_id)),'',1);
		if ($details[2]!='') call_user_func_array($details[2],array($purchase_id,$details,$product,true)); // Run cancel code
	}
	elseif (($payment_status=='Pending') && ($item_name==do_lang('PRODUCT_ORDERS',$purchase_id)))
	{
		$details['ORDER_STATUS']='ORDER_STATUS_awaiting_payment';

		if ($details[2]!='') call_user_func_array($details[2],array($purchase_id,$details,$product,true)); // Set order status
	}
	// Cancelled
	elseif (($payment_status=='SCancelled') && ($subscription))
	{
		$update_vals	=	array('s_auto_fund_source'=>$source,'s_state'=>'cancelled','s_time'=>time());
		$GLOBALS['SITE_DB']->query_update('subscriptions',$update_vals,array('id'=>intval($purchase_id)),'',1);
		if ($found[2]!='') call_user_func_array($found[2],array($purchase_id,$found,$product,true)); // Run cancel code
	}
	//Made active
	elseif ($subscription)
	{
		$update_vals	=	array('s_auto_fund_source'=>$source,'s_state'=>'active','s_via'=>$source);
		if(!$is_local_sub)
		{
			$update_vals	=	array_merge($update_vals,array('s_auto_fund_key'=>$txn_id));
		}
		else
		{
			$update_vals	=	array_merge($update_vals,array('s_time'=>time()));
		}

		require_code('hooks/systems/ecommerce_via/'.$source);
		$payment_object	=	object_factory('Hook_'.$source);

		if(method_exists($payment_object,'map_payment_ids'))
		{
			$sub_prof_data	=	$payment_object->map_payment_ids($txn_id,$parent_txn_id);
			$update_vals	=	array_merge($update_vals,array('s_auto_fund_key'=>$sub_prof_data));
		}

		$GLOBALS['SITE_DB']->query_update('subscriptions',$update_vals,array('id'=>intval($purchase_id)),'',1);
	}

	// Check completed
	elseif (($payment_status!='Completed') && ($payment_status!='SCancelled') && get_option('ecommerce_test_mode')!="1")
		my_exit(do_lang('TRANSACTION_NOT_COMPLETE',$product.':'.strval($purchase_id),$payment_status),true);


	// Dispatch section code

	if ($payment_status=='Completed')
	{
		//Find product hooks of this order to check dispatch type

		if(is_object($object) && !method_exists($object,'get_product_dispatch_type'))
		{	//If hook does not have dispatch method setting take dispatch method as automatic
			$details['ORDER_STATUS']	=	'ORDER_STATUS_dispatched';
		}
		elseif(is_object($object) && $object->get_product_dispatch_type($purchase_id)=='automatic')
		{
			$details['ORDER_STATUS']	=	'ORDER_STATUS_dispatched';
		}
		else
		{
			$details['ORDER_STATUS']	=	'ORDER_STATUS_payment_received';
		}

		if ($details[2]!='') call_user_func_array($details[2],array($purchase_id,$details,$product));
	}

	//Dispatch section end

	// Invoice handling
	if ($found[0]==PRODUCT_INVOICE)
	{
		$price=$GLOBALS['SITE_DB']->query_value('invoices','i_amount',array('id'=>intval($purchase_id)));

		// Reading the credit points of the member
		require_code('hooks/modules/catalogue_items');
		$object=object_factory('Hook_catalogue_items');

		$member_id=method_exists($object,'member_for')?$object->member_for($purchase_id):$GLOBALS['FORUM_DRIVER']->get_guest_id();

		if(!credit_calculations($mc_gross,$details[1],$txn_id))
			my_exit(do_lang('PURCHASE_WRONG_PRICE',$item_name));

		$GLOBALS['SITE_DB']->query_update('invoices',array('i_state'=>'paid'),array('id'=>intval($purchase_id)),'',1);
	}

	// Delete if cancelled
	if (($payment_status=='SCancelled') && ($subscription))
	{
		$GLOBALS['SITE_DB']->query_delete('subscriptions',array('id'=>intval($purchase_id)),'',1);
	}
}

