<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		core
 */

function get_option_field($myrow,$name_tempcode,$explanation)
{
	$out	=	new ocp_tempcode();
	switch ($myrow['the_type'])
	{
		case 'integer':
			$out->attach(form_input_integer($name_tempcode,$explanation,$myrow['the_name'],intval(get_option($myrow['the_name'])),false));
			break;
		case 'line':
			if ($myrow['the_name']=='currency')
			{
				$list=new ocp_tempcode();
				$currencies=array('USD','CAD','EUR','GBP','JPY','AUD');
				foreach ($currencies as $currency)
				{
					$list->attach(form_input_list_entry($currency,$currency==get_option($myrow['the_name'])));
				}
				$out->attach(form_input_list($name_tempcode,$explanation,$myrow['the_name'],$list));
			}
			elseif ($myrow['the_name']=='payment_gateway')
			{
				$list=new ocp_tempcode();
				$all_via=find_all_hooks('systems','ecommerce_via');
				foreach (array_keys($all_via) as $via)
				{
					$list->attach(form_input_list_entry($via,$via==get_option($myrow['the_name'])));
				}
				$out->attach(form_input_list($name_tempcode,$explanation,$myrow['the_name'],$list));
			} else
			{
			/*if (strpos($myrow['the_name'],'password')!==false)  password fields can't take defaults
				$out->attach(form_input_password($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name']),false));
			else
				*/$out->attach(form_input_line($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name']),false));
			}
			break;
		case 'list':
			$list=new ocp_tempcode();
			$_value=get_option($myrow['the_name']);
			$values=explode('|',$myrow['c_data']);
			foreach ($values as $value)
			{
				$list->attach(form_input_list_entry($value,$_value==$value,do_lang_tempcode('CONFIG_OPTION_'.$myrow['the_name'].'_VALUE_'.$value)));
			}
			$out->attach(form_input_list($name_tempcode,$explanation,$myrow['the_name'],$list));
			break;
		case 'transline':
			$out->attach(form_input_line($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name']),false));
			break;
		case 'text':
			$out->attach(form_input_text($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name']),false,NULL,true));
			break;
		case 'transtext':
			$out->attach(form_input_text($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name']),false,NULL,true));
			break;
		case 'float':
			$out->attach(form_input_float($name_tempcode,$explanation,$myrow['the_name'],floatval(get_option($myrow['the_name'])),false));
			break;
		case 'tick':
			$out->attach(form_input_tick($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name'])=='1'));
			break;
		case 'date':
			$out->attach(form_input_date($name_tempcode,$explanation,$myrow['the_name'],false,false,false,intval(get_option($myrow['the_name'])),40,intval(date('Y'))-20,NULL,false));
			break;
		case 'forum':
			if (get_forum_type()=='ocf')
			{
				$current_setting=get_option($myrow['the_name']);
				if (!is_numeric($current_setting))
				{
					$_current_setting=$GLOBALS['FORUM_DB']->query_value_null_ok('f_forums','id',array('f_name'=>$current_setting));
					$current_setting=is_null($_current_setting)?strval(db_get_first_id()):strval($_current_setting);
				}
				$out->attach(form_input_tree_list($name_tempcode,$explanation,$myrow['the_name'],NULL,'choose_forum',array(),false,$current_setting));
			} else
			{
				$out->attach(form_input_line($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name']),false));
			}
			break;
		case 'category':
			if (get_forum_type()=='ocf')
			{
				$tmp_value=$GLOBALS['FORUM_DB']->query_value_null_ok('f_categories','id',array('c_title'=>get_option($myrow['the_name'])));

				require_code('ocf_forums2');
				$list=ocf_nice_get_categories(NULL,$tmp_value);
				$out->attach(form_input_list($name_tempcode,$explanation,$myrow['the_name'],$list));
			} else
			{
				$out->attach(form_input_line($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name']),false));
			}
			break;
		case 'usergroup':
			if (get_forum_type()=='ocf')
			{
				$tmp_value=$GLOBALS['FORUM_DB']->query_value_null_ok('f_groups g LEFT JOIN '.$GLOBALS['FORUM_DB']->get_table_prefix().'translate t ON t.id=g.g_name','g.id',array('text_original'=>get_option($myrow['the_name'])));

				require_code('ocf_groups');
				$list=ocf_nice_get_usergroups($tmp_value);
				$out->attach(form_input_list($name_tempcode,$explanation,$myrow['the_name'],$list));
			} else
			{
				$out->attach(form_input_line($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name']),false));
			}
			break;
	}
	return $out;
}


