<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		galleries
 */

class Block_main_members_store
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']='Manuprathap';
		$info['organisation']='ocProducts';
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=2;
		$info['locked']=true;
		$info['parameters']=array('param','filter');
		return $info;
	}

	/**
	 * Standard modular cache function.
	 *
	 * @return ?array	Map of cache details (cache_on and ttl) (NULL: module is disabled).
	 */
	function cacheing_environment()
	{
		$info=array();
		$info['cache_on']='array(array_key_exists(\'filter\',$map)?$map[\'filter\']:\'\',array_key_exists(\'max\',$map)?intval($map[\'param\']):NULL,array_key_exists(\'param\',$map)?intval($map[\'param\']):get_member())';
		$info['ttl']=60;
		return $info;
	}

	/**
	 * Standard modular run function.
	 *
	 * @param  array		A map of parameters.
	 * @return tempcode	The result of execution.
	 */
	function run($map)
	{
		require_code('catalogues');
		require_lang('catalogues');

		$member_id=array_key_exists('param',$map)?intval($map['param']):get_member();
		$catalogue_name	=	'store_'.strval($member_id);

		//Check existance of store
		$temp	=	$GLOBALS['SITE_DB']->query_value_null_ok('catalogues','c_name',array('c_name'=>$catalogue_name,'c_ecommerce'=>1));
		if(is_null($temp))	return new ocp_tempcode();

		$temp	=	$GLOBALS['SITE_DB']->query_value_null_ok('catalogue_entries','id',array('c_name'=>$catalogue_name));
		if(is_null($temp))	return new ocp_tempcode();

		$row	=	$GLOBALS['SITE_DB']->query("SELECT MIN(id) as id FROM ".get_table_prefix()."catalogue_categories WHERE c_name='".get_param('catalogue_name',$catalogue_name)."' AND cc_parent_id IS NULL");
		$category_id	=	$row[0]['id'];
		return render_catalogue_category_screen($category_id,true,true);
	}
}


