<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license	http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package	shopping
 */

class Module_shopping
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']='Manuprathap';
		$info['organisation']='ocProducts';
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=5;
		$info['update_require_upgrade']=1;
		$info['locked']=false;
		return $info;
	}

	/**
	 * Standard modular uninstall function.
	*/
	function uninstall()
	{
		$GLOBALS['SITE_DB']->drop_if_exists('shopping_cart');

		$GLOBALS['SITE_DB']->drop_if_exists('shopping_order_details');

		$GLOBALS['SITE_DB']->drop_if_exists('shopping_order');

		$GLOBALS['SITE_DB']->drop_if_exists('shopping_logging');

		$GLOBALS['SITE_DB']->drop_if_exists('shopping_order_addresses');

		$GLOBALS['SITE_DB']->query_delete('group_category_access',array('module_the_name'=>'shopping'));

		delete_config_option('shipping_cost_factor');
		delete_config_option('allow_opting_out_of_tax');
		delete_config_option('paypal_address');
		delete_config_option('ocp_paypal_address');
		delete_config_option('relay_url_return');
		delete_config_option('relay_url_send');
	}

	/**
	 * Standard modular install function.
	 *
	 * @param  ?integer	What version we're upgrading from (NULL: new install)
	 * @param  ?integer	What hack version we're upgrading from (NULL: new-install/not-upgrading-from-a-hacked-version)
	*/
	function install($upgrade_from=NULL,$upgrade_from_hack=NULL)
	{
		if(is_null($upgrade_from))
		{
			$GLOBALS['SITE_DB']->create_table('shopping_cart',array(
				'id'							=>	'*AUTO',
				'session_id'				=>	'INTEGER',
				'ordered_by'				=>	'*USER',
				'product_id'				=>	'*AUTO_LINK',
				'product_name'				=>	'SHORT_TEXT',
				'product_code'				=>	'SHORT_TEXT',
				'quantity'					=>	'INTEGER',
				'tax'			            =>	'REAL',
				'tax_type'					=> 'SHORT_TEXT',
				'price'						=>	'REAL',
				'product_description'	=>	'LONG_TEXT',
				'product_type'				=>	'SHORT_TEXT',
				'product_weight'			=>	'REAL',
				'is_deleted'				=>	'BINARY',
			));

			$GLOBALS['SITE_DB']->create_table('shopping_order',array(
				'id'					=>	'*AUTO',
				'c_member'			=>	'USER',
				'session_id'		=>	'INTEGER',
				'add_date'			=>	'TIME',
				'tot_price'			=>	'REAL',
				'order_status'		=>	'ID_TEXT',
				'notes'				=>	'LONG_TEXT',
				'transaction_id'	=>	'SHORT_TEXT',
				'product_name'		=>	'ID_TEXT',//(this keeps the actual order product name  like CART_ORDER, PERMISSIONS etc
				'tax_opted_out'	=>	'BINARY',
				'to_member_id'		=>	'?USER',
				'shipping_option'	=>	'?AUTO_LINK',
			));

			$GLOBALS['SITE_DB']->create_table('shopping_order_details',array(
				'id'					=>	'*AUTO',
				'order_id'			=>	'?AUTO_LINK',
				'p_id'				=>	'?AUTO_LINK',
				'p_name'				=>	'SHORT_TEXT',
				'p_code'				=>	'SHORT_TEXT',
				'p_type'				=>	'SHORT_TEXT',
				'p_quantity'		=>	'INTEGER',
				'p_price'			=>	'REAL',
				'included_tax'		=>	'REAL',
				'dispatch_status'	=>	'SHORT_TEXT'
			));

			$GLOBALS['SITE_DB']->create_table('shopping_logging',array(
				'id'					=>	'*AUTO',
				'e_member_id'		=>	'*USER',
				'session_id'		=>	'INTEGER',
				'ip'					=>	'IP',
				'last_action'		=>	'SHORT_TEXT',
				'date_and_time'	=>	'TIME',
				'item'				=>	'?AUTO_LINK',
			));

			$GLOBALS['SITE_DB']->create_table('shopping_order_addresses',array(
				'id'					=>	'*AUTO',
				'order_id'			=>	'?AUTO_LINK',
				'address_name'		=>	'SHORT_TEXT',
				'address_street'	=>	'LONG_TEXT',
				'address_state'	=>	'ID_TEXT',
				'address_city'		=>	'ID_TEXT',
				'address_zip'		=>	'ID_TEXT',
				'address_country'	=>	'ID_TEXT',
				'receiver_email'	=>	'ID_TEXT',
			));

			require_lang('shopping');

			$GLOBALS['SITE_DB']->create_index('shopping_order','recent_shopped',array('add_date'));
			$GLOBALS['SITE_DB']->create_index('shopping_logging','calculate_bandwidth',array('date_and_time'));

			add_config_option('SHIPPING_COST_FACTOR','shipping_cost_factor','float','return \'0.0\';','ECOMMERCE','ECOMMERCE',1);
			add_config_option('ALLOW_OPTING_OUT_OF_TAX','allow_opting_out_of_tax','tick','return \'1\';','ECOMMERCE','ECOMMERCE');

			add_menu_item_simple('ecommerce_features',NULL,'ORDERS','_SEARCH:shopping:type=my_orders');

			//CPFs for ecommerce purchase
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('firstname',20,1,1,1,0,'','short_text');
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('lastname',20,1,1,1,0,'','short_text');
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('building_name_or_number',100,1,0,0,0,'','long_text');
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('city',20,1,1,1,0,'','short_text');
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('state',100,1,0,0,0,'','short_text');
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('post_code',20,1,1,1,0,'','short_text');
			require_code('currency');
			$currencies=get_currency_map();
			$_countries=array();
			foreach ($currencies as $c)
				$_countries=array_merge($_countries,$c);
			$_countries=array_unique($_countries);
			sort($_countries);
			$countries='|'.implode('|',$_countries);
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('country',100,1,0,0,0,'','list',0,$countries);

			//CPF for custom paypal address (For selling items by a submitter instead of website, ie, the payment will go to the given cpf address of submitter of an item
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('paypal_address',20,1,1,1,0,do_lang('SPECIAL_CPF__ocp_paypal_address_DESCRIPTION'),'short_text');

			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('recipient_email',20,1,1,1,0,do_lang('SPECIAL_CPF__ocp_recipient_email_DESCRIPTION'),'short_text');

			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('recipient_tocken_id',20,1,1,1,0,do_lang('SPECIAL_CPF__ocp_recipient_tocken_id_DESCRIPTION'),'short_text');

			//Example return url : http://winserv.ocproducts.biz/Manu/relay/request_receive.php
			add_config_option('PAYMENT_GATEWAY_RELAY_URL_RETURN','relay_url_return','line','return \'\';','ECOMMERCE','ECOMMERCE');
			//Example return url : http://winserv.ocproducts.biz/Manu/relay/request_send.php
			add_config_option('PAYMENT_GATEWAY_RELAY_URL_SEND','relay_url_send','line','return \'\';','ECOMMERCE','ECOMMERCE');
		}
	}

	/**
	 * Standard modular entry-point finder function.
	 *
	 * @return ?array	A map of entry points (type-code=>language-code) (NULL: disabled).
	 */
	function get_entry_points()
	{
		return array('my_orders'=>'MY_ORDERS','my_cart'=>'SHOPPING');
	}

	/**
	 * Standard modular run function.
	 *
	 * @return tempcode	The result of execution.
	*/
	function run()
	{
		require_lang('shopping');
		require_lang('catalogues');
		require_code('shopping');
		require_code('feedback');
		require_lang('ecommerce');
		require_code('ecommerce');

		if (get_forum_type()!='ocf') warn_exit(do_lang_tempcode('NO_OCF'));

		// Kill switch
		//if ((ecommerce_test_mode()) && (!$GLOBALS['IS_ACTUALLY_ADMIN']) && (!has_specific_permission(get_member(),'access_ecommerce_in_test_mode'))) warn_exit(do_lang_tempcode('PURCHASE_DISABLED'));

		$type	=	get_param('type','misc');

		if ($type=='view_cart') 	return	$this->view_shopping_cart();
		if ($type=='add_item') 		return	$this->add_item_to_cart();
		if ($type=='update_cart') 	return	$this->update_cart();
		if ($type=='empty_cart') 	return	$this->empty_cart();
		if ($type=='pay') 		return	$this->pay();
		if ($type=='order') 		return	$this->order();
		if ($type=='finish') 		return	$this->finish();
		if ($type=='my_orders') 	return $this->my_orders();
		if ($type=='order_det') 	return $this->order_det();
		if ($type=='mp_fee') 	return $this->show_market_place_fee_button();
		if ($type=='_mp_fee') 	return $this->market_place_return();

		return new ocp_tempcode();
	}

	/**
	 * The UI to show shopping cart
	 *
	 * @return tempcode		The UI
	*/
	function view_shopping_cart()
	{
		$pro_ids	=	array();

		$shipping_rates	=	array();

		$pro_ids_val	=	NULL;

		require_code('templates_results_table');

		require_code('form_templates');

		require_css('shopping');

		require_javascript('javascript_shopping');

		$title		=	get_page_title('SHOPPING');

		log_cart_actions('View cart');

		breadcrumb_set_parents(array(array('_SELF:catalogues:misc:ecommerce=1',do_lang_tempcode('CATALOGUES'))));

		$result		=	$GLOBALS['SITE_DB']->query_select('shopping_cart',array('*'),array('session_id'=>get_session_id(),'ordered_by'=>get_member(),'is_deleted'=>0));

		$max_rows			=	count($result);
		$shopping_cart		=	new ocp_tempcode();

		$tax_type='';
		$tax_rate='';

		if($max_rows>0)
		{
			$checkout_details	=	new ocp_tempcode();

			$fields_title=results_field_title(
								array(
									'',
									do_lang_tempcode('PRODUCT_NAME'),
									do_lang_tempcode('UNIT_PRICE'),
									do_lang_tempcode('QUANTITY'),
									do_lang_tempcode('TAX'),
									do_lang_tempcode('SHIPPING_CHARGE'),
									do_lang_tempcode('TOTAL_PRICE'),
									do_lang_tempcode('REMOVE_FROM_CART')
								),NULL
							);

			$i					=	1;
			$sub_tot			=	0.0;
			$tot_tax			=	0.0;
			$shipping_cost	=	0;
			$weight			=	0;

			foreach ($result as $value)
			{
				$pro_ids[]	=	$value['product_id'];

				$_hook		=	$value['product_type'];

				$value['sl_no']	=	$i;

				require_code('hooks/systems/ecommerce/'.filter_naughty_harsh($_hook));

				$object		=	object_factory('Hook_'.filter_naughty_harsh($_hook));

				$tax_type=$value['tax_type'];

				if(method_exists($object,'show_cart_entry'))
				{
					$object->show_cart_entry($shopping_cart/*Received by reference*/,$value);
					$shipping_rates	=	array_merge($shipping_rates,array($shopping_cart->shipping_equation_amts));
				}

				if(method_exists($object,'calculate_tax'))
					$tax	=	$object->calculate_tax($value['price'],$value['tax']);
				else
					$tax	=	0;


				//Shipping
				if(method_exists($object,'calculate_shipping_cost'))
					$shipping_cost	=	$object->calculate_shipping_cost($value['product_weight']);
				else
					$shipping_cost	=	0;

				$sub_tot				+=	round($value['price']+$tax+$shipping_cost,2)*$value['quantity'];
				$weight				+=	$value['product_weight']*$value['quantity'];

				$i++;
			}

			$width		=	array('60','100%','75','75','75','75','75','75');

			$results_table	=	results_table(do_lang_tempcode('ENTRIES'),0,'start',$max_rows,'max',$max_rows,$fields_title,$shopping_cart,NULL,NULL,NULL,'sort',NULL,$width,'cart');

			$update_cart	=	build_url(array('page'=>'_SELF','type'=>'update_cart'),'_SELF');

			$empty_cart		=	build_url(array('page'=>'_SELF','type'=>'empty_cart'),'_SELF');

			$checkout 		= 	build_url(array('page'=>'_SELF','type'=>'pay'),'_SELF');

			$payment_form	=	payment_form();

			$proceed_box	=	do_template('SHOPPING_CART_PROCEED',array('SUB_TOTAL'=>float_format($sub_tot),'SHIPPING_COST'=>float_format($shipping_cost),'GRAND_TOTAL'=>float_format($sub_tot),'CHECKOUT_URL'=>$checkout,'PROCEED'=>do_lang_tempcode('PROCEED'),'CURRENCY'=>ecommerce_get_currency_symbol(),'PAYMENT_FORM'=>$payment_form));

		}
		else
		{
			$update_cart	= 	new ocp_tempcode();

			$empty_cart		=	new ocp_tempcode();

			$checkout		=	new ocp_tempcode();

			$results_table	=	do_lang_tempcode('CART_EMPTY');

			$proceed_box	=	new ocp_tempcode();
		}

		if(isset($shopping_cart->catalogue))
		{
			$category			=	$GLOBALS['SITE_DB']->query_value_null_ok('catalogue_categories','id',array('c_name'=>$shopping_cart->catalogue));

			$cont_shopping 	= 	build_url(array('page'=>'catalogues','type'=>'category','id'=>$category,'catalogue_name'=>$shopping_cart->catalogue),'_SELF');
		}
		else
		{
			$default_catalogue	=	$GLOBALS['SITE_DB']->query_value_null_ok('catalogues','c_name',array('c_ecommerce'=>1,'c_owner'=>NULL));

			$cont_shopping 		=	(!is_null($default_catalogue))?build_url(array('page'=>'catalogues','type'=>'category','id'=>$default_catalogue,'catalogue_name'=>$default_catalogue),'_SELF'):new ocp_tempcode();
		}

		//Product id string for hidden field in Shopping cart
		$pro_ids_val	=	is_array($pro_ids)?implode(',',$pro_ids):'';

		$allow_opt_out_tax			=	get_option('allow_opting_out_of_tax');

		$allow_opt_out_tax_value	=	get_order_tax_opt_out_status();

		$shipping_options				=	array();

		$row	=	$GLOBALS['SITE_DB']->query('SELECT * FROM '.get_table_prefix().'shipping_equations ORDER BY is_default DESC, add_date DESC');

		foreach($row as $key=>$value)
		{
			$equation_rate	=	0;
			foreach ($shipping_rates as $rates)
				$equation_rate	+=	array_key_exists($value['id'],$rates)?$rates[$value['id']]:0;

			$shipping_options[$value['id']]	=	get_translated_text($value['title'])." (".ecommerce_get_currency_symbol().strval(float_format($equation_rate,2)).")";
		}

		$order_id		=	get_current_order_id();

		$selected_shipping_option	=	$GLOBALS['SITE_DB']->query_value_null_ok('shopping_order','shipping_option',array('id'=>$order_id));

		return do_template('SHOPPING_CART_SCREEN',array('TITLE'=>$title,'TAX_TYPE'=>$tax_type,'RESULT_TABLE'=>$results_table,'CONTENT'=>'','FORM_URL'=>$update_cart,'CONT_SHOPPING'=>$cont_shopping,'MESSAGE'=>'','BACK'=>$cont_shopping,'PRO_IDS'=>$pro_ids_val,'EMPTY_CART'=>$empty_cart,'EMPTY'=>do_lang_tempcode('EMPTY_CART'),'UPDATE'=>do_lang_tempcode('UPDATE'),'CONTINUE_SHOPPING'=>do_lang_tempcode('CONTINUE_SHOPPING'),'PROCEED_BOX'=>$proceed_box,'ALLOW_OPTOUT_TAX'=>$allow_opt_out_tax,'ALLOW_OPTOUT_TAX_VALUE'=>strval($allow_opt_out_tax_value),'SHIPPING_OPTIONS'=>$shipping_options,'SELECTED_SHIPPING_OPT'=>strval($selected_shipping_option)),NULL,false);
	}

	/**
	 * Function to add item to cart.
	 *
	 * @return tempcode		The UI
	*/
	function add_item_to_cart()
	{
		$title				=	get_page_title('SHOPPING');

		$_hooks				=	find_all_hooks('systems','ecommerce');

		$product_details	=	get_product_details();

		add_to_cart($product_details);

		log_cart_actions('Added to cart');

 		$cart_view		=	build_url(array('page'=>'_SELF','type'=>'view_cart'),'_SELF');

		return redirect_screen($title,$cart_view,do_lang_tempcode('SUCCESS'));
	}

	/**
	 * Function to Update cart
	 *
	 * @return tempcode			The UI
	*/
	function update_cart()
	{
		$title		=	get_page_title('SHOPPING');

		$p_ids		=	post_param('product_ids');

		$pids		=	explode(",",$p_ids);

		$product_to_remove	=	array();

		$product_details	=	array();

		if(count($pids)>0)
		{
			foreach($pids as $pid)
			{
				$qty		=	post_param_integer('quantity_'.$pid);

				$object		=	find_product($pid);

				if (method_exists($object,'get_available_quantity'))
				{
					$available_qty	=	$object->get_available_quantity($pid);

					if((!is_null($available_qty)) && ($available_qty<$qty))
					{
						$qty	=	$available_qty;

						attach_message(do_lang_tempcode('PRODUCT_QUANTITY_CHANGED',strval($pid)),'warn');
					}
				}

				$product_details[]	=	array('product_id'=>$pid,'Quantity'=>$qty);

				$remove			=	post_param_integer('remove_'.$pid,0);

				if($remove==1)	$product_to_remove	[]	=	$pid;
			}
		}

		update_cart($product_details);

		log_cart_actions('Updated cart');

		if(count($product_to_remove)>0)
			remove_from_cart($product_to_remove);


		$cart_view	=	build_url(array('page'=>'_SELF','type'=>'view_cart'),'_SELF');

		return redirect_screen($title,$cart_view,do_lang_tempcode('CART_UPDATED'));
	}

	/**
	* Function to empty shopping cart
	*
	* @return tempcode		The UI
	*/
	function empty_cart()
	{
		$title		=	get_page_title('SHOPPING');

		log_cart_actions('Cart emptied');

		$GLOBALS['SITE_DB']->query_update('shopping_cart', array('is_deleted'=>1),array('session_id'=>get_session_id()));

		$cart_view	=	build_url(array('page'=>'_SELF','type'=>'view_cart'),'_SELF');

		return redirect_screen($title,$cart_view,do_lang_tempcode('CART_EMPTIED'));
	}

	/**
	 * Wrap-up so as to remove redundancy in templates.
	 *
	 * @param  tempcode	To wrap.
	 * @param  tempcode	The title to use.
	 * @param  ?mixed		URL (NULL: no next URL).
	 * @param  boolean	Whether it is a GET form
	 * @return tempcode	Wrapped.
	 */
	function wrap($content,$title,$url,$get=false)
	{
		if (is_null($url)) $url='';
		require_javascript('javascript_validation');

		return do_template('PURCHASE_WIZARD_SCREEN',array('_GUID'=>'a32c99acc28e8ad05fd9b5e2f2cda029','GET'=>$get?true:NULL,'TITLE'=>$title,'CONTENT'=>$content,'URL'=>$url));
	}

	/**
	 * Finish step.
	 *
	 * @return tempcode	The result of execution.
	*/
	function finish()
	{
		$title		=	get_page_title('_PURCHASE_FINISHED');

		breadcrumb_set_parents(array(array('_SELF:catalogues:misc:ecommerce=1',do_lang_tempcode('CATALOGUES')),array('_SELF:_SELF:view_cart',do_lang_tempcode('SHOPPING'))));

		$message=get_param('message',NULL,true);

		//Empty cart.
		$GLOBALS['SITE_DB']->query_delete('shopping_cart', array('session_id'=>get_session_id()));

		log_cart_actions('Completed payment');

		if (perform_local_payment())
		{
			$trans_id=post_param('trans_id');

			$transaction_rows=$GLOBALS['SITE_DB']->query_select('trans_expecting',array('*'),array('id'=>$trans_id),'',1);

			if (!array_key_exists(0,$transaction_rows)) warn_exit(do_lang_tempcode('MISSING_RESOURCE'));

			$transaction_row	=	$transaction_rows[0];

			$amount			=	$transaction_row['e_amount'];

			$length			=	$transaction_row['e_length'];

			$length_units		=	$transaction_row['e_length_units'];

			$via			=	get_option('payment_gateway');

			require_code('hooks/systems/ecommerce_via/'.filter_naughty_harsh($via));

			$object			=	object_factory('Hook_'.$via);
			$first_name			=	post_param('first_name');
			$last_name			=	post_param('last_name');

			$card_number		=	post_param('card_number');
			$expiry_date		=	str_replace('/','',post_param('expiry_date'));
			$issue_number		=	post_param_integer('issue_number',NULL);
			$start_date		=	str_replace('/','',post_param('start_date',''));
			$card_type		=	post_param('card_type','');
			$cv2			=	post_param('cv2','');
			$address1=post_param('address1');
			$city=post_param('city');
			$state=post_param('state','');
			$zip=post_param('zip');
			$country=post_param('country','');

			$product=get_param('product');
			$temp=find_product($product);
			$_product_row=$temp->get_products(true);
			$product_row=$_product_row[$product];

			list($success,,$message,$message_raw)	=	$object->do_transaction($trans_id,$first_name,$last_name,$card_number,$amount,$expiry_date,$issue_number,$start_date,$card_type,$cv2,$length,$length_units,$product_row[4],/*get_member() this should be item owner*/NULL,$address1,$city,$state,$zip,$country);

			if (($success) || (!is_null($length)))
			{
				$status=((!is_null($length)) && (!$success))?'SCancelled':'Completed';
				handle_confirmed_transaction($transaction_row['e_purchase_id'],$transaction_row['e_item_name'],$status,$message_raw,'','',$amount,get_option('currency'),$trans_id,'',$via,is_null($length)?'':strtolower(strval($length).' '.$length_units));
			}

			if ($success)
			{
				$member_id=$transaction_row['e_member_id'];
				require_code('mail');
				$to_name=$GLOBALS['FORUM_DRIVER']->get_username($member_id);
				$email=$GLOBALS['FORUM_DRIVER']->get_member_email_address($member_id);
				mail_wrap(do_lang('PAYMENT_RECEIVED_SUBJECT'),do_lang('PAYMENT_RECEIVED_BODY',float_format(floatval($amount)),get_option('currency'),get_site_name()),array($email),$to_name);
			}
		}

		if (get_param_integer('cancel',0)==0)
		{
			$order_id	=	post_param('custom','-1');

			handle_transaction_script();

			attach_message(do_lang_tempcode('SUCCESS'),'inform');

			$object=find_product(do_lang('CART-ORDER',$order_id));

			if (method_exists($object,'get_finish_url'))
			{
				return redirect_screen($title,$object->get_finish_url(),$message);
			}

			return $this->wrap(do_template('PURCHASE_WIZARD_STAGE_FINISH',array('TITLE'=>$title,'MESSAGE'=>$message)),$title,NULL);
		}

		if (!is_null($message))
		{
			return $this->wrap(do_template('PURCHASE_WIZARD_STAGE_FINISH',array('TITLE'=>$title,'MESSAGE'=>$message)),$title,NULL);
		}

		warn_exit(do_lang_tempcode('PRODUCT_PURCHASE_CANCEL'));
	}

	/**
	 * Show all my orders
	 *
	 * @return tempcode	The interface.
	*/
	function my_orders()
	{
		$title		=	get_page_title('MY_ORDERS');

		$member_id	=	get_member();

		if (has_specific_permission(get_member(),'assume_any_member')) $member_id=get_param_integer('id',$member_id);

		$orders	=	array();

		$rows		=	$GLOBALS['SITE_DB']->query_select('shopping_order',array('*'),array('c_member'=>$member_id));

		foreach ($rows as $row)
		{
			$order_title	=	$row['product_name'];
			$order_det_url	=	build_url(array('page'=>'_SELF','type'=>'order_det','id'=>$row['id']),'_SELF');

			$orders[]=array('ORDER_TITLE'=>$order_title,'ID'=>strval($row['id']),'AMOUNT'=>strval($row['tot_price']),'TIME'=>get_timezoned_date($row['add_date'],true,false,true,true),'STATE'=>do_lang_tempcode($row['order_status']),'NOTE'=>'','ORDER_DET_URL'=>$order_det_url,'DELIVERABLE'=>'');
		}

		if (count($orders)==0) inform_exit(do_lang_tempcode('NO_ENTRIES'));

		return do_template('ECOM_ORDERS_SCREEN',array('TITLE'=>$title,'CURRENCY'=>get_option('currency'),'ORDERS'=>$orders));
	}

	/**
	 * Show an order details
	 *
	 * @return tempcode	The interface.
	 */
	function order_det()
	{
		$id=get_param_integer('id');

		$title		=	get_page_title('_MY_ORDER_DETAILS',true,array($id));

		$products	=	array();

		$order_title	=	do_lang('CART_ORDER',$id);

		$rows		=	$GLOBALS['SITE_DB']->query_select('shopping_order_details',array('*'),array('order_id'=>$id));

		breadcrumb_set_parents(array(array('_SELF:orders:misc',do_lang_tempcode('MY_ORDERS'))));

		foreach ($rows as $row)
		{
			$product_info_url	=	build_url(array('page'=>'catalogues','type'=>'entry','id'=>$row['p_id']),get_module_zone('catalogues'));

			$product_name	=	$row['p_name'];

			$quantity	=	$row['p_quantity'];

			$products[]	=	array('PRODUCT_NAME'=>$row['p_name'],'ID'=>strval($row['p_id']),'AMOUNT'=>strval($row['p_price']),'QUANTITY'=>strval($row['p_quantity']),'DESPATCH_STATUS'=>do_lang_tempcode($row['dispatch_status']),'PRODUCT_DET_URL'=>$product_info_url,'DELIVERABLE'=>'');
		}

		if (count($products)==0) inform_exit(do_lang_tempcode('NO_ENTRIES'));

		return do_template('ECOM_ORDERS_DETAILS_SCREEN',array('TITLE'=>$title,'CURRENCY'=>get_option('currency'),'PRODUCTS'=>$products));
	}

	/**
	 * Show market place fee button for amazon payments
	 *
	 * @return tempcode	The interface.
	 */
	function show_market_place_fee_button()
	{
		if(get_ocp_cpf('recipient_email',get_member())=='')
		{
			$title		=	get_page_title('CREATE_MARKET_PLACE_ACCOUNT');
			require_code('amazon_payment/FPSApis/src/Amazon/FPS/ocp_amazon/payment_amazon');
			$text			=	do_lang_tempcode('CREATE_MARKET_PLACE_ACCOUNT_TEXT');
			$fee_button_form	=	payment_amazon::AcceptMarketplaceFeeButtonForm();
			return do_template('AMAZON_MP_FEE_BUTOON',array('TITLE'=>$title,'MP_BUTTON_FORM'=>$fee_button_form,'DESC'=>$text));
		}
		else
		{
			$rec_email	=	get_ocp_cpf('recipient_email',get_member());
			$rec_token	=	get_ocp_cpf('recipient_tocken_id',get_member());
			$text			=	do_lang_tempcode('SHOW_MARKET_PLACE_ACCOUNT_TEXT');
			$title	=	get_page_title('SHOW_MARKET_PLACE_ACCOUNT');
			return do_template('AMAZON_MP_FEE_BUTOON',array('TITLE'=>$title,'MP_BUTTON_FORM'=>'','DESC'=>$text,'RECIPIENT_EMAIL'=>$rec_email,'RECIPIENT_TOKEN'=>$rec_token));
		}
	}

	/**
	 * Market place fee process return
	 *
	 * @return tempcode	The interface.
	 */
	function market_place_return()
	{
		$ocp_recipient_email_field		=	get_cpfid('ocp_recipient_email');
		$recipient_email					=	get_param('recipientEmail');

		$recipient_tocken_id_field		=	get_cpfid('ocp_recipient_tocken_id');
		$recipient_tocken_id				=	get_param('tokenID');

		//Update cpf field with returned recipient email
		$GLOBALS['SITE_DB']->query_update('f_member_custom_fields',array($ocp_recipient_email_field=>$recipient_email,$recipient_tocken_id_field=>$recipient_tocken_id),array('mf_member_id'=>get_member()));

		$profile_url	=	build_url(array('page'=>'members','type'=>'view','id'=>get_member()),'_SELF');
		return redirect_screen(get_page_title('MARKET_PLACE_ACCOUNT_CREATED'),$profile_url,do_lang_tempcode('MARKET_PLACE_ACCOUNT_CREATED'));
	}
}