<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		ecommerce
 */

class Module_purchase
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']='Chris Graham';
		$info['organisation']='ocProducts';
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=4;
		$info['locked']=false;
		$info['update_require_upgrade']=1;
		return $info;
	}

	/**
	 * Standard modular uninstall function.
	 */
	function uninstall()
	{
		$GLOBALS['SITE_DB']->drop_if_exists('transactions');
		$GLOBALS['SITE_DB']->drop_if_exists('trans_expecting');
		delete_config_option('currency');
		delete_config_option('ecommerce_test_mode');
		delete_config_option('ipn_password');
		delete_config_option('vpn_password');
		delete_config_option('vpn_username');
		delete_config_option('ipn_digest');
		delete_config_option('use_local_payment');
		delete_config_option('pd_address');
		delete_config_option('pd_email');
		delete_config_option('pd_number');
		delete_config_option('callback_password');
		delete_specific_permission('access_ecommerce_in_test_mode');

		delete_menu_item_simple('_SELF:purchase:type=misc');
		delete_menu_item_simple('_SELF:invoices:type=misc');
		delete_menu_item_simple('_SEARCH:purchase:type=misc');
		delete_menu_item_simple('_SEARCH:invoices:type=misc');
		delete_menu_item_simple('_SEARCH:subscriptions:type=misc');

		delete_config_option('sub_one_time_fee');
		delete_config_option('sub_recurring_fee');
		delete_config_option('enable_member_payments');

		delete_config_option('enable_third_party_sales');
		delete_config_option('fixed_mp_fee');
		delete_config_option('variable_mp_fee');
		delete_config_option('amazon_fixed_mp_fee');
		delete_config_option('amazon_variable_mp_fee');

		delete_config_option('enable_member_subscription_start_date');

		delete_config_option('paypal_transaction_flat_cost');
		delete_config_option('paypal_transaction_percentage_cost');
		delete_config_option('authorize_transaction_flat_cost');
		delete_config_option('authorize_transaction_percentage_cost');
		delete_config_option('secpay_transaction_flat_cost');
		delete_config_option('secpay_transaction_percentage_cost');

		$_hooks = find_all_hooks('systems','ecommerce_via');
		foreach (array_keys($_hooks) as $hook)
		{
			require_code('hooks/systems/ecommerce_via/'.filter_naughty_harsh($hook));
			echo 'Hook_'.$hook;
			$payment_object = object_factory('Hook_'.$hook);
			if(method_exists($payment_object,'uninstall_config'))	$payment_object->uninstall_config();
		}
	}

	/**
	 * Standard modular install function.
	 *
	 * @param  ?integer	What version we're upgrading from (NULL: new install)
	 * @param  ?integer	What hack version we're upgrading from (NULL: new-install/not-upgrading-from-a-hacked-version)
	 */
	function install($upgrade_from=NULL,$upgrade_from_hack=NULL)
	{
		if ((!is_null($upgrade_from)) && ($upgrade_from<3))
		{
			$GLOBALS['SITE_DB']->alter_table_field('transactions','currency','ID_TEXT','t_currency');
		}

		if ((!is_null($upgrade_from)) && ($upgrade_from<4))
		{
			$GLOBALS['SITE_DB']->add_table_field('transactions','t_via','ID_TEXT','paypal');
		}

		if ((is_null($upgrade_from)) || ($upgrade_from<4))
		{
			add_config_option('ENABLE_MEMBER_PAYMENTS','enable_member_payments','tick','return \'0\';','ECOMMERCE','ECOMMERCE');
			add_config_option('USE_LOCAL_PAYMENT','use_local_payment','tick','return \'0\';','ECOMMERCE','PAYMENT_GATEWAY');
			add_config_option('IPN_PASSWORD','ipn_password','line','return \'\';','ECOMMERCE','ECOMMERCE'); // SecPay test account: 'secpay'/'secpay'
			add_config_option('IPN_DIGEST','ipn_digest','line','return \'\';','ECOMMERCE','ECOMMERCE');
			add_config_option('VPN_USERNAME','vpn_username','line','return \'\';','ECOMMERCE','ECOMMERCE'); // SecPay: not needed
			add_config_option('VPN_PASSWORD','vpn_password','line','return \'\';','ECOMMERCE','ECOMMERCE'); // SecPay test account: 'secpay'/'secpay'
			add_config_option('POSTAL_ADDRESS','pd_address','text','return \'\';','ECOMMERCE','ECOMMERCE'); // SecPay: not needed
			add_config_option('EMAIL_ADDRESS','pd_email','line','return get_option(\'staff_address\');','ECOMMERCE','ECOMMERCE'); // SecPay: not needed
			add_config_option('PHONE_NUMBER','pd_number','line','return \'\';','ECOMMERCE','ECOMMERCE'); // SecPay: not needed
			add_config_option('ENABLE_MEMBER_SUBSCRIPTION_START_DATE','enable_member_subscription_start_date','tick','return \'0\';','ECOMMERCE','ECOMMERCE');
			add_config_option('PAYPAL_TRANSACTION_FLAT_COST','paypal_transaction_flat_cost','line','return \'0.25\';','ECOMMERCE','PAYMENT_GATEWAY');
			add_config_option('PAYPAL_TRANSACTION_PERCENTAGE_COST','paypal_transaction_percentage_cost','line','return \'0.034\';','ECOMMERCE','PAYMENT_GATEWAY');
			add_config_option('AUTHORIZE_TRANSACTION_FLAT_COST','authorize_transaction_flat_cost','line','return \'0.30\';','ECOMMERCE','PAYMENT_GATEWAY');
			add_config_option('AUTHORIZE_TRANSACTION_PERCENTAGE_COST','authorize_transaction_percentage_cost','line','return \'0.0212\';','ECOMMERCE','PAYMENT_GATEWAY');
			add_config_option('SECPAY_TRANSACTION_FLAT_COST','secpay_transaction_flat_cost','line','return \'0.39\';','ECOMMERCE','PAYMENT_GATEWAY');
			add_config_option('SECPAY_TRANSACTION_PERCENTAGE_COST','secpay_transaction_percentage_cost','line','return \'0\';','ECOMMERCE','PAYMENT_GATEWAY');
			add_specific_permission('ECOMMERCE','access_ecommerce_in_test_mode',false);

			$GLOBALS['SITE_DB']->create_table('trans_expecting',array( // Used by payment gateways that return limited information back via IPN
				'id'=>'*ID_TEXT',
				'e_purchase_id'=>'ID_TEXT',
				'e_item_name'=>'SHORT_TEXT',
				'e_member_id'=>'USER',
				'e_amount'=>'SHORT_TEXT',
				'e_ip_address'=>'IP',
				'e_session_id'=>'INTEGER',
				'e_time'=>'TIME',
				'e_length'=>'?INTEGER',
				'e_length_units'=>'ID_TEXT',
			));

			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('pays_sales_tax',1);

			//Store credit card details or not?
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('credit_card_store_det',1);
			//Credit card cpfs
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('credit_card_firstname',20,1,1,1,0,'','line');
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('credit_card_lastname',20,1,1,1,0,'','line');
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('credit_card_number',20,0,1,1,0,'','short_text');
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('credit_card_expiry_date',20,1,1,1,0,'','short_text');
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('credit_card_security_code',20,1,1,1,0,'','line');

			//Card address fields
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('credit_card_address',20,1,1,1,0,'','line');
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('credit_card_country',20,1,1,1,0,'','short_text');
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('credit_card_state',20,1,1,1,0,'','state');
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('credit_card_city',20,1,1,1,0,'','city');
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('credit_card_post_code',20,1,1,1,0,'','zipcode');

			//Shipping address fields
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('shipping_street',20,0,0,0,0,'','line');
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('shipping_country',20,0,0,0,0,'','line');
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('shipping_state',20,0,0,0,0,'','line');
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('shipping_city',20,0,0,0,0,'','line');
			$GLOBALS['FORUM_DRIVER']->install_create_custom_field('shipping_zip',20,0,0,0,0,'','line');


			require_lang('ecommerce');
			add_menu_item_simple('pc_features',NULL,'INVOICES','_SELF:invoices:type=misc',0,0,true,do_lang('ZONE_BETWEEN'));
			add_menu_item_simple('pc_features',NULL,'MODULE_TRANS_NAME_subscriptions','_SELF:subscriptions:type=misc',0,0,true,do_lang('ZONE_BETWEEN'));
			add_menu_item_simple('ecommerce_features',NULL,'PURCHASING','_SEARCH:purchase:type=misc');
			add_menu_item_simple('ecommerce_features',NULL,'INVOICES','_SEARCH:invoices:type=misc');
			add_menu_item_simple('ecommerce_features',NULL,'SUBSCRIPTIONS','_SEARCH:subscriptions:type=misc');
		}

		if ((is_null($upgrade_from)) || ($upgrade_from<3))
		{
			add_config_option('CURRENCY','currency','line','return \'GBP\';','ECOMMERCE','ECOMMERCE');
			add_config_option('ECOMMERCE_TEST_MODE','ecommerce_test_mode','tick','return \'0\';','ECOMMERCE','PAYMENT_GATEWAY');

			//Subscription fee
			add_config_option('SUBSCRIPTION_ONE_TIME_FEE','sub_one_time_fee','line','return \'0\';','ECOMMERCE','ECOMMERCE');
			add_config_option('SUBSCRIPTION_RECURRING_TIME_FEE','sub_recurring_fee','line','return \'0\';','ECOMMERCE','ECOMMERCE');

			//add_config_option('ENABLE_THIRD_PARTY_SALES','enable_third_party_sales','special_group__tick_control__third_party__tick','return \'0\';','ECOMMERCE','ECOMMERCE');
			//add_config_option('MP_FIXED_FEE','amazon_fixed_mp_fee','special_group__tick_control__third_party__line','return \'0\';','ECOMMERCE','ECOMMERCE');
			//add_config_option('MP_VARIABLE_FEE','amazon_variable_mp_fee','special_group__tick_control__third_party__line','return \'0\';','ECOMMERCE','ECOMMERCE');
		}

		if (is_null($upgrade_from))
		{
			$GLOBALS['SITE_DB']->create_table('transactions',array(
				'id'=>'*ID_TEXT',
				'purchase_id'=>'ID_TEXT',
				'status'=>'SHORT_TEXT',
				'reason'=>'SHORT_TEXT',
				'amount'=>'SHORT_TEXT',
				't_currency'=>'ID_TEXT',
				'linked'=>'ID_TEXT',
				't_time'=>'*TIME',
				'item'=>'SHORT_TEXT',
				'pending_reason'=>'SHORT_TEXT',
				't_memo'=>'LONG_TEXT',
				't_via'=>'ID_TEXT',
				'to_member_id'=>'?USER'
			));
		}

		$_hooks = find_all_hooks('systems','ecommerce_via');
		foreach (array_keys($_hooks) as $hook)
		{
			require_code('hooks/systems/ecommerce_via/'.filter_naughty_harsh($hook));
			$payment_object = object_factory('Hook_'.$hook);
			if(method_exists($payment_object,'install_config')) $payment_object->install_config($upgrade_from,$upgrade_from_hack);
		}
	}

	/**
	 * Standard modular entry-point finder function.
	 *
	 * @return ?array	A map of entry points (type-code=>language-code) (NULL: disabled).
	 */
	function get_entry_points()
	{
		return array('misc'=>'PURCHASING');
	}

	/**
	 * Standard modular run function.
	 *
	 * @return tempcode	The result of execution.
	 */
	function run()
	{
		require_lang('ecommerce');
		require_code('ecommerce');
		require_lang('config');
		require_css('ecommerce');

		// Kill switch
		//if ((ecommerce_test_mode()) && (!$GLOBALS['IS_ACTUALLY_ADMIN']) && (!has_specific_permission(get_member(),'access_ecommerce_in_test_mode'))) warn_exit(do_lang_tempcode('PURCHASE_DISABLED'));

		$type=get_param('type','misc');

		$title=get_page_title('PURCHASING_TITLE',true,array(do_lang_tempcode('PURCHASE_STAGE_'.$type)));

		$tpl=new ocp_tempcode();
		if ($type=='misc') $tpl=$this->choose($title);
		if ($type=='message') $tpl=$this->message($title);
		if ($type=='licence') $tpl=$this->licence($title);
		if ($type=='details') $tpl=$this->details($title);
		if ($type=='pay') $tpl=$this->pay($title);
		if ($type=='finish') $tpl=$this->finish($title);
		if($type=='payment_note')$tpl=$this->show_payment_gateway_notes($title);
		if ($type=='upgrade_account') $tpl=$this->upgrade_account($title);		
		return $tpl;
	}

	/**
	 * Only allow logged in members to here.
	 */
	function ensure_in()
	{
		if (is_guest())
		{
			attach_message(do_lang_tempcode('PURCHASE_NOT_LOGGED_IN'),'warn');

			access_denied('NOT_AS_GUEST');
		}
	}

	/**
	 * Wrap-up so as to remove redundancy in templates.
	 *
	 * @param  tempcode	To wrap.
	 * @param  tempcode	The title to use.
	 * @param  ?mixed		URL (NULL: no next URL).
	 * @param  boolean	Whether it is a GET form
	 * @return tempcode	Wrapped.
	 */
	function wrap($content,$title,$url,$get=false,$login_needed=NULL)
	{
		if (is_null($url)) $url='';
		require_javascript('javascript_validation');
		return do_template('PURCHASE_WIZARD_SCREEN',array('_GUID'=>'a32c99acc28e8ad05fd9b5e2f2cda029','GET'=>$get?true:NULL,'TITLE'=>$title,'CONTENT'=>$content,'URL'=>$url,'NO_PROCEED'=>$login_needed));
	}

	/**
	 * Choose product step.
	 *
	 * @param  tempcode	The page title.
	 * @return tempcode	The result of execution.
	 */
	function choose($title)
	{
		breadcrumb_set_self(do_lang_tempcode('PURCHASING'));

		/*if (is_guest())
		{
			$register=$GLOBALS['FORUM_DRIVER']->join_link();
			if (is_object($register)) $register=$register->evaluate();
			$_redirect=build_url(array('page'=>'_SELF','type'=>'misc'),'_SELF');
			$redirect=$_redirect->evaluate();
			$_login=build_url(array('page'=>'login','redirect'=>$redirect));
			$login=$_login->evaluate();
			return $this->wrap(do_template('PURCHASE_WIZARD_STAGE_GUEST',array('_GUID'=>'accf475a1457f73d7280b14d774acc6e','TITLE'=>$title,'TEXT'=>do_lang_tempcode('PURCHASE_NOT_LOGGED_IN_2',escape_html($register),escape_html($login)))),$title,NULL);
		}*/

		$url=build_url(array('page'=>'_SELF','type'=>'message','id'=>get_param('id','-1')),'_SELF',NULL,true,true);

		require_code('form_templates');

		$list=new ocp_tempcode();
		$filter=get_param('filter','');
		$products=find_all_products();

		foreach ($products as $product=>$details)
		{
			$product_id	=	$details[3]['id'];

			if ($filter!='')
			{
				if ((!is_string($product)) || (substr($product,0,strlen($filter))!=$filter)) continue;
			}

			$is_available	=	(method_exists($details[count($details)-1],'is_available')  && (($details[count($details)-1]->is_available($product_id,get_member())==AVAILABLE_YES) || ($details[count($details)-1]->is_available($product_id,get_member())==AVAILABLE_IF_WAS_LOGGED_IN && !is_guest())))?true:false;

			if ((($details[0]==PRODUCT_PURCHASE_WIZARD) || ($details[0]==PRODUCT_SUBSCRIPTION) || ($details[0]==PRODUCT_CATALOGUE) || ($details[0]==PRODUCT_PERMISSIONS) || ($details[0]==PRODUCT_GIFT_VOUCHER)) && $is_available)
			{
				require_code('currency');
				$currency=get_option('currency');
				$price=$details[1].$currency;//currency_convert(floatval($details[1]),$currency,NULL,true);

				$description=$details[4];
				if (strpos($details[4],(strpos($details[4],'.')===false)?preg_replace('#\.00($|[^\d])#','',$price):$price)===false)
					$description.=(' ('.$price.')');

				$list->attach(form_input_list_entry($product,false,protect_from_escaping($description)));
			}
		}
		if ($list->is_empty()) inform_exit(do_lang_tempcode('NO_CATEGORIES'));
		$fields=form_input_list(do_lang_tempcode('PRODUCT'),'','product',$list,NULL,true);

		return $this->wrap(do_template('PURCHASE_WIZARD_STAGE_CHOOSE',array('_GUID'=>'47c22d48313ff50e6323f05a78342eae','FIELDS'=>$fields,'TITLE'=>$title)),$title,$url,true);
	}

	/**
	 * Message about product step.
	 *
	 * @param  tempcode	The page title.
	 * @return tempcode	The result of execution.
	 */
	function message($title)
	{
//		$this->ensure_in();

		require_code('form_templates');

		$text=new ocp_tempcode();
		$object=find_product(get_param('product'));
		if (is_null($object))	warn_exit(do_lang_tempcode('MISSING_RESOURCE'));

		$product_id	=	$object->product_id[3]['id'];

		if (method_exists($object,'is_available'))
		{
			if($object->is_available($product_id,get_member())==AVAILABLE_NO)
				warn_exit(do_lang_tempcode('PRODUCT_UNAVAILABLE'));
			elseif($object->is_available($product_id,get_member())==AVAILABLE_IF_WAS_LOGGED_IN && is_guest())
			{
				$self_url=build_url(array('page'=>'_SELF','type'=>'message','product'=>get_param('product')),'_SELF');
				$self_url=$self_url->evaluate();
				$login_url=find_script('snippet').'?snippet=overlay_login&redirect='.urlencode($self_url).'&iframe=false&width=700&height=400';
				$join_url=find_script('snippet').'?snippet=overlay_signup&redirect='.urlencode($self_url).'&iframe=true&width=700&height=400&redirect='.$self_url;
				return do_lang_tempcode('NOT_AS_GUEST',$login_url,$join_url);
			}
		}

		if(method_exists($object,'product_info'))
			return $object->product_info($product_id,$title);
		else
			$text->attach(paragraph($object->get_message($product_id)));

		$licence	=	method_exists($object,'get_agreement')?$object->get_agreement($product_id):'';
		$fields	=	method_exists($object,'get_needed_fields')?$object->get_needed_fields($product_id):NULL;
		if (is_object($fields) && $fields->is_empty()) $fields=NULL;

		$url=build_url(array('page'=>'_SELF','type'=>($licence=='')?(is_null($fields)?'pay':'details'):'licence','product'=>get_param('product'),'id'=>get_param('id','-1')),'_SELF',NULL,true);

		if(is_guest() && method_exists($object,'required_login') && $object->required_login())
			$login_needed	=	true;
		else
			$login_needed	=	false;

		$url=build_url(array('page'=>'_SELF','type'=>($licence=='')?(is_null($fields)?'pay':'details'):'licence','product'=>get_param('product'),'id'=>get_param('id','-1')),'_SELF',NULL,true);

		breadcrumb_set_parents(array(array('_SELF:_SELF:misc',do_lang_tempcode('PURCHASING'))));

		return $this->wrap(do_template('PURCHASE_WIZARD_STAGE_MESSAGE',array('_GUID'=>'8667b6b544c4cea645a52bb4d087f816','TITLE'=>'','TEXT'=>$text)),$title,$url,false,($login_needed)?$login_needed:NULL);
	}

	/**
	 * Licence agreement step.
	 *
	 * @param  tempcode	The page title.
	 * @return tempcode	The result of execution.
	 */
	function licence($title)
	{
//		$this->ensure_in();

		require_lang('installer');

		require_code('form_templates');

		$object=find_product(get_param('product'));
		if (method_exists($object,'is_available'))
		{
			if($object->is_available(get_param('product'),get_member())==AVAILABLE_NO)
				warn_exit(do_lang_tempcode('PRODUCT_UNAVAILABLE'));
			elseif($object->is_available(get_param('product'),get_member())==AVAILABLE_IF_WAS_LOGGED_IN && is_guest())
				warn_exit(do_lang_tempcode('NOT_AS_GUEST'));
		}
		$licence=$object->get_agreement(get_param('product'));
		$fields=$object->get_needed_fields(get_param('product'));
		if ((!is_null($fields)) && ($fields->is_empty())) $fields=NULL;
		$url=build_url(array('page'=>'_SELF','type'=>is_null($fields)?'pay':'details','product'=>get_param('product'),'id'=>get_param('id','-1')),'_SELF',NULL,true,true);

		breadcrumb_set_parents(array(array('_SELF:_SELF:misc',do_lang_tempcode('PURCHASING'))));

		return $this->wrap(do_template('PURCHASE_WIZARD_STAGE_LICENCE',array('_GUID'=>'55c7bc550bb327535db1aebdac9d85f2','TITLE'=>$title,'URL'=>$url,'LICENCE'=>$licence)),$title,NULL);
	}

	/**
	 * Details about purchase step.
	 *
	 * @param  tempcode	The page title.
	 * @return tempcode	The result of execution.
	 */
	function details($title)
	{
		require_code('form_templates');

		$object=find_product(get_param('product'));
		if (method_exists($object,'is_available'))
		{
			if($object->is_available(get_param('product'),get_member())==AVAILABLE_NO)
				warn_exit(do_lang_tempcode('PRODUCT_UNAVAILABLE'));
			elseif($object->is_available(get_param('product'),get_member())==AVAILABLE_IF_WAS_LOGGED_IN && is_guest())
				warn_exit(do_lang_tempcode('NOT_AS_GUEST'));
		}
		$fields=$object->get_needed_fields(get_param('product'),get_param('id','-1'));
		$url=build_url(array('page'=>'_SELF','type'=>'pay','product'=>get_param('product')),'_SELF',NULL,true);

		breadcrumb_set_parents(array(array('_SELF:_SELF:misc',do_lang_tempcode('PURCHASING'))));

		return $this->wrap(do_template('PURCHASE_WIZARD_STAGE_DETAILS',array('_GUID'=>'7fcbb0be5e90e52163bfec01f22f4ea0','TEXT'=>is_array($fields)?$fields[1]:'','FIELDS'=>is_array($fields)?$fields[0]:$fields)),$title,$url);
	}

	/**
	 * Payment step.
	 *
	 * @param  tempcode	The page title.
	 * @param  ARRAY 		Submitted data
	 * @return tempcode	The result of execution.
	 */
	function pay($title)
	{
		require_lang('gift_voucher');
		$payment_gateway	= post_param('payment_gateway','');
		$product				= get_param('product');

		if(!is_null(post_param('claim_voucher',NULL)))
		{
			require_code('gift_vouchers');
			process_gift_voucher();
		}

		$object	=	find_product($product);

		if(!is_object($object))	warn_exit(do_lang_tempcode('PRODUCT_UNAVAILABLE_FOR_SALE'));

		$product_det	=	$object->product_id;

		$price		=	$product_det[1];
		$item_name	=	$product_det[4];
		$product_id	=	$product_det[3]['id'];

		if (method_exists($object,'is_available'))
		{
			if($object->is_available($product_id,get_member())==AVAILABLE_NO)
				warn_exit(do_lang_tempcode('PRODUCT_UNAVAILABLE'));
			elseif($object->is_available($product_id,get_member())==AVAILABLE_IF_WAS_LOGGED_IN && is_guest())
			{
				$self_url=build_url(array('page'=>'_SELF','type'=>'pay','product'=>$product),'_SELF');
				$self_url=$self_url->evaluate();
				$login_url=find_script('snippet').'?snippet=overlay_login&redirect='.urlencode($self_url).'&iframe=false&width=700&height=400';
				$join_url=find_script('snippet').'?snippet=overlay_signup&redirect='.urlencode($self_url).'&iframe=true&width=700&height=400&redirect='.$self_url;
				return do_lang_tempcode('NOT_AS_GUEST',$login_url,$join_url);
			}
		}

		//Show enabled payment gateways
		if(perform_local_payment() && $payment_gateway=='')
		{
			$transaction_button = make_transaction_button($product);
			$result = do_template('PURCHASE_WIZARD_STAGE_PAYMENT_GATEWAYS',array('CONTENT'=>$transaction_button));

			return $this->wrap($result,$title,NULL);
		}



		$product_det	=	$object->product_id;

		$price		=	$product_det[1];
		$item_name	=	$product_det[4];
		$product_id	=	$product_det[3]['id'];

		if (method_exists($object,'set_needed_fields'))
		{
			$_purchase_id	=	$object->set_needed_fields($product_id,$product_det);
			$purchase_id	=	is_null($_purchase_id)?'':strval($_purchase_id);
		} else
		{
			$purchase_id=strval(get_member());
		}

		if ($product_det[0]==PRODUCT_SUBSCRIPTION)
		{
			$GLOBALS['SITE_DB']->query_delete('subscriptions',array(
				's_type_code'=>$product,
				's_member_id'=>get_member(),
				's_state'=>'new'
			));

			$purchase_id=strval($GLOBALS['SITE_DB']->query_insert('subscriptions',array(
				's_type_code'=>$product,
				's_member_id'=>get_member(),
				's_state'=>'new',
				's_amount'=>$product_det[1],
				's_special'=>$purchase_id,
				's_time'=>time(),
				's_auto_fund_source'=>'',
				's_auto_fund_key'=>'',
				's_via'=>$payment_gateway, //payment gatway cannot set this time as we are displaying multiple payment options below
				'locally_controlled'=>0,
				's_start'=>time()
			),true));

			$length			=	array_key_exists('length',$product_det[3])?$product_det[3]['length']:1;
			$length_units	=	array_key_exists('length_units',$product_det[3])?$product_det[3]['length_units']:'m';
		} else
		{
			$length=NULL;
			$length_units='';
		}

		breadcrumb_set_parents(array(array('_SELF:_SELF:misc',do_lang_tempcode('PURCHASING'))));

		if ($price=='0')	do_free_purchase($purchase_id,$product);

		if (!array_key_exists(4,$product_det)) $item_name=do_lang('CUSTOM_PRODUCT_'.$product,NULL,NULL,NULL,get_lang());

		if (!perform_local_payment()) // Pass through to the gateway's HTTP server
		{
			$adjusted_price=0;
			if ($product_det[0]==PRODUCT_SUBSCRIPTION)
			{
				$transaction_button=make_subscription_button($product,$item_name,$purchase_id,floatval($price),$length,$length_units,get_option('currency'));
			} else
			{
				// If the member have any credit in table
				$member_id=method_exists($object,'member_for')?$object->member_for($purchase_id):$GLOBALS['FORUM_DRIVER']->get_guest_id();

				$credit_points=($member_id==$GLOBALS['FORUM_DRIVER']->get_guest_id())?0:$GLOBALS['SITE_DB']->query_value('ecommerce_credits','SUM(number_credits)',array('member_id'=>$member_id));

				$adjusted_price=float_to_raw_string(max(0.0,floatval($price)-$credit_points));

				if($adjusted_price<=0)	return	do_free_purchase($purchase_id,$product,floatval($price),$member_id);

				$seller	=	(method_exists($object,'get_seller'))?$object->get_seller($product_id):NULL;

				$transaction_button=make_transaction_button($product,$item_name,$purchase_id,floatval($adjusted_price),get_option('currency'),NULL,$seller);
			}
			$tpl=($product_det[0]==PRODUCT_SUBSCRIPTION)?'PURCHASE_WIZARD_STAGE_SUBSCRIBE':'PURCHASE_WIZARD_STAGE_PAY';
			$logos=method_exists($object,'get_logos')?$object->get_logos():new ocp_tempcode();
			$result=do_template($tpl,array('LOGOS'=>$logos,'TRANSACTION_BUTTON'=>$transaction_button,'CURRENCY'=>get_option('currency'),'ITEM_NAME'=>$item_name,'TITLE'=>$title,'LENGTH'=>is_null($length)?'':strval($length),'LENGTH_UNITS'=>$length_units,'PURCHASE_ID'=>$purchase_id,'PRICE'=>float_to_raw_string(floatval($price)),'ADJUSTED_PRICE'=>float_to_raw_string(floatval($adjusted_price))));
		} else // Handle the transaction internally
		{
			if (((ocp_srv('HTTPS')=='') || (ocp_srv('HTTPS')=='off')) && (!ecommerce_test_mode()))
			{
				warn_exit(do_lang_tempcode('NO_SSL_SETUP'));
			}

			require_code('hooks/systems/ecommerce_via/'.filter_naughty_harsh($payment_gateway));
			$object_payment=object_factory('Hook_'.$payment_gateway);

			list($fields,$hidden,$verified_account_logo)=$object_payment->get_transaction_form_fields(NULL,$purchase_id,$product,float_to_raw_string($price),($product_det[0]==PRODUCT_SUBSCRIPTION)?intval($length):NULL,($product_det[0]==PRODUCT_SUBSCRIPTION)?$length_units:'');

			$finish_url=build_url(array('page'=>'_SELF','type'=>'finish','product'=>$product,'redirect'=>get_param('redirect',NULL)),'_SELF');

			$result=do_template('PURCHASE_WIZARD_STAGE_TRANSACT',array('_GUID'=>'15cbba9733f6ff8610968418d8ab527e','ERROR_MSG'=>'','FIELDS'=>$fields,'VERIFIED_ACCOUNT_LOGO'=>$verified_account_logo,'HIDDEN'=>$hidden));
			return $this->wrap($result,$title,$finish_url);
		}

		return $this->wrap($result,$title,NULL);
	}

	/**
	 * Finish step.
	 *
	 * @param  tempcode	The page title.
	 * @return tempcode	The result of execution.
	 */
	function finish($title)
	{
		breadcrumb_set_parents(array(array('_SELF:_SELF:misc',do_lang_tempcode('PURCHASING'))));
		$message=get_param('message',NULL,true);

		if (perform_local_payment()) // We need to try and run the transaction
		{
			$product=get_param('product');
			$object = find_product($product);
			$product_det =	$object->product_id;
			$is_subscription = ($product_det[0]==PRODUCT_SUBSCRIPTION) ? true : false;
			$payment_gateway = post_param('payment_gateway');
			require_code('hooks/systems/ecommerce_via/'.filter_naughty_harsh($payment_gateway));
			$payment_object=object_factory('Hook_'.$payment_gateway);

			$trans_id=post_param('trans_id');
			$transaction_rows=$GLOBALS['SITE_DB']->query_select('trans_expecting',array('*'),array('id'=>$trans_id),'',1);
			if (!array_key_exists(0,$transaction_rows)) warn_exit(do_lang_tempcode('MISSING_RESOURCE'));
			$transaction_row=$transaction_rows[0];
			$amount=$transaction_row['e_amount'];

			$first_name			   =	post_param('first_name');
			$last_name			   =	post_param('last_name');
			$card_number		   =	post_param('card_number');
			$expiry_date		   =	post_param('expiry_date_year').'/'.post_param('expiry_date_month');
			$issue_number		   =	post_param_integer('issue_number',NULL);
			$start_month         =  post_param('start_date_month',date('n'));
			$start_day           =  post_param('start_date_day',date('j'));
			$start_year          =  post_param('start_date_year',date('Y'));
			$start_date			   =	$start_year.'-'.str_pad($start_month,2,'0',STR_PAD_LEFT).'-'.str_pad($start_day,2,'0',STR_PAD_LEFT);
			$card_type			   =	post_param('card_type','');
			$cv2					   =	post_param('cv2',NULL);
			$address1			   =	post_param('address1');
			$city					   =	post_param('city');
			$state				   =	post_param('state','');
			$zip					   =	post_param('zip');
			$country				   =	post_param('country','');
			$shipping_first_name	=	post_param('ship_first_name','');
			$shipping_last_name	=	post_param('ship_last_name','');
			$shipping_street	   =	post_param('ship_addr_1','');
			$shipping_city		   =	post_param('ship_city','');
			$shipping_state	   =	post_param('ship_state','');
			$shipping_zip		   =	post_param('ship_post_code','');
			$shipping_country	   =	post_param('shipping_country','');

			if($is_subscription)
			{
				$payment_details	=	array(
													'card_number'	=>	$card_number,
													'cv2'				=>	$cv2,
													'card_type'		=>	$card_type,
													'expiry_date'	=>	$expiry_date,
													'first_name'	=>	$first_name,
													'last_name'		=>	$last_name,
													'address'		=>	$address1,
													'city'			=>	$city,
													'state'			=>	$state,
													'zip'				=>	$zip,
													'country'		=>	$country
												);

				if ($start_month && $start_date && $start_year)
				{
					$start_time = mktime(0,0,0,$start_month,$start_day,$start_year);
				}
				else
				{
					$start_time = time();
				}

				$GLOBALS['SITE_DB']->query_update('subscriptions',array('s_start'=>$start_time),array('id'=>intval($transaction_row['e_purchase_id'])));

				list($length,$length_units)	=	do_subscription_method_process($transaction_row,$payment_object,$payment_gateway,$payment_details);
			} else {
				$length = NULL;
				$length_units = NULL;
			}

			$cpfs_to_save		=	array
										(
											'ocp_credit_card_firstname'	=>		$first_name,
											'ocp_credit_card_lastname'		=>		$last_name,
											'ocp_credit_card_number'		=>		$card_number,
											'ocp_credit_card_security_code'=>	$cv2,
											'ocp_credit_card_type'			=>		$card_type,
											'ocp_credit_card_expiry_date'	=>		$expiry_date,
											'ocp_credit_card_address'		=>		$address1,
											'ocp_credit_card_city'			=>		$city,
											'ocp_credit_card_state'			=>		$state,
											'ocp_credit_card_post_code'	=>		$zip,
											'ocp_credit_card_country'		=>		$country,
										);

			if(!is_null(post_param('allow_store_card_det',NULL)))
			{
				set_ocp_cpfs($cpfs_to_save);
			}

			$temp=find_product($product);
			$_product_row=$temp->get_products(true);
			$product_row=$_product_row[$product];

			list($success,$code,$sub_code,$message_raw)=$payment_object->do_transaction($trans_id,$first_name,$last_name,$card_number,$amount,$expiry_date,$issue_number,$start_date,$card_type,$cv2,$length,$length_units,$product_row[4],/*get_member() this should be item owner*/NULL,$address1,$city,$state,$zip,$country);

			if (($success) || (!is_null($length)))
			{
				$status=((!is_null($length)) && (!$success))?'SCancelled':'Completed';
				handle_confirmed_transaction($transaction_row['e_purchase_id'],$transaction_row['e_item_name'],$status,$message_raw,'','',$amount,get_option('currency'),$trans_id,$code,$payment_gateway,is_null($length)?'':strtolower(strval($length).' '.$length_units));
			}

			if ($success)
			{
				$member_id=$transaction_row['e_member_id'];
				if (!is_null($transaction_row['e_member_id']))
				{
					require_code('mail');
					$to_name=$GLOBALS['FORUM_DRIVER']->get_username($member_id);
					$email=$GLOBALS['FORUM_DRIVER']->get_member_email_address($member_id);
					mail_wrap(do_lang('PAYMENT_RECEIVED_SUBJECT'),do_lang('PAYMENT_RECEIVED_BODY',float_format(floatval($amount)),get_option('currency'),get_site_name()),array($email),$to_name);
				}
			}
			else
			{
				$error_message = ($is_subscription) ? $payment_object->get_subscription_error($code,$message_raw) : $payment_object->get_transaction_error($code,$message_raw);
				$title=get_page_title('PURCHASING_TITLE',true,array(do_lang_tempcode('PURCHASE_STAGE_pay')));
				attach_message(do_lang_tempcode('TRANSACTION_ERROR',$error_message),'warn');
				return $this->pay($title);
			}
		}

		if (get_param_integer('cancel',0)==0)
		{
			if (!perform_local_payment())
			{
				handle_transaction_script();
			}

			$product	=	(!is_null(get_param('product',NULL)))?get_param('product'):get_param('paymentReason','');
			if ($product!='')
			{
				$object=find_product($product);

				if (method_exists($object,'get_finish_url'))
				{
					attach_message(do_lang_tempcode('PURCHASE_FINISHED'),'inform');

					if(is_numeric($message)) $message	=	NULL; //Temp setting for authorise.net as it does not returns the values in our desired order/format.
					return redirect_screen($title,$object->get_finish_url($product),$message);
				}

				$redirect=get_param('redirect',NULL);
				if (!is_null($redirect))
				{
					attach_message(do_lang_tempcode('PURCHASE_FINISHED'),'inform');

					return redirect_screen($title,$redirect,$message);
				}
			}

			return $this->wrap(do_template('PURCHASE_WIZARD_STAGE_FINISH',array('_GUID'=>'43f706793719ea893c280604efffacfe','TITLE'=>$title,'MESSAGE'=>$message)),$title,NULL);
		}

		if (!is_null($message))
		{
			return $this->wrap(do_template('PURCHASE_WIZARD_STAGE_FINISH',array('_GUID'=>'859c31e8f0f02a2a46951be698dd22cf','TITLE'=>$title,'MESSAGE'=>$message)),$title,NULL);
		}

		warn_exit(do_lang_tempcode('PRODUCT_PURCHASE_CANCEL'));
	}

	/**
	 * Product info for all ecommerce items
	 *
	 * @param  tempcode	The page title.
	 * @return tempcode	The result of execution.
	*/
	function product_info($title)
	{
		$this->ensure_in();

		require_code('form_templates');

		$text=new ocp_tempcode();

		$object=find_product(get_param('product'));

		if (is_null($object))
			warn_exit(do_lang_tempcode('MISSING_RESOURCE'));

		if (method_exists($object,'is_available'))
		{
			if($object->is_available(get_param('product'),get_member())==AVAILABLE_NO)
				warn_exit(do_lang_tempcode('PRODUCT_UNAVAILABLE'));
			elseif($object->is_available(get_param('product'),get_member())==AVAILABLE_IF_WAS_LOGGED_IN && is_guest())
				warn_exit(do_lang_tempcode('NOT_AS_GUEST'));
		}

		$text->attach(paragraph($object->product_info(get_param('product'))));
		$licence=method_exists($object,'get_agreement')?$object->get_agreement(get_param('product')):'';
		$fields=method_exists($object,'get_needed_fields')?$object->get_needed_fields(get_param('product')):NULL;

		$url=build_url(array('page'=>'_SELF','type'=>($licence=='')?(is_null($fields)?'pay':'details'):'licence','product'=>get_param('product'),'id'=>get_param('id','-1')),'_SELF');

		breadcrumb_set_parents(array(array('_SELF:_SELF:misc',do_lang_tempcode('PURCHASING'))));

		return $this->wrap(do_template('PURCHASE_WIZARD_STAGE_MESSAGE',array('_GUID'=>'8667b6b544c4cea645a52bb4d087f816','TITLE'=>$title,'TEXT'=>$text)),$title,$url);
	}
	/**
	* Show verified merchant popup text
	*
	* @return tempcode.
	*/
	function show_payment_gateway_notes()
	{
		$page		=	get_param('screen');
		$text 	= request_page($page,true,get_comcode_zone($page),NULL,true);
		return do_template('SIGNUP_RULES',array('RULES'=>$text));
	}

	/**
	* Upgrade to pro
	*
	* @param  ID	Member ID
	* @return bool
	*/
	function upgrade_account()
	{
		$via = 'authorize';/*currently subscription through authorize only*/
		require_code('hooks/systems/ecommerce_via/'.filter_naughty_harsh($via));
		$object = object_factory('Hook_'.$via);
		return $object->show_subscription_payment_form(true);
	}
}