<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2008

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		catalogues
 */

class Module_catalogues
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']='Chris Graham';
		$info['organisation']='ocProducts';
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=5;
		$info['update_require_upgrade']=1;
		$info['locked']=false;
		return $info;
	}
	
	/**
	 * Standard modular uninstall function.
	 */
	function uninstall()
	{
		$GLOBALS['SITE_DB']->drop_if_exists('catalogues');
		$GLOBALS['SITE_DB']->drop_if_exists('catalogue_fields');
		$GLOBALS['SITE_DB']->drop_if_exists('catalogue_categories');
		$GLOBALS['SITE_DB']->drop_if_exists('catalogue_entries');
		$GLOBALS['SITE_DB']->drop_if_exists('catalogue_efv_long_trans');
		$GLOBALS['SITE_DB']->drop_if_exists('catalogue_efv_short_trans');
		$GLOBALS['SITE_DB']->drop_if_exists('catalogue_efv_long');
		$GLOBALS['SITE_DB']->drop_if_exists('catalogue_efv_short');
	
		$GLOBALS['SITE_DB']->query_delete('group_category_access',array('module_the_name'=>'catalogues_category'));
		$GLOBALS['SITE_DB']->query_delete('group_category_access',array('module_the_name'=>'catalogues_catalogue'));
	
		$GLOBALS['SITE_DB']->query_delete('trackbacks',array('trackback_for_type'=>'catalogues'));
		
		deldir_contents(get_custom_file_base().'/uploads/catalogues',true);
		
		delete_specific_permission('high_catalogue_entry_timeout');

		delete_menu_item_simple('_SEARCH:catalogues:type=misc');
		delete_menu_item_simple('_SEARCH:catalogues:id=projects:type=index');
		delete_menu_item_simple('_SEARCH:cms_catalogues:catalogue_name=projects:type=add_entry');
	}

	/**
	 * Standard modular install function.
	 *
	 * @param  ?integer	What version we're upgrading from (NULL: new install)
	 * @param  ?integer	What hack version we're upgrading from (NULL: new-install/not-upgrading-from-a-hacked-version)
	 */
	function install($upgrade_from=NULL,$upgrade_from_hack=NULL)
	{
		require_lang('catalogues');
		require_code('catalogues');
		require_code('catalogues2');

		if (is_null($upgrade_from))
		{
			$GLOBALS['SITE_DB']->create_table('catalogues',array(
				'c_name'=>'*ID_TEXT',
				'c_title'=>'SHORT_TRANS',
				'c_description'=>'LONG_TRANS',	// Comcode
				'c_display_type'=>'SHORT_INTEGER', // C_DT_*
				'c_is_tree'=>'BINARY',
				'c_notes'=>'LONG_TEXT',
				'c_add_date'=>'TIME',
				'c_submit_points'=>'INTEGER',
				'c_ecommerce'=>'BINARY',
				'c_send_view_reports'=>'ID_TEXT', // never,daily,weekly,monthly,quarterly
				'c_owner'=>'?USER',
			));
		
			$GLOBALS['SITE_DB']->create_table('catalogue_categories',array(
				'id'=>'*AUTO',
				'c_name'=>'ID_TEXT',
				'cc_title'=>'SHORT_TRANS',
				'cc_description'=>'LONG_TRANS',	// Comcode
				'rep_image'=>'URLPATH',
				'cc_notes'=>'LONG_TEXT',
				'cc_add_date'=>'TIME',
				'cc_parent_id'=>'?AUTO_LINK',
				'cc_move_target'=>'?AUTO_LINK',
				'cc_move_days_lower'=>'INTEGER',
				'cc_move_days_higher'=>'INTEGER',
			));

			$GLOBALS['SITE_DB']->create_table('catalogue_fields',array(
				'id'=>'*AUTO',
				'c_name'=>'ID_TEXT',
				'cf_name'=>'SHORT_TRANS',
				'cf_description'=>'LONG_TRANS',
				'cf_type'=>'ID_TEXT', /* can be short_text,long_text,short_trans,long_trans,integer,float,picture,upload,url,email,user */
				'cf_order'=>'SHORT_INTEGER',
				'cf_defines_order'=>'BINARY',
				'cf_visible'=>'BINARY',
				'cf_searchable'=>'BINARY',
				'cf_default'=>'LONG_TEXT',
				'cf_required'=>'BINARY',
				'cf_put_in_category'=>'BINARY',
				'cf_put_in_search'=>'BINARY',
			));

			$GLOBALS['SITE_DB']->create_table('catalogue_entries',array(
				'id'=>'*AUTO',
				'c_name'=>'ID_TEXT',
				'cc_id'=>'AUTO_LINK',
				'ce_submitter'=>'USER',
				'ce_add_date'=>'TIME',
				'ce_edit_date'=>'?TIME',
				'ce_views'=>'INTEGER',
				'ce_views_prior'=>'INTEGER',
				'ce_validated'=>'BINARY',
				'notes'=>'LONG_TEXT',
				'allow_rating'=>'BINARY',
				'allow_comments'=>'SHORT_INTEGER',
				'allow_trackbacks'=>'BINARY',
				'ce_last_moved'=>'INTEGER',
			));
		
			$GLOBALS['SITE_DB']->create_table('catalogue_efv_long_trans',array(
				'id'=>'*AUTO', // NEVER use this column: cf_id and ce_id also provide a key. This only exists for the SQL-server fulltext indexing. This column doesn't exist on upgraded old installs.
				'cf_id'=>'AUTO_LINK',
				'ce_id'=>'AUTO_LINK',
				'cv_value'=>'LONG_TRANS', /* does your CV have value? */	// often Comcode
			));

			$GLOBALS['SITE_DB']->create_table('catalogue_efv_long',array(
				'id'=>'*AUTO', // NEVER use this column: cf_id and ce_id also provide a key. This only exists for the SQL-server fulltext indexing. This column doesn't exist on upgraded old installs.
				'cf_id'=>'AUTO_LINK',
				'ce_id'=>'AUTO_LINK',
				'cv_value'=>'LONG_TEXT', /* mine does! */
			));

			$GLOBALS['SITE_DB']->create_table('catalogue_efv_short_trans',array(
				'id'=>'*AUTO', // NEVER use this column: cf_id and ce_id also provide a key. This only exists for the SQL-server fulltext indexing. This column doesn't exist on upgraded old installs.
				'cf_id'=>'AUTO_LINK',
				'ce_id'=>'AUTO_LINK',
				'cv_value'=>'SHORT_TRANS', /* mine too! */  // often Comcode
			));

			$GLOBALS['SITE_DB']->create_table('catalogue_efv_short',array(
				'id'=>'*AUTO', // NEVER use this column: cf_id and ce_id also provide a key. This only exists for the SQL-server fulltext indexing. This column doesn't exist on upgraded old installs.
				'cf_id'=>'AUTO_LINK',
				'ce_id'=>'AUTO_LINK',
				'cv_value'=>'SHORT_TEXT', /* so who gets the job? (groan) */
			));

			// Add the default catalogues
			// ==========================
		
			$groups=$GLOBALS['FORUM_DRIVER']->get_usergroup_list();

			// Projects
			actual_add_catalogue('projects',lang_code_to_default_content('DEFAULT_CATALOGUE_PROJECTS_TITLE',false,2),lang_code_to_default_content('DEFAULT_CATALOGUE_PROJECTS_DESCRIPTION',true,3),0,0,'',30);
			$fields=array(
				array('NAME','DESCRIPTION_NAME','short_trans',1,1),
				array('MAINTAINER','DESCRIPTION_MAINTAINER','user',0,1),
				array('DESCRIPTION','DESCRIPTION_DESCRIPTION','long_trans',0,1),
				array('PROJECT_PROGRESS','DESCRIPTION_PROJECT_PROGRESS','integer',0,1)
			);
			foreach ($fields as $i=>$field)
				actual_add_catalogue_field('projects',lang_code_to_default_content($field[0],false,3),lang_code_to_default_content($field[1],true,3),$field[2],$i,$field[3],1,1,'',$field[4]);
			$cat_id=actual_add_catalogue_category('projects',lang_code_to_default_content('DEFAULT_CATALOGUE_PROJECTS_TITLE',false,2),lang_code_to_default_content('DEFAULT_CATALOGUE_PROJECTS_DESCRIPTION',true,3),'',NULL,'');
			foreach (array_keys($groups) as $group_id)
			{
				$GLOBALS['SITE_DB']->query_insert('group_category_access',array('module_the_name'=>'catalogues_category','category_name'=>strval($cat_id),'group_id'=>$group_id));
				$GLOBALS['SITE_DB']->query_insert('group_category_access',array('module_the_name'=>'catalogues_catalogue','category_name'=>'projects','group_id'=>$group_id));
			}
		
			// Modifications
			actual_add_catalogue('modifications',lang_code_to_default_content('DEFAULT_CATALOGUE_MODIFICATIONS_TITLE',false,2),lang_code_to_default_content('DEFAULT_CATALOGUE_MODIFICATIONS_DESCRIPTION',true,3),1,0,'',60);
			$fields=array(
				array('NAME','DESCRIPTION_NAME','short_trans',1,1),
				array('IMAGE_URL','DESCRIPTION_MODIFICATION_IMAGE_URL','url',0,0),
				array('STATUS','DESCRIPTION_MODIFICATION_STATUS','short_trans',0,1),
				array('URL','DESCRIPTION_URL','url',0,0),
				array('DESCRIPTION','DESCRIPTION_DESCRIPTION','long_trans',0,1),
				array('AUTHOR','DESCRIPTION_AUTHOR','short_text',0,1)
			);
			foreach ($fields as $i=>$field)
				actual_add_catalogue_field('modifications',lang_code_to_default_content($field[0],false,3),lang_code_to_default_content($field[1],true,3),$field[2],$i,$field[3],1,1,'',$field[4]);
			foreach (array_keys($groups) as $group_id)
				$GLOBALS['SITE_DB']->query_insert('group_category_access',array('module_the_name'=>'catalogues_catalogue','category_name'=>'modifications','group_id'=>$group_id));
		
			// Hosted-sites
			actual_add_catalogue('hosted',lang_code_to_default_content('DEFAULT_CATALOGUE_HOSTED_TITLE',false,2),lang_code_to_default_content('DEFAULT_CATALOGUE_HOSTED_DESCRIPTION',true,3),0,0,'',0);
			$fields=array(
				array('NAME','DESCRIPTION_NAME','short_trans',1,1),
				array('URL','DESCRIPTION_URL','url',0,0),
				array('DESCRIPTION','DESCRIPTION_DESCRIPTION','long_trans',0,0)
			);
			foreach ($fields as $i=>$field)
				actual_add_catalogue_field('hosted',lang_code_to_default_content($field[0],false,2),lang_code_to_default_content($field[1],true,3),$field[2],$i,$field[3],1,1,'',$field[4]);
			$cat_id=actual_add_catalogue_category('hosted',lang_code_to_default_content('DEFAULT_CATALOGUE_HOSTED_TITLE',false,2),lang_code_to_default_content('DEFAULT_CATALOGUE_HOSTED_DESCRIPTION',true,3),'',NULL,'');
			foreach (array_keys($groups) as $group_id)
			{
				$GLOBALS['SITE_DB']->query_insert('group_category_access',array('module_the_name'=>'catalogues_category','category_name'=>strval($cat_id),'group_id'=>$group_id));
				$GLOBALS['SITE_DB']->query_insert('group_category_access',array('module_the_name'=>'catalogues_catalogue','category_name'=>'hosted','group_id'=>$group_id));
			}

			// Links
			$links_category=actual_add_catalogue('links',lang_code_to_default_content('DEFAULT_CATALOGUE_LINKS_TITLE',false,2),lang_code_to_default_content('DEFAULT_CATALOGUE_LINKS_DESCRIPTION',true,3),2,1,'',0);
			$fields=array(
				array('TITLE','DESCRIPTION_TITLE','short_trans',1,1,1),
				array('URL','DESCRIPTION_URL','url',0,1,0),
				array('DESCRIPTION','DESCRIPTION_DESCRIPTION','long_trans',0,0,1)
			);
			foreach ($fields as $i=>$field)
				actual_add_catalogue_field('links',lang_code_to_default_content($field[0],false,2),lang_code_to_default_content($field[1],true,3),$field[2],$i,$field[3],1,1,'',$field[4],$field[5]);
			foreach (array_keys($groups) as $group_id)
			{
				$GLOBALS['SITE_DB']->query_insert('group_category_access',array('module_the_name'=>'catalogues_category','category_name'=>strval($links_category),'group_id'=>$group_id));
				$GLOBALS['SITE_DB']->query_insert('group_category_access',array('module_the_name'=>'catalogues_catalogue','category_name'=>'links','group_id'=>$group_id));
			}
	
			// FAQs
			actual_add_catalogue('faqs',lang_code_to_default_content('DEFAULT_CATALOGUE_FAQS_TITLE',false,2),lang_code_to_default_content('DEFAULT_CATALOGUE_FAQS_DESCRIPTION',true,3),0,0,'',0);
			$fields=array(
				array('QUESTION','DESCRIPTON_QUESTION','short_trans',0,1,1),
				array('ANSWER','_DESCRIPTION_ANSWER','long_trans',0,1,1),
				array('ORDER','DESCRIPTION_ORDER','integer',1,1,0)
			);
			foreach ($fields as $i=>$field)
				actual_add_catalogue_field('faqs',lang_code_to_default_content($field[0],false,2),lang_code_to_default_content($field[1],true,3),$field[2],$i,$field[3],$field[5],1,'',$field[4]);
			$cat_id=actual_add_catalogue_category('faqs',lang_code_to_default_content('DEFAULT_CATALOGUE_FAQS_TITLE',false,2),lang_code_to_default_content('DEFAULT_CATALOGUE_FAQS_DESCRIPTION',true,3),'',NULL,'');
			foreach (array_keys($groups) as $group_id)
			{
				$GLOBALS['SITE_DB']->query_insert('group_category_access',array('module_the_name'=>'catalogues_category','category_name'=>strval($cat_id),'group_id'=>$group_id));
				$GLOBALS['SITE_DB']->query_insert('group_category_access',array('module_the_name'=>'catalogues_catalogue','category_name'=>'faqs','group_id'=>$group_id));
			}
			
			// Contacts
			actual_add_catalogue('contacts',lang_code_to_default_content('CONTACTS',false,2),lang_code_to_default_content('DEFAULT_CATALOGUE_CONTACTS_DESCRIPTION',true,3),0,0,'',30);
			$fields=array(
				array('CONTACT_FIRST_NAME','','short_text',0,1),
				array('CONTACT_LAST_NAME','','short_text',1,1),
				array('EMAIL_ADDRESS','','short_text',0,1),
				array('CONTACT_COMPANY','','short_text',0,1),
				array('CONTACT_HOMEADDRESS','','short_text',0,1),
				array('CONTACT_CITY','','short_text',0,1),
				array('CONTACT_HOMEPHONE','','short_text',0,1),
				array('CONTACT_WORKPHONE','','short_text',0,1),
				array('CONTACT_HOMEPAGE','','short_text',0,1),
				array('CONTACT_IM','','short_text',0,1),
				array('CONTACT_EVENTS','','long_text',0,1),
				array('CONTACT_NOTES','','long_text',0,1)
			);
			foreach ($fields as $i=>$field)
				actual_add_catalogue_field('contacts',lang_code_to_default_content($field[0],false,3),insert_lang('',2),$field[2],$i,$field[3],1,1,'',$field[4]);
			actual_add_catalogue_category('contacts',lang_code_to_default_content('CONTACTS',false,2),'','',NULL,'');

			require_lang('catalogues');
			add_menu_item_simple('main_content',NULL,'CATALOGUES','_SEARCH:catalogues:type=misc');
			$projects=add_menu_item_simple('collab_features',NULL,'DEFAULT_CATALOGUE_PROJECTS_TITLE');
			add_menu_item_simple('collab_features',$projects,'VIEW','_SEARCH:catalogues:id=projects:type=index',0,0,true,do_lang('ZONE_BETWEEN'));
			add_menu_item_simple('collab_features',$projects,'ADD','_SEARCH:cms_catalogues:catalogue_name=projects:type=add_entry',0,0,true,do_lang('ZONE_BETWEEN'));
		}

		if ((!is_null($upgrade_from)) && ($upgrade_from<4))
		{
			$GLOBALS['SITE_DB']->delete_table_field('catalogues','c_own_template');
			$GLOBALS['SITE_DB']->add_table_field('catalogues','c_cat_tab','BINARY',0);
			$GLOBALS['SITE_DB']->add_table_field('catalogues','c_ecommerce','BINARY',0);
			$GLOBALS['SITE_DB']->add_table_field('catalogue_entries','ce_views_prior','INTEGER');
			$GLOBALS['SITE_DB']->add_table_field('catalogues','c_send_view_reports','ID_TEXT','never');
			$GLOBALS['SITE_DB']->add_table_field('catalogue_categories','cc_move_target','?AUTO_LINK',NULL);
			$GLOBALS['SITE_DB']->add_table_field('catalogue_categories','cc_move_days_lower','INTEGER',30);
			$GLOBALS['SITE_DB']->add_table_field('catalogue_categories','cc_move_days_higher','INTEGER',60);
			$GLOBALS['SITE_DB']->add_table_field('catalogue_entries','ce_last_moved','INTEGER',0);
			$GLOBALS['SITE_DB']->query('UPDATE '.$GLOBALS['SITE_DB']->get_table_prefix().'catalogue_entries SET ce_last_moved=ce_add_date');
		}

		if ((is_null($upgrade_from)) || ($upgrade_from<3))
		{
			create_ecommerce_catalogue('products',lang_code_to_default_content('DEFAULT_CATALOGUE_PRODUCTS_TITLE',false,2));

			add_specific_permission('CATALOGUES','high_catalogue_entry_timeout',false);
		}

		if ((is_null($upgrade_from)) || ($upgrade_from<3))
		{
			$GLOBALS['SITE_DB']->create_index('catalogue_efv_long','#lcv_value',array('cv_value'),'id');
			$GLOBALS['SITE_DB']->create_index('catalogue_efv_short','#scv_value',array('cv_value'),'id');
		}

		if ((!is_null($upgrade_from)) && ($upgrade_from<3))
		{
			$GLOBALS['SITE_DB']->add_table_field('catalogue_entries','allow_trackbacks','BINARY',1);
			$GLOBALS['SITE_DB']->add_table_field('catalogue_entries','c_name','ID_TEXT');
			$GLOBALS['SITE_DB']->add_table_field('catalogue_categories','rep_image','URLPATH');
			$GLOBALS['SITE_DB']->add_table_field('catalogue_fields','cf_default','LONG_TEXT');
			$GLOBALS['SITE_DB']->add_table_field('catalogue_fields','cf_searchable','BINARY',1);
			$entries=$GLOBALS['SITE_DB']->query_select('catalogue_entries e LEFT JOIN '.$GLOBALS['SITE_DB']->get_table_prefix().'catalogue_categories c ON e.cc_id=c.id',array('e.id','c.c_name'));
			foreach ($entries as $entry)
			{
				$GLOBALS['SITE_DB']->query_update('catalogue_entries',array('c_name'=>$entry['c_name']),array('id'=>$entry['id']),'',1);
			}
		}

		if ((!is_null($upgrade_from)) && ($upgrade_from<4))
		{
			$GLOBALS['SITE_DB']->alter_table_field('catalogues','c_own_pages','SHORT_INTEGER','c_display_type');
			$GLOBALS['SITE_DB']->add_table_field('catalogue_fields','cf_put_in_category','BINARY',1);
			$GLOBALS['SITE_DB']->add_table_field('catalogue_fields','cf_put_in_search','BINARY',1);
		}
		if ((!is_null($upgrade_from)) && ($upgrade_from<5))
		{
			$GLOBALS['SITE_DB']->add_table_field('catalogues','c_owner','?USER',NULL);
			add_specific_permission('CATALOGUES','use_project_alert',false);
			add_specific_permission('CATALOGUES','can_add_events',true);
			add_specific_permission('CATALOGUES','can_add_project',true);
			add_specific_permission('CATALOGUES','use_alert_system',false);
			add_specific_permission('CATALOGUES','can_add_merchandise',false);
		}
	}
	
	/**
	 * Standard modular entry-point finder function.
	 *
	 * @return ?array	A map of entry points (type-code=>language-code) (NULL: disabled).
	 */
	function get_entry_points()
	{
		return array('misc'=>'CATALOGUES');
	}
	
	/**
	 * Standard modular page-link finder function (does not return the main entry-points that are not inside the tree).
	 *
	 * @param  ?integer  The number of tree levels to computer (NULL: no limit)
	 * @param  boolean	Whether to not return stuff that does not support permissions (unless it is underneath something that does).
	 * @param  ?string	Position to start at in the tree. Does not need to be respected. (NULL: from root)
	 * @param  boolean	Whether to avoid returning categories.
	 * @return ?array	 	A tuple: 1) full tree structure [made up of (pagelink, permission-module, permissions-id, title, children, ?entry point for the children, ?children permission module, ?whether there are children) OR a list of maps from a get_* function] 2) permissions-page 3) optional base entry-point for the tree 4) optional permission-module 5) optional permissions-id (NULL: disabled).
	 */
	function get_page_links($max_depth=NULL,$require_permission_support=false,$start_at=NULL,$dont_care_about_categories=false)
	{
		unset($require_permission_support);

		$permission_page='cms_catalogues';

		require_code('catalogues');

		$category_id=NULL;
		if (!is_null($start_at))
		{
			$matches=array();
			if (preg_match('#[^:]*:catalogues:type=index:id=(.*)#',$start_at,$matches)!=0)
			{
				$category_id=NULL;
				$adjusted_max_depth=is_null($max_depth)?NULL:(is_null($category_id)?$max_depth:$max_depth);
				$children=$dont_care_about_categories?array():get_catalogue_category_tree($matches[1],$category_id,NULL,NULL,$adjusted_max_depth,false);
				return array($children,$permission_page,'_SELF:_SELF:catalogue='.$matches[1].':type=category:id=!','catalogues_category');
			}
			elseif (preg_match('#[^:]*:catalogues:catalogue=([^:]*):type=category:id=(.*)#',$start_at,$matches)!=0)
			{
				$category_id=($matches[2]=='')?NULL:intval($matches[2]);
				$adjusted_max_depth=is_null($max_depth)?NULL:(is_null($category_id)?$max_depth:$max_depth);
				$children=$dont_care_about_categories?array():get_catalogue_category_tree($matches[1],$category_id,NULL,NULL,$adjusted_max_depth,false);
				return array($children,$permission_page,'_SELF:_SELF:catalogue='.$matches[1].':type=category:id=!','catalogues_category');
			}
		}

		$children=array();
		$rows=$dont_care_about_categories?array():$GLOBALS['SITE_DB']->query_select('catalogues c LEFT JOIN '.$GLOBALS['SITE_DB']->get_table_prefix().'translate t ON '.db_string_equal_to('language',user_lang()).' AND c.c_title=t.id',array('c_title','c_name','text_original'));
		foreach ($rows as $row)
		{
			if (is_null($row['text_original'])) $row['text_original']=get_translated_text($row['c_title']);
			$kids=array();
			if ((!is_null($max_depth)) || ($max_depth>1))
			{
				$adjusted_max_depth=is_null($max_depth)?NULL:(is_null($category_id)?($max_depth-2):($max_depth-1));
				$kids=get_catalogue_category_tree($row['c_name'],$category_id,NULL,NULL,$adjusted_max_depth,false);
			}
			$children[]=array('_SELF:_SELF:type=index:id='.$row['c_name'],'catalogues_catalogue',$row['c_name'],$row['text_original'],$kids,'_SELF:_SELF:catalogue='.$row['c_name'].':type=category:id=!','catalogues_category',true);
		}

		return array($children,$permission_page,'_SELF:_SELF:type=misc:id=!');
	}

	/**
	 * Convert a page link to a category ID and category permission module type.
	 *
	 * @param  string	The page link
	 * @return array	The pair
	 */
	function extract_page_link_permissions($page_link)
	{
		$matches=array();
		if (preg_match('#^([^:]*):([^:]*):type=index:id=(.*)$#',$page_link,$matches)!=0)
			return array($matches[3],'catalogues_catalogue');
		preg_match('#^([^:]*):([^:]*):catalogue=([^:]*):type=category:id=(.*)$#',$page_link,$matches);
		return array($matches[4],'catalogues_category');
	}

	/**
	 * Standard modular run function.
	 *
	 * @return tempcode	The result of execution.
	 */
	function run()
	{
		require_lang('catalogues');
		require_code('catalogues');
		require_code('tracking');
		require_lang('tracking');
		require_code('submit');
		require_css('catalogues');

		$type=get_param('type','misc');
		$GLOBALS['NO_QUERY_LIMIT']=true;
		if ($type=='category') return $this->view_catalogue_category();
		if ($type=='atoz') return $this->view_catalogue_category_entries();
		if ($type=='entry') return $this->view_catalogue_entry();
		if ($type=='index') return $this->view_catalogue_index();
		if ($type=='tree') return $this->tree_view_screen();
		if ($type=='misc') return $this->list_catalogues();

		return new ocp_tempcode();
	}
	
	/**
	 * The UI to show a catalogue category.
	 *
	 * @return tempcode		The UI
	 */
	function view_catalogue_category()
	{
		return render_catalogue_category_screen();
	}

	/**
	 * The UI to show a catalogue category.
	 *
	 * @return tempcode		The UI
	 */
	function view_catalogue_category_entries()
	{	
		$GLOBALS['NO_QUERY_LIMIT']=true;

		$id=get_param_integer('id',-1);

		if ($id==-1)
		{
			$id=$GLOBALS['SITE_DB']->query_value('catalogue_categories','MIN(id)',array('c_name'=>get_param('catalogue_name')));
		}
		$GLOBALS['FEED_URL']=find_script('backend').'?mode=catalogues&filter='.strval($id);

		$categories=$GLOBALS['SITE_DB']->query_select('catalogue_categories',array('*'),array('id'=>$id));
		if (!array_key_exists(0,$categories))
		{
			return warn_screen(get_page_title('CATALOGUES'),do_lang_tempcode('MISSING_RESOURCE'));
		}
		$category=$categories[0];
	
		// Permission for here?
		if (!has_category_access(get_member(),'catalogues_catalogue',$category['c_name']))
		{
			access_denied('CATALOGUE_ACCESS');
		}
	
		$catalogue_name=$category['c_name'];

		$min=$GLOBALS['SITE_DB']->query_value('catalogue_categories','MIN(id)',array('c_name'=>$catalogue_name));

		$root=get_param_integer('root',$min,true);

		$category=$GLOBALS['SITE_DB']->query_value('catalogue_categories','cc_title',array('id'=>$id));

		$category_name=get_translated_text($category);

		$catalogues=$GLOBALS['SITE_DB']->query_select('catalogues',array('*'),array('c_name'=>$catalogue_name),'',1);

		if(!array_key_exists(0,$catalogues)) warn_exit(do_lang_tempcode('MISSING_RESOURCE'));

		$catalogue=$catalogues[0];

		$tpl_set=$catalogue_name;
		
		$category_buildup=new ocp_tempcode();

		$max=get_param_integer('max',30);
		$start=get_param_integer('start',0);

		require_code('ocfiltering');
		$sql_filter=ocfilter_to_sqlfragment(strval($id).'*','cc_id','catalogue_categories','cc_parent_id','cc_id','id'); // Note that the parameters are fiddled here so that category-set and record-set are the same, yet SQL is returned to deal in an entirely different record-set (entries' record-set)

		$cats=array();
		$rows=$GLOBALS['SITE_DB']->query('SELECT * FROM '.get_table_prefix().'catalogue_entries p WHERE ce_validated=1 AND ('.$sql_filter.')');
		foreach ($rows as $row)
		{
			$entry_map=get_catalogue_entry_map($row,$catalogue,'CATEGORY','DEFAULT',$root,NULL,array(0),false,false);
			$letter=strtoupper(substr($entry_map['FIELD_0_PLAIN']->evaluate(),0,1));

			if (!has_category_access(get_member(),'catalogues_category',strval($row['id']))) continue;

			if (!array_key_exists($letter,$cats)) $cats[$letter]=array();
			$cats[$letter][]=$row;
		}
		unset($rows);

		ksort($cats);

		foreach ($cats as $letter=>$entries)
		{
			list($entry_buildup)=get_catalogue_category_entry_buildup(NULL,$catalogue_name,$catalogue,'CATEGORY',$tpl_set,$max,$start,NULL,$root,NULL,true,$entries);
	
			$category_buildup->attach(do_template('CATALOGUE_CATEGORY_HEADING',array('LETTER'=>$letter,'ENTRIES'=>escape_html($entry_buildup)),NULL,false,'CATALOGUE_CATEGORY_HEADING'));				
		}

		$_title=get_translated_text($category);

		$title_to_use=do_lang_tempcode('DEFAULT__CATALOGUE_CATEGORY_ATOZ',escape_html($_title));

		$title=get_page_title($title_to_use,false);

		//Link to add to catalogue category
		if (has_actual_catalogue_page_access($catalogue_name,NULL,'cms_catalogues',NULL,array('catalogues_catalogue',$catalogue_name,'catalogues_category',$id),'submit_midrange_content'))
		{
			$add_link=build_url(array('page'=>'cms_catalogues','type'=>'add_entry','catalogue_name'=>$catalogue_name,'category_id'=>$id),get_module_zone('cms_catalogues'));
		} else $add_link=new ocp_tempcode();
		if (has_actual_catalogue_page_access($catalogue_name,NULL,'cms_catalogues',NULL,array('catalogues_catalogue',$catalogue_name,'catalogues_category',$id),'submit_cat_midrange_content'))
		{
			$add_cat_url=build_url(array('page'=>'cms_catalogues','type'=>'add_category','catalogue_name'=>$catalogue_name,'parent_id'=>$id),get_module_zone('cms_catalogues'));
		} else $add_cat_url=new ocp_tempcode();
		if (has_actual_catalogue_page_access($catalogue_name,NULL,'cms_catalogues',NULL,array('catalogues_catalogue',$catalogue_name,'catalogues_category',$id),'edit_cat_midrange_content'))
		{
			$edit_cat_url=build_url(array('page'=>'cms_catalogues','type'=>'_edit_category','catalogue_name'=>$catalogue_name,'id'=>$id),get_module_zone('cms_catalogues'));
		} else $edit_cat_url=new ocp_tempcode();
		if (has_actual_catalogue_page_access($catalogue_name,NULL,'cms_catalogues',NULL,array('catalogues_catalogue',$catalogue_name),'edit_cat_highrange_content'))
		{
			$edit_catalogue_url=build_url(array('page'=>'cms_catalogues','type'=>'_edit_catalogue','id'=>$catalogue_name),get_module_zone('cms_catalogues'));
		} else $edit_catalogue_url=new ocp_tempcode();

		breadcrumb_set_parents(array(array('_SELF:_SELF:misc'.(($catalogue['c_ecommerce']==1)?':ecommerce=1':''),do_lang_tempcode('CATALOGUES'))));

		$catalogue_title=get_translated_text($catalogue['c_title']);

		return do_template('CATALOGUE_'.$tpl_set.'_CATEGORY_SCREEN',array('TITLE'=>$title,'CART_LINK'=>'','_TITLE'=>$_title,'TAGS'=>get_loaded_tags('catalogue_categories'),'CATALOGUE_TITLE'=>$catalogue_title,'CATALOGUE'=>$catalogue_name,'BROWSER'=>'','SORT_OPTIONS'=>'','ADD_LINK'=>$add_link,'ADD_CAT_URL'=>$add_cat_url,'EDIT_CAT_URL'=>$edit_cat_url,'EDIT_CATALOGUE_URL'=>$edit_catalogue_url,'ENTRIES'=>$category_buildup,'SUBCATEGORIES'=>'','DESCRIPTION'=>''),NULL,false,'CATALOGUE_DEFAULT_CATEGORY_SCREEN');
	}

	/**
	 * The UI to show a catalogue entry.
	 *
	 * @return tempcode		The UI
	 */
	function view_catalogue_entry()
	{
		$id	=	get_param_integer('id');
		return render_catalogue_entry_screen($id);
	}

	/**
	 * The UI to show the index of a catalogue.
	 *
	 * @return tempcode		The UI
	 */
	function view_catalogue_index()
	{
		$catalogue_name=get_param('id');
		$GLOBALS['FEED_URL']=find_script('backend').'?mode=catalogues&filter='.$catalogue_name;
		$catalogue_rows=$GLOBALS['SITE_DB']->query_select('catalogues',array('*'),array('c_name'=>$catalogue_name));
		if (!array_key_exists(0,$catalogue_rows)) warn_exit(do_lang_tempcode('MISSING_RESOURCE'));
		$catalogue=$catalogue_rows[0];
		//$tpl_set=$catalogue_name;
		$description=get_translated_tempcode($catalogue['c_description']);
		$description_2=get_translated_text($catalogue['c_description']);
		$title_to_use=do_lang_tempcode($catalogue_name.'__CATALOGUE_INDEX',escape_html(get_translated_text($catalogue['c_title'])));
		$title_to_use_2=do_lang($catalogue_name.'__CATALOGUE_INDEX',escape_html(get_translated_text($catalogue['c_title'])),NULL,NULL,NULL,false);
		if (is_null($title_to_use_2))
			$title_to_use=do_lang_tempcode('DEFAULT__CATALOGUE_INDEX',escape_html(get_translated_text($catalogue['c_title'])));
		$title=get_page_title($title_to_use,false);

		if (!has_category_access(get_member(),'catalogues_catalogue',$catalogue_name))
		{
			access_denied('CATALOGUE_ACCESS');
		}

		$rows_subcategories=$GLOBALS['SITE_DB']->query_select('catalogue_categories',array('*'),array('c_name'=>$catalogue_name));
		foreach ($rows_subcategories as $i=>$subcategory) // Dereference language
		{
			$rows_subcategories[$i]['cc_title']=get_translated_text($subcategory['cc_title']);
		}
		global $M_SORT_KEY;
		$M_SORT_KEY='cc_title';
		usort($rows_subcategories,'multi_sort');
		$out=new ocp_tempcode();
		foreach ($rows_subcategories as $myrow)
		{
			if (!has_category_access(get_member(),'catalogues_category',strval($myrow['id']))) continue;

	//		$count=$GLOBALS['SITE_DB']->query_value_null_ok('catalogue_entries','COUNT(*)',array('cc_id'=>$myrow['id'],'ce_validated'=>1));
	//		if (!($count>0)) continue;

			$url=build_url(array('page'=>'_SELF','id'=>$myrow['id'],'type'=>'category'),'_SELF');
			$name=$myrow['cc_title'];
			$child_counts=count_catalogue_category_children($myrow['id']);
			$num_children=$child_counts['num_children'];
			$num_entries=$child_counts['num_entries_children'];
			if ($num_entries!=0)
			{
				if ($num_children>0)
				{
					$display_string=do_lang_tempcode('CATEGORY_SUBORDINATE',number_format($num_entries),number_format($num_children));
				} else
				{
					$display_string=do_lang_tempcode('CATEGORY_SUBORDINATE_2',number_format($num_entries));
				}
			} else
			{
				if ($num_children>0)
				{
					$display_string=do_lang_tempcode('CATEGORY_SUBORDINATE_NO_ENTRIES',number_format($num_children));
				} else
				{
					$display_string=do_lang_tempcode('CATEGORY_SUBORDINATE_NO_ENTRIES_OR_SUBCATEGORIES');
				}
			}

			$out->attach(do_template('INDEX_SCREEN_ENTRY',array('_GUID'=>'f2550f5be8765b5d0349ee5523f739cb','NAME'=>$name,'URL'=>$url,'DISPLAY_STRING'=>$display_string)));
		}

		breadcrumb_set_parents(array(array('_SELF:_SELF:misc'.(($catalogue['c_ecommerce']==1)?':ecommerce=1':''),do_lang_tempcode('CATALOGUES'))));
		breadcrumb_set_self(make_string_tempcode(escape_html(get_translated_text($catalogue['c_title']))));

		$edit_url=build_url(array('page'=>'cms_catalogues','type'=>'_edit_catalogue','id'=>$catalogue_name),get_module_zone('cms_catalogues'));

		if (has_actual_catalogue_page_access($catalogue_name,NULL,'cms_catalogues',NULL,array('catalogues_catalogue',$catalogue_name),'submit_cat_midrange_content'))
		{
			$add_cat_url=build_url(array('page'=>'cms_catalogues','type'=>'add_category','catalogue_name'=>$catalogue_name),get_module_zone('cms_catalogues'));
		} else $add_cat_url=new ocp_tempcode();

		$catalogue_title=get_translated_text($catalogue['c_title']);

		$GLOBALS['META_DATA']+=array(
			'created'=>date('Y-m-d',$catalogue['c_add_date']),
			'creator'=>'',
			'publisher'=>'', // blank means same as creator
			'modified'=>'',
			'type'=>'Catalogue',
			'title'=>$catalogue_title,
			'identifier'=>'_SEARCH:catalogues:index:'.strval($catalogue_name),
			'description'=>$description_2,
		);

		// Checking if the tracked or not 
		if(is_tracked('catalogues',$catalogue_name))
		{
			$track_url=build_url(array('page'=>'tracking','track_type'=>'catalogues','id'=>$catalogue_name,'type'=>'untrack','redirect'=>get_self_url(true)),get_module_zone('tracking'));
			$img="untrack_resource";
		}
		else
		{
			$track_url=build_url(array('page'=>'tracking','track_type'=>'catalogues','id'=>$catalogue_name,'type'=>'misc','redirect'=>get_self_url(true)),get_module_zone('tracking'));
			$img="track_resource";
		}

		// If the its a guest then unset the tracking image
		if(is_guest())
			$img=NULL;

		return do_template('CATALOGUE_INDEX_SCREEN',array('_GUID'=>'9ac6f5967177b020bebfe8b4ace35eff','TITLE'=>$title,'CATALOGUE'=>$catalogue_name,'CATALOGUE_TITLE'=>$catalogue_title,'DESCRIPTION'=>$description,'ADD_CAT_URL'=>$add_cat_url,'CONTENT'=>$out,'EDIT_URL'=>$edit_url,'TRACK_URL'=>$track_url,'TRACK_IMG'=>$img));
	}
	
	/**
	 * The UI to show a list of catalogues to choose from.
	 *
	 * @return tempcode		The UI
	 */
	function list_catalogues()
	{
		$title=get_page_title('CATALOGUES');

		$GLOBALS['FEED_URL']=find_script('backend').'?mode=catalogues&filter=';

		$ecommerce=get_param_integer('ecommerce',NULL);

		$map=is_null($ecommerce)?NULL:array('c_ecommerce'=>$ecommerce);

		$rows=$GLOBALS['SITE_DB']->query_select('catalogues',array('*'),$map);
		$out=new ocp_tempcode();
		foreach ($rows as $myrow)
		{
			$first_category=$GLOBALS['SITE_DB']->query_value_null_ok('catalogue_categories','MIN(id)',array('c_name'=>$myrow['c_name']));
			if (is_null($first_category)) continue;
			$first_entry=$GLOBALS['SITE_DB']->query_value_null_ok('catalogue_entries','MIN(id)',array('c_name'=>$myrow['c_name']));
			if (is_null($first_entry)) continue;
	
			if (!has_category_access(get_member(),'catalogues_catalogue',$myrow['c_name'])) continue;

			if ($myrow['c_is_tree']==1) // Point to root
			{
				$url=build_url(array('page'=>'_SELF','catalogue_name'=>$myrow['c_name'],'type'=>'category','id'=>$first_category),'_SELF');
			} else
			{
				$url=build_url(array('page'=>'_SELF','id'=>$myrow['c_name'],'type'=>'index'),'_SELF');
			}
			$name=get_translated_text($myrow['c_title']);
	
			$out->attach(do_template('INDEX_SCREEN_ENTRY',array('_GUID'=>'082993547f051894a6b70eea8194df5f','NAME'=>$name,'URL'=>$url)));
		}

		return do_template('INDEX_SCREEN',array('_GUID'=>'5af7dcb5bd26550ca6f26c2f9108f478','PRE'=>'','POST'=>'','TITLE'=>$title,'CONTENT'=>$out));
	}

	/**
	 * The UI to view a catalogue category tree.
	 *
	 * @return tempcode		The UI
	 */
	function tree_view_screen()
	{
		require_code('splurgh');

		$GLOBALS['FEED_URL']=find_script('backend').'?mode=catalogues&filter=';

		$catalogue_name=get_param('id');

		$url_stub=build_url(array('page'=>'_SELF','type'=>'category'),'_SELF');
		$last_change_time=$GLOBALS['SITE_DB']->query_value_null_ok('catalogue_categories','MAX(cc_add_date)');
	
		if (!has_category_access($GLOBALS['FORUM_DRIVER']->get_guest_id(),'catalogues_catalogue',$catalogue_name))
		{
			access_denied('CATALOGUE_ACCESS');
		}

		$category_rows=$GLOBALS['SITE_DB']->query_select('catalogue_categories',array('id','cc_title','cc_parent_id'),array('c_name'=>$catalogue_name));
		$map=array();
		foreach ($category_rows as $category)
		{
			if (!has_category_access($GLOBALS['FORUM_DRIVER']->get_guest_id(),'catalogues_category',strval($category['id']))) continue;

			$id=$category['id'];

			$map[$id]['title']=get_translated_text($category['cc_title']);
			$children=array();
			foreach ($category_rows as $child)
			{
				if ($child['cc_parent_id']==$id) $children[]=$child['id'];
			}
			$map[$id]['children']=$children;
		}
		if (count($map)==0) inform_exit(do_lang_tempcode('NO_ENTRIES'));

		$content=splurgh_master_build('id',$map,$url_stub,'catalogue_'.$catalogue_name.'_tree_made',$last_change_time,$category_rows[0]['id']);

		$title=get_page_title('CATEGORIES');

		breadcrumb_set_parents(array(array('_SELF:_SELF:misc'.(is_ecommerce_catalogue($catalogue_name)?':ecommerce=1':''),do_lang_tempcode('CATALOGUES'))));

		return do_template('SPLURGH_SCREEN',array('_GUID'=>'7cbb5d410887e3834a01265e133a9b33','TITLE'=>$title,'CONTENT'=>$content));
	}

}


