<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		galleries
 */

class Block_main_view_items
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']='Manuprathap';
		$info['organisation']='ocProducts';
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=1;
		$info['locked']=true;
		$info['parameters']=array('param');
		return $info;
	}

	/**
	 * Standard modular cache function.
	 *
	 * @return ?array	Map of cache details (cache_on and ttl) (NULL: module is disabled).
	 */
	function cacheing_environment()
	{
		$info=array();
		$info['cache_on']='array(array_key_exists(\'param\',$map)?intval($map[\'param\']):5)';
		$info['ttl']=60*24;
		return $info;
	}

	/**
	 * Standard modular run function.
	 *
	 * @param  array		A map of parameters.
	 * @return tempcode	The result of execution.
	 */
	function run($map)
	{
		require_code('catalogues');
		require_css('ecommerce');

		$number = array_key_exists('param',$map)?intval($map['param']):5;

		$rows	= $GLOBALS['SITE_DB']->query_select('shopping_logging',array('DISTINCT item'),array('e_member_id'=>get_member(),'session_id'=>get_session_id(),'last_action'=>'View item'));

		if(!array_key_exists(0,$rows))	return paragraph(do_lang_tempcode('NO_ENTRIES'),'','nothing_here');
		$i	=	1;
		foreach($rows as $entry)
		{
			$catalogue_name =	$GLOBALS['SITE_DB']->query_value_null_ok('catalogue_entries','c_name',array('id'=>$entry['item']));

			if(is_null($catalogue_name))	continue;

			$entry_map		=	get_catalogue_entry_field_values($catalogue_name,$entry['item']);
			$product_url	=	build_url(array('page'=>'catalogues','type'=>'entry','id'=>$entry['item']),get_module_zone('catalogues'));
			$product_link	=	hyperlink($product_url,$entry_map[0]['effective_value'],false,false,do_lang('INDEX'));
			$item_det[]		=	array('TITLE'=>$product_link,'IMAGE'=>get_item_image_thumb($entry_map[0]['effective_value'],$entry_map[7]['effective_value']));
			if ($i==$number) break;
			$i++;
		}

		return do_template('BLOCK_MAIN_RECENT_ITEM_VIEWS',array('ITEMS'=>$item_det));
	}
}