<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core
 */

// These symbols are all static evaluated during compilation, so don't need loading on each request.

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_MAKE_URL_ABSOLUTE($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[0])) {
        $value = $param[0];
        if (url_is_local($value)) {
            $value = get_custom_base_url() . '/' . $value;
        }
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_THEME($lang, $escaped, $param)
{
    if (isset($GLOBALS['FORUM_DRIVER'])) {
        $value = $GLOBALS['FORUM_DRIVER']->get_theme();
    } else {
        $value = 'default';
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_VERSION_NUMBER($lang, $escaped, $param)
{
    if ((isset($param[0])) && ($param[0] == '1')) {
        require_code('version2');
        $value = get_version_dotted();
    } else {
        $value = cms_version_pretty();
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_SITE_NAME($lang, $escaped, $param)
{
    $value = get_site_name();

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_CHARSET($lang, $escaped, $param)
{
    $value = get_charset();

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_VALUE_OPTION($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        $value = function_exists('get_value') ? get_value($param[0]) : '';
        if (is_null($value)) {
            $value = function_exists('get_value') ? get_value($param[0], null, true) : '';
            if (is_null($value)) {
                $value = isset($param[1]) ? $param[1] : '';
                if (($param[0] == 'textmate') && ((running_locally()) && (strpos(cms_srv('HTTP_USER_AGENT'), 'Macintosh') !== false))) {
                    $value = '1';
                }
            }
        }
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_BRAND_BASE_URL($lang, $escaped, $param)
{
    $value = get_brand_base_url();

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_CUSTOM_BASE_URL($lang, $escaped, $param)
{
    $value = get_custom_base_url((isset($param[0]) && ($param[0] != '')) ? ($param[0] == '1') : null);

    if ((isset($param[1])) && ($param[1] == '1')) {
        $value = cdn_filter($value);
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_BASE_URL_NOHTTP($lang, $escaped, $param)
{
    if ($GLOBALS['DEV_MODE']) {// Dev mode changes base domain so we need to actually use it in full (fine, we don't have HTTPS in dev mode).
        return ecv_BASE_URL($lang, $escaped, $param);
    }

    $value = preg_replace('#^https?://[^/]+#', '', get_base_url());
    if (substr($value, 0, 2) == '//') {
        $value = substr($value, 1);
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_CUSTOM_BASE_URL_NOHTTP($lang, $escaped, $param)
{
    if ($GLOBALS['DEV_MODE']) {// Dev mode changes base domain so we need to actually use it in full (fine, we don't have HTTPS in dev mode).
        return ecv_BASE_URL($lang, $escaped, $param);
    }

    $value = preg_replace('#^https?://[^/]+/#', '/', get_custom_base_url());
    if (substr($value, 0, 2) == '//') {
        $value = substr($value, 1);
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_VALID_FILE_TYPES($lang, $escaped, $param)
{
    $value = get_option('valid_types');
    $types = array_flip(explode(',', $value));
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    ksort($types);
    foreach (array_flip($types) as $val) {
        $value .= $val . ',';
    }
    $value = substr($value, 0, strlen($value) - 1);

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_COOKIE_PATH($lang, $escaped, $param)
{
    $value = function_exists('get_cookie_path') ? get_cookie_path() : '/';

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_COOKIE_DOMAIN($lang, $escaped, $param)
{
    $s_value = function_exists('get_cookie_domain') ? get_cookie_domain() : '';
    $value = is_null($s_value) ? '' : $s_value;

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_SESSION_COOKIE_NAME($lang, $escaped, $param)
{
    $value = function_exists('get_session_cookie') ? get_session_cookie() : '';

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_MAILTO($lang, $escaped, $param)
{
    require_code('obfuscate');

    $value = mailto_obfuscated();

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_ADD($lang, $escaped, $param)
{
    $_value = 0.0;

    foreach ($param as $p) {
        $_value += floatval(str_replace(',', '', $p));
    }

    $value = float_to_raw_string($_value, 20, true);

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_SUBTRACT($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[0])) {
        $_value = 0.0;

        foreach ($param as $i => $p) {
            $_p = floatval(str_replace(',', '', $p));
            if ($i == 0) {
                $_value = $_p;
            } else {
                $_value -= $_p;
            }
        }

        $value = float_to_raw_string($_value, 20, true);
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_ALREADY_RATED($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[1])) {
        require_code('feedback');
        $value = (already_rated(array($param[0]), $param[1]) ? '1' : '0');
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_ANCHOR($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        $_value = do_template('ANCHOR', array('_GUID' => '8795c70c9dd7c6217bb765264ac24092', 'NAME' => $param[0]));
        $value = $_value->evaluate();
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_AT($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[1])) {
        $value = cms_mb_substr($param[0], intval($param[1]), 1);
    }

    if ($GLOBALS['XSS_DETECT'] && ocp_is_escaped($param[0])) {
        ocp_mark_as_escaped($value);
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_ATTACHMENT_DOWNLOADS($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[0])) {
        $db = $GLOBALS['SITE_DB'];
        if ((isset($param[1])) && ($param[1] == '1')) {
            $db = $GLOBALS['FORUM_DB'];
        }
        $_value = $db->query_select_value_if_there('attachments', 'a_num_downloads', array('id' => intval($param[0])));
        $value = is_null($_value) ? '?' : strval($_value);
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_AVAILABLE_POINTS($lang, $escaped, $param)
{
    $value = '';

    if (addon_installed('points')) {
        require_code('points');
        $value = strval(available_points(isset($param[0]) ? intval($param[0]) : get_member()));
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_AWARD_ID($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[0])) {
        if ($param[0] != '') {
            static $awarded_content_ids = array();
            if (!isset($awarded_content_ids[intval($param[0])])) {
                $awarded_content_ids[intval($param[0])] = $GLOBALS['SITE_DB']->query_select_value_if_there('award_archive', 'content_id', array('a_type_id' => intval($param[0])), 'ORDER BY date_and_time DESC');
            }
            $value = isset($awarded_content_ids[intval($param[0])]) ? $awarded_content_ids[intval($param[0])] : '';
        }
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_BROWSER_UA($lang, $escaped, $param)
{
    $browser = get_browser_string();
    $value = $browser;

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_CAN_SPELLCHECK($lang, $escaped, $param)
{
    $value = (function_exists('pspell_check') || function_exists('enchant_dict_check')) ? '1' : '0';

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_URLDECODE($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[0])) {
        $value = urldecode($param[0]);
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_CLEAN_FILE_SIZE($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        $bytes = is_numeric($param[0]) ? intval($param[0]) : null;
        require_code('files');
        $value = clean_file_size($bytes);
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_COMCODE($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        global $LAX_COMCODE;
        $tmp = $LAX_COMCODE;
        $LAX_COMCODE = true;
        $_value = comcode_to_tempcode($param[0], null, !isset($param[1]) || $param[1] == '1');
        $LAX_COMCODE = $tmp;
        $value = $_value->evaluate();
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_COMMA_LIST_FROM_BREADCRUMBS($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        $separator = do_template('BREADCRUMB_SEPARATOR', array('_GUID' => 'y28e21cdbc38a3037d083f619bb311ae',));
        $value = '=' . str_replace($separator->evaluate(), ',=', str_replace(',', '&#44;', $param[0]));
        if ((!array_key_exists(1, $param)) || ($param[1] == '0')) {
            $value = strip_tags($value);
        } else {
            $value = strip_tags($value, '<a>');
        }
        $value = trim($value);
        if (($GLOBALS['XSS_DETECT']) && (ocp_is_escaped($param[0]))) {
            ocp_mark_as_escaped($value);
        }
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_COMMA_LIST_NICIFY($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        $value = html_entity_decode(str_replace(',', ', ', preg_replace('#[^,=]*=#', '', $param[0])), ENT_QUOTES, get_charset());
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_COMMA_LIST_POP($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        $value = preg_replace('#(^|,)[^,]+$#', '', $param[0]);
        if (($GLOBALS['XSS_DETECT']) && (ocp_is_escaped($param[0]))) {
            ocp_mark_as_escaped($value);
        }
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_COMMA_LIST_PUSH($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[1])) {
        $value = $param[0] . ',' . str_replace(',', '&#44;', $param[1]);
        if (($GLOBALS['XSS_DETECT']) && (ocp_is_escaped($param[0]))) {
            ocp_mark_as_escaped($value);
        }
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_COMMA_LIST_REVERSE($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        $value = implode(',', array_reverse(explode(',', $param[0])));
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_COMMA_LIST_SET($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[2])) {
        require_code('blocks');
        $values = block_params_str_to_arr($param[0]);
        $values[$param[1]] = $param[2];
        $value = block_params_arr_to_str($values);
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_COMMA_LIST_SHIFT($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        $value = preg_replace('#^[^,]+(,|$)#', '', $param[0]);
        if (($GLOBALS['XSS_DETECT']) && (ocp_is_escaped($param[0]))) {
            ocp_mark_as_escaped($value);
        }
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_COMMA_LIST_UNSHIFT($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[1])) {
        $value = str_replace(',', '&#44;', $param[1]) . ',' . $param[0];
        if (($GLOBALS['XSS_DETECT']) && (ocp_is_escaped($param[0]))) {
            ocp_mark_as_escaped($value);
        }
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_COPPA_ON($lang, $escaped, $param)
{
    $value = ((get_option('is_on_coppa') == '1') && (get_option('dobs') == '1')) ? '1' : '0';

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_CSS_DIMENSION_REDUCE($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[1])) {
        $value = $param[0];
        if (substr($value, -2) == 'px') {
            $b = $param[1];
            $value = strval(intval(substr($value, 0, -2)) - intval($b)) . 'px';
        }
        if ($value == '') {
            $value = '0px';
        }
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_CURRENTLY_INVISIBLE($lang, $escaped, $param)
{
    $value = is_invisible() ? '1' : '0';

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_DEC($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        global $TEMPCODE_SETGET;
        if (!isset($TEMPCODE_SETGET[$param[0]])) {
            $TEMPCODE_SETGET[$param[0]] = '0';
        }
        $TEMPCODE_SETGET[$param[0]] = strval(intval($TEMPCODE_SETGET[$param[0]]) - 1);
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_DIV_CEIL($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[1])) {
        if (floatval($param[1]) == 0.0) {
            $value = 'divide-by-zero';
        } else {
            $value = strval(intval(ceil(floatval($param[0]) / floatval($param[1]))));
        }
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_DOMAIN($lang, $escaped, $param)
{
    $value = get_domain();

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_ENTITY_DECODE($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        static $charset = null;
        if ($charset === null) {
            $charset = get_charset();
        }
        $value = @html_entity_decode($param[0], ENT_QUOTES, $charset);
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_ESCAPE($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        $d_escaping = array(isset($param[1]) ? constant($param[1]) : ENTITY_ESCAPED);
        for ($i = 0; $i < max(1, array_key_exists(2, $param) ? intval($param[2]) : 1); $i++) {
            if (is_string($param[0])) {
                apply_tempcode_escaping($d_escaping, $param[0]);
            }
        }
        $value = $param[0];
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_FIND_GUID_VIA_ID($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (!addon_installed('commandr')) {
        return $value;
    }

    if (isset($param[1])) {
        require_code('resource_fs');
        $value = find_guid_via_id($param[0], $param[1]);
        if ($value === null) {
            $value = '';
        }
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_FIND_ID_VIA_GUID($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (!addon_installed('commandr')) {
        return $value;
    }

    if (isset($param[0])) {
        require_code('resource_fs');
        $value = find_id_via_guid($param[0]);
        if ($value === null) {
            $value = '';
        }
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_FIND_ID_VIA_LABEL($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (!addon_installed('commandr')) {
        return $value;
    }

    if (isset($param[1])) {
        require_code('resource_fs');
        $value = find_id_via_label($param[0], $param[1], array_key_exists(2, $param) ? $param[2] : null);
        if ($value === null) {
            $value = '';
        }
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_FIND_ID_VIA_COMMANDR_FS_FILENAME($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (!addon_installed('commandr')) {
        return $value;
    }

    if (isset($param[1])) {
        require_code('resource_fs');
        $value = find_id_via_commandr_fs_filename($param[0], $param[1]);
        if ($value === null) {
            $value = '';
        }
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_FIND_ID_VIA_URL_MONIKER($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[1])) {
        require_code('urls2');
        $value = find_id_via_url_moniker($param[0], $param[1]);
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_FIND_LABEL_VIA_ID($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (!addon_installed('commandr')) {
        return $value;
    }

    if (isset($param[1])) {
        require_code('resource_fs');
        $value = find_label_via_id($param[0], $param[1]);
        if ($value === null) {
            $value = '';
        }
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_FIND_COMMANDR_FS_FILENAME_VIA_ID($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (!addon_installed('commandr')) {
        return $value;
    }

    if (isset($param[1])) {
        require_code('resource_fs');
        $value = find_commandr_fs_filename_via_id($param[0], $param[1]);
        if ($value === null) {
            $value = '';
        }
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_FIND_URL_MONIKER_VIA_ID($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[1])) {
        $value = find_id_moniker(array('page' => $param[0], 'type' => $param[1], 'id' => $param[1]), array_key_exists(2, $param) ? $param[2] : '');
        if ($value === null) {
            $value = '';
        }
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_FLOAT_FORMAT($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        $value = float_format(floatval($param[0]), isset($param[1]) ? intval($param[1]) : 2, array_key_exists(2, $param) && $param[2] == '1');
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_FORUM_BASE_URL($lang, $escaped, $param)
{
    $value = get_forum_base_url();

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_FORUM_CONTEXT($lang, $escaped, $param)
{
    global $SET_CONTEXT_FORUM;
    $value = is_null($SET_CONTEXT_FORUM) ? '' : strval($SET_CONTEXT_FORUM);

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_GEOLOCATE($lang, $escaped, $param)
{
    require_code('locations');

    $value = geolocate_ip(isset($param[0]) ? $param[0] : null);

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_GROUP_ID($lang, $escaped, $param)
{
    $value = '';

    $i = isset($param[0]) ? intval($param[0]) : 0;
    $groups = $GLOBALS['FORUM_DRIVER']->get_members_groups(isset($param[1]) ? intval($param[1]) : get_member());
    $value = array_key_exists($i, $groups) ? strval($groups[$i]) : '';

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_GROUP_NAME($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    $groups = $GLOBALS['FORUM_DRIVER']->get_members_groups(isset($param[1]) ? intval($param[1]) : get_member());
    $i = isset($param[0]) ? intval($param[0]) : 0;
    if (array_key_exists($i, $groups)) {
        $all_usergroups = $GLOBALS['FORUM_DRIVER']->get_usergroup_list();
        $value = $all_usergroups[$groups[$i]];
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_HAS_CATEGORY_ACCESS($lang, $escaped, $param)
{
    $value = '';

    if ((isset($param[0])) && (function_exists('has_category_access'))) {
        $value = has_category_access(((isset($param[2]))) ? intval($param[2]) : get_member(), $param[0], $param[1]) ? '1' : '0';
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_HAS_EDIT_PERMISSION($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[1])) {
        $range = strtolower($param[0]);
        $owner = intval($param[1]);
        $member = ((isset($param[2]))) ? intval($param[2]) : get_member();
        $cms_page = ((isset($param[3]))) ? $param[3] : get_page_name();
        if (array_key_exists(5, $param)) {
            $value = has_edit_permission($range, $member, $owner, $cms_page, array($param[4], $param[5])) ? '1' : '0';
        } else {
            $value = has_edit_permission($range, $member, $owner, $cms_page) ? '1' : '0';
        }
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_SUPPORTS_FRACTIONAL_EDITABLE($lang, $escaped, $param)
{
    $value = '0';
    if (isset($param[1])) {
        $edit_pagelink = $param[0];
        $has_permission = (isset($param[1]) ? $param[1] : null) === '1';

        list($zone, $attributes,) = page_link_decode($edit_pagelink);
        if ($zone == '_SEARCH') {
            $zone = get_module_zone($attributes['page']);
        }
        if ((has_actual_page_access(get_member(), $attributes['page'], $zone)) && (($has_permission === true) || (($has_permission === null) && (has_zone_access(get_member(), 'adminzone'))))) {
            $value = '1';
        }
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_HAS_FORUM($lang, $escaped, $param)
{
    if ((isset($param[0])) && ($param[0] == '1')) {
        $value = (get_forum_type() == 'none') ? '0' : '1';
    } else {
        $value = has_no_forum() ? '0' : '1';
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_HAS_PAGE_ACCESS($lang, $escaped, $param)
{
    $value = '';

    if ((isset($param[0])) && (function_exists('has_page_access'))) {
        if (!isset($param[1])) {
            $param[1] = '_SEARCH';
        }

        $value = has_page_access(((isset($param[2]))) ? intval($param[2]) : get_member(), $param[0], $param[1], ((isset($param[3]))) ? ($param[3] == '1') : false) ? '1' : '0';
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_HAS_SUBMIT_PERMISSION($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[0])) {
        $range = strtolower($param[0]);
        $ip_address = $param[1];
        $member = ((isset($param[2]))) ? intval($param[2]) : get_member();
        $cms_page = ((isset($param[3]))) ? $param[3] : get_page_name();
        if (array_key_exists(5, $param)) {
            $value = has_submit_permission($range, $member, $ip_address, $cms_page, array($param[5], $param[6])) ? '1' : '0';
        } else {
            $value = has_submit_permission($range, $member, $ip_address, $cms_page) ? '1' : '0';
        }
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_HTTP_STATUS_CODE($lang, $escaped, $param)
{
    global $HTTP_STATUS_CODE;
    $value = $HTTP_STATUS_CODE;

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_ISSET($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[0])) {
        global $TEMPCODE_SETGET;
        $value = (isset($TEMPCODE_SETGET[$param[0]])) ? '1' : '0';
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_IS_A_COOKIE_LOGIN($lang, $escaped, $param)
{
    global $IS_A_COOKIE_LOGIN;
    $value = ($IS_A_COOKIE_LOGIN && (ini_get('suhosin.cookie.max_name_length') !== '64')) ? '1' : '0';

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_IS_FRIEND($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[0])) {
        if (addon_installed('chat')) {
            $test = $GLOBALS['SITE_DB']->query_select_value_if_there('chat_friends', 'member_likes', array('member_likes' => isset($param[1]) ? intval($param[1]) : get_member(), 'member_liked' => intval($param[0])));
            $value = is_null($test) ? '0' : '1';
        } else {
            $value = '0';
        }
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_IS_VIRTUALISED_REQUEST($lang, $escaped, $param)
{
    $value = $GLOBALS['IS_VIRTUALISED_REQUEST'] ? '1' : '0';

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_LAST_VISIT_TIME($lang, $escaped, $param)
{
    $value = '';

    if (get_forum_type() == 'cns') {
        require_code('cns_general');
        $member_info = cns_read_in_member_profile(get_member(), true);
        $value = strval($member_info['last_visit_time']);
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_MEMBER_OVERRIDE($lang, $escaped, $param)
{
    $value = strval(get_member());

    if ((get_page_name() == 'members') && (get_param_string('type', 'browse') == 'view')) {
        $user = get_param_string('id', '');
        if (is_string($user)) {
            $member_id_of = $GLOBALS['FORUM_DRIVER']->get_member_from_username($user);
            if ($member_id_of !== null) {
                $value = strval($member_id_of);
            }
        } else {
            $value = $user;
        }
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_MOD($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[0])) {
        $value = strval(max(intval($param[0]), -intval($param[0])));
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_MULT($lang, $escaped, $param)
{
    $_value = 1.0;

    foreach ($param as $p) {
        $_value *= floatval(str_replace(',', '', $p));
    }

    $value = float_to_raw_string($_value, 20, true);

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_NEGATE($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[0])) {
        $value = strval(-intval($param[0]));
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_NO_SAFE_MODE($lang, $escaped, $param)
{
    $value = (str_replace(array('on', 'true', 'yes'), array('1', '1', '1'), strtolower(ini_get('safe_mode'))) == '1') ? '0' : '1';

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_NUMBER_FORMAT($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        $value = integer_format(intval($param[0]));
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_NUM_NEW_POSTS($lang, $escaped, $param)
{
    $value = '';

    if (get_forum_type() == 'cns') {
        require_code('cns_general');
        $member_info = cns_read_in_member_profile(get_member(), true);
        $_new_posts = $GLOBALS['FORUM_DB']->query('SELECT COUNT(*) AS mycnt FROM ' . $GLOBALS['FORUM_DB']->get_table_prefix() . 'f_posts WHERE p_cache_forum_id IS NOT NULL AND p_time>' . strval($member_info['last_visit_time']));
        $new_posts = $_new_posts[0]['mycnt'];
        $value = strval($new_posts);
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_NUM_NEW_TOPICS($lang, $escaped, $param)
{
    $value = '';

    if (get_forum_type() == 'cns') {
        require_code('cns_general');
        $member_info = cns_read_in_member_profile(get_member(), true);
        $_new_topics = $GLOBALS['FORUM_DB']->query('SELECT COUNT(*) AS mycnt FROM ' . $GLOBALS['FORUM_DB']->get_table_prefix() . 'f_topics WHERE t_forum_id IS NOT NULL AND t_cache_first_time>' . strval($member_info['last_visit_time']));
        $new_topics = $_new_topics[0]['mycnt'];
        $value = strval($new_topics);
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_NUM_RATINGS($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[1])) {
        global $DISPLAYED_TITLE;

        static $cache_num_ratings = array();
        $cache_key = serialize($param);
        if (isset($cache_num_ratings[$cache_key])) {
            $value = $cache_num_ratings[$cache_key];
        } else {
            require_code('feedback');
            $rating = get_rating_simple_array(empty($param[3]) ? get_self_url(true) : $param[3], empty($param[4]) ? (is_null($DISPLAYED_TITLE) ? '' : $DISPLAYED_TITLE->evaluate()) : $param[4], $param[0], $param[1], empty($param[5]) ? 'RATING_FORM' : $param[5], empty($param[2]) ? null : $param[2]);
            if ($rating !== null) {
                $value = $rating['ALL_RATING_CRITERIA'][key($rating['ALL_RATING_CRITERIA'])]['NUM_RATINGS'];
            }

            $cache_num_ratings[$cache_key] = $value;
        }
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_OBFUSCATE($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        require_code('obfuscate');
        $value = obfuscate_entities($param[0]);
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_CNS_MEMBER_HTML($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (get_forum_type() == 'cns') {
        require_code('cns_members');
        require_code('cns_members2');
        $_value = render_member_box(isset($param[0]) ? intval($param[0]) : get_member(), false, null, null, true, null, false);
        $value = $_value->evaluate();
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_OS($lang, $escaped, $param)
{
    $os = get_os_string();
    if (is_null($os)) {
        $os = '';
    }
    $value = $os;

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_PAD_LEFT($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[1])) {
        $value = str_pad($param[0], intval($param[1]), array_key_exists(2, $param) ? $param[2] : ' ', STR_PAD_LEFT);
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_PAD_RIGHT($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[1])) {
        $value = str_pad($param[0], intval($param[1]), array_key_exists(2, $param) ? $param[2] : ' ', STR_PAD_RIGHT);
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_POINTS_USED($lang, $escaped, $param)
{
    $value = '';

    if (addon_installed('points')) {
        require_code('points');
        $value = strval(points_used(isset($param[0]) ? intval($param[0]) : get_member()));
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_PREG_MATCH($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[1])) {
        $bak = $GLOBALS['SUPPRESS_ERROR_DEATH'];
        $GLOBALS['SUPPRESS_ERROR_DEATH'] = true;
        $value = (preg_match('#' . str_replace('#', '\#', $param[0]) . '#' . (isset($param[2]) ? str_replace('e', '', $param[2]) : ''), $param[1]) != 0) ? '1' : '0';
        $GLOBALS['SUPPRESS_ERROR_DEATH'] = $bak;
        if (isset($php_errormsg)) {
            attach_message($php_errormsg, 'warn');
        }
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_QUERY_STRING($lang, $escaped, $param)
{
    $value = cms_srv('QUERY_STRING');

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_REM($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[1])) {
        if (intval($param[1]) != 0) {
            $value = strval(intval($param[0]) % intval($param[1]));
        }
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_RESET_CYCLE($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[0])) {
        global $CYCLES;
        $CYCLES[$param[0]] = 0;
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_SECONDS_PERIOD($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        $value = display_seconds_period(intval($param[0]));
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_SESSION($lang, $escaped, $param)
{
    $value = get_session_id();

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_SESSION_HASHED($lang, $escaped, $param)
{
    $value = md5(get_session_id());

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_SET_TITLE($lang, $escaped, $param)
{
    if (isset($param[0])) {
        global $SHORT_TITLE, $FORCE_SET_TITLE;
        $SHORT_TITLE = $param[0];
        $FORCE_SET_TITLE = true;
    }

    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_SITE_SCOPE($lang, $escaped, $param)
{
    $value = get_option('site_scope');

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_SSW($lang, $escaped, $param)
{
    $value = (get_option('ssw') == '1') ? '1' : '0';

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_STAFF_ADDRESS($lang, $escaped, $param)
{
    require_code('obfuscate');
    $value = obfuscate_email_address(get_option('staff_address'));

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_STAFF_ADDRESS_PURE($lang, $escaped, $param)
{
    $value = get_option('staff_address');

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_STRPOS($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[1])) {
        $t_value = strpos($param[0], $param[1]);
        $value = ($t_value === false) ? '0' : strval($t_value);
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_TEMPCODE($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        require_code('tempcode_compiler');
        $_value = template_to_tempcode($param[0]);
        $value = $_value->evaluate();
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_TIMEZONE($lang, $escaped, $param)
{
    require_code('temporal2');
    $value = make_nice_timezone_name(get_site_timezone());

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_MATURITY_FILTER_REQUESTED($lang, $escaped, $param)
{
    $safe = '';
    if (function_exists('apache_request_headers')) {
        $headers = apache_request_headers();
        if (array_key_exists('prefer', $headers)) {
            $safe = $headers['prefer'];
        }
    } elseif (isset($_SERVER['HTTP_PREFER'])) {
        $safe = $_SERVER['HTTP_PREFER'];
    } elseif (isset($_ENV['HTTP_PREFER'])) {
        $safe = $_ENV['HTTP_PREFER'];
    }
    if (strtolower($safe) == 'safe') {
        return '1';
    }
    return '0';
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_TIME_PERIOD($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        $value = display_time_period(intval($param[0]));
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_TOTAL_POINTS($lang, $escaped, $param)
{
    $value = '';

    if (addon_installed('points')) {
        require_code('points');
        $value = strval(total_points(isset($param[0]) ? intval($param[0]) : get_member()));
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_TO_TIMESTAMP($lang, $escaped, $param)
{
    if (isset($param[0])) {
        $value = strval(strtotime($param[0]));
        if ((array_key_exists(1, $param)) && ($param[1] == '1')) {
            $value = strval(usertime_to_utctime(intval($value))); // '1' means date was in user-time so needs converting to a UTC timestamp
        }
    } else {
        $value = strval(time());
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_TRUNCATE_EXPAND($lang, $escaped, $param)
{
    $value = symbol_truncator($param, 'expand');

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_TRUNCATE_RIGHT($lang, $escaped, $param)
{
    $value = symbol_truncator($param, 'right');

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_TUTORIAL_URL($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        $value = get_tutorial_url($param[0]);
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_UCASE($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        if ((isset($param[1])) && ($param[1] == '1')) {
            $value = cms_mb_strtoupper(cms_mb_substr($param[0], 0, 1)) . cms_mb_substr($param[0], 1); // ucfirst
        } else {
            $value = cms_mb_strtoupper($param[0]);
        }
    }

    if ($GLOBALS['XSS_DETECT'] && ocp_is_escaped($param[0])) {
        ocp_mark_as_escaped($value);
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_USER_AGENT($lang, $escaped, $param)
{
    $value = cms_srv('HTTP_USER_AGENT');

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_IP_ADDRESS($lang, $escaped, $param)
{
    $value = get_ip_address();

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_VERSION($lang, $escaped, $param)
{
    $value = strval(cms_version());

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_VIEWS($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[2])) {
        $id_field = /*isset($param[4]) ? $param[4] : */'id'; // Not allowed on fields other than 'id', for security reasons
        if (preg_match('#^\w*views\w*$#', $param[1]) != 0) {
            $test = $GLOBALS['SITE_DB']->query_select_value_if_there($param[0], $param[1], array($id_field => $param[2]));
            if ($test !== null) {
                $value = integer_format($test);
            }
        }
    }

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_WCASE($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[0])) {
        $value = cms_mb_ucwords($param[0]);
    }

    if ($GLOBALS['XSS_DETECT'] && ocp_is_escaped($param[0])) {
        ocp_mark_as_escaped($value);
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_WORDWRAP($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if (isset($param[1])) {
        $cut = isset($param[3]) && ($param[3] == '1');
        $value = wordwrap($param[0], intval($param[1]), isset($param[2]) ? $param[2] : '<br />', $cut);
    }

    if ($GLOBALS['XSS_DETECT'] && ocp_is_escaped($param[0])) {
        ocp_mark_as_escaped($value);
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_XOR($lang, $escaped, $param)
{
    $count = 0;
    foreach ($param as $test) {
        if ($test == '1') {
            $count++;
        }
    }
    $value = ($count == 1) ? '1' : '0';

    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_ZONE_HEADER_TEXT($lang, $escaped, $param)
{
    $value = get_translated_text($GLOBALS['ZONE']['zone_header_text']);

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_SELF_PAGE_LINK($lang, $escaped, $param)
{
    $value = '';
    global $IN_SELF_ROUTING_SCRIPT;
    if ($IN_SELF_ROUTING_SCRIPT) {
        $value = get_zone_name() . ':' . get_page_name();
        foreach ($_GET as $key => $val) {
            if ($key == 'page' || is_array($val) || substr($key, 0, 5) == 'keep_') {
                continue;
            }
            $value .= ':' . $key . '=' . $val;
        }
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }

    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_SET_TUTORIAL_LINK($lang, $escaped, $param)
{
    $value = '';
    if ($GLOBALS['XSS_DETECT']) {
        ocp_mark_as_escaped($value);
    }

    if ((array_key_exists(1, $param)) && ($param[1] != '') && ($param[1][0] != '#')) {
        require_code('comcode_renderer');
        set_tutorial_link($param[0], $param[1]);
    }

    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_DISPLAY_CONCEPT($lang, $escaped, $param)
{
    $value = '';
    if (array_key_exists(0, $param)) {
        $key = $param[0];
        require_code('comcode_renderer');
        $_key = 'concept__' . preg_replace('#[^\w]#', '_', $key);
        $page_link = get_tutorial_link($_key);
        if (is_null($page_link)) {
            $temp_tpl = make_string_tempcode($key);
        } else {
            list($zone, $attributes, $hash) = page_link_decode($page_link);
            if ($zone == get_zone_name() && $attributes['page'] == get_page_name()) {
                $_url = make_string_tempcode('#' . $hash);
            } else {
                $_url = build_url($attributes, $zone, null, false, false, false, $hash);
            }
            $temp_tpl = do_template('COMCODE_CONCEPT', array('_GUID' => 'ee0cd05f87329923f05145180004d8a8', 'TEXT' => $key, 'URL' => $_url));
        }
        $value = $temp_tpl->evaluate();
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }

    return $value;
}

// These directives are all static evaluated during compilation, so don't need loading on each request.

/**
 * Evaluate a particular Tempcode directive.
 *
 * @ignore
 *
 * @param  string $value Value to write into.
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 */
function ecv2_CSS_INHERIT(&$value, $lang, $escaped, $param) // e.g. {+START,CSS_INHERIT,global,default,0,#886aa9}{+END}
{
    if (isset($param[0])) {
        require_code('css_and_js');

        $css_file = $param[0]->evaluate();
        $theme = isset($param[1]) ? $param[1]->evaluate() : 'default';
        $seed = isset($param[2]) ? $param[2]->evaluate() : null;
        if ($seed == '') {
            $seed = null;
        }
        $dark = isset($param[3]) ? ($param[3]->evaluate() == '1') : false;
        $algorithm = isset($param[4]) ? ($param[4]->evaluate()) : 'equations';

        $value = css_inherit($css_file, $theme, $GLOBALS['FORUM_DRIVER']->get_theme(), $seed, $dark, $algorithm);
    }
}

/**
 * Evaluate a particular Tempcode directive.
 *
 * @ignore
 *
 * @param  string $value Value to write into.
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 */
function ecv2_RECONTEXTUALISE_IDS(&$value, $lang, $escaped, $param)
{
    if (isset($param[1])) {
        $prefix = $param[0]->evaluate();
        $str = $param[1]->evaluate();
        $matches = array();
        $num_matches = preg_match_all('# id="([^"]*)"#', $str, $matches);
        for ($i = 0; $i < $num_matches; $i++) {
            $str = str_replace(' id="' . $matches[$i][1] . '"', ' id="' . $prefix . '_' . $matches[$i][1] . '"', $str);
            $str = str_replace(' for="' . $matches[$i][1] . '"', ' for="' . $prefix . '_' . $matches[$i][1] . '"', $str);
            $str = str_replace(' ById(\'' . $matches[$i][1] . '\')', ' ById(\'' . $prefix . '_' . $matches[$i][1] . '\')', $str);
            $str = str_replace(' ById("' . $matches[$i][1] . '\')', ' ById(\'' . $prefix . '_' . $matches[$i][1] . '")', $str);
        }
        $value = $str;
    }
}

// Uncommon directives

/**
 * Evaluate a particular Tempcode directive.
 *
 * @ignore
 *
 * @param  string $value Value to write into.
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 */
function ecv2_IF(&$value, $lang, $escaped, $param)
{
    if (isset($param[1])) {
        $_p = $param[0]->evaluate();
        if ($_p == '1') {
            $value = $param[1]->evaluate();
        }
    }
}

/**
 * Evaluate a particular Tempcode directive.
 *
 * @ignore
 *
 * @param  string $value Value to write into.
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 */
function ecv2_IF_EMPTY(&$value, $lang, $escaped, $param)
{
    if (isset($param[1])) {
        if ($param[0]->is_empty()) {
            $value = $param[1]->evaluate();
        }
    }
}

/**
 * Evaluate a particular Tempcode directive.
 *
 * @ignore
 *
 * @param  string $value Value to write into.
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 */
function ecv2_IF_NON_EMPTY(&$value, $lang, $escaped, $param)
{
    if (isset($param[1])) {
        if (!$param[0]->is_empty()) {
            $value = $param[1]->evaluate();
        }
    }
}

/**
 * Evaluate a particular Tempcode directive.
 *
 * @ignore
 *
 * @param  string $value Value to write into.
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 */
function ecv2_IF_PASSED(&$value, $lang, $escaped, $param)
{
    if (isset($param[1])) {
        $t = $param[0]->evaluate();
        if (isset($param['vars'][$t])) {
            $value = $param[1]->evaluate();
        }
    }
}

/**
 * Evaluate a particular Tempcode directive.
 *
 * @ignore
 *
 * @param  string $value Value to write into.
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 */
function ecv2_IF_NON_PASSED(&$value, $lang, $escaped, $param)
{
    if (isset($param[1])) {
        $t = $param[0]->evaluate();
        if (!isset($param['vars'][$t])) {
            $value = $param[1]->evaluate();
        }
    }
}

/**
 * Evaluate a particular Tempcode directive.
 *
 * @ignore
 *
 * @param  string $value Value to write into.
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 */
function ecv2_IF_PASSED_AND_TRUE(&$value, $lang, $escaped, $param)
{
    if (isset($param[1])) {
        $t = $param[0]->evaluate();
        if ((isset($param['vars'][$t])) && ($param['vars'][$t] !== false) && ($param['vars'][$t] === '1')) {
            $value = $param[1]->evaluate();
        }
    }
}

/**
 * Evaluate a particular Tempcode directive.
 *
 * @ignore
 *
 * @param  string $value Value to write into.
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 */
function ecv2_IF_NON_PASSED_OR_FALSE(&$value, $lang, $escaped, $param)
{
    if (isset($param[1])) {
        $t = $param[0]->evaluate();
        if ((!isset($param['vars'][$t])) || ($param['vars'][$t] === false) || ($param['vars'][$t] !== '1')) {
            $value = $param[1]->evaluate();
        }
    }
}

/**
 * Evaluate a particular Tempcode directive.
 *
 * @ignore
 *
 * @param  string $value Value to write into.
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 */
function ecv2_WHILE(&$value, $lang, $escaped, $param)
{
    if (isset($param[1])) {
        $_p = $param[0]->evaluate();
        if ($_p == '1') {
            $value = '';
            $value .= $param[1]->evaluate();
            $put = '';
            ecv2_WHILE($put, $lang, $escaped, $param);
            $value .= $put;
        }
    }
}

/**
 * Evaluate a particular Tempcode directive.
 *
 * @ignore
 *
 * @param  string $value Value to write into.
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 */
function ecv2_LOOP(&$value, $lang, $escaped, $param)
{
    if (isset($param[0])) {
        if (!array_key_exists($param[0]->evaluate(), $param['vars'])) {
            require_code('site');
            attach_message(do_lang_tempcode('MISSING_TEMPLATE_PARAMETER', $param[0]->evaluate(), '???'), 'warn');
            return;
        }

        $array_key = $param[0]->evaluate();
        if ((is_numeric($array_key)) || (strpos($array_key, ',') !== false)) {
            $array = array();
            foreach (explode(',', $array_key) as $x) {
                if (strpos($x, '=') !== false) {
                    list($key, $val) = explode('=', $x, 2);
                    $array[$key] = $val;
                } else {
                    $array[] = $x;
                }
            }
        } else {
            $array = array_key_exists($array_key, $param['vars']) ? $param['vars'][$array_key] : array();
            if (!is_array($array)) {
                $array = array();
            }
        }

        $value = '';
        if (array_key_exists(1 + 1, $param)) {
            $columns = $param[1]->evaluate();
            $row_starter = array_key_exists(2 + 1, $param) ? $param[2]->evaluate() : '<tr>';
            $row_terminator = array_key_exists(3 + 1, $param) ? $param[3]->evaluate() : '</tr>';
            $value .= $row_starter;

            // Sorting
            if (array_key_exists(4 + 1, $param)) {
                $sort_key = $param[4]->evaluate();

                $rev = ((array_key_exists(5 + 1, $param)) && ($param[5]->evaluate() == 'DESC'));
                if ($sort_key != '') {
                    sort_maps_by($array, $sort_key);
                }
                if ($rev) {
                    $array = array_reverse($array);
                }
            }
        }
        $last = count($param) - 2;
        $col = 0;
        $first = true;
        foreach ($array as $go_key => $go) {
            if (!is_array($go)) {
                $go = array('_loop_key' => make_string_tempcode(is_integer($go_key) ? strval($go_key) : $go_key), '_loop_var' => make_string_tempcode($go)); // In case it's not a list of maps, but just a list
            }

            if ((isset($param[2])) && ($col % $columns == 0) && ($col != 0)) {
                $value .= $row_starter;
            }
            $ps = $go + $param['vars'] + array('_loop_key' => make_string_tempcode(is_integer($go_key) ? strval($go_key) : $go_key), '_i' => strval($col), '_first' => $first, '_last' => $col == count($array) - 1);
            $bound = $param[$last]->bind($ps, '');
            $value .= $bound->evaluate();
            ++$col;
            if ((isset($param[3])) && ($col % $columns == 0)) {
                $value .= $row_terminator;
            }
            $first = false;
        }
        if ((isset($param[2])) && ($col % $columns != 0)) {
            $value .= $row_terminator;
        }
    }
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_TAPATALK($lang, $escaped, $param)
{
    $value = (defined('IN_MOBIQUO') ? '1' : '0');

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_AUTHOR_MEMBER($lang, $escaped, $param)
{
    $value = '';

    if (isset($param[0])) {
        if (addon_installed('authors')) {
            require_code('authors');
            $member_id = get_author_id_from_name($param[0]);
            if ($member_id === null) {
                $member_id = $GLOBALS['FORUM_DRIVER']->get_guest_id();
            }
            $value = strval($member_id);
        }
    }

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}

/**
 * Evaluate a particular Tempcode symbol.
 *
 * @ignore
 *
 * @param  LANGUAGE_NAME $lang The language to evaluate this symbol in (some symbols refer to language elements).
 * @param  array $escaped Array of escaping operations.
 * @param  array $param Parameters to the symbol. For all but directive it is an array of strings. For directives it is an array of Tempcode objects. Actually there may be template-style parameters in here, as an influence of singular_bind and these may be Tempcode, but we ignore them.
 * @return string The result.
 */
function ecv2_DECIMAL_POINT($lang, $escaped, $param)
{
    $value = '';

    $locale = localeconv();
    $value = $locale['decimal_point'];

    if ($escaped !== array()) {
        apply_tempcode_escaping($escaped, $value);
    }
    return $value;
}
