<?php

class Hook_symbol_HAS_TRIGGER_ACCESS
{
    /**
     * Run function for symbol hooks. Searches for tasks to perform.
     *
     * @param  array $param Symbol parameters
     * @return string Result
     */
    public function run($param)
    {
        $value = '0';

        if (isset($param[0])) {
            $change_tag = $param[0];

            if (get_value('change_tag_for_all__' . $change_tag) === '1') {
                return '1';
            }

            $access_code = get_param_string('keep_access_code', '');
            if ($access_code != '') {
                $early_access_code_rows = $GLOBALS['SITE_DB']->query_select('early_access_codes', array('c_num_views_assigned', 'c_num_views_used'), array('c_change_tag' => $change_tag, 'c_access_code' => $access_code), '', 1);
                if (!empty($early_access_code_rows)) {
                    $num_views_assigned = $early_access_code_rows[0]['c_num_views_assigned'];
                    $num_views_used = $early_access_code_rows[0]['c_num_views_used'];
                    if (($num_views_assigned === null) || ($num_views_used < $num_views_assigned)) {
                        return '1';
                    }
                }
            }
        }

        return $value;
    }
}
