<?php

function install_early_access()
{
    $GLOBALS['SITE_DB']->create_table('early_access_codes', array(
        'c_access_code' => '*ID_TEXT',
        'c_label' => 'SHORT_TEXT',
        'c_change_tag' => 'ID_TEXT',
        'c_num_views_assigned' => '?INTEGER',
        'c_num_views_used' => 'INTEGER',
        'c_created_by' => 'MEMBER',
        'c_creation_time' => 'TIME',
    ));

    $GLOBALS['SITE_DB']->create_table('early_access_code_content', array(
        'a_access_code' => '*ID_TEXT',
        'a_content_type' => '*ID_TEXT',
        'a_content_id' => '*ID_TEXT',
    ));
}

function check_has_special_page_access_for_unvalidated_content($validation_pass, $content_type, $content_id, &$method)
{
    $special_pass = false;
    if (get_value('allow_unvalidated_jump_hashes') === '1') {
        require_code('crypt');
        if (hash_equals($validation_pass, get_param_string('_validation_pass', ''))) {
            $special_pass = true;
            $method = 'validation_pass';
        }
    }
    if (!$special_pass) {
        $access_code = get_param_string('keep_access_code', '');
        if ($access_code != '') {
            $test = $GLOBALS['SITE_DB']->query_select_value_if_there('early_access_code_content', 'a_access_code', array('a_content_type' => $content_type, 'a_content_id' => $content_id, 'a_access_code' => $access_code));
            if ($test !== null) {
                $early_access_code_rows = $GLOBALS['SITE_DB']->query_select('early_access_codes', array('c_num_views_assigned', 'c_num_views_used'), array('c_access_code' => $access_code), '', 1);
                if (!empty($early_access_code_rows)) {
                    $num_views_assigned = $early_access_code_rows[0]['c_num_views_assigned'];
                    $num_views_used = $early_access_code_rows[0]['c_num_views_used'];
                    if (($num_views_assigned === null) || ($num_views_used < $num_views_assigned)) {
                        $special_pass = true;

                        $num_views_used++;

                        $early_access_code_message = 'You are using an early-access code to get a sneak peek on our data.';
                        if ($num_views_assigned !== null) {
                            $early_access_code_message .= ' You have used ' . integer_format($num_views_used) . ' of ' . integer_format($num_views_assigned) . ' page views for your code.';
                        }

                        $GLOBALS['SITE_DB']->query_update('early_access_codes', array('c_num_views_used' => $num_views_used), array('c_access_code' => $access_code), '', 1);

                        $method = 'early_access_code';

                        return protect_from_escaping($early_access_code_message);
                    } else {
                        warn_exit('You have used all ' . integer_format($num_views_assigned) . ' of the views for your early-access code.');
                    }
                }
            }
        }
    }

    if (has_privilege(get_member(), 'jump_to_unvalidated')) {
        if (!$special_pass) {
            $method = 'privilege';
        }

        if (get_value('allow_unvalidated_jump_hashes') === '1') {
            header('X-Composr-Preview-URL: ' . get_self_url(false, false, array('_validation_pass' => $validation_pass)));
        }
    } elseif (!$special_pass) {
        access_denied('PRIVILEGE', 'jump_to_unvalidated');
    }

    return do_lang_tempcode((get_param_integer('redirected', 0) == 1) ? 'UNVALIDATED_TEXT_NON_DIRECT' : 'UNVALIDATED_TEXT', $content_type);
}
