<?php

i_solemnly_declare(I_UNDERSTAND_SQL_INJECTION | I_UNDERSTAND_XSS | I_UNDERSTAND_PATH_INJECTION);

$title = get_screen_title('Early-access codes');
$title->evaluate_echo();

echo '<h2>Set up new access code</h2>';

// Deleting one?
$delete = post_param_string('delete', null);
if ($delete !== null) {
    $GLOBALS['SITE_DB']->query_delete('early_access_codes', array('c_access_code' => $delete), '', 1);

    attach_message('Deleted access code ' . $delete . '.', 'inform');
}

// Adding one?
$new_label = post_param_string('new_label', null);
if ($new_label !== null) {
    require_code('crypt');
    $new_access_code = get_rand_password();

    $new_change_tag = post_param_string('new_change_tag');

    $new_num_views_assigned = post_param_integer('new_num_views_assigned', null);

    $GLOBALS['SITE_DB']->query_insert('early_access_codes', array(
        'c_access_code' => $new_access_code,
        'c_label' => $new_label,
        'c_change_tag' => $new_change_tag,
        'c_num_views_assigned' => $new_num_views_assigned,
        'c_num_views_used' => 0,
        'c_created_by' => get_member(),
        'c_creation_time' => time(),
    ));

    foreach ($_POST['new_content_items'] as $new_content_item) {
        list($content_type, $content_id) = explode(':', $new_content_item, 2);

        $GLOBALS['SITE_DB']->query_insert('early_access_code_content', array(
            'a_access_code' => $new_access_code,
            'a_content_type' => $content_type,
            'a_content_id' => $content_id,
        ));
    }
}

// Default new to use the most recent, for easy cloning
$recent_access_code = $GLOBALS['SITE_DB']->query_select_value_if_there('early_access_codes', 'c_access_code', array(), 'ORDER BY c_creation_time DESC');
if (!empty($recent_access_code)) {
    $early_access_code_rows = $GLOBALS['SITE_DB']->query_select('early_access_codes', array('*'), array('c_access_code' => $recent_access_code), '', 1);
    $recent_change_tag = $early_access_code_rows[0]['c_change_tag'];
    $recent_num_views_assigned = $early_access_code_rows[0]['c_num_views_assigned'];

    $recent_content = $GLOBALS['SITE_DB']->query_select('early_access_code_content', array('a_content_type', 'a_content_id'), array('a_access_code' => $recent_access_code), 'ORDER BY a_content_type,a_content_id');
} else {
    $recent_change_tag = '';
    $recent_num_views_assigned = 100;

    $recent_content = null;
}

require_code('form_templates');
require_code('content');
require_code('zones2');

$fields = new Tempcode();

$fields->attach(form_input_line('Label', 'Label for access code. Only visible here.', 'new_label', '', true));

$fields->attach(form_input_codename('Change tag', 'A codename used in content code used to distinguish new changes, that this access code will activate.', 'new_change_tag', $recent_change_tag, false));

$fields->attach(form_input_integer('Number of views', 'The number of views to the site that are assigned. Blank for no limit.', 'new_num_views_assigned', $recent_num_views_assigned, false));

$list = new Tempcode();
$unvalidated_pages = $GLOBALS['SITE_DB']->query_select('comcode_pages', array('the_zone', 'the_page'), array('p_validated' => 0));
foreach ($unvalidated_pages as $page) {
    $content_id = $page['the_zone'] . ':' . $page['the_page'];
    list($content_title, , , , $content_url) = content_get_details('comcode_page', $content_id);
    list(, , $path) = find_comcode_page(get_site_default_lang(), $page['the_page'], $page['the_zone']);
    if (!empty($path)) {
        $content_title = get_comcode_page_title_from_disk($path);
    }

    if ($recent_content === null) {
        $selected = true;
    } else {
        $selected = false;
        foreach ($recent_content as $content) {
            if (($content['a_content_type'] == 'comcode_page') && ($content['a_content_id'] == $page['the_zone'] . ':' . $page['the_page'])) {
                $selected = true;
            }
        }
    }

    $list->attach(form_input_list_entry('comcode_page:' . $content_id, $selected, 'Page: ' . $content_title));
}
$unvalidated_news = $GLOBALS['SITE_DB']->query_select('news', array('id', 'title'), array('validated' => 0));
foreach ($unvalidated_news as $news) {
    if ($recent_content === null) {
        $selected = true;
    } else {
        $selected = false;
        foreach ($recent_content as $content) {
            if (($content['a_content_type'] == 'news') && ($content['a_content_id'] == strval($news['id']))) {
                $selected = true;
            }
        }
    }

    $list->attach(form_input_list_entry('news:' . strval($news['id']), $selected, 'Article: ' . get_translated_text($news['title'])));
}
// IDEA: Other content types (check_has_special_page_access_for_unvalidated_content will need hooking up too)
$fields->attach(form_input_multi_list('Content', 'Content the access code will provide early access for.', 'new_content_items', $list, null, 5, true));

$form = do_template('FORM', array('HIDDEN' => '', 'TEXT' => '', 'URL' => get_self_url(), 'FIELDS' => $fields, 'SUBMIT_ICON' => 'buttons__save', 'SUBMIT_NAME' => do_lang_tempcode('SAVE')));

$form->evaluate_echo();

echo '<h2>Existing codes</h2>';

$codes = $GLOBALS['SITE_DB']->query_select('early_access_codes', array('*'), array(), 'ORDER BY c_creation_time DESC');
if (empty($codes)) {
    echo '<p class="nothing_here">No codes set up yet</p>';
} else {
    echo '
        <table class="wide_table results_table columned_table autosized_table">
            <thead>
                <tr>
                    <th>Code</th>
                    <th>Label</th>
                    <th>Change tag</th>
                    <th>Content</th>
                    <th>Views</th>
                    <th>Created by</th>
                    <th>Created</th>
                    <th>Actions</th>
                </tr>
            </thead>

            <tbody>
    ';
    foreach ($codes as $row) {
        $_content = $GLOBALS['SITE_DB']->query_select('early_access_code_content', array('a_content_type', 'a_content_id'), array('a_access_code' => $row['c_access_code']), 'ORDER BY a_content_type,a_content_id');
        $content = '';
        foreach ($_content as $_content_item) {
            if ($content != '') {
                $content .= '<br />';
            }

            list($content_title, , $info, , $content_url) = content_get_details($_content_item['a_content_type'], $_content_item['a_content_id']);
            if ($_content_item['a_content_type'] == 'comcode_page') {
                list($zone, $page) = explode(':', $_content_item['a_content_id'], 2);
                list(, , $path) = find_comcode_page(get_site_default_lang(), $page, $zone);
                if (!empty($path)) {
                    $content_title = get_comcode_page_title_from_disk($path);
                }
            }
            if (strpos($content_url, '?') === false) {
                $content_url .= '?';
            } else {
                $content_url .= '&';
            }
            $content_url .= 'keep_access_code=' . urlencode($row['c_access_code']);

            $content .= '<a href="' . escape_html($content_url) . '">' . do_lang($info['content_type_label']) . ': ' . escape_html($content_title) . '</a>';
        }

        echo '
                <tr>
                    <td>' . escape_html($row['c_access_code']) . '</td>
                    <td>' . escape_html($row['c_label']) . '</td>
                    <td>' . escape_html($row['c_change_tag']) . '</td>
                    <td>' . $content . '</td>
                    <td>' . escape_html(integer_format($row['c_num_views_used']) . '/' . (($row['c_num_views_assigned'] === null) ? 'unlimited' : integer_format($row['c_num_views_assigned']))) . '</td>
                    <td>' . escape_html($GLOBALS['FORUM_DRIVER']->get_username($row['c_created_by'])) . '</td>
                    <td>' . escape_html(get_timezoned_date($row['c_creation_time'], false, false, false, true)) . '</td>
                    <td>
                        <form action="' . escape_html(get_self_url(true)) . '" method="post">
                            ' . static_evaluate_tempcode(symbol_tempcode('INSERT_SPAMMER_BLACKHOLE')) . '
                            <input type="hidden" name="delete" value="' . escape_html($row['c_access_code']) . '" />
                            <input type="image" src="' . escape_html(find_theme_image('icons/14x14/delete')) . '" title="Delete" />
                        </form>
                    </td>
                </tr>
        ';
    }
    echo '
            </tbody>
        </table>
    ';
}
