<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2012

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		core_feedback_features
 */

/**
 * Output the trackback script and handle trackbacks.
 */
function trackback_script()
{
	if (get_option('is_on_trackbacks')=='0') return;
	
	require_lang('trackbacks');

	header('Content-type: text/xml');

	$page=get_param('page');
	$id=get_param_integer('id');
	$mode=either_param('__mode','none');
	
	$allow_trackbacks=true;

	$hooks=find_all_hooks('systems','trackback');
	foreach (array_keys($hooks) as $hook)
	{
		if ($hook==$page)
		{
			require_code('hooks/systems/trackback/'.filter_naughty_harsh($hook));
			$object=object_factory('Hook_trackback_'.filter_naughty_harsh($hook),true);
			if (is_null($object)) continue;
			$allow_trackbacks=$object->run($id);
			break;
		}
	}

	if ($mode=='rss')
	{
		//List all the trackbacks to the specified page
		$xml=get_trackbacks($page,strval($id),$allow_trackbacks,'xml');
	}
	else
	{
		$time=get_param_integer('time');
		if ($time>time()-60*5) exit(); // Trackback link intentionally goes stale after 5 minutes, so it can't be statically stored and spam hammered

		//Add a trackback for the specified page
		$output=actualise_post_trackback($allow_trackbacks,$page,strval($id));
		
		if ($output) $xml=do_template('TRACKBACK_XML_NO_ERROR',array());
		else $xml=do_template('TRACKBACK_XML_ERROR',array('_GUID'=>'ac5e34aeabf92712607e62e062407861','TRACKBACK_ERROR'=>do_lang_tempcode('TRACKBACK_ERROR')));
	}
	

	$echo=do_template('TRACKBACK_XML_WRAPPER',array('_GUID'=>'cd8d057328569803a6cca9f8d37a0ac8','XML'=>$xml));
	$echo->evaluate_echo();
}

/**
 * Get the tempcode for the manipulation of the feedback fields for some content, if they are enabled in the Admin Zone.
 *
 * @param  boolean		Whether rating is currently/by-default allowed for this resource
 * @param  boolean		Whether comments are currently/by-default allowed for this resource
 * @param  ?boolean		Whether trackbacks are currently/by-default allowed for this resource (NULL: this resource does not support trackbacks regardless)
 * @param  boolean		Whether we're allowed to send trackbacks for this resource
 * @param  LONG_TEXT		The current/by-default notes for this content
 * @param  ?boolean		Whether reviews are currently/by-default allowed for this resource (NULL: no reviews allowed here)
 * @param  boolean		Whether the default values for the allow options is actually off (this determines how the tray auto-hides itself)
 * @param  boolean		If there's to be a notes field
 * @return tempcode		The feedback editing fields
 */
function feedback_fields($allow_rating,$allow_comments,$allow_trackbacks,$send_trackbacks,$notes,$allow_reviews=NULL,$default_off=false,$has_notes=true)
{
	if (get_value('disable_feedback')==='1') return new ocp_tempcode();

	require_code('feedback');
	require_code('form_templates');
	$fields=new ocp_tempcode();
	if (($send_trackbacks) && (get_option('is_on_trackbacks')=='1'))
	{
		require_lang('trackbacks');
		$fields->attach(form_input_line(do_lang_tempcode('SEND_TRACKBACKS'),do_lang_tempcode('DESCRIPTION_SEND_TRACKBACKS'),'send_trackbacks',get_param('trackback',''),false));
	}
	if (get_option('is_on_rating')=='1')
	{
		$fields->attach(form_input_tick(do_lang_tempcode('ALLOW_RATING'),do_lang_tempcode('DESCRIPTION_ALLOW_RATING'),'allow_rating',$allow_rating));
	}
	if (get_option('is_on_comments')=='1')
	{
		if (!is_null($allow_reviews))
		{
			$choices=new ocp_tempcode();
			$choices->attach(form_input_list_entry('0',!$allow_comments && !$allow_reviews,do_lang('NO')));
			$choices->attach(form_input_list_entry('1',$allow_comments && !$allow_reviews,do_lang('ALLOW_COMMENTS_ONLY')));
			$choices->attach(form_input_list_entry('2',$allow_reviews,do_lang('ALLOW_REVIEWS')));
			$fields->attach(form_input_list(do_lang_tempcode('ALLOW_COMMENTS'),do_lang_tempcode('DESCRIPTION_ALLOW_COMMENTS'),'allow_comments',$choices));
		} else
		{
			$fields->attach(form_input_tick(do_lang_tempcode('ALLOW_COMMENTS'),do_lang_tempcode('DESCRIPTION_ALLOW_COMMENTS'),'allow_comments',$allow_comments));
		}
	}
	if ((get_option('is_on_trackbacks')=='1') && (!is_null($allow_trackbacks)))
	{
		require_lang('trackbacks');
		$fields->attach(form_input_tick(do_lang_tempcode('ALLOW_TRACKBACKS'),do_lang_tempcode('DESCRIPTION_ALLOW_TRACKBACKS'),'allow_trackbacks',$allow_trackbacks));
	}
	if ((get_value('disable_staff_notes')!=='1') && ($has_notes))
		$fields->attach(form_input_text(do_lang_tempcode('NOTES'),do_lang_tempcode('DESCRIPTION_NOTES'),'notes',$notes,false));

	if (!$fields->is_empty())
	{
		if ($default_off)
		{
			$section_hidden=$notes=='' && !$allow_comments && (is_null($allow_trackbacks) || !$allow_trackbacks) && !$allow_rating;
		} else
		{
			$section_hidden=$notes=='' && $allow_comments && (is_null($allow_trackbacks) || $allow_trackbacks || (get_option('is_on_trackbacks')=='0')) && $allow_rating;
		}
		$_fields=do_template('FORM_SCREEN_FIELD_SPACER',array('SECTION_HIDDEN'=>$section_hidden,'TITLE'=>do_lang_tempcode((get_value('disable_staff_notes')!=='1')?'FEEDBACK_AND_NOTES':'_FEEDBACK')));
		$_fields->attach($fields);
		$fields=$_fields;
	}

	return $fields;
}

/**
 * Send a trackback to somebody else's website.
 *
 * @param  string			A comma-separated list of URLs to which we should trackback
 * @param  string			The article title
 * @param  string			The excerpt to send
 * @return boolean		Success?
*/
function send_trackbacks($_urls,$title,$excerpt)
{
	$urls=explode(',',$_urls);

	foreach ($urls as $url)
	{
		$url=trim($url);
		http_download_file($url,NULL,false,false,'ocPortal',array('url'=>get_custom_base_url(),'title'=>$title,'blog_name'=>get_site_name(),'excerpt'=>$excerpt));
	}

	return true; // To be honest, I can't be bothered to code a proper status return, and it wouldn't do anything, so I won't.
}

