<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2020

 See text/EN/licence.txt for full licencing information.

*/

/**
 * Hook class.
 */
class Hook_symbol_CONTENT_COUNT
{
    /**
     * Run function for symbol hooks. Searches for tasks to perform.
     *
     * @param  array $param Symbol parameters
     * @return string Result
     */
    public function run($param)
    {
        require_code('filtercode');

        $content_type = $param[0];
        $filter = $param[1];

        require_code('content');
        $object = get_content_object($content_type);
        $info = $object->info();

        $db = $info['connection'];

        require_code('filtercode');
        list($extra_select, $extra_join, $extra_where) = filtercode_to_sql($db, parse_filtercode($filter), $content_type);

        $count = $db->query_select_value($info['table'] . ' r' . implode('', $extra_join), 'COUNT(*)', [], $extra_where);

        $value = strval($count);

        return $value;
    }
}
