<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2012

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		catalogues
 */

class Block_main_recent_cc_entries
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']='Chris Graham';
		$info['organisation']='ocProducts';
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=2;
		$info['locked']=false;
		$info['parameters']=array('root','param','catalogue','zone','display_type');
		return $info;
	}

	/**
	 * Standard modular cache function.
	 *
	 * @return ?array	Map of cache details (cache_on and ttl) (NULL: module is disabled).
	 */
	function cacheing_environment()
	{
		$info=array();
		$info['cache_on']='array(((array_key_exists(\'root\',$map)) && ($map[\'root\']!=\'\'))?intval($map[\'root\']):NULL,array_key_exists(\'display_type\',$map)?$map[\'display_type\']:NULL,$GLOBALS[\'FORUM_DRIVER\']->get_members_groups(get_member(),false,true),array_key_exists(\'catalogue\',$map)?$map[\'catalogue\']:10,array_key_exists(\'param\',$map)?intval($map[\'param\']):10,array_key_exists(\'zone\',$map)?$map[\'zone\']:get_module_zone(\'catalogues\'))';
		$info['ttl']=60;
		return $info;
	}
	
	/**
	 * Standard modular run function.
	 *
	 * @param  array		A map of parameters.
	 * @return tempcode	The result of execution.
	 */
	function run($map)
	{
		require_code('catalogues');
		require_lang('catalogues');
		require_css('catalogues');

		$number=array_key_exists('param',$map)?intval($map['param']):10;
		$catalogue=array_key_exists('catalogue',$map)?$map['catalogue']:'faqs';
		$zone=array_key_exists('zone',$map)?$map['zone']:get_module_zone('catalogues');
		$root=((array_key_exists('root',$map)) && ($map['root']!=''))?intval($map['root']):NULL;

		$catalogues=$GLOBALS['SITE_DB']->query_select('catalogues',array('*'),array('c_name'=>$catalogue),'',1);
		if (!array_key_exists(0,$catalogues)) return do_lang_tempcode('MISSING_RESOURCE',escape_html($catalogue));
		$catalogue_row=$catalogues[0];
		$entries=$GLOBALS['SITE_DB']->query_select('catalogue_entries',array('*'),array('c_name'=>$catalogue,'ce_validated'=>1),'ORDER BY ce_add_date DESC',$number);
		$tpl_set=$catalogue;
		$_display_type=((array_key_exists('display_type',$map)) && ($map['display_type']!=''))?$map['display_type']:NULL;
		$display_type=mixed();
		if (!is_null($_display_type))
		{
			if (is_numeric($_display_type))
			{
				$display_type=intval($_display_type);
			} else
			{
				switch ($_display_type)
				{
					case 'FIELDMAPS':
						$display_type=C_DT_FIELDMAPS;
						break;
					case 'TITLELIST':
						$display_type=C_DT_TITLELIST;
						break;
					case 'TABULAR':
						$display_type=C_DT_TABULAR;
						break;
					case 'GRID':
						$display_type=C_DT_GRID;
						break;
				}
			}
		}
		list($content,,)=get_catalogue_category_entry_buildup(db_get_first_id() /* ignored */,$catalogue,$catalogue_row,'SEARCH',$tpl_set,$number,0,NULL,$root,$display_type,false,$entries);

		$catalogue_title=get_translated_text($catalogue_row['c_title']);

		if ($content->is_empty())
		{
			if ((has_actual_page_access(NULL,'cms_catalogues',NULL,NULL)) && (has_submit_permission('mid',get_member(),get_ip_address(),'cms_catalogues')))
			{
				$submit_url=build_url(array('page'=>'cms_catalogues','type'=>'add_entry','catalogue_name'=>$catalogue,'redirect'=>SELF_REDIRECT),get_module_zone('cms_catalogues'));
			} else $submit_url=new ocp_tempcode();
			return do_template('BLOCK_NO_ENTRIES',array('HIGH'=>false,'TITLE'=>do_lang_tempcode('RECENT',escape_html(integer_format($number)),escape_html($catalogue_title)),'MESSAGE'=>do_lang_tempcode('NO_ENTRIES'),'ADD_NAME'=>do_lang_tempcode('CATALOGUE_GENERIC_ADD',escape_html($catalogue_title)),'SUBMIT_URL'=>$submit_url));
		}

		return do_template('BLOCK_MAIN_RECENT_CC_ENTRIES',array('_GUID'=>'a57fa1b83d1b6fe3acbceb2b618e6d7f','CATALOGUE_TITLE'=>$catalogue_title,'CATALOGUE'=>$catalogue,'CONTENT'=>$content,'NUMBER'=>integer_format($number)));
	}

}


