<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		galleries
 */

class Block_main_best_sellers
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']='Manuprathap';
		$info['organisation']='ocProducts';
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=1;
		$info['locked']=true;
		$info['parameters']=array('param','product_type');
		return $info;
	}
	
	/**
	 * Standard modular cache function.
	 *
	 * @return ?array	Map of cache details (cache_on and ttl) (NULL: module is disabled).
	 */
	function cacheing_environment()
	{
		$info=array();
		$info['cache_on']='array(array_key_exists(\'param\',$map)?intval($map[\'param\']):5)';
		$info['ttl']=60*24;
		return $info;
	}
	
	/**
	 * Standard modular run function.
	 *
	 * @param  array		A map of parameters.
	 * @return tempcode	The result of execution.
	 */
	function run($map)
	{
		require_code('ecommerce');
		require_css('ecommerce');
		require_code('ocf_members2');

		$number=array_key_exists('param',$map)?intval($map['param']):5;
		$filter=array_key_exists('product_type',$map)?$map['product_type']:NULL;
			
		$_hooks 	=	find_all_hooks('systems','ecommerce');
		$sales	=	array();
		foreach (array_keys($_hooks) as $hook)
		{
			if(!is_null($filter) && $hook!=$filter)	continue;	
			require_code('hooks/systems/ecommerce/'.filter_naughty_harsh($hook));
			$payment_object = object_factory('Hook_'.$hook);
			
			if(method_exists($payment_object,'get_product_sales_data'))
			{
				$sales	=	$payment_object->get_product_sales_data()+$sales;
			}
		}

		//Sorting sales details array to decenting order	
		arsort($sales);
		$i=1;
		$sellers	=	array();
		foreach ($sales as $member=>$row)
		{
			$sellers[]	=	array('PROFILE_IMAGE'=>ocf_show_member_box($member,true,'100%',false,true),'MEMBER_NAME'=>$GLOBALS['FORUM_DRIVER']->get_username($member));
			if ($i==$number) break;
			$i++;
		}
		if (count($sellers)==0) return paragraph(do_lang_tempcode('NO_ENTRIES'),'','nothing_here');
		return do_template('BLOCK_MAIN_BEST_SELLERS',array('SELLERS'=>$sellers));
	}
}