<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2012

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		securitylogging
 */

class Hook_addon_registry_securitylogging
{

	/**
	 * Get a list of file permissions to set
	 *
	 * @return array			File permissions to set
	 */
	function get_chmod_array()
	{
		return array();
	}

	/**
	 * Get the version of ocPortal this addon is for
	 *
	 * @return float			Version number
	 */
	function get_version()
	{
		return ocp_version_number();
	}

	/**
	 * Get the description of the addon
	 *
	 * @return string			Description of the addon
	 */
	function get_description()
	{
		return 'Log/display security alerts.';
	}

	/**
	 * Get a mapping of dependency types
	 *
	 * @return array			File permissions to set
	 */
	function get_dependencies()
	{
		return array(
			'requires'=>array(),
			'recommends'=>array(),
			'conflicts_with'=>array(),
			'previously_in_addon'=>array('core_securitylogging'),
		);
	}

	/**
	 * Get a list of files that belong to this addon
	 *
	 * @return array			List of files
	 */
	function get_file_list()
	{
		return array(

			'sources/hooks/systems/realtime_rain/security.php',
			'sources/hooks/systems/addon_registry/securitylogging.php',
			'SECURITY_SCREEN.tpl',
			'SECURITY_ALERT_SCREEN.tpl',
			'adminzone/pages/modules/admin_security.php',
			'themes/default/images/bigicons/security.png',
			'themes/default/images/bigicons/securitylog.png',
			'themes/default/images/pagepics/securitylog.png',
			'HACK_ATTEMPT_MAIL.tpl',
			'adminzone/pages/modules/admin_ipban.php',
		);
	}


	/**
	* Get mapping between template names and the method of this class that can render a preview of them
	*
	* @return array			The mapping
	*/
	function tpl_previews()
	{
		return array(
				'SECURITY_SCREEN.tpl'=>'administrative__security_screen',
				'SECURITY_ALERT_SCREEN.tpl'=>'administrative__security_alert_screen',
				'HACK_ATTEMPT_MAIL.tpl'=>'administrative__hack_attempt_mail',
				'IPBAN_SCREEN.tpl'=>'ipban_screen',
				);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__ipban_screen()
	{
		return array(
			lorem_globalise(
				do_lorem_template('IPBAN_SCREEN',array(
					'PING_URL'=>placeholder_url(),
					'WARNING_DETAILS'=>'',
					'TITLE'=>lorem_title(),
					'BANS'=>placeholder_ip(),
					'LOCKED_BANS'=>placeholder_ip(),
					'URL'=>placeholder_url(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__administrative__hack_attempt_mail()
	{
		return array(
			lorem_globalise(
				do_lorem_template('HACK_ATTEMPT_MAIL',array(
					'STACK_TRACE'=>lorem_phrase(),
					'USER_AGENT'=>lorem_phrase(),
					'REFERER'=>lorem_phrase(),
					'USER_OS'=>lorem_phrase(),
					'REASON'=>lorem_phrase(),
					'IP'=>placeholder_ip(),
					'ID'=>placeholder_id(),
					'USERNAME'=>lorem_word_html(),
					'TIME_RAW'=>placeholder_date_raw(),
					'TIME'=>placeholder_date(),
					'URL'=>placeholder_url(),
					'POST'=>lorem_phrase(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__administrative__security_screen()
	{
		require_lang('security');
		return array(
			lorem_globalise(
				do_lorem_template('SECURITY_SCREEN',array(
					'TITLE'=>lorem_title(),
					'FAILED_LOGINS'=>placeholder_table(),
					'ALERTS'=>lorem_phrase(),
					'URL'=>placeholder_url(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__administrative__security_alert_screen()
	{
		require_lang('security');
		return array(
			lorem_globalise(
				do_lorem_template('SECURITY_ALERT_SCREEN',array(
					'TITLE'=>lorem_title(),
					'USER_AGENT'=>lorem_phrase(),
					'REFERER'=>lorem_phrase(),
					'USER_OS'=>lorem_phrase(),
					'REASON'=>lorem_phrase(),
					'IP'=>lorem_phrase(),
					'USERNAME'=>lorem_word_html(),
					'POST'=>lorem_phrase(),
					'URL'=>placeholder_url(),
						)
			),NULL,'',true),
		);
	}
}