<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2012

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		core
 */

class Hook_addon_registry_core
{

	/**
	 * Get a list of file permissions to set
	 *
	 * @return array			File permissions to set
	 */
	function get_chmod_array()
	{
		return array();
	}

	/**
	 * Get the version of ocPortal this addon is for
	 *
	 * @return float			Version number
	 */
	function get_version()
	{
		return ocp_version_number();
	}

	/**
	 * Get the description of the addon
	 *
	 * @return string			Description of the addon
	 */
	function get_description()
	{
		return '(Core ocPortal code)';
	}

	/**
	 * Get a mapping of dependency types
	 *
	 * @return array			File permissions to set
	 */
	function get_dependencies()
	{
		return array(
			'requires'=>array(),
			'recommends'=>array(),
			'conflicts_with'=>array(),
		);
	}

	/**
	 * Get a list of files that belong to this addon
	 *
	 * @return array			List of files
	 */
	function get_file_list()
	{
		return array(

			'sources/antispam.php',
			'sources/hooks/systems/notifications/spam_check_block.php',
			'sources/hooks/systems/notifications/low_disk_space.php',
			'sources/hooks/systems/notifications/hack_attack.php',
			'sources/hooks/systems/notifications/auto_ban.php',
			'sources/hooks/systems/notifications/error_occurred.php',
			'sources/hooks/systems/notifications/error_occurred_missing_resource.php',
			'sources/hooks/systems/notifications/error_occurred_missing_page.php',
			'sources/hooks/systems/notifications/error_occurred_cron.php',
			'sources/hooks/systems/notifications/error_occurred_missing_reference.php',
			'sources/hooks/systems/notifications/error_occurred_missing_reference_important.php',
			'sources/hooks/systems/notifications/adminzone_frontpage_accessed.php',
			'sources/password_strength.php',
			'sources/hooks/systems/snippets/password_strength.php',
			'web.config',
			'data/html5.js',
			'themes/default/images/bottom/ocpchat.png',
			'install.css',
			'lang/EN/installer.ini',
			'sources/group_member_timeouts.php',
			'sources/hooks/systems/cron/group_member_timeouts.php',
			'sources/inst_special.php',
			'sources/actionlog.php',
			'sources/hooks/systems/config_default/advanced_admin_cache.php',
			'sources/hooks/systems/config_default/fixed_width.php',
			'sources/hooks/systems/config_default/collapse_user_zones.php',
			'sources/hooks/systems/config_default/filesystem_caching.php',
			'sources/hooks/systems/config_default/url_monikers_enabled.php',
			'data/editarea/edit_area.css',
			'data/editarea/edit_area_compressor.php',
			'data/editarea/edit_area_full.js',
			'data/editarea/images/autocompletion.gif',
			'data/editarea/images/close.gif',
			'data/editarea/images/fullscreen.gif',
			'data/editarea/images/go_to_line.gif',
			'data/editarea/images/help.gif',
			'data/editarea/images/highlight.gif',
			'data/editarea/images/index.html',
			'data/editarea/images/load.gif',
			'data/editarea/images/move.gif',
			'data/editarea/images/newdocument.gif',
			'data/editarea/images/opacity.png',
			'data/editarea/images/processing.gif',
			'data/editarea/images/redo.gif',
			'data/editarea/images/reset_highlight.gif',
			'data/editarea/images/save.gif',
			'data/editarea/images/search.gif',
			'data/editarea/images/smooth_selection.gif',
			'data/editarea/images/spacer.gif',
			'data/editarea/images/statusbar_resize.gif',
			'data/editarea/images/undo.gif',
			'data/editarea/images/word_wrap.gif',
			'data/editarea/index.html',
			'data/editarea/langs/bg.js',
			'data/editarea/langs/cs.js',
			'data/editarea/langs/de.js',
			'data/editarea/langs/dk.js',
			'data/editarea/langs/en.js',
			'data/editarea/langs/eo.js',
			'data/editarea/langs/es.js',
			'data/editarea/langs/fi.js',
			'data/editarea/langs/fr.js',
			'data/editarea/langs/hr.js',
			'data/editarea/langs/index.html',
			'data/editarea/langs/it.js',
			'data/editarea/langs/ja.js',
			'data/editarea/langs/mk.js',
			'data/editarea/langs/nl.js',
			'data/editarea/langs/pl.js',
			'data/editarea/langs/pt.js',
			'data/editarea/langs/ru.js',
			'data/editarea/langs/sk.js',
			'data/editarea/langs/zh.js',
			'data/editarea/license_bsd.txt',
			'data/editarea/reg_syntax/css.js',
			'data/editarea/reg_syntax/html.js',
			'data/editarea/reg_syntax/js.js',
			'data/editarea/reg_syntax/php.js',
			'data/editarea/reg_syntax/xml.js',
			'data/editarea/template.html',
			'sources/hooks/systems/meta/index.html',
			'uploads/website_specific/index.html',
			'sources/hooks/systems/upon_page_load/index.html',
			'sources/hooks/systems/upon_access_denied/index.html',
			'sources/hooks/systems/upon_query/index.html',
			'sources/hooks/systems/upon_login/index.html',
			'sources/hooks/systems/login_providers/.htaccess',
			'sources/hooks/systems/login_providers/index.html',
			'sources/hooks/systems/login_providers/httpauth.php',
			'data/question_ui.php',
			'data/.htaccess',
			'data_custom/.htaccess',
			'sources/firephp.php',
			'sources/content.php',
			'adminzone/find_permissions.php',
			'JAVASCRIPT_SOUND.tpl',
			'INLINE_WIP_MESSAGE.tpl',
			'colour_picker.css',
			'themes/default/css_custom/.htaccess',
			'themes/default/images_custom/.htaccess',
			'themes/default/templates_cached/.htaccess',
			'themes/default/images_custom/index.html',
			'themes/default/images/colour_picker/hue_bg.png',
			'themes/default/images/colour_picker/hue_thumb.png',
			'themes/default/images/colour_picker/index.html',
			'themes/default/images/colour_picker/picker_mask.png',
			'themes/default/images/colour_picker/picker_thumb.png',
			'themes/default/images/exp_con.png',
			'themes/default/images/help_jumpout.png',
			'themes/default/images/help_panel_show.png',
			'themes/default/images/am_icons/index.html',
			'themes/default/images/am_icons/notice.png',
			'themes/default/images/am_icons/inform.png',
			'themes/default/images/am_icons/warn.png',
			'themes/default/images/am_icons/inform_large.png',
			'themes/default/images/am_icons/warn_large.png',
			'themes/default/images/arrow_ruler.png',
			'themes/default/images/arrow_ruler_small.png',
			'themes/default/images/outer-background.jpg',
			'themes/default/images/inner-background.jpg',
			'themes/default/images/block-background.png',
			'themes/default/images/header.png',
			'pages/comcode/EN/panel_top.txt',
			'lang/EN/dearchive.ini',
			'sources/hooks/modules/admin_config/.htaccess',
			'sources/hooks/modules/admin_config/index.html',
			'sources/ocfiltering.php',
			'MISSING_SCREEN.tpl',
			'PARAM_INFO.tpl',
			'sources/temporal.php',
			'sources/temporal2.php',
			'sources/blocks/main_comcode_page_children.php',
			'sources/blocks/main_include_module.php',
			'themes/default/images/filetypes/email_link.png',
			'themes/default/images/filetypes/external_link.png',
			'themes/default/images/filetypes/feed.png',
			'themes/default/images/filetypes/index.html',
			'themes/default/images/filetypes/page_archive.png',
			'themes/default/images/filetypes/page_doc.png',
			'themes/default/images/filetypes/page_media.png',
			'themes/default/images/filetypes/page_odp.png',
			'themes/default/images/filetypes/page_ods.png',
			'themes/default/images/filetypes/page_odt.png',
			'themes/default/images/filetypes/page_pdf.png',
			'themes/default/images/filetypes/page_ppt.png',
			'themes/default/images/filetypes/page_torrent.png',
			'themes/default/images/filetypes/page_txt.png',
			'themes/default/images/filetypes/page_xls.png',
			'data/autosave.php',
			'adminzone/pages/comcode/EN/panel_top.txt',
			'cms/pages/comcode/EN/panel_top.txt',
			'sources/hooks/systems/addon_registry/core.php',
			'sources/hooks/systems/non_active_urls/.htaccess',
			'sources/hooks/systems/non_active_urls/index.html',
			'sources/hooks/systems/addon_registry/index.html',
			'sources/hooks/blocks/main_notes/.htaccess',
			'sources/hooks/blocks/main_notes/index.html',
			'sources/hooks/systems/chmod/.htaccess',
			'sources/hooks/systems/chmod/index.html',
			'sources/hooks/systems/disposable_values/.htaccess',
			'sources/hooks/systems/disposable_values/index.html',
			'sources/hooks/systems/special_cpf/.htaccess',
			'sources/hooks/systems/special_cpf/index.html',
			'sources/hooks/systems/symbols/.htaccess',
			'sources/hooks/systems/symbols/index.html',
			'sources/url_remappings.php',
			'sources/hooks/systems/addon_registry/.htaccess',
			'data/quick_js_loader.js',
			'ZONE_CHOOSE.tpl',
			'ZONE_CHOOSE_INLINE.tpl',
			'JOIN_OR_LOGIN.tpl',
			'JAVASCRIPT.tpl',
			'JAVASCRIPT_AJAX.tpl',
			'JAVASCRIPT_NEED.tpl',
			'JAVASCRIPT_NEED_INLINE.tpl',
			'JAVASCRIPT_STAFF.tpl',
			'JAVASCRIPT_THUMBNAILS.tpl',
			'JAVASCRIPT_DRAGDROP.tpl',
			'JAVASCRIPT_MORE.tpl',
			'JAVASCRIPT_TREE_LIST.tpl',
			'JAVASCRIPT_XSL_MOPUP.tpl',
			'JAVASCRIPT_YAHOO.tpl',
			'JAVASCRIPT_YAHOO_2.tpl',
			'JAVASCRIPT_COLOUR_PICKER.tpl',
			'JAVASCRIPT_YAHOO_EVENTS.tpl',
			'BLOCK_SIDE_PERSONAL_STATS_LINE_COMPLEX.tpl',
			'BLOCK_SIDE_PERSONAL_STATS.tpl',
			'BLOCK_SIDE_PERSONAL_STATS_LINE.tpl',
			'BLOCK_SIDE_PERSONAL_STATS_LINK.tpl',
			'BLOCK_SIDE_PERSONAL_STATS_LINK_2.tpl',
			'BLOCK_SIDE_PERSONAL_STATS_LOGOUT.tpl',
			'BLOCK_SIDE_PERSONAL_STATS_NO.tpl',
			'LOGIN_REDIRECT_SCREEN.tpl',
			'LOGIN_SCREEN.tpl',
			'login.css',
			'BLOCK_SIDE_ZONE_JUMP.tpl',
			'CSS_NEED.tpl',
			'CSS_NEED_INLINE.tpl',
			'BROKEN_LANG_STRINGS.tpl',
			'BROKEN_URLS.tpl',
			'FORUMS_EMBED.tpl',
			'ACTION_LOGS_SCREEN.tpl',
			'ACTION_LOGS_TOGGLE_LINK.tpl',
			'FORUM_ATTACHMENT_IMAGE.tpl',
			'FORUM_ATTACHMENT_IMAGE_THUMB.tpl',
			'FORUM_ATTACHMENT_LINK.tpl',
			'LOOKUP_IP_LIST_ENTRY.tpl',
			'LOOKUP_SCREEN.tpl',
			'FATAL_SCREEN.tpl',
			'STACK_TRACE_HYPER_WRAP.tpl',
			'STACK_TRACE_LINE.tpl',
			'STACK_TRACE_WRAP.tpl',
			'BLOCK_MAIN_EMOTICON_CODES_ENTRY.tpl',
			'BLOCK_MAIN_EMOTICON_CODES.tpl',
			'BLOCK_MAIN_SITEMAP.tpl',
			'BLOCK_MAIN_SITEMAP_NEST.tpl',
			'BLOCK_NO_ENTRIES.tpl',
			'adminzone/index.php',
			'adminzone/pages/comcode/.htaccess',
			'adminzone/pages/comcode/EN/.htaccess',
			'adminzone/pages/comcode/EN/index.html',
			'adminzone/pages/comcode/EN/start.txt',
			'adminzone/pages/comcode/index.html',
			'adminzone/pages/comcode_custom/.htaccess',
			'adminzone/pages/comcode_custom/EN/.htaccess',
			'adminzone/pages/comcode_custom/EN/index.html',
			'adminzone/pages/comcode_custom/index.html',
			'adminzone/pages/html/.htaccess',
			'adminzone/pages/html/EN/.htaccess',
			'adminzone/pages/html/EN/index.html',
			'adminzone/pages/html/index.html',
			'adminzone/pages/html_custom/EN/index.html',
			'adminzone/pages/html_custom/index.html',
			'adminzone/pages/html_custom/EN/.htaccess',
			'adminzone/pages/index.html',
			'adminzone/pages/minimodules/.htaccess',
			'adminzone/pages/minimodules/index.html',
			'adminzone/pages/minimodules_custom/.htaccess',
			'adminzone/pages/minimodules_custom/index.html',
			'adminzone/pages/modules/.htaccess',
			'adminzone/pages/modules/admin.php',
			'themes/default/images/keyboard.png',
			'themes/default/images/admin-search.png',
			'ocp_sitemap.xml',
			'sources/sitemap.php',
			'data/force_sitemap_generation.php',
			'sources/hooks/systems/cron/sitemap.php',
			'IPBAN_SCREEN.tpl',
			'LOOKUP_IP_LIST_GROUP.tpl',
			'BLOCK_MAIN_COMCODE_PAGE_CHILDREN.tpl',
			'adminzone/pages/modules/admin_lookup.php',
			'adminzone/pages/modules/admin_version.php',
			'adminzone/pages/modules/index.html',
			'adminzone/pages/modules_custom/.htaccess',
			'adminzone/pages/modules_custom/index.html',
			'text/.htaccess',
			'text/bots.txt',
			'text/EN/.htaccess',
			'text/EN/index.html',
			'text/EN/licence.txt',
			'text/EN/too_common_words.txt',
			'text/EN/word_characters.txt',
			'text/index.html',
			'text_custom/.htaccess',
			'text_custom/EN/.htaccess',
			'text_custom/EN/index.html',
			'text_custom/index.html',
			'safe_mode_temp/.htaccess',
			'safe_mode_temp/index.html',
			'config_editor.php',
			'index.php',
			'info.php',
			'uploads/auto_thumbs/index.html',
			'uploads/auto_thumbs/.htaccess',
			'exports/file_backups/.htaccess',
			'uploads/index.html',
			'sources_custom/.htaccess',
			'sources_custom/blocks/.htaccess',
			'sources_custom/blocks/index.html',
			'sources_custom/hooks/.htaccess',
			'sources_custom/hooks/blocks/.htaccess',
			'sources_custom/hooks/blocks/index.html',
			'sources_custom/hooks/index.html',
			'sources_custom/hooks/modules/.htaccess',
			'sources_custom/hooks/modules/index.html',
			'sources_custom/hooks/systems/.htaccess',
			'sources_custom/hooks/systems/index.html',
			'sources_custom/index.html',
			'sources_custom/miniblocks/.htaccess',
			'sources_custom/miniblocks/index.html',
			'lang/index.html',
			'lang/langs.ini',
			'lang/map.ini',
			'lang_cached/.htaccess',
			'lang_cached/EN/.htaccess',
			'lang_cached/EN/index.html',
			'lang_cached/index.html',
			'lang_custom/.htaccess',
			'lang_custom/EN/.htaccess',
			'lang_custom/EN/index.html',
			'lang_custom/index.html',
			'adminzone.css',
			'global.css',
			'themes/default/css/index.html',
			'no_cache.css',
			'data/editarea/reg_syntax/index.html',
			'themes/default/images/pagepics/export.png',
			'themes/default/images/pagepics/email.png',
			'side_blocks.css',
			'themes/default/css_custom/index.html',
			'themes/default/index.html',
			'themes/default/templates/.htaccess',
			'themes/default/templates/index.html',
			'themes/default/templates_cached/EN/index.html',
			'themes/default/templates_cached/index.html',
			'themes/default/templates_custom/.htaccess',
			'themes/default/templates_custom/index.html',
			'themes/default/theme.ini',
			'themes/index.html',
			'themes/map.ini',
			'sources/hooks/systems/module_permissions/.htaccess',
			'sources/hooks/systems/module_permissions/forums.php',
			'sources/hooks/systems/module_permissions/index.html',
			'lang/EN/permissions.ini',
			'sources/permissions.php',
			'sources/permissions2.php',
			'themes/default/images/arrow_box.png',
			'themes/default/images/arrow_box_hover.png',
			'themes/default/images/background_image.png',
			'themes/default/images/bigicons/import.png',
			'themes/default/images/bigicons/export.png',
			'themes/default/images/bigicons/add_one.png',
			'themes/default/images/bigicons/add_one_category.png',
			'themes/default/images/bigicons/add_one_image.png',
			'themes/default/images/bigicons/add_to_category.png',
			'themes/default/images/bigicons/admin_home.png',
			'themes/default/images/bigicons/back.png',
			'themes/default/images/bigicons/baseconfig.png',
			'themes/default/images/bigicons/cms_home.png',
			'themes/default/images/bigicons/delete.png',
			'themes/default/images/bigicons/edit_one.png',
			'themes/default/images/bigicons/edit_one_category.png',
			'themes/default/images/bigicons/edit_this.png',
			'themes/default/images/bigicons/edit_this_category.png',
			'themes/default/images/bigicons/index.html',
			'themes/default/images/bigicons/investigateuser.png',
			'themes/default/images/bigicons/ipban.png',
			'themes/default/images/bigicons/main_home.png',
			'themes/default/images/bigicons/merge.png',
			'themes/default/images/bigicons/move.png',
			'themes/default/images/bigicons/ocp-logo.png',
			'themes/default/images/bigicons/pagewizard.png',
			'themes/default/images/bigicons/usergroups.png',
			'themes/default/images/bigicons/view_archive.png',
			'themes/default/images/bigicons/view_this.png',
			'themes/default/images/bigicons/view_this_category.png',
			'themes/default/images/blank.gif',
			'themes/default/images/bottom/home.png',
			'themes/default/images/bottom/index.html',
			'themes/default/images/bottom/loading.gif',
			'themes/default/images/bottom/sitemap.png',
			'themes/default/images/bottom/top.png',
			'themes/default/images/contract.png',
			'themes/default/images/donext/index.html',
			'themes/default/images/donext/botleft.png',
			'themes/default/images/donext/botmid.png',
			'themes/default/images/donext/botright.png',
			'themes/default/images/donext/midleft.png',
			'themes/default/images/donext/midright.png',
			'themes/default/images/donext/titleleft.png',
			'themes/default/images/donext/titleright.png',
			'themes/default/images/donext/topcent.png',
			'themes/default/images/donext/topleft.png',
			'themes/default/images/donext/topright.png',
			'themes/default/images/edited.png',
			'themes/default/images/comcode.png',
			'themes/default/images/EN/index.html',
			'themes/default/images/EN/logo/-logo.png',
			'themes/default/images/EN/logo/index.html',
			'themes/default/images/EN/logo/trimmed-logo.png',
			'themes/default/images/EN/page/advanced.png',
			'themes/default/images/EN/page/all.png',
			'themes/default/images/EN/page/all2.png',
			'themes/default/images/EN/page/amend.png',
			'themes/default/images/EN/page/changes.png',
			'themes/default/images/EN/page/closed.png',
			'themes/default/images/EN/page/delete.png',
			'themes/default/images/EN/page/edit.png',
			'themes/default/images/EN/page/index.html',
			'themes/default/images/EN/page/login.png',
			'themes/default/images/EN/page/new.png',
			'themes/default/images/EN/page/next.png',
			'themes/default/images/EN/page/slideshow.png',
			'themes/default/images/EN/page/no_next.png',
			'themes/default/images/EN/page/no_previous.png',
			'themes/default/images/EN/page/previous.png',
			'themes/default/images/EN/page/rename.png',
			'themes/default/images/EN/page/simple.png',
			'themes/default/images/EN/pageitem/choose.png',
			'themes/default/images/EN/pageitem/delete.png',
			'themes/default/images/EN/pageitem/edit.png',
			'themes/default/images/EN/pageitem/export.png',
			'themes/default/images/EN/pageitem/goto.png',
			'themes/default/images/EN/pageitem/history.png',
			'themes/default/images/EN/pageitem/index.html',
			'themes/default/images/EN/pageitem/more.png',
			'themes/default/images/EN/pageitem/move.png',
			'themes/default/images/EN/pageitem/rename.png',
			'themes/default/images/EN/pageitem/restore.png',
			'themes/default/images/EN/pageitem/unvalidate.png',
			'themes/default/images/EN/pageitem/validate.png',
			'themes/default/images/EN/pageitem/punish.png',
			'themes/default/images/EN/page/cancel.png',
			'themes/default/images/EN/page/close.png',
			'themes/default/images/EN/page/convert.png',
			'themes/default/images/EN/page/discard.png',
			'themes/default/images/EN/page/ignore.png',
			'themes/default/images/EN/page/no.png',
			'themes/default/images/EN/page/ok.png',
			'themes/default/images/expand.png',
			'themes/default/images/help.png',
			'themes/default/images/help_panel_hide.png',
			'themes/default/images/index.html',
			'themes/default/images/led_off.png',
			'themes/default/images/led_on.png',
			'themes/default/images/na.png',
			'themes/default/images/poll/index.html',
			'themes/default/images/poll/poll_l.png',
			'themes/default/images/poll/poll_m.gif',
			'themes/default/images/poll/poll_r.png',
			'themes/default/images/rating.png',
			'themes/default/images/results/index.html',
			'themes/default/images/results/sortablefield_asc.png',
			'themes/default/images/results/sortablefield_desc.png',
			'themes/default/images/results/sortablefield_asc_nonselected.png',
			'themes/default/images/results/sortablefield_desc_nonselected.png',
			'themes/default/images/standardboxes/bottom_left.png',
			'themes/default/images/standardboxes/bottom_right.png',
			'themes/default/images/standardboxes/index.html',
			'themes/default/images/standardboxes/nontitle_left.png',
			'themes/default/images/standardboxes/nontitle_right.png',
			'themes/default/images/standardboxes/title_gradient.png',
			'themes/default/images/standardboxes/title_left.png',
			'themes/default/images/standardboxes/title_right.png',
			'themes/default/images/tab.png',
			'themes/default/images/tableitem/delete.png',
			'themes/default/images/tableitem/download.png',
			'themes/default/images/tableitem/edit.png',
			'themes/default/images/tableitem/index.html',
			'themes/default/images/top.png',
			'themes/default/images/treefield/category.png',
			'themes/default/images/treefield/entry.png',
			'themes/default/images/treefield/index.html',
			'themes/default/images/treefield/minus.png',
			'themes/default/images/treefield/plus.png',
			'themes/default/images/treenav.png',
			'themes/default/images/underline.gif',
			'themes/default/images/zone_gradient.png',
			'themes/default/images/pagepics/index.html',
			'themes/default/images/pagepics/investigateuser.png',
			'themes/default/images/pagepics/ipban.png',
			'themes/default/images/pagepics/ocp-logo.png',
			'themes/default/images/pagepics/ocpmainpage.png',
			'sources/hooks/systems/startup/index.html',
			'data/confirm_session.php',
			'data/cron_bridge.php',
			'data/curl-ca-bundle.crt',
			'data/db_meta.dat',
			'data/empty.html',
			'data/files.dat',
			'data/files_previous.dat',
			'data/guids.dat',
			'data/iframe.php',
			'data/images/index.html',
			'data/index.html',
			'data/javascript.php',
			'data/modules/index.html',
			'data/pagelink_redirect.php',
			'data/quash_referer.php',
			'data/sheet.php',
			'data/site_tree.php',
			'data/snippet.php',
			'data/soundmanager2.swf',
			'data/soundmanager2_flash9.swf',
			'data/soundmanager2_flash9_debug.swf',
			'data/soundmanager2_debug.swf',
			'data/sounds/index.html',
			'data_custom/execute_temp.php',
			'data_custom/functions.dat',
			'data_custom/index.html',
			'data_custom/modules/index.html',
			'cms/index.php',
			'cms/pages/comcode/.htaccess',
			'cms/pages/comcode/EN/.htaccess',
			'cms/pages/comcode/EN/index.html',
			'cms/pages/comcode/index.html',
			'cms/pages/comcode_custom/.htaccess',
			'cms/pages/comcode_custom/EN/.htaccess',
			'cms/pages/comcode_custom/EN/index.html',
			'cms/pages/comcode_custom/index.html',
			'cms/pages/html/.htaccess',
			'cms/pages/html/EN/.htaccess',
			'cms/pages/html/EN/index.html',
			'cms/pages/html/index.html',
			'cms/pages/html_custom/EN/.htaccess',
			'cms/pages/html_custom/EN/index.html',
			'cms/pages/html_custom/index.html',
			'cms/pages/index.html',
			'cms/pages/minimodules/.htaccess',
			'cms/pages/minimodules/index.html',
			'cms/pages/minimodules_custom/.htaccess',
			'cms/pages/minimodules_custom/index.html',
			'cms/pages/modules/.htaccess',
			'cms/pages/modules/cms.php',
			'cms/pages/modules/index.html',
			'cms/pages/modules_custom/.htaccess',
			'cms/pages/modules_custom/index.html',
			'lang/.htaccess',
			'lang/EN/.htaccess',
			'lang/EN/abstract_file_manager.ini',
			'lang/EN/blocks.ini',
			'lang/EN/critical_error.ini',
			'lang/EN/dates.ini',
			'lang/EN/debrand.ini',
			'lang/EN/do_next.ini',
			'lang/EN/global.ini',
			'lang/EN/index.html',
			'lang/EN/javascript.ini',
			'lang/EN/lang.ini',
			'lang/EN/mail.ini',
			'lang/EN/profiling.ini',
			'lang/EN/security.ini',
			'lang/EN/submitban.ini',
			'lang/EN/version.ini',
			'lang/EN/zones.ini',
			'pages/comcode/.htaccess',
			'pages/comcode/EN/.htaccess',
			'pages/comcode/EN/404.txt',
			'pages/comcode/EN/index.html',
			'pages/comcode/EN/keymap.txt',
			'pages/comcode/EN/panel_left.txt',
			'pages/comcode/EN/panel_right.txt',
			'pages/comcode/EN/privacy.txt',
			'pages/comcode/EN/rules.txt',
			'pages/comcode/EN/sitemap.txt',
			'pages/comcode/EN/start.txt',
			'pages/comcode/index.html',
			'pages/comcode_custom/.htaccess',
			'pages/comcode_custom/EN/.htaccess',
			'pages/comcode_custom/EN/index.html',
			'pages/comcode_custom/index.html',
			'pages/html/.htaccess',
			'pages/html/EN/.htaccess',
			'pages/html/EN/index.html',
			'pages/html/index.html',
			'pages/html_custom/EN/.htaccess',
			'pages/html_custom/EN/index.html',
			'pages/html_custom/index.html',
			'pages/index.html',
			'pages/minimodules/.htaccess',
			'pages/minimodules/index.html',
			'pages/minimodules_custom/.htaccess',
			'pages/minimodules_custom/index.html',
			'pages/modules/.htaccess',
			'pages/modules/forums.php',
			'pages/modules/index.html',
			'pages/modules/login.php',
			'pages/modules_custom/.htaccess',
			'pages/modules_custom/index.html',
			'site/index.php',
			'site/pages/comcode/.htaccess',
			'site/pages/comcode/EN/.htaccess',
			'site/pages/comcode/EN/index.html',
			'site/pages/comcode/EN/panel_left.txt',
			'site/pages/comcode/EN/panel_right.txt',
			'site/pages/comcode/EN/start.txt',
			'site/pages/comcode/EN/userguide_comcode.txt',
			'site/pages/comcode/index.html',
			'site/pages/comcode_custom/.htaccess',
			'site/pages/comcode_custom/EN/.htaccess',
			'site/pages/comcode_custom/EN/index.html',
			'site/pages/comcode_custom/index.html',
			'site/pages/html/.htaccess',
			'site/pages/html/EN/.htaccess',
			'site/pages/html/EN/index.html',
			'site/pages/html/index.html',
			'site/pages/html_custom/EN/.htaccess',
			'site/pages/html_custom/EN/index.html',
			'site/pages/html_custom/index.html',
			'site/pages/index.html',
			'site/pages/minimodules/.htaccess',
			'site/pages/minimodules/index.html',
			'site/pages/minimodules_custom/.htaccess',
			'site/pages/minimodules_custom/index.html',
			'site/pages/modules/.htaccess',
			'site/pages/modules/index.html',
			'site/pages/modules_custom/.htaccess',
			'site/pages/modules_custom/index.html',
			'sources/.htaccess',
			'sources/abstract_file_manager.php',
			'sources/aed_module.php',
			'sources/ajax.php',
			'sources/blocks/.htaccess',
			'sources/blocks/index.html',
			'sources/blocks/main_as_zone_access.php',
			'sources/blocks/main_db_notes.php',
			'sources/blocks/main_notes.php',
			'sources/blocks/main_only_if_match.php',
			'sources/blocks/main_sitemap.php',
			'sources/blocks/side_personal_stats.php',
			'sources/caches.php',
			'sources/caches2.php',
			'sources/caches_filesystem.php',
			'sources/caches_eaccelerator.php',
			'sources/caches_apc.php',
			'sources/caches_xcache.php',
			'sources/caches_wincache.php',
			'sources/config.php',
			'sources/config2.php',
			'sources/critical_errors.php',
			'sources/database.php',
			'sources/database_helper.php',
			'sources/database_action.php',
			'sources/database_search.php',
			'sources/diff.php',
			'sources/encryption.php',
			'sources/files.php',
			'sources/files2.php',
			'sources/forum_stub.php',
			'sources/global.php',
			'sources/shared_installs.php',
			'sources/xml_storage.php',
			'sources/override_api.php',
			'sources/global2.php',
			'sources/character_sets.php',
			'sources/css_and_js.php',
			'sources/jsmin.php',
			'sources/word_filter.php',
			'sources/input_filter.php',
			'sources/failure.php',
			'sources/images.php',
			'sources/exif.php',
			'sources/index.html',
			'sources/integrator.php',
			'sources/lang.php',
			'sources/lang_urlise.php',
			'sources/lang_compile.php',
			'sources/lang2.php',
			'sources/lang3.php',
			'sources/lookup.php',
			'sources/mail.php',
			'sources/miniblocks/.htaccess',
			'sources/miniblocks/index.html',
			'sources/minikernel.php',
			'sources/misc_scripts.php',
			'sources/hooks/systems/preview/block_comcode.php',
			'sources/m_zip.php',
			'sources/seo2.php',
			'sources/site.php',
			'sources/site_adminzone.php',
			'sources/site_html_pages.php',
			'sources/site2.php',
			'sources/site_tree.php',
			'sources/splurgh.php',
			'sources/submit.php',
			'sources/support.php',
			'sources/support2.php',
			'sources/mime_types.php',
			'sources/obfuscate.php',
			'sources/xhtml.php',
			'sources/xmlrpc.php',
			'sources/textfiles.php',
			'sources/autosave.php',
			'sources/symbols.php',
			'sources/tar.php',
			'sources/tempcode.php',
			'sources/tempcode_compiler.php',
			'sources/tempcode__runtime.php',
			'sources/tempcode_compiler__runtime.php',
			'sources/templates.php',
			'sources/themes.php',
			'sources/type_validation.php',
			'sources/uploads.php',
			'sources/urls.php',
			'sources/urls2.php',
			'sources/users.php',
			'sources/users_active_actions.php',
			'sources/users_inactive_occasionals.php',
			'sources/version.php',
			'sources/version2.php',
			'sources/view_modes.php',
			'sources/zip.php',
			'sources/zones.php',
			'sources/zones2.php',
			'sources/zones3.php',
			'sources/developer_tools.php',
			'sources/hooks/.htaccess',
			'sources/hooks/blocks/.htaccess',
			'sources/hooks/blocks/index.html',
			'sources/hooks/index.html',
			'sources/hooks/modules/.htaccess',
			'sources/hooks/modules/index.html',
			'sources/hooks/systems/.htaccess',
			'sources/hooks/systems/index.html',
			'data/zone_jump.php',
			'data/ajax_tree.php',
			'sources/hooks/systems/ajax_tree/.htaccess',
			'sources/hooks/systems/ajax_tree/index.html',
			'sources/hooks/systems/cron/.htaccess',
			'sources/hooks/systems/cron/index.html',
			'sources/hooks/systems/do_next_menus/.htaccess',
			'sources/hooks/systems/do_next_menus/core.php',
			'sources/hooks/systems/do_next_menus/index.html',
			'sources/hooks/systems/preview/.htaccess',
			'sources/hooks/systems/preview/index.html',
			'sources/hooks/systems/snippets/.htaccess',
			'sources/hooks/systems/snippets/index.html',
			'sources/hooks/systems/snippets/css_compile.php',
			'sources/hooks/systems/snippets/block.php',
			'sources/blocks.php',
			'sources/hooks/systems/cron/block_caching.php',
			'tempcode_test.tpl',
			'QUERY_LOG.tpl',
			'QUERY_SCREEN.tpl',
			'JAVASCRIPT_CUSTOM_GLOBALS.tpl',
			'JAVASCRIPT_MODALWINDOW.tpl',
			'sources/blocks/main_greeting.php',
			'themes/default/images/iphone.png',
			'themes/default/images/quote_gradient.png',
			'themes/default/images/bigicons/xml.png',
			'themes/default/images/bigicons/email.png',
			'sources/hooks/systems/content_meta_aware/.htaccess',
			'sources/hooks/systems/content_meta_aware/index.html',
			'sources/hooks/systems/meta/.htaccess',
			'sources/hooks/systems/ocf_auth/.htaccess',
			'sources/hooks/systems/startup/.htaccess',
			'sources/hooks/systems/upon_access_denied/.htaccess',
			'sources/hooks/systems/upon_login/.htaccess',
			'sources/hooks/systems/upon_page_load/.htaccess',
			'sources/hooks/systems/upon_query/.htaccess',
			'sources_custom/database/.htaccess',
			'sources_custom/database/index.html',
			'sources/rss.php',
			'lang/EN/rss.ini',
			'data/incoming_uploads.php',
			'sources/incoming_uploads.php',
			'themes/default/images/swfupload/cancelbutton.gif',
			'themes/default/images/swfupload/index.html',
			'themes/default/images/EN/pageitem/clear.png',
			'themes/default/images/EN/pageitem/upload.png',
			'uploads/incoming/index.html',
			'uploads/incoming/.htaccess',
			'JAVASCRIPT_SWFUPLOAD.tpl',
			'data/swfupload/index.html',
			'data/swfupload/blank.swf',
			'data/swfupload/swfupload.swf',
			'data/swfupload/swfuploadbutton.swf',
			'data/javaupload/Checker.class',
			'data/javaupload/index.html',
			'data/javaupload/Net.jar',
			'data/javaupload/Uploader.jar',
			'JAVA_DETECT.tpl',
			'swfupload.css',
			'NEWSLETTER_DEFAULT.tpl',
			'themes/default/images/favicon.ico',
			'themes/default/images/appleicon.png',
			'adminzone/pages/modules/admin_emaillog.php',
			'sources/hooks/systems/cron/mail_queue.php',
			'lang/EN/emaillog.ini',
			'EMAILLOG_SCREEN.tpl',
			'QUICK_JS_LOADER.tpl',
			'sources/hooks/systems/cron/implicit_usergroup_sync.php',
			'sources/hooks/systems/ocf_implicit_usergroups/index.html',
			'sources/hooks/systems/ocf_implicit_usergroups/.htaccess',
		);
	}


	/**
	* Get mapping between template names and the method of this class that can render a preview of them
	*
	* @return array			The mapping
	*/
	function tpl_previews()
	{
		return array(
				'ACTION_LOGS_SCREEN.tpl'=>'administrative__action_logs_screen',
				'ACTION_LOGS_TOGGLE_LINK.tpl'=>'administrative__action_logs_toggle_link',
				'LOOKUP_IP_LIST_ENTRY.tpl'=>'administrative__lookup_screen',
				'LOOKUP_IP_LIST_GROUP.tpl'=>'administrative__lookup_screen',
				'LOOKUP_SCREEN.tpl'=>'administrative__lookup_screen',
				'LOGIN_SCREEN.tpl'=>'login_screen',
				'LOGIN_REDIRECT_SCREEN.tpl'=>'login_redirect_screen',
				'FORUMS_EMBED.tpl'=>'forums_embed',
				'JAVASCRIPT_NEED_INLINE.tpl'=>'javascript_need_inline',
				'CSS_NEED_INLINE.tpl'=>'css_need_inline',
				'FATAL_SCREEN.tpl'=>'administrative__fatal_screen',
				'STACK_TRACE_LINE.tpl'=>'administrative__stack_trace_hyper_wrap',
				'STACK_TRACE_WRAP.tpl'=>'administrative__stack_trace_hyper_wrap',
				'STACK_TRACE_HYPER_WRAP.tpl'=>'administrative__stack_trace_hyper_wrap',
				'INLINE_WIP_MESSAGE.tpl'=>'inline_wip_message',
				'MISSING_SCREEN.tpl'=>'missing_screen',
				'PARAM_INFO.tpl'=>'param_info',
				'JAVASCRIPT_NEED.tpl'=>'javascript_need',
				'CSS_NEED.tpl'=>'css_need',
				'BLOCK_SIDE_PERSONAL_STATS_LINE.tpl'=>'block_side_personal_stats',
				'BLOCK_SIDE_PERSONAL_STATS_LINK_2.tpl'=>'block_side_personal_stats',
				'BLOCK_SIDE_PERSONAL_STATS_LINK.tpl'=>'block_side_personal_stats',
				'BLOCK_SIDE_PERSONAL_STATS_LINE_COMPLEX.tpl'=>'block_side_personal_stats',
				'BLOCK_SIDE_PERSONAL_STATS_LOGOUT.tpl'=>'block_side_personal_stats',
				'BLOCK_SIDE_PERSONAL_STATS.tpl'=>'block_side_personal_stats',
				'BLOCK_SIDE_PERSONAL_STATS_NO.tpl'=>'block_side_personal_stats_no',
				'BLOCK_NO_ENTRIES.tpl'=>'block_no_entries',
				'BLOCK_MAIN_EMOTICON_CODES_ENTRY.tpl'=>'block_main_emoticon_codes',
				'BLOCK_MAIN_EMOTICON_CODES.tpl'=>'block_main_emoticon_codes',
				'BLOCK_SIDE_ZONE_JUMP.tpl'=>'block_side_zone_jump',
				'BLOCK_MAIN_COMCODE_PAGE_CHILDREN.tpl'=>'block_main_comcode_page_children',
				'BLOCK_MAIN_SITEMAP_NEST.tpl'=>'block_main_sitemap',
				'BLOCK_MAIN_SITEMAP.tpl'=>'block_main_sitemap',
				'QUERY_LOG.tpl'=>'administrative__query_screen',
				'QUERY_SCREEN.tpl'=>'administrative__query_screen',
				'BROKEN_URLS.tpl'=>'administrative__broken_urls',
				'BROKEN_LANG_STRINGS.tpl'=>'administrative__broken_lang_strings',
				'ZONE_CHOOSE.tpl'=>'zone_choose',
				'ZONE_CHOOSE_INLINE.tpl'=>'block_side_zone_jump',
				'JOIN_OR_LOGIN.tpl'=>'join_or_login',
				'FORUM_ATTACHMENT_IMAGE.tpl'=>'forum_attachment_image',
				'FORUM_ATTACHMENT_IMAGE_THUMB.tpl'=>'forum_attachment_link',
				'FORUM_ATTACHMENT_LINK.tpl'=>'forum_attachment_link',
				'tempcode_test.tpl'=>'administrative__tempcode_test',
				'JAVA_DETECT.tpl'=>'java_detect',
				'EMAILLOG_SCREEN.tpl'=>'email_log_screen',
				'QUICK_JS_LOADER.tpl'=>'quick_js_loader',
				);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__java_detect()
	{
		return array(
			lorem_globalise(
				do_lorem_template('JAVA_DETECT',array(
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__email_log_screen()
	{
		require_lang('emaillog');

		return array(
			lorem_globalise(
				do_lorem_template('EMAILLOG_SCREEN',array(
					'TITLE'=>lorem_title(),
					'RESULTS_TABLE'=>placeholder_table(),
					'MASS_DELETE_URL'=>placeholder_url(),
					'MASS_SEND_URL'=>placeholder_url(),
						)
			),NULL,'',true),
		);
	}
	
	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__quick_js_loader()
	{
		return array(
			lorem_globalise(
				do_lorem_template('QUICK_JS_LOADER',array(
						)
			),NULL,'',true),
		);
	}
	
	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__administrative__action_logs_toggle_link()
	{
		return array(
			lorem_globalise(
				do_lorem_template('ACTION_LOGS_TOGGLE_LINK',array(
					'URL'=>placeholder_url(),
					'page'=>lorem_phrase(),
					'type'=>lorem_phrase(),
					'id'=>lorem_phrase(),
					'mode'=>lorem_phrase(),
					'action_id'=>lorem_phrase(),
					)
				),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__administrative__action_logs_screen()
	{
		return array(
			lorem_globalise(
				do_lorem_template('ACTION_LOGS_SCREEN',array(
					'TABLE'=>placeholder_table(),
					'TITLE'=>lorem_title(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__administrative__lookup_screen()
	{
		$inner_ip_list	=	new ocp_tempcode();
		foreach (placeholder_array() as $value)
			$inner_ip_list->attach(do_lorem_template('LOOKUP_IP_LIST_ENTRY',array('LOOKUP_URL'=>placeholder_url(),'DATE'=>placeholder_time(),'_DATE'=>placeholder_time(),'IP'=>placeholder_ip(),'BANNED'=>do_lang_tempcode('YES'),'UNIQID'=>placeholder_random())));

		$group = do_lorem_template('LOOKUP_IP_LIST_GROUP',array('BANNED'=>do_lang_tempcode('YES'),'MASK'=>placeholder_ip(),'GROUP'=>$inner_ip_list,'OPEN_DEFAULT'=>true,'UNIQID'=>placeholder_random()));
		return array(
			lorem_globalise(
				do_lorem_template('LOOKUP_SCREEN',array(
					'TITLE'=>lorem_title(),
					'ALERTS'=>lorem_phrase(),
					'STATS'=>lorem_phrase(),
					'IP_LIST'=>$group,
					'IP_BANNED'=>lorem_phrase(),
					'SUBMITTER_BANNED'=>lorem_phrase(),
					'MEMBER_BANNED'=>lorem_phrase(),
					'ID'=>placeholder_id(),
					'IP'=>placeholder_ip(),
					'NAME'=>lorem_word(),
					'SEARCH_URL'=>placeholder_url(),
					'AUTHOR_URL'=>placeholder_url(),
					'POINTS_URL'=>placeholder_url(),
					'PROFILE_URL'=>placeholder_url(),
					'ACTION_LOG_URL'=>placeholder_url(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__login_screen()
	{
		$_GET['wide']='1';

		return array(
			lorem_globalise(
				do_lorem_template('LOGIN_SCREEN',array(
					'EXTRA'=>lorem_phrase(),
					'USERNAME'=>lorem_word(),
					'JOIN_LINK'=>placeholder_url(),
					'TITLE'=>lorem_title(),
					'LOGIN_URL'=>placeholder_url(),
					'PASSION'=>'',
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__login_redirect_screen()
	{
		return array(
			lorem_globalise(
				do_lorem_template('LOGIN_REDIRECT_SCREEN',array(
					'REFRESH'=>'',
					'TITLE'=>lorem_title(),
					'TEXT'=>lorem_sentence_html(),
					'URL'=>placeholder_url(),
					'POST'=>lorem_phrase(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__forums_embed()
	{
		return array(
			lorem_globalise(
				do_lorem_template('FORUMS_EMBED',array(
					'FORUMS'=>placeholder_url(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__javascript_need_inline()
	{
		return array(
			lorem_globalise(
				do_lorem_template('JAVASCRIPT_NEED_INLINE',array(
					'CODE'=>placeholder_javascript_code(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__css_need_inline()
	{
		return array(
			lorem_globalise(
				do_lorem_template('CSS_NEED_INLINE',array(
					'CSS'=>'',
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__administrative__fatal_screen()
	{
		return array(
			lorem_globalise(
				do_lorem_template('FATAL_SCREEN',array(
					'TITLE'=>lorem_title(),
					'MESSAGE'=>lorem_phrase(),
					'TRACE'=>lorem_phrase(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__administrative__stack_trace_hyper_wrap()
	{
		$trace	=	new ocp_tempcode();
		foreach (placeholder_array() as $value)
		{
			$traces	=	new ocp_tempcode();
			foreach (placeholder_array() as $key=>$value1)
			{
				$traces->attach(do_lorem_template('STACK_TRACE_LINE',array('LINE'=>$value1,'FILE'=>lorem_phrase(),'KEY'=>ucfirst($value1),'VALUE'=>lorem_sentence())));
			}
			$trace->attach(do_lorem_template('STACK_TRACE_WRAP',array('TRACES'=>$traces)));
		}

		return array(
			lorem_globalise(
				do_lorem_template('STACK_TRACE_HYPER_WRAP',array(
					'CONTENT'=>$trace,
					'POST'=>placeholder_array(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__inline_wip_message()
	{
		return array(
			lorem_globalise(
				do_lorem_template('INLINE_WIP_MESSAGE',array(
					'MESSAGE'=>lorem_phrase(),
					'NO_ENTRIES'=>lorem_word(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__missing_screen()
	{
		return array(
			lorem_globalise(
				do_lorem_template('MISSING_SCREEN',array(
					'TITLE'=>lorem_title(),
					'ADD_URL'=>placeholder_url(),
					'PAGE'=>lorem_phrase(),
					'DID_MEAN'=>lorem_word(),
					'ADD_REDIRECT_URL'=>placeholder_url(),
				)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__param_info()
	{
		return array(
			lorem_globalise(
				do_lorem_template('PARAM_INFO',array(
					'MAP'=>array(
						'A'=>'a',
						'B'=>'b',
					),
				)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__javascript_need()
	{
		return array(
			lorem_globalise(
				do_lorem_template('JAVASCRIPT_NEED',array(
					'CODE'=>placeholder_javascript_code(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__css_need()
	{
		return array(
			lorem_globalise(
				do_lorem_template('CSS_NEED',array(
					'CODE'=>lorem_phrase(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__block_side_personal_stats()
	{
		$content	=	new ocp_tempcode();
		$links	=	new ocp_tempcode();

		$content->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LINE',array('KEY'=>lorem_word(),'VALUE'=>placeholder_number())));

		$links->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LINK_2',array('NAME'=>lorem_word_2(),'DESCRIPTION'=>lorem_phrase(),'URL'=>placeholder_url())));

		$links->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LINK',array('NAME'=>lorem_word(),'URL'=>placeholder_url(),'REL'=>'me')));

		$links->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LOGOUT',array('NAME'=>do_lang_tempcode('LOGOUT'),'URL'=>placeholder_url())));

		$content->attach(do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_LINE_COMPLEX',array('KEY'=>do_lang_tempcode('GROUP'),'VALUE'=>placeholder_link())));

		$staff_actions=new ocp_tempcode();

		$staff_actions->attach(form_input_list_entry(lorem_word(),true,lorem_phrase()));

		return array(
			lorem_globalise(
				do_lorem_template('BLOCK_SIDE_PERSONAL_STATS',array(
					'AVATAR_URL'=>placeholder_avatar(),
					'LINKS'=>$links,
					'HAS_SU'=>true,
					'CONTENT'=>$content,
					'USERNAME'=>lorem_word(),
					'STAFF_ACTIONS'=>$staff_actions,
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__block_side_personal_stats_no()
	{
		return array(
			lorem_globalise(
				do_lorem_template('BLOCK_SIDE_PERSONAL_STATS_NO',array(
					'TITLE'=>lorem_phrase(),
					'FULL_LINK'=>placeholder_url(),
					'JOIN_LINK'=>placeholder_url(),
					'LOGIN_URL'=>placeholder_url(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__block_no_entries()
	{
		return array(
			lorem_globalise(
				do_lorem_template('BLOCK_NO_ENTRIES',array(
					'HIGH'=>lorem_phrase(),
					'TITLE'=>lorem_word(),
					'MESSAGE'=>lorem_phrase(),
					'ADD_NAME'=>lorem_word(),
					'SUBMIT_URL'=>placeholder_url(),
					'RECENT'=>lorem_word(),
					'MEMBERS'=>lorem_word(),
					'NO_ENTRIES'=>lorem_word(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__block_main_emoticon_codes()
	{
		$smilies = placeholder_emoticons();
		$entries=new ocp_tempcode();
		global $EMOTICON_LEVELS;
		foreach ($smilies as $code=>$imgcode)
		{
			if ((is_null($EMOTICON_LEVELS)) || ($EMOTICON_LEVELS[$code]<3))
			{
				$entries->attach(do_lorem_template('BLOCK_MAIN_EMOTICON_CODES_ENTRY',array('CODE'=>$code,'TPL'=>do_emoticon($imgcode))));
			}
		}

		return array(
			lorem_globalise(
				do_lorem_template('BLOCK_MAIN_EMOTICON_CODES',array(
					'ENTRIES'=>$entries,
				)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__join_or_login()
	{		
		return array(
			lorem_globalise(
				do_lorem_template('JOIN_OR_LOGIN',array(
					'LOGIN_URL'=>placeholder_url(),
					'JOIN_URL'=>placeholder_url(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__block_side_zone_jump()
	{		
		$out	=	do_lorem_template('ZONE_CHOOSE_INLINE',array(
							'CONTENT'=>placeholder_options()
					));

		return array(
			lorem_globalise(
				do_lorem_template('BLOCK_SIDE_ZONE_JUMP',array(
					'CONTENT'=>$out,
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__block_main_comcode_page_children()
	{
		$children=array();
		foreach (placeholder_array() as $i=>$temp)
		{
			$child=array();
			$child['TITLE']=$temp;
			$child['PAGE']=lorem_word();
			$child['ZONE']=lorem_word();

			$children[$i]=$child;
		}

		return array(
			lorem_globalise(
				do_lorem_template('BLOCK_MAIN_COMCODE_PAGE_CHILDREN',array(
					'CHILDREN'=>$children,
					'THE_PAGE'=>lorem_phrase(),
					'THE_ZONE'=>lorem_phrase(),
					'TITLE'=>lorem_phrase(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__block_main_sitemap()
	{
		$children = array();
		foreach (placeholder_array() as $v)
		{
			$children1 = array();
			foreach (placeholder_array(2) as $v)
			{
					$children2 = array();
					foreach (placeholder_array(1) as $v)
					{
						$children2[] = do_lorem_template('BLOCK_MAIN_SITEMAP_NEST',array(
						'URL'=>placeholder_url(),
						'NAME'=>lorem_word(),
						'CHILDREN'=>placeholder_array(),
							)
						);
					}

					$children1[] = do_lorem_template('BLOCK_MAIN_SITEMAP_NEST',array(
					'URL'=>placeholder_url(),
					'NAME'=>lorem_word(),
					'CHILDREN'=>$children2,
						)
					);
			}
			$children[] = do_lorem_template('BLOCK_MAIN_SITEMAP_NEST',array(
				'URL'=>placeholder_url(),
				'NAME'=>lorem_word(),
				'CHILDREN'=>$children1,
					)
			);
		}
		return array(
			lorem_globalise(
				do_lorem_template('BLOCK_MAIN_SITEMAP',array(
					'CHILDREN'=>$children,
						)
				),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__administrative__query_screen()
	{
		$queries	=	new ocp_tempcode();
		foreach (placeholder_array() as $value)
		{
			$queries->attach(do_lorem_template('QUERY_LOG',array(
					'TIME'=>placeholder_number(),
					'TEXT'=>lorem_sentence(),
						)
			));
		}

		return array(
			lorem_globalise(
				do_lorem_template('QUERY_SCREEN',array(
					'TITLE'=>lorem_title(),
					'TOTAL'=>lorem_phrase(),
					'TOTAL_TIME'=>placeholder_number(),
					'QUERIES'=>$queries,
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__administrative__broken_urls()
	{
		require_lang('cleanup');
		$found_404=array();
		foreach (placeholder_array() as $value)
		{
			$found_404[]	=	array('URL'=>placeholder_url(),'SPOT'=>$value);
		}

		$found=array();
		foreach (placeholder_array() as $k=>$value)
		{
			$found[]	=	array('URL'=>placeholder_url(),'TABLE'=>$value,'FIELD'=>lorem_word_2(),'ID'=>strval($k));
		}

		return array(
			lorem_globalise(
				do_lorem_template('BROKEN_URLS',array(
					'FOUND'=>$found,
					'FOUND_404'=>$found_404,
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__administrative__broken_lang_strings()
	{
		require_lang('cleanup');
		return array(
			lorem_globalise(
				do_lorem_template('BROKEN_LANG_STRINGS',array(
					'MISSING_LANG_STRINGS'=>placeholder_array(),
					'FUSED_LANG_STRINGS'=>placeholder_array(),
					'ORPHANED_LANG_STRINGS'=>placeholder_array(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__zone_choose()
	{
		return array(
			lorem_globalise(
				do_lorem_template('ZONE_CHOOSE',array(
					'CONTENT'=>placeholder_options()
				)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__forum_attachment_image()
	{
		return array(
			lorem_globalise(
				do_lorem_template('FORUM_ATTACHMENT_IMAGE',array(
					'URL'=>placeholder_image_url(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__forum_attachment_link()
	{
		$content = do_lorem_template('FORUM_ATTACHMENT_IMAGE_THUMB',array(
					'FULL'=>placeholder_url(),
					'URL'=>placeholder_image_url(),
						));

		$content->attach(do_lorem_template('FORUM_ATTACHMENT_LINK',array(
					'FULL'=>placeholder_url(),
					'FILENAME'=>lorem_word(),
					'CLEAN_SIZE'=>placeholder_filesize(),
					'NUM_DOWNLOADS'=>placeholder_number(),
						)));
		return array(
			lorem_globalise($content,NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__administrative__tempcode_test()
	{
		return array(
			lorem_globalise(
				do_lorem_template('tempcode_test',array(
					'EMPTY1'=>'',
					'EMPTY2'=>'',
					'NONEMPTY'=>lorem_word(),
					'PASSED'=>lorem_word(),
					'ARRAY'=>array(array('A'=>'','B'=>'','C'=>'')),
						)
			),NULL,'',true),
		);
	}
}