<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2012

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		import
 */

class Hook_ocp_merge
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['supports_advanced_import']=true;
		$info['product']=do_lang('OCPORTAL_SITE_MERGER');
		$info['prefix']='ocp4_';
		$info['import']=array(
								'attachments',
								'ocf_groups',
								'ocf_custom_profile_fields',
								'ocf_members',
								'authors',
								'banners',
								'calendar',
								'catalogues', // including rating, trackbacks, seo
								'points_gifts_and_charges', // including leader board
								'chat_rooms',
								'config',
								'custom_comcode',
								'awards',
								'downloads_and_categories', // including rating, trackbacks, seo
								'ocf_categories',
								'ocf_emoticons',
								'ocf_forums', // including intros
								'ocf_topics', // including readlogs
								'ocf_multi_moderations',
								'ocf_polls_and_votes',
								'ocf_post_templates',
								'ocf_posts', // including title remapping for comment topics
								'ocf_warnings',
								'filedump',
								'images_and_galleries', // including rating, trackbacks, seo
								'iotds', // including rating, trackbacks, seo
								'news_and_categories', // including rating, trackbacks, seo
								'newsletter_subscriptions',
								'polls', // including rating, trackbacks, seo
								'pointstore',
								'redirects',
								'cedi', // including rating, trackbacks, seo
								'stats',
								'flagrant',
								'themes',
								'support_tickets',
								'useronline_tracking',
								'ip_bans',
								'wordfilter',
								'zones',
								'permissions', // including HTTPS
								'attachment_references',
								'feedback',
								'ecommerce',
								'ocf_welcome_emails',
								'bookmarks',
								'quizzes',
							);
		$info['dependencies']=array( // This dependency tree is overdefined, but I wanted to make it clear what depends on what, rather than having a simplified version
								'attachment_references'=>array('attachments','ocf_members','ocf_posts','news_and_categories','cedi'),
								'permissions'=>array_diff($info['import'],array('feedback','attachment_references','permissions','quizzes','bookmarks','stats')),
								'feedback'=>array_diff($info['import'],array('feedback','attachment_references','permissions','quizzes','bookmarks','stats')),
								'authors'=>array('ocf_members'),
								'banners'=>array('ocf_members'),
								'catalogues'=>array('ocf_members'),
								'chat_rooms'=>array('ocf_members','ocf_groups'),
								'downloads_and_categories'=>array('ocf_members'),
								'filedump'=>array('ocf_members'),
								'images_and_galleries'=>array('ocf_members'),
								'iotds'=>array('ocf_members'),
								'news_and_categories'=>array('ocf_members','attachments'),
								'polls'=>array('ocf_members'),
								'pointstore'=>array('ocf_members'),
								'cedi'=>array('ocf_members','attachments'),
								'flagrant'=>array('ocf_members'),
								'useronline_tracking'=>array('ocf_members'),
								'ip_bans'=>array('ocf_members'),
								'points_gifts_and_charges'=>array('ocf_members'),
								'calendar'=>array('ocf_members'),
								'ocf_custom_profile_fields'=>array('ocf_groups'),
								'ocf_multi_moderations'=>array('ocf_forums'),
								'ocf_members'=>array('ocf_groups','ocf_custom_profile_fields','attachments'),
								'ocf_forums'=>array('ocf_categories','ocf_members','ocf_groups'),
								'ocf_topics'=>array('ocf_forums','ocf_members'),
								'ocf_polls_and_votes'=>array('ocf_topics','ocf_members'),
								'ocf_posts'=>array('custom_comcode','ocf_topics','ocf_members','attachments'),
								'ocf_personal_topics'=>array('custom_comcode','ocf_members'),
								'ocf_post_templates'=>array('ocf_forums'),
								'ocf_warnings'=>array('ocf_members','ocf_groups','ocf_topics','ocf_forums'),
								'newsletter_subscriptions'=>array('attachments'),
								'awards'=>array('calendar','cedi','news_and_categories','images_and_galleries','catalogues','authors','ocf_topics','ocf_posts','ocf_forums','ocf_groups','ocf_members','downloads_and_categories'),
								'ecommerce'=>array('ocf_groups','ocf_members'),
								'ocf_welcome_emails'=>array('ocf_members'),
								'bookmarks'=>array('ocf_members'),
								'quizzes'=>array('ocf_members'),
							);

		//if (!$this->on_same_msn($file_base))
		{
			$_cleanup_url=build_url(array('page'=>'admin_cleanup'),get_module_zone('admin_cleanup'));
			$cleanup_url=$_cleanup_url->evaluate();
			$info['message']=(get_param('type','misc')!='import' && get_param('type','misc')!='hook')?new ocp_tempcode():do_lang_tempcode('FORUM_CACHE_CLEAR',escape_html($cleanup_url));
		}

		return $info;
	}

	/**
	 * Do some tests, to make sure we're happy to continue importing.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 * @return ?tempcode		Error/warning UI (NULL: no error/warning)
	 */
	function pre_import_tests($db,$table_prefix,$file_base)
	{
		$title=get_page_title('IMPORT');

		$bad=false;

		// Check actually is ocPortal DB (ERROR)
		$test=$db->query_value('zones','zone_name');
		if (is_null($test))
		{
			return warn_screen($title,do_lang_tempcode('ERROR_NOT_CORRECT_DATABASE'));
		}

		// Check version (WARNING)
		$test=$db->query_value_null_ok('values','the_value',array('the_name'=>'version'));
		if ((is_null($test)) || (intval($test)!=ocp_version()))
		{
			attach_message(do_lang_tempcode('ERROR_NOT_CORRECT_VERSION'),'warn');
			$bad=true;
		}

		// Check actually is ocPortal file path (ERROR)
		if ((!file_exists($file_base.'/info.php')) || (!file_exists($file_base.'/sources_custom')))
		{
			attach_message(do_lang_tempcode('ERROR_NOT_CORRECT_FILES'),'warn');
			if ((isset($GLOBALS['FORUM_DB'])) && ($db->connection_write!=$GLOBALS['FORUM_DB']->connection_write) && (!file_exists($file_base.'/info.php')))
				attach_message(do_lang_tempcode('ERROR_NOT_CORRECT_LINKING_POSSIBLY'),'warn');
			$bad=true;
		}

		// Check is on same MSN or is OCF (WARNING)
		if (file_exists($file_base.'/info.php'))
		{
			global $SITE_INFO;
			$backup_site_info=$SITE_INFO;
			$SITE_INFO=NULL;
			@include($file_base.'/info.php');
			if (is_null($SITE_INFO))
			{
				$SITE_INFO=$backup_site_info;
				attach_message(do_lang_tempcode('ERROR_INACESSIBLE_DIR'),'warn');
				if ((isset($GLOBALS['FORUM_DB'])) && ($db->connection_write!=$GLOBALS['FORUM_DB']->connection_write))
					attach_message(do_lang_tempcode('ERROR_NOT_CORRECT_LINKING_POSSIBLY'),'warn');
				$bad=true;
			} else
			{
				$this_site_info=$SITE_INFO;
				$SITE_INFO=$backup_site_info;
				if (!array_key_exists('db_forums_host',$SITE_INFO)) $SITE_INFO['db_forums_host']='localhost';
				$same_forum=($this_site_info['db_forums']==$SITE_INFO['db_forums']) && ($this_site_info['db_forums_host']==$SITE_INFO['db_forums_host']) && ($db->table_prefix);
				if (($this_site_info['forum_type']!='ocf') && (!$same_forum))
				{
					attach_message(do_lang_tempcode('ERROR_NOT_CORRECT_LINKING'),'warn');
					$bad=true;
				}
			}
		}

		// Show warning
		if ($bad)
		{
			return do_template('CONFIRM_SCREEN',array('_GUID'=>'286928b79830cdff4ac506e4f4f00f3a','TITLE'=>$title,'PREVIEW'=>do_lang_tempcode('IMPORT_WARNINGS_GIVEN'),'FIELDS'=>build_keep_post_fields(),'URL'=>get_self_url(false,false,array('happy'=>1))));
		}

		return NULL;
	}

	/**
	 * See if the importing site is on the same M.S.N. as the site being imported.
	 *
	 * @param  PATH			The path to the imported site
	 * @return boolean		Answer
	 */
	function on_same_msn($file_base)
	{
		if (get_param_integer('keep_on_same_msn',NULL)===0) return false;
		if (get_param_integer('keep_on_same_msn',NULL)===1) return true;
		
		//return false;
		global $SITE_INFO;
		$backup_site_info=$SITE_INFO;
		$SITE_INFO=mixed();
		@include($file_base.'/info.php');
		$sites_site_info=$SITE_INFO;
		$SITE_INFO=$backup_site_info;
		
		$answer=($sites_site_info['db_forums']==get_db_forums()) && ($sites_site_info['db_forums_host']==get_db_forums_host()) && (@$sites_site_info['ocf_table_prefix']===@$SITE_INFO['ocf_table_prefix']);

		return $answer;
	}

	/**
	 * Fetch and clean up a language string.
	 *
	 * @param  object			The DB connection to import from
	 * @param  integer		The string ID
	 * @return string			The cleaned-up string
	 */
	function get_lang_string($db,$id)
	{
		if (is_null($id)) return '';
		$text=get_translated_text($id,$db);
		$matches=array();
		$count=preg_match_all('#\](\d+)\[/attachment\]#',$text,$matches);
		if ($count!=0)
		{
			for ($i=0;$i<$count;$i++)
			{
				$from=$matches[1][$i];
				$to=import_id_remap_get('attachment',$from,true);
				if (is_null($to)) $to=-1;
				$text=str_replace(']'.$from.'[/attachment]',']'.strval($to).'[/attachment]',$text);
			}
		}
		return $text;
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_ocf_welcome_emails($db,$table_prefix,$file_base)
	{
		if ($this->on_same_msn($file_base)) return;
	
		$rows=$db->query('SELECT * FROM '.$table_prefix.'f_welcome_emails',NULL,NULL,true);
		if (is_null($rows)) return;
		foreach ($rows as $row)
		{
			if (import_check_if_imported('welcome_email',$row['w_name'])) continue;

			ocf_make_welcome_email($row['w_name'],$this->get_lang_string($db,$row['w_subject']),$this->get_lang_string($db,$row['w_text']),$row['w_send_time']);

			import_id_remap_put('welcome_email',$row['w_name'],0);
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_bookmarks($db,$table_prefix,$file_base)
	{
		$rows=$db->query('SELECT * FROM '.$table_prefix.'bookmarks',NULL,NULL,true);
		if (is_null($rows)) return;
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			$owner=$on_same_msn?$row['b_owner']:import_id_remap_get('member',$row['b_owner'],true);
			if (is_null($owner)) $owner=$GLOBALS['FORUM_DRIVER']->get_guest_id();

			$GLOBALS['SITE_DB']->query_insert('bookmarks',array('b_owner'=>$owner,'b_folder'=>$row['b_folder'],'b_title'=>$row['b_title'],'b_page_link'=>$row['b_page_link']));
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_quizzes($db,$table_prefix,$file_base)
	{
		$rows=$db->query('SELECT * FROM '.$table_prefix.'quizzes ORDER BY id',NULL,NULL,true);
		if (is_null($rows))
		{
			$rows=$db->query('SELECT * FROM '.$table_prefix.'quiz ORDER BY id',NULL,NULL,true);
			if (is_null($rows)) return;
		}
		foreach ($rows as $row)
		{
			if (import_check_if_imported('quiz',strval($row['id']))) continue;

			if (!array_key_exists('q_add_date',$row)) $row['q_add_date']=time();
			if (!array_key_exists('q_validated',$row)) $row['q_validated']=1;
			if (!array_key_exists('q_submitter',$row)) $row['q_submitter']=get_member();

			$start_text=is_integer($row['q_start_text'])?$this->get_lang_string($db,$row['q_start_text']):$row['q_start_text'];
			$end_text=is_integer($row['q_end_text'])?$this->get_lang_string($db,$row['q_end_text']):$row['q_end_text'];
			if (!isset($row['q_end_text_fail'])) $row['q_end_text_fail']='';
			$end_text_fail=is_integer($row['q_end_text_fail'])?$this->get_lang_string($db,$row['q_end_text_fail']):$row['q_end_text_fail'];

			$map=array(
				'q_name'=>insert_lang($this->get_lang_string($db,$row['q_name']),2),
				'q_timeout'=>$row['q_timeout'],
				'q_start_text'=>insert_lang($start_text,2),
				'q_end_text'=>insert_lang($end_text,2),
				'q_end_text_fail'=>insert_lang($end_text_fail,2),
				'q_notes'=>$row['q_notes'],
				'q_percentage'=>$row['q_percentage'],
				'q_open_time'=>$row['q_open_time'],
				'q_close_time'=>$row['q_close_time'],
				'q_num_winners'=>$row['q_num_winners'],
				'q_redo_time'=>$row['q_redo_time'],
				'q_type'=>$row['q_type'],
				'q_validated'=>$row['q_validated'],
				'q_submitter'=>$row['q_submitter'],
				'q_add_date'=>$row['q_add_date'],
				'q_points_for_passing'=>array_key_exists('q_points_for_passing',$row)?$row['q_points_for_passing']:0,
			);
			if (get_param_integer('keep_preserve_ids',0)==1) $map['id']=$row['id'];
			$id_new=$GLOBALS['SITE_DB']->query_insert('quizzes',$map,true);

			import_id_remap_put('quiz',strval($row['id']),$id_new);
		}

		$rows=$db->query('SELECT * FROM '.$table_prefix.'quiz_questions');
		foreach ($rows as $i=>$row)
		{
			if (import_check_if_imported('quiz_question',strval($row['id']))) continue;

			$quiz=import_id_remap_get('quiz',strval($row['q_quiz']));

			$id_new=$GLOBALS['SITE_DB']->query_insert('quiz_questions',array(
				'q_order'=>array_key_exists('q_order',$row)?$row['q_order']:$i,
				'q_long_input_field'=>$row['q_long_input_field'],
				'q_num_choosable_answers'=>$row['q_num_choosable_answers'],
				'q_quiz'=>$quiz,
				'q_question_text'=>insert_lang($this->get_lang_string($db,$row['q_question_text']),2),
				'q_required'=>array_key_exists('q_required',$row)?$row['q_required']:0,
			),true);

			import_id_remap_put('quiz_question',strval($row['id']),$id_new);
		}

		$rows=$db->query('SELECT * FROM '.$table_prefix.'quiz_question_answers');
		foreach ($rows as $i=>$row)
		{
			$question=import_id_remap_get('quiz_question',strval($row['q_question']));

			$GLOBALS['SITE_DB']->query_insert('quiz_question_answers',array(
				'q_order'=>array_key_exists('q_order',$row)?$row['q_order']:$i,
				'q_question'=>$question,
				'q_answer_text'=>insert_lang(array_key_exists('q_answer_text',$row)?$this->get_lang_string($db,$row['q_answer_text']):'',2),
				'q_explanation'=>insert_lang(array_key_exists('q_explanation',$row)?$this->get_lang_string($db,$row['q_explanation']):'',2),
				'q_is_correct'=>$row['q_is_correct'],
			));
		}

		$rows=$db->query('SELECT * FROM '.$table_prefix.'quiz_entries');
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			if (import_check_if_imported('quiz_entry',strval($row['id']))) continue;

			$quiz=import_id_remap_get('quiz',strval($row['q_quiz']));
			$member=$on_same_msn?$row['q_member']:import_id_remap_get('member',$row['q_member'],true);
			if (is_null($member)) $member=$GLOBALS['FORUM_DRIVER']->get_guest_id();

			$id_new=$GLOBALS['SITE_DB']->query_insert('quiz_entries',array(
				'q_time'=>$row['q_time'],
				'q_member'=>$member,
				'q_quiz'=>$quiz,
				'q_results'=>$row['q_results'],
			),true);

			import_id_remap_put('quiz_entry',strval($row['id']),$id_new);
		}

		$rows=$db->query('SELECT * FROM '.$table_prefix.'quiz_entry_answer');
		foreach ($rows as $row)
		{
			$question=import_id_remap_get('quiz_question',strval($row['q_question']));
			$entry=import_id_remap_get('quiz_entry',strval($row['q_entry']));

			$GLOBALS['SITE_DB']->query_insert('quiz_entry_answer',array('q_entry'=>$entry,'q_question'=>$question,'q_answer'=>$row['q_answer']));
		}

		$rows=$db->query('SELECT * FROM '.$table_prefix.'quiz_winner');
		foreach ($rows as $row)
		{
			$quiz=import_id_remap_get('quiz',strval($row['q_quiz']));
			$entry=import_id_remap_get('quiz_entry',strval($row['q_entry']));

			$GLOBALS['SITE_DB']->query_insert('quiz_winner',array('q_quiz'=>$quiz,'q_entry'=>$entry,'q_winner_level'=>$row['q_winner_level']));
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_ecommerce($db,$table_prefix,$file_base)
	{
		$rows=$db->query('SELECT * FROM '.$table_prefix.'transactions',NULL,NULL,true);
		if (is_null($rows)) return;
		foreach ($rows as $row)
		{
			$GLOBALS['SITE_DB']->query_insert('transactions',$row);
		}

		$rows=$db->query('SELECT * FROM '.$table_prefix.'invoices ORDER BY id');
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			$row['i_member_id']=$on_same_msn?$row['i_member_id']:import_id_remap_get('member',strval($row['i_member_id']),true);
			if (is_null($row['i_member_id'])) continue; // Uh oh - someones deleted and they had invoices - lets hope they paid them ;)
			if (get_param_integer('keep_preserve_ids',0)==0) unset($row['id']);
			$GLOBALS['SITE_DB']->query_insert('invoices',$row);
		}

		$rows=$db->query('SELECT * FROM '.$table_prefix.'f_usergroup_subs',NULL,NULL,true);
		if (!is_null($rows))
		{
			foreach ($rows as $row)
			{
				if (import_check_if_imported('usergroup_sub',strval($row['id']))) continue;

				$group_id=$on_same_msn?$row['s_group_id']:import_id_remap_get('group',strval($row['s_group_id']));

				$id_new=$GLOBALS['SITE_DB']->query_insert('f_usergroup_subs',array(
					's_title'=>insert_lang($this->get_lang_string($db,$row['s_title']),2),
					's_description'=>insert_lang($this->get_lang_string($db,$row['s_description']),2),
					's_cost'=>$row['s_cost'],
					's_length'=>$row['s_length'],
					's_length_units'=>$row['s_length_units'],
					's_group_id'=>$group_id,
					's_enabled'=>$row['s_enabled'],
					's_mail_start'=>insert_lang($this->get_lang_string($db,$row['s_mail_start']),2),
					's_mail_end'=>insert_lang($this->get_lang_string($db,$row['s_mail_end']),2),
					's_mail_uhoh'=>insert_lang($this->get_lang_string($db,$row['s_mail_uhoh']),2),
				),true);
	
				import_id_remap_put('usergroup_sub',strval($row['id']),$id_new);
			}
		}

		$rows=$db->query('SELECT * FROM '.$table_prefix.'subscriptions ORDER BY id');
		foreach ($rows as $row)
		{
			$row['s_member_id']=$on_same_msn?$row['s_member_id']:import_id_remap_get('member',strval($row['s_member_id']),true);
			if (is_null($row['s_member_id'])) continue; // Uh oh - someones deleted and they had invoices - lets hope they paid them ;)
			if (substr($row['s_type_code'],0,9)=='USERGROUP')
			{
				$remap_id=import_id_remap_get('usergroup_sub',substr($row['s_type_code'],9),true);
				if (is_null($remap_id)) continue;
				$row['s_type_code']='USERGROUP'.strval($remap_id);
			}
			if (get_param_integer('keep_preserve_ids',0)==0) unset($row['id']);
			$GLOBALS['SITE_DB']->query_insert('subscriptions',$row);
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_attachments($db,$table_prefix,$file_base)
	{
		$row_start=0;
		$rows=array();
		do
		{
			$rows=$db->query('SELECT * FROM '.$table_prefix.'attachments ORDER BY id',200,$row_start);
			foreach ($rows as $row)
			{
				if (import_check_if_imported('attachment',strval($row['id']))) continue;
	
	//			$row['a_member_id']=import_id_remap_get('member',strval($row['a_member_id']));
				$row['a_member_id']=-$row['a_member_id']; // This is resolved when importing members
				$row_copy=$row;
				if (get_param_integer('keep_preserve_ids',0)==0) unset($row_copy['id']);
				if (!array_key_exists('a_description',$row_copy)) $row_copy['a_description']='';
				$id_new=$GLOBALS['SITE_DB']->query_insert('attachments',$row_copy,true);
	
				import_id_remap_put('attachment',strval($row['id']),$id_new);
			}
			$row_start+=200;
		}
		while (count($rows)>0);
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_attachment_references($db,$table_prefix,$file_base)
	{
		$row_start=0;
		$rows=array();
		do
		{
			$rows=$db->query('SELECT * FROM '.$table_prefix.'attachment_refs',200,$row_start);
			foreach ($rows as $row)
			{
				$id_new=import_id_remap_get($row['r_referer_type'],$row['r_referer_id'],true);
				if (is_null($id_new)) $id_new=$row['r_referer_id'];
				$aid=import_id_remap_get('attachment',$row['a_id'],true);
				if (!is_null($aid))
					$GLOBALS['SITE_DB']->query_insert('attachment_refs',array('r_referer_type'=>$row['r_referer_type'],'r_referer_id'=>$id_new,'a_id'=>$aid));
			}
			$row_start+=200;
		}
		while (count($rows)>0);
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_feedback($db,$table_prefix,$file_base)
	{
		$type_remap=array('downloads_category'=>'download_category','downloads_download'=>'download','downloads'=>'download');

		$rows=$db->query('SELECT * FROM '.$table_prefix.'rating');
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			$remapped=$row['rating_for_type'];
			if (array_key_exists($remapped,$type_remap)) $remapped=$type_remap[$remapped];

			unset($row['id']);
			if (is_numeric($row['rating_for_id']))
			{
				$id_new=import_id_remap_get($remapped,$row['rating_for_id'],true);
				if (!is_null($id_new)) $row['rating_for_id']=strval($id_new);
			}
			$row['rating_member']=$on_same_msn?$row['rating_member']:import_id_remap_get('member',$row['rating_member'],true);
			if (is_null($row['rating_member'])) $row['rating_member']=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			$GLOBALS['SITE_DB']->query_insert('rating',$row);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'trackbacks');
		foreach ($rows as $row)
		{
			$remapped=$row['trackback_for_type'];
			if (array_key_exists($remapped,$type_remap)) $remapped=$type_remap[$remapped];

			unset($row['id']);
			if (is_numeric($row['trackback_for_id']))
			{
				$id_new=import_id_remap_get($remapped,$row['trackback_for_id'],true);
				if (!is_null($id_new)) $row['trackback_for_id']=strval($id_new);
			}
			$GLOBALS['SITE_DB']->query_insert('trackbacks',$row);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'seo_meta');
		foreach ($rows as $row)
		{
			$remapped=$row['meta_for_type'];
			if (array_key_exists($remapped,$type_remap)) $remapped=$type_remap[$remapped];

			unset($row['id']);
			if (is_numeric($row['meta_for_id']))
			{
				$id_new=import_id_remap_get($remapped,$row['meta_for_id'],true);
				if (!is_null($id_new)) $row['meta_for_id']=strval($id_new);
			}
			$row['meta_keywords']=insert_lang($this->get_lang_string($db,$row['meta_keywords']),2);
			$row['meta_description']=insert_lang($this->get_lang_string($db,$row['meta_description']),2);
			$GLOBALS['SITE_DB']->query_insert('seo_meta',$row);
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_authors($db,$table_prefix,$file_base)
	{
		require_code('authors');
		
		$rows=$db->query('SELECT * FROM '.$table_prefix.'authors',NULL,NULL,true);
		if (is_null($rows)) return;
		foreach ($rows as $row)
		{
			$test=$GLOBALS['SITE_DB']->query_value_null_ok('authors','author',array('author'=>$row['author']));
			if (is_null($test)) add_author($row['author'],$row['url'],$row['forum_handle'],$this->get_lang_string($db,$row['description']),$this->get_lang_string($db,$row['skills']));
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_banners($db,$table_prefix,$file_base)
	{
		require_code('banners2');
		
		$rows=$db->query('SELECT * FROM '.$table_prefix.'banner_types',NULL,NULL,true);
		if (is_null($rows)) return;
		foreach ($rows as $row)
		{
			$test=$GLOBALS['SITE_DB']->query_value_null_ok('banner_types','id',array('id'=>$row['id']));
			if (is_null($test))
			{
				add_banner_type($row['id'],$row['t_is_textual'],$row['t_image_width'],$row['t_image_height'],$row['t_max_file_size'],$row['t_comcode_inline']);
			}
		}

		$rows=$db->query('SELECT * FROM '.$table_prefix.'banners',NULL,NULL,true);
		if (is_null($rows)) return;
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			$test=$GLOBALS['SITE_DB']->query_value_null_ok('banners','name',array('name'=>$row['name']));
			if (is_null($test))
			{
				$submitter=$on_same_msn?$row['submitter']:import_id_remap_get('member',$row['submitter'],true);
				if (is_null($submitter)) $submitter=$GLOBALS['FORUM_DRIVER']->get_guest_id();
				add_banner($row['name'],$row['img_url'],array_key_exists('b_title_text',$row)?$row['b_title_text']:'',$this->get_lang_string($db,$row['caption']),$row['campaign_remaining'],$row['site_url'],$row['importance_modulus'],$row['notes'],$row['the_type'],$row['expiry_date'],$submitter,$row['validated'],$row['b_type'],$row['add_date'],$row['hits_from'],$row['hits_to'],$row['views_from'],$row['views_to'],$row['edit_date']);
			}
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_points_gifts_and_charges($db,$table_prefix,$file_base)
	{
		require_code('points2');

		$rows=$db->query('SELECT * FROM '.$table_prefix.'chargelog',NULL,NULL,true);
		if (is_null($rows)) $rows=array();
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			$user=$on_same_msn?$row['user_id']:import_id_remap_get('member',$row['user_id'],true);
			if (is_null($user)) $user=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			add_to_charge_log($user,$row['amount'],$this->get_lang_string($db,$row['reason']),$row['date_and_time']);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'gifts',NULL,NULL,true);
		if (is_null($rows)) $rows=array();
		foreach ($rows as $row)
		{
			$viewer_member=$on_same_msn?$row['gift_from']:import_id_remap_get('member',$row['gift_from'],true);
			$member=$on_same_msn?$row['gift_to']:import_id_remap_get('member',$row['gift_to'],true);
			if (is_null($viewer_member)) $viewer_member=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			if (is_null($member)) $member=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			$GLOBALS['SITE_DB']->query_insert('gifts',array('date_and_time'=>$row['date_and_time'],'amount'=>$row['amount'],'gift_from'=>$viewer_member,'gift_to'=>$member,'reason'=>insert_lang_comcode($this->get_lang_string($db,$row['reason']),4),'anonymous'=>$row['anonymous']));
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'leader_board',NULL,NULL,true);
		if (is_null($rows)) $rows=array();
		foreach ($rows as $row)
		{
			$member=$on_same_msn?$row['lb_member']:import_id_remap_get('member',$row['lb_member'],true);
			if (is_null($member)) continue;
			$GLOBALS['SITE_DB']->query_delete('leader_board',array('lb_member'=>$member,'lb_points'=>$row['lb_points'],'date_and_time'=>$row['date_and_time']),'',1);
			$GLOBALS['SITE_DB']->query_insert('leader_board',array('lb_member'=>$member,'lb_points'=>$row['lb_points'],'date_and_time'=>$row['date_and_time']));
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_config($db,$table_prefix,$file_base)
	{
		$rows=$db->query('SELECT * FROM '.$table_prefix.'config');
		foreach ($rows as $row)
		{
			$name=$row['the_name'];
			$value=$row['config_value'];
			if ((!is_null($value)) && ((!array_key_exists('c_set',$row)) || ($row['c_set']==1)))
			{
				if (strpos($row['the_type'],'trans')!==false) $value=$this->get_lang_string($db,intval($value));
				$test=get_option($name,true);
				if (!is_null($test))
					set_option($name,$value);
			}
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_iotds($db,$table_prefix,$file_base)
	{
		require_code('iotds');
		
		$rows=$db->query('SELECT * FROM '.$table_prefix.'iotd',NULL,NULL,true);
		if (is_null($rows)) return;
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			if (import_check_if_imported('iotd',strval($row['id']))) continue;

			$submitter=$on_same_msn?$row['submitter']:import_id_remap_get('member',$row['submitter'],true);
			if (is_null($submitter)) $submitter=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			$id_new=add_iotd($row['url'],array_key_exists('i_title',$row)?$this->get_lang_string($db,$row['i_title']):'',$this->get_lang_string($db,$row['caption']),$row['thumb_url'],$row['is_current'],$row['allow_rating'],$row['allow_comments'],$row['allow_trackbacks'],$row['notes'],$row['add_date'],$submitter,$row['used'],$row['date_and_time'],$row['iotd_views'],$row['edit_date']);

			import_id_remap_put('iotd',strval($row['id']),$id_new);
		}
	}
	
	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_polls($db,$table_prefix,$file_base)
	{
		require_code('polls');
		
		$rows=$db->query('SELECT * FROM '.$table_prefix.'poll',NULL,NULL,true);
		if (is_null($rows)) return;
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			if (import_check_if_imported('poll',strval($row['id']))) continue;

			$submitter=$on_same_msn?$row['submitter']:import_id_remap_get('member',$row['submitter'],true);
			if (is_null($submitter)) $submitter=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			$id_new=add_poll( $this->get_lang_string($db,$row['question']),
									$this->get_lang_string($db,$row['option1']),
									$this->get_lang_string($db,$row['option2']),
									$this->get_lang_string($db,$row['option3']),
									$this->get_lang_string($db,$row['option4']),
									$this->get_lang_string($db,$row['option5']),
									array_key_exists('option6',$row)?$this->get_lang_string($db,$row['option6']):'',
									array_key_exists('option7',$row)?$this->get_lang_string($db,$row['option7']):'',
									array_key_exists('option8',$row)?$this->get_lang_string($db,$row['option8']):'',
									array_key_exists('option9',$row)?$this->get_lang_string($db,$row['option9']):'',
									array_key_exists('option10',$row)?$this->get_lang_string($db,$row['option10']):'',
									$row['num_options'],
									$row['is_current'],
									$row['allow_rating'],
									$row['allow_comments'],
									$row['allow_trackbacks'],
									$row['notes'],
									$row['add_time'],
									$submitter,
									$row['date_and_time'],
									$row['votes1'],
									$row['votes2'],
									$row['votes3'],
									$row['votes4'],
									$row['votes5'],
									array_key_exists('votes6',$row)?$row['votes6']:0,
									array_key_exists('votes7',$row)?$row['votes7']:0,
									array_key_exists('votes8',$row)?$row['votes8']:0,
									array_key_exists('votes9',$row)?$row['votes9']:0,
									array_key_exists('votes10',$row)?$row['votes10']:0,
									$row['poll_views'],
									$row['edit_date']);

			// Who has voted in the poll?
			$votes=$db->query('SELECT * FROM '.$table_prefix.'poll_votes WHERE pollID='.strval($row['id']),NULL,NULL,true);
			if (is_null($votes)) // Old ocPortal-style
			{
				$voters=explode('-',$row['ip']);
				$votes=array();
				foreach ($voters as $voter)
				{
					$votes[]=array(
						'v_poll_id'=>$row['id'],
						'v_voter_id'=>is_numeric($voter)?intval($voter):NULL,
						'v_voter_ip'=>is_numeric($voter)?NULL:$voter,
						'v_vote_for'=>NULL,
					);
				}
			}
			foreach ($votes as $vote)
			{
				$GLOBALS['SITE_DB']->query_insert('poll_votes',array(
					'v_poll_id'=>$id_new,
					'v_voter_id'=>$vote['v_voter_id'],
					'v_voter_ip'=>$vote['v_voter_ip'],
					'v_vote_for'=>$vote['v_vote_for'],
				));
			}

			import_id_remap_put('poll',strval($row['id']),$id_new);
		}
	}
	
	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_news_and_categories($db,$table_prefix,$file_base)
	{
		require_code('news');
		
		$rows=$db->query('SELECT * FROM '.$table_prefix.'news_categories ORDER BY id',NULL,NULL,true);
		if (is_null($rows)) return;
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			if (import_check_if_imported('news_category',strval($row['id']))) continue;

			$owner=$on_same_msn?$row['nc_owner']:import_id_remap_get('member',$row['nc_owner'],true);

			$id=(get_param_integer('keep_preserve_ids',0)==0)?NULL:$row['id'];
			$id_new=add_news_category($this->get_lang_string($db,$row['nc_title']),$row['nc_img'],$row['notes'],$owner,$id);

			import_id_remap_put('news_category',strval($row['id']),$id_new);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'news ORDER BY id');
		foreach ($rows as $row)
		{
			if (import_check_if_imported('news',strval($row['id']))) continue;

			$news_category=array();
			$rows2=$db->query('SELECT news_entry_category FROM '.$table_prefix.'news_category_entries WHERE news_entry='.strval((integer)$row['id']));
			foreach ($rows2 as $row2)
			{
				$next=import_id_remap_get('news_category',strval($row2['news_entry_category']),true);
				if (!is_null($next)) $news_category[]=$next;
			}
			$submitter=$on_same_msn?$row['submitter']:import_id_remap_get('member',$row['submitter'],true);
			if (is_null($submitter)) $submitter=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			$id=(get_param_integer('keep_preserve_ids',0)==0)?NULL:$row['id'];
			$id_new=add_news($this->get_lang_string($db,$row['title']),$this->get_lang_string($db,$row['news']),$row['author'],$row['validated'],$row['allow_rating'],$row['allow_comments'],$row['allow_trackbacks'],$row['notes'],$this->get_lang_string($db,$row['news_article']),$row['news_category'],$news_category,$row['date_and_time'],$submitter,$row['news_views'],$row['edit_date'],$id,$row['news_image']);

			import_id_remap_put('news',strval($row['id']),$id_new);
		}
	}
	
	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_newsletter_subscriptions($db,$table_prefix,$file_base)
	{
		$rows=$db->query('SELECT * FROM '.$table_prefix.'newsletters',NULL,NULL,true);
		if (!is_null($rows))
		{
			foreach ($rows as $row)
			{
				if (import_check_if_imported('newsletter',strval($row['id']))) continue;

				$new_id=$GLOBALS['SITE_DB']->query_insert('newsletters',array('title'=>insert_lang($this->get_lang_string($db,$row['title']),2),'description'=>insert_lang($this->get_lang_string($db,$row['description']),2)),true);

				import_id_remap_put('newsletter',strval($row['id']),$new_id);
			}
			
			$old_format=false;
		} else $old_format=true;
		$rowsn=$db->query('SELECT * FROM '.$table_prefix.'newsletter',NULL,NULL,true);
		if (is_null($rowsn)) return;
		$rows=array();
		foreach ($rowsn as $row)
		{
			$GLOBALS['SITE_DB']->query_delete('newsletter',array('email'=>$row['email'],'language'=>$row['language']),'',1);
			if (!array_key_exists('join_time',$row)) $row['join_time']=time()-(60*60*24*325);
			if (!array_key_exists('n_forename',$row)) $row['n_forename']='';
			if (!array_key_exists('n_surname',$row)) $row['n_surname']='';
			$GLOBALS['SITE_DB']->query_insert('newsletter',array('n_forename'=>$row['n_forename'],'n_surname'=>$row['n_surname'],'join_time'=>$row['join_time'],'email'=>$row['email'],'code_confirm'=>$row['code_confirm'],'pass_salt'=>array_key_exists('pass_salt',$row)?$row['pass_salt']:'','the_password'=>$row['the_password'],'language'=>$row['language']));
			if ($old_format)
			{
				$rows[]=array('newsletter_id'=>db_get_first_id(),'email'=>$row['email'],'the_level'=>$row['the_level']);
			}
		}
		if (!$old_format) $rows=$db->query('SELECT * FROM '.$table_prefix.'newsletter_subscribe');
		foreach ($rows as $row)
		{
			$newsletter_id=$row['newsletter_id'];
			if (!$old_format) $newsletter_id=import_id_remap_get('newsletter',$newsletter_id);
			$GLOBALS['SITE_DB']->query_insert('newsletter_subscribe',array('newsletter_id'=>$newsletter_id,'email'=>$row['email'],'the_level'=>$row['the_level']),false,true);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'newsletter_archive');
		foreach ($rows as $row)
		{
			$GLOBALS['SITE_DB']->query_insert('newsletter_archive',array('date_and_time'=>$row['date_and_time'],'subject'=>$row['subject'],'newsletter'=>$row['newsletter'],'language'=>$row['language'],'importance_level'=>$row['importance_level']));
		}
	}
	
	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_pointstore($db,$table_prefix,$file_base)
	{
		$rows=$db->query('SELECT * FROM '.$table_prefix.'prices',NULL,NULL,true);
		if (is_null($rows)) return;
		foreach ($rows as $row)
		{
			$GLOBALS['SITE_DB']->query_delete('prices',array('name'=>$row['name']),'',1);
			$GLOBALS['SITE_DB']->query_insert('prices',$row);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'sales');
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			$member_id=$on_same_msn?$row['memberid']:import_id_remap_get('member',$row['memberid'],true);
			if (is_null($member_id)) continue;
			unset($row['id']);
			$GLOBALS['SITE_DB']->query_insert('sales',array('date_and_time'=>$row['date_and_time'],'memberid'=>$member_id,'purchasetype'=>$row['purchasetype'],'details'=>$row['details'],'details2'=>$row['details2']));
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_flagrant($db,$table_prefix,$file_base)
	{
		$rows=$db->query('SELECT * FROM '.$table_prefix.'text',NULL,NULL,true);
		if (is_null($rows)) return;
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			$user_id=$on_same_msn?$row['user_id']:import_id_remap_get('member',$row['user_id'],true);
			if (is_null($user_id)) $user_id=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			unset($row['id']);
			$GLOBALS['SITE_DB']->query_insert('text',array('user_id'=>$user_id,'the_message'=>insert_lang($this->get_lang_string($db,$row['the_message']),2),'days'=>$row['days'],'order_time'=>$row['order_time'],'activation_time'=>$row['activation_time'],'active_now'=>$row['active_now'],'notes'=>$row['notes']));
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_downloads_and_categories($db,$table_prefix,$file_base)
	{
		require_code('downloads2');
		
		$rows=$db->query('SELECT * FROM '.$table_prefix.'download_categories ORDER BY id',NULL,NULL,true);
		if (is_null($rows)) return;
		foreach ($rows as $row)
		{
			if (import_check_if_imported('download_category',strval($row['id']))) continue;

			$id=(get_param_integer('keep_preserve_ids',0)==0)?NULL:$row['id'];
			$id=add_download_category($this->get_lang_string($db,$row['category']),-$row['parent_id'],$this->get_lang_string($db,$row['description']),$row['notes'],$row['rep_image'],$id);

			import_id_remap_put('download_category',strval($row['id']),$id);
		}

		foreach ($rows as $row)
		{
			$id=import_id_remap_get('download_category',strval($row['id']));
			$parent_id=import_id_remap_get('download_category',$row['parent_id'],true);
			if (is_null($parent_id)) $parent_id=db_get_first_id();

			$GLOBALS['SITE_DB']->query_update('download_categories',array('parent_id'=>$parent_id),array('id'=>$id),'',1);
		}

		$rows=$db->query('SELECT * FROM '.$table_prefix.'download_downloads ORDER BY id');
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			if (import_check_if_imported('download',strval($row['id']))) continue;
			$submitter=$on_same_msn?$row['submitter']:import_id_remap_get('member',$row['submitter'],true);
			if (is_null($submitter)) $submitter=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			$category_id=import_id_remap_get('download_category',strval($row['category_id']),true);
			if (is_null($category_id)) $category_id=db_get_first_id();
			$id=(get_param_integer('keep_preserve_ids',0)==0)?NULL:$row['id'];
			$id_new=add_download($category_id,$this->get_lang_string($db,$row['name']),$row['url'],$this->get_lang_string($db,$row['description']),$row['author'],$this->get_lang_string($db,$row['comments']),NULL,$row['validated'],$row['allow_rating'],$row['allow_comments'],$row['allow_trackbacks'],$row['notes'],$row['original_filename'],$row['file_size'],$row['download_cost'],$row['download_submitter_gets_points'],array_key_exists('download_licence',$row)?$row['download_licence']:NULL,$row['add_date'],$row['num_downloads'],$row['download_views'],$submitter,$row['edit_date'],$id);

			import_id_remap_put('download',strval($row['id']),$id_new);
		}
		foreach ($rows as $row)
		{
			if (!is_null($row['out_mode_id']))
			{
				$out_mode_id=import_id_remap_get('download',$row['out_mode_id'],true);
				if (is_null($out_mode_id)) $out_mode_id=NULL;
				$id_new=import_id_remap_get('download',strval($row['id']),true);
				if (is_null($id_new)) continue;
				$GLOBALS['SITE_DB']->query_update('download_downloads',array('out_mode_id'=>$out_mode_id),array('id'=>$id_new),'',1);
			}
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'download_logging');
		foreach ($rows as $row)
		{
			$id=import_id_remap_get('download',$row['id'],true);
			if (is_null($id)) continue;
			$user=$on_same_msn?$row['the_user']:import_id_remap_get('member',$row['the_user'],true);
			if (is_null($user)) $user=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			$test=$GLOBALS['SITE_DB']->query_value_null_ok('download_logging','ip',array('id'=>$id,'the_user'=>$user));
			if (is_null($test)) $GLOBALS['SITE_DB']->query_insert('download_logging',array('id'=>$id,'the_user'=>$user,'ip'=>$row['ip'],'date_and_time'=>$row['date_and_time']));
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_images_and_galleries($db,$table_prefix,$file_base)
	{
		require_code('galleries2');
		
		$rows=$db->query('SELECT * FROM '.$table_prefix.'galleries',NULL,NULL,true);
		if (is_null($rows)) return;
		foreach ($rows as $row)
		{
			$test=$GLOBALS['SITE_DB']->query_value_null_ok('galleries','name',array('name'=>$row['name']));
			if (is_null($test))
			{
				add_gallery($row['name'],$this->get_lang_string($db,$row['fullname']),$this->get_lang_string($db,$row['description']),$this->get_lang_string($db,$row['teaser']),$row['notes'],$row['parent_id'],$row['accept_images'],$row['accept_videos'],$row['is_member_synched'],$row['flow_mode_interface'],$row['rep_image'],$row['watermark_top_left'],$row['watermark_top_right'],$row['watermark_bottom_left'],$row['watermark_bottom_right'],$row['allow_rating'],$row['allow_comments'],false,$row['add_date']);
			}
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'images ORDER BY id');
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			if (import_check_if_imported('attachment',strval($row['id']))) continue;

			$submitter=$on_same_msn?$row['submitter']:import_id_remap_get('member',$row['submitter'],true);
			if (is_null($submitter)) $submitter=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			$id=(get_param_integer('keep_preserve_ids',0)==0)?NULL:$row['id'];
			$id_new=add_image(array_key_exists('title',$row)?$row['title']:'',$row['cat'],$this->get_lang_string($db,$row['comments']),$row['url'],$row['thumb_url'],$row['validated'],$row['allow_rating'],$row['allow_comments'],$row['allow_trackbacks'],$row['notes'],$submitter,$row['add_date'],$row['edit_date'],$row['image_views'],$id);

			import_id_remap_put('image',strval($row['id']),$id_new);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'videos ORDER BY id');
		foreach ($rows as $row)
		{
			if (import_check_if_imported('video',strval($row['id']))) continue;

			$submitter=$on_same_msn?$row['submitter']:import_id_remap_get('member',$row['submitter'],true);
			if (is_null($submitter)) $submitter=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			$id=(get_param_integer('keep_preserve_ids',0)==0)?NULL:$row['id'];
			$id_new=add_video(array_key_exists('title',$row)?$row['title']:'',$row['cat'],$this->get_lang_string($db,$row['comments']),$row['url'],$row['thumb_url'],$row['validated'],$row['allow_rating'],$row['allow_comments'],$row['allow_trackbacks'],$row['notes'],$row['video_length'],$row['video_width'],$row['video_height'],$submitter,$row['add_date'],$row['edit_date'],$row['video_views'],$id);

			import_id_remap_put('video',strval($row['id']),$id_new);
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_cedi($db,$table_prefix,$file_base)
	{
		if (!import_check_if_imported('cedi_page',strval(db_get_first_id())))
			import_id_remap_put('cedi_page',strval(db_get_first_id()),db_get_first_id());

		$rows_pages=$db->query('SELECT * FROM '.$table_prefix.'seedy_pages',NULL,NULL,true);
		if (is_null($rows_pages)) return;
		$titlemap=array();
		foreach ($rows_pages as $row)
		{
			$title=$this->get_lang_string($db,$row['title']);

			if (import_check_if_imported('cedi_page',strval($row['id'])))
			{
				$id=import_id_remap_get('cedi_page',strval($row['id']));
				$titlemap[$id]=$title;
				continue;
			}

			$titlemap[$id]=$title;
			$id=$GLOBALS['SITE_DB']->query_insert('seedy_pages',array('submitter'=>array_key_exists('submitter',$row)?$row['submitter']:get_member(),'hide_posts'=>array_key_exists('hide_posts',$row)?$row['hide_posts']:0,'seedy_views'=>array_key_exists('seedy_views',$row)?$row['seedy_views']:0,'notes'=>$row['notes'],'description'=>insert_lang_comcode($this->get_lang_string($db,$row['description']),2),'add_date'=>$row['add_date'],'title'=>insert_lang($title,2)),true);

			import_id_remap_put('cedi_page',strval($row['id']),$id);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'seedy_posts');
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			if (import_check_if_imported('cedi_post',strval($row['id']))) continue;
			
			$page_id=import_id_remap_get('cedi_page',$row['page_id'],true);
			if (is_null($page_id)) $page_id=db_get_first_id();

			$user=$on_same_msn?$row['the_user']:import_id_remap_get('member',$row['the_user'],true);
			if (is_null($user)) $user=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			$id_new=$GLOBALS['SITE_DB']->query_insert('seedy_posts',array('seedy_views'=>array_key_exists('seedy_views',$row)?$row['seedy_views']:0,'validated'=>array_key_exists('validated',$row)?$row['validated']:1,'the_message'=>insert_lang_comcode($this->get_lang_string($db,$row['the_message']),2),'the_user'=>$user,'date_and_time'=>$row['date_and_time'],'page_id'=>$page_id,'edit_date'=>$row['edit_date']),true);

			import_id_remap_put('cedi_post',strval($row['id']),$id_new);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'seedy_changes');
		foreach ($rows as $row)
		{
			$page_id=import_id_remap_get('cedi_page',$row['the_page'],true);
			if (is_null($page_id)) continue;
			
			$user=$on_same_msn?$row['the_user']:import_id_remap_get('member',$row['the_user'],true);
			if (is_null($user)) $user=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			$GLOBALS['SITE_DB']->query_insert('seedy_changes',array('the_action'=>$row['the_action'],'the_page'=>$page_id,'ip'=>$row['ip'],'the_user'=>$user,'date_and_time'=>$row['date_and_time']),false,true);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'seedy_children');
		foreach ($rows as $row)
		{
			$child_id=import_id_remap_get('cedi_page',$row['child_id'],true);
			$parent_id=import_id_remap_get('cedi_page',$row['parent_id'],true);
			
			if (is_null($child_id)) continue;
			if (is_null($parent_id)) continue;

			if (array_key_exists($child_id,$titlemap))
			{
				$title=$titlemap[$child_id];
			} elseif (array_key_exists($child_id,$rows_pages))
			{
				$title=$this->get_lang_string($db,$rows_pages[$child_id]['title']);
			} else continue;
			
			$GLOBALS['SITE_DB']->query_insert('seedy_children',array('parent_id'=>$parent_id,'child_id'=>$child_id,'the_order'=>$row['the_order'],'title'=>$titlemap[$child_id]),false,true);
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_custom_comcode($db,$table_prefix,$file_base)
	{
		$rows=$db->query('SELECT * FROM '.$table_prefix.'custom_comcode',NULL,NULL,true);
		if (is_null($rows)) return;
		foreach ($rows as $row)
		{
			$test=$GLOBALS['SITE_DB']->query_value_null_ok('custom_comcode','tag_tag',array('tag_tag'=>$row['tag_tag']));
			if (!is_null($test)) continue;

			$GLOBALS['SITE_DB']->query_insert('custom_comcode',array(
				'tag_tag'=>$row['tag_tag'],
				'tag_title'=>insert_lang($this->get_lang_string($db,$row['tag_title']),3),
				'tag_description'=>insert_lang($this->get_lang_string($db,$row['tag_description']),3),
				'tag_replace'=>$row['tag_replace'],
				'tag_example'=>$row['tag_example'],
				'tag_parameters'=>$row['tag_parameters'],
				'tag_enabled'=>$row['tag_enabled'],
				'tag_dangerous_tag'=>$row['tag_dangerous_tag'],
				'tag_block_tag'=>$row['tag_block_tag'],
				'tag_textual_tag'=>$row['tag_textual_tag']
			));
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_wordfilter($db,$table_prefix,$file_base)
	{
		require_code('word_filter');
		
		$rows=$db->query('SELECT word FROM '.$table_prefix.'wordfilter',NULL,NULL,true);
		if (is_null($rows)) return;
		foreach ($rows as $row)
		{
			add_wordfilter_word($row['word'],array_key_exists('w_replacement',$row)?$row['w_replacement']:'',array_key_exists('w_substr',$row)?$row['w_substr']:0);
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_calendar($db,$table_prefix,$file_base)
	{
		require_code('calendar2');
		
		$rows=$db->query('SELECT * FROM '.$table_prefix.'calendar_types',NULL,NULL,true);
		if (is_null($rows)) return;
		foreach ($rows as $row)
		{
			if (import_check_if_imported('event_type',strval($row['id']))) continue;

			$id_new=add_event_type($this->get_lang_string($db,$row['t_title']),$row['t_logo'],array_key_exists('t_external_feed',$row)?$row['t_external_feed']:'');

			import_id_remap_put('event_type',strval($row['id']),$id_new);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'calendar_interests',NULL,NULL,true);
		if (is_null($rows))
			$rows=$db->query('SELECT * FROM '.$table_prefix.'calendar_declarations_of_interest');
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			$member=$on_same_msn?$row['i_member_id']:import_id_remap_get('member',$row['i_member_id'],true);
			if (is_null($member)) continue;
			$type=import_id_remap_get('event_type',strval($row['t_type']));
			$GLOBALS['SITE_DB']->query_delete('calendar_interests',array('i_member_id'=>$member,'t_type'=>$type),'',1);
			$GLOBALS['SITE_DB']->query_insert('calendar_interests',array('i_member_id'=>$member,'t_type'=>$type));
		}
		$event_rows=$db->query('SELECT * FROM '.$table_prefix.'calendar_events ORDER BY id');
		foreach ($event_rows as $row)
		{
			if (import_check_if_imported('event',strval($row['id']))) continue;

			$submitter=$on_same_msn?$row['e_submitter']:import_id_remap_get('member',strval($row['e_submitter']),true);
			if (is_null($submitter)) $submitter=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			$type=import_id_remap_get('event_type',strval($row['e_type']));

			if (!array_key_exists('validated',$row)) $row['validated']=1;
			if (!array_key_exists('notes',$row)) $row['notes']='';
			if (!array_key_exists('allow_rating',$row)) $row['allow_rating']=1;
			if (!array_key_exists('allow_comments',$row)) $row['allow_comments']=1;
			if (!array_key_exists('allow_trackbacks',$row)) $row['allow_trackbacks']=1;
			$id=(get_param_integer('keep_preserve_ids',0)==0)?NULL:$row['id'];
			$id_new=add_calendar_event($type,$row['e_recurrence'],$row['e_recurrences'],array_key_exists('e_seg_recurrences',$row)?$row['e_seg_recurrences']:0,$this->get_lang_string($db,$row['e_title']),$this->get_lang_string($db,$row['e_content']),$row['e_priority'],$row['e_is_public'],$row['e_start_year'],$row['e_start_month'],$row['e_start_day'],$row['e_start_hour'],$row['e_start_minute'],$row['e_end_year'],$row['e_end_month'],$row['e_end_day'],$row['e_end_hour'],$row['e_end_minute'],array_key_exists('e_timezone',$row)?$row['e_timezone']:NULL,array_key_exists('e_do_timezone_conv',$row)?$row['e_do_timezone_conv']:1,$row['validated'],$row['allow_rating'],$row['allow_comments'],$row['allow_trackbacks'],$row['notes'],$submitter,$row['e_views'],$row['e_add_date'],$row['e_edit_date'],$id);

			import_id_remap_put('event',strval($row['id']),$id_new);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'calendar_reminders');
		foreach ($rows as $row)
		{
			$event=import_id_remap_get('event',strval($row['e_id']));
			$member=$on_same_msn?$row['n_member_id']:import_id_remap_get('member',strval($row['n_member_id']),true);
			if (is_null($member)) continue;
			$GLOBALS['SITE_DB']->query_insert('calendar_reminders',array('e_id'=>$event,'n_member_id'=>$member,'n_seconds_before'=>$row['n_seconds_before']));
		}

		require_code('calendar');
		foreach ($event_rows as $row)
		{
			regenerate_event_reminder_jobs(import_id_remap_get('event',strval($row['id'])));
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_redirects($db,$table_prefix,$file_base)
	{
		$rows=$db->query('SELECT * FROM '.$table_prefix.'redirects');
		foreach ($rows as $row)
		{
			$GLOBALS['SITE_DB']->query_insert('redirects',$row,false,true); // Allow failure if row already there
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_stats($db,$table_prefix,$file_base)
	{
		$row_start=0;
		$rows=array();
		$on_same_msn=($this->on_same_msn($file_base));
		do
		{
			$rows=$db->query('SELECT * FROM '.$table_prefix.'stats',200,$row_start);
			foreach ($rows as $row)
			{
				unset($row['regionality']);
				
				$row['the_user']=$on_same_msn?$row['the_user']:import_id_remap_get('member',$row['the_user'],true);
				if (is_null($row['the_user'])) $row['the_user']=$GLOBALS['FORUM_DRIVER']->get_guest_id();
				unset($row['id']);
				$GLOBALS['SITE_DB']->query_insert('stats',$row);
			}
			$row_start+=200;
		}
		while (count($rows)>0);
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_themes($db,$table_prefix,$file_base)
	{
		$rows=$db->query('SELECT * FROM '.$table_prefix.'theme_images WHERE path LIKE \''.db_encode_like('%/images_custom/%').'\'');
		foreach ($rows as $row)
		{
			$GLOBALS['SITE_DB']->query_delete('theme_images',$row,'',1);
			$GLOBALS['SITE_DB']->query_insert('theme_images',$row,false,true); // Allow failure if row already there
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_support_tickets($db,$table_prefix,$file_base)
	{
		$rows=$db->query('SELECT * FROM '.$table_prefix.'ticket_types',NULL,NULL,true);
		if (is_null($rows)) return;
		foreach ($rows as $row)
		{
			$GLOBALS['SITE_DB']->query_insert('ticket_types',array('search_faq'=>array_key_exists('search_faq',$row)?$row['search_faq']:0,'guest_emails_mandatory'=>array_key_exists('guest_emails_mandatory',$row)?$row['guest_emails_mandatory']:0,'ticket_type'=>insert_lang($this->get_lang_string($db,$row['ticket_type']),1)));
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_useronline_tracking($db,$table_prefix,$file_base)
	{
		$rows=$db->query('SELECT * FROM '.$table_prefix.'usersonline_track');
		foreach ($rows as $row)
		{
			$GLOBALS['SITE_DB']->query_insert('usersonline_track',$row,false,true); // Allow failure if row already there
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_ip_bans($db,$table_prefix,$file_base)
	{
		require_code('failure');

		$rows=$db->query('SELECT * FROM '.$table_prefix.'usersubmitban_ip');
		foreach ($rows as $row)
		{
			add_ip_ban($row['ip'],array_key_exists('i_descrip',$row)?$row['i_descrip']:'',array_key_exists('i_ban_until',$row)?$row['i_ban_until']:NULL,array_key_exists('i_ban_positive',$row)?($row['i_ban_positive']==1):1);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'usersubmitban_member');
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			$member=$on_same_msn?$row['the_member']:import_id_remap_get('member',$row['the_member'],true);
			if (is_null($member)) continue;
			$GLOBALS['SITE_DB']->query_insert('usersubmitban_member',array('the_member'=>$member));
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_zones($db,$table_prefix,$file_base)
	{
		$rows=$db->query('SELECT * FROM '.$table_prefix.'zones');
		foreach ($rows as $row)
		{
			$test=$GLOBALS['SITE_DB']->query_value_null_ok('zones','zone_name',array('zone_name'=>$row['zone_name']));
			if ((is_null($test)) && ($test!='seedy') && ($test!='supermembercentre') && ($test!='admincentre') && ($test!='membersonly') && ($test!='personalcentre') && ($test!='membercentre'))
			{
				if (!array_key_exists('zone_displayed_in_menu',$row)) $row['zone_displayed_in_menu']=1;
				$old_title=$this->get_lang_string($db,$row['zone_title']);
				$row['zone_title']=array_key_exists('zone_title',$row)?insert_lang($old_title,1):insert_lang($row['zone_name'],1);
				$row['zone_header_text']=insert_lang($this->get_lang_string($db,$row['zone_header_text']),1);
				unset($row['access_denied_counter']); // Just to support old-version compatibility a little
				$GLOBALS['SITE_DB']->query_insert('zones',$row);

				require_code('menus2');
				add_menu_item_simple('zone_menu',NULL,$old_title,$row['zone_name'].':'.$row['zone_default_page'],0,1);
			}
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_catalogues($db,$table_prefix,$file_base)
	{
		require_code('catalogues2');
		
		$rows=$db->query('SELECT * FROM '.$table_prefix.'catalogues',NULL,NULL,true);
		if (is_null($rows)) return;
		foreach ($rows as $row)
		{
			$test=$GLOBALS['SITE_DB']->query_value_null_ok('catalogues','c_name',array('c_name'=>$row['c_name']));
			if (is_null($test))
			{
				$row['c_title']=insert_lang($this->get_lang_string($db,$row['c_title']),2);
				$row['c_description']=insert_lang($this->get_lang_string($db,$row['c_description']),2);
				if (!array_key_exists('c_display_type',$row))
				{
					$row['c_display_type']=$row['c_own_pages'];
					unset($row['c_own_pages']);
				}
				if (!array_key_exists('c_ecommerce',$row)) $row['c_ecommerce']=0;
				if (!array_key_exists('c_send_view_reports',$row)) $row['c_send_view_reports']=0;
				unset($row['c_own_template']);
				$GLOBALS['SITE_DB']->query_insert('catalogues',$row);

				$rows2=$db->query('SELECT * FROM '.$table_prefix.'catalogue_fields WHERE '.db_string_equal_to('c_name',$row['c_name']));
				foreach ($rows2 as $row2)
				{
					if (import_check_if_imported('catalogue_field',strval($row2['id']))) continue;

					$row2['cf_name']=insert_lang($this->get_lang_string($db,$row2['cf_name']),2);
					$row2['cf_description']=insert_lang($this->get_lang_string($db,$row2['cf_description']),2);
					if (!array_key_exists('cf_put_in_category',$row2)) $row2['cf_put_in_category']=1;
					if (!array_key_exists('cf_put_in_search',$row2)) $row2['cf_put_in_search']=1;
					$old_id=$row2['id'];
					unset($row2['id']);
					$id_new=$GLOBALS['SITE_DB']->query_insert('catalogue_fields',$row2,true);
					import_id_remap_put('catalogue_field',$old_id,$id_new);
				}
			}
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'catalogue_categories ORDER BY id');
		$id=mixed();
		foreach ($rows as $row)
		{
			if (import_check_if_imported('catalogue_category',strval($row['id']))) continue;

			$id=(get_param_integer('keep_preserve_ids',0)==0)?NULL:$row['id'];
			$rep_image=array_key_exists('cc_rep_image',$row)?$row['cc_rep_image']:'';
			$id_new=actual_add_catalogue_category($row['c_name'],$this->get_lang_string($db,$row['cc_title']),$this->get_lang_string($db,$row['cc_description']),$row['cc_notes'],is_null($row['cc_parent_id'])?NULL:-$row['cc_parent_id'],$rep_image,array_key_exists('cc_move_days_lower',$row)?$row['cc_move_days_lower']:30,array_key_exists('cc_move_days_higher',$row)?$row['cc_move_days_higher']:60,array_key_exists('cc_move_target',$row)?$row['cc_move_target']:NULL,$row['cc_add_date'],$id);

			import_id_remap_put('catalogue_category',strval($row['id']),$id_new);
		}
		$rows=$GLOBALS['SITE_DB']->query('SELECT id,cc_parent_id FROM '.$GLOBALS['SITE_DB']->get_table_prefix().'catalogue_categories WHERE cc_parent_id<0');
		foreach ($rows as $row)
		{
			$parent_id=import_id_remap_get('catalogue_category',-$row['cc_parent_id'],true);
			$GLOBALS['SITE_DB']->query_update('catalogue_categories',array('cc_parent_id'=>$parent_id),array('id'=>$row['id']),'',1);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'catalogue_entries ORDER BY id');
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			if (import_check_if_imported('catalogue_entry',strval($row['id']))) continue;

			$category_id=import_id_remap_get('catalogue_category',$row['cc_id'],true);
			if (is_null($category_id)) continue;
			$map=array();

			// Tedious...
			foreach (array('long','short','float','integer') as $table)
			{
				$rows2=$db->query('SELECT * FROM '.$table_prefix.'catalogue_efv_'.$table.' WHERE ce_id='.strval((integer)$row['id']),NULL,NULL,true);
				if (!is_null($rows2)) // Older versions of ocPortal don't have float and integer
				{
					foreach ($rows2 as $row2)
					{
						$remapped=import_id_remap_get('catalogue_field',$row2['cf_id'],true);
						if (is_null($remapped)) continue;
						$value=$row2['cv_value'];
						if (is_integer($value)) $value=strval($value);
						elseif (is_float($value)) $value=float_to_raw_string($value);
						$map[$remapped]=$value;
					}
				}
			}
			$rows2=$db->query('SELECT * FROM '.$table_prefix.'catalogue_efv_long_trans WHERE ce_id='.strval((integer)$row['id']));
			foreach ($rows2 as $row2)
			{
				$remapped=import_id_remap_get('catalogue_field',$row2['cf_id'],true);
				if (is_null($remapped)) continue;
				$map[$remapped]=$this->get_lang_string($db,$row2['cv_value']);
			}
			$rows2=$db->query('SELECT * FROM '.$table_prefix.'catalogue_efv_short_trans WHERE ce_id='.strval((integer)$row['id']));
			foreach ($rows2 as $row2)
			{
				$remapped=import_id_remap_get('catalogue_field',$row2['cf_id'],true);
				if (is_null($remapped)) continue;
				$map[$remapped]=$this->get_lang_string($db,$row2['cv_value']);
			}
			$submitter=$on_same_msn?$row['ce_submitter']:import_id_remap_get('member',$row['ce_submitter'],true);
			if (is_null($submitter)) $submitter=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			$id=(get_param_integer('keep_preserve_ids',0)==0)?NULL:$row['id'];
			$id_new=actual_add_catalogue_entry($category_id,$row['ce_validated'],$row['notes'],$row['allow_rating'],$row['allow_comments'],$row['allow_trackbacks'],$map,$row['ce_add_date'],$submitter,$row['ce_edit_date'],$row['ce_views'],$id);

			import_id_remap_put('catalogue_entry',strval($row['id']),$id_new);
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_chat_rooms($db,$table_prefix,$file_base)
	{
		require_code('chat2');
		
		$rows=$db->query('SELECT * FROM '.$table_prefix.'chat_rooms WHERE is_im=0 ORDER BY id',NULL,NULL,true);
		if (is_null($rows)) return;
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			$test=$GLOBALS['SITE_DB']->query_value_null_ok('chat_rooms','id',array('room_name'=>$row['room_name']));
			if (!is_null($test)) continue;

			$row['room_owner']=$on_same_msn?$row['room_owner']:import_id_remap_get('member',$row['room_owner'],true);
			$row['c_welcome']=insert_lang($this->get_lang_string($db,$row['c_welcome']),2);

			$_disallow_list_groups=explode(',',$row['disallow_list_groups']);
			$row['disallow_list_groups']='';
			foreach ($_disallow_list_groups as $x)
				$row['disallow_list_groups'].=($on_same_msn?$x:strval(import_id_remap_get('group',$x,true))).',';
			$_allow_list_groups=explode(',',$row['allow_list']);
			$row['allow_list_groups']='';
			foreach ($_allow_list_groups as $x)
				$row['allow_list_groups'].=($on_same_msn?$x:strval(import_id_remap_get('group',$x,true))).',';
			$_disallow_list=explode(',',$row['disallow_list']);
			$row['disallow_list']='';
			foreach ($_disallow_list as $x)
				$row['disallow_list'].=($on_same_msn?$x:strval(import_id_remap_get('member',$x,true))).',';
			$_allow_list=explode(',',$row['allow_list']);
			$row['allow_list']='';
			foreach ($_allow_list as $x)
				$row['allow_list'].=($on_same_msn?$x:strval(import_id_remap_get('member',$x,true))).',';


			if (get_param_integer('keep_preserve_ids',0)==0) unset($row['id']);
			$GLOBALS['SITE_DB']->query_insert('chat_rooms',$row);
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_awards($db,$table_prefix,$file_base)
	{
		$content_types=array();
		$rows=$db->query('SELECT * FROM '.$table_prefix.'award_types',NULL,NULL,true);
		if (is_null($rows)) return;
		foreach ($rows as $row)
		{
			$content_types[$row['id']]=$row['a_content_type'];

			if (import_check_if_imported('award_type',strval($row['id']))) continue;

			$row['a_title']=insert_lang($this->get_lang_string($db,$row['a_title']),2);
			$row['a_description']=insert_lang($this->get_lang_string($db,$row['a_description']),2);

			$id_old=$row['id'];
			unset($row['id']);
			$id_new=$GLOBALS['SITE_DB']->query_insert('award_types',$row,true);

			import_id_remap_put('award_type',strval($id_old),$id_new);
		}

		$rows=$db->query('SELECT * FROM '.$table_prefix.'award_archive');
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			if (import_check_if_imported('awarded',strval($row['date_and_time']))) continue;

			$row['member_id']=$on_same_msn?$row['member_id']:import_id_remap_get('member',$row['member_id'],true);
			if (is_null($row['member_id'])) $row['member_id']=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			if (!is_string($row['content_id'])) $row['content_id']=import_id_remap_get($content_types[$row['a_type_id']],$row['content_id']);
			$row['a_type_id']=import_id_remap_get('award_type',strval($row['a_type_id']));
			$GLOBALS['SITE_DB']->query_insert('award_archive',$row);

			import_id_remap_put('awarded',strval($row['date_and_time']),$row['date_and_time']);
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_filedump($db,$table_prefix,$file_base)
	{
		$rows=$db->query('SELECT * FROM '.$table_prefix.'filedump',NULL,NULL,true);
		if (is_null($rows)) return;
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			$row['description']=insert_lang($this->get_lang_string($db,$row['description']),2);
			$row['the_member']=$on_same_msn?$row['the_member']:import_id_remap_get('member',$row['the_member'],true);
			if (is_null($row['the_member'])) $row['the_member']=$GLOBALS['FORUM_DRIVER']->get_guest_id();
			$GLOBALS['SITE_DB']->query_insert('filedump',$row);
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_permissions($db,$table_prefix,$file_base)
	{
		$rows=$db->query('SELECT * FROM '.$table_prefix.'gsp');
		$on_same_msn=($this->on_same_msn($file_base));
		foreach ($rows as $row)
		{
			$row['group_id']=$on_same_msn?$row['group_id']:import_id_remap_get('group',$row['group_id'],true);
			if (is_null($row['group_id'])) continue;
			$row_temp=$row;
			unset($row_temp['the_value']);
			$GLOBALS['SITE_DB']->query_delete('gsp',$row_temp,'',1);
			if (!array_key_exists('the_page',$row)) $row['the_page']='';
			if (!array_key_exists('module_the_name',$row)) $row['module_the_name']='';
			if (!array_key_exists('category_name',$row)) $row['category_name']='';
			if (!array_key_exists('the_value',$row)) $row['the_value']='1';
			$GLOBALS['SITE_DB']->query_insert('gsp',$row);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'group_page_access');
		foreach ($rows as $row)
		{
			$row['group_id']=$on_same_msn?$row['group_id']:import_id_remap_get('group',$row['group_id'],true);
			if (is_null($row['group_id'])) continue;
			$GLOBALS['SITE_DB']->query_delete('group_page_access',$row,'',1);
			$GLOBALS['SITE_DB']->query_insert('group_page_access',$row);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'group_zone_access');
		foreach ($rows as $row)
		{
			$row['group_id']=$on_same_msn?$row['group_id']:import_id_remap_get('group',$row['group_id'],true);
			if (is_null($row['group_id'])) continue;
			$GLOBALS['SITE_DB']->query_delete('group_zone_access',$row,'',1);
			$GLOBALS['SITE_DB']->query_insert('group_zone_access',$row);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'https_pages');
		foreach ($rows as $row)
		{
			$GLOBALS['SITE_DB']->query_delete('https_pages',$row);
			$GLOBALS['SITE_DB']->query_insert('https_pages',$row);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'group_category_access');
		foreach ($rows as $row)
		{
			$row['group_id']=$on_same_msn?$row['group_id']:import_id_remap_get('group',$row['group_id'],true);
			if (is_null($row['group_id'])) continue;
			if (is_numeric($row['category_name']))
			{
				$module=$row['module_the_name'];
				switch ($module)
				{
					case 'galleries':
						$module='gallery';
						break;
					case 'downloads':
						$module='download';
						break;
					case 'calendar':
						$module='event_type';
						break;
					case 'catalogues_catalogue':
						$module='catalogue';
						break;
				}
				$id_new=import_id_remap_get($module,$row['category_name'],true);
				if (!is_null($id_new)) $row['category_name']=strval($id_new);
			}
			$GLOBALS['SITE_DB']->query_delete('group_category_access',$row,'',1);
			$GLOBALS['SITE_DB']->query_insert('group_category_access',$row);
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_ocf_groups($db,$table_prefix,$file_base)
	{
		if ($this->on_same_msn($file_base)) return;
	
		$rows=$db->query('SELECT * FROM '.$table_prefix.'f_groups');
		foreach ($rows as $row)
		{
			if (import_check_if_imported('group',strval($row['id']))) continue;

			$name=$this->get_lang_string($db,$row['g_name']);
			$id_new=$GLOBALS['FORUM_DB']->query_value_null_ok('f_groups g LEFT JOIN '.$GLOBALS['FORUM_DB']->get_table_prefix().'translate t ON g.g_name=t.id WHERE '.db_string_equal_to('text_original',$name),'g.id');
			if (is_null($id_new))
			{
				$title=$this->get_lang_string($db,$row['g_title']);
				if (!array_key_exists('g_is_presented_at_install',$row)) $row['g_is_presented_at_install']=0;
				$id_new=ocf_make_group($name,array_key_exists('g_is_default',$row)?$row['g_is_default']:0,$row['g_is_super_admin'],$row['g_is_super_moderator'],$title,'',$row['g_promotion_target'],$row['g_promotion_threshold'],-$row['g_group_leader'],$row['g_flood_control_submit_secs'],$row['g_flood_control_access_secs'],$row['g_max_daily_upload_mb'],$row['g_max_attachments_per_post'],$row['g_max_avatar_width'],$row['g_max_avatar_height'],$row['g_max_post_length_comcode'],$row['g_max_sig_length_comcode'],$row['g_gift_points_base'],$row['g_gift_points_per_day'],$row['g_enquire_on_new_ips'],$row['g_is_presented_at_install'],array_key_exists('g_hidden',$row)?$row['g_hidden']:0,array_key_exists('g_order',$row)?$row['g_order']:NULL,array_key_exists('g_rank_image_pri_only',$row)?$row['g_rank_image_pri_only']:0,array_key_exists('g_open_membership',$row)?$row['g_open_membership']:0,array_key_exists('g_is_private_club',$row)?$row['g_is_private_club']:0);
			}

			import_id_remap_put('group',strval($row['id']),$id_new);
		}

		// Now we must fix promotion
		foreach ($rows as $row)
		{
			if (!is_null($row['g_promotion_target']))
			{
				$row_promotion_target=import_id_remap_get('group',strval($row['g_promotion_target']));
				$GLOBALS['FORUM_DB']->query_update('f_groups',array('g_promotion_target'=>$row_promotion_target),array('id'=>import_id_remap_get('group',strval($row['id']))),'',1);
			}
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_ocf_members($db,$table_prefix,$file_base)
	{
		if ($this->on_same_msn($file_base)) return;
	
		$row_start=0;
		$rows=array();
		do
		{
			$rows=$db->query('SELECT * FROM '.$table_prefix.'f_members ORDER BY id',200,$row_start);
			foreach ($rows as $row)
			{
				if (import_check_if_imported('member',strval($row['id']))) continue;

				$test=$GLOBALS['OCF_DRIVER']->get_member_from_username($row['m_username']);
				if (!is_null($test))
				{
					// Fix usergroup leadership
					$GLOBALS['FORUM_DB']->query_update('f_groups',array('g_group_leader'=>$test),array('g_group_leader'=>-$row['id']));

					import_id_remap_put('member',strval($row['id']),$test);
					continue;
				}

				$primary_group=import_id_remap_get('group',strval($row['m_primary_group']));

				$custom_fields=array();
				$id=(get_param_integer('keep_preserve_ids',0)==0)?NULL:$row['id'];
				$timezone=$row['m_timezone_offset'];
				if (is_integer($timezone)) $timezone=strval($timezone);
				if (!isset($row['m_auto_alert_contrib_content'])) $row['m_auto_alert_contrib_content']=$row['m_track_contributed_topics'];
				$id_new=ocf_make_member($row['m_username'],$row['m_pass_hash_salted'],$row['m_email_address'],NULL,$row['m_dob_day'],$row['m_dob_month'],$row['m_dob_year'],$custom_fields,$timezone,$primary_group,$row['m_validated'],$row['m_join_time'],$row['m_last_visit_time'],$row['m_theme'],$row['m_avatar_url'],$this->get_lang_string($db,$row['m_signature']),$row['m_is_perm_banned'],$row['m_preview_posts'],$row['m_reveal_age'],$row['m_title'],$row['m_photo_url'],$row['m_photo_thumb_url'],$row['m_views_signatures'],$row['m_auto_alert_contrib_content'],$row['m_language'],$row['m_allow_emails'],array_key_exists('m_allow_emails_from_staff',$row)?$row['m_allow_emails_from_staff']:$row['m_allow_emails'],$row['m_notes'],$row['m_ip_address'],$row['m_validated_email_confirm_code'],false,array_key_exists('m_password_compat_scheme',$row)?$row['m_password_compat_scheme']:$row['m_password_compatibility_scheme'],$row['m_pass_salt'],$row['m_zone_wide'],$row['m_last_submit_time'],$id,array_key_exists('m_highlighted_name',$row)?$row['m_highlighted_name']:0,array_key_exists('m_pt_allow',$row)?$row['m_pt_allow']:'*',array_key_exists('m_pt_rules_text',$row)?$this->get_lang_string($db,$row['m_pt_rules_text']):'');
				$rows2=$db->query('SELECT * FROM '.$table_prefix.'f_member_custom_fields WHERE mf_member_id='.strval((integer)$row['id']),1);
				if (array_key_exists(0,$rows2))
				{
					$row2=array();
					foreach ($rows2[0] as $key=>$val)
					{
						if (is_null($val)) $val='';
						if (substr($key,0,6)=='field_')
							$row2['field_'.strval(import_id_remap_get('cpf',substr($key,6)))]=$val;
					}
					$GLOBALS['SITE_DB']->query_update('f_member_custom_fields',$row2,array('mf_member_id'=>$id_new),'',1);
				}

				// Fix some tricky dependences that we shoved to one side
				$GLOBALS['FORUM_DB']->query_update('f_groups',array('g_group_leader'=>$id_new),array('g_group_leader'=>-$row['id']));
				$GLOBALS['SITE_DB']->query_update('attachments',array('a_member_id'=>$id_new),array('a_member_id'=>-$row['id']));

				import_id_remap_put('member',strval($row['id']),$id_new);
			}

			$row_start+=200;
		}
		while (count($rows)>0);

		// Group membership
		$rows=$db->query('SELECT * FROM '.$table_prefix.'f_group_members');
		foreach ($rows as $row)
		{
			$row['gm_group_id']=import_id_remap_get('group',strval($row['gm_group_id']));
			$row['gm_member_id']=import_id_remap_get('member',strval($row['gm_member_id']));
			$GLOBALS['SITE_DB']->query_insert('f_group_members',$row,false,true);
		}

		// Known login IPs
		$rows=$db->query('SELECT * FROM '.$table_prefix.'f_member_known_login_ips');
		foreach ($rows as $row)
		{
			$row['i_member_id']=import_id_remap_get('member',strval($row['i_member_id']));
			$GLOBALS['SITE_DB']->query_insert('f_member_known_login_ips',$row);
		}
	}
	
	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_ocf_custom_profile_fields($db,$table_prefix,$file_base)
	{
		if ($this->on_same_msn($file_base)) return;
	
		$rows=$db->query('SELECT * FROM '.$table_prefix.'f_custom_fields');
		foreach ($rows as $row)
		{
			if (import_check_if_imported('cpf',strval($row['id']))) continue;

			$name=$this->get_lang_string($db,$row['cf_name']);
			$existing=$GLOBALS['FORUM_DB']->query_select('f_custom_fields f LEFT JOIN '.$GLOBALS['FORUM_DB']->get_table_prefix().'translate t ON f.cf_name=t.id',array('f.id','cf_type'),array('text_original'=>$name),'',1);
			if ((!array_key_exists(0,$existing)) || ($existing[0]['cf_type']!=$row['cf_type']))
			{
				$only_group=$row['cf_only_group'];
				if ($only_group!='')
				{
					$only_group2='';
					foreach (explode(',',$only_group) as $_only_group)
					{
						if ($only_group2!='') $only_group2.=',';
						$only_group2.=strval(import_id_remap_get('group',$_only_group));
					}
					$only_group2=$only_group;
				}
				$id_new=ocf_make_custom_field($name,$row['cf_locked'],$this->get_lang_string($db,$row['cf_description']),$row['cf_default'],$row['cf_public_view'],$row['cf_owner_view'],$row['cf_owner_set'],array_key_exists('cf_encrypted',$row)?$row['cf_encrypted']:0,$row['cf_type'],$row['cf_required'],$row['cf_show_in_posts'],$row['cf_show_in_post_previews'],$row['cf_order'],(!is_string($only_group))?(is_null($only_group)?'':strval($only_group)):$only_group);
			} else
			{
				$id_new=$existing[0]['id'];
			}

			import_id_remap_put('cpf',strval($row['id']),$id_new);
		}
	}
	
	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_ocf_categories($db,$table_prefix,$file_base)
	{
		if ($this->on_same_msn($file_base)) return;
	
		$rows=$db->query('SELECT * FROM '.$table_prefix.'f_categories');
		foreach ($rows as $row)
		{
			if (import_check_if_imported('category',strval($row['id']))) continue;
	
			$title=$row['c_title'];

			$test=$GLOBALS['FORUM_DB']->query_value_null_ok('f_categories','id',array('c_title'=>$title));
			if (!is_null($test))
			{
				import_id_remap_put('category',strval($row['id']),$test);
				continue;
			}

			$id_new=ocf_make_category($title,$row['c_description'],$row['c_expanded_by_default']);

			import_id_remap_put('category',strval($row['id']),$id_new);
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_ocf_forums($db,$table_prefix,$file_base)
	{
		if ($this->on_same_msn($file_base)) return;
	
		require_code('ocf_forums_action2');

		$rows=$db->query('SELECT * FROM '.$table_prefix.'f_forums');
		foreach ($rows as $row)
		{
			$remapped=import_id_remap_get('forum',strval($row['id']),true);
			if (!is_null($remapped))
			{
				continue;
			}
			if ($row['id']==db_get_first_id())
			{
				import_id_remap_put('forum',strval(db_get_first_id()),db_get_first_id());
				continue;
			}

			$category_id=import_id_remap_get('category',strval($row['f_category_id']),true);

			$id_new=ocf_make_forum($row['f_name'],$this->get_lang_string($db,$row['f_description']),$category_id,array(),db_get_first_id(),$row['f_position'],$row['f_post_count_increment'],$row['f_order_sub_alpha'],$this->get_lang_string($db,$row['f_intro_question']),$row['f_intro_answer'],$row['f_redirection'],array_key_exists('f_order',$row)?$row['f_order']:'last_post');
			import_id_remap_put('forum',strval($row['id']),$id_new);
		}

		// Now we must fix parenting
		foreach ($rows as $row)
		{
			if (is_null($row['f_parent_forum'])) continue;
			$parent_id=import_id_remap_get('forum',strval($row['f_parent_forum']));
			$GLOBALS['FORUM_DB']->query_update('f_forums',array('f_parent_forum'=>$parent_id),array('id'=>import_id_remap_get('forum',strval($row['id']))),'',1);
		}

		// Intros
		$rows=$db->query('SELECT * FROM '.$table_prefix.'f_forum_intro_ip');
		foreach ($rows as $row)
		{
			$row['i_forum_id']=import_id_remap_get('forum',strval($row['i_forum_id']));
			$GLOBALS['FORUM_DB']->query_delete('f_forum_intro_ip',$row,'',1);
			$GLOBALS['FORUM_DB']->query_insert('f_forum_intro_ip',$row);
		}
		$rows=$db->query('SELECT * FROM '.$table_prefix.'f_forum_intro_member');
		foreach ($rows as $row)
		{
			$row['i_forum_id']=import_id_remap_get('forum',strval($row['i_forum_id']));
			$GLOBALS['FORUM_DB']->query_delete('f_forum_intro_member',$row,'',1);
			$GLOBALS['FORUM_DB']->query_insert('f_forum_intro_member',$row);
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_ocf_topics($db,$table_prefix,$file_base)
	{
		if ($this->on_same_msn($file_base)) return;
	
		$row_start=0;
		$rows=array();
		do
		{
			$rows=$db->query('SELECT * FROM '.$table_prefix.'f_topics ORDER BY id',200,$row_start);
			foreach ($rows as $row)
			{
				if (import_check_if_imported('topic',strval($row['id']))) continue;

				$forum_id=is_null($row['t_forum_id'])?NULL:import_id_remap_get('forum',strval($row['t_forum_id']));

				$t_pt_to=$row['t_pt_to'];
				$t_pt_from=$row['t_pt_from'];
				if (!is_null($t_pt_to))
				{
					$t_pt_to=import_id_remap_get('member',$t_pt_to,true);
					if (is_null($t_pt_to)) $t_pt_to=db_get_first_id();
				}
				if (!is_null($t_pt_from))
				{
					$t_pt_from=import_id_remap_get('member',$t_pt_from,true);
					if (is_null($t_pt_from)) $t_pt_from=db_get_first_id();
				}
				$id=(get_param_integer('keep_preserve_ids',0)==0)?NULL:$row['id'];
				$id_new=ocf_make_topic($forum_id,$row['t_description'],$row['t_emoticon'],$row['t_validated'],$row['t_is_open'],array_key_exists('t_is_sunk',$row)?$row['t_is_sunk']:0,$row['t_pinned'],$row['t_cascading'],$t_pt_from,$t_pt_to,false,$row['t_num_views'],$id);

				import_id_remap_put('topic',strval($row['id']),$id_new);
			}
	
			$row_start+=200;
		}
		while (count($rows)>0);

		// Read logs
		$rows=$db->query('SELECT * FROM '.$table_prefix.'f_read_logs');
		foreach ($rows as $row)
		{
			$row['l_member_id']=import_id_remap_get('member',$row['l_member_id'],true);
			$row['l_topic_id']=import_id_remap_get('topic',$row['l_topic_id'],true);
			if (is_null($row['l_member_id'])) continue;
			if (is_null($row['l_topic_id'])) continue;
			$GLOBALS['FORUM_DB']->query_delete('f_read_logs',$row,'',1);
			$GLOBALS['FORUM_DB']->query_insert('f_read_logs',$row);
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_ocf_posts($db,$table_prefix,$file_base)
	{
		if ($this->on_same_msn($file_base)) return;
	
		global $STRICT_FILE,$TOPIC_FORUM_CACHE;
		$TOPIC_FORUM_CACHE=array();

		$row_start=0;
		$rows=array();
		do
		{
			$rows=$db->query('SELECT * FROM '.$table_prefix.'f_posts ORDER BY id',200,$row_start);

			foreach ($rows as $row)
			{
				if (import_check_if_imported('post',strval($row['id']))) continue;

				$member_id=import_id_remap_get('member',strval($row['p_poster']),true);
				if (is_null($member_id)) $member_id=db_get_first_id();

				$topic_id=import_id_remap_get('topic',strval($row['p_topic_id']));

				// This speeds up addition... using the cache can reduce about 7/8 of a query per post on average
				if (array_key_exists($topic_id,$TOPIC_FORUM_CACHE))
				{
					$forum_id=$TOPIC_FORUM_CACHE[$topic_id];
				} else
				{
					$forum_id=$GLOBALS['FORUM_DB']->query_value_null_ok('f_topics','t_forum_id',array('id'=>$topic_id));
					$TOPIC_FORUM_CACHE[$topic_id]=$forum_id;
				}

				// Comment topic re-mapping
				$title=$row['p_title'];
				$matches=array();
				if (preg_match('#^(\w+)s_(\d+)$#',$title,$matches)!=0)
				{
					$c_id=import_id_remap_get($matches[1],$matches[2],true);
					if (!is_null($c_id))
					{
						$title=$matches[1].'s_'.strval($c_id);
					}
				}

				$last_edit_by=$row['p_last_edit_by'];
				if (!is_null($last_edit_by)) $last_edit_by=import_id_remap_get('member',strval($last_edit_by),true);
				$intended_solely_for=$row['p_intended_solely_for'];
				if (!is_null($intended_solely_for))
				{
					$intended_solely_for=import_id_remap_get('member',strval($intended_solely_for),true);
					if (is_null($intended_solely_for)) $intended_solely_for=-1;
				}
				$id=(get_param_integer('keep_preserve_ids',0)==0)?NULL:$row['id'];
				$id_new=ocf_make_post($topic_id,$title,$this->get_lang_string($db,$row['p_post']),0,false,$row['p_validated'],$row['p_is_emphasised'],$row['p_poster_name_if_guest'],$row['p_ip_address'],$row['p_time'],$member_id,$intended_solely_for,$row['p_last_edit_time'],$last_edit_by,false,false,$forum_id,false,'',0,$id,false,true);

				import_id_remap_put('post',strval($row['id']),$id_new);
			}

			$row_start+=200;
		}
		while (count($rows)>0);
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_ocf_polls_and_votes($db,$table_prefix,$file_base)
	{
		if ($this->on_same_msn($file_base)) return;
	
		$rows=$db->query('SELECT p.*,t.id AS tid FROM '.$table_prefix.'f_polls p LEFT JOIN '.$table_prefix.'f_topics t ON p.id=t.t_poll_id');
		foreach ($rows as $row)
		{
			if (import_check_if_imported('poll',strval($row['id']))) continue;

			$topic_id=import_id_remap_get('topic',strval($row['tid']));

			$rows2=$db->query('SELECT * FROM '.$table_prefix.'f_poll_votes WHERE pv_poll_id='.strval($row['id']));
			foreach ($rows2 as $i=>$row2)
			{
				$rows2[$i]['pv_member_id']=import_id_remap_get('member',strval($row2['pv_member_id']),true);
			}
			$rows3=$db->query('SELECT * FROM '.$table_prefix.'f_poll_answers WHERE pa_poll_id='.strval($row['id']).' ORDER BY id');
			$answers=array();
			$id_ordinal_map=array();
			foreach ($rows3 as $i=>$row3)
			{
				$answers[]=array($row3['pa_answer'],0);
				$id_ordinal_map[$row3['id']]=$i;
			}

			$id_new=ocf_make_poll($topic_id,$row['po_question'],$row['po_is_private'],$row['po_is_open'],$row['po_minimum_selections'],$row['po_maximum_selections'],$row['po_requires_reply'],$answers,false);

			$answers=collapse_1d_complexity('id',$GLOBALS['FORUM_DB']->query_select('f_poll_answers',array('id'),array('pa_poll_id'=>$id_new))); // Effectively, a remapping from vote number ordinal to new vote number
			foreach ($rows2 as $row2)
			{
				$vote=$row2['pv_answer_id'];
				if (!array_key_exists($vote,$id_ordinal_map)) continue;
				if (!array_key_exists($id_ordinal_map[$vote],$answers)) continue;
				$answer=$answers[$id_ordinal_map[$vote]];
				if (is_null($row2['pv_member_id'])) continue;
				$GLOBALS['FORUM_DB']->query_insert('f_poll_votes',array('pv_poll_id'=>$id_new,'pv_member_id'=>$row2['pv_member_id'],'pv_answer_id'=>$answer));
			}

			import_id_remap_put('poll',strval($row['id']),$id_new);
		}
	}
	
	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_ocf_emoticons($db,$table_prefix,$file_base)
	{
		if ($this->on_same_msn($file_base)) return;
	
		$rows=$db->query('SELECT * FROM '.$table_prefix.'f_emoticons');
		foreach ($rows as $row)
		{
			$test=$GLOBALS['FORUM_DB']->query_value_null_ok('f_emoticons','e_code',array('e_code'=>$row['e_code']));
			if (is_null($test))
			{
				$GLOBALS['FORUM_DB']->query_insert('f_emoticons',$row);
			}
		}
	}

	/**
	 * Pass a multi-code through a forum remap.
	 *
	 * @param  SHORT_TEXT	Multi code
	 * @return SHORT_TEXT	New multi code
	 */
	function convert_multi_code($multi_code)
	{
		if ($multi_code=='*') return $multi_code;
		if ($multi_code=='') return $multi_code;

		$new_multi_code='';
		if ($multi_code[0]=='+')
		{
			$parts=explode(',',substr($multi_code,1));
			$new_multi_code='+';
			foreach ($parts as $_part)
			{
				$part=import_id_remap_get('forum',trim($_part),true);
				if (!is_null($part))
				{
					if ($new_multi_code!='') $new_multi_code.=',';
					$new_multi_code.=strval($part);
				}
			}
		} else
		{
			$parts=explode(',',$multi_code);
			foreach ($parts as $_part)
			{
				$part=import_id_remap_get('forum',trim($_part),true);
				if (!is_null($part))
				{
					if ($new_multi_code!='') $new_multi_code.=',';
					$new_multi_code.=strval($part);
				}
			}
		}

		return $new_multi_code;
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_ocf_multi_moderations($db,$table_prefix,$file_base)
	{
		if ($this->on_same_msn($file_base)) return;
	
		$rows=$db->query('SELECT * FROM '.$table_prefix.'f_multi_moderations');
		foreach ($rows as $row)
		{
			$name=$this->get_lang_string($db,$row['mm_name']);
			$test=$GLOBALS['FORUM_DB']->query_value_null_ok('f_multi_moderations m LEFT JOIN '.$GLOBALS['FORUM_DB']->get_table_prefix().'translate t ON m.mm_name=t.id','m.id',array('text_original'=>$name));
			if (is_null($test))
			{
				$move_to=is_null($row['mm_move_to'])?NULL:import_id_remap_get('forum',strval($row['mm_move_to']));
				$multi_code=$this->convert_multi_code($row['mm_forum_multi_code']);
				ocf_make_multi_moderation($name,$row['mm_post_text'],$move_to,$row['mm_pin_state'],array_key_exists('mm_sink_state',$row)?$row['mm_sink_state']:NULL,$row['mm_open_state'],$multi_code,array_key_exists('mm_title_suffix',$row)?$row['mm_title_suffix']:'');
			}
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_ocf_post_templates($db,$table_prefix,$file_base)
	{
		if ($this->on_same_msn($file_base)) return;
	
		$rows=$db->query('SELECT * FROM '.$table_prefix.'f_post_templates');
		foreach ($rows as $row)
		{
			$multi_code=$this->convert_multi_code($row['t_forum_multi_code']);
			ocf_make_post_template($row['t_title'],$row['t_text'],$multi_code,$row['t_use_default_forums']);
		}
	}

	/**
	 * Standard import function.
	 *
	 * @param  object			The DB connection to import from
	 * @param  string			The table prefix the target prefix is using
	 * @param  PATH			The base directory we are importing from
	 */
	function import_ocf_warnings($db,$table_prefix,$file_base)
	{
		if ($this->on_same_msn($file_base)) return;
	
		$rows=$db->query('SELECT * FROM '.$table_prefix.'f_warnings');
		foreach ($rows as $row)
		{
			$member_id=import_id_remap_get('member',$row['w_member_id'],true);
			$by=import_id_remap_get('member',$row['w_by'],true);
			if (is_null($member_id)) continue;
			if (is_null($by)) $by=$GLOBALS['FORUM_DRIVER']->get_guest_id();

			$silence_from_topic=array_key_exists('w_silence_from_topic',$row)?import_id_remap_get('topic',$row['w_silence_from_topic'],true):NULL;
			if (is_null($silence_from_topic)) $silence_from_topic=NULL;

			$silence_from_forum=array_key_exists('w_silence_from_forum',$row)?import_id_remap_get('forum',$row['w_silence_from_forum'],true):NULL;
			if (is_null($silence_from_forum)) $silence_from_forum=NULL;

			$changed_usergroup_from=array_key_exists('w_changed_usergroup_from',$row)?import_id_remap_get('group',$row['w_changed_usergroup_from'],true):NULL;
			if (is_null($changed_usergroup_from)) $changed_usergroup_from=NULL;

			ocf_make_warning($member_id,$row['w_explanation'],$by,$row['w_time'],array_key_exists('w_is_warning',$row)?$row['w_is_warning']:1,$silence_from_topic,$silence_from_forum,array_key_exists('w_probation',$row)?$row['w_probation']:0,array_key_exists('w_banned_ip',$row)?$row['w_banned_ip']:'',array_key_exists('w_charged_points',$row)?$row['w_charged_points']:0,array_key_exists('w_banned_member',$row)?$row['w_banned_member']:0,$changed_usergroup_from);
		}
	}

}


