<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2012

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		core
 */

class standard_aed_module
{
	var $module_type;
	var $redirect_type=NULL;
	var $code_require=NULL;
	var $javascript_require=NULL;
	var $skip_validation=false;
	var $default_type=NULL;
	var $author='Chris Graham';
	var $organisation='ocProducts';
	var $user_facing=false;
	var $send_validation_request=true; // Only applies if $user_facing
	var $check_validation=true; // Only applies if $user_facing
	var $archive_entry_point=NULL;
	var $archive_label=NULL;
	var $view_entry_point=NULL;
	var $protect_first=0;
	var $permission_page=NULL; // Usually just get_page_name()
	var $permission_module=NULL; // E.g. 'catalogues_catalogue' if we are AEDing a catalogue
	var $permissions_require=NULL;  // E.g. 'mid'
	var $permissions_cat_require=NULL; // E.g. 'catalogues_catalogue' if we are AEDing a catalogue entry
	var $permissions_cat_name=NULL; // E.g. 'catalogue_name' if we are AEDing a catalogue entry
	var $permissions_cat_require_b=NULL; // E.g. 'catalogues_category' if we are AEDing a catalogue entry
	var $permissions_cat_name_b=NULL; // E.g. 'cat'
	var $add_text='';
	var $edit_text='';
	var $extra_donext_entries=NULL;
	var $extra_donext_categories=NULL;
	var $extra_donext_whatever=NULL;
	var $extra_donext_whatever_title=NULL;
	var $do_next_editing_categories=false;
	var $special_edit_frontend=false;
	var $upload=NULL;
	var $possibly_some_kind_of_upload=false;
	var $cat_aed_module=NULL; // Allows chaining of a secondary aed module on, to listen for cat aed (c)
	var $alt_aed_module=NULL; // Allows chaining of a secondary aed module on, to listen for some other aed (v)
	var $seo_type=NULL;
	var $award_type=NULL;
	var $posting_form_title=NULL;
	var $posting_form_text='';
	var $posting_form_text_parsed=NULL;
	var $javascript=NULL;
	var $type_code='d';
	var $catalogue=false;
	var $non_integer_id=false;
	var $output_of_action_is_confirmation=false;
	var $second_stage_preview=false;
	var $add_submit_name=NULL;
	var $edit_submit_name=NULL;
	var $do_preview=true; // true or NULL (NULL means false here)
	var $add_one_label=NULL;
	var $add_one_cat_label=NULL;
	var $edit_this_label=NULL;
	var $edit_one_label=NULL;
	var $edit_this_cat_label=NULL;
	var $edit_one_cat_label=NULL;
	var $entries_title=NULL;
	var $categories_title=NULL;
	var $do_next_description=NULL;
	var $appended_actions_already=false;
	var $select_name_description=NULL;
	var $menu_label=NULL;
	var $care_please=true;
	var $new_id=NULL;
	var $no_blank_ids=true;
	var $posting_field_required=true;

	// These only needed if we are generate nice_get_entries automatically
	var $table_prefix='';
	var $array_key='id';
	var $title_is_multi_lang=true;
	var $orderer=NULL;
	var $table=NULL; // Actually, this is used by choose_feedback_fields_statistically also

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']=$this->author;
		$info['organisation']=$this->organisation;
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=2;
		$info['locked']=false;
		return $info;
	}
	
	/**
	 * Standard modular entry-point finder function.
	 *
	 * @return ?array	A map of entry points (type-code=>language-code) (NULL: disabled).
	 */
	function get_entry_points()
	{
		$entry_points=array();
		if (method_exists($this,'add_actualisation'))
			$entry_points=array_merge($entry_points,array('ad'=>'ADD_'.$this->lang_type,'ed'=>'EDIT_'.$this->lang_type));
		if (!is_null($this->cat_aed_module))
			$entry_points=array_merge($entry_points,array('ac'=>'ADD_'.$this->cat_aed_module->lang_type,'ec'=>'EDIT_'.$this->cat_aed_module->lang_type));
		if (!is_null($this->alt_aed_module))
			$entry_points=array_merge($entry_points,array('av'=>'ADD_'.$this->alt_aed_module->lang_type,'ev'=>'EDIT_'.$this->alt_aed_module->lang_type));
		return $entry_points;
	}

	/**
	 * Standard modular run function.
	 *
	 * @return tempcode	The result of execution.
	 */
	function run()
	{
		require_code('form_templates');
		require_code('feedback');
		require_code('autosave');
		require_code('permissions2');

		if (get_value('xhtml_strict')==='1')
		{
			$this->second_stage_preview=true;
		}

		// Load lang file if it exists
		$this->module_type=get_class($this);
		if (strtolower(substr($this->module_type,0,11))=='module_cms_') $this->module_type=substr($this->module_type,11);
		if (strtolower(substr($this->module_type,0,13))=='module_admin_') $this->module_type=substr($this->module_type,13);
		if (strtolower(substr($this->module_type,0,7))=='module_') $this->module_type=substr($this->module_type,7);
		if (substr($this->module_type,0,4)=='ocf_') $this->module_type=substr($this->module_type,2);
		if ((file_exists(get_file_base().'/lang/'.fallback_lang().'/'.$this->module_type.'.ini'))
			|| (file_exists(get_custom_file_base().'/lang_custom/'.fallback_lang().'/'.$this->module_type.'.ini')))
		{
			require_lang($this->module_type);
		}

		if (!is_null($this->code_require)) require_code($this->code_require);
		if (!is_null($this->javascript_require)) require_javascript($this->javascript_require);

		if (is_null($this->default_type)) $this->default_type=method_exists($this,'misc')?'misc':'ad';
		$type=get_param('type',$this->default_type);

		if ((method_exists($this,'misc')) && ($type!='misc'))
		{
			if (($this->special_edit_frontend) && (($type=='_ed') || ($type=='_ec')))
			{
				breadcrumb_set_parents(array(array('_SELF:_SELF:misc',do_lang_tempcode(is_null($this->menu_label)?'MENU':$this->menu_label)),array('_SELF:_SELF:'.substr($type,1),do_lang_tempcode('CHOOSE'))));
			} else
			{
				if (($this->catalogue) && (either_param('catalogue_name','')!=''))
				{
					$catalogue_title=get_translated_text($GLOBALS['SITE_DB']->query_value('catalogues','c_title',array('c_name'=>either_param('catalogue_name'))));
					breadcrumb_set_parents(array(array('_SELF:_SELF:misc:catalogue_name='.either_param('catalogue_name',''),$catalogue_title)));
				} else
				{
					breadcrumb_set_parents(array(array('_SELF:_SELF:misc',do_lang_tempcode(is_null($this->menu_label)?'MENU':$this->menu_label))));
				}
			}
		} else
		{
			if (($this->special_edit_frontend) && (($type=='_ed') || ($type=='_ec')))
			{
				breadcrumb_set_parents(array(array('_SELF:_SELF:'.substr($type,1),do_lang_tempcode('CHOOSE'))));
			}
		}


		if (method_exists($this,'run_start'))
		{
			$ret=$this->run_start($type);
			if ((!is_null($ret)) && (!$ret->is_empty())) return $ret;
		}

		if (!is_null($this->cat_aed_module)) $this->cat_aed_module->type_code='d';
		if ($type=='ad') return $this->ad();
		if ($type=='_ad') return $this->_ad();
		if ($type=='ed') return $this->ed();
		if ($type=='_ed') return $this->_ed();
		if ($type=='__ed') return $this->__ed();
		if (!is_null($this->cat_aed_module))
		{
			$this->cat_aed_module->type_code='c';
			if ($type=='ac') return $this->cat_aed_module->ad();
			if ($type=='_ac') return $this->cat_aed_module->_ad();
			if ($type=='ec') return $this->cat_aed_module->ed();
			if ($type=='_ec') return $this->cat_aed_module->_ed();
			if ($type=='__ec') return $this->cat_aed_module->__ed();
		}
		if (!is_null($this->alt_aed_module))
		{
			$this->alt_aed_module->type_code='v';
			if ($type=='av') return $this->alt_aed_module->ad();
			if ($type=='_av') return $this->alt_aed_module->_ad();
			if ($type=='ev') return $this->alt_aed_module->ed();
			if ($type=='_ev') return $this->alt_aed_module->_ed();
			if ($type=='__ev') return $this->alt_aed_module->__ed();
		}
		
		// These ones are for catalogues only...
		if ($type=='add_entry') return $this->ad();
		if ($type=='_add_entry') return $this->_ad();
		if ($type=='edit_entry') return $this->ed();
		if ($type=='_edit_entry') return $this->_ed();
		if ($type=='__edit_entry') return $this->__ed();
		if (!is_null($this->cat_aed_module))
		{
			$this->cat_aed_module->type_code='c';
			if ($type=='add_category') return $this->cat_aed_module->ad();
			if ($type=='_add_category') return $this->cat_aed_module->_ad();
			if ($type=='edit_category') return $this->cat_aed_module->ed();
			if ($type=='_edit_category') return $this->cat_aed_module->_ed();
			if ($type=='__edit_category') return $this->cat_aed_module->__ed();
		}
		if (!is_null($this->alt_aed_module))
		{
			$this->alt_aed_module->type_code='v';
			if ($type=='add_catalogue') return $this->alt_aed_module->ad();
			if ($type=='_add_catalogue') return $this->alt_aed_module->_ad();
			if ($type=='edit_catalogue') return $this->alt_aed_module->ed();
			if ($type=='_edit_catalogue') return $this->alt_aed_module->_ed();
			if ($type=='__edit_catalogue') return $this->alt_aed_module->__ed();
		}

		return new ocp_tempcode();
	}

	/**
	 * Statistically work out defaults for feedback fields, if not currently set.
	 *
	 * @param  ?BINARY			Whether rating is allowed (NULL: decide statistically, based on existing choices)
	 * @param  ?SHORT_INTEGER	Whether comments are allowed (0=no, 1=yes, 2=review style) (NULL: decide statistically, based on existing choices)
	 * @param  ?BINARY			Whether trackbacks are allowed (NULL: decide statistically, based on existing choices)
	 * @return array				Array of all input parameters, converted
	 */
	function choose_feedback_fields_statistically($allow_rating,$allow_comments,$allow_trackbacks)
	{
		if (is_null($allow_rating))
		{
			$val=$GLOBALS['SITE_DB']->query_value($this->table,'AVG(allow_rating)');
			$allow_rating=is_null($val)?1:intval(round($val));
		}

		if (is_null($allow_comments))
		{
			$val=$GLOBALS['SITE_DB']->query_value_null_ok_full('SELECT allow_comments,count(allow_comments) AS qty FROM '.get_table_prefix().$this->table.' GROUP BY allow_comments ORDER BY qty DESC',1); // We need the mode here, not the mean
			$allow_comments=is_null($val)?1:$val;
		}

		if (is_null($allow_trackbacks))
		{
			$val=$GLOBALS['SITE_DB']->query_value($this->table,'AVG(allow_trackbacks)');
			$allow_trackbacks=is_null($val)?1:intval(round($val));
		}

		return array($allow_rating,$allow_comments,$allow_trackbacks);
	}

	/**
	 * Standard modular permission chooser.
	 *
	 * @param  ?ID_TEXT		The category ID the permissions are being chosen for (NULL: new category)
	 * @param  ?tempcode		Extra help to show in interface (NULL: none)
	 * @param  boolean		Whether this is a new category (don't load permissions, default to on)
	 * @param  ?tempcode		Label for view permissions (NULL: default)
	 * @return tempcode		The permission fields
	 */
	function get_permission_fields($category_id,$help=NULL,$new_category=false,$pinterface_view=NULL)
	{
		return get_category_permissions_for_environment($this->permission_module,$category_id,$this->permission_page,$help,$new_category,$pinterface_view);
	}

	/**
	 * Set permissions of the news category from POST parameters.
	 *
	 * @param  ID_TEXT		The category to set permissions for
	 */
	function set_permissions($id)
	{
		set_category_permissions_from_environment($this->permission_module,$id,$this->permission_page);
	}

	/**
	 * The do-next manager for after content management.
	 *
	 * @param  tempcode		The title (output of get_page_title)
	 * @param  tempcode		Some description to show, saying what happened
	 * @param  ?ID_TEXT		The ID of whatever we are working with (NULL: deleted)
	 * @return tempcode		The UI
	 */
	function do_next_manager($title,$description,$id)
	{
		$archive_url=NULL;
		if (!is_null($this->archive_entry_point))
		{
			list($zone,$attributes,)=page_link_decode($this->archive_entry_point);
			$page=$attributes['page'];
			unset($attributes['page']);
			$archive_url=array($page,$attributes,$zone,(!isset($this->archive_label))?NULL:do_lang_tempcode($this->archive_label));
		}
		$view_url=NULL;
		if (!is_null($this->view_entry_point))
		{
			list($zone,$attributes,)=page_link_decode(str_replace('_ID',$id,$this->view_entry_point));
			$page=$attributes['page'];
			unset($attributes['page']);
			$view_url=array($page,$attributes,$zone,(!isset($this->view_label))?NULL:$this->view_label);
		}

		breadcrumb_set_self(do_lang_tempcode('DONE'));

		require_code('templates_donext');
		return do_next_manager($title,$description,
					NULL,
					NULL,
					/*		TYPED-ORDERED LIST OF 'LINKS'		*/
					/*	 page	 params				  zone	  */
					$this->do_next_editing_categories?NULL:array('_SELF',array('type'=>'a'.$this->type_code),'_SELF',!is_null($this->add_one_label)?$this->add_one_label:NULL),									 // Add one
					$this->do_next_editing_categories?NULL:((is_null($id) || ((!is_null($this->permissions_require)) && (!has_specific_permission(get_member(),'edit_own_'.$this->permissions_require.'range_content',get_page_name()))))?NULL:array('_SELF',array('type'=>'_e'.$this->type_code,'id'=>$id),'_SELF',!is_null($this->edit_this_label)?$this->edit_this_label:NULL)),					  // Edit this
					$this->do_next_editing_categories?NULL:(((!is_null($this->permissions_require)) && (!has_specific_permission(get_member(),'edit_own_'.$this->permissions_require.'range_content',get_page_name())))?NULL:array('_SELF',array('type'=>'e'.$this->type_code),'_SELF',!is_null($this->edit_one_label)?$this->edit_one_label:NULL)),									 // Edit one
					$this->do_next_editing_categories?NULL:(is_null($id))?NULL:$view_url,																				 // View this
					$archive_url,																			 // View archive
					NULL,																						 // Add to category
					(!$this->do_next_editing_categories)?NULL:array('_SELF',array('type'=>'a'.$this->type_code),'_SELF',!is_null($this->add_one_cat_label)?$this->add_one_cat_label:NULL),									 // Add one category
					(!$this->do_next_editing_categories)?NULL:(((!is_null($this->permissions_require)) && (!has_specific_permission(get_member(),'edit_own_'.$this->permissions_require.'range_content',get_page_name())))?NULL:array('_SELF',array('type'=>'e'.$this->type_code),'_SELF',!is_null($this->edit_one_cat_label)?$this->edit_one_cat_label:NULL)),									 // Edit one category
					(!$this->do_next_editing_categories)?NULL:((is_null($id) || ((!is_null($this->permissions_require)) && (!has_specific_permission(get_member(),'edit_own_'.$this->permissions_require.'range_content',get_page_name()))))?NULL:array('_SELF',array('type'=>'_e'.$this->type_code,'id'=>$id),'_SELF',!is_null($this->edit_this_cat_label)?$this->edit_this_cat_label:NULL)),					  // Edit this category
					(!$this->do_next_editing_categories)?NULL:$view_url,																				 // View this category
					$this->extra_donext_entries,
					$this->extra_donext_categories,
					$this->extra_donext_whatever,
					$this->extra_donext_whatever_title,
					NULL,
					$this->entries_title,
					$this->categories_title
		);
	}

	/**
	 * If a confirmation is needed, and not been given, ask for one.
	 *
	 * @param  tempcode	The page title for what's being done
	 * @return ?tempcode	The confirmation UI (NULL: all is clear - no confirmation needed)
	 */
	function handle_confirmations($title)
	{
		if (!method_exists($this,'get_preview')) return NULL;

		if (get_param_integer('confirmed',0)==1) return NULL;

		$preview=$this->get_preview();
		$fields=build_keep_post_fields();
		$url=get_self_url(false,false,array('confirmed'=>1));

		return do_template('CONFIRM_SCREEN',array('_GUID'=>'802e21c2beb889385141bb2ed2f27976'.get_class($this),'TITLE'=>$title,'PREVIEW'=>$preview,'URL'=>$url,'FIELDS'=>$fields));
	}

	/**
	 * Get some XHTML for a form to choose a catalogue out of all the available ones.
	 *
	 * @param  tempcode		The get_page_title converted title for this page
	 * @return ?tempcode		The tempcode for the catalogue chooser (NULL: already chosen)
	 */
	function choose_catalogue($title)
	{
		if (!$this->catalogue) return NULL;

		$catalogue_name=get_param('catalogue_name','');
		if ($catalogue_name!='') return NULL;

		$tree=nice_get_catalogues(NULL,false,true);
		if ($tree->is_empty())
		{
			return inform_screen($title,do_lang_tempcode('NO_ENTRIES'));
		}

		require_code('form_templates');
		$fields=form_input_list(do_lang_tempcode('CATALOGUE'),'','catalogue_name',$tree,NULL,true);
		$post_url=get_self_url(false,false,NULL,false,true);
		$submit_name=do_lang_tempcode('PROCEED');
		$hidden=build_keep_post_fields();

		return do_template('FORM_SCREEN',array('_GUID'=>'22812ac8056903811f444682d45ee448'.get_class($this),'GET'=>true,'HIDDEN'=>$hidden,'TITLE'=>$title,'TEXT'=>paragraph(do_lang_tempcode('CHOOSE_CATALOGUE')),'URL'=>$post_url,'FIELDS'=>$fields,'SUBMIT_NAME'=>$submit_name,'SKIP_VALIDATION'=>true));
	}

	/**
	 * Standard modular UI for a separate preview.
	 *
	 * @param  tempcode	The page title
	 * @return tempcode	The UI
	 */
	function preview_intercept($title)
	{
		require_code('preview');
		$output=build_preview();

		$url=get_self_url(false,false,array('preview'=>0));

		$fields=build_keep_post_fields();

		return do_template('CONFIRM_SCREEN',array('_GUID'=>'06a3eb06338a7f821676d8ca3eb66aa6','TITLE'=>$title,'PREVIEW'=>$output,'URL'=>$url,'FIELDS'=>$fields));
	}
	
	/**
	 * Find whether this content type has a tied catalogue.
	 *
	 * @return boolean	Whether it has
	 */
	function has_tied_catalogue()
	{
		if (!is_null($this->award_type))
		{
			require_code('fields');
			return has_tied_catalogue($this->award_type);
		}
		return false;
	}
	
	/**
	 * Standard modular UI to add an entry.
	 *
	 * @return tempcode	The UI
	 */
	function ad()
	{
		if ((!is_null($this->permissions_require)) && (is_null($this->permissions_cat_require)))
			check_submit_permission($this->permissions_require);

		$doing='ADD_'.$this->lang_type;
		if (($this->catalogue) && (get_param('catalogue_name','')!=''))
		{
			$catalogue_title=get_translated_text($GLOBALS['SITE_DB']->query_value('catalogues','c_title',array('c_name'=>get_param('catalogue_name'))));
			if ($this->type_code=='d')
			{
				$doing=do_lang('CATALOGUE_GENERIC_ADD',escape_html($catalogue_title));
			}
			elseif ($this->type_code=='c')
			{
				$doing=do_lang('CATALOGUE_GENERIC_ADD_CATEGORY',escape_html($catalogue_title));
			}
		}

		$title=get_page_title($doing);

		$test=$this->choose_catalogue($title);
		if (!is_null($test)) return $test;

		if (multi_lang())
		{
			require_code('lang2');
			$switch_url=get_self_url(false,false,array('keep_lang'=>get_site_default_lang()));
			if ((has_actual_page_access(get_member(),'admin_lang')) && (user_lang()!=get_site_default_lang()))
			{
				attach_message(do_lang_tempcode('lang:ADDING_CONTENT_IN_LANGUAGE_STAFF',escape_html(lookup_language_full_name(user_lang())),escape_html(lookup_language_full_name(get_site_default_lang())),escape_html($switch_url->evaluate())),'warn');
			} else
			{
				attach_message(do_lang_tempcode('lang:ADDING_CONTENT_IN_LANGUAGE',escape_html(lookup_language_full_name(user_lang()))),'inform');
			}
		}

		$submit_name=(strpos($doing,' ')!==false)?protect_from_escaping($doing):do_lang($doing);
		if (!is_null($this->add_submit_name)) $submit_name=$this->add_submit_name;

		$map=array('page'=>'_SELF','type'=>'_a'.$this->type_code);
		if (get_param('catalogue_name','')!='') $map['catalogue_name']=get_param('catalogue_name');
		if (!is_null(get_param('auto__add_one',NULL))) $map['auto__add_one']=get_param('auto__add_one');
		if (!is_null(get_param('auto__add_one_category',NULL))) $map['auto__add_one_category']=get_param('auto__add_one_category');
		if (!is_null(get_param('redirect',NULL))) $map['redirect']=get_param('redirect');
		if (!is_null(get_param('continue',NULL))) $map['continue']=get_param('continue');
		if ((!is_null($this->upload)) || ($this->possibly_some_kind_of_upload)) $map['uploading']=1;
		$post_url=build_url($map,'_SELF');

		$bits=$this->get_form_fields();
		$fields2=new ocp_tempcode();
		$posting_form_tabindex=NULL;
		if (is_array($bits))
		{
			$fields=$bits[0];
			$hidden=$bits[1];
			if (array_key_exists(6,$bits)) $fields2=$bits[6];
			if (array_key_exists(7,$bits)) $posting_form_tabindex=$bits[7];
		} else
		{
			$fields=$bits;
			$hidden=new ocp_tempcode();
		}
		
		// Add in custom fields
		if ($this->has_tied_catalogue())
		{
			require_code('fields');
			$fields->attach(do_template('FORM_SCREEN_FIELD_SPACER',array('TITLE'=>do_lang_tempcode('MORE'))));
			append_form_custom_fields($this->award_type,NULL,$fields,$hidden);
		}

		// SEO?
		if (!is_null($this->seo_type))
		{
			require_code('seo2');
			$fields2->attach(seo_get_fields($this->seo_type));
		}

		// Awards?
		if (addon_installed('awards'))
		{
			if (!is_null($this->award_type))
			{
				require_code('awards');
				$fields2->attach(get_award_fields($this->award_type));
			}
		}

		if (!is_object($this->add_text)) $this->add_text=make_string_tempcode($this->add_text);
		if ($this->user_facing)
		{
			if (($this->care_please) && (do_lang('CARE_PLEASE')!='')) $this->add_text->attach(paragraph(do_lang_tempcode('CARE_PLEASE')));
			if (addon_installed('points'))
			{
				$login_url=build_url(array('page'=>'login','type'=>'misc','redirect'=>get_self_url(true,true)),get_module_zone('login'));
				$_login_url=escape_html($login_url->evaluate());
				if ((is_guest()) && ((get_forum_type()!='ocf') || (has_actual_page_access(get_member(),'join')))) $this->add_text->attach(paragraph(do_lang_tempcode('NOT_LOGGED_IN_NO_CREDIT',$_login_url)));
			}
		}
		if (!is_null($this->upload))
		{
			if ($this->upload=='image')
			{
				require_code('images');
				$max=floatval(get_max_image_size())/floatval(1024*1024);
				if ($max<3.0)
				{
					require_code('files2');
					$config_url=get_upload_limit_config_url();
					$this->add_text->attach(paragraph(do_lang_tempcode(is_null($config_url)?'MAXIMUM_UPLOAD':'MAXIMUM_UPLOAD_STAFF',escape_html(($max>10.0)?integer_format(intval($max)):float_format($max)),escape_html($config_url))));
				}
			} else
			{
				require_code('files2');
				$max=floatval(get_max_file_size())/floatval(1024*1024);
				if ($max<30.0)
				{
					$config_url=get_upload_limit_config_url();
					$this->add_text->attach(paragraph(do_lang_tempcode(is_null($config_url)?'MAXIMUM_UPLOAD':'MAXIMUM_UPLOAD_STAFF',escape_html(($max>10.0)?integer_format(intval($max)):float_format($max)),escape_html($config_url))));
				}
			}
		}

		if (get_param('type','ad')=='add_catalogue')
		{
			require_javascript('javascript_catalogues');
			
			// New field
			$fields_new=new ocp_tempcode();
			for ($i=0;$i<10;$i++) // Up to 10 new fields for catalogue, although this number is arbitrary
			{
				list($_fields_new,$_hidden_new)=$this->get_field_fields((($i==0) && (substr(get_param('id',''),0,1)!='_')),10,'new_field_'.strval($i).'_',$i);
				$temp=do_template('FORM_FIELD_SET_GROUPER',array('_GUID'=>'3eba3a73d1fbdf922707d63216e13e03'.get_class($this),'VISIBLE'=>($i==0)?true:NULL,'NAME'=>do_lang_tempcode('NEW_FIELD',strval($i+1)),'ID'=>'NEW_FIELD_'.strval($i+1),'FIELDS'=>$_fields_new->evaluate()/*FUDGEFUDGE*/));
				$fields_new->attach($temp);
				$hidden->attach($_hidden_new);
			}

			$fields->attach($fields2);
			return do_template('CATALOGUE_ADDING_SCREEN',array('_GUID'=>'adf73fdfccb387640340f15d5d6dae54'.get_class($this),'HIDDEN'=>$hidden,'TITLE'=>$title,'TEXT'=>$this->add_text,'URL'=>$post_url,'FIELDS'=>$fields->evaluate()/*FUDGEFUDGE*/,'FIELDS_NEW'=>$fields_new->evaluate()/*FUDGEFUDGE*/,'SUBMIT_NAME'=>$submit_name,'JAVASCRIPT'=>$this->javascript));
		}
		elseif (!is_null($this->posting_form_title))
		{
			$posting_form=get_posting_form($submit_name,$this->posting_form_text,$post_url,$hidden,$fields,$this->posting_form_title,'',$fields2,$this->posting_form_text_parsed,$this->javascript,$posting_form_tabindex,$this->posting_field_required);
			return do_template('POSTING_SCREEN',array('_GUID'=>'15930ba8cc02634ed3a225c9714c3eac'.get_class($this),'TITLE'=>$title,'PREVIEW'=>$this->do_preview,'SEPARATE_PREVIEW'=>$this->second_stage_preview,'TEXT'=>$this->add_text,'POSTING_FORM'=>$posting_form->evaluate()/*FUDGEFUDGE*/,'JAVASCRIPT'=>$this->javascript));
		} else
		{
			$fields->attach($fields2);
			return do_template('FORM_SCREEN',array('_GUID'=>'1df73fdfccb387640340f15d5d6dae54'.get_class($this),'PREVIEW'=>$this->do_preview,'SEPARATE_PREVIEW'=>$this->second_stage_preview,'HIDDEN'=>$hidden,'TITLE'=>$title,'SKIP_VALIDATION'=>$this->skip_validation,'TEXT'=>$this->add_text,'URL'=>$post_url,'FIELDS'=>$fields->evaluate()/*FUDGEFUDGE*/,'SUBMIT_NAME'=>$submit_name,'JAVASCRIPT'=>$this->javascript));
		}
	}

	/**
	 * Standard modular UI/actualiser to add an entry.
	 *
	 * @return tempcode	The UI
	 */
	function _ad()
	{
		if (!is_null($this->permissions_require)) check_submit_permission($this->permissions_require,array($this->permissions_cat_require,is_null($this->permissions_cat_name)?'':post_param($this->permissions_cat_name),$this->permissions_cat_require_b,is_null($this->permissions_cat_name_b)?'':post_param($this->permissions_cat_name_b)));

		$doing='ADD_'.$this->lang_type;
		if (($this->catalogue) && (get_param('catalogue_name','')!=''))
		{
			$catalogue_title=get_translated_text($GLOBALS['SITE_DB']->query_value('catalogues','c_title',array('c_name'=>get_param('catalogue_name'))));
			if ($this->type_code=='d')
			{
				$doing=do_lang('CATALOGUE_GENERIC_ADD',escape_html($catalogue_title));
			}
			elseif ($this->type_code=='c')
			{
				$doing=do_lang('CATALOGUE_GENERIC_ADD_CATEGORY',escape_html($catalogue_title));
			}
		}

		$title=get_page_title($doing);

		if (($this->second_stage_preview) && (get_param_integer('preview',0)==1))
		{
			return $this->preview_intercept($title);
		}

		$test=$this->handle_confirmations($title);
		if (!is_null($test)) return $test;

		if (($this->user_facing) && (!is_null($this->permissions_require)))
		{
			inject_action_spamcheck();
			if (!has_specific_permission(get_member(),'bypass_validation_'.$this->permissions_require.'range_content',NULL,array($this->permissions_cat_require,is_null($this->permissions_cat_name)?'':post_param($this->permissions_cat_name),$this->permissions_cat_require_b,is_null($this->permissions_cat_name_b)?'':post_param($this->permissions_cat_name_b))))
				$_POST['validated']='0';
		}

		if (!is_null($this->upload)) require_code('uploads');
		$temp=$this->add_actualisation();

		$description=is_null($this->do_next_description)?do_lang_tempcode('SUCCESS'):$this->do_next_description;

		if (is_array($temp))
		{
			list($id,$text)=$temp;
			if (!is_null($text)) $description->attach($text);
		} else
		{
			$id=$temp;
		}

		// Save custom fields
		if ($this->has_tied_catalogue())
		{
			require_code('fields');
			save_form_custom_fields($this->award_type,$id);
		}

		if ($this->user_facing)
		{
			require_code('submit');
			if (($this->check_validation) && (post_param_integer('validated',0)==0))
			{
				if ($this->send_validation_request)
				{
					$edit_url=build_url(array('page'=>'_SELF','type'=>'_e'.$this->type_code,'id'=>$id,'validated'=>1),'_SELF',NULL,false,false,true);
					if (addon_installed('unvalidated'))
						send_validation_request($doing,$this->table,$this->non_integer_id,$id,$edit_url);
				}

				$description->attach(paragraph(do_lang_tempcode('SUBMIT_UNVALIDATED')));
			}
			give_submit_points($doing);
		}

		if (addon_installed('awards'))
		{
			if (!is_null($this->award_type))
			{
				require_code('awards');
				handle_award_setting($this->award_type,$id);
			}
		}

		clear_ocp_autosave();
		decache('main_awards');

//		if ($this->redirect_type=='!')
		{
			$url=get_param('redirect',NULL);
			if (!is_null($url)) return redirect_screen($title,$url,$description);
		}

		breadcrumb_set_parents(array_merge($GLOBALS['BREADCRUMB_SET_PARENTS'],array(array('_SELF:_SELF:a'.$this->type_code,(strpos($doing,' ')!==false)?protect_from_escaping($doing):do_lang_tempcode($doing)))));

		return $this->do_next_manager($title,$description,$id);
	}
	
	/**
	 * Standard modular entry function to get rows for selection from.
	 *
	 * @param  boolean		Whether to force a recache
	 * @param  ?ID_TEXT		Order to use (NULL: automatic)
	 * @param  ?array			Extra where clauses (NULL: none)
	 * @param  boolean		Whether to always access using the site database
	 * @param  string			Extra join clause for our query (blank: none)
	 * @return array			A pair: Rows for selection from, Total results
	 */
	function get_entry_rows($recache=false,$orderer=NULL,$where=NULL,$force_site_db=false,$join='')
	{
		if ((!$recache) && (!is_null($orderer)) && (!is_null($where)))
		{
			if (isset($this->cached_entry_rows))
			{
				return array($this->cached_entry_rows,$this->cached_max_rows);
			}
		}

		$select_field=!is_null($this->orderer)?$this->orderer:($this->table_prefix.strtolower($this->select_name));

		if (is_null($orderer))
		{
			$orderer=$select_field;
		}
		$table=is_null($this->table)?$this->module_type:$this->table;
		$db=((substr($table,0,2)=='f_') && (!$force_site_db) && (get_forum_type()!='none'))?$GLOBALS['FORUM_DB']:$GLOBALS['SITE_DB'];
		if ($force_site_db)
		{
			$dbs_bak=$GLOBALS['NO_DB_SCOPE_CHECK'];
			$GLOBALS['NO_DB_SCOPE_CHECK']=true;
		}
		$max_rows=$db->query_value($table.' r '.$join,'COUNT(*)',$where,'ORDER BY '.$orderer);
		if ($max_rows==0) return array(array(),0);
		$rows=$db->query_select($table.' r '.$join,array('r.*'),$where,'ORDER BY '.$orderer,get_param_integer('max',50),get_param_integer('start',0));
		if ($force_site_db)
		{
			$GLOBALS['NO_DB_SCOPE_CHECK']=$dbs_bak;
		}
		$_entries=array();
		foreach ($rows as $row)
		{
			$key=$row[$this->array_key];
			$readable=$this->title_is_multi_lang?get_translated_text($row[$select_field],$db):$row[$select_field];
			if (is_integer($readable)) $readable='#'.strval($readable);
			if ($readable=='') $readable=do_lang('_DEFAULT');
			$row['_readable']=$readable;
			$_entries[$key]=$row;
		}
		if (($this->title_is_multi_lang) && (preg_replace('# (ASC|DESC)$#','',$orderer)==$select_field))
		{
			global $M_SORT_KEY;
			$M_SORT_KEY='_readable';
			usort($_entries,'multi_sort');
			if (substr($orderer,-5)==' DESC') $_entries=array_reverse($_entries);
		}
		
		if ((!is_null($orderer)) && (!is_null($where)))
		{
			$this->cached_entry_rows=$_entries;
			$this->cached_max_rows=$max_rows;
		}
		
		return array($_entries,$max_rows);
	}
	
	/**
	 * Standard modular entry list fetcher.
	 *
	 * @return tempcode		The selection list
	 */
	function nice_get_entries()
	{
		list($_entries,)=$this->get_entry_rows();
		
		$entries=new ocp_tempcode();
		foreach ($_entries as $key=>$row)
		{
			$readable=$row['_readable'];
			$entries->attach(form_input_list_entry($key,$key===get_param('id',NULL,true),$readable));
		}
		return $entries;
	}
	
	/**
	 * Standard modular UI to choose an entry to edit.
	 *
	 * @return tempcode	The UI
	 */
	function ed()
	{
		if ((!is_null($this->permissions_require)) && (is_null($this->permissions_cat_require)))
			check_some_edit_permission($this->permissions_require);

		$doing='EDIT_'.$this->lang_type;
		if (($this->catalogue) && (get_param('catalogue_name','')!=''))
		{
			$catalogue_title=get_translated_text($GLOBALS['SITE_DB']->query_value('catalogues','c_title',array('c_name'=>get_param('catalogue_name'))));
			if ($this->type_code=='d')
			{
				$doing=do_lang('CATALOGUE_GENERIC_EDIT',escape_html($catalogue_title));
			}
			elseif ($this->type_code=='c')
			{
				$doing=do_lang('CATALOGUE_GENERIC_EDIT_CATEGORY',escape_html($catalogue_title));
			}
		}

		$title=get_page_title($doing);

		$test=$this->choose_catalogue($title);
		if (!is_null($test)) return $test;

		$text=paragraph(do_lang_tempcode('CHOOSE_EDIT_LIST'));

		$next_type='_e'.$this->type_code;
		if (get_param('type','ed')=='edit_catalogue') $next_type='_edit_catalogue';
		$map=array('page'=>'_SELF','type'=>$next_type);
		if (either_param('catalogue_name','')!='') $map['catalogue_name']=either_param('catalogue_name');
		if (!is_null(get_param('redirect',NULL))) $map['redirect']=get_param('redirect');
		if (!is_null(get_param('continue',NULL))) $map['continue']=get_param('continue');

		$description=($this->select_name_description!='')?do_lang_tempcode($this->select_name_description):new ocp_tempcode();
		if (method_exists($this,'nice_get_radio_entries')) // For picture selection lists only
		{
			$entries=$this->nice_get_radio_entries();
			if ($entries->is_empty()) inform_exit(do_lang_tempcode(($this->type_code=='d')?'NO_ENTRIES':'NO_CATEGORIES'));
			$fields=form_input_radio(do_lang_tempcode($this->select_name),$description,$entries,$this->no_blank_ids,true,'');
		}
		elseif ((method_exists($this,'nice_get_ajax_tree')) && (($_fields=$this->nice_get_ajax_tree())!==NULL))
		{
			if (is_array($_fields))
			{
				$text=paragraph(do_lang_tempcode('CHOOSE_EDIT_LIST_EXTRA',escape_html($_fields[1]->evaluate()),escape_html($_fields[2]->evaluate())));
				$fields=$_fields[0];
			} else
			{
				$fields=$_fields;
			}
		}
		elseif (method_exists($this,'nice_get_choose_table'))
		{
			list($test,)=$this->get_entry_rows();
			if (count($test)==0) inform_exit(do_lang_tempcode(($this->type_code=='d')?'NO_ENTRIES':'NO_CATEGORIES'));
			$table_result=$this->nice_get_choose_table($map);
			if (is_null($table_result)) inform_exit(do_lang_tempcode(($this->type_code=='d')?'NO_ENTRIES':'NO_CATEGORIES'));
			$table=$table_result[0];
			$has_ordering=$table_result[1];
			if ((array_key_exists(2,$table_result)) && (!is_null($table_result[2])))
			{
				$text=paragraph(do_lang_tempcode('CHOOSE_EDIT_TABLE_EXTRA',escape_html($table_result[2]->evaluate()),escape_html($table_result[3]->evaluate())));
			} else
			{
				$text=paragraph(do_lang_tempcode('CHOOSE_EDIT_TABLE'));
			}

			return do_template('TABLE_TABLE_SCREEN',array('TITLE'=>$title,'TEXT'=>$text,'TABLE'=>$table,'SUBMIT_NAME'=>$has_ordering?do_lang_tempcode('ORDER'):NULL,'POST_URL'=>get_self_url()));
		} else
		{
			$_entries=$this->nice_get_entries();

			if (is_array($_entries))
			{
				$text=paragraph(do_lang_tempcode('CHOOSE_EDIT_LIST_EXTRA',escape_html($_entries[1]->evaluate()),escape_html($_entries[2]->evaluate())));
				$entries=$_entries[0];
			} else
			{
				$entries=$_entries;
			}

			if ($entries->is_empty()) inform_exit(do_lang_tempcode(($this->type_code=='d')?'NO_ENTRIES':'NO_CATEGORIES'));
			$fields=form_input_list(do_lang_tempcode($this->select_name),$description,'id',$entries,NULL,true,$this->no_blank_ids);
		}

		$post_url=build_url($map,'_SELF',NULL,false,true);

		//$submit_name=(strpos($doing,' ')!==false)?protect_from_escaping($doing):do_lang($doing);
		$submit_name=do_lang_tempcode('PROCEED');

		$keep=symbol_tempcode('KEEP');
		$iframe_url=NULL;
		if (!$this->special_edit_frontend && (has_js()))
		{
			$iframe_url=find_script('iframe').'?zone='.get_zone_name().'&wide_high=1&opens_below=1';
			foreach ($map as $key=>$val)
			{
				$iframe_url.='&'.$key.'='.urlencode(str_replace('_SELF',get_page_name(),$val));
			}
			$iframe_url.=$keep->evaluate();
		}

		return do_template('FORM_SCREEN',array('_GUID'=>'228a05e24253f324ea286ea8ac3d8b02'.get_class($this),'GET'=>true,'IFRAME_URL'=>$iframe_url,'HIDDEN'=>'','TITLE'=>$title,'TEXT'=>$text,'URL'=>$post_url,'FIELDS'=>$fields->evaluate()/*FUDGEFUDGE*/,'SUBMIT_NAME'=>$submit_name,'SKIP_VALIDATION'=>true));
	}

	/**
	 * Standard modular UI to edit an entry.
	 *
	 * @return tempcode	The UI
	 */
	function _ed()
	{
		$doing='EDIT_'.$this->lang_type;
		if (($this->catalogue) && (get_param('catalogue_name','')!=''))
		{
			$catalogue_title=get_translated_text($GLOBALS['SITE_DB']->query_value('catalogues','c_title',array('c_name'=>get_param('catalogue_name'))));
			if ($this->type_code=='d')
			{
				$doing=do_lang('CATALOGUE_GENERIC_EDIT',escape_html($catalogue_title));
			}
			elseif ($this->type_code=='c')
			{
				$doing=do_lang('CATALOGUE_GENERIC_EDIT_CATEGORY',escape_html($catalogue_title));
			}
		}

		$title=get_page_title($doing);
		//$submit_name=(strpos($doing,' ')!==false)?protect_from_escaping($doing):do_lang($doing);
		//if (!is_null($this->edit_submit_name)) $submit_name=$this->edit_submit_name;
		$submit_name=do_lang_tempcode('SAVE');

		//$test=$this->choose_catalogue($title);
		//if (!is_null($test)) return $test;

		$id=mixed(); // Define type as mixed
		$id=$this->non_integer_id?get_param('id',false,true):strval(get_param_integer('id'));

		$map=array('page'=>'_SELF','type'=>'__e'.$this->type_code,'id'=>$id);
		if (get_param('catalogue_name','')!='') $map['catalogue_name']=get_param('catalogue_name');
		if (!is_null(get_param('redirect',NULL))) $map['redirect']=get_param('redirect');
		if (!is_null(get_param('continue',NULL))) $map['continue']=get_param('continue');
		if ((!is_null($this->upload)) || ($this->possibly_some_kind_of_upload)) $map['uploading']=1;
		$post_url=build_url($map,'_SELF');

		if ((multi_lang()) && (has_actual_page_access(get_member(),'admin_lang')) && (user_lang()!=get_site_default_lang()))
		{
			require_code('lang2');
			$switch_url=get_self_url(false,false,array('keep_lang'=>get_site_default_lang()));
			attach_message(do_lang_tempcode('lang:EDITING_CONTENT_IN_LANGUAGE_STAFF',escape_html(lookup_language_full_name(user_lang())),escape_html(lookup_language_full_name(get_site_default_lang())),escape_html($switch_url->evaluate())),'warn');
		}

		if (method_exists($this,'get_submitter'))
		{
			list($submitter,$date_and_time)=$this->get_submitter($id);
		} else
		{
			$submitter=NULL;
			$date_and_time=NULL;
		}

		if (!is_null($this->permissions_require))
		{
			check_edit_permission($this->permissions_require,$submitter,array($this->permissions_cat_require,is_null($this->permissions_cat_name)?NULL:$this->get_cat($id),$this->permissions_cat_require_b,is_null($this->permissions_cat_name_b)?NULL:$this->get_cat_b($id)));
		}

		if ((!is_null($this->permissions_cat_require)) && (!has_category_access(get_member(),$this->permissions_cat_require,$this->get_cat($id))))
			access_denied('CATEGORY_ACCESS');

		if ((!is_null($this->permissions_cat_require_b)) && (!has_category_access(get_member(),$this->permissions_cat_require_b,$this->get_cat_b($id))))
			access_denied('CATEGORY_ACCESS');

		$bits=$this->fill_in_edit_form($id);
		$delete_fields=new ocp_tempcode();
		$all_delete_fields_given=false;
		$fields2=new ocp_tempcode();
		if (is_array($bits))
		{
			$fields=$bits[0];
			$hidden=$bits[1];
			if ((array_key_exists(2,$bits)) && (!is_null($bits[2]))) $delete_fields=$bits[2];
			if ((array_key_exists(3,$bits)) && (!is_null($bits[3]))) $this->edit_text=$bits[3];
			if ((array_key_exists(4,$bits)) && ($bits[4])) $all_delete_fields_given=true;
			if ((array_key_exists(5,$bits)) && (!is_null($bits[5]))) $this->posting_form_text=$bits[5];
			if ((array_key_exists(6,$bits)) && (!is_null($bits[6]))) $fields2=$bits[6];
			if (array_key_exists(7,$bits)) $this->posting_form_text_parsed=$bits[7];
		} else
		{
			$fields=$bits;
			$hidden=new ocp_tempcode();
		}

		// Add in custom fields
		if ($this->has_tied_catalogue())
		{
			require_code('fields');
			$fields->attach(do_template('FORM_SCREEN_FIELD_SPACER',array('TITLE'=>do_lang_tempcode('MORE'))));
			append_form_custom_fields($this->award_type,$id,$fields,$hidden);
		}

		// SEO?
		if (!is_null($this->seo_type))
		{
			require_code('seo2');
			$fields2->attach(seo_get_fields($this->seo_type,$id));
		}

		// Awards?
		if (addon_installed('awards'))
		{
			if (!is_null($this->award_type))
			{
				require_code('awards');
				$fields2->attach(get_award_fields($this->award_type,$id));
			}
		}

		// Action fields / deletion options
		$delete_permission=true;
		if (!is_null($this->permissions_require))
		{
			$delete_permission=has_delete_permission($this->permissions_require,get_member(),$submitter,get_page_name(),array($this->permissions_cat_require,is_null($this->permissions_cat_name)?NULL:$this->get_cat($id),$this->permissions_cat_require_b,is_null($this->permissions_cat_name_b)?NULL:$this->get_cat_b($id)));
		}
		$may_delete=(((!method_exists($this,'may_delete_this')) || ($this->may_delete_this($id))) && ((!is_numeric($id)) || (intval($id)>=db_get_first_id()+$this->protect_first))) && ($delete_permission);

		// Deletion options
		$action_fields=new ocp_tempcode();
		if ($may_delete)
		{
			if (!$all_delete_fields_given)
				$action_fields->attach(form_input_tick(do_lang_tempcode('DELETE'),do_lang_tempcode('DESCRIPTION_DELETE'),'delete',false));

			if ((addon_installed('points')) && (!is_null($submitter)) && (!is_null($date_and_time)))
			{
				$points_test=$GLOBALS['SITE_DB']->query_value_null_ok('gifts','id',array('date_and_time'=>$date_and_time,'gift_to'=>$submitter,'gift_from'=>$GLOBALS['FORUM_DRIVER']->get_guest_id()));
				if (!is_null($points_test))
				{
					require_lang('points');
					$action_fields->attach(form_input_tick(do_lang_tempcode('REVERSE_TITLE'),do_lang_tempcode('REVERSE_TITLE_DESCRIPTION'),'reverse_point_transaction',false));
				}
			}
			$action_fields->attach($delete_fields);
		}

		if ((!$this->appended_actions_already) && (!$action_fields->is_empty()))
		{
			$fields2->attach(do_template('FORM_SCREEN_FIELD_SPACER',array('TITLE'=>do_lang_tempcode('ACTIONS'))));
		}
		$fields2->attach($action_fields);

		if (!is_object($this->edit_text)) $this->edit_text=make_string_tempcode($this->edit_text);
		if (!is_null($this->upload))
		{
			if ($this->upload=='image')
			{
				require_code('images');
				$max=floatval(get_max_image_size())/floatval(1024*1024);
				if ($max<3.0)
				{
					require_code('files2');
					$config_url=get_upload_limit_config_url();
					$this->edit_text->attach(paragraph(do_lang_tempcode(is_null($config_url)?'MAXIMUM_UPLOAD':'MAXIMUM_UPLOAD_STAFF',escape_html(($max>10.0)?integer_format(intval($max)):float_format($max)),escape_html($config_url))));
				}
			} else
			{
				require_code('files2');
				$max=floatval(get_max_file_size())/floatval(1024*1024);
				if ($max<30.0)
				{
					$config_url=get_upload_limit_config_url();
					$this->edit_text->attach(paragraph(do_lang_tempcode(is_null($config_url)?'MAXIMUM_UPLOAD':'MAXIMUM_UPLOAD_STAFF',escape_html(($max>10.0)?integer_format(intval($max)):float_format($max)),escape_html($config_url))));
				}
			}
		}

		if (get_param('type','_ed')=='_edit_catalogue')
		{
			require_javascript('javascript_catalogues');
			
			// Existing fields
			$field_count=0;
			$c_name=get_param('id',false,true);
			$rows=$GLOBALS['SITE_DB']->query_select('catalogue_fields',array('*'),array('c_name'=>$c_name),'ORDER BY cf_order');
			$fields_existing=new ocp_tempcode();
			foreach ($rows as $i=>$myrow)
			{
				$name=get_translated_text($myrow['cf_name']);
				$description=get_translated_text($myrow['cf_description']);
				$prefix='existing_field_'.strval($myrow['id']).'_';
				list($_fields_existing,$_fields_hidden)=$this->get_field_fields((($i==0) && (substr($c_name,0,1)!='_')),count($rows)+10,$prefix,$field_count,$name,$description,$myrow['cf_type'],$myrow['cf_defines_order'],$myrow['cf_visible'],$myrow['cf_searchable'],$myrow['cf_default'],$myrow['cf_required'],$myrow['cf_put_in_category'],$myrow['cf_put_in_search']);
				if ((!is_ecommerce_catalogue($c_name)) || ($i>9))
				{
					$_fields_existing->attach(do_template('FORM_SCREEN_FIELD_SPACER',array('TITLE'=>do_lang_tempcode('ACTIONS'))));
					$_fields_existing->attach(form_input_tick(do_lang_tempcode('DELETE'),do_lang_tempcode('DESCRIPTION_DELETE'),$prefix.'delete',false));
				}
				$temp=do_template('FORM_FIELD_SET_GROUPER',array('_GUID'=>'1492d973db45cbecff892ad4ac1af28f'.get_class($this),'NAME'=>$name,'ID'=>'FIELD_'.strval($i+1),'FIELDS'=>$_fields_existing->evaluate()/*FUDGEFUDGE*/));
				$fields_existing->attach($temp);
				$hidden->attach($_fields_hidden);

				$field_count++;
			}

			// New field
			$fields_new=new ocp_tempcode();
			for ($i=0;$i<5;$i++)
			{
				list($_fields_new,$_fields_hidden)=$this->get_field_fields(false,count($rows)+10,'new_field_'.strval($i).'_',$field_count);
				$temp=do_template('FORM_FIELD_SET_GROUPER',array('_GUID'=>'8b9a632eafae003ccc6b007eefb0ce3d'.get_class($this),'NAME'=>do_lang_tempcode('NEW_FIELD',strval($i+1)),'ID'=>'NEW_FIELD_'.strval($i+1),'FIELDS'=>$_fields_new->evaluate()/*FUDGEFUDGE*/));
				$fields_new->attach($temp);
				$hidden->attach($_fields_hidden);

				$field_count++;
			}

			$fields->attach($fields2);
			return do_template('CATALOGUE_EDITING_SCREEN',array('_GUID'=>'584d7dc7c2c13939626102374f13f508'.get_class($this),'HIDDEN'=>$hidden,'TITLE'=>$title,'TEXT'=>$this->add_text,'URL'=>$post_url,'FIELDS'=>$fields->evaluate()/*FUDGEFUDGE*/,'FIELDS_EXISTING'=>$fields_existing->evaluate()/*FUDGEFUDGE*/,'FIELDS_NEW'=>$fields_new->evaluate()/*FUDGEFUDGE*/,'SUBMIT_NAME'=>$submit_name,'JAVASCRIPT'=>$this->javascript));
		}
		list($warning_details,$ping_url)=handle_conflict_resolution();
		if (!is_null($this->posting_form_title))
		{
			$posting_form=get_posting_form($submit_name,$this->posting_form_text,$post_url,$hidden,$fields,$this->posting_form_title,'',$fields2,$this->posting_form_text_parsed,$this->javascript,NULL,$this->posting_field_required);
			return do_template('POSTING_SCREEN',array('_GUID'=>'841b9af3aa80bcab86b907e4b942786a'.get_class($this),'PREVIEW'=>$this->do_preview,'TITLE'=>$title,'SEPARATE_PREVIEW'=>$this->second_stage_preview,'PING_URL'=>$ping_url,'WARNING_DETAILS'=>$warning_details,'TEXT'=>$this->add_text,'POSTING_FORM'=>$posting_form->evaluate()/*FUDGEFUDGE*/,'JAVASCRIPT'=>$this->javascript));
		} else
		{
			$fields->attach($fields2);
			return do_template('FORM_SCREEN',array('_GUID'=>'2d70be34595a16c6f170d966b894bfe2'.get_class($this),'PREVIEW'=>$this->do_preview,'SEPARATE_PREVIEW'=>$this->second_stage_preview,'TITLE'=>$title,'SKIP_VALIDATION'=>$this->skip_validation,'PING_URL'=>$ping_url,'WARNING_DETAILS'=>$warning_details,'HIDDEN'=>$hidden,'TEXT'=>$this->edit_text,'URL'=>$post_url,'FIELDS'=>$fields->evaluate()/*FUDGEFUDGE*/,'SUBMIT_NAME'=>$submit_name,'JAVASCRIPT'=>$this->javascript));
		}
	}

	/**
	 * Standard modular UI/actualiser to edit an entry.
	 *
	 * @return tempcode	The UI
	 */
	function __ed()
	{
		$id=mixed(); // Define type as mixed
		$id=$this->non_integer_id?get_param('id',false,true):strval(get_param_integer('id'));

		$doing='EDIT_'.$this->lang_type;
		if (($this->catalogue) && (get_param('catalogue_name','')!=''))
		{
			$catalogue_title=get_translated_text($GLOBALS['SITE_DB']->query_value('catalogues','c_title',array('c_name'=>get_param('catalogue_name'))));
			if ($this->type_code=='d')
			{
				$doing=do_lang('CATALOGUE_GENERIC_EDIT',escape_html($catalogue_title));
			}
			elseif ($this->type_code=='c')
			{
				$doing=do_lang('CATALOGUE_GENERIC_EDIT_CATEGORY',escape_html($catalogue_title));
			}
		}
		$title=get_page_title($doing);

		if (($this->second_stage_preview) && (get_param_integer('preview',0)==1))
		{
			return $this->preview_intercept($title);
		}


		if (method_exists($this,'get_submitter'))
		{
			list($submitter,$date_and_time)=$this->get_submitter($id);
			if ((!is_null($date_and_time)) && (addon_installed('points')))
			{
				$reverse=post_param_integer('reverse_point_transaction',0);
				if ($reverse==1)
				{
					$points_test=$GLOBALS['SITE_DB']->query_select('gifts',array('*'),array('date_and_time'=>$date_and_time,'gift_to'=>$submitter,'gift_from'=>$GLOBALS['FORUM_DRIVER']->get_guest_id()));
					if (array_key_exists(0,$points_test))
					{
						$amount=$points_test[0]['amount'];
						$sender_id=$points_test[0]['gift_from'];
						$recipient_id=$points_test[0]['gift_to'];
						$GLOBALS['SITE_DB']->query_delete('gifts',array('id'=>$points_test[0]['id']),'',1);
						if (!is_guest($sender_id))
						{
							$_sender_gift_points_used=point_info($sender_id);
							$sender_gift_points_used=array_key_exists('gift_points_used',$_sender_gift_points_used)?$_sender_gift_points_used['gift_points_used']:0;
							$GLOBALS['FORUM_DRIVER']->set_custom_field($sender_id,'gift_points_used',strval($sender_gift_points_used-$amount));
						}
						require_code('points');
						$temp_points=point_info($recipient_id);
						$GLOBALS['FORUM_DRIVER']->set_custom_field($recipient_id,'points_gained_given',strval((array_key_exists('points_gained_given',$temp_points)?$temp_points['points_gained_given']:0)-$amount));
					}
				}
			}
		} else $submitter=NULL;

		breadcrumb_set_parents(array_merge($GLOBALS['BREADCRUMB_SET_PARENTS'],array(array('_SELF:_SELF:_e'.$this->type_code.':'.$id,(strpos($doing,' ')!==false)?protect_from_escaping($doing):do_lang_tempcode($doing)))));

		$delete=post_param_integer('delete',0);
		if (($delete==1) || ($delete==2)) //1=partial,2=full,...=unknown,thus handled as an edit
		{
			if (!is_null($this->permissions_require))
			{
				check_delete_permission($this->permissions_require,$submitter,array($this->permissions_cat_require,is_null($this->permissions_cat_name)?NULL:$this->get_cat($id),$this->permissions_cat_require_b,is_null($this->permissions_cat_name_b)?NULL:$this->get_cat_b($id)));
			}

			$doing='DELETE_'.$this->lang_type;
			if (($this->catalogue) && (get_param('catalogue_name','')!=''))
			{
				$catalogue_title=get_translated_text($GLOBALS['SITE_DB']->query_value('catalogues','c_title',array('c_name'=>get_param('catalogue_name'))));
				if ($this->type_code=='d')
				{
					$doing=do_lang('CATALOGUE_GENERIC_DELETE',escape_html($catalogue_title));
				}
				elseif ($this->type_code=='c')
				{
					$doing=do_lang('CATALOGUE_GENERIC_DELETE_CATEGORY',escape_html($catalogue_title));
				}
			}
			$title=get_page_title($doing);

			$test=$this->handle_confirmations($title);
			if (!is_null($test)) return $test;

			$this->delete_actualisation($id);

			// Delete custom fields
			if ($this->has_tied_catalogue())
			{
				require_code('fields');
				delete_form_custom_fields($this->award_type,$id);
			}

			/*if ((!is_null($this->redirect_type)) || ((!is_null(get_param('redirect',NULL)))))		No - resource is gone now, and redirect would almost certainly try to take us back there
			{
				$url=(($this->redirect_type=='!') || (is_null($this->redirect_type)))?get_param('redirect'):build_url(array('page'=>'_SELF','type'=>$this->redirect_type),'_SELF');
				return redirect_screen($title,$url,do_lang_tempcode('SUCCESS'));
			}*/

			clear_ocp_autosave();

			$description=is_null($this->do_next_description)?do_lang_tempcode('SUCCESS'):$this->do_next_description;

			return $this->do_next_manager($title,$description,NULL);
		}
		else
		{
			if (!is_null($this->permissions_require))
			{
				check_edit_permission($this->permissions_require,$submitter,array($this->permissions_cat_require,is_null($this->permissions_cat_name)?NULL:$this->get_cat($id),$this->permissions_cat_require_b,is_null($this->permissions_cat_name_b)?NULL:$this->get_cat_b($id)));
			}

			$test=$this->handle_confirmations($title);
			if (!is_null($test)) return $test;

			if (($this->user_facing) && (!is_null($this->permissions_require)) && (array_key_exists('validated',$_POST)))
			{
				if (!has_specific_permission(get_member(),'bypass_validation_'.$this->permissions_require.'range_content',NULL,array($this->permissions_cat_require,is_null($this->permissions_cat_name)?'':post_param($this->permissions_cat_name),$this->permissions_cat_require_b,is_null($this->permissions_cat_name_b)?'':post_param($this->permissions_cat_name_b))))
					$_POST['validated']='0';
			}

			if (!is_null($this->upload)) require_code('uploads');
			$description=$this->edit_actualisation($id);
			if (!is_null($this->new_id)) $id=$this->new_id;

			// Save custom fields
			if ($this->has_tied_catalogue())
			{
				require_code('fields');
				save_form_custom_fields($this->award_type,$id);
			}

			if (($this->output_of_action_is_confirmation) && (!is_null($description))) return $description;

			if (is_null($description)) $description=do_lang_tempcode('SUCCESS');

			if (addon_installed('awards'))
			{
				if (!is_null($this->award_type))
				{
					require_code('awards');
					handle_award_setting($this->award_type,$id);
				}
			}

			if ($this->user_facing)
			{
				if (($this->check_validation) && (post_param_integer('validated',0)==0))
				{
					require_code('submit');
					if ($this->send_validation_request)
					{
						$edit_url=build_url(array('page'=>'_SELF','type'=>'_e'.$this->type_code,'id'=>$id,'validated'=>1),'_SELF',NULL,false,false,true);
						if (addon_installed('unvalidated'))
							send_validation_request($doing,$this->table,$this->non_integer_id,$id,$edit_url);
					}
	
					$description->attach(paragraph(do_lang_tempcode('SUBMIT_UNVALIDATED')));
				}
			}
		}

		if ((!is_null($this->redirect_type)) || ((!is_null(get_param('redirect',NULL)))))
		{
			$url=(($this->redirect_type=='!') || (is_null($this->redirect_type)))?make_string_tempcode(get_param('redirect')):build_url(array('page'=>'_SELF','type'=>$this->redirect_type),'_SELF');
			return redirect_screen($title,$url,do_lang_tempcode('SUCCESS'));
		}

		clear_ocp_autosave();
		decache('main_awards');

		return $this->do_next_manager($title,$description,$id);
	}

}
