<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2012

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		core_feedback_features
 */

/**
 * Module page class.
 */
class Module_admin_trackbacks
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']='Chris Graham';
		$info['organisation']='ocProducts';
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=2;
		$info['locked']=false;
		return $info;
	}
	
	/**
	 * Standard modular entry-point finder function.
	 *
	 * @return ?array	A map of entry points (type-code=>language-code) (NULL: disabled).
	 */
	function get_entry_points()
	{
		return array('misc'=>'MANAGE_TRACKBACKS');
	}
	
	/**
	 * Standard modular run function.
	 *
	 * @return tempcode	The result of execution.
	 */
	function run()
	{
		$GLOBALS['HELPER_PANEL_PIC']='pagepics/trackbacks';
		$GLOBALS['HELPER_PANEL_TEXT']=comcode_lang_string('DOC_TRACKBACKS');

		require_lang('trackbacks');
		
		$type=get_param('type','misc');

		if ($type=='misc') return $this->choose();
		if ($type=='delete') return $this->delete_trackbacks();

		return new ocp_tempcode();
	}

	/**
	 * The UI to delete trackbacks.
	 *
	 * @return tempcode		The UI
	 */
	function choose()
	{
		$title=get_page_title('MANAGE_TRACKBACKS');

		$trackback_rows=$GLOBALS['SITE_DB']->query_select('trackbacks',array('*'),NULL,'ORDER BY id DESC',1000);
		
		$trackbacks='';
		foreach ($trackback_rows as $value)
		{
			$trackbacks.=static_evaluate_tempcode(do_template('TRACKBACK',array('ID'=>strval($value['id']),'TIME_RAW'=>strval($value['trackback_time']),'TIME'=>get_timezoned_date($value['trackback_time']),'URL'=>$value['trackback_url'],'TITLE'=>$value['trackback_title'],'EXCERPT'=>$value['trackback_excerpt'],'NAME'=>$value['trackback_name'])));
		}
		
		return do_template('TRACKBACK_DELETE_SCREEN',array('_GUID'=>'51f7e4c1976bcaf120758d2c86771289','TITLE'=>$title,'TRACKBACKS'=>$trackbacks,'LOTS'=>count($trackback_rows)==1000));
	}
	
	/**
	 * The actualiser to delete trackbacks.
	 *
	 * @return tempcode		The UI
	 */
	function delete_trackbacks()
	{
		$title=get_page_title('DELETE_TRACKBACKS');
	
		foreach ($_POST as $key=>$val)
		{
			if (!is_string($val)) continue;
			
			if (substr($key,0,10)=='trackback_')
			{
				$id=intval(substr($key,10));
				switch ($val)
				{
					case '2':
						if (addon_installed('securitylogging'))
						{
							$trackback_ip=$GLOBALS['SITE_DB']->query_value_null_ok('trackbacks','trackback_ip',array('id'=>$id));
							if (is_null($trackback_ip)) break;
							require_code('failure');
							add_ip_ban($trackback_ip,do_lang('TRACKBACK_SPAM'));
							syndicate_spammer_report($trackback_ip,'','',do_lang('TRACKBACK_SPAM'),true);
						}
						// Intentionally no 'break' line below
					case '1':
						$GLOBALS['SITE_DB']->query_delete('trackbacks',array('id'=>$id),'',1);
						break;
					// (zero is do nothing)
				}
			}
		}
		
		// Show it worked / Refresh
		$text=do_lang_tempcode('SUCCESS');
		$url=get_param('redirect',NULL);
		if (is_null($url))
		{
			$_url=build_url(array('page'=>'_SELF','type'=>'misc'),'_SELF');
			$url=$_url->evaluate();
		}
		return redirect_screen($title,$url,$text);
	}

}

