<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2012

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		securitylogging
 */

/**
 * Module page class.
 */
class Module_admin_ipban
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']='Chris Graham';
		$info['organisation']='ocProducts';
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=5;
		$info['locked']=true;
		$info['update_require_upgrade']=1;
		return $info;
	}
	
	/**
	 * Standard modular uninstall function.
	 */
	function uninstall()
	{
		$GLOBALS['SITE_DB']->drop_if_exists('usersubmitban_ip');
		$GLOBALS['SITE_DB']->drop_if_exists('usersubmitban_member');
	}
	
	/**
	 * Standard modular install function.
	 *
	 * @param  ?integer	What version we're upgrading from (NULL: new install)
	 * @param  ?integer	What hack version we're upgrading from (NULL: new-install/not-upgrading-from-a-hacked-version)
	 */
	function install($upgrade_from=NULL,$upgrade_from_hack=NULL)
	{
		if (is_null($upgrade_from))
		{
			$GLOBALS['SITE_DB']->create_table('usersubmitban_ip',array(
				'ip'=>'*IP',
				'i_descrip'=>'LONG_TEXT',
			));
	
			$GLOBALS['SITE_DB']->create_table('usersubmitban_member',array(
				'the_member'=>'*USER',
			));
		}
		if ((!is_null($upgrade_from)) && ($upgrade_from<3))
		{
			$GLOBALS['SITE_DB']->drop_if_exists('usersubmit');
		}
		if ((!is_null($upgrade_from)) && ($upgrade_from<4))
		{
			$GLOBALS['SITE_DB']->add_table_field('usersubmitban_ip','i_descrip','LONG_TEXT');
		}
		if ((!is_null($upgrade_from)) && ($upgrade_from<5))
		{
			$GLOBALS['SITE_DB']->add_table_field('usersubmitban_ip','i_ban_until','?TIME');
			$GLOBALS['SITE_DB']->add_table_field('usersubmitban_ip','i_ban_positive','BINARY',1);
		}
	}
	
	/**
	 * Standard modular entry-point finder function.
	 *
	 * @return ?array	A map of entry points (type-code=>language-code) (NULL: disabled).
	 */
	function get_entry_points()
	{
		return array('misc'=>'IP_BANS');
	}
	
	/**
	 * Standard modular run function.
	 *
	 * @return tempcode	The result of execution.
	 */
	function run()
	{
		$GLOBALS['HELPER_PANEL_PIC']='pagepics/ipban';
		$GLOBALS['HELPER_PANEL_TUTORIAL']='tut_censor';

		require_lang('submitban');
		require_code('submit');

		// What are we doing?
		$type=get_param('type','misc');

		if ($type=='misc') return $this->gui();
		if ($type=='actual') return $this->actual();
		return new ocp_tempcode();
	}
	
	/**
	 * The UI for managing banned IPs.
	 *
	 * @return tempcode		The UI
	 */
	function gui()
	{
		$title=get_page_title('IP_BANS');

		$lookup_url=build_url(array('page'=>'admin_lookup'),get_module_zone('admin_lookup'));
		$GLOBALS['HELPER_PANEL_TEXT']=comcode_to_tempcode(do_lang('IP_BANNING_WILDCARDS',$lookup_url->evaluate()));

		$bans='';
		$locked_bans='';
		$rows=$GLOBALS['SITE_DB']->query('SELECT ip,i_descrip,i_ban_until FROM '.get_table_prefix().'usersubmitban_ip WHERE i_ban_positive=1 AND (i_ban_until IS NULL'.' OR i_ban_until>'.strval(time()).')');
		foreach ($rows as $row)
		{
			if (is_null($row['i_ban_until']))
			{
				$bans.=$row['ip'].' '.$row['i_descrip'].chr(10);
			} else
			{
				$locked_bans.=do_lang('SPAM_AUTO_BAN_TIMEOUT',$row['ip'],$row['i_descrip'],get_timezoned_date($row['i_ban_until'])).chr(10);
			}
		}

		$post_url=build_url(array('page'=>'_SELF','type'=>'actual'),'_SELF');
		
		require_code('form_templates');

		list($warning_details,$ping_url)=handle_conflict_resolution();

		return do_template('IPBAN_SCREEN',array('_GUID'=>'963d24852ba87e9aa84e588862bcfecb','PING_URL'=>$ping_url,'WARNING_DETAILS'=>$warning_details,'TITLE'=>$title,'LOCKED_BANS'=>$locked_bans,'BANS'=>$bans,'URL'=>$post_url));
	}

	/**
	 * The actualiser for managing banned IPs.
	 *
	 * @return tempcode		The UI
	 */
	function actual()
	{
		require_code('failure');

		$rows=$GLOBALS['SITE_DB']->query('SELECT ip,i_descrip FROM '.get_table_prefix().'usersubmitban_ip WHERE i_ban_until IS NULL'/*.' OR i_ban_until>'.strval(time())*/);
		$old_bans=collapse_1d_complexity('ip',$rows);
		$bans=post_param('bans');
		$_bans=explode(chr(10),$bans);
		foreach ($old_bans as $ban)
		{
			if (!in_array($ban,$_bans)) remove_ip_ban($ban);
		}
		$matches=array();
		foreach ($_bans as $ban)
		{
			if (trim($ban)=='') continue;
			if (!in_array($ban,$old_bans))
			{
				if (preg_match('#^(\d+|\*)\.(\d+|\*)\.(\d+|\*)\.(\d+|\*)(.*)#',$ban,$matches)==0)
				{
					attach_message(do_lang_tempcode('IP_ADDRESS_NOT_VALID',$ban),'warn');
				} else
				{
					$ban=$matches[1].'.'.$matches[2].'.'.$matches[3].'.'.$matches[4];
					ban_ip($ban,trim($matches[5]));
					$old_bans[]=$ban;
				}
			}
		}

		// Show it worked / Refresh
		$title=get_page_title('IP_BANS');
		$refresh_url=build_url(array('page'=>'_SELF','type'=>'misc'),'_SELF');
		return redirect_screen($title,$refresh_url,do_lang_tempcode('SUCCESS'));
	}

}


