<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2012

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		core_configuration
 */

/**
 * Module page class.
 */
class Module_admin_config
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']='Chris Graham';
		$info['organisation']='ocProducts';
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=13;
		$info['locked']=true;
		$info['update_require_upgrade']=1;
		return $info;
	}
	
	/**
	 * Standard modular uninstall function.
	 */
	function uninstall()
	{
		$config_options=array('simplified_donext','anti_leech','allow_audio_videos','low_space_check','site_name','site_scope','description','copyright','welcome_message','keywords','logo_map','validation',
										'gzip_output','forum_in_portal','staff_address','is_on_gd','is_on_folder_create','site_closed','closed',
										'maximum_users','cc_address','log_php_errors','display_php_errors','valid_types','valid_images','is_on_rating',
										'is_on_comments','comments_forum_name','comment_text','thumb_width','max_image_size','mod_rewrite','is_on_trackbacks',
										'session_expiry_time','unzip_dir','unzip_cmd','detect_lang_forum','detect_lang_browser','enable_https',
										'smtp_sockets_use','smtp_sockets_host','smtp_sockets_port','smtp_sockets_username','smtp_sockets_password',
										'smtp_from_address','use_security_images','send_error_emails','send_error_emails_ocproducts','width_left','width_right',
										'validation_xhtml','validation_wcag','validation_css','validation_javascript','validation_ext_files','validation_compat',
										'is_on_strong_forum_tie','is_on_preview_validation','show_inline_stats',
										'sms_username','sms_password','sms_api_id','sms_low_limit','sms_high_limit','sms_low_trigger_limit','sms_high_trigger_limit','max_download_size',
										'bottom_show_admin_menu','bottom_show_top_button','bottom_show_feedback_link','bottom_show_privacy_link',
										'bottom_show_sitemap_button','forum_show_personal_stats_posts','forum_show_personal_stats_topics',
										'ocp_show_personal_sub_links','ocp_show_personal_adminzone_link','ocp_show_conceded_mode_link','ocp_show_su','ocp_show_staff_page_actions','ocf_show_profile_link',
										'ocp_show_personal_usergroup','ocp_show_personal_last_visit','ocp_show_avatar',
										'panel_width','panel_width_spaced','debug_mode','main_forum_name','allowed_post_submitters','ssw',
										'root_zone_login_theme','use_custom_zone_menu','tray_support','show_docs','captcha_noise','captcha_on_feedback',
										'show_post_validation','ip_forwarding','force_meta_refresh','use_contextual_dates','eager_wysiwyg',
										'website_email','enveloper_override','bcc','allow_ext_images','htm_short_urls','ip_strict_for_sessions','enable_previews',
										'enable_keyword_density_check','enable_spell_check','enable_markup_validation','enable_image_fading','users_online_time','auto_submit_sitemap',
										'user_postsize_errors','automatic_meta_extraction','is_on_emoticon_choosers','no_stats_when_closed',
										'deeper_admin_breadcrumbs','has_low_memory_limit','is_on_comcode_page_children','global_donext_icons','no_bot_stats',
										'java_upload','java_ftp_host','java_username','java_password','java_ftp_path','filesystem_caching',
										'check_broken_urls','advanced_admin_cache','collapse_user_zones','google_analytics','fixed_width','show_screen_actions','show_content_tagging','show_content_tagging_inline',
										'long_google_cookies','remember_me_by_default','detect_javascript','mobile_support','mail_queue','mail_queue_debug',
										'comments_to_show_in_thread','max_thread_depth',
										'spam_check_level','stopforumspam_api_key','tornevall_api_username','tornevall_api_password','spam_block_lists','spam_cache_time','spam_check_exclusions',
										'spam_stale_threshold','spam_ban_threshold','spam_block_threshold','spam_approval_threshold',
										'spam_check_usernames','implied_spammer_confidence','spam_blackhole_detection','honeypot_url','honeypot_phrase',
										);

		foreach ($config_options as $option)
			delete_config_option($option);
	}

	/**
	 * Standard modular install function.
	 *
	 * @param  ?integer	What version we're upgrading from (NULL: new install)
	 * @param  ?integer	What hack version we're upgrading from (NULL: new-install/not-upgrading-from-a-hacked-version)
	 */
	function install($upgrade_from=NULL,$upgrade_from_hack=NULL)
	{
		if (($upgrade_from<3) || (is_null($upgrade_from))) // These are new in 3 of this module, and thus are for upgrades and fresh installs
		{
			add_config_option('MOD_REWRITE','mod_rewrite','tick','return \''.(in_array(ocp_srv('HTTP_HOST'),array('test.ocportal.com'))?'1':'0').'\'; /*function_exists(\'apache_get_modules\')?\'1\':\'0\';*/','SITE','ADVANCED');
		}
		if (($upgrade_from<4) || (is_null($upgrade_from))) // These are new in 4 of this module, and thus are for upgrades and fresh installs
		{
			add_config_option('SESSION_EXPIRY_TIME','session_expiry_time','integer','return \'1\';','SECURITY','GENERAL');
		}
		if (($upgrade_from<5) || (is_null($upgrade_from))) // These are new in 5 of this module, and thus are for upgrades and fresh installs
		{
			add_config_option('TRACKBACKS','is_on_trackbacks','tick','return \'0\';','FEATURE','USER_INTERACTION');

			add_config_option('UNZIP_DIR','unzip_dir','line','return (DIRECTORY_SEPARATOR==\'/\')?\'/tmp/\':ocp_srv(\'TMP\');','SITE','ARCHIVES',1);
			add_config_option('UNZIP_CMD','unzip_cmd','line','return \'/usr/bin/unzip -o @_SRC_@ -x -d @_DST_@\';','SITE','ARCHIVES',1);

			add_config_option('ENABLED','smtp_sockets_use','tick','return \'0\';','SITE','SMTP',1);
			add_config_option('HOST','smtp_sockets_host','line','return \'mail.yourispwhateveritis.net\';','SITE','SMTP',1);
			add_config_option('PORT','smtp_sockets_port','line','return \'25\';','SITE','SMTP',1);
			add_config_option('USERNAME','smtp_sockets_username','line','return \'\';','SITE','SMTP',1);
			add_config_option('PASSWORD','smtp_sockets_password','line','return \'\';','SITE','SMTP',1);
			add_config_option('EMAIL_ADDRESS','smtp_from_address','line','return \'\';','SITE','SMTP',1);

			add_config_option('USE_SECURITY_IMAGES','use_security_images','tick','return \'1\';','SECURITY','GENERAL');
			add_config_option('HTTPS_SUPPORT','enable_https','tick','return \'0\';','SECURITY','GENERAL',1);

			add_config_option('SEND_ERROR_EMAILS_OCPRODUCTS','send_error_emails_ocproducts','tick','return '.strval(post_param_integer('allow_reports_default',0)).';','SITE','ADVANCED',1);

			add_config_option('LOW_DISK_SPACE_SUBJECT','low_space_check','integer','return \'20\';','SITE','GENERAL'); // 20MB - very very low even for lame web hosts

			add_config_option('DETECT_LANG_FORUM','detect_lang_forum','tick','return \'1\';','SITE','ADVANCED');
			add_config_option('DETECT_LANG_BROWSER','detect_lang_browser','tick','return \'0\';','SITE','ADVANCED');
		}
		if (($upgrade_from<7) && (!is_null($upgrade_from))) // These are changed in 7 of this module, and thus are for upgrades and not fresh installs
		{
			$GLOBALS['SITE_DB']->query_update('config',array('eval'=>'return has_no_forum()?NULL:do_template(\'COMMENTS_DEFAULT_TEXT\');'),array('the_name'=>'comment_text'),'',1);
			if ($GLOBALS['OPTIONS']['comment_text']['c_set']==0)
			{
				$tpl=do_template('COMMENTS_DEFAULT_TEXT');
				set_option('comment_text',$tpl->evaluate());
			}
			delete_config_option('width_left');
			delete_config_option('width_right');
			set_option('welcome_message','[html]'.get_option('welcome_message').'[/html]');
			set_option('closed','[html]'.get_option('closed').'[/html]');
			delete_config_option('xhtml_validation');
		}

		if ((is_null($upgrade_from)) || ($upgrade_from<7))
		{
			add_config_option('ALLOW_AUDIO_VIDEOS','allow_audio_videos','tick','return \'1\';','SITE','ADVANCED');
			add_config_option('VALIDATION','validation','tick','return \'0\';','SITE','VALIDATION',1); /*(((substr(ocp_srv('HTTP_HOST'),0,8)=='192.168.') || (substr(ocp_srv('HTTP_HOST'),0,7)=='10.0.0.') || (in_array(ocp_srv('HTTP_HOST'),array('localhost','test.ocportal.com'))))?'1':'0')*/ // return (!function_exists(\'memory_get_usage()\') || (ini_get(\'memory_limit\')!=\'8M\'))?\'1\':\'0\';
			add_config_option('VALIDATION_XHTML','validation_xhtml','tick','return \'1\';','SITE','VALIDATION',1);
			add_config_option('VALIDATION_WCAG','validation_wcag','tick','return \'1\';','SITE','VALIDATION',1);
			add_config_option('VALIDATION_CSS','validation_css','tick','return \'0\';','SITE','VALIDATION',1);
			add_config_option('VALIDATION_JAVASCRIPT','validation_javascript','tick','return \'0\';','SITE','VALIDATION',1);
			add_config_option('VALIDATION_COMPAT','validation_compat','tick','return \'0\';','SITE','VALIDATION',1);
			add_config_option('VALIDATION_EXT_FILES','validation_ext_files','tick','return \'0\';','SITE','VALIDATION',1);
			add_config_option('MAX_SIZE','max_download_size','integer','return \'20000\';','SITE','UPLOAD');
		}
		if ((is_null($upgrade_from)) || ($upgrade_from<8))
		{
			// TODO: Move these into sms addon_registry hook, once these hooks support installation
			add_config_option('USERNAME','sms_username','line','return addon_installed(\'sms\')?\'\':NULL;','FEATURE','SMS');
			add_config_option('PASSWORD','sms_password','line','return addon_installed(\'sms\')?\'\':NULL;','FEATURE','SMS');
			add_config_option('API_ID','sms_api_id','integer','return addon_installed(\'sms\')?\'\':NULL;','FEATURE','SMS');
			add_config_option('SMS_LOW_LIMIT','sms_low_limit','integer','return addon_installed(\'sms\')?\'10\':NULL;','FEATURE','SMS');
			add_config_option('SMS_HIGH_LIMIT','sms_high_limit','integer','return addon_installed(\'sms\')?\'20\':NULL;','FEATURE','SMS');
			add_config_option('SMS_LOW_TRIGGER_LIMIT','sms_low_trigger_limit','integer','return addon_installed(\'sms\')?\'50\':NULL;','FEATURE','SMS');
			add_config_option('SMS_HIGH_TRIGGER_LIMIT','sms_high_trigger_limit','integer','return addon_installed(\'sms\')?\'100\':NULL;','FEATURE','SMS');

			add_config_option('ALLOWED_POST_SUBMITTERS','allowed_post_submitters','text','return \'\';','SECURITY','ADVANCED',1);
			add_config_option('STRONG_FORUM_TIE','is_on_strong_forum_tie','tick','return \'0\';','FEATURE','USER_INTERACTION',1);
			add_config_option('VALIDATION_ON_PREVIEW','is_on_preview_validation','tick','return \'1\';','SITE','VALIDATION',1);
			add_config_option('SHOW_INLINE_STATS','show_inline_stats','tick','return \'1\';','SITE','GENERAL');
			add_config_option('SIMPLIFIED_DONEXT','simplified_donext','tick','return \'0\';','SITE','ADVANCED');
			add_config_option('ANTI_LEECH','anti_leech','tick','return \'0\';','SECURITY','GENERAL');
			add_config_option('SSW','ssw','tick','return \'0\';','SITE','GENERAL');
			add_config_option('ADMIN_MENU','bottom_show_admin_menu','tick','return \'1\';','FEATURE','BOTTOM_LINKS');
			add_config_option('TOP_LINK','bottom_show_top_button','tick','return \'0\';','FEATURE','BOTTOM_LINKS');
			add_config_option('FEEDBACK_LINK','bottom_show_feedback_link','tick','return \'1\';','FEATURE','BOTTOM_LINKS');
			add_config_option('PRIVACY_LINK','bottom_show_privacy_link','tick','return \'1\';','FEATURE','BOTTOM_LINKS');
			add_config_option('SITEMAP_LINK','bottom_show_sitemap_button','tick','return \'1\';','FEATURE','BOTTOM_LINKS');
			add_config_option('COUNT_POSTSCOUNT','forum_show_personal_stats_posts','tick','return has_no_forum()?NULL:\'0\';','BLOCKS','PERSONAL_BLOCK');
			add_config_option('COUNT_TOPICSCOUNT','forum_show_personal_stats_topics','tick','return ((has_no_forum()) || (get_forum_type()!=\'ocf\'))?NULL:\'0\';','BLOCKS','PERSONAL_BLOCK');
			add_config_option('ADMIN_ZONE_LINK','ocp_show_personal_adminzone_link','tick','return \'1\';','BLOCKS','PERSONAL_BLOCK');
			add_config_option('CONCEDED_MODE_LINK','ocp_show_conceded_mode_link','tick','return \'0\';','BLOCKS','PERSONAL_BLOCK');
			add_config_option('SU','ocp_show_su','tick','return has_no_forum()?NULL:\'1\';','BLOCKS','PERSONAL_BLOCK');
			add_config_option('PAGE_ACTIONS','ocp_show_staff_page_actions','tick','return \'1\';','THEME','GENERAL');
			add_config_option('MY_PROFILE_LINK','ocf_show_profile_link','tick','return has_no_forum()?NULL:\'1\';','BLOCKS','PERSONAL_BLOCK');
			add_config_option('_USERGROUP','ocp_show_personal_usergroup','tick','return has_no_forum()?NULL:\'0\';','BLOCKS','PERSONAL_BLOCK');
			add_config_option('LAST_HERE','ocp_show_personal_last_visit','tick','return has_no_forum()?NULL:\'0\';','BLOCKS','PERSONAL_BLOCK');
			add_config_option('AVATAR','ocp_show_avatar','tick','return (has_no_forum() || ((get_forum_type()==\'ocf\') && (!addon_installed(\'ocf_member_avatars\'))))?NULL:\'0\';','BLOCKS','PERSONAL_BLOCK');
			add_config_option('PANEL_WIDTH','panel_width','line','return \'13.3em\';','THEME','GENERAL');
			add_config_option('PANEL_WIDTH_SPACED','panel_width_spaced','line','return \'14.3em\';','THEME','GENERAL');
			add_config_option('ROOT_ZONE_LOGIN_THEME','root_zone_login_theme','tick','return \'0\';','THEME','GENERAL');
			add_config_option('USE_CUSTOM_ZONE_MENU','use_custom_zone_menu','tick','return \'1\';','THEME','GENERAL');
			add_config_option('TRAY_SUPPORT','tray_support','tick','return \'1\';','THEME','GENERAL');
			add_config_option('SHOW_DOCS','show_docs','tick','return \'1\';','SITE','ADVANCED');
			add_config_option('CAPTCHA_NOISE','captcha_noise','tick','return addon_installed(\'captcha\')?\'1\':NULL;','SECURITY','SPAMMER_DETECTION');
			add_config_option('CAPTCHA_ON_FEEDBACK','captcha_on_feedback','tick','return addon_installed(\'captcha\')?\'0\':NULL;','SECURITY','SPAMMER_DETECTION');
			add_config_option('SHOW_POST_VALIDATION','show_post_validation','tick','return \'1\';','SITE','ADVANCED');
			add_config_option('IP_FORWARDING','ip_forwarding','tick','return \'0\';','SITE','ENVIRONMENT');
			add_config_option('FORCE_META_REFRESH','force_meta_refresh','tick','return \'0\';','SITE','ENVIRONMENT');
			add_config_option('USE_CONTEXTUAL_DATES','use_contextual_dates','tick','return \'1\';','SITE','ADVANCED');
			add_config_option('EAGER_WYSIWYG','eager_wysiwyg','tick','return \'0\';','SITE','ADVANCED');
			add_config_option('WEBSITE_EMAIL','website_email','line','$staff_address=get_option(\'staff_address\'); $website_email=\'website@\'.get_domain(); if (substr($staff_address,-strlen(get_domain())-1)==\'@\'.get_domain()) $website_email=$staff_address; return $website_email;','SITE','EMAIL');
			add_config_option('ENVELOPER_OVERRIDE','enveloper_override','tick','return \'0\';','SITE','EMAIL');
			add_config_option('BCC','bcc','tick','return \'1\';','SITE','EMAIL');
			add_config_option('ALLOW_EXT_IMAGES','allow_ext_images','tick','return \'0\';','SITE','EMAIL');
			add_config_option('HTM_SHORT_URLS','htm_short_urls','tick','return \'0\';','SITE','ADVANCED');
			add_config_option('IP_STRICT_FOR_SESSIONS','ip_strict_for_sessions','tick','return \'1\';','SECURITY','GENERAL');
			add_config_option('ENABLE_PREVIEWS','enable_previews','tick','return \'1\';','SITE','PREVIEW');
			add_config_option('ENABLE_KEYWORD_DENSITY_CHECK','enable_keyword_density_check','tick','return \'0\';','SITE','PREVIEW');
			add_config_option('ENABLE_SPELL_CHECK','enable_spell_check','tick','return function_exists(\'pspell_check\')?\'0\':NULL;','SITE','PREVIEW');
			add_config_option('ENABLE_MARKUP_VALIDATION','enable_markup_validation','tick','return \'0\';','SITE','PREVIEW');
			add_config_option('ENABLE_IMAGE_FADING','enable_image_fading','tick','return \'1\';','THEME','GENERAL');
		}
		if ((is_null($upgrade_from)) || ($upgrade_from<9))
		{
			add_config_option('AUTO_SUBMIT_SITEMAP','auto_submit_sitemap','tick','return \'0\';','SITE','GENERAL');
			add_config_option('USER_POSTSIZE_ERRORS','user_postsize_errors','tick','return is_null($old=get_value(\'no_user_postsize_errors\'))?\'1\':invert_value($old);','SITE','UPLOAD');
			add_config_option('AUTOMATIC_META_EXTRACTION','automatic_meta_extraction','tick','return is_null($old=get_value(\'no_auto_meta\'))?\'1\':invert_value($old);','SITE','GENERAL');
			add_config_option('IS_ON_EMOTICON_CHOOSERS','is_on_emoticon_choosers','tick','return is_null($old=get_value(\'no_emoticon_choosers\'))?\'1\':invert_value($old);','THEME','GENERAL');
			add_config_option('DEEPER_ADMIN_BREADCRUMBS','deeper_admin_breadcrumbs','tick','return is_null($old=get_value(\'no_admin_menu_assumption\'))?\'1\':invert_value($old);','SITE','ADVANCED');
			add_config_option('HAS_LOW_MEMORY_LIMIT','has_low_memory_limit','tick','return is_null($old=get_value(\'has_low_memory_limit\'))?((ini_get(\'memory_limit\')==\'-1\' || ini_get(\'memory_limit\')==\'0\' || ini_get(\'memory_limit\')==\'\')?\'0\':NULL):$old;','SITE','ADVANCED');
			add_config_option('IS_ON_COMCODE_PAGE_CHILDREN','is_on_comcode_page_children','tick','return is_null($old=get_value(\'disable_comcode_page_children\'))?\'1\':invert_value($old);','SITE','ADVANCED');
			add_config_option('GLOBAL_DONEXT_ICONS','global_donext_icons','tick','return is_null($old=get_value(\'disable_donext_global\'))?\'1\':invert_value($old);','SITE','ADVANCED');
			add_config_option('NO_STATS_WHEN_CLOSED','no_stats_when_closed','tick','return \''.(((substr(ocp_srv('HTTP_HOST'),0,8)=='192.168.') || (substr(ocp_srv('HTTP_HOST'),0,7)=='10.0.0.') || (in_array(ocp_srv('HTTP_HOST'),array('localhost','test.ocportal.com'))))?'0':'1').'\';','SITE','CLOSED_SITE');
			add_config_option('NO_BOT_STATS','no_bot_stats','tick','return \'0\';','SITE','GENERAL');
			add_config_option('FILE_SYSTEM_CACHING','filesystem_caching','tick','return \'0\';','SITE','CACHES');

			// Java/FTP upload
			add_config_option('ENABLE_JAVA_UPLOAD','java_upload','tick','return \'0\';','SITE','JAVA_UPLOAD');
			add_config_option('JAVA_FTP_HOST','java_ftp_host','line','return ocp_srv(\'HTTP_HOST\');','SITE','JAVA_UPLOAD');
			add_config_option('JAVA_FTP_USERNAME','java_username','line','return \'anonymous\';','SITE','JAVA_UPLOAD');
			add_config_option('JAVA_FTP_PASSWORD','java_password','line','return \'someone@example.com\';','SITE','JAVA_UPLOAD');
			add_config_option('JAVA_FTP_PATH','java_ftp_path','line','return \'/public_html/uploads/incoming/\';','SITE','JAVA_UPLOAD');
		}
		if ((is_null($upgrade_from)) || ($upgrade_from<10))
		{
			add_config_option('ADVANCED_ADMIN_CACHE','advanced_admin_cache','tick','return \'0\';','SITE','CACHES');
			add_config_option('COLLAPSE_USER_ZONES','collapse_user_zones','tick','return \'1\';','SITE','GENERAL');
			add_config_option('CHECK_BROKEN_URLS','check_broken_urls','tick','return \'1\';','SITE','_COMCODE');
			add_config_option('GOOGLE_ANALYTICS','google_analytics','line','return \'\';','SITE','GENERAL');
			add_config_option('FIXED_WIDTH','fixed_width','tick','return \'1\';','THEME','GENERAL');
			add_config_option('SHOW_CONTENT_TAGGING','show_content_tagging','tick','return \'0\';','THEME','GENERAL');
			add_config_option('SHOW_CONTENT_TAGGING_INLINE','show_content_tagging_inline','tick','return \'0\';','THEME','GENERAL');
			add_config_option('SHOW_SCREEN_ACTIONS','show_screen_actions','tick','return \'1\';','THEME','GENERAL');
			add_config_option('PERSONAL_SUB_LINKS','ocp_show_personal_sub_links','tick','return \'1\';','BLOCKS','PERSONAL_BLOCK');
		}
		if ((is_null($upgrade_from)) || ($upgrade_from<11))
		{
			add_config_option('LONG_GOOGLE_COOKIES','long_google_cookies','tick','return \'0\';','SITE','GENERAL');
			add_config_option('REMEMBER_ME_BY_DEFAULT','remember_me_by_default','tick','return \'0\';','SITE','GENERAL');
			add_config_option('DETECT_JAVASCRIPT','detect_javascript','tick','return \'0\';','SITE','ADVANCED');
			add_config_option('MOBILE_SUPPORT','mobile_support','tick','return \'1\';','SITE','GENERAL');
		}
		if ((is_null($upgrade_from)) || ($upgrade_from<12))
		{
			add_config_option('MAIL_QUEUE','mail_queue','tick','return \'0\';','SITE','EMAIL');
			add_config_option('MAIL_QUEUE_DEBUG','mail_queue_debug','tick','return \'0\';','SITE','EMAIL');
			add_config_option('COMMENTS_TO_SHOW_IN_THREAD','comments_to_show_in_thread','integer','return \'30\';','FEATURE','USER_INTERACTION');
			add_config_option('MAX_THREAD_DEPTH','max_thread_depth','integer','return \'6\';','FEATURE','USER_INTERACTION');
		}
		if ((!is_null($upgrade_from)) && ($upgrade_from<12))
		{
			foreach (array('send_error_emails','ocf_show_personal_myhome_link','twitter_login','twitter_password','facebook_api','facebook_appid','facebook_secret_code','facebook_uid','facebook_target_ids') as $option_to_delete)
				delete_config_option($option_to_delete);
		}
		if ((is_null($upgrade_from)) || ($upgrade_from<13))
		{
			add_config_option('SPAM_CHECK_LEVEL','spam_check_level','list','return \'NEVER\';','SECURITY','SPAMMER_DETECTION',0,'EVERYTHING|ACTIONS|GUESTACTIONS|JOINING|NEVER');
			add_config_option('STOPFORUMSPAM_API_KEY','stopforumspam_api_key','line','return \'\';','SECURITY','SPAMMER_DETECTION');
			add_config_option('TORNEVALL_API_USERNAME','tornevall_api_username','line','return class_exists(\'SoapClient\')?\'\':NULL;','SECURITY','SPAMMER_DETECTION');
			add_config_option('TORNEVALL_API_PASSWORD','tornevall_api_password','line','return class_exists(\'SoapClient\')?\'\':NULL;','SECURITY','SPAMMER_DETECTION');
			add_config_option('SPAM_BLOCK_LISTS','spam_block_lists','line','return \'*.opm.tornevall.org\';','SECURITY','SPAMMER_DETECTION');
			add_config_option('SPAM_CACHE_TIME','spam_cache_time','integer','return \'60\';','SECURITY','SPAMMER_DETECTION');
			add_config_option('SPAM_CHECK_EXCLUSIONS','spam_check_exclusions','line','return \'127.0.0.1,\'.ocp_srv(\'SERVER_ADDR\').\'\';','SECURITY','SPAMMER_DETECTION');
			add_config_option('SPAM_STALE_THRESHOLD','spam_stale_threshold','integer','return \'31\';','SECURITY','SPAMMER_DETECTION');
			add_config_option('SPAM_BAN_THRESHOLD','spam_ban_threshold','integer','return \'90\';','SECURITY','SPAMMER_DETECTION');
			add_config_option('SPAM_BLOCK_THRESHOLD','spam_block_threshold','integer','return \'60\';','SECURITY','SPAMMER_DETECTION');
			add_config_option('SPAM_APPROVAL_THRESHOLD','spam_approval_threshold','integer','return \'40\';','SECURITY','SPAMMER_DETECTION');
			add_config_option('SPAM_CHECK_USERNAMES','spam_check_usernames','tick','return \'0\';','SECURITY','SPAMMER_DETECTION');
			add_config_option('IMPLIED_SPAMMER_CONFIDENCE','implied_spammer_confidence','integer','return \'80\';','SECURITY','SPAMMER_DETECTION');
			add_config_option('SPAM_BLACKHOLE_DETECTION','spam_blackhole_detection','tick','return \'1\';','SECURITY','SPAMMER_DETECTION');
			add_config_option('HONEYPOT_URL','honeypot_url','line','return \'\';','SECURITY','SPAMMER_DETECTION');
			add_config_option('HONEYPOT_PHRASE','honeypot_phrase','line','return \'\';','SECURITY','SPAMMER_DETECTION');
		}

		if ((!is_null($upgrade_from)) && ($upgrade_from<8))
		{
			delete_config_option('logo_map');
			$GLOBALS['SITE_DB']->query('UPDATE '.$GLOBALS['SITE_DB']->get_table_prefix().'config SET the_type=\'forum\' WHERE the_name LIKE \''.db_encode_like('%_forum_name').'\'');
		}

		if (is_null($upgrade_from))
		{
			set_value('version',float_to_raw_string(ocp_version_number()));
			set_value('ocf_version',float_to_raw_string(ocp_version_number()));
	
			// Site Configuration
			//  General
				add_config_option('SITE_NAME','site_name','line','return do_lang(\'UNNAMED\');','SITE','GENERAL');
				add_config_option('SITE_SCOPE','site_scope','transline','return \'???\';','SITE','GENERAL');
				add_config_option('DESCRIPTION','description','transline','return \'\';','SITE','GENERAL');
				add_config_option('COPYRIGHT','copyright','transline','return \'Copyright &copy; \'.get_site_name().\' \'.date(\'Y\').\'\';','SITE','GENERAL');
				add_config_option('WELCOME_MESSAGE','welcome_message','transtext','return \'\';','SITE','GENERAL');
				add_config_option('MAIN_FORUM_NAME','main_forum_name','forum','return has_no_forum()?NULL:do_lang(\'DEFAULT_FORUM_TITLE\',\'\',\'\',\'\',get_site_default_lang());','FEATURE','USER_INTERACTION');
				add_config_option('KEYWORDS','keywords','line','return \'\';','SITE','GENERAL');
				
			//  Advanced
				//add_config_option('LOGO_MAP','logo_map','text','$tpl=do_template(\'IMAGE_MAP\'); return $tpl->evaluate();','SITE','ADVANCED');
				add_config_option('GZIP_OUTPUT','gzip_output','tick','return \'0\';','SITE','ADVANCED',1);
			//  Environment
				add_config_option('FORUM_IN_PORTAL','forum_in_portal','tick','return has_no_forum()?NULL:\'0\';','SITE','ENVIRONMENT',1);
				add_config_option('EMAIL','staff_address','line','return \'staff@\'.get_domain();','SITE','EMAIL');
				add_config_option('GD','is_on_gd','tick','return function_exists(\'imagetypes\')?\'1\':\'0\';','SITE','ENVIRONMENT',1);
				add_config_option('FOLDER_CREATE','is_on_folder_create','tick','return \'1\';','SITE','ENVIRONMENT',1);
			//  Closed Site
				add_config_option('CLOSED_SITE','site_closed','tick','return \''.(((substr(ocp_srv('HTTP_HOST'),0,8)=='192.168.') || (substr(ocp_srv('HTTP_HOST'),0,7)=='10.0.0.') || (in_array(ocp_srv('HTTP_HOST'),array('localhost','test.ocportal.com'))))?'0':'1').'\';','SITE','CLOSED_SITE');
				add_config_option('MESSAGE','closed','transtext','return do_lang(\'BEING_INSTALLED\');','SITE','CLOSED_SITE');
				add_config_option('MAXIMUM_USERS','maximum_users','integer','return \'100\';','SITE','CLOSED_SITE',1);
			//  Logging
				add_config_option('CC_ADDRESS','cc_address','line','return \'\';','SITE','EMAIL'); // \'staff_cc@\'.get_domain()
				add_config_option('LOG_PHP_ERRORS','log_php_errors','tick','return \'1\';','SITE','LOGGING');
				add_config_option('DISPLAY_PHP_ERRORS','display_php_errors','tick','return \'0\';','SITE','LOGGING');

			// Security/Usergroup Options
			//  Uploading
				add_config_option('FILE_TYPES','valid_types','line','return \'swf,sql,odg,odp,odt,ods,pdf,pgp,dot,doc,ppt,csv,xls,docx,pptx,xlsx,pub,txt,log,psd,tga,tif,gif,png,ico,bmp,jpg,jpeg,flv,avi,mov,3gp,mpg,mpeg,mp4,webm,asf,wmv,zip,tar,rar,gz,wav,mp3,ogg,ogv,torrent,php,css,tpl,ini,eml,patch,diff,iso,dmg\';','SECURITY','UPLOADED_FILES'); // fla,html,htm,svg,xml kept out for security reasons. NB: Can't add any more due to length limit.
				add_config_option('IMAGE_TYPES','valid_images','line','return \'jpg,jpeg,gif,png,ico\';','SECURITY','UPLOADED_FILES');

			// Feature Options
			//  User Interaction
				add_config_option('RATING','is_on_rating','tick','return \'1\';','FEATURE','USER_INTERACTION');
				add_config_option('COMMENTS','is_on_comments','tick','return has_no_forum()?NULL:\'1\';','FEATURE','USER_INTERACTION');
				add_config_option('COMMENTS_FORUM_NAME','comments_forum_name','forum','return has_no_forum()?NULL:do_lang(\'COMMENT_FORUM_NAME\',\'\',\'\',\'\',get_site_default_lang());','FEATURE','USER_INTERACTION');
				add_config_option('COMMENT_FORM_TEXT','comment_text','transtext','return has_no_forum()?NULL:static_evaluate_tempcode(do_template(\'COMMENTS_DEFAULT_TEXT\'));','FEATURE','USER_INTERACTION');
			//  Images
				add_config_option('THUMB_WIDTH','thumb_width','integer','return \'200\';','FEATURE','IMAGES');
				add_config_option('IMAGES','max_image_size','integer','return \'700\';','SITE','UPLOAD');

			add_config_option('USERS_ONLINE_TIME','users_online_time','integer','return \'5\';','SITE','LOGGING');
		}
	}
	
	/**
	 * Standard modular entry-point finder function.
	 *
	 * @return ?array	A map of entry points (type-code=>language-code) (NULL: disabled).
	 */
	function get_entry_points()
	{
		$ret=array('misc'=>'CONFIGURATION');

		$ret['base']='BASE_CONFIGURATION';

		if (addon_installed('xml_fields'))
			$ret['xml_fields']='FIELD_FILTERS';

		if (addon_installed('breadcrumbs'))
			$ret['xml_breadcrumbs']='BREADCRUMB_OVERRIDES';

		if (is_null(get_value('brand_base_url')))
			$ret['upgrader']='FU_UPGRADER_TITLE';

		if (addon_installed('syndication'))
			$ret['backend']='FEEDS';

		if (addon_installed('code_editor'))
			$ret['code_editor']='CODE_EDITOR';

		return $ret;
	}

	/**
	 * Standard modular run function.
	 *
	 * @return tempcode	The result of execution.
	 */
	function run()
	{
		require_all_lang();
		require_code('config2');

		$val=ini_get('suhosin.post.max_vars');
		if ((is_string($val)) && ($val!='') && (intval($val)<400))
		{
			attach_message(do_lang_tempcode('LOW_SUHOSIN_SETTING'),'warn');
		}

		$type=get_param('type','misc');
	
		if ($type=='base') return $this->base();
		if ($type=='misc') return $this->config_choose();
		if ($type=='category') return $this->config_category();
		if ($type=='set') return $this->config_set();
		if (addon_installed('xml_fields'))
		{
			if ($type=='xml_fields') return $this->xml_fields();
			if ($type=='_xml_fields') return $this->_xml_fields();
		}
		if (addon_installed('breadcrumbs'))
		{
			if ($type=='xml_breadcrumbs') return $this->xml_breadcrumbs();
			if ($type=='_xml_breadcrumbs') return $this->_xml_breadcrumbs();
		}

		if (is_null(get_value('brand_base_url')))
			if ($type=='upgrader') return $this->upgrader();
		if (addon_installed('syndication'))
			if ($type=='backend') return $this->backend();
		if (addon_installed('code_editor'))
			if ($type=='code_editor') return $this->code_editor();

		return new ocp_tempcode();
	}

	/**
	 * Redirect to the config_editor script.
	 *
	 * @return tempcode		The UI
	 */
	function base()
	{
		$title=get_page_title('CONFIGURATION');
		require_code('site2');
		assign_refresh(get_base_url().'/config_editor.php',0.0);
		return do_template('REDIRECT_SCREEN',array('URL'=>get_base_url().'/config_editor.php','TITLE'=>$title,'TEXT'=>do_lang_tempcode('REDIRECTING')));
	}

	/**
	 * Redirect to the upgrader script.
	 *
	 * @return tempcode		The UI
	 */
	function upgrader()
	{
		$title=get_page_title('FU_UPGRADER_TITLE');
		require_code('site2');
		assign_refresh(get_base_url().'/upgrader.php',0.0);
		return do_template('REDIRECT_SCREEN',array('URL'=>get_base_url().'/upgrader.php','TITLE'=>$title,'TEXT'=>do_lang_tempcode('REDIRECTING')));
	}

	/**
	 * Redirect to the backend script.
	 *
	 * @return tempcode		The UI
	 */
	function backend()
	{
		$title=get_page_title('FEEDS');
		require_code('site2');
		assign_refresh(get_base_url().'/backend.php',0.0);
		return do_template('REDIRECT_SCREEN',array('URL'=>get_base_url().'/backend.php','TITLE'=>$title,'TEXT'=>do_lang_tempcode('REDIRECTING')));
	}

	/**
	 * Redirect to the code_editor script.
	 *
	 * @return tempcode		The UI
	 */
	function code_editor()
	{
		$title=get_page_title('CODE_EDITOR');
		require_code('site2');
		assign_refresh(get_base_url().'/code_editor.php',0.0);
		return do_template('REDIRECT_SCREEN',array('URL'=>get_base_url().'/code_editor.php','TITLE'=>$title,'TEXT'=>do_lang_tempcode('REDIRECTING')));
	}

	/**
	 * The UI to choose what configuration page to edit.
	 *
	 * @return tempcode		The UI
	 */
	function config_choose()
	{
		$GLOBALS['HELPER_PANEL_PIC']='pagepics/config';
		$GLOBALS['HELPER_PANEL_TUTORIAL']='tut_adv_configuration';

		$title=get_page_title('CONFIGURATION');
		
		$rows=$GLOBALS['SITE_DB']->query_select('config',array('the_page','COUNT(*) AS cnt'),NULL,'GROUP BY the_page ORDER BY the_page');
		$content=new ocp_tempcode();
		foreach ($rows as $myrow)
		{
			$url=build_url(array('page'=>'_SELF','type'=>'category','id'=>$myrow['the_page']),'_SELF');
			$_name=do_lang('CONFIG_CATEGORY_'.$myrow['the_page'],NULL,NULL,NULL,NULL,false);
			if (is_null($_name)) continue;
			$name=do_lang_tempcode('CONFIG_CATEGORY_'.$myrow['the_page']);
//			if ($name->evaluate()=='') @exit($myrow['the_page']);

			$count=do_lang_tempcode('CATEGORY_SUBORDINATE_2',escape_html(integer_format($myrow['cnt'])));

			$content->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY',array('_GUID'=>'6ba2b09432d06e7502c71e7aac2d3527','COUNT'=>$count,'TITLE'=>do_lang_tempcode('CONFIGURATION'),'URL'=>$url,'NAME'=>$name,'DESCRIPTION'=>do_lang_tempcode('CONFIG_CATEGORY_DESCRIPTION__'.$myrow['the_page']))));
		}
		$content->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY',array('COUNT'=>NULL,'TITLE'=>do_lang_tempcode('CONFIGURATION'),'URL'=>get_base_url().'/config_editor.php','NAME'=>do_lang_tempcode('BASE_CONFIGURATION'),'DESCRIPTION'=>do_lang_tempcode('DOC_BASE_CONFIGURATION'))));

		return do_template('INDEX_SCREEN_FANCIER_SCREEN',array('_GUID'=>'c8fdb2b481625d58b0b228c897fda72f','PRE'=>paragraph(do_lang_tempcode('CHOOSE_A_CONFIG_CATEGORY')),'POST'=>'','TITLE'=>$title,'CONTENT'=>$content));
	}
	
	/**
	 * The UI to edit a configuration page.
	 *
	 * @return tempcode		The UI
	 */
	function config_category()
	{
		require_javascript('javascript_validation');

		/*$GLOBALS['HELPER_PANEL_PIC']='pagepics/config';
		$GLOBALS['HELPER_PANEL_TUTORIAL']='tut_adv_configuration';*/

		$page=get_param('id');
		$title=get_page_title(do_lang_tempcode('CONFIG_CATEGORY_'.$page),false);
		$post_url=build_url(array('page'=>'_SELF','type'=>'set','id'=>$page,'redirect'=>get_param('redirect',NULL)),'_SELF');

		$category_description=do_lang_tempcode('CONFIG_CATEGORY_DESCRIPTION__'.$page);

		$rows=$GLOBALS['SITE_DB']->query_select('config',array('*'),array('the_page'=>$page));

		// Addin special ones
		if ($page=='SITE') $rows[]=array('the_name'=>'timezone','human_name'=>'TIME_ZONE','config_value'=>'','the_type'=>'special','eval'=>'','the_page'=>'SITE','section'=>'GENERAL','explanation'=>'','shared_hosting_restricted'=>0);

		/*global $M_SORT_KEY;	This is a lame sort - it doesn't preserve internal order
		$M_SORT_KEY='section';
		usort($rows,'multi_sort');*/
		// Better sort
		$all_known_groups=array();
		foreach ($rows as $myrow)
		{
			$_group=do_lang($myrow['section'],NULL,NULL,NULL,NULL,false);
			if (is_null($_group)) $_group=$myrow['section'];
			$_group=strtolower(trim(preg_replace('#(&.*;)|[^\w\d\s]#U','',$_group)));
			if ((array_key_exists($_group,$all_known_groups)) && ($all_known_groups[$_group]!=$myrow['section'])) $_group='std_'.$myrow['section']; // If cat names translate to same things or are in non-latin characters like Cyrillic
			$all_known_groups[$_group]=$myrow['section'];
		}
		$old_rows=$rows;
		$rows=array();
		ksort($all_known_groups);
		foreach ($all_known_groups as $group_codename)
		{
			foreach ($old_rows as $myrow)
			{
				if ($myrow['section']==$group_codename) $rows[]=$myrow;
			}
		}

		// Move advanced group options to the end
		$rows2=array();
		foreach ($rows as $i=>$row)
		{
			if ($row['section']=='ADVANCED')
			{
				$rows2[]=$row;
				unset($rows[$i]);
			}
		}
		$rows=array_merge($rows,$rows2);

		// UI hooks
		$ui_hooks=find_all_hooks('modules','admin_config');

		$upload_max_filesize=(ini_get('upload_max_filesize')=='0')?do_lang('NA'):clean_file_size(php_return_bytes(ini_get('upload_max_filesize')));
		$post_max_size=(ini_get('post_max_size')=='0')?do_lang('NA'):clean_file_size(php_return_bytes(ini_get('post_max_size')));

		$groups=new ocp_tempcode();
		
		require_code('form_templates');
		$current_group='';
		$out='';
		$_groups=array();
		foreach ($rows as $myrow)
		{
			if (($myrow['eval']!='') && ($myrow['the_name']!='detect_lang_forum')/*HACKHACK: works around old bug - once we have hook config it'll fix this*/)
			{
				if (defined('HIPHOP_PHP'))
				{
					require_code('hooks/systems/config_default/'.$myrow['the_name']);
					$hook=object_factory('Hook_config_default_'.$myrow['the_name']);
					if (is_null($hook->get_default())) continue;
				} else
				{
					if (is_null(@eval($myrow['eval'].';'))) continue; // @'d in case default is corrupt, don't want it to give errors forever
				}
			}

			$_group=do_lang($myrow['section'],NULL,NULL,NULL,NULL,false);
			$name=do_lang($myrow['human_name'],NULL,NULL,NULL,NULL,false);
			$_group_tempcode=is_null($_group)?make_string_tempcode($myrow['section']):do_lang_tempcode($myrow['section']);
			$name_tempcode=is_null($name)?make_string_tempcode($myrow['human_name']):do_lang_tempcode($myrow['human_name']);
			if ((get_forum_type()=='ocf') && ($myrow['explanation']=='CONFIG_OPTION_forum_in_portal'))
			{
				$exp_string=$myrow['explanation'].'__ocf';
			} else
			{
				$exp_string=$myrow['explanation'];
			}
			$_explanation=do_lang($exp_string,NULL,NULL,NULL,NULL,false);
			if (is_null($_explanation))
			{
				$_explanation=do_lang('CONFIG_GROUP_DEFAULT_DESCRIP_'.$myrow['section'],NULL,NULL,NULL,NULL,false);
				if (is_null($_explanation))
				{
					$explanation=new ocp_tempcode();
				} else
				{
					$explanation=do_lang_tempcode('CONFIG_GROUP_DEFAULT_DESCRIP_'.$myrow['section']);
				}
			} else
			{
				$explanation=do_lang_tempcode($exp_string);
			}

			if (($myrow['shared_hosting_restricted']==1) && (!is_null($GLOBALS['CURRENT_SHARE_USER']))) continue;

			if (($myrow['section']!=$current_group) && ($current_group!=''))
			{
				$_current_group=do_lang_tempcode($current_group);
				$_group_description=do_lang('CONFIG_GROUP_DESCRIP_'.$current_group,escape_html($post_max_size),escape_html($upload_max_filesize),NULL,NULL,false);
				if (is_null($_group_description))
				{
					$group_description=new ocp_tempcode();
				} else
				{
					$group_description=do_lang_tempcode('CONFIG_GROUP_DESCRIP_'.$current_group,escape_html($post_max_size),escape_html($upload_max_filesize));
				}
				$group=do_template('CONFIG_GROUP',array('_GUID'=>'af4c31daa1bc39714ab83b11bd6d3e51','GROUP_DESCRIPTION'=>$group_description,'GROUP_NAME'=>$current_group,'GROUP'=>$out,'CURRENT_GROUP'=>$_current_group));
				$groups->attach($group->evaluate());
				$out='';
			}

			$_groups[$myrow['section']]=$_group_tempcode;

			switch ($myrow['the_type'])
			{
				case 'special':
					switch($myrow['the_name'])
					{
						case 'timezone':
							$list='';
							$timezone=get_site_timezone();
							foreach (get_timezone_list() as $_timezone=>$timezone_nice)
							{
								$list.=static_evaluate_tempcode(form_input_list_entry($_timezone,$_timezone==$timezone,$timezone_nice));
							}
							$out.=static_evaluate_tempcode(form_input_list(do_lang_tempcode('TIME_ZONE'),do_lang_tempcode('DESCRIPTION_TIMEZONE_SITE'),'timezone',make_string_tempcode($list)));
							break;

						default:
							require_code('hooks/modules/admin_config/'.filter_naughty_harsh($myrow['the_name']));
							$hook_ob=object_factory('Hook_admin_config_'.filter_naughty_harsh($myrow['the_name']));
							$out.=static_evaluate_tempcode($hook_ob->run($myrow));
							break;
					}
					break;

				case 'integer':
					$out.=static_evaluate_tempcode(form_input_integer($name_tempcode,$explanation,$myrow['the_name'],intval(get_option($myrow['the_name'])),false));
					break;
				case 'line':
					if ((strpos($myrow['the_name'],'colour')!==false) && (substr(get_option($myrow['the_name']),0,1)=='#'))
					{
						$out.=static_evaluate_tempcode(form_input_colour($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name']),false,NULL,true));
					}
					elseif ($myrow['the_name']=='currency')
					{
						$list='';
						require_code('currency');
						$currencies=array_keys(get_currency_map());
						foreach ($currencies as $currency)
						{
							$list.=static_evaluate_tempcode(form_input_list_entry($currency,$currency==get_option($myrow['the_name'])));
						}
						$out.=static_evaluate_tempcode(form_input_list($name_tempcode,$explanation,$myrow['the_name'],make_string_tempcode($list)));
					}
					elseif ($myrow['the_name']=='payment_gateway')
					{
						$list='';
						$all_via=find_all_hooks('systems','ecommerce_via');
						foreach (array_keys($all_via) as $via)
						{
							$list.=static_evaluate_tempcode(form_input_list_entry($via,$via==get_option($myrow['the_name'])));
						}
						$out.=static_evaluate_tempcode(form_input_list($name_tempcode,$explanation,$myrow['the_name'],make_string_tempcode($list)));
					} else
					{
					/*if (strpos($myrow['the_name'],'password')!==false)  password fields can't take defaults
						$out.=static_evaluate_tempcode(form_input_password($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name']),false));
					else
						*/$out.=static_evaluate_tempcode(form_input_line($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name']),false));
					}
					break;
				case 'list':
					$list='';
					$_value=get_option($myrow['the_name']);
					$values=explode('|',$myrow['c_data']);
					foreach ($values as $value)
					{
						$_option_text=do_lang('CONFIG_OPTION_'.$myrow['the_name'].'_VALUE_'.$value,NULL,NULL,NULL,NULL,false);
						if (!is_null($_option_text))
						{
							$option_text=do_lang_tempcode('CONFIG_OPTION_'.$myrow['the_name'].'_VALUE_'.$value);
						} else
						{
							$option_text=make_string_tempcode($value);
						}
						$list.=static_evaluate_tempcode(form_input_list_entry($value,$_value==$value,$option_text));
					}
					$out.=static_evaluate_tempcode(form_input_list($name_tempcode,$explanation,$myrow['the_name'],make_string_tempcode($list),NULL,false,false));
					break;
				case 'transline':
					$out.=static_evaluate_tempcode(form_input_line($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name']),false));
					break;
				case 'text':
					$out.=static_evaluate_tempcode(form_input_text($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name']),false,NULL,true));
					break;
				case 'transtext':
					$out.=static_evaluate_tempcode(form_input_text($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name']),false,NULL,true));
					break;
				case 'float':
					$out.=static_evaluate_tempcode(form_input_float($name_tempcode,$explanation,$myrow['the_name'],floatval(get_option($myrow['the_name'])),false));
					break;
				case 'tick':
					$out.=static_evaluate_tempcode(form_input_tick($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name'])=='1'));
					break;
				case 'date':
					$out.=static_evaluate_tempcode(form_input_date($name_tempcode,$explanation,$myrow['the_name'],false,false,false,intval(get_option($myrow['the_name'])),40,intval(date('Y'))-20,NULL,false));
					break;
				case 'forum':
				case '?forum':
					if ((get_forum_type()=='ocf') && (addon_installed('ocf_forum')))
					{
						$current_setting=get_option($myrow['the_name']);
						if (!is_numeric($current_setting))
						{
							$_current_setting=$GLOBALS['FORUM_DB']->query_value_null_ok('f_forums','id',array('f_name'=>$current_setting));
							if (is_null($_current_setting))
							{
								if ($myrow['the_type']=='?forum')
								{
									$current_setting=NULL;
								} else
								{
									$current_setting=strval(db_get_first_id());
									attach_message(do_lang_tempcode('FORUM_CURRENTLY_UNSET',$name_tempcode),'warn');
								}
							} else
							{
								$current_setting=strval($_current_setting);
							}
						}
						$out.=static_evaluate_tempcode(form_input_tree_list($name_tempcode,$explanation,$myrow['the_name'],NULL,'choose_forum',array(),false,$current_setting));
					} else
					{
						$out.=static_evaluate_tempcode(form_input_line($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name']),false));
					}
					break;
				case 'category':
					if (get_forum_type()=='ocf')
					{
						$tmp_value=$GLOBALS['FORUM_DB']->query_value_null_ok('f_categories','id',array('c_title'=>get_option($myrow['the_name'])));

						require_code('ocf_forums2');
						$_list=ocf_nice_get_categories(NULL,$tmp_value);
						$out.=static_evaluate_tempcode(form_input_list($name_tempcode,$explanation,$myrow['the_name'],$_list));
					} else
					{
						$out.=static_evaluate_tempcode(form_input_line($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name']),false));
					}
					break;
				case 'usergroup':
					if (get_forum_type()=='ocf')
					{
						$tmp_value=$GLOBALS['FORUM_DB']->query_value_null_ok('f_groups g LEFT JOIN '.$GLOBALS['FORUM_DB']->get_table_prefix().'translate t ON t.id=g.g_name','g.id',array('text_original'=>get_option($myrow['the_name'])));

						require_code('ocf_groups');
						$_list=ocf_nice_get_usergroups($tmp_value);
						$out.=static_evaluate_tempcode(form_input_list($name_tempcode,$explanation,$myrow['the_name'],$_list));
					} else
					{
						$out.=static_evaluate_tempcode(form_input_line($name_tempcode,$explanation,$myrow['the_name'],get_option($myrow['the_name']),false));
					}
					break;
			}

			$current_group=$myrow['section'];
		}
		if ($out!='')
		{
			$_group_description=do_lang('CONFIG_GROUP_DESCRIP_'.$current_group,escape_html($post_max_size),escape_html($upload_max_filesize),NULL,NULL,false);
			if (is_null($_group_description))
			{
				$group_description=new ocp_tempcode();
			} else
			{
				$group_description=do_lang_tempcode('CONFIG_GROUP_DESCRIP_'.$current_group,escape_html($post_max_size),escape_html($upload_max_filesize));
			}
			$group=do_template('CONFIG_GROUP',array('_GUID'=>'84c0db86002a33a383a7c2e195dd3913','GROUP_DESCRIPTION'=>$group_description,'GROUP_NAME'=>$current_group,'GROUP'=>$out,'CURRENT_GROUP'=>$_group_tempcode));
			$groups->attach($group->evaluate());
		}

		list($warning_details,$ping_url)=handle_conflict_resolution();

		breadcrumb_set_parents(array(array('_SELF:_SELF:misc',do_lang_tempcode('CONFIGURATION'))));
		breadcrumb_set_self(do_lang_tempcode('CONFIG_CATEGORY_'.$page));

		return do_template('CONFIG_CATEGORY_SCREEN',array('_GUID'=>'d01b28b71c38bbb52b6aaf877c7f7b0e','CATEGORY_DESCRIPTION'=>$category_description,'_GROUPS'=>$_groups,'PING_URL'=>$ping_url,'WARNING_DETAILS'=>$warning_details,'TITLE'=>$title,'URL'=>$post_url,'GROUPS'=>$groups,'SUBMIT_NAME'=>do_lang_tempcode('SAVE')));
	}

	/**
	 * The actualiser to edit a configuration page.
	 *
	 * @return tempcode		The UI
	 */
	function config_set()
	{
		$page=get_param('id','MAIN');
		$title=get_page_title(do_lang_tempcode('CONFIG_CATEGORY_'.$page),false);

		// Make sure we haven't locked ourselves out due to clean URL support
		if ((post_param_integer('mod_rewrite',0)==1) && (substr(ocp_srv('SERVER_SOFTWARE'),0,6)=='Apache') && ((!file_exists(get_file_base().'/.htaccess')) || (strpos(file_get_contents(get_file_base().'/.htaccess'),'RewriteEngine on')===false)))
		{
			warn_exit(do_lang_tempcode('BEFORE_MOD_REWRITE'));
		}
	
		// Make sure we haven't just locked staff out
		$new_site_name=substr(post_param('site_name',''),0,200);
		if (($new_site_name!='') && (get_option('is_on_sync_staff',true)==='1'))
		{
			$admin_groups=array_merge($GLOBALS['FORUM_DRIVER']->get_super_admin_groups(),$GLOBALS['FORUM_DRIVER']->get_moderator_groups());
			$staff=$GLOBALS['FORUM_DRIVER']->member_group_query($admin_groups,100);
			if (count($staff)<100)
			{
				foreach ($staff as $row_staff)
				{
					$member=$GLOBALS['FORUM_DRIVER']->pname_id($row_staff);
					if ($GLOBALS['FORUM_DRIVER']->is_staff($member))
					{
						$sites=get_ocp_cpf('sites');
						$sites=str_replace(', '.get_site_name(),'',$sites);
						$sites=str_replace(','.get_site_name(),'',$sites);
						$sites=str_replace(get_site_name().', ','',$sites);
						$sites=str_replace(get_site_name().',','',$sites);
						$sites=str_replace(get_site_name(),'',$sites);
						if ($sites!='') $sites.=', ';
						$sites.=$new_site_name;
						$GLOBALS['FORUM_DRIVER']->set_custom_field($member,'sites',$sites);
					}
				}
			}
		}
		
		// Empty thumbnail cache if needed
		if ((get_option('is_on_gd')=='1') && (function_exists('imagetypes')))
		{
			if ((!is_null(post_param('thumb_width',NULL))) && (post_param('thumb_width')!=get_option('thumb_width')))
			{
				$thumb_fields=$GLOBALS['SITE_DB']->query('SELECT m_name,m_table FROM '.$GLOBALS['SITE_DB']->get_table_prefix().'db_meta WHERE m_name LIKE \''.db_encode_like('%thumb_url').'\'');
				$GLOBALS['NO_DB_SCOPE_CHECK']=true;
				foreach ($thumb_fields as $field)
				{
					if ($field['m_table']=='videos') continue;
				
					$GLOBALS['SITE_DB']->query_update($field['m_table'],array($field['m_name']=>''));
				}
				$GLOBALS['NO_DB_SCOPE_CHECK']=false;
			}
		}

		$rows=$GLOBALS['SITE_DB']->query_select('config',array('*'),array('the_page'=>$page));
		if ($page=='SITE') $rows[]=array('the_name'=>'timezone','shared_hosting_restricted'=>0,'the_type'=>'special','eval'=>'');
		foreach ($rows as $myrow)
		{
         if ($myrow['eval']!='')
         {
				if (defined('HIPHOP_PHP'))
				{
					require_code('hooks/systems/config_default/'.$myrow['the_name']);
					$hook=object_factory('Hook_config_default_'.$myrow['the_name']);
					if (is_null($hook->get_default())) continue;
				} else
				{
					if (is_null(@eval($myrow['eval'].';'))) continue; // @'d in case default is corrupt, don't want it to give errors forever
				}
			}

			if (($myrow['shared_hosting_restricted']==1) && (!is_null($GLOBALS['CURRENT_SHARE_USER']))) continue;

			if ($myrow['the_type']=='tick')
			{
				$value=strval(post_param_integer($myrow['the_name'],0));
			}
			elseif ($myrow['the_type']=='date')
			{
				$date_value=get_input_date($myrow['the_name']);
				$value=is_null($date_value)?'':strval($date_value);
			}
			elseif ((($myrow['the_type']=='forum') || ($myrow['the_type']=='?forum')) && (get_forum_type()=='ocf'))
			{
				$value=post_param($myrow['the_name']);
				if (is_numeric($value))
					$value=$GLOBALS['FORUM_DB']->query_value_null_ok('f_forums','f_name',array('id'=>post_param_integer($myrow['the_name'])));
				if (is_null($value)) $value='';
			}
			elseif (($myrow['the_type']=='category') && (get_forum_type()=='ocf'))
			{
				$value=post_param($myrow['the_name']);
				if (is_numeric($value))
					$value=$GLOBALS['FORUM_DB']->query_value_null_ok('f_categories','c_title',array('id'=>post_param_integer($myrow['the_name'])));
				if (is_null($value)) $value='';
			}
			elseif (($myrow['the_type']=='usergroup') && (get_forum_type()=='ocf'))
			{
				$value=$GLOBALS['FORUM_DB']->query_value_null_ok('f_groups g LEFT JOIN '.$GLOBALS['FORUM_DB']->get_table_prefix().'translate t ON t.id=g.g_name','text_original',array('g.id'=>post_param_integer($myrow['the_name'])));
				if (is_null($value)) $value='';
			} else
			{
				$value=post_param($myrow['the_name'],'');
			}

			if ($myrow['the_type']=='special')
			{
				if ($myrow['the_name']=='timezone')
				{
					set_value('timezone',$value);
				}
			}
			elseif ($myrow['c_set']==1)
			{
				if ((($myrow['the_type']=='transline') || ($myrow['the_type']=='transtext')) && (is_numeric($myrow['config_value'])))
				{
					$old_value=get_translated_text(intval($myrow['config_value']));
				} else $old_value=$myrow['config_value'];

				// If the option was changed
				if ($old_value!=$value)
				{
					set_option($myrow['the_name'],$value,$myrow['the_type'],$myrow['config_value']);
				}
			} else
			{
				if (($myrow['the_type']=='transline') || ($myrow['the_type']=='transtext'))
				{
					$_value=strval(insert_lang($value,1));
				} else $_value=$value;
				$GLOBALS['SITE_DB']->query_update('config',array('config_value'=>$_value,'c_set'=>1),array('the_name'=>$myrow['the_name']),'',1);
			}
		}

		// Clear some cacheing
		require_code('view_modes');
		require_code('zones2');
		require_code('zones3');
		erase_comcode_page_cache();
		erase_tempcode_cache();
		//persistant_cache_delete('OPTIONS');  Done by set_option
		persistant_cache_empty();
		erase_cached_templates();

		// Show it worked / Refresh
		$redirect=get_param('redirect',NULL);
		if ($redirect===NULL)
		{
			$url=build_url(array('page'=>'_SELF','type'=>'misc'),'_SELF'); // ,'type'=>'category','id'=>$page
		} else
		{
			$url=make_string_tempcode($redirect);
		}
		return redirect_screen($title,$url,do_lang_tempcode('SUCCESS'));
	}

	/**
	 * The UI to edit the fields XML file.
	 *
	 * @return tempcode		The UI
	 */
	function xml_fields()
	{
		$GLOBALS['HELPER_PANEL_TUTORIAL']='tut_fields_filter';
		$GLOBALS['HELPER_PANEL_TEXT']=comcode_lang_string('DOC_FIELD_FILTERS');

		$title=get_page_title('FIELD_FILTERS');

		$post_url=build_url(array('page'=>'_SELF','type'=>'_xml_fields'),'_SELF');

		return do_template('XML_CONFIG_SCREEN',array('TITLE'=>$title,'POST_URL'=>$post_url,'XML'=>file_exists(get_custom_file_base().'/data_custom/fields.xml')?file_get_contents(get_custom_file_base().'/data_custom/fields.xml'):''));
	}

	/**
	 * The UI actualiser edit the fields XML file.
	 *
	 * @return tempcode		The UI
	 */
	function _xml_fields()
	{
		$title=get_page_title('FIELD_FILTERS');

		$myfile=@fopen(get_custom_file_base().'/data_custom/fields.xml','wt');
		if ($myfile===false) intelligent_write_error(get_custom_file_base().'/data_custom/fields.xml');
		$xml=post_param('xml');
		if (fwrite($myfile,$xml)<strlen($xml)) warn_exit(do_lang_tempcode('COULD_NOT_SAVE_FILE'));
		fclose($myfile);
		fix_permissions(get_custom_file_base().'/data_custom/fields.xml');
		sync_file(get_custom_file_base().'/data_custom/fields.xml');

		return inform_screen($title,do_lang_tempcode('SUCCESS'));
	}

	/**
	 * The UI to edit the breadcrumbs XML file.
	 *
	 * @return tempcode		The UI
	 */
	function xml_breadcrumbs()
	{
		$GLOBALS['HELPER_PANEL_TUTORIAL']='tut_structure';
		$GLOBALS['HELPER_PANEL_TEXT']=comcode_lang_string('DOC_BREADCRUMB_OVERRIDES');

		$title=get_page_title('BREADCRUMB_OVERRIDES');

		$post_url=build_url(array('page'=>'_SELF','type'=>'_xml_breadcrumbs'),'_SELF');

		return do_template('XML_CONFIG_SCREEN',array('TITLE'=>$title,'POST_URL'=>$post_url,'XML'=>file_exists(get_custom_file_base().'/data_custom/breadcrumbs.xml')?file_get_contents(get_custom_file_base().'/data_custom/breadcrumbs.xml'):''));
	}

	/**
	 * The UI actualiser edit the breadcrumbs XML file.
	 *
	 * @return tempcode		The UI
	 */
	function _xml_breadcrumbs()
	{
		$title=get_page_title('BREADCRUMB_OVERRIDES');

		$myfile=@fopen(get_custom_file_base().'/data_custom/breadcrumbs.xml','wt');
		if ($myfile===false) intelligent_write_error(get_custom_file_base().'/data_custom/breadcrumbs.xml');
		$xml=post_param('xml');
		if (fwrite($myfile,$xml)<strlen($xml)) warn_exit(do_lang_tempcode('COULD_NOT_SAVE_FILE'));
		fclose($myfile);
		fix_permissions(get_custom_file_base().'/data_custom/breadcrumbs.xml');
		sync_file(get_custom_file_base().'/data_custom/breadcrumbs.xml');

		return inform_screen($title,do_lang_tempcode('SUCCESS'));
	}

}


