<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		ecommerce
 */

require_code('amazon_payment/FPSApis/src/Amazon/FPS/ocp_amazon/payment_amazon');

class Hook_amazon
{
	/**
	* Get some title/description about payment method
	*
	* @return SHORT_TEXT		Title/Description about paypal
	*/
	function info()
	{
		return do_lang('AMAZON_DESCRIPTION');
	}

	/**
	 * Function to install amazon config options
	 */
	function install_config()
	{
		add_config_option('AMAZON_ENABLE','amazon_enable','special_group__tick_control__amazon__tick','return \'0\';','ECOMMERCE','PAYMENT_GATEWAY');
		add_config_option('AMAZON_PAYMENT_ACCESS_KEY','amazon_access_key','special_group__tick_control__amazon__line','return \'\';','ECOMMERCE','PAYMENT_GATEWAY');
		add_config_option('AMAZON_PAYMENT_SECRET_KEY','amazon_secret_key','special_group__tick_control__amazon__line','return \'\';','ECOMMERCE','PAYMENT_GATEWAY');
	}

	/**
	 * Function to unistall amazon config options
	 */
	function uninstall_config()
	{
		delete_config_option('amazon_access_key');
		delete_config_option('amazon_secret_key');
		delete_config_option('amazon_enable');
	}

	/**
	* Get logos/verified seal of payment method
	*
	* @return tempcode	Logo/verified sign
	*/
	function get_confidence_logos()
	{
		require_css('ecommerce');
		$logo	=	'<a href="https://payments.amazon.com"><img border="0" alt="" src="https://payments.amazon.com/img/AP-HLogo-215x35.jpg" width="100px"/></a>';

		$read_text_link	=	build_url(array('page'=>'purchase','type'=>'payment_note','screen'=>'secure_payment_amazon','wide_high'=>1),get_module_zone('purchase'));

		$read_text_link	=	$read_text_link->evaluate();

		$js	=	"function secure_shopping_notes() {
                	window.open('$read_text_link','ruleswindow','menubar=1,resizable=1,scrollbars=1,width=970,height=650');
                  return false;
               }";
		return do_template('VERIFIED_MERCHANT_LOGO_SCREEN',array('LOGO'=>$logo,'READ_TEXT_LINK'=>$read_text_link,'JAVASCRIPT'=>$js,'PAYMENT_TEXT_URL'=>'site:secure_payment_authorize'));
	}

	/**
	 * Find the payment gateway enabled or not
	 *
	 * @return BINARY		Enabled/Disabled
	 */
	function is_enabled()
	{
		return get_option('amazon_enable');
	}

	/**
	 * Get the amazon payment address.
	 *
	 * @return array	Array of payment address details
	 */
	function _get_payment_address($seller=NULL)
	{
		$site_amazon_key		=	get_option('amazon_access_key');
		$site_amazon_secret	=	get_option('amazon_secret_key');
		$recipient_email		=	get_ocp_cpf('recipient_email',$seller);
		return	array('amazon_access_key'=>$site_amazon_key,'amazon_secret_key'=>$site_amazon_secret,'recipient_email'=>$recipient_email);
	}

	/**
	 * Create transaction button for amazon payments
	 *
	 * @return array	A long tuple of collected data.
	 */
	function make_transaction_button($product,$item_name,$purchase_id,$amount,$currency,$seller=NULL)
	{
		$payment_address	=	$this->_get_payment_address($seller);
		$amz_pyt				=	new payment_amazon();
		return $amz_pyt->make_transaction_button($product,$item_name,$purchase_id,$amount,$currency,$payment_address);
	}

	/**
	 * Create transaction button for amazon payments
	 *
	 * @return array	A long tuple of collected data.
	 */
	function make_subscription_button($product,$item_name,$purchase_id,$amount,$length,$length_units,$currency)
	{
		$amz_pyt	=	new payment_amazon();
		return $amz_pyt->make_subscription_button($product,$item_name,$purchase_id,$amount,$length,$length_units,$currency);
	}

	/**
	 * Handle IPN's. The function may produce output, which would be returned to the Payment Gateway. The function may do transaction verification.
	 *
	 * @return array	A long tuple of collected data.
	 */
	function handle_transaction()
	{
		$amz_pyt	=	new payment_amazon();
		if((!is_null(get_param('transactionId',NULL))) && $amz_pyt->validate_return_url())
		{
			if ((file_exists(get_file_base().'/data_custom/ecommerce.log')) && (is_writable_wrap(get_file_base().'/data_custom/ecommerce.log')))
			{
				$myfile=fopen(get_file_base().'/data_custom/ecommerce.log','at');
				fwrite($myfile,serialize($_GET));
				fclose($myfile);
			}
		}

		$purchase_id	=	either_param_integer('referenceId','-1');
		$txn_id			=	either_param('transactionId',NULL);

		//Get transaction status using AWS api
		//***********************************************************************/
		$get_transaction_status_result	=	(!is_null($txn_id))?$amz_pyt->get_transaction_status($txn_id,$purchase_id):NULL;

		// assign posted variables to local variables
		if(!is_null(either_param('subscriptionId',NULL)))
			$item_name		=	find_item_name_of_subscription($purchase_id);
		else
			$item_name		=	find_item_name_of_order($purchase_id);

		if(is_object($get_transaction_status_result))
			$payment_status=$get_transaction_status_result->getTransactionStatus(); // May be blank for subscription
		else
			$payment_status='';

		$reason_code=either_param('paymentReason','');	//Dont have pending reason code, just set paymentReason for passing
		$pending_reason=either_param('pending_reason','');
		$memo=either_param('memo','');
		$mc_gross=either_param('transactionAmount',''); // May be blank for subscription
		$mc_currency=get_option('currency');		//	Currency is not coming in seperate value, but validation is doing by api. Here just added syste currency for passing to handle transaction
		$parent_txn_id=either_param('parent_txn_id','-1'); //Paypal's need checking
		$receiver_email=either_param('recipientEmail');

		//subscription type doing... -----------------------------------
		$txn_status		=	either_param('status');
		if($payment_status=='Success')	$payment_status='Completed';	//'Completed' text is checking in handle transaction confirmation
		if ($txn_status=='SS')	//Subscription started
		{
			$payment_status='Completed';
			$mc_gross	=	either_param('transactionAmount');
			$txn_id		=	either_param('subscriptionId');
		}
		elseif ($txn_status=='SC')	//Need to check return status for sub. cancel
		{
			$payment_status	=	'SCancelled';
			$txn_id				=	either_param('subscriptionId').'-c';
		}

		if(addon_installed('shopping'))
		{
			$this->store_shipping_address($purchase_id);
		}

		if(!$amz_pyt->validate_ipn() && get_option('ecommerce_test_mode')!="1")//mark pending if ipn is invalid and system not in test mode
		{
			$payment_status	=	'pending';	//Need to get IPN to confirm payment, till then status is marked as pending
			attach_message(do_lang_tempcode('TRANSACTION_COMPLETED_NEED_IPN_VERIFICATION'));
		}

		return array($purchase_id,$item_name,$payment_status,$reason_code,$pending_reason,$memo,$mc_gross,$mc_currency,$txn_id,$parent_txn_id);
	}

	/**
	 * Store shipping address for orders
	 *
	 * @param  AUTO_LINK		Order id
	 * @return ?mixed			Address id (NULL : No address record found)
	 */
	function store_shipping_address($order_id)
	{
		if(is_null(get_param('addressName',NULL))) return;

		$shipping_address	=	array();

		if(is_null($GLOBALS['SITE_DB']->query_value_null_ok('shopping_order_addresses','id',array('order_id'=>$order_id))))
		{
			$shipping_address['order_id']			=	$order_id;
			$shipping_address['address_name']	=	get_param('addressName','');
			$shipping_address['address_street']	=	get_param('addressLine1','');
			$shipping_address['address_zip']		=	get_param('zip','');
			$shipping_address['address_city']	=	get_param('city','');
			$shipping_address['address_state']	=	get_param('state','');
			$shipping_address['address_country']=	get_param('address_country','');
			$shipping_address['receiver_email']	=	get_param('buyerEmail','');

			return $GLOBALS['SITE_DB']->query_insert('shopping_order_addresses',$shipping_address,true);
		}
	}

	/**
	 * Find whether the hook auto-cancels (if it does, auto cancel the given trans-id).
	 *
	 * @param  string		Purchase/Subscription id
	 * @return ?boolean	True: yes. False: no. (NULL: cancels via a user-URL-directioning)
	 */
	function auto_cancel($purchase_id)
	{
		$trans_id=$GLOBALS['SITE_DB']->query_value('transactions','id',array('purchase_id'=>$purchase_id));
		$amz_pyt	=	new payment_amazon();
		$temp	=	$amz_pyt->cancel_subscription_refund($trans_id,0,'Cancelled');
		return	is_object($temp);
	}
}

