<?php
/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     Amazon_FPS
 *  @copyright   Copyright 2008 Amazon Technologies, Inc.
 *  @link        http://aws.amazon.com
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2008-09-17
 */
require_once '.config.inc.php';
require_once 'SignatureUtilsForOutbound.php';
  
class ReturnUrlVerificationSampleCode {

	public static function test() {
        $utils = new SignatureUtilsForOutbound();
        
        //Parameters present in return url.
        $params["transactionId"] = $_GET["transactionId"];
        $params["transactionDate"] = $_GET["transactionDate"];
        $params["status"] = $_GET["status"];
        $params["signatureMethod"] = $_GET["signatureMethod"];
        $params["signatureVersion"] = $_GET["signatureVersion"];
        $params["buyerEmail"] = $_GET["buyerEmail"];
        $params["recipientEmail"] = $_GET["recipientEmail"];
        $params["operation"] = $_GET["operation"];
        $params["transactionAmount"] = $_GET["transactionAmount"];
        $params["referenceId"] = $_GET["referenceId"];
        $params["buyerName"] = $_GET["buyerName"];
        $params["recipientName"] = $_GET["recipientName"];
        $params["paymentMethod"] = $_GET["paymentMethod"];
        $params["paymentReason"] = $_GET["paymentReason"];
        $params["certificateUrl"] = $_GET["certificateUrl"];
        $params["signature"] = $_GET["signature"];
 
        $urlEndPoint = "http://winserv.ocproducts.biz/Manu/relay/request_receive.php"; //Your return url end point. 
        print "Verifying return url signed using signature v2 ....\n";
        //return url is sent as a http GET request and hence we specify GET as the http method.
        //Signature verification does not require your secret key
        print "Is signature correct: " . $utils->validateRequest($params, $urlEndPoint, "GET") . "\n";
	}
}

ReturnUrlVerificationSampleCode::test(); 
?>
