<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		ecommerce
 */

require_once 'ButtonGenerator.php';
 
class payment_amazon 
{
	private static $signatureMethod	=	"HmacSHA256"; 	// Valid values  are  HmacSHA256 and HmacSHA1.
	private static $immediateReturn	=	"0"; 				//Optionally, enter "1" if you want to skip the final status page in Amazon Payments
	private static $processImmediate	=	"1"; 				//Optionally, enter "1" if you want to settle the transaction immediately else "0". Default value is "1" 
	private static $collectShippingAddress		=	"1";		//Optionally, enter "1" if you want Amazon Payments to return the buyer's shipping address as part of the transaction information
	
	//Subscription-----------------------------------------------------------------------------
	private static $subscriptionPeriod 			=	NULL;	//Optionally, enter the subscription duration. By default subscription will be for an unlimited period.
	private static $RecurringStartDate 			=	null;	 //Optionally, enter the start date for the subscription. By default susbcription will be processed as soon as subscription id created 
	private static $promotionAmount 				=	NULL ; //Optionally, enter the introductory subscription price.
	private static $NoOfPromotionTransactions =	NULL;  //Required if for promotional period referenceId	
	//------------------------------------------------------------------------------------------

	//----------market place system	
	//private static $fixedMarketplaceFee 	="0.01";					//Optionally, enter the fixed market place fee
	//private static $variableMarketplaceFee = "4" ;					//Optionally, enter the variable market place fee
	//-------------------------------

	/**
	* Transaction button generator
	*
	* @param		AUTO_LINK	Product
	* @param		ID_TEXT		Item name
	* @param		AUTO_LINK	Purchase Id
	* @param		REAL			Amount
	* @param		ID_TEXT		Currency
	* @param		?array		payment address
	* @return UI	Transaction button button with form
	*/
	public static function make_transaction_button($product,$item_name,$purchase_id,$amount,$currency,$payment_address=NULL) 
	{
		try
		{
			if(is_null($payment_address))	$payment_address	=	self::get_seller_amazon_payment_keys($purchase_id);

			$payment_settings			=	self::get_payment_settings();
			
			if($payment_address['recipient_email']!='' and (!is_null($payment_address['recipient_email'])))	//Means product is from third party seller, so go to market place method
			{
				require_code('amazon_payment/FPSApis/src/Amazon/FPS/ocp_amazon/market_place_button_generator');

				$fixedMarketplaceFee		=	get_option('fixed_mp_fee');
				$variableMarketplaceFee	=	get_option('variable_mp_fee');

				return MarketplaceButtonGenerator::GenerateMarketplacePayButtonForm($payment_address['amazon_access_key'],$payment_address['amazon_secret_key'],$amount,$item_name, $purchase_id, self::$immediateReturn,$payment_settings['return_url'], $payment_settings['cancel_url'], self::$processImmediate, $payment_settings['ipn_url'], self::$collectShippingAddress,self::$signatureMethod,$payment_address['recipient_email'],$fixedMarketplaceFee,$variableMarketplaceFee, $payment_settings['environment'],$payment_settings['relay_send']);
			}
			else	//Product's owner is site, so go with normal payment method
			{
				return ButtonGenerator::GenerateForm($payment_address['amazon_access_key'],$payment_address['amazon_secret_key'],$amount, $item_name, $purchase_id, self::$immediateReturn,$payment_settings['return_url'], $payment_settings['cancel_url'], self::$processImmediate, $payment_settings['ipn_url'], self::$collectShippingAddress,self::$signatureMethod, $payment_settings['environment'],$payment_settings['relay_send']);
			}
		}
		catch(Exception $e){
			echo 'Exception : ', $e->getMessage(),"\n";
		}
	}

	/**
	* Subscription button generator
	*
	* @param		AUTO_LINK	Product
	* @param		ID_TEXT		Item name
	* @param		AUTO_LINK	Purchase Id
	* @param		REAL			Amount
	* @param		integer		Length
	* @param		integer		Length units
	* @param		ID_TEXT		Currency
	* @param		?array		payment address
	* @return UI	Subscription button with form
	*/
	public static function make_subscription_button($product,$item_name,$purchase_id,$amount,$length,$length_units,$currency)
	{
		require_code('amazon_payment/FPSApis/src/Amazon/FPS/ocp_amazon/subscription_button_generator');
		try
		{
			$payment_address	=	self::get_seller_amazon_payment_keys($purchase_id);
			$environment	=	(get_option('ecommerce_test_mode')=="1")?"sandbox":"prod";
			$recur_freq		=	array('d'=>'day','w'=>'week','m'=>'month','y'=>'years');
			$recurrance		=	$length.' '.$recur_freq[$length_units];

			$payment_settings	=	self::get_payment_settings();

			return SubscriptionButtonGenerator::GenerateForm($payment_address['amazon_access_key'],$payment_address['amazon_secret_key'],$amount, $item_name, $purchase_id, self::$immediateReturn,$payment_settings['return_url'], $payment_settings['cancel_url'],self::$processImmediate,$payment_settings['ipn_url'],self::$collectShippingAddress,self::$signatureMethod,$recurrance,self::$subscriptionPeriod,self::$RecurringStartDate,self::$promotionAmount, self::$NoOfPromotionTransactions, $environment);
		}
		catch(Exception $e){
			echo 'Exception : ', $e->getMessage(),"\n";
		}
	}

	/**
	* UI for redirect to amazon market place section to authorize third party seller
	*
	* @return UI	Market place fee authorize button
	*/
	public static function AcceptMarketplaceFeeButtonForm() 
	{
		try
		{
			require_code('amazon_payment/FPSApis/src/Amazon/FPS/ocp_amazon/market_place_button_generator');
			$environment	=	(get_option('ecommerce_test_mode')=="1")?"sandbox":"prod";

			$site_amazon_key		=	get_option('amazon_access_key');
			$site_amazon_secret	=	get_option('amazon_secret_key');

			$returnUrl				=	build_url(array('page'=>'shopping','type'=>'_mp_fee'),get_module_zone('shopping'),NULL,false,false,true);
			$returnUrl				=	$returnUrl->evaluate();	
	
			$callerReference		=	get_member();

			$fixedMarketplaceFee		=	get_option('fixed_mp_fee');
			$variableMarketplaceFee	=	get_option('variable_mp_fee');

			return MarketplaceButtonGenerator::GenerateAcceptMarketplaceFeeButtonForm($site_amazon_key,$site_amazon_secret,$returnUrl, self::$signatureMethod,$callerReference,$fixedMarketplaceFee,$variableMarketplaceFee,$environment);
		}
		catch(Exception $e){
			echo 'Exception : ', $e->getMessage(),"\n";
		}
	}

	/**
	* Validate return Url
	*
	* @return BINARY	Validation result
	*/
	public static function validate_return_url() 
	{	
		//require_code('amazon_payment/IPNAndReturnURLValidation/src/.config.inc');
		require_code('amazon_payment/IPNAndReturnURLValidation/src/SignatureUtilsForOutbound');
		
		$utils = new SignatureUtilsForOutbound();
		//Parameters present in return url.
		$params["transactionId"] 		= $_GET['transactionId'];
		$params["transactionDate"] 	= $_GET['transactionDate'];
		$params["status"] 				= $_GET['status'];
		$params["signatureMethod"] 	= $_GET['signatureMethod'];
		$params["signatureVersion"] 	= $_GET["signatureVersion"];
		$params["buyerEmail"] 			= $_GET["buyerEmail"];
		$params["recipientEmail"] 		= $_GET["recipientEmail"];
		$params["operation"] 			= $_GET["operation"];
		$params["transactionAmount"] 	= $_GET["transactionAmount"];
		$params["referenceId"]	 		= $_GET["referenceId"];
		$params["buyerName"] 			= $_GET["buyerName"];
		$params["recipientName"] 		= $_GET["recipientName"];
		$params["paymentMethod"] 		= $_GET["paymentMethod"];
		$params["paymentReason"] 		= $_GET["paymentReason"];
		$params["certificateUrl"] 		= $_GET["certificateUrl"];
		$params["signature"]				= $_GET["signature"];
		
		$det				=	self::get_payment_settings();
		$urlEndPoint	=	$det['return_url'];

		$urlEndPoint	=	get_option('relay_url_return');
		return $utils->validateRequest($params, $urlEndPoint, "GET");
	}

	/**
	* Get Transaction Status
	* 
	* Gets the latest status of a transaction.
	* 
	* @param 	AUTO_LINK Transaction Id
	* @return	array			Transaction details		
	*/
	function get_transaction_status($transaction_id=NULL,$purchase_id)
	{
		$payment_address	=	self::get_seller_amazon_payment_keys($purchase_id);
		include_once ('.config.inc.php');
		$service = new Amazon_FPS_Client($payment_address['amazon_access_key'],                           $payment_address['amazon_secret_key']);
		//************************************************************************
		$request 	=	new Amazon_FPS_Model_GetTransactionStatusRequest();
		$request->setTransactionId($transaction_id);
		return $this->invokeGetTransactionStatus($service, $request);
	}

	/**
	* Get Transaction Status Action
	* 
	* Gets the latest status of a transaction.
	* 
	* @param Amazon_FPS_Interface $service instance of Amazon_FPS_Interface
	* @param mixed $request Amazon_FPS_Model_GetTransactionStatus or array of parameters
	*/
	function invokeGetTransactionStatus(Amazon_FPS_Interface $service, $request) 
	{
		try 
		{
			$response = $service->getTransactionStatus($request);
			if ($response->isSetGetTransactionStatusResult()) 
			{ 
				return $response->getGetTransactionStatusResult();
			}
			
		} catch (Amazon_FPS_Exception $ex) {	
				echo("Caught Exception: " . $ex->getMessage() . "\n");
				echo("Response Status Code: " . $ex->getStatusCode() . "\n");
				echo("Error Code: " . $ex->getErrorCode() . "\n");
				echo("Error Type: " . $ex->getErrorType() . "\n");
				echo("Request ID: " . $ex->getRequestId() . "\n");
				echo("XML: " . $ex->getXML() . "\n");
		}
	}

	/**
	* Validate return Url
	*
	* @return BINARY	Validation result
	*/
	public static function validate_ipn() 
	{
		require_code('amazon_payment/IPNAndReturnURLValidation/src/SignatureUtilsForOutbound');

		if(is_null(post_param('transactionId',NULL)))	return false;
		
		$utils = new SignatureUtilsForOutbound();
		//Parameters present in return url.
		$params["transactionId"] 		= post_param('transactionId',NULL);
		$params["transactionDate"] 	= post_param('transactionDate');
		$params["status"] 				= post_param('status');
		$params["signatureMethod"] 	= post_param('signatureMethod');
		$params["signatureVersion"] 	= post_param("signatureVersion");
		$params["buyerEmail"] 			= post_param("buyerEmail");
		$params["recipientEmail"] 		= post_param("recipientEmail");
		$params["operation"] 			= post_param("operation");
		$params["transactionAmount"] 	= post_param("transactionAmount");
		$params["referenceId"]	 		= post_param("referenceId");
		$params["buyerName"] 			= post_param("buyerName");
		$params["recipientName"] 		= post_param("recipientName");
		$params["paymentMethod"] 		= post_param("paymentMethod");
		$params["paymentReason"] 		= post_param("paymentReason");
		$params["certificateUrl"] 		= post_param("certificateUrl");
		$params["signature"]				= post_param("signature");

		$det				=	self::get_payment_settings();
		$urlEndPoint	=	$det['ipn_url'];
		return $utils->validateRequest($params, $urlEndPoint, "POST");
	}

	/**
	 * Get seller's amazon access keys
	 *
	 *	@param	AUTO_LINK	Purchase Id
	 * @return 	array			Access Keys
	 */
	function get_seller_amazon_payment_keys($purchase_id)
	{
		require_code('hooks/systems/ecommerce/'.filter_naughty_harsh('cart_orders'));
		$object		=	object_factory('Hook_'.filter_naughty_harsh('cart_orders'));
		$seller		=	$object->get_seller($purchase_id);

		require_code('hooks/systems/ecommerce_via/amazon');
		$pay_object			=	object_factory('Hook_amazon');
		$payment_address	=	$pay_object->_get_payment_address($seller);	
		return	$payment_address;
	}

	/**
	 * Get Site's default amazon payment keys
	 *
	 * @return array		Access Keys
	 */
	function _get_amazon_keys()
	{
		return ecommerce_test_mode()?array('amazon_access_key'=>get_option('amazon_access_key_test'),'amazon_secret_key'=>get_option('amazon_secret_key_test')):array('amazon_access_key'=>get_option('amazon_access_key'),'amazon_secret_key'=>get_option('amazon_secret_key'));
	}

	/**
	 * Get payment setting data
	 *
	 * @return array		Payment settings
	 */
	function get_payment_settings()
	{
		$relay_send	=	NULL;
		$module		=	get_param('page','purchase');
		$return_url	=	build_url(array('page'=>$module,'type'=>'finish','from'=>'amazon'),get_module_zone($module),NULL,false,false,true);
		$return_url	=	$return_url->evaluate();
		$cancel_url	=	build_url(array('page'=>$module,'type'=>'finish','cancel'=>1,'from'=>'amazon'),get_module_zone($module),NULL,false,false,true);
		$cancel_url	=	$cancel_url->evaluate();
		$ipn_url		=	find_script('ecommerce');

		if(get_option('ecommerce_test_mode')=="1")
		{
			$environment=	"sandbox";
			if(get_option('relay_url_return')!='')
			{
				$return_url	=	get_option('relay_url_return')."?from=amazon&method=get&to=".$return_url;
				$cancel_url	=	get_option('relay_url_return')."?from=amazon&method=get&cancel=1&to=".$return_url;
				$ipn_url		=	get_option('relay_url_return')."?from=amazon&ipn=1&method=get&to=".$return_url;
			}
			if(get_option('relay_url_send')!='')
			{
				$relay_send	=	get_option('relay_url_send');
			}
		}
		else
		{
			$environment	=	"prod";
		}
		return array('environment'=>$environment,'return_url'=>$return_url,'cancel_url'=>$cancel_url,'ipn_url'=>$ipn_url,'relay_send'=>$relay_send);
	}

	/**
	* Cancel subscription and refund
	* 
	* @param 	AUTO_LINK Transaction Id
	* @return	array		 Transaction details		
	*/
	function cancel_subscription_refund($subscription_id=NULL,$refund_amt=0,$cancel_reason=NULL,$cancelled_by=NULL)
	{
		if(is_null($cancelled_by))	$cancelled_by	=	$GLOBALS['FORUM_DRIVER']->get_username(get_member());
		$payment_address	=	self::get_seller_amazon_payment_keys($subscription_id);
		include_once ('.config.inc.php');
		$service = new Amazon_FPS_Client($payment_address['amazon_access_key'],                           $payment_address['amazon_secret_key']);
		//************************************************************************
		$request 	=	new Amazon_FPS_Model_CancelSubscriptionAndRefundRequest();
		$request->setSubscriptionId($subscription_id);
		$request->setCallerReference($cancelled_by);
		$request->setCancelReason('Cancelled by request');
		
		$response = $service->cancelSubscriptionAndRefund($request);
		return	$response;
	}
}

