<?php
/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     Amazon_FPS
 *  @copyright   Copyright 2008 Amazon Technologies, Inc.
 *  @link        http://aws.amazon.com
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2008-09-17
 */
/******************************************************************************* 
 *    __  _    _  ___ 
 *   (  )( \/\/ )/ __)
 *   /__\ \    / \__ \
 *  (_)(_) \/\/  (___/
 * 
 *  Amazon FPS PHP5 Library
 *  Generated: Wed Sep 23 03:35:04 PDT 2009
 * 
 */

/**
 * Verify Signature  Sample
 */

include_once ('.config.inc.php'); 

/************************************************************************
 * Instantiate Implementation of Amazon FPS
 * 
 * AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY constants 
 * are defined in the .config.inc.php located in the same 
 * directory as this sample
 ***********************************************************************/
 $service = new Amazon_FPS_Client(AWS_ACCESS_KEY_ID, 
                                       AWS_SECRET_ACCESS_KEY);
 
/************************************************************************
 * Uncomment to try out Mock Service that simulates Amazon_FPS
 * responses without calling Amazon_FPS service.
 *
 * Responses are loaded from local XML files. You can tweak XML files to
 * experiment with various outputs during development
 *
 * XML files available under Amazon/FPS/Mock tree
 *
 ***********************************************************************/
 // $service = new Amazon_FPS_Mock();

/************************************************************************
 * Setup request parameters and uncomment invoke to try out 
 * sample for Verify Signature Action
 ***********************************************************************/
 // @TODO: set request. Action can be passed as Amazon_FPS_Model_VerifySignatureRequest
 // object or array of parameters
	
	$request= new Amazon_FPS_Model_VerifySignatureRequest();
	$request->setUrlEndPoint("http://winserv.ocproducts.biz/Manu/amazone_payment/finish.php");
	$request->setHttpParameters("transactionDate=1259040291&signatureVersion=2&signatureMethod=RSA-SHA1&status=PF&referenceId=102&operation=pay&transactionAmount=1500&recipientEmail=manuprathapmukundan%40gmail.com&signature=TGx4wvYsJ3aMkx5QsFv75IBHnZcCF4OIaCtE%2BCNVX4zguWa0oQnO2chexGe02114uriMPqOFfdVA%0AwoxTW%2FfszMNPf0qCtlMD899%2BLmMbma%2FJ2qivlQ%2Fjlql1iRGLkRciIrLeyNrdh%2Bb1L8RpgOhiBZ0u%0APb5b6uS9asSID0FfN5S%2FUH%2FTg%2BK%2FBlja6t289siA66ZtDjpokCiLSAz3DhAaiPQr7w76AhRdUw%2Bs%0AGy5kebwub43K%2BQTNxx2%2BZnB%2FeN0eMR%2FPO7L1BRkNivPUBIlAgDfn4drGbnLFklTNNTeyDlfvkweX%0A0nxvzzozboY5mgBpgViL7keEQA5PKTxQyzrfMA%3D%3D&recipientName=Manuprathap&paymentMethod=Amazon+Payments+Balance&certificateUrl=https%3A%2F%2Ffps.sandbox.amazonaws.com%2Fcerts%2F090909%2FPKICert.pem&paymentReason=unicorn");

	invokeVerifySignature($service, $request);

                                                                                                                    
/**
  * Verify Signature Action Sample
  * 
  * Verify the signature that FPS sent in IPN or callback urls.
  *   
  * @param Amazon_FPS_Interface $service instance of Amazon_FPS_Interface
  * @param mixed $request Amazon_FPS_Model_VerifySignature or array of parameters
  */
  function invokeVerifySignature(Amazon_FPS_Interface $service, $request) 
  {
      try {
              $response = $service->verifySignature($request);
              
                echo ("Service Response\n");
                echo ("=============================================================================\n");
					print_r($response);exit();

                echo("        VerifySignatureResponse\n");
                if ($response->isSetVerifySignatureResult()) { 
                    echo("            VerifySignatureResult\n");
                    $verifySignatureResult = $response->getVerifySignatureResult();
                    if ($verifySignatureResult->isSetVerificationStatus()) 
                    {
                        echo("                VerificationStatus\n");
                        echo("                    " . $verifySignatureResult->getVerificationStatus() . "\n");
                    }
                } 
                if ($response->isSetResponseMetadata()) { 
                    echo("            ResponseMetadata\n");
                    $responseMetadata = $response->getResponseMetadata();
                    if ($responseMetadata->isSetRequestId()) 
                    {
                        echo("                RequestId\n");
                        echo("                    " . $responseMetadata->getRequestId() . "\n");
                    }
                } 

     } catch (Amazon_FPS_Exception $ex) {
         echo("Caught Exception: " . $ex->getMessage() . "\n");
         echo("Response Status Code: " . $ex->getStatusCode() . "\n");
         echo("Error Code: " . $ex->getErrorCode() . "\n");
         echo("Error Type: " . $ex->getErrorType() . "\n");
         echo("Request ID: " . $ex->getRequestId() . "\n");
         echo("XML: " . $ex->getXML() . "\n");
     }
 }
    