<?php
/** 
 *  PHP Version 5
 *
 *  @category    Amazon
 *  @package     Amazon_FPS
 *  @copyright   Copyright 2008 Amazon Technologies, Inc.
 *  @link        http://aws.amazon.com
 *  @license     http://aws.amazon.com/apache2.0  Apache License, Version 2.0
 *  @version     2008-09-17
 */
/******************************************************************************* 
 *    __  _    _  ___ 
 *   (  )( \/\/ )/ __)
 *   /__\ \    / \__ \
 *  (_)(_) \/\/  (___/
 * 
 *  Amazon FPS PHP5 Library
 *  Generated: Wed Sep 23 03:35:04 PDT 2009
 * 
 */

/**
 *  @see Amazon_FPS_Model
 */
require_once ('Amazon/FPS/Model.php');  

    

/**
 * Amazon_FPS_Model_CancelSubscriptionAndRefundRequest
 * 
 * Properties:
 * <ul>
 * 
 * <li>SubscriptionId: string</li>
 * <li>RefundAmount: Amazon_FPS_Model_Amount</li>
 * <li>CallerReference: string</li>
 * <li>CancelReason: string</li>
 *
 * </ul>
 */ 
class Amazon_FPS_Model_CancelSubscriptionAndRefundRequest extends Amazon_FPS_Model
{


    /**
     * Construct new Amazon_FPS_Model_CancelSubscriptionAndRefundRequest
     * 
     * @param mixed $data DOMElement or Associative Array to construct from. 
     * 
     * Valid properties:
     * <ul>
     * 
     * <li>SubscriptionId: string</li>
     * <li>RefundAmount: Amazon_FPS_Model_Amount</li>
     * <li>CallerReference: string</li>
     * <li>CancelReason: string</li>
     *
     * </ul>
     */
    public function __construct($data = null)
    {
        $this->_fields = array (
        'SubscriptionId' => array('FieldValue' => null, 'FieldType' => 'string'),
        'RefundAmount' => array('FieldValue' => null, 'FieldType' => 'Amazon_FPS_Model_Amount'),
        'CallerReference' => array('FieldValue' => null, 'FieldType' => 'string'),
        'CancelReason' => array('FieldValue' => null, 'FieldType' => 'string'),
		  'CurrencyCode'=>array('FieldValue' => null, 'FieldType' => 'string'),			
        );
        parent::__construct($data);
    }

        /**
     * Gets the value of the SubscriptionId property.
     * 
     * @return string SubscriptionId
     */
    public function getSubscriptionId() 
    {
        return $this->_fields['SubscriptionId']['FieldValue'];
    }

    /**
     * Sets the value of the SubscriptionId property.
     * 
     * @param string SubscriptionId
     * @return this instance
     */
    public function setSubscriptionId($value) 
    {
        $this->_fields['SubscriptionId']['FieldValue'] = $value;
        return $this;
    }

    /**
     * Sets the value of the SubscriptionId and returns this instance
     * 
     * @param string $value SubscriptionId
     * @return Amazon_FPS_Model_CancelSubscriptionAndRefundRequest instance
     */
    public function withSubscriptionId($value)
    {
        $this->setSubscriptionId($value);
        return $this;
    }


    /**
     * Checks if SubscriptionId is set
     * 
     * @return bool true if SubscriptionId  is set
     */
    public function isSetSubscriptionId()
    {
        return !is_null($this->_fields['SubscriptionId']['FieldValue']);
    }

    /**
     * Gets the value of the RefundAmount.
     * 
     * @return Amount RefundAmount
     */
    public function getRefundAmount() 
    {
        return $this->_fields['RefundAmount']['FieldValue'];
    }

    /**
     * Sets the value of the RefundAmount.
     * 
     * @param Amount RefundAmount
     * @return void
     */
    public function setRefundAmount($value) 
    {
        $this->_fields['RefundAmount']['FieldValue'] = $value;
        return;
    }

    /**
     * Sets the value of the RefundAmount  and returns this instance
     * 
     * @param Amount $value RefundAmount
     * @return Amazon_FPS_Model_CancelSubscriptionAndRefundRequest instance
     */
    public function withRefundAmount($value)
    {
        $this->setRefundAmount($value);
        return $this;
    }


    /**
     * Checks if RefundAmount  is set
     * 
     * @return bool true if RefundAmount property is set
     */
    public function isSetRefundAmount()
    {
        return !is_null($this->_fields['RefundAmount']['FieldValue']);

    }

    /**
     * Gets the value of the CallerReference property.
     * 
     * @return string CallerReference
     */
    public function getCallerReference() 
    {
        return $this->_fields['CallerReference']['FieldValue'];
    }

    /**
     * Sets the value of the CallerReference property.
     * 
     * @param string CallerReference
     * @return this instance
     */
    public function setCallerReference($value) 
    {
        $this->_fields['CallerReference']['FieldValue'] = $value;
        return $this;
    }

    /**
     * Sets the value of the CallerReference and returns this instance
     * 
     * @param string $value CallerReference
     * @return Amazon_FPS_Model_CancelSubscriptionAndRefundRequest instance
     */
    public function withCallerReference($value)
    {
        $this->setCallerReference($value);
        return $this;
    }


    /**
     * Checks if CallerReference is set
     * 
     * @return bool true if CallerReference  is set
     */
    public function isSetCallerReference()
    {
        return !is_null($this->_fields['CallerReference']['FieldValue']);
    }

    /**
     * Gets the value of the CancelReason property.
     * 
     * @return string CancelReason
     */
    public function getCancelReason() 
    {
        return $this->_fields['CancelReason']['FieldValue'];
    }

    /**
     * Sets the value of the CancelReason property.
     * 
     * @param string CancelReason
     * @return this instance
     */
    public function setCancelReason($value) 
    {
        $this->_fields['CancelReason']['FieldValue'] = $value;
        return $this;
    }

    /**
     * Sets the value of the CancelReason and returns this instance
     * 
     * @param string $value CancelReason
     * @return Amazon_FPS_Model_CancelSubscriptionAndRefundRequest instance
     */
    public function withCancelReason($value)
    {
        $this->setCancelReason($value);
        return $this;
    }


    /**
     * Checks if CancelReason is set
     * 
     * @return bool true if CancelReason  is set
     */
    public function isSetCancelReason()
    {
        return !is_null($this->_fields['CancelReason']['FieldValue']);
    }

	 /**
     * Checks if CurrencyCode is set
     * 
     * @return bool true if CurrencyCode  is set
     */
    public function isSetCurrencyCode()
    {
        return !is_null($this->_fields['CurrencyCode']['FieldValue']);
    }

	 /**
     * Gets the value of the CurrencyCode property.
     * 
     * @return string CurrencyCode
     */
    public function getCurrencyCode()
    {
        return $this->_fields['CurrencyCode']['FieldValue'];
    }
}