/* Validation code and other general code relating to forms */

"use strict";

new Image().src='{$IMG,bottom/loading}'.replace(/^http:/,window.location.protocol);

function password_strength(ob)
{
	if (ob.name.indexOf('2')!=-1) return;
	if (ob.name.indexOf('confirm')!=-1) return;

	var _ind=document.getElementById('password_strength_'+ob.id);
	if (!_ind) return;
	var ind=_ind.getElementsByTagName('div')[0];
	var strength=load_snippet('password_strength','password='+window.encodeURIComponent(ob.value));
	strength*=2; if (strength>10) strength=10; // Normally too harsh!
	ind.style.width=(strength*10)+'px';
	if (strength>=6)
		ind.style.backgroundColor='green';
	else if (strength<4)
		ind.style.backgroundColor='red';
	else
		ind.style.backgroundColor='orange';
	ind.parentNode.style.display=(ob.value.length==0)?'none':'block';
}

function fix_form_enter_key(form)
{
	var submit=document.getElementById('submit_button');
	var inputs=form.getElementsByTagName('input');
	var type;
	for (var i=0;i<inputs.length;i++)
	{
		type=inputs[i].type;
		if (((type=='text') || (type=='password') || (type=='color') || (type=='email') || (type=='number') || (type=='range') || (type=='search') || (type=='tel') || (type=='url'))
		 && (typeof submit.onclick!='undefined') && (submit.onclick)
		 && ((typeof inputs[i].onkeypress=='undefined') || (!inputs[i].onkeypress)))
			inputs[i].onkeypress=function(event) { if (typeof event=='undefined') var event=window.event; if (enter_pressed(event)) submit.onclick(); };
	}
}

function radioValue(radios)
{
	for (var i=0;i<radios.length;i++)
	{
		if (radios[i].checked) return radios[i].value;
	}
	return '';
}

function setFieldError(theElement,errorMsg)
{
	var errorElement=null;
	if (typeof theElement.name!='undefined')
	{
		var id=theElement.name;
		errorElement=document.getElementById('error_'+id);
		if (!errorElement)
		{
			if ((errorMsg=='') && (id.indexOf('_hour')!=-1) || (id.indexOf('_minute')!=-1)) return; // Do not blank out as day/month/year (which comes first) would have already done it
			errorElement=document.getElementById('error_'+id.replace(/\_day$/,'').replace(/\_month$/,'').replace(/\_year$/,'').replace(/\_hour$/,'').replace(/\_minute$/,''));
		}
		if (errorElement)
		{
			// Make error message visible, if there's an error
			errorElement.style.display=(errorMsg=='')?'none':'block';

			// Changed error message
			if (getInnerHTML(errorElement)!=escape_html(errorMsg))
			{
				setInnerHTML(errorElement,'');
				if (errorMsg!='') // If there actually an error
				{
					theElement.setAttribute('aria-invalid','true');

					// Need to switch tab?
					var p=errorElement;
					while (p)
					{
						p=p.parentNode;
						if ((errorMsg.substr(0,5)!='{!DISABLED_FORM_FIELD;}'.substr(0,5)) && (p) && (typeof p.getAttribute!='undefined') && (p.getAttribute('id')) && (p.getAttribute('id').substr(0,2)=='g_') && (p.style.display=='none'))
						{
							select_tab('g',p.getAttribute('id').substr(2,p.id.length-2));
							break;
						}
					}

					// Set error message
					var msgNode=document.createTextNode(errorMsg);
					errorElement.appendChild(msgNode);
					errorElement.setAttribute('role','alert');

					// Fade in
					if (typeof window.nereidFade!='undefined')
					{
						setOpacity(errorElement,0.0);
						nereidFade(errorElement,100,30,4);
					}
				} else
				{
					theElement.setAttribute('aria-invalid','false');
					errorElement.setAttribute('role','');
				}
			}
		}
	}
	if ((typeof window.isWYSIWYGField!='undefined') && (isWYSIWYGField(theElement))) theElement=theElement.parentNode;
	if (errorMsg!='')
	{
		theElement.className=theElement.className+' input_erroneous';
	} else
	{
		theElement.className=theElement.className.replace(/( input_erroneous($| ))+/g,' ');
	}
}

function try_to_simplify_iframe_form()
{
	var form_cat_selector=document.getElementById('main_form'),i,element,count=0,found,foundButton;
	if (!form_cat_selector) return;
	var inputs=form_cat_selector.getElementsByTagName('input');
	var buttons=form_cat_selector.getElementsByTagName('button');
	var selects=form_cat_selector.getElementsByTagName('select');
	var textareas=form_cat_selector.getElementsByTagName('select');
	var elements=[];
	for (i=0;i<inputs.length;i++) elements.push(inputs[i]);
	for (i=0;i<buttons.length;i++) elements.push(buttons[i]);
	for (i=0;i<selects.length;i++) elements.push(selects[i]);
	for (i=0;i<textareas.length;i++) elements.push(textareas[i]);
	for (i=0;i<elements.length;i++)
	{
		element=elements[i];
		if (((element.nodeName.toLowerCase()=='input') && (element.getAttribute('type')!='hidden') && (element.getAttribute('type')!='button') && (element.getAttribute('type')!='image') && (element.getAttribute('type')!='submit')) || (element.nodeName.toLowerCase()=='select') || (element.nodeName.toLowerCase()=='textarea'))
		{
			found=element;
			count++;
		}
		if (((element.nodeName.toLowerCase()=='input') && ((element.getAttribute('type')=='button') || (element.getAttribute('type')=='image') || (element.getAttribute('type')=='submit'))) || (element.nodeName.toLowerCase()=='button'))
		{
			foundButton=element;
		}
	}

	if ((count==1) && (found.nodeName.toLowerCase()=='select'))
	{
		var iframe=document.getElementById('iframe_under');
		found.onchange=function() {
			if (iframe)
			{
				if ((iframe.contentDocument) && (iframe.contentDocument.getElementsByTagName('form').length!=0))
				{
					window.fauxmodal_confirm(
						'{!Q_SURE_LOSE^;}',
						function(result)
						{
							if (result)
							{
								_simplified_form_continue_submit(iframe,form_cat_selector);
							}
						}
					);

					return null;
				}
			}

			_simplified_form_continue_submit(iframe,form_cat_selector);
			
			return null;
		}
		if ((found.getAttribute('size')>1) || (found.multiple)) found.onclick=found.onchange;
		if (iframe)
		{
			foundButton.style.display='none';
		}
	}
}

function _simplified_form_continue_submit(iframe,form_cat_selector)
{
	if (checkForm(form_cat_selector))
	{
		if (iframe) animateFrameLoad(iframe,'iframe_under');
		form_cat_selector.submit();
	}
}

function do_form_submit(form)
{
	if (!checkForm(form,false)) return false;

	if ((typeof form.old_action!='undefined') && (form.old_action)) form.setAttribute('action',form.old_action);
	if ((typeof form.old_target!='undefined') && (form.old_target)) form.setAttribute('target',form.old_target);
	if (!form.getAttribute('target')) form.setAttribute('target','_top');

	{$,Remove any stuff that is only in the form for previews if doing a GET request}
	if (form.getAttribute('method').toLowerCase()=='get')
	{
   	var i=0,name,elements=[];
   	for (i=0;i<form.elements.length;i++)
   	{
   		elements.push(form.elements[i]);
   	}
   	for (i=0;i<elements.length;i++)
   	{
   		name=elements[i].name;
   		if ((name.substr(0,11)=='label_for__') || (name.substr(0,14)=='tick_on_form__') || (name.substr(0,9)=='comcode__') || (name.substr(0,9)=='require__'))
   		{
   			elements[i].parentNode.removeChild(elements[i]);
   		}
   	}
	}
	if (form.onsubmit)
	{
		var ret=form.onsubmit();
		if (!ret) return false;
	}
	if ((typeof window.just_checking_requirements=='undefined') || (!window.just_checking_requirements)) form.submit();
	
	disable_buttons_just_clicked(document.getElementsByTagName('input'));
	disable_buttons_just_clicked(document.getElementsByTagName('button'));

	if (typeof window.detect_interval!='undefined')
	{
		window.clearInterval(window.detect_interval);
		window.detect_interval=null;
	}

	return true;
}

function disable_buttons_just_clicked(inputs)
{
	for (var i=0;i<inputs.length;i++)
	{
		if ((inputs[i].nodeName.toLowerCase()=='button') || (inputs[i].type=='image') || (inputs[i].type=='submit') || (inputs[i].type=='button'))
		{
			if (inputs[i].getAttribute('accesskey')=='u') /* Identifies submit button */
			{
				if ((!inputs[i].disabled) && (!inputs[i].under_timer)) /* We do not want to interfere with other code potentially operating */
				{
					disable_button_just_clicked(inputs[i]);
				}
			}
		}
	}
}

function do_form_preview(form,preview_url,has_separate_preview)
{
	if ((window.checkForm) && (!checkForm(form,true))) return false;

	var old_action=form.getAttribute('action');

	if ((has_separate_preview) || (window.has_separate_preview))
	{
		form.setAttribute('action',old_action+'&preview=1');
		return true;
	}

	if (!form.old_action) form.old_action=old_action;
	form.setAttribute('action',/*maintain_theme_in_link - no, we want correct theme images to work*/(preview_url)+((form.old_action.indexOf('&uploading=1')!=-1)?'&uploading=1':''));
	var old_target=form.getAttribute('target');
	if (!old_target) old_target='_top'; {$,not _self due to edit screen being a frame itself}
	if (!form.old_target) form.old_target=old_target;
	form.setAttribute('target','preview_iframe');
	document.getElementById('submit_button').style.display='inline';
	//window.setInterval(function() { resizeFrame('preview_iframe',window.top.scrollY+window.top.getWindowHeight()); },1500);
	var pf=document.getElementById('preview_iframe');

	{$,Do our loading-animation}
	window.setInterval(trigger_resize,500);  {$,In case its running in an iframe itself}
	animateFrameLoad(pf,'preview_iframe',50);

	/* input.value not readable on most modern web browsers, and this code is not maintained
	var inputs=form.elements,input;
	for (var i=0;i<inputs.length-1;i++)
	{
		input=inputs[i];
		if ((input.type=='file') && (!input.name.match(/file\d*$/)) && (input.className.indexOf('previews')==-1) && (!input.disabled) && (input.value!=''))
		{
			input.disabled=true;
			window.setTimeout(function() { document.getElementById(input.id).disabled=false; },500);
		}
	}*/

	return true;
}

function cleverFindValue(theForm,theElement)
{
	var myValue=(typeof window.getTextbox=='undefined')?theElement.value:getTextbox(theElement);
	if (theElement.getAttribute('type')=='radio')
	{
		myValue='';
		for (var i=0;i<theForm.elements.length;i++)
		{
			if ((theForm.elements[i].checked) && (theForm.elements[i].name==theElement.name))
				myValue=theForm.elements[i].value;
		}
	}
	if ((theElement.nodeName.toLowerCase()=='select') && (theElement.selectedIndex>=0))
	{
		myValue=theElement.options[theElement.selectedIndex].value;
		if ((myValue=='') && (theElement.getAttribute('size')>1)) myValue='-1'; // Fudge, as we have selected something explicitly that is blank
	}
	if (myValue===null) myValue='';
	return myValue;
}

function checkField(theElement,theForm,forPreview)
{
	var i,theClass,required,myValue,erroneous=false,errorMsg='',regexp,totalFileSize=0,alerted=false,errorElement=null;

	if (((theElement.type=='hidden') || ((theElement.style.display=='none') && ((typeof window.isWYSIWYGField=='undefined') || (!isWYSIWYGField(theElement))))) && ((!theElement.className) || (theElement.className.indexOf('hidden_but_needed')==-1)))
	{
		return null;
	}

	// Test file sizes
	if ((theElement.type=='file') && (theElement.files) && (theElement.files.item) && (theElement.files.item(0)) && (theElement.files.item(0).fileSize))
		totalFileSize+=theElement.files.item(0).fileSize;

	// Test file types
	if ((theElement.type=='file') && (theElement.value) && (theElement.name!='file_novalidate'))
	{
		var valid_types='{$VALID_FILE_TYPES;}'.split(/,/);
		var type_ok=false;
		var theFileType=theElement.value.indexOf('.')?theElement.value.substr(theElement.value.lastIndexOf('.')+1):'{!NONE^;}';
		for (var k=0;k<valid_types.length;k++)
		{
			if (valid_types[k].toLowerCase()==theFileType.toLowerCase()) type_ok=true;
		}
		if (!type_ok)
		{
			errorMsg="{!INVALID_FILE_TYPE^#,xx1xx,{$VALID_FILE_TYPES}}".replace(/xx1xx/g,theFileType).replace(/<[^>]*>/g,'').replace(/&[lr][sd]quo;/g,"'").replace(/,/g,', ');
			if (!alerted) window.fauxmodal_alert(errorMsg);
			alerted=true;
		}
	}

	// Fix up bad characters
	if ((browser_matches('ie')) && (theElement.value) && (theElement.nodeName.toLowerCase()!='select'))
	{
		bad_word_chars=[8216,8217,8220,8221];
		fixed_word_chars=["'","'",'"','"'];
		for (i=0;i<bad_word_chars.length;i++)
		{
			regexp=new RegExp(String.fromCharCode(bad_word_chars[i]),'gm');
			theElement.value=theElement.value.replace(regexp,fixed_word_chars[i]);
		}
	}

	theClass=firstClassName(theElement.className);

	if ((!forPreview) && (theElement.name=='delete') && (((theClass=='input_radio') && (theElement.value!='0')) || (theClass=='input_tick')) && (theElement.checked))
	{
		return [false,theElement,0,true]; // Because we're deleting, errors do not matter
	}

	// Find whether field is required and value of it
	required=theElement.className.indexOf('_required');
	myValue=cleverFindValue(theForm,theElement);

	if ((required!=-1) && ((myValue.replace(/&nbsp;/g,' ').replace(/<br\s*\/?>/g,' ').replace(/\s/g,'')=='') || (myValue=='****')))
	{
		errorMsg="{!REQUIRED_NOT_FILLED_IN^#}";
	} else
	{
		if ((theElement.className.indexOf('date')!=-1) && (theElement.name.match(/\_(day|month|year)$/)) && (myValue!=''))
		{
			var day=theForm.elements[theElement.name.replace(/\_(day|month|year)$/,'_day')].options[theForm.elements[theElement.name.replace(/\_(day|month|year)$/,'_day')].selectedIndex].value;
			var month=theForm.elements[theElement.name.replace(/\_(day|month|year)$/,'_month')].options[theForm.elements[theElement.name.replace(/\_(day|month|year)$/,'_month')].selectedIndex].value;
			var year=theForm.elements[theElement.name.replace(/\_(day|month|year)$/,'_year')].options[theForm.elements[theElement.name.replace(/\_(day|month|year)$/,'_year')].selectedIndex].value;
			var source_date=new Date(year,month-1,day);
			if (year!=source_date.getFullYear()) errorMsg="{!NOT_A_DATE^#}";
			if (month!=source_date.getMonth()+1) errorMsg="{!NOT_A_DATE^#}";
			if (day!=source_date.getDate()) errorMsg="{!NOT_A_DATE^#}";
		}
		if (((theClass=='input_email') || (theClass=='input_email_required')) && (myValue!='') && (myValue!='****') && (!myValue.match(/^[a-zA-Z0-9\._\-\+]+@[a-zA-Z0-9\._\-]+$/)))
		{
			errorMsg="{!NOT_A_EMAIL^#}".replace('xxx',myValue);
		}
		if (((theClass=='input_username') || (theClass=='input_username_required')) && (myValue!='') && (myValue!='****') && (window.do_ajax_field_test) && (!do_ajax_field_test('{$FIND_SCRIPT_NOHTTP;,username_exists}?username='+encodeURIComponent(myValue))))
		{
			errorMsg="{!NOT_USERNAME^#}".replace('xxx',myValue);
		}
		if (((theClass=='input_codename') || (theClass=='input_codename_required')) && (myValue!='') && (myValue!='****') && (!myValue.match(/^[a-zA-Z0-9\-\.\_]*$/)))
		{
			errorMsg="{!NOT_CODENAME^#}".replace('xxx',myValue);
		}
		if (((theClass=='input_integer') || (theClass=='input_integer_required')) && (myValue!='') && (myValue!='****') && (parseInt(myValue,10)!=myValue-0))
		{
			errorMsg="{!NOT_INTEGER^#}".replace('xxx',myValue);
		}
		if (((theClass=='input_float') || (theClass=='input_float_required')) && (myValue!='') && (myValue!='****') && (parseFloat(myValue)!=myValue-0))
		{
			errorMsg="{!NOT_FLOAT^#}".replace('xxx',myValue);
		}
	}

	setFieldError(theElement,errorMsg);
	if ((errorMsg!='') && (!erroneous))
	{
		erroneous=true;
		errorElement=theElement;
	}
	
	return [erroneous,errorElement,totalFileSize,alerted];
}

function checkForm(theForm,forPreview)
{
	var j,theElement,erroneous=false,totalFileSize=0,alerted=false,errorElement=null,checkResult;
	for (j=0;j<theForm.elements.length;j++)
	{
		if (!theForm.elements[j]) continue;
		
		if (theForm.elements[j].nodeName.toLowerCase()=='object') continue; // IE9 being weird!

		theElement=theForm.elements[j];

		checkResult=checkField(theElement,theForm,forPreview);
		if (checkResult!=null)
		{
			erroneous=checkResult[0] | erroneous;
			if (!errorElement) errorElement=checkResult[1];
			totalFileSize+=checkResult[2];
			alerted=checkResult[3] | alerted;
			
			if (checkResult[0])
			{
				theElement.onblur=function(theElement) { return function(event,no_recurse) {
					var checkResult=checkField(theElement,theForm,forPreview);
					if ((checkResult!=null) && (!checkResult[0]))
					{
						setFieldError(theElement,'');
					}

					if ((!no_recurse) && (theElement.className.indexOf('date')!=-1) && (theElement.name.match(/\_(day|month|year)$/)))
					{
						var e=document.getElementById(theElement.id.replace(/\_(day|month|year)$/,'_day'));
						if (e!=theElement) e.onblur(event,true);
						var e=document.getElementById(theElement.id.replace(/\_(day|month|year)$/,'_month'));
						if (e!=theElement) e.onblur(event,true);
						var e=document.getElementById(theElement.id.replace(/\_(day|month|year)$/,'_year'));
						if (e!=theElement) e.onblur(event,true);
					}
				} }(theElement);
			}
		}
	}
	
	if ((totalFileSize>0) && (theForm.elements['MAX_FILE_SIZE']))
	{
		if (totalFileSize>theForm.elements['MAX_FILE_SIZE'].value)
		{
			if (!erroneous)
			{
				errorElement=theElement;
				erroneous=true;
			}
			if (!alerted)
			{
				window.fauxmodal_alert("{!TOO_MUCH_FILE_DATA^#}".replace(new RegExp('\\\\{'+'1'+'\\\\}','g'),Math.round(totalFileSize/1024)).replace(new RegExp('\\\\{'+'2'+'\\\\}','g'),Math.round(theForm.elements['MAX_FILE_SIZE'].value/1024)));
			}
			alerted=true;
		}
	}

	if (erroneous)
	{
		if (!alerted) window.fauxmodal_alert("{!IMPROPERLY_FILLED_IN^#}");
		var posy=findPosY(errorElement,true);
		if (posy==0)
		{
			posy=findPosY(errorElement.parentNode,true);
		}

		if (posy!=0)
			smoothScroll(posy-50,null,null,function() { try { errorElement.focus(); } catch(e) {}; /* Can have exception giving focus on IE for invisible fields */ } );
	}

	return !erroneous;
}

function standardAlternateFieldsWithin(set_name,something_required)
{
	var form=document.getElementById('set_wrapper_'+set_name);
	while (form.nodeName.toLowerCase()!='form')
	{
		form=form.parentNode;
	}
	var fields=form.elements[set_name];
	var field_names=[];
	for (var i=0;i<fields.length;i++)
	{
		if (typeof fields[i][0]=='undefined')
		{
			if (fields[i].id.match(/^choose\_/))
				field_names.push(fields[i].id.replace(/^choose\_/,''));
		} else
		{
			if (fields[i][0].id.match(/^choose\_/))
				field_names.push(fields[i][0].id.replace(/^choose\_/,''));
		}
	}
	standardAlternateFields(field_names,something_required);
}

// Do dynamic setLocked/setRequired such that one of these must be set, but only one may be
function standardAlternateFields(field_names,something_required,second_run)
{
	if (typeof second_run=='undefined') var second_run=false;

	// Look up field objects
	var fields=[];
	for (var i=0;i<field_names.length;i++)
	{
		var field=_standardAlternateFieldsGetObject(field_names[i]);
		fields.push(field);
	}

	// Set up listeners...
	for (var i=0;i<field_names.length;i++)
	{
		var field=fields[i];
		if (typeof field.alternating=='undefined') // ... but only if not already set
		{
			var selfFunction=function (e) { standardAlternateFields(field_names,something_required,true); } ; // We'll re-call ourself on change
			_standardAlternateFieldCreateListeners(field,selfFunction);
		}
	}

	// Update things
	for (var i=0;i<field_names.length;i++)
	{
		var field=fields[i];
		if (_standardAlternateFieldIsFilledIn(field,second_run,false))
			return _standardAlternateFieldUpdateEditability(field,fields,something_required);
	}

	// Hmm, force first one chosen then
	for (var i=0;i<field_names.length;i++)
	{
		var field=fields[i];
		if (_standardAlternateFieldIsFilledIn(field,second_run,true))
			return _standardAlternateFieldUpdateEditability(field,fields,something_required);
	}
}

function _standardAlternateFieldIsFilledIn(field,second_run,force)
{
	var is_set=force || ((field.value!='') && (field.value!='-1')) || ((typeof field.virtual_value!='undefined') && (field.virtual_value!='') && (field.virtual_value!='-1'));

	var radio_button=document.getElementById('choose_'+field.name.replace(/\[\]$/,'')); // Radio button handles field alternation
	if (second_run)
	{
		if (radio_button) return radio_button.checked;
	} else
	{
		if (radio_button) radio_button.checked=is_set;
	}
	return is_set;
}

function _standardAlternateFieldCreateListeners(field,refreshFunction)
{
	if (typeof field.nodeName!='undefined')
	{
		__standardAlternateFieldCreateListeners(field,refreshFunction);
	} else
	{
		var i;
		for (i=0;i<field.length;i++)
		{
			if (typeof field[i].name!='undefined')
				__standardAlternateFieldCreateListeners(field[i],refreshFunction);
		}
		field.alternating=true;
	}
	return null;
}

function __standardAlternateFieldCreateListeners(field,refreshFunction)
{
	var radio_button=document.getElementById('choose_'+field.name.replace(/\[\]$/,''));
	if (radio_button) // Radio button handles field alternation
	{
		addEventListenerAbstract(radio_button,"change",refreshFunction);
	} else // Filling/blanking out handles field alternation
	{
		addEventListenerAbstract(field,"keyup",refreshFunction);
		addEventListenerAbstract(field,"change",refreshFunction);
		field.fakeonchange=refreshFunction;
	}
	field.alternating=true;
}

function _standardAlternateFieldsGetObject(field_name)
{
	var field=document.getElementById(field_name);
	if (field) return field;

	// A radio field, so we need to create a virtual field object to return that will hold our value
	var radio_buttons=[],i,j,e;
	radio_buttons['name']=field_name;
	radio_buttons['value']='';
	for (i=0;i<document.forms.length;i++)
	{
		for (j=0;j<document.forms[i].elements.length;j++)
		{
			e=document.forms[i].elements[j];

			if (e.name.replace(/\[\]$/,'')==field_name)
			{
				radio_buttons.push(e);
				if (e.checked) // This is the checked radio equivalent to our text field, copy the value through to the text field
				{
					radio_buttons['value']=e.value;
				}
				if (e.alternating) radio_buttons.alternating=true;
			}
		}
	}

	if (radio_buttons.length==0) return null;

	return radio_buttons;
}

function _standardAlternateFieldUpdateEditability(chosen,choices,something_required)
{
	for (var i=0;i<choices.length;i++)
	{
		__standardAlternateFieldUpdateEditability(choices[i],chosen,choices[i]!=chosen,choices[i]==chosen,something_required);
	}
}
// NB: is_chosen may only be null if is_locked is false
function __standardAlternateFieldUpdateEditability(field,chosen_field,is_locked,is_chosen,something_required)
{
	if (typeof field.nodeName!='undefined')
	{
		___standardAlternateFieldUpdateEditability(field,chosen_field,is_locked,is_chosen,something_required);
	} else // Radio list
	{
		for (var i=0;i<field.length;i++)
		{
			if (typeof field[i].name!='undefined') // If it is an object, as opposed to some string in the collection
			{
				___standardAlternateFieldUpdateEditability(field[i],chosen_field,is_locked,is_chosen,something_required);
			}
		}
	}
}
function ___standardAlternateFieldUpdateEditability(field,chosen_field,is_locked,is_chosen,something_required)
{
	var radio_button=document.getElementById('choose_'+field.name.replace(/\[\]$/,''));

	setLocked(field,is_locked,chosen_field);
	if (something_required)
	{
		setRequired(field.name.replace(/\[\]$/,''),is_chosen);
	}
	var tr=field;
	while ((tr) && (tr.nodeName.toLowerCase()!='tr'))
	{
		tr=tr.parentNode;
	}
	if ((tr) && (tr.nodeName.toLowerCase()=='tr') && (!radio_button))
		setOpacity(tr,is_locked?0.3:1.0);
}

function setLocked(field,is_locked,chosen_ob)
{
	var radio_button=document.getElementById('choose_'+field.name.replace(/\[\]$/,''));

	// For All-and-not,Line-multi,Compound-Tick,Radio-List,Date/Time: setLocked assumes that the calling code is clever
	// special input types are coded to observe their master input field readonly status)
	var button=document.getElementById('uploadButton_'+field.name.replace(/\[\]$/,''));

	if (is_locked)
	{
		var labels=document.getElementsByTagName('label'),label=null;
		for (var i=0;i<labels.length;i++)
		{
			if (labels[i].getAttribute('for')==chosen_ob.id)
			{
				label=labels[i];
				break;
			}
		}
		if (!radio_button)
		{
			if (label)
			{
				var label_nice=getInnerHTML(label).replace('&raquo;','').replace('','').replace(/^\s*/,'').replace(/\s*$/,'');
				if (field.type=='file')
				{
					setFieldError(field,'{!DISABLED_FORM_FIELD_ENCHANCEDMSG_UPLOAD^;}'.replace(/\\{1\\}/,label_nice));
				} else
				{
					setFieldError(field,'{!DISABLED_FORM_FIELD_ENCHANCEDMSG^;}'.replace(/\\{1\\}/,label_nice));
				}
			} else
			{
				setFieldError(field,'{!DISABLED_FORM_FIELD^;}');
			}
		}
		field.className=field.className.replace(/( input_erroneous($| ))+/g,' ');
	} else
	{
		if (!radio_button)
		{
			setFieldError(field,'');
		}
	}
	field.disabled=is_locked;
	if (button) button.disabled=is_locked;
}

function setRequired(field_name,is_required)
{
	var radio_button=document.getElementById('choose_'+field_name);

	if (radio_button)
	{
		if (is_required) radio_button.checked=true;
	} else
	{
		var required_a=document.getElementById('requirea__'+field_name);
		var required_b=document.getElementById('requireb__'+field_name);
		var required_c=document.getElementById('requirec__'+field_name);
		var required_d=document.getElementById('required__'+field_name);
		if (is_required)
		{
			if (required_a) required_a.className='de_th dottedborder_barrier_a_required';
			if (required_d) required_d.className='dottedborder_barrier_b_required';
			if (required_b) required_b.style.display='inline';
			if (required_c) required_c.value=1;
		} else
		{
			if (required_a) required_a.className='de_th dottedborder_barrier_a_nonrequired';
			if (required_d) required_d.className='dottedborder_barrier_b_nonrequired';
			if (required_b) required_b.style.display='none';
			if (required_c) required_c.value=0;
		}
	}

	var element=document.getElementById(field_name);

	if (element)
	{
		element.className=element.className.replace(/(input\_[a-z\_]+)_required/g,'$1');

		if (typeof element.swfob!='undefined')
		{
			element.swfob.settings.required=is_required;
		}

		if (is_required) element.className=element.className.replace(/(input\_[a-z\_]+)/g,'$1_required');
	}

	if (!is_required)
	{
		var error=document.getElementById('error__'+field_name);
		if (error) error.style.display='none';
	}
}

// Hide a 'tray' of trs in a form
function toggleSubordinateFields(pic,help_id)
{
	var new_state,new_state_2,new_state_3,i;
	var tr=pic.parentNode.parentNode.parentNode;
	
	var next=tr.nextSibling;
	if (!next) return;
	while (next.nodeName.toLowerCase()!='tr') // Sometimes divs or whatever may have errornously been put in a table by a programmer, skip past them
	{
		next=next.nextSibling;
		if (!next) break;
		if (next.className=='form_screen_field_spacer') // End of section, so no need to keep going
		{
			next=null;
			break;
		}
	}

	if (((!next) && (pic.src.indexOf('expand')!=-1)) || ((next) && (next.style.display=='none'))) {$,Expanding now}
	{
		pic.src=((pic.src.indexOf("themewizard.php")!=-1)?pic.src.replace("expand","contract"):"{$IMG,contract}").replace(/^http:/,window.location.protocol);
		pic.setAttribute('alt','{!CONTRACT;}');
		pic.setAttribute('title','{!CONTRACT;}');
		new_state=browser_matches('ie')?'block':'table-row';
		new_state_2='block';
		new_state_3='1px dashed';
	} else {$,Contracting now}
	{
		pic.src=((pic.src.indexOf("themewizard.php")!=-1)?pic.src.replace("contract","expand"):"{$IMG,expand}").replace(/^http:/,window.location.protocol);
		pic.setAttribute('alt','{!EXPAND;}');
		pic.setAttribute('title','{!EXPAND;}');
		new_state='none';
		new_state_2='none';
		new_state_3='0';
	}
	
	// Hide everything until we hit end of section
	var count=0;
	while (tr.nextSibling)
	{
		tr=tr.nextSibling;
		if (tr.nodeName.toLowerCase()!='tr') continue;

		{$,Start of next section?}
		if (tr.className=='form_screen_field_spacer') break; // End of section
		
		{$,Ok to proceed}
		tr.style.display=new_state;
		if (browser_matches('ie6'))
		{
			for (i=0;i<tr.cells.length;i++) // Work around IE6 bug (the table borders do not hide so you need to turn them off for hidden cells)
			{
				tr.cells[i].style.border=new_state_3;
				tr.cells[i].style.display=new_state;
			}
		}

		if ((typeof window.nereidFade!='undefined') && (new_state_2!='none') && (count<50/*Performance*/))
		{
			setOpacity(tr,0.0);
			nereidFade(tr,100,30,4);
			count++;
		}
	}
	if (typeof help_id=='undefined') var help_id=pic.parentNode.id+'_help';
	var help=document.getElementById(help_id);
	while (help)
	{
		help.style.display=new_state_2;
		help=help.nextSibling;
		if ((help) && (help.nodeName.toLowerCase()!='p')) break;
	}
	
	trigger_resize();
}

function choose_picture(id,ob,name)
{
	var r=document.getElementById(id);
	if (!r) return;
	var e=r.form.elements[name];
	if (e.length<100)
	{
		for (var i=0;i<e.length;i++)
		{
			if (e[i].disabled) continue;
			var img=e[i].parentNode.parentNode.getElementsByTagName('img')[0];
			if ((img) && (img!=ob))
			{
				img.style.outline='0';
				if (!browser_matches('ie8+')) img.style.background='none';
				if (!browser_matches('no_alpha_ie_with_opacity'))
				{
					setOpacity(img.parentNode,0.5);
					img.parentNode.onmouseover=function(img) { return function()
					{
						setOpacity(img.parentNode,1.0);
					} } (img);
					img.parentNode.onmouseout=function(img) { return function()
					{
						setOpacity(img.parentNode,0.5);
					} } (img);
				}
			}
		}
	}

	if (r.disabled) return;
	r.checked=true;
	//if (r.onclick) r.onclick(); causes loop
	ob.parentNode.onmouseover=function() {};
	ob.parentNode.onmouseout=function() {};
	if (typeof r.fakeonchange!='undefined' && r.fakeonchange) r.fakeonchange();
	if (e.length<100)
	{
		if (!browser_matches('no_alpha_ie_with_opacity')) setOpacity(ob.parentNode,1.0);
		if (!browser_matches('opera')) ob.style.outline='1px dotted';
		if (!browser_matches('ie8+')) ob.style.background='green';
	}
}

function disable_preview_scripts(under)
{
	if (typeof under=='undefined') var under=document;

	var elements,i;
	var no_go=function() {
		window.fauxmodal_alert('{!NOT_IN_PREVIEW_MODE^;}');
		return false;
	};
	elements=under.getElementsByTagName('button');
	for (i=0;i<elements.length;i++)
		elements[i].onclick=no_go;
	elements=under.getElementsByTagName('input');
	for (i=0;i<elements.length;i++)
		if ((elements[i].getAttribute('type')=='button') || (elements[i].getAttribute('type')=='image')) elements[i].onclick=no_go;
	elements=under.getElementsByTagName('a');
	for (i=0;i<elements.length;i++)
		elements[i].target='false_blank'; // Real _blank would trigger annoying CSS. This is better anyway.
}

function setUpChangeMonitor(container,input,container2)
{
	var elements=[];
	if (input)
	{
		elements=[document.getElementById(input)];
	} else
	{
		elements=getAllFormElements(container);
	}
	if (elements.length>300) return;
	for (var i=0;i<elements.length;i++)
	{
		if (!elements[i]) continue;
		if ((typeof elements[0]!='undefined') || (elements[0].id.indexOf('choose_')!=-1)) continue;
		var func=function () {
			if (findIfChildrenSet(input?document.getElementById(input).parentNode:container))
			{
				if (container.className.indexOf(' filledin')==-1) container.className+=' filledin';
				if (container2) if (container2.className.indexOf(' filledin')==-1) container2.className+=' filledin';
			} else
			{
				container.className=container.className.replace(/ filledin$/,'');
				if (container2) container2.className=container2.className.replace(/ filledin$/,'');
			}
		};
		addEventListenerAbstract(elements[i],'blur',func );
		addEventListenerAbstract(elements[i],'change',func );
	}
}

function findIfChildrenSet(container)
{
	var value,blank=true,theElement;
	var elements=getAllFormElements(container);
	for (var i=0;i<elements.length;i++)
	{
		if (!elements[i]) continue;
		theElement=elements[i];
		if (((theElement.type=='hidden') || ((theElement.style.display=='none') && ((typeof window.isWYSIWYGField=='undefined') || (!isWYSIWYGField(theElement))))) && ((!theElement.className) || (theElement.className.indexOf('hidden_but_needed')==-1))) continue;
		value=cleverFindValue(theElement.form,theElement);
		blank=blank & (value=='');
	}
	return !blank;
}

function getAllFormElements(container)
{
	var i;
	var elements1=container.getElementsByTagName('input');
	var elements2=container.getElementsByTagName('select');
	var elements3=container.getElementsByTagName('textarea');
	var elements=[];
	for (i=0;i<elements1.length;i++) elements.push(elements1[i]);
	for (i=0;i<elements2.length;i++) elements.push(elements2[i]);
	for (i=0;i<elements3.length;i++) elements.push(elements3[i]);
	return elements;
}
