<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2012

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		core_form_interfaces
 */

class Hook_addon_registry_core_form_interfaces
{

	/**
	 * Get a list of file permissions to set
	 *
	 * @return array			File permissions to set
	 */
	function get_chmod_array()
	{
		return array();
	}

	/**
	 * Get the version of ocPortal this addon is for
	 *
	 * @return float			Version number
	 */
	function get_version()
	{
		return ocp_version_number();
	}

	/**
	 * Get the description of the addon
	 *
	 * @return string			Description of the addon
	 */
	function get_description()
	{
		return 'Core rendering functionality for forms.';
	}

	/**
	 * Get a mapping of dependency types
	 *
	 * @return array			File permissions to set
	 */
	function get_dependencies()
	{
		return array(
			'requires'=>array(),
			'recommends'=>array(),
			'conflicts_with'=>array(),
		);
	}

	/**
	 * Get a list of files that belong to this addon
	 *
	 * @return array			List of files
	 */
	function get_file_list()
	{
		return array(

			'sources/hooks/systems/addon_registry/core_form_interfaces.php',
			'POSTING_FORM.tpl',
			'POSTING_SCREEN.tpl',
			'HTML_EDIT.tpl',
			'JAVASCRIPT_POSTING.tpl',
			'JAVASCRIPT_EDITING.tpl',
			'JAVASCRIPT_MULTI.tpl',
			'JAVASCRIPT_VALIDATION.tpl',
			'FORM_FIELD_SET_GROUPER.tpl',
			'FORM.tpl',
			'FORM_DESCRIP_SEP.tpl',
			'FORM_GROUP.tpl',
			'FORM_GROUPED.tpl',
			'FORM_SCREEN.tpl',
			'COMCODE_EDITOR.tpl',
			'FORM_SCREEN_FIELD.tpl',
			'FORM_SCREEN_FIELDS_SET_ITEM.tpl',
			'FORM_SCREEN_FIELDS_SET.tpl',
			'FORM_SCREEN_INPUT_ALL_AND_NOT.tpl',
			'FORM_SCREEN_INPUT_DATE.tpl',
			'FORM_SCREEN_INPUT_DATE_NULL.tpl',
			'FORM_SCREEN_INPUT_FLOAT.tpl',
			'FORM_SCREEN_INPUT_HIDDEN.tpl',
			'FORM_SCREEN_INPUT_HIDDEN_2.tpl',
			'FORM_SCREEN_INPUT_HUGE_COMCODE.tpl',
			'FORM_SCREEN_INPUT_HUGE_LIST.tpl',
			'FORM_SCREEN_INPUT_INTEGER.tpl',
			'FORM_SCREEN_INPUT_LINE.tpl',
			'FORM_SCREEN_INPUT_CODENAME.tpl',
			'FORM_SCREEN_INPUT_LINE_MULTI.tpl',
			'FORM_SCREEN_INPUT_TEXT_MULTI.tpl',
			'FORM_SCREEN_INPUT_LIST.tpl',
			'FORM_SCREEN_INPUT_LIST_ENTRY.tpl',
			'FORM_SCREEN_INPUT_MULTI_LIST.tpl',
			'FORM_SCREEN_INPUT_HUGE.tpl',
			'FORM_SCREEN_INPUT_PERMISSION_MATRIX.tpl',
			'FORM_SCREEN_INPUT_PERMISSION_MATRIX_OUTER.tpl',
			'FORM_SCREEN_INPUT_PERMISSION_OVERRIDE.tpl',
			'FORM_SCREEN_INPUT_USERNAME_MULTI.tpl',
			'FORM_SCREEN_INPUT_PASSWORD.tpl',
			'FORM_SCREEN_INPUT_RADIO_LIST.tpl',
			'FORM_SCREEN_INPUT_RADIO_LIST_ENTRY.tpl',
			'FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE.tpl',
			'FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_2.tpl',
			'FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_2_CAT_WRAP.tpl',
			'FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_2_WRAP.tpl',
			'FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_3.tpl',
			'FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_3_NA.tpl',
			'FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_3_WRAP.tpl',
			'FORM_SCREEN_INPUT_TEXT.tpl',
			'FORM_SCREEN_INPUT_TICK.tpl',
			'FORM_SCREEN_INPUT_TIME.tpl',
			'FORM_SCREEN_INPUT_TREE_LIST.tpl',
			'FORM_SCREEN_INPUT_UPLOAD.tpl',
			'FORM_SCREEN_INPUT_UPLOAD_MULTI.tpl',
			'FORM_SCREEN_FIELD_SPACER.tpl',
			'FORM_SCREEN_INPUT_AUTHOR.tpl',
			'FORM_SCREEN_INPUT_COLOUR.tpl',
			'FORM_SCREEN_INPUT_EMAIL.tpl',
			'FORM_SCREEN_INPUT_PERMISSION.tpl',
			'FORM_SCREEN_INPUT_PERMISSION_ADMIN.tpl',
			'FORM_SCREEN_INPUT_USERNAME.tpl',
			'FORM_SCREEN_INPUT_VARIOUS_TICKS.tpl',
			'FORM_STANDARD_END.tpl',
			'BLOCK_HELPER_DONE.tpl',
			'BLOCK_HELPER_START.tpl',
			'BLOCK_HELPER_BLOCK_GROUP.tpl',
			'BLOCK_HELPER_BLOCK_CHOICE.tpl',
			'data/block_helper.php',
			'JAVASCRIPT_AJAX_PEOPLE_LISTS.tpl',
			'JAVASCRIPT_DATE_CHOOSER.tpl',
			'PREVIEW_SCRIPT.tpl',
			'PREVIEW_SCRIPT_CODE.tpl',
			'PREVIEW_SCRIPT_KEYWORD_DENSITY.tpl',
			'PREVIEW_SCRIPT_SPELLING.tpl',
			'data/preview.php',
			'sources/preview.php',
			'date_chooser.css',
			'data/ckeditor/.htaccess',
			'data/ckeditor/ckeditor.js',
			'data/ckeditor/contents.css',
			'data/ckeditor/images/spacer.gif',
			'data/ckeditor/lang/_languages.js',
			'data/ckeditor/lang/_translationstatus.txt',
			'data/ckeditor/lang/af.js',
			'data/ckeditor/lang/ar.js',
			'data/ckeditor/lang/bg.js',
			'data/ckeditor/lang/bn.js',
			'data/ckeditor/lang/bs.js',
			'data/ckeditor/lang/ca.js',
			'data/ckeditor/lang/cs.js',
			'data/ckeditor/lang/cy.js',
			'data/ckeditor/lang/da.js',
			'data/ckeditor/lang/de.js',
			'data/ckeditor/lang/el.js',
			'data/ckeditor/lang/en-au.js',
			'data/ckeditor/lang/en-ca.js',
			'data/ckeditor/lang/en-gb.js',
			'data/ckeditor/lang/en.js',
			'data/ckeditor/lang/eo.js',
			'data/ckeditor/lang/es.js',
			'data/ckeditor/lang/et.js',
			'data/ckeditor/lang/eu.js',
			'data/ckeditor/lang/fa.js',
			'data/ckeditor/lang/fi.js',
			'data/ckeditor/lang/fo.js',
			'data/ckeditor/lang/fr-ca.js',
			'data/ckeditor/lang/fr.js',
			'data/ckeditor/lang/gl.js',
			'data/ckeditor/lang/gu.js',
			'data/ckeditor/lang/he.js',
			'data/ckeditor/lang/hi.js',
			'data/ckeditor/lang/hr.js',
			'data/ckeditor/lang/hu.js',
			'data/ckeditor/lang/is.js',
			'data/ckeditor/lang/it.js',
			'data/ckeditor/lang/ja.js',
			'data/ckeditor/lang/km.js',
			'data/ckeditor/lang/ko.js',
			'data/ckeditor/lang/lt.js',
			'data/ckeditor/lang/lv.js',
			'data/ckeditor/lang/mn.js',
			'data/ckeditor/lang/ms.js',
			'data/ckeditor/lang/nb.js',
			'data/ckeditor/lang/nl.js',
			'data/ckeditor/lang/no.js',
			'data/ckeditor/lang/pl.js',
			'data/ckeditor/lang/pt-br.js',
			'data/ckeditor/lang/pt.js',
			'data/ckeditor/lang/ro.js',
			'data/ckeditor/lang/ru.js',
			'data/ckeditor/lang/sk.js',
			'data/ckeditor/lang/sl.js',
			'data/ckeditor/lang/sr-latn.js',
			'data/ckeditor/lang/sr.js',
			'data/ckeditor/lang/sv.js',
			'data/ckeditor/lang/th.js',
			'data/ckeditor/lang/tr.js',
			'data/ckeditor/lang/uk.js',
			'data/ckeditor/lang/vi.js',
			'data/ckeditor/lang/zh-cn.js',
			'data/ckeditor/lang/zh.js',
			'data/ckeditor/LICENSE.html',
			'data/ckeditor/plugins/a11yhelp/dialogs/a11yhelp.js',
			'data/ckeditor/plugins/a11yhelp/lang/en.js',
			'data/ckeditor/plugins/a11yhelp/lang/he.js',
			'data/ckeditor/plugins/about/dialogs/about.js',
			'data/ckeditor/plugins/about/dialogs/logo_ckeditor.png',
			'data/ckeditor/plugins/autogrow/plugin.js',
			'data/ckeditor/plugins/clipboard/dialogs/paste.js',
			'data/ckeditor/plugins/colordialog/dialogs/colordialog.js',
			'data/ckeditor/plugins/dialog/dialogDefinition.js',
			'data/ckeditor/plugins/div/dialogs/div.js',
			'data/ckeditor/plugins/find/dialogs/find.js',
			'data/ckeditor/plugins/flash/dialogs/flash.js',
			'data/ckeditor/plugins/flash/images/placeholder.png',
			'data/ckeditor/plugins/forms/dialogs/button.js',
			'data/ckeditor/plugins/forms/dialogs/checkbox.js',
			'data/ckeditor/plugins/forms/dialogs/form.js',
			'data/ckeditor/plugins/forms/dialogs/hiddenfield.js',
			'data/ckeditor/plugins/forms/dialogs/radio.js',
			'data/ckeditor/plugins/forms/dialogs/select.js',
			'data/ckeditor/plugins/forms/dialogs/textarea.js',
			'data/ckeditor/plugins/forms/dialogs/textfield.js',
			'data/ckeditor/plugins/forms/images/hiddenfield.gif',
			'data/ckeditor/plugins/iframedialog/plugin.js',
			'data/ckeditor/plugins/image/dialogs/image.js',
			'data/ckeditor/plugins/link/dialogs/anchor.js',
			'data/ckeditor/plugins/link/dialogs/link.js',
			'data/ckeditor/plugins/link/images/anchor.gif',
			'data/ckeditor/plugins/liststyle/dialogs/liststyle.js',
			'data/ckeditor/plugins/pagebreak/images/pagebreak.gif',
			'data/ckeditor/plugins/pastefromword/filter/default.js',
			'data/ckeditor/plugins/pastetext/dialogs/pastetext.js',
			'data/ckeditor/plugins/scayt/dialogs/options.js',
			'data/ckeditor/plugins/scayt/dialogs/toolbar.css',
			'data/ckeditor/plugins/showblocks/images/block_address.png',
			'data/ckeditor/plugins/showblocks/images/block_blockquote.png',
			'data/ckeditor/plugins/showblocks/images/block_div.png',
			'data/ckeditor/plugins/showblocks/images/block_h1.png',
			'data/ckeditor/plugins/showblocks/images/block_h2.png',
			'data/ckeditor/plugins/showblocks/images/block_h3.png',
			'data/ckeditor/plugins/showblocks/images/block_h4.png',
			'data/ckeditor/plugins/showblocks/images/block_h5.png',
			'data/ckeditor/plugins/showblocks/images/block_h6.png',
			'data/ckeditor/plugins/showblocks/images/block_p.png',
			'data/ckeditor/plugins/showblocks/images/block_pre.png',
			'data/ckeditor/plugins/specialchar/dialogs/specialchar.js',
			'data/ckeditor/plugins/styles/styles/default.js',
			'data/ckeditor/plugins/table/dialogs/table.js',
			'data/ckeditor/plugins/ocportal/plugin.js',
			'data/ckeditor/plugins/ocportal/images/block.png',
			'data/ckeditor/plugins/ocportal/images/box.png',
			'data/ckeditor/plugins/ocportal/images/code.png',
			'data/ckeditor/plugins/ocportal/images/comcode.png',
			'data/ckeditor/plugins/ocportal/images/page.png',
			'data/ckeditor/plugins/ocportal/images/quote.png',
			'data/ckeditor/plugins/tableresize/plugin.js',
			'data/ckeditor/plugins/tabletools/dialogs/tableCell.js',
			'data/ckeditor/plugins/templates/dialogs/templates.js',
			'data/ckeditor/plugins/templates/templates/default.js',
			'data/ckeditor/plugins/templates/templates/images/template1.gif',
			'data/ckeditor/plugins/templates/templates/images/template2.gif',
			'data/ckeditor/plugins/templates/templates/images/template3.gif',
			'data/ckeditor/plugins/wsc/dialogs/ciframe.html',
			'data/ckeditor/plugins/wsc/dialogs/tmpFrameset.html',
			'data/ckeditor/plugins/wsc/dialogs/wsc.css',
			'data/ckeditor/plugins/wsc/dialogs/wsc.js',
			'data/ckeditor/skins/kama/dialog.css',
			'data/ckeditor/skins/kama/editor.css',
			'data/ckeditor/skins/kama/icons.png',
			'data/ckeditor/skins/kama/icons_rtl.png',
			'data/ckeditor/skins/kama/images/dialog_sides.gif',
			'data/ckeditor/skins/kama/images/dialog_sides.png',
			'data/ckeditor/skins/kama/images/dialog_sides_rtl.png',
			'data/ckeditor/skins/kama/images/mini.gif',
			'data/ckeditor/skins/kama/images/noimage.png',
			'data/ckeditor/skins/kama/images/sprites.png',
			'data/ckeditor/skins/kama/images/sprites_ie6.png',
			'data/ckeditor/skins/kama/images/toolbar_start.gif',
			'data/ckeditor/skins/kama/skin.js',
			'data/ckeditor/skins/kama/templates.css',
			'data/ckeditor/themes/default/theme.js',
			'data/areaedit/backend.php',
			'data/areaedit/plugins/SpellChecker/output.log',
			'data/areaedit/plugins/SpellChecker/personal_dicts/.htaccess',
			'data/areaedit/plugins/SpellChecker/personal_dicts/index.html',
			'data/areaedit/plugins/SpellChecker/spell-check-logic.php',
			'data/areaedit/plugins/SpellChecker/spell-check-savedicts.php',
			'data/areaedit/plugins/SpellChecker/write.log',
			'data_custom/spelling/index.html',
			'data_custom/spelling/output.log',
			'data_custom/spelling/personal_dicts/.htaccess',
			'data_custom/spelling/personal_dicts/index.html',
			'data_custom/spelling/write.log',
			'themes/default/images/EN/comcodeeditor/apply_changes.png',
			'themes/default/images/EN/comcodeeditor/b.png',
			'themes/default/images/EN/comcodeeditor/quote.png',
			'themes/default/images/EN/comcodeeditor/block.png',
			'themes/default/images/EN/comcodeeditor/box.png',
			'themes/default/images/EN/comcodeeditor/code.png',
			'themes/default/images/EN/comcodeeditor/comcode.png',
			'themes/default/images/EN/comcodeeditor/email.png',
			'themes/default/images/EN/comcodeeditor/hide.png',
			'themes/default/images/EN/comcodeeditor/html.png',
			'themes/default/images/EN/comcodeeditor/i.png',
			'themes/default/images/EN/comcodeeditor/img.png',
			'themes/default/images/EN/comcodeeditor/index.html',
			'themes/default/images/EN/comcodeeditor/list.png',
			'themes/default/images/EN/comcodeeditor/page.png',
			'themes/default/images/EN/comcodeeditor/s.png',
			'themes/default/images/EN/comcodeeditor/thumb.png',
			'themes/default/images/EN/comcodeeditor/u.png',
			'themes/default/images/EN/comcodeeditor/url.png',
			'sources/form_templates.php',
			'themes/default/images/date_chooser/callt.gif',
			'themes/default/images/date_chooser/calrt.gif',
			'themes/default/images/date_chooser/calx.gif',
			'themes/default/images/date_chooser/index.html',
			'themes/default/images/date_chooser/pdate.gif',
			'data/namelike.php',
			'data/username_exists.php',
		);
	}


	/**
	* Get mapping between template names and the method of this class that can render a preview of them
	*
	* @return array			The mapping
	*/
	function tpl_previews()
	{
		return array(
				'FORM_STANDARD_END.tpl'=>'form_screen_2',
				'FORM_SCREEN.tpl'=>'form_screen_2',
				'FORM_SCREEN_FIELD_SPACER.tpl'=>'form_screen_1',
				'FORM.tpl'=>'form_screen_1',
				'POSTING_SCREEN.tpl'=>'posting_screen',
				'FORM_SCREEN_INPUT_LIST_ENTRY.tpl'=>'form_screen_1',
				'FORM_GROUP.tpl'=>'form_group',
				'FORM_GROUPED.tpl'=>'form_grouped',
				'FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_3.tpl'=>'form_screen',
				'FORM_FIELD_SET_GROUPER.tpl'=>'form_field_set_grouper',
				'PREVIEW_SCRIPT_SPELLING.tpl'=>'preview_script_spelling',
				'PREVIEW_SCRIPT_KEYWORD_DENSITY.tpl'=>'preview_script_keyword_density',
				'PREVIEW_SCRIPT_CODE.tpl'=>'preview_script_code',
				'FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE.tpl'=>'form_screen',
				'HTML_EDIT.tpl'=>'html_edit',
				'POSTING_FORM.tpl'=>'posting_form',
				'COMCODE_MESSAGE.tpl'=>'form_screen_1',
				'COMCODE_EDITOR.tpl'=>'posting_form',
				'COMCODE_EDITOR_BUTTON.tpl'=>'posting_form',
				'COMCODE_EDITOR_MICRO_BUTTON.tpl'=>'posting_form',
				'FORM_SCREEN_INPUT_CODENAME.tpl'=>'form_screen_1',
				'FORM_SCREEN_INPUT_LINE.tpl'=>'form_screen_1',
				'FORM_SCREEN_FIELDS_SET_ITEM.tpl'=>'form_screen_1',
				'FORM_SCREEN_FIELDS_SET.tpl'=>'form_screen_1',
				'FORM_SCREEN_INPUT_USERNAME.tpl'=>'form_screen_2',
				'FORM_DESCRIP_SEP.tpl'=>'form_descrip_sep',
				'FORM_SCREEN_INPUT_AUTHOR.tpl'=>'form_screen_1',
				'FORM_SCREEN_INPUT_EMAIL.tpl'=>'form_screen_1',
				'FORM_SCREEN_INPUT_COLOUR.tpl'=>'form_screen_1',
				'FORM_SCREEN_INPUT_LINE_MULTI.tpl'=>'form_screen_2',
				'FORM_SCREEN_INPUT_TEXT_MULTI.tpl'=>'form_screen_2',
				'FORM_SCREEN_INPUT_USERNAME_MULTI.tpl'=>'form_screen_2',
				'FORM_SCREEN_INPUT_TEXT.tpl'=>'form_screen_1',
				'FORM_SCREEN_INPUT_HUGE_COMCODE.tpl'=>'form_screen_1',
				'FORM_SCREEN_INPUT_HUGE.tpl'=>'form_screen_1',
				'FORM_SCREEN_INPUT_PASSWORD.tpl'=>'form_screen_2',
				'FORM_SCREEN_INPUT_TICK.tpl'=>'form_screen_1',
				'FORM_SCREEN_INPUT_VARIOUS_TICKS.tpl'=>'form_screen_2',
				'FORM_SCREEN_INPUT_UPLOAD.tpl'=>'form_screen_2',
				'FORM_SCREEN_INPUT_UPLOAD_MULTI.tpl'=>'form_screen_2',
				'FORM_SCREEN_INPUT_LIST.tpl'=>'form_screen_2',
				'FORM_SCREEN_INPUT_TREE_LIST.tpl'=>'form_screen_2',
				'FORM_SCREEN_INPUT_HUGE_LIST.tpl'=>'form_screen_2',
				'FORM_SCREEN_INPUT_MULTI_LIST.tpl'=>'form_screen_2',
				'FORM_SCREEN_INPUT_ALL_AND_NOT.tpl'=>'form_screen_1',
				'FORM_SCREEN_INPUT_RADIO_LIST.tpl'=>'form_screen_2',
				'FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_2.tpl'=>'form_screen',
				'FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_2_WRAP.tpl'=>'form_screen',
				'FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_2_CAT_WRAP.tpl'=>'form_screen',
				'FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_3_WRAP.tpl'=>'form_screen',
				'POSTING_FIELD.tpl'=>'form_screen',
				'FORM_SCREEN_INPUT_TIME.tpl'=>'form_screen_1',
				'FORM_SCREEN_INPUT_DATE_NULL.tpl'=>'form_screen_1',
				'FORM_SCREEN_INPUT_DATE.tpl'=>'form_screen_1',
				'FORM_SCREEN_INPUT_INTEGER.tpl'=>'form_screen_2',
				'FORM_SCREEN_INPUT_FLOAT.tpl'=>'form_screen_1',
				'FORM_SCREEN_INPUT_HIDDEN_2.tpl'=>'form_screen_2',
				'FORM_SCREEN_FIELD.tpl'=>'form_screen_1',
				'FORM_SCREEN_INPUT_RADIO_LIST_ENTRY.tpl'=>'form_screen_2',
				'FORM_SCREEN_INPUT_PERMISSION_OVERRIDE.tpl'=>'administrative__form_screen_input_permission',
				'FORM_SCREEN_INPUT_PERMISSION.tpl'=>'administrative__form_screen_input_permission',
				'FORM_SCREEN_INPUT_PERMISSION_ADMIN.tpl'=>'administrative__form_screen_input_permission',
				'FORM_SCREEN_INPUT_PERMISSION_MATRIX.tpl'=>'administrative__form_screen_input_permission',
				'FORM_SCREEN_INPUT_PERMISSION_MATRIX_OUTER.tpl'=>'administrative__form_screen_input_permission',
				'FORM_SCREEN_INPUT_HIDDEN.tpl'=>'form_screen_2',
				'PREVIEW_SCRIPT.tpl'=>'preview_script',
				'BLOCK_HELPER_BLOCK_CHOICE.tpl'=>'administrative__block_helper_block_group',
				'BLOCK_HELPER_BLOCK_GROUP.tpl'=>'administrative__block_helper_block_group',
				'BLOCK_HELPER_START.tpl'=>'administrative__block_helper_start',
				'BLOCK_HELPER_DONE.tpl'=>'administrative__block_helper_done',
				'FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_3_NA.tpl'=>'form_screen'
			);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__form_screen_1()
	{
		require_lang('comcode');
		require_lang('dates');
		require_javascript('javascript_yahoo_2');
		require_javascript('javascript_colour_picker');
		require_javascript('javascript_theme_colours');

		$fields	= new ocp_tempcode();
		$list =	new ocp_tempcode();

		$name = placeholder_random_id();
		$_input1 = do_lorem_template('FORM_SCREEN_INPUT_LINE',array('MAXLENGTH'=>placeholder_number(),'TABINDEX'=>placeholder_number(),'REQUIRED'=>'','NAME'=>$name.'1','DEFAULT'=>''));
		$input1 = do_lorem_template('FORM_SCREEN_FIELDS_SET_ITEM',array('SET_NAME'=>$name,'REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>$name.'1','NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$_input1,'COMCODE'=>''));
		$_input2 = do_lorem_template('FORM_SCREEN_INPUT_LINE',array('MAXLENGTH'=>placeholder_number(),'TABINDEX'=>placeholder_number(),'REQUIRED'=>'','NAME'=>$name.'2','DEFAULT'=>''));
		$input2 = do_lorem_template('FORM_SCREEN_FIELDS_SET_ITEM',array('SET_NAME'=>$name,'REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>$name.'2','NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$_input2,'COMCODE'=>''));
		$inputs = new ocp_tempcode();
		$inputs->attach($_input1);
		$inputs->attach($_input2);
		$fieldset = do_lorem_template('FORM_SCREEN_FIELDS_SET',array('SET_NAME'=>$name,'FIELDS'=>$inputs,'REQUIRED'=>true));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$fieldset,'COMCODE'=>'')));

		$name = placeholder_random_id();
		$input = do_lorem_template('FORM_SCREEN_INPUT_TEXT',array('RAW'=>true,'SCROLLS'=>'','TABINDEX'=>placeholder_number(),'REQUIRED'=>'','NAME'=>$name,'DEFAULT'=>''));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$name = placeholder_random_id();
		$input = do_lorem_template('FORM_SCREEN_INPUT_CODENAME',array('MAXLENGTH'=>placeholder_number(),'TABINDEX'=>placeholder_number(),'REQUIRED'=>'','NAME'=>$name,'DEFAULT'=>''));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$name = placeholder_random_id();
		$input = do_lorem_template('FORM_SCREEN_INPUT_TICK',array('CHECKED'=>'true','TABINDEX'=>placeholder_number(),'NAME'=>$name));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD_SPACER',array('SECTION_HIDDEN'=>false,'TITLE'=>lorem_phrase(),'THEME_ALSO_INCLUDE_PAGES'=>false)));
		foreach (placeholder_array() as $key=>$value)
		{
			$list->attach(do_lorem_template('FORM_SCREEN_INPUT_LIST_ENTRY',array('SELECTED'=>false,'DISABLED'=>false,'CLASS'=>'','NAME'=>placeholder_random_id(),'TEXT'=>lorem_phrase())));
		}
		$radios = new ocp_tempcode();
		$name = placeholder_random_id();
		$radios->attach(do_lorem_template('FORM_SCREEN_INPUT_RADIO_LIST_ENTRY',array('DESCRIPTION'=>lorem_sentence(),'CHECKED'=>'true','TABINDEX'=>placeholder_number(),'NAME'=>$name,'VALUE'=>placeholder_random(),'TEXT'=>lorem_phrase())));
		$radios->attach(do_lorem_template('FORM_SCREEN_INPUT_RADIO_LIST_ENTRY',array('DESCRIPTION'=>lorem_sentence(),'CHECKED'=>'false','TABINDEX'=>placeholder_number(),'NAME'=>$name,'VALUE'=>placeholder_random(),'TEXT'=>lorem_phrase())));
		$radios->attach(do_lorem_template('FORM_SCREEN_INPUT_RADIO_LIST_ENTRY',array('DESCRIPTION'=>lorem_sentence(),'CHECKED'=>'false','TABINDEX'=>placeholder_number(),'NAME'=>$name,'VALUE'=>placeholder_random(),'TEXT'=>lorem_phrase())));

		$name = placeholder_random_id();
		$input=do_lorem_template('FORM_SCREEN_INPUT_ALL_AND_NOT',array('TABINDEX'=>placeholder_number(),'BASE'=>$name,'RADIOS'=>$radios,'LIST'=>$list));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>$name.'_list','NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$name = placeholder_random_id();
		$input = do_lorem_template('FORM_SCREEN_INPUT_AUTHOR',array('TABINDEX'=>placeholder_number(),'REQUIRED'=>'','NAME'=>$name,'DEFAULT'=>''));
		$_description = new ocp_tempcode();
		$_description->attach(lorem_phrase());
		$_description->attach(do_lorem_template('FORM_DESCRIP_SEP'));
		$extra = do_lorem_template('HYPERLINK_POPUP_WINDOW',array('URL'=>placeholder_url(),'TITLE'=>lorem_phrase(),'CAPTION'=>lorem_phrase()));
		$_description->attach($extra);

		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>$_description,'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$fields->attach(do_lorem_template('FORM_SCREEN_INPUT_COLOUR',array('TRUE_FIELD'=>false,'REQUIRED'=>'','PRETTY_NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence(),'TABINDEX'=>placeholder_number(),'_REQUIRED'=>'','NAME'=>lorem_word(),'DEFAULT'=>'')));

		// Dates
		$start_year = intval(date('Y'))-1;
		$start_month = intval(date('m'));
		$start_day = intval(date('d'));
		$start_hour = intval(date('H'));
		$start_minute = intval(date('i'));

		$name = placeholder_random_id();
		$time = do_lorem_template('FORM_SCREEN_INPUT_TIME',array('NULL_OK'=>'','DISABLED'=>'','TABINDEX'=>placeholder_number(),'MINUTES'=>placeholder_options(),'HOURS'=>placeholder_options(),'STUB'=>placeholder_random_id()));
		$input = do_lorem_template('FORM_SCREEN_INPUT_DATE',array('UNLIMITED'=>false,'NULL_OK'=>'','DISABLED'=>'','TABINDEX'=>placeholder_number(),'YEARS'=>placeholder_options(),'MONTHS'=>placeholder_options(),'DAYS'=>placeholder_options(),'STUB'=>$name,'NULL'=>'','TIME'=>$time));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>true,'BORING_NAME'=>'','NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$name = placeholder_random_id();
		$input = do_lorem_template('FORM_SCREEN_INPUT_EMAIL',array('TABINDEX'=>placeholder_number(),'REQUIRED'=>'','NAME'=>$name,'DEFAULT'=>''));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$name = placeholder_random_id();
		$input = do_lorem_template('FORM_SCREEN_INPUT_FLOAT',array('TABINDEX'=>placeholder_number(),'REQUIRED'=>'','NAME'=>$name,'DEFAULT'=>''));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$fields->attach(do_lorem_template('FORM_SCREEN_INPUT_HUGE',array('RAW'=>true,'SCROLLS'=>'','DESCRIPTION_SIDE'=>lorem_sentence(),'REQUIRED'=>'','_REQUIRED'=>'','TABINDEX'=>placeholder_number(),'PRETTY_NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence(),'NAME'=>placeholder_random_id(),'DEFAULT'=>'','ROWS'=>"20")));

		$_comcode = do_lorem_template('COMCODE_MESSAGE',array('NAME'=>lorem_word(),'W'=>'','URL'=>placeholder_url()));
		$fields->attach(do_lorem_template('FORM_SCREEN_INPUT_HUGE_COMCODE',array('SCROLLS'=>'','DESCRIPTION_SIDE'=>lorem_sentence(),'REQUIRED'=>'wysiwyg','_REQUIRED'=>'wysiwyg','TABINDEX'=>placeholder_number(),'COMCODE'=>$_comcode,'PRETTY_NAME'=>lorem_word(),'DESCRIPTION'=>lorem_phrase(),'NAME'=>placeholder_random_id(),'DEFAULT'=>lorem_word(),'DEFAULT_PARSED'=>lorem_word(),'ROWS'=>"20")));

		$hidden = do_lorem_template('FORM_SCREEN_INPUT_DATE_NULL',array('STUB'=>placeholder_random_id()));

		return array(
			lorem_globalise(
				do_lorem_template('FORM',array(
					'GET'=>NULL,
					'SKIP_VALIDATION'=>true,
					'HIDDEN'=>$hidden,
					'TITLE'=>lorem_title(),
					'URL'=>placeholder_url(),
					'FIELDS'=>$fields,
					'SUBMIT_NAME'=>lorem_word(),
					'TEXT'=>lorem_sentence_html(),
						)
			),NULL,'',true),
		);
	}

/**
	* Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	* Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	* Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	*
	* @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	*/
	function tpl_preview__form_screen_2()
	{
		require_lang('comcode');
		require_lang('dates');

		$fields	= new ocp_tempcode();
		$list =	new ocp_tempcode();

		$entries = new ocp_tempcode();
		foreach (placeholder_array() as $val)
		{
			$entries->attach(do_lorem_template('FORM_SCREEN_INPUT_LIST_ENTRY',array('SELECTED'=>'','DISABLED'=>'','CLASS'=>'','NAME'=>placeholder_random_id(),'TEXT'=>lorem_phrase())));
		}
		$fields->attach(do_lorem_template('FORM_SCREEN_INPUT_HUGE_LIST',array('TABINDEX'=>placeholder_number(),'REQUIRED'=>'','PRETTY_NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence(),'NAME'=>placeholder_random_id(),'CONTENT'=>$entries,'INLINE_LIST'=>false)));

		$name = placeholder_random_id();
		$input = do_lorem_template('FORM_SCREEN_INPUT_INTEGER',array('TABINDEX'=>placeholder_number(),'REQUIRED'=>'','NAME'=>$name,'DEFAULT'=>''));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$input = new ocp_tempcode();
		foreach (placeholder_array(1) as $k=>$v)
		{
			$input->attach(do_lorem_template('FORM_SCREEN_INPUT_LINE_MULTI',array('CLASS'=>'','MAXLENGTH'=>'10','PRETTY_NAME'=>$v,'TABINDEX'=>placeholder_random_id(),'NAME_STUB'=>placeholder_random_id(),'I'=>strval($k),'REQUIRED'=>'_required','DEFAULT'=>'')));
		}

		foreach (placeholder_array(2) as $k=>$v)
		{
			$input->attach(do_lorem_template('FORM_SCREEN_INPUT_TEXT_MULTI',array('PRETTY_NAME'=>lorem_word(),'TABINDEX'=>placeholder_number(),'NAME_STUB'=>placeholder_random_id(),'I'=>strval($k),'REQUIRED'=>'_required','DEFAULT'=>'')));
		}
		$name = placeholder_random_id();
		$hidden = do_lorem_template('FORM_SCREEN_INPUT_HIDDEN_2',array('NAME'=>$name,'VALUE'=>lorem_phrase()));
		
		$name = placeholder_random_id();
		foreach (placeholder_array() as $key=>$value)
		{
			$list->attach(do_lorem_template('FORM_SCREEN_INPUT_LIST_ENTRY',array('SELECTED'=>'','DISABLED'=>'','CLASS'=>'','NAME'=>$value,'TEXT'=>lorem_phrase())));
		}

		$name = placeholder_random_id();
		$input = do_lorem_template('FORM_SCREEN_INPUT_LIST',array('TABINDEX'=>placeholder_number(),'REQUIRED'=>'','NAME'=>$name,'CONTENT'=>$list,'INLINE_LIST'=>false));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$name = placeholder_random_id();
		$input = do_lorem_template('FORM_SCREEN_INPUT_MULTI_LIST',array('TABINDEX'=>placeholder_number(),'SIZE'=>'5','NAME'=>$name,'CONTENT'=>$list));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$name = placeholder_random_id();
		$input = do_lorem_template('FORM_SCREEN_INPUT_PASSWORD',array('TABINDEX'=>placeholder_number(),'REQUIRED'=>'','NAME'=>$name,'VALUE'=>''));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$name = placeholder_random_id();
		$radios = do_lorem_template('FORM_SCREEN_INPUT_RADIO_LIST_ENTRY',array('DESCRIPTION'=>lorem_phrase(),'CHECKED'=>'true','TABINDEX'=>placeholder_number(),'NAME'=>$name,'VALUE'=>lorem_word(),'TEXT'=>lorem_phrase()));
		$radios->attach(do_lorem_template('FORM_SCREEN_INPUT_RADIO_LIST_ENTRY',array('DESCRIPTION'=>lorem_phrase(),'CHECKED'=>'true','TABINDEX'=>placeholder_number(),'NAME'=>$name,'VALUE'=>lorem_word_2(),'TEXT'=>lorem_phrase())));
		$input = do_lorem_template('FORM_SCREEN_INPUT_RADIO_LIST',array('CONTENT'=>$radios));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>true,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$name = placeholder_random_id();
		$input = do_lorem_template('FORM_SCREEN_INPUT_TREE_LIST',array('NICE_LABEL'=>'','USE_SERVER_ID'=>placeholder_id(),'TABINDEX'=>placeholder_number(),'NAME'=>$name,'REQUIRED'=>'','DEFAULT'=>'','HOOK'=>'','ROOT_ID'=>'','OPTIONS'=>serialize('')));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$name = placeholder_random_id();
		$input = do_lorem_template('FORM_SCREEN_INPUT_UPLOAD',array('FILTER'=>'','EXISTING_URL'=>placeholder_url(),'IS_IMAGE'=>'','SWFUPLOAD'=>false,'EDIT'=>'','TABINDEX'=>placeholder_number(),'REQUIRED'=>'','NAME'=>$name));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$name = placeholder_random_id();
		$input = do_lorem_template('FORM_SCREEN_INPUT_UPLOAD_MULTI',array('TABINDEX'=>placeholder_number(),'FILTER'=>'','SWFUPLOAD'=>false,'REQUIRED'=>'','NAME'=>$name,'I'=>$name,'NAME_STUB'=>lorem_word()));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>true,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$name = placeholder_random_id();
		$input = do_lorem_template('FORM_SCREEN_INPUT_USERNAME',array('TABINDEX'=>placeholder_number(),'NEEDS_MATCH'=>true,'REQUIRED'=>'','NAME'=>$name,'DEFAULT'=>''));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$name = placeholder_random_id();
		$input = new ocp_tempcode();
		foreach (placeholder_array() as $k=>$v)
		{
			$input->attach(do_lorem_template('FORM_SCREEN_INPUT_USERNAME_MULTI',array('PRETTY_NAME'=>lorem_word(),'TABINDEX'=>placeholder_number(),'NEEDS_MATCH'=>true,'NAME_STUB'=>$name,'I'=>strval($k),'REQUIRED'=>'','DEFAULT'=>'')));
		}
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>true,'BORING_NAME'=>placeholder_random_id(),'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$input = new ocp_tempcode();
		$options = array(
						array('option1','opt1',true,''),
						array('option2','opt2',true,''),
						array('option3','opt3',true,''),
					);
		if (count($options[0])!=3)
		{
			$options = array(array($options,NULL,new ocp_tempcode()));
		}

		foreach ($options as $_option)
		{
			$out = array();
			foreach ($_option[0] as $option)
			{
				$out[] = array('DISABLED'=>false,'CHECKED'=>lorem_word(),'TABINDEX'=>placeholder_number(),'NAME'=>placeholder_random_id(),'PRETTY_NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence());
			}

			$input->attach(do_lorem_template('FORM_SCREEN_INPUT_VARIOUS_TICKS',array('SECTION_TITLE'=>$_option[2],'EXPANDED'=>$_option[1],'SIMPLE_STYLE'=>false,'BRETHREN_COUNT'=>"3",'OUT'=>$out)));
		}
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>true,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$hidden->attach(do_lorem_template('FORM_SCREEN_INPUT_HIDDEN',array('NAME'=>lorem_word(),'VALUE'=>lorem_word())));

		return array(
			lorem_globalise(
				do_lorem_template('FORM_SCREEN',array(
					'GET'=>NULL,
					'SKIP_VALIDATION'=>true,
					'HIDDEN'=>$hidden,
					'TITLE'=>lorem_title(),
					'URL'=>placeholder_url(),
					'FIELDS'=>$fields,
					'SUBMIT_NAME'=>lorem_word(),
					'TEXT'=>lorem_sentence_html(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__posting_screen()
	{
		return array(
			lorem_globalise(
				do_lorem_template('POSTING_SCREEN',array(
					'POSTING_FORM'=>placeholder_form(),
					'HIDDEN'=>'',
					'TITLE'=>lorem_title(),
					'TEXT'=>lorem_sentence_html(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__form_group()
	{
		return array(
			lorem_globalise(
				do_lorem_template('FORM_GROUP',array(
					'FIELDS'=>placeholder_fields(),
					'HIDDEN'=>'',
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__form_grouped()
	{
		return array(
			lorem_globalise(
				do_lorem_template('FORM_GROUPED',array(
					'TEXT'=>lorem_sentence_html(),
					'FIELD_GROUPS'=>lorem_phrase(),
					'SUBMIT_NAME'=>lorem_word(),
					'SUBMIT_BUTTON_CLASS'=>lorem_phrase(),
					'URL'=>placeholder_url(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__form_field_set_grouper()
	{
		return array(
			lorem_globalise(
				do_lorem_template('FORM_FIELD_SET_GROUPER',array(
					'NAME'=>lorem_word(),
					'ID'=>placeholder_random_id(),
					'FIELDS'=>placeholder_fields(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__preview_script_spelling()
	{
		return array(
			lorem_globalise(
				do_lorem_template('PREVIEW_SCRIPT_SPELLING',array(
					'FIELD'=>lorem_phrase(),
					'MISSPELLINGS'=>array(array('WORD'=>'batt','CORRECTIONS'=>'bat'),array('WORD'=>'caat','CORRECTIONS'=>'cat')),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__preview_script_keyword_density()
	{
		return array(
			lorem_globalise(
				do_lorem_template('PREVIEW_SCRIPT_KEYWORD_DENSITY',array(
					'FIELD'=>lorem_phrase(),
					'KEYWORDS'=>placeholder_array(),
					'KEYWORD'=>lorem_word(),
					'DENSITY'=>placeholder_id(),
					'IDEAL_DENSITY'=>placeholder_number(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__preview_script_code()
	{
		return array(
			lorem_globalise(
				do_lorem_template('PREVIEW_SCRIPT_CODE',array(
					'NEW_POST_VALUE_HTML'=>lorem_phrase(),
					'NEW_POST_VALUE'=>lorem_phrase(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__form_screen()
	{
		require_lang('comcode');
		require_lang('dates');
		$input = new ocp_tempcode();
		$fields = new ocp_tempcode();
		foreach (placeholder_array(1) as $key=>$val)
		{
			$input=do_lorem_template('FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE',array('CHECKED'=>true,'NAME'=>'path','VALUE'=>$val,'URL'=>placeholder_image_url(),'PRETTY'=>strval($key)));
			$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>'path'."_".$val,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));
		}
		$content = new ocp_tempcode();
		$i = 0;
		foreach (placeholder_array() as $k=>$v)
		{
			$cells = new ocp_tempcode();
			foreach (placeholder_array() as $k=>$v)
			{
				$temp = do_lorem_template('FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_2',array('CHECKED'=>'true','PRETTY'=>lorem_phrase(),'NAME'=>placeholder_random_id(),'CODE'=>$v,'URL'=>placeholder_image_url()));
				$temp->attach(do_lorem_template('FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_3_NA',array('NAME'=>placeholder_random_id())));
			}

			$_category = do_lorem_template('FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_2_WRAP',array('ROWS'=>$cells));
			$input = do_lorem_template('FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_2_CAT_WRAP',array('DISPLAY'=>'block','CATEGORY'=>$_category,'CATEGORY_NAME'=>lorem_word()));
			$content->attach($input);
		}
		//$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>false,'BORING_NAME'=>placeholder_random(),'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$content,'COMCODE'=>'')));
		$name = placeholder_random_id();
		$input = do_lorem_template('FORM_SCREEN_INPUT_RADIO_LIST',array('NAME'=>$name,'CODE'=>'','TABINDEX'=>placeholder_number(),'CONTENT'=>$content));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>true,'BORING_NAME'=>$name,'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$input,'COMCODE'=>'')));

		$entries = array();
		$first = true;
		foreach (placeholder_array() as $k=>$v)
		{
			$entries[] = do_lorem_template('FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_3',array('PRETTY'=>lorem_word(),'CHECKED'=>$first,'NAME'=>placeholder_random_id(),'CODE'=>lorem_word(),'URL'=>placeholder_image_url()));
			$first = false;
		}

		$content = new ocp_tempcode();
		foreach ($entries as $i=>$tempcode)
		{
			$content->attach($tempcode);
		}

		$content = do_lorem_template('FORM_SCREEN_INPUT_RADIO_LIST_ENTRY_PICTURE_3_WRAP',array('ROWS'=>$content));
		$fields->attach(do_lorem_template('FORM_SCREEN_FIELD',array('REQUIRED'=>true,'SKIP_LABEL'=>true,'BORING_NAME'=>placeholder_random_id(),'NAME'=>lorem_word(),'DESCRIPTION'=>lorem_sentence_html(),'DESCRIPTION_SIDE'=>'','INPUT'=>$content,'COMCODE'=>'')));
		//$fields->attach($content);

		$fields->attach(do_lorem_template('POSTING_FIELD', array(
			'REQUIRED'=>true,
			'DESCRIPTION'=>lorem_phrase(),
			'HIDDEN_FIELDS'=>'',
			'PRETTY_NAME'=>lorem_word(),
			'NAME'=>placeholder_random_id(),
			'TABINDEX_PF'=>placeholder_random(),
			'COMCODE_EDITOR'=>placeholder_blank(),
			'COMCODE_EDITOR_SMALL'=>placeholder_blank(),
			'CLASS'=>lorem_word(),
			'COMCODE_URL'=>placeholder_url(),
			'EMOTICON_CHOOSER'=>placeholder_emoticon_chooser(),
			'COMCODE_HELP'=>placeholder_blank(),
			'POST'=>placeholder_blank(),
			'DEFAULT_PARSED'=>placeholder_blank(),
			'ATTACHMENTS'=>placeholder_blank()
		)));

		return array(
			lorem_globalise(
				do_lorem_template('FORM_SCREEN',array(
					'GET'=>NULL,
					'HIDDEN'=>'',
					'TITLE'=>lorem_title(),
					'URL'=>placeholder_url(),
					'FIELDS'=>$fields,
					'SUBMIT_NAME'=>lorem_word(),
					'TEXT'=>lorem_sentence_html(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__html_edit()
	{
		return array(
			lorem_globalise(
				do_lorem_template('HTML_EDIT',array(
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__posting_form()
	{
		require_lang('comcode');
		require_lang('dates');


		$buttons = new ocp_tempcode();
		$_buttons = array('img','thumb','url','page','code','quote','hide','box','block','list','html');
		foreach ($_buttons as $button)
		{
			$buttons->attach(do_lorem_template('COMCODE_EDITOR_BUTTON',array('DIVIDER'=>true,'FIELD_NAME'=>lorem_word(),'TITLE'=>lorem_phrase(),'B'=>$button)));
		}

		$micro_buttons = new ocp_tempcode();
		$_micro_buttons = array(
			array('t'=>'b'),
			array('t'=>'i'),
		);

		foreach ($_micro_buttons as $button)
		{
			$micro_buttons->attach(do_lorem_template('COMCODE_EDITOR_MICRO_BUTTON',array('FIELD_NAME'=>lorem_word(),'TITLE'=>lorem_phrase(),'B'=>$button['t'])));
		}

		$comcode = do_lorem_template('COMCODE_EDITOR',array(
					'POSTING_FIELD'=>lorem_word(),
					'BUTTONS'=>$buttons,
					'MICRO_BUTTONS'=>$micro_buttons
				));


		return array(
			lorem_globalise(
				do_lorem_template('POSTING_FORM',array(
					'TABINDEX_PF'=>placeholder_number(),
					'JAVASCRIPT'=>'',
					'PREVIEW'=>lorem_phrase(),
					'COMCODE_EDITOR'=>$comcode,
					'COMCODE_EDITOR_SMALL'=>lorem_phrase(),
					'CLASS'=>lorem_phrase(),
					'COMCODE_URL'=>placeholder_url(),
					'EXTRA'=>lorem_phrase(),
					'POST_COMMENT'=>lorem_phrase(),
					'EMOTICON_CHOOSER'=>lorem_phrase(),
					'SUBMIT_NAME'=>lorem_word(),
					'HIDDEN_FIELDS'=>'',
					'COMCODE_HELP'=>lorem_phrase(),
					'URL'=>placeholder_url(),
					'POST'=>lorem_phrase(),
					'DEFAULT_PARSED'=>lorem_phrase(),
					'CONTINUE_URL'=>placeholder_url(),
					'ATTACHMENTS'=>lorem_phrase(),
					'SPECIALISATION'=>placeholder_fields(),
					'SPECIALISATION2'=>placeholder_fields(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__form_descrip_sep()
	{
		return array(
			lorem_globalise(
				do_lorem_template('FORM_DESCRIP_SEP',array(
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__administrative__form_screen_input_permission()
	{
		require_lang('permissions');
		$permission_rows = new ocp_tempcode();
		foreach (placeholder_array() as $k=>$v)
		{
			$overrides = new ocp_tempcode();
			$all_global = true;
			foreach (placeholder_array() as $k=>$v)
			{
				$overrides->attach(do_lorem_template('FORM_SCREEN_INPUT_PERMISSION_OVERRIDE',array('FORCE_PRESETS'=>false,'GROUP_NAME'=>lorem_phrase(),'VIEW_ACCESS'=>'','TABINDEX'=>placeholder_number(),'GROUP_ID'=>placeholder_random_id(),'SP'=>strval($k),'ALL_GLOBAL'=>true,'TITLE'=>lorem_phrase(),'DEFAULT_ACCESS'=>'','CODE'=>'-1')));
			}

			$permission_rows->attach(do_lorem_template('FORM_SCREEN_INPUT_PERMISSION',array('FORCE_PRESETS'=>false,'GROUP_NAME'=>lorem_phrase(),'OVERRIDES'=>$overrides->evaluate()/*FUDGEFUDGE*/,'ALL_GLOBAL'=>true,'VIEW_ACCESS'=>'','TABINDEX'=>placeholder_number(),'GROUP_ID'=>placeholder_random_id(),'PINTERFACE_VIEW'=>'')));
		}

		$permission_rows->attach(do_lorem_template('FORM_SCREEN_INPUT_PERMISSION_MATRIX_OUTER',array(
					'INNER'=>lorem_word()
				)));

		$permission_rows->attach(do_lorem_template('FORM_SCREEN_INPUT_PERMISSION_ADMIN',array(
					'PINTERFACE_VIEW'=>lorem_word(),
					'GROUP_ID'=>placeholder_random_id(),
					'GROUP_NAME'=>lorem_phrase(),
					'FORCE_PRESETS'=>false,
					'OVERRIDES'=>placeholder_array(),
				)));

		$field = do_lorem_template('FORM_SCREEN_INPUT_PERMISSION_MATRIX',array(
					'TITLE'=>lorem_phrase(),
					'SERVER_ID'=>placeholder_id(),
					'COLOR'=>lorem_word(),
					'OVERRIDES'=>placeholder_array(),
					'PERMISSION_ROWS'=>$permission_rows
				));

		return array(
			lorem_globalise(
				do_lorem_template('FORM_GROUPED',array(
					'URL'=>'#',
					'FIELD_GROUPS'=>$field,
					'TEXT'=>'',
					'SUBMIT_NAME'=>lorem_word_2(),
				)),NULL,'',true
			),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__preview_script()
	{
		return array(
			lorem_globalise(
				do_lorem_template('PREVIEW_SCRIPT',array(
					'OUTPUT'=>lorem_phrase(),
					'HIDDEN'=>'',
					'VALIDATION'=>placeholder_id(),
					'KEYWORD_DENSITY'=>lorem_phrase(),
					'SPELLING'=>lorem_phrase(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__administrative__block_helper_block_group()
	{
		$links = new ocp_tempcode();
		foreach (placeholder_array() as $v)
		{
			$links->attach(do_lorem_template('BLOCK_HELPER_BLOCK_CHOICE',array(
					'USAGE'=>placeholder_array(),
					'DESCRIPTION'=>lorem_paragraph_html(),
					'URL'=>placeholder_url(),
					'LINK_CAPTION'=>lorem_phrase(),
						)
			));
		}
		return array(
			lorem_globalise(
				do_lorem_template('BLOCK_HELPER_BLOCK_GROUP',array(
					'IMG'=>'themes/default/images/bigicons/add_one.png',
					'TITLE'=>lorem_phrase(),
					'LINKS'=>$links,
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__administrative__block_helper_start()
	{
		require_lang('comcode');
		return array(
			lorem_globalise(
				do_lorem_template('BLOCK_HELPER_START',array(
					'GET'=>false,
					'TITLE'=>lorem_phrase(),
					'LINKS'=>placeholder_link(),
						)
			),NULL,'',true),
		);
	}

	/**
	 * Get a preview(s) of a (group of) template(s), as a full standalone piece of HTML in Tempcode format.
	 * Uses sources/lorem.php functions to place appropriate stock-text. Should not hard-code things, as the code is intended to be declaritive.
	 * Assumptions: You can assume all Lang/CSS/Javascript files in this addon have been pre-required.
	 *
	 * @return array			Array of previews, each is Tempcode. Normally we have just one preview, but occasionally it is good to test templates are flexible (e.g. if they use IF_EMPTY, we can test with and without blank data).
	 */
	function tpl_preview__administrative__block_helper_done()
	{
		return array(
			lorem_globalise(
				do_lorem_template('BLOCK_HELPER_DONE',array(
					'TITLE'=>lorem_phrase(),
					'FIELD_NAME'=>placeholder_id(),
					'BLOCK'=>lorem_phrase(),
					'COMCODE_XML'=>lorem_phrase(),
					'COMCODE'=>lorem_phrase(),
					'COMCODE_SEMIHTML'=>lorem_phrase(),
						)
			),NULL,'',true),
		);
	}
}