<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2012

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		core_menus
 */

/**
 * Module page class.
 */
class Module_admin_menus
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']='Chris Graham';
		$info['organisation']='ocProducts';
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=2;
		$info['locked']=true;
		return $info;
	}
	
	/**
	 * Standard modular uninstall function.
	 */
	function uninstall()
	{
	}

	/**
	 * Standard modular install function.
	 *
	 * @param  ?integer	What version we're upgrading from (NULL: new install)
	 * @param  ?integer	What hack version we're upgrading from (NULL: new-install/not-upgrading-from-a-hacked-version)
	 */
	function install($upgrade_from=NULL,$upgrade_from_hack=NULL)
	{
		require_code('menus');

		require_all_lang();

		/* Our idealised choice of installed links is built for minimalism by assuming we also have:
			 zone menu
			 tailored menus in non-site/welcome zones
			 NO panel_top (if there is that's fine, it's just a supplementary source of navigation)
			 footer menu
			 donate/hosting/advertise linked to by banners
			 side_personal_stats/side_search/main_newsletter_signup/main_leaderboard/main_poll/main_iotd/main_news/side_news_categories/side_calendar blocks
			 implicit links to authors/awards/member-actions/onlinemembers
			
			(not all links defined here, various modules also install them)
		*/

		// root_website
		add_menu_item_simple('root_website',NULL,'FRONT_PAGE',':');
		add_menu_item_simple('root_website',NULL,'RULES','_SEARCH:rules');
		//add_menu_item_simple('root_website',NULL,'FEEDBACK','_SEARCH:feedback');
		if (!in_array(get_forum_type(),array('ocf','none'))) add_menu_item_simple('root_website',NULL,'SECTION_FORUMS',get_forum_base_url(true));

		// main_features
		add_menu_item_simple('main_features',NULL,'FRONT_PAGE','site:');
		add_menu_item_simple('main_features',NULL,'GUIDE','_SEARCH:help');
		add_menu_item_simple('main_features',NULL,'RULES','_SEARCH:rules');

		// main_content

		// main_community
		if (!in_array(get_forum_type(),array('ocf','none'))) add_menu_item_simple('main_community',NULL,'SECTION_FORUMS',get_forum_base_url(true));
		if (get_forum_type()=='ocf') add_menu_item_simple('main_community',NULL,'MEMBERS','_SEARCH:members:type=misc');
		if (get_forum_type()=='ocf') add_menu_item_simple('main_community',NULL,'USERGROUPS','_SEARCH:groups:type=misc');

		// member_features
		add_menu_item_simple('member_features',NULL,'_JOIN','_SEARCH:join:type=misc',0,1);
		add_menu_item_simple('member_features',NULL,'RESET_PASSWORD','_SEARCH:lostpassword:type=misc');

		// collab_website
		add_menu_item_simple('collab_website',NULL,'FRONT_PAGE','collaboration:');
		add_menu_item_simple('collab_website',NULL,'ABOUT','collaboration:about');

		// forum_features
		add_menu_item_simple('forum_features',NULL,'RULES','_SEARCH:rules');
		add_menu_item_simple('forum_features',NULL,'MEMBERS','_SEARCH:members:type=misc');

		// Zones
		add_menu_item_simple('zone_menu',NULL,'SITE','site'.':',0,1);
		if (get_forum_type()=='ocf')
		{
			add_menu_item_simple('zone_menu',NULL,'SECTION_FORUMS','forum'.':',0,1);
		} else
		{
			add_menu_item_simple('zone_menu',NULL,'SECTION_FORUMS',get_forum_base_url(),0,1);
		}
		if (file_exists(get_file_base().'/collaboration'))
			add_menu_item_simple('zone_menu',NULL,'COLLABORATION','collaboration'.':',0,1);
		add_menu_item_simple('zone_menu',NULL,'CMS','cms'.':',0,1);
		add_menu_item_simple('zone_menu',NULL,'ADMIN_ZONE','adminzone'.':',0,1);
		//add_menu_item_simple('zone_menu',NULL,'GUIDES','docs'.':userguide',0,1);
	}

	/**
	 * Standard modular entry-point finder function.
	 *
	 * @return ?array	A map of entry points (type-code=>language-code) (NULL: disabled).
	 */
	function get_entry_points()
	{
		return array('misc'=>'MENU_MANAGEMENT');
	}
	
	/**
	 * Standard modular run function.
	 *
	 * @return tempcode	The result of execution.
	 */
	function run()
	{
		require_javascript('javascript_menu_editor');
		require_javascript('javascript_ajax');
	
		require_code('menus');
		require_lang('menus');
		require_code('menus2');
	
		$type=get_param('type','misc');
	
		if ($type=='misc') return $this->get_menu_name();
		if ($type=='edit') return $this->edit_menu();
		if ($type=='_edit') return $this->_edit_menu();
	
		return new ocp_tempcode();
	}
	
	/**
	 * The UI to choose a menu to edit / create a new menu.
	 *
	 * @return tempcode		The UI
	 */
	function get_menu_name()
	{
		$GLOBALS['HELPER_PANEL_PIC']='pagepics/menus';
		$GLOBALS['HELPER_PANEL_TUTORIAL']='tut_menus';

		$title=get_page_title('MENU_MANAGEMENT');
	
		require_code('form_templates');
		$rows=$GLOBALS['SITE_DB']->query_select('menu_items',array('DISTINCT i_menu'),NULL,'ORDER BY i_menu');
		$list=new ocp_tempcode();//form_input_list_entry('',false,do_lang_tempcode('NA_EM'));
		foreach ($rows as $row)
		{
			$list->attach(form_input_list_entry($row['i_menu']));
		}
		$fields=new ocp_tempcode();

		$set_name='menu';
		$required=true;
		$set_title=do_lang_tempcode('MENU');
		$field_set=alternate_fields_set__start($set_name);

		$field_set->attach(form_input_list(do_lang_tempcode('EXISTING'),do_lang_tempcode('EXISTING_MENU'),'id',$list,NULL,true,false));

		$field_set->attach(form_input_codename(do_lang_tempcode('NEW'),do_lang_tempcode('NEW_MENU'),'id_new','',false));

		$fields->attach(alternate_fields_set__end($set_name,$set_title,'',$field_set,$required));

		$map=array('page'=>'_SELF','type'=>'edit','wide'=>1);
		if (get_param('redirect','!')!='!') $map['redirect']=get_param('redirect');
		$post_url=build_url($map,'_SELF',NULL,false,true);
		$submit_name=do_lang_tempcode('CHOOSE');

		return do_template('FORM_SCREEN',array('_GUID'=>'f3c04ea3fb5e429210c5e33e5a2f2092','GET'=>true,'SKIP_VALIDATION'=>true,'TITLE'=>$title,'HIDDEN'=>'','TEXT'=>do_lang_tempcode('CHOOSE_EDIT_LIST'),'FIELDS'=>$fields,'URL'=>$post_url,'SUBMIT_NAME'=>$submit_name));
	}

	/**
	 * The UI to edit a menu.
	 *
	 * @return tempcode		The UI
	 */
	function edit_menu()
	{
		if (!has_js()) warn_exit(do_lang_tempcode('MSG_JS_NEEDED'));
		
		$id=get_param('id','');
		if ($id=='') $id=get_param('id_new');
		if (substr($id,0,1)=='_') warn_exit(do_lang_tempcode('MENU_UNDERSCORE_RESERVED'));

		if (($id=='zone_menu') && (get_option('use_custom_zone_menu')=='0'))
		{
			$config_url=build_url(array('page'=>'admin_config','type'=>'category','id'=>'THEME'),get_module_zone('admin_config'));
			attach_message(do_lang_tempcode('EDITING_UNUSED_MENU',escape_html($config_url->evaluate())),'warn');
		}

		$title=get_page_title('_EDIT_MENU',true,array(escape_html($id)));

		$clickable_sections=(get_param_integer('clickable_sections',0)==1); // This is set to '1 if we have a menu type where pop out sections may be clicked on to be loaded. If we do then we make no UI distinction between page nodes and contracted/expanded, so people don't get compelled to choose a URL for everything, it simply becomes an option for them.

		// This will be a templates for branches created dynamically
		$t_id='replace_me_with_random';
		$branch=do_template('MENU_EDITOR_BRANCH',array('_GUID'=>'59d5c9bebecdac1440112ef8301d7c67','CLICKABLE_SECTIONS'=>$clickable_sections?'true':'false','I'=>$t_id,'CHILD_BRANCH_TEMPLATE'=>'','CHILD_BRANCHES'=>''));
		$child_branch_template=do_template('MENU_EDITOR_BRANCH_WRAP',array('_GUID'=>'fb16265f553127b47dfdaf33a420136b','DISPLAY'=>$clickable_sections?'display: block':'display: none','CLICKABLE_SECTIONS'=>$clickable_sections,'ORDER'=>'replace_me_with_order','PARENT'=>'replace_me_with_parent','BRANCH_TYPE'=>'0','NEW_WINDOW'=>'0','CHECK_PERMS'=>'0','CAPTION_LONG'=>'','CAPTION'=>'','URL'=>'','PAGE_ONLY'=>'','THEME_IMG_CODE'=>'','I'=>$t_id,'BRANCH'=>$branch));

		$order=0;
		$menu_items=$GLOBALS['SITE_DB']->query_select('menu_items',array('*'),array('i_menu'=>$id),'ORDER BY i_parent,i_order');
		$child_branches=$this->menu_branch($id,NULL,$order,$clickable_sections,$menu_items);

		$root_branch=do_template('MENU_EDITOR_BRANCH',array('CLICKABLE_SECTIONS'=>$clickable_sections?'true':'false','CHILD_BRANCH_TEMPLATE'=>$child_branch_template,'CHILD_BRANCHES'=>$child_branches,'I'=>''));

		$map=array('page'=>'_SELF','type'=>'_edit','id'=>$id);
		if (get_param('redirect','!')!='!') $map['redirect']=get_param('redirect');
		$post_url=build_url($map,'_SELF');

		$map=array('page'=>'_SELF','type'=>'_edit','id'=>$id); // Actually same as edit URL, just we put this into an empty post form
		if (get_param('redirect','!')!='!') $map['redirect']=get_param('redirect');
		$delete_url=build_url($map,'_SELF');

		require_code('form_templates');
		$fields_template=new ocp_tempcode();
		//$fields_template->attach(form_input_line(do_lang_tempcode('CAPTION'),do_lang_tempcode('MENU_ENTRY_CAPTION'),'caption','',true)); This is editable in the tree structure instead
		$fields_template->attach(form_input_line(do_lang_tempcode('LINK'),do_lang_tempcode('MENU_ENTRY_URL'),'url','',false));
		$options=array(
			array(do_lang_tempcode('MENU_ENTRY_NEW_WINDOW'),'new_window',false,new ocp_tempcode()),
			array(do_lang_tempcode('MENU_ENTRY_CHECK_PERMS'),'check_perms',true,do_lang_tempcode('DESCRIPTION_MENU_ENTRY_CHECK_PERMS')),
		);
		$fields_template->attach(form_input_various_ticks($options,'',NULL,do_lang_tempcode('OPTIONS'),false));
		$list=new ocp_tempcode();
		if (!$clickable_sections)
		{
			$list->attach(form_input_list_entry('page',false,do_lang_tempcode('PAGE')));
		}
		$list->attach(form_input_list_entry('branch_minus',false,do_lang_tempcode('CONTRACTED_BRANCH')));
		$list->attach(form_input_list_entry('branch_plus',false,do_lang_tempcode('EXPANDED_BRANCH')));
		$fields_template->attach(form_input_list(do_lang_tempcode('BRANCH_TYPE'),do_lang_tempcode('MENU_ENTRY_BRANCH'),'branch_type',$list));

		$fields_template->attach(do_template('FORM_SCREEN_FIELD_SPACER',array('SECTION_HIDDEN'=>true,'TITLE'=>do_lang_tempcode('ADVANCED'))));
		$fields_template->attach(form_input_line(do_lang_tempcode('CAPTION_LONG'),do_lang_tempcode('MENU_ENTRY_CAPTION_LONG'),'caption_long','',false));
		$list=new ocp_tempcode();
		$list->attach(form_input_list_entry('',false,do_lang_tempcode('NONE_EM')));
		require_code('themes2');
		$list->attach(nice_get_theme_images(NULL,NULL,false,true,'menu_items/'));
		$fields_template->attach(form_input_list(do_lang_tempcode('THEME_IMAGE'),do_lang_tempcode('DESCRIPTION_THEME_IMAGE_FOR_MENU_ITEM'),'theme_img_code',$list,NULL,false,false));
		$fields_template->attach(form_input_line(do_lang_tempcode('RESTRICT_PAGE_VISIBILITY'),do_lang_tempcode('MENU_ENTRY_MATCH_KEYS'),'match_tags','',false));

		require_javascript('javascript_ajax');
		require_javascript('javascript_more');
		require_javascript('javascript_tree_list');

		list($warning_details,$ping_url)=handle_conflict_resolution();

		breadcrumb_set_parents(array(array('_SELF:_SELF:misc',do_lang_tempcode('MENU_MANAGEMENT'))));

		$all_menus=array();
		$menu_rows=$GLOBALS['SITE_DB']->query_select('menu_items',array('DISTINCT i_menu'),NULL,'ORDER BY i_menu');
		foreach ($menu_rows as $menu_row)
		{
			if ($menu_row['i_menu']!=$id)
				$all_menus[]=$menu_row['i_menu'];
		}

		return do_template('MENU_EDITOR_SCREEN',array('_GUID'=>'d2bc26eaea38f3d5b3221be903ff541e','ALL_MENUS'=>$all_menus,'MENU_NAME'=>$id,'DELETE_URL'=>$delete_url,'PING_URL'=>$ping_url,'WARNING_DETAILS'=>$warning_details,'FIELDS_TEMPLATE'=>$fields_template,'HIGHEST_ORDER'=>strval($order),'URL'=>$post_url,'CHILD_BRANCH_TEMPLATE'=>$child_branch_template,'ROOT_BRANCH'=>$root_branch,'TITLE'=>$title));
	}

	/**
	 * Show a branch-editor of the menu editor.
	 *
	 * @param  AUTO_LINK		The ID of the branch we are displaying items for
	 * @param  integer		The parent branch holding the branch
	 * @param  integer		The order this branch has in the editor (and due to linearly moving through, the number of branches shown assembled ready)
	 * @param  boolean		Whether childed branches themselves can have URLs (etc)
	 * @param  array			All rows on the menu
	 * @return tempcode		The part of the UI
	 */
	function menu_branch($id,$branch,&$order,$clickable_sections,$menu_items)
	{
		$child_branches=new ocp_tempcode();
		foreach ($menu_items as $menu_item)
		{
			if ($menu_item['i_parent']==$branch)
			{
				$caption=get_translated_text($menu_item['i_caption']);
				$url=$menu_item['i_url'];
				$page_only=$menu_item['i_page_only'];
				$theme_img_code=$menu_item['i_theme_img_code'];
				$new_window=$menu_item['i_new_window'];
				$check_perms=$menu_item['i_check_permissions'];
				$caption_long=get_translated_text($menu_item['i_caption_long']);
				$branch_type=0;
				foreach ($menu_items as $_menu_item)
				{
					if ($_menu_item['i_parent']==$menu_item['id'])
					{
						$branch_type=($menu_item['i_expanded']==1)?2:1;
						break;
					}
				}
				if (($url=='') && ($branch_type==0)) $branch_type=1;

				$display=(($branch_type==0) && (!$clickable_sections))?'display: none':'';
				$_child_branches=$this->menu_branch($id,$menu_item['id'],$order,$clickable_sections,$menu_items);
				$_branch=do_template('MENU_EDITOR_BRANCH',array('_GUID'=>'381f5600da214b84e300bcf668f66570','CLICKABLE_SECTIONS'=>$clickable_sections?'true':'false','I'=>strval($menu_item['id']),'CHILD_BRANCHES'=>$_child_branches->evaluate()));
				$_wrap=do_template('MENU_EDITOR_BRANCH_WRAP',array('_GUID'=>'1ace7da7a1d8a18f13305eec5069e4c5','DISPLAY'=>$display,'CLICKABLE_SECTIONS'=>$clickable_sections,'ORDER'=>strval($order),'PARENT'=>is_null($branch)?'':strval($branch),'BRANCH_TYPE'=>strval($branch_type),'NEW_WINDOW'=>strval($new_window),'CHECK_PERMS'=>strval($check_perms),'CAPTION'=>$caption,'CAPTION_LONG'=>$caption_long,'URL'=>$url,'PAGE_ONLY'=>$page_only,'THEME_IMG_CODE'=>$theme_img_code,'I'=>strval($menu_item['id']),'BRANCH'=>$_branch));
				$child_branches->attach($_wrap);
				$order++;
			}
		}

		return $child_branches;
	}

	/**
	 * The actualiser to edit a menu.
	 *
	 * @return tempcode		The UI
	 */
	function _edit_menu()
	{
		$title=get_page_title('_EDIT_MENU',true,array(escape_html(get_param('id'))));

		post_param_integer('confirm'); // Just to make sure hackers don't try and get people to erase this form via a URL

		$menu_id=get_param('id');

		// Find what we have on the menu first
		$ids=array();
		foreach ($_POST as $key=>$val)
		{
			if (is_string($val))
			{
				if (substr($key,0,7)=='parent_') $ids[intval(substr($key,7))]=$val;
			}
		}

		/*// Order
		$orderings=array();
		$ids_copy=$ids;
		while (count($ids_copy)!=0)
		{
			$best_value=0; // to initialise to integer type
			$best_value=NULL;
			$best_id=NULL;
			foreach ($ids_copy as $id=>$parent)
			{
				$value=post_param_integer('order_'.strval($id));
				if ((is_null($best_id)) || ($value<$best_value))
				{
					$best_id=$id;
					$best_value=$value;
				}
			}
			$orderings[]=$best_id;
			unset($ids_copy[$best_id]);
		}*/
		$orderings=array_keys($ids);

		// Get language codes currently used
		$old_menu_bits=list_to_map('id',$GLOBALS['SITE_DB']->query_select('menu_items',array('id','i_caption','i_caption_long'),array('i_menu'=>$menu_id)));
	
		// Now, process everything on the root
		$order=0;
		foreach ($orderings as $id)
		{
			$parent=$ids[$id];
	
			if ($parent=='')
			{
				$this->add_menu_item($menu_id,$id,$ids,NULL,$old_menu_bits,$order);
				$order++;
			}
		}
	
		// Erase old stuff
		foreach ($old_menu_bits as $menu_item_id=>$lang_code)
		{
			$GLOBALS['SITE_DB']->query_delete('menu_items',array('id'=>$menu_item_id));
			delete_lang($lang_code['i_caption']);
			delete_lang($lang_code['i_caption_long']);
		}
	
		decache('side_stored_menu');
		persistant_cache_delete(array('MENU',$menu_id));

		log_it((count($_POST)==1)?'DELETE_MENU':'EDIT_MENU',$menu_id);

		// Go back to editing the menu
		$url=get_param('redirect','!');
		if ($url=='!')
		{
			if (count($_POST)==1)
			{
				$_url=build_url(array('page'=>'_SELF','type'=>'misc'),'_SELF');
			} else
			{
				$_url=build_url(array('page'=>'_SELF','type'=>'edit','wide'=>1,'id'=>$menu_id),'_SELF');
			}
			$url=$_url->evaluate();
		}
		return redirect_screen($title,$url,do_lang_tempcode('SUCCESS'));
	}

	/**
	 * Add a menu item from details in POST.
	 *
	 * @param  ID_TEXT		The name of the menu the item is on
	 * @param  integer		The ID of the menu item (i.e. what it is referenced as in POST)
	 * @param  array			The map of IDs on the menu (ID=>parent)
	 * @param  ?integer		The ID of the parent branch (NULL: no parent)
	 * @param  array			The map of menu id=>string language IDs employed by items before the edit
	 * @param  integer		The order this branch has in the editor (and due to linearly moving through, the number of branches shown assembled ready)
	 */
	function add_menu_item($menu,$id,&$ids,$parent,&$old_menu_bits,&$order)
	{
		// Load in details of menu item
		$caption=post_param('caption_'.strval($id),''); // Default needed to workaround Opera problem
		$caption_long=post_param('caption_long_'.strval($id),''); // Default needed to workaround Opera problem
		$page_only=post_param('match_tags_'.strval($id),''); // Default needed to workaround Opera problem
		$theme_img_code=post_param('theme_img_code_'.strval($id),''); // Default needed to workaround Opera problem
		$check_permissions=post_param_integer('check_perms_'.strval($id),0);
		$branch_type=post_param('branch_type_'.strval($id),'branch_plus'); // Default needed to workaround Opera problem
		if ($branch_type=='branch_plus') $expanded=1; else $expanded=0;
		$new_window=post_param_integer('new_window_'.strval($id),0);
/*		if ($branch_type=='page')
		{*/
			$url=post_param('url_'.strval($id),'');

			// See if we can tidy it back to a page-link
			if (preg_match('#^\w+$#',$url)!=0) $url=':'.$url; // So users do not have to think about zones
			$page_link=url_to_pagelink($url,true);
			if ($page_link!='')
			{
				$url=$page_link;
			} elseif (strpos($url,':')===false)
			{
				$url=fixup_protocolless_urls($url);
			}
//		} else $url='';
	
		$menu_save_map=array(
			'i_menu'=>$menu,
			'i_order'=>$order,
			'i_parent'=>$parent,
			'i_url'=>$url,
			'i_check_permissions'=>$check_permissions,
			'i_expanded'=>$expanded,
			'i_new_window'=>$new_window,
			'i_page_only'=>$page_only,
			'i_theme_img_code'=>$theme_img_code
		);
	
		// Save
		if (array_key_exists($id,$old_menu_bits))
		{
			$lang_code=$old_menu_bits[$id]['i_caption'];
			$lang_code_2=$old_menu_bits[$id]['i_caption_long'];
			$menu_save_map+=array(
				'i_caption'=>$lang_code,
				'i_caption_long'=>$lang_code_2,
			);
			unset($old_menu_bits[$id]);
			$insert_id=$id;
			$GLOBALS['SITE_DB']->query_update('menu_items',$menu_save_map,array('id'=>$id));
			
			lang_remap($lang_code,$caption);
			lang_remap($lang_code_2,$caption_long);
		} else
		{
			$lang_code=insert_lang($caption,1);
			$lang_code_2=insert_lang($caption_long,1);
			$menu_save_map+=array(
				'i_caption'=>$lang_code,
				'i_caption_long'=>$lang_code_2,
			);
			$insert_id=$GLOBALS['SITE_DB']->query_insert('menu_items',$menu_save_map,true);
		}

		// Menu item children
		$my_kids=array();
		foreach ($ids as $new_id=>$child_parent)
		{
			if (strval($id)==$child_parent) $my_kids[]=$new_id;
		}

		foreach ($my_kids as $new_id)
		{
			$this->add_menu_item($menu,$new_id,$ids,$insert_id,$old_menu_bits,$order);
			$order++;
		}
	}

}


